<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wrap wseo-admin-wrap">
    <h1>Presmerovania</h1>
    
    <!-- Tab Navigation -->
    <h2 class="nav-tab-wrapper">
        <a href="#redirects" class="nav-tab nav-tab-active" data-tab="redirects">Existujúce presmerovania</a>
        <a href="#errors-404" class="nav-tab" data-tab="errors-404">404 Chyby</a>
    </h2>
    
    <!-- Tab Content: Existujúce presmerovania -->
    <div id="tab-redirects" class="wseo-tab-content active">
    
    <div class="wseo-admin-card">
        <h2>Pridať nové presmerovanie</h2>
        
        <form method="post">
            <?php wp_nonce_field('wseo_redirects_settings'); ?>
            
            <table class="form-table">
                <tr>
                    <th>Pôvodná URL</th>
                    <td>
                        <input type="text" name="wseo_redirect_from" class="regular-text" placeholder="/stara-stranka/" required>
                        <p class="description">
                            Zadajte cestu bez domény. Príklady:<br>
                            <code>/stara-stranka/</code> - presná zhoda<br>
                            <code>/stary-adresar/*</code> - všetko čo začína na /stary-adresar/<br>
                            <code>^/produkt/([0-9]+)/?$</code> - regex pattern
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>Nová URL</th>
                    <td>
                        <input type="url" name="wseo_redirect_to" class="regular-text" placeholder="https://example.com/nova-stranka/" required>
                        <p class="description">
                            Zadajte plnú URL vrátane https://. Pri regex môžete použiť $1, $2 pre zachytené skupiny.
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>Typ presmerovania</th>
                    <td>
                        <select name="wseo_redirect_type">
                            <option value="301">301 - Trvalé presmerovanie (odporúčané)</option>
                            <option value="302">302 - Dočasné presmerovanie</option>
                            <option value="307">307 - Dočasné presmerovanie (zachová metódu)</option>
                            <option value="308">308 - Trvalé presmerovanie (zachová metódu)</option>
                        </select>
                        <p class="description">
                            <strong>301</strong> - Pre trvalé zmeny URL. Google prenesie SEO hodnotu.<br>
                            <strong>302</strong> - Pre dočasné zmeny. Google neprenesie SEO hodnotu.
                        </p>
                    </td>
                </tr>
            </table>
            
            <p>
                <button type="submit" name="wseo_add_redirect" class="button button-primary">
                    <span class="dashicons dashicons-plus-alt" style="margin-top: 4px;"></span>
                    Pridať presmerovanie
                </button>
            </p>
        </form>
    </div>
    
    <div class="wseo-admin-card">
        <h2>Existujúce presmerovania</h2>
        
        <?php
        $redirects = get_option('wseo_redirects', array());
        
        if (empty($redirects)):
        ?>
            <p style="color: #646970; padding: 20px 0;">
                <span class="dashicons dashicons-info" style="color: #2271b1;"></span>
                Zatiaľ nemáte žiadne presmerovania. Pridajte prvé pomocou formulára vyššie.
            </p>
        <?php else: ?>
            <style>
            .wseo-redirects-table {
                width: 100%;
                border-collapse: collapse;
            }
            .wseo-redirects-table th,
            .wseo-redirects-table td {
                padding: 12px;
                text-align: left;
                border-bottom: 1px solid #e2e4e7;
            }
            .wseo-redirects-table th {
                background: #f9f9f9;
                font-weight: 600;
            }
            .wseo-redirects-table tr:hover {
                background: #f9f9f9;
            }
            .wseo-redirect-url {
                font-family: monospace;
                font-size: 12px;
                background: #f0f0f1;
                padding: 4px 8px;
                border-radius: 3px;
                word-break: break-all;
            }
            .wseo-redirect-type {
                display: inline-block;
                padding: 2px 8px;
                border-radius: 3px;
                font-size: 12px;
                font-weight: 600;
            }
            .wseo-redirect-type-301 { background: #edfaef; color: #0a5c1a; }
            .wseo-redirect-type-302 { background: #fef8e7; color: #94660c; }
            .wseo-redirect-type-307 { background: #f0f6fc; color: #2271b1; }
            .wseo-redirect-type-308 { background: #edfaef; color: #0a5c1a; }
            .wseo-redirect-hits {
                font-size: 12px;
                color: #646970;
            }
            .wseo-redirect-arrow {
                color: #646970;
                font-size: 16px;
            }
            </style>
            
            <table class="wseo-redirects-table">
                <thead>
                    <tr>
                        <th style="width: 35%;">Z (pôvodná URL)</th>
                        <th style="width: 5%;"></th>
                        <th style="width: 35%;">Na (nová URL)</th>
                        <th style="width: 8%;">Typ</th>
                        <th style="width: 10%;">Použití</th>
                        <th style="width: 7%;">Akcia</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($redirects as $index => $redirect): ?>
                    <tr>
                        <td>
                            <span class="wseo-redirect-url"><?php echo esc_html($redirect['from']); ?></span>
                        </td>
                        <td class="wseo-redirect-arrow">→</td>
                        <td>
                            <span class="wseo-redirect-url"><?php echo esc_html($redirect['to']); ?></span>
                        </td>
                        <td>
                            <span class="wseo-redirect-type wseo-redirect-type-<?php echo esc_attr($redirect['type']); ?>">
                                <?php echo esc_html($redirect['type']); ?>
                            </span>
                        </td>
                        <td>
                            <span class="wseo-redirect-hits">
                                <?php echo isset($redirect['hits']) ? intval($redirect['hits']) : 0; ?>×
                                <?php if (isset($redirect['last_hit'])): ?>
                                    <br><small>Posledné: <?php echo date('d.m.Y', strtotime($redirect['last_hit'])); ?></small>
                                <?php endif; ?>
                            </span>
                        </td>
                        <td>
                            <form method="post" style="display: inline;" onsubmit="return confirm('Naozaj chcete zmazať toto presmerovanie?');">
                                <?php wp_nonce_field('wseo_redirects_settings'); ?>
                                <button type="submit" name="wseo_delete_redirect" value="<?php echo $index; ?>" class="button button-small" title="Zmazať">
                                    <span class="dashicons dashicons-trash" style="margin-top: 3px;"></span>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <p style="margin-top: 15px; color: #646970; font-size: 12px;">
                <span class="dashicons dashicons-info"></span>
                Celkom <?php echo count($redirects); ?> presmerovaní
            </p>
        <?php endif; ?>
    </div>
    
    <div class="wseo-admin-card">
        <h2>💡 Tipy pre presmerovania</h2>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            <div>
                <h4 style="margin-top: 0;">Kedy použiť 301?</h4>
                <ul style="margin: 0; padding-left: 20px; color: #646970;">
                    <li>Stránka sa trvalo presunula na novú URL</li>
                    <li>Pri redesigne webu</li>
                    <li>Pri zmene štruktúry URL</li>
                    <li>Pri zlúčení duplicitného obsahu</li>
                </ul>
            </div>
            <div>
                <h4 style="margin-top: 0;">Kedy použiť 302?</h4>
                <ul style="margin: 0; padding-left: 20px; color: #646970;">
                    <li>Stránka je dočasne nedostupná</li>
                    <li>A/B testovanie</li>
                    <li>Geografické presmerovanie</li>
                    <li>Presmerovanie na údržbu</li>
                </ul>
            </div>
            <div>
                <h4 style="margin-top: 0;">Príklady použitia</h4>
                <ul style="margin: 0; padding-left: 20px; color: #646970;">
                    <li><code>/blog/*</code> → presmeruje /blog/cokolvek/</li>
                    <li><code>^/p/([0-9]+)$</code> → regex pre /p/123</li>
                    <li><code>/stary-clanok/</code> → presná zhoda</li>
                </ul>
            </div>
        </div>
    </div>
    
    <div class="wseo-admin-card">
        <h2>📥 Import / Export</h2>
        
        <p>
            <strong>Export:</strong> Skopírujte tento JSON pre zálohu presmerovaní:
        </p>
        <textarea readonly style="width: 100%; height: 100px; font-family: monospace; font-size: 11px;"><?php echo json_encode($redirects, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?></textarea>
    </div>
    
    </div><!-- End Tab: Existujúce presmerovania -->
    
    <!-- Tab Content: 404 Chyby -->
    <div id="tab-errors-404" class="wseo-tab-content" style="display: none;">
    
    <!-- AUTO-REDIRECT SETTINGS (v2.8.6 SIMPLIFIED) -->
    <div class="wseo-admin-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #fff; margin-bottom: 20px;">
        <h2 style="color: #fff;">⚡ Auto-Redirect 404 na podobný obsah</h2>
        <p style="color: rgba(255,255,255,0.9);">Automaticky presmeruj zo 404 chýb na najlepší podobný článok/stránku.</p>
        
        <form method="post" style="background: rgba(255,255,255,0.1); padding: 20px; border-radius: 8px;">
            <?php wp_nonce_field('wseo_redirects_settings'); ?>
            
            <table class="form-table" style="margin: 0;">
                <tr>
                    <th style="color: #fff; width: 200px;">Režim</th>
                    <td>
                        <?php $auto_redirect = get_option('wseo_auto_redirect_404', 'disabled'); ?>
                        <select name="wseo_auto_redirect_404" style="min-width: 250px;">
                            <option value="disabled" <?php selected($auto_redirect, 'disabled'); ?>>❌ Vypnuté</option>
                            <option value="aggressive" <?php selected($auto_redirect, 'aggressive'); ?>>🔥 Agresívne (50%+ zhoda)</option>
                            <option value="moderate" <?php selected($auto_redirect, 'moderate'); ?>>✅ Moderate (65%+ zhoda)</option>
                            <option value="conservative" <?php selected($auto_redirect, 'conservative'); ?>>🛡️ Konzervatívne (80%+ zhoda)</option>
                        </select>
                        <p class="description" style="color: rgba(255,255,255,0.8);">
                            <strong>Agresívne (50%):</strong> Presmeruje ak je aspoň polovica slov rovnaká<br>
                            <strong>Moderate (65%):</strong> Väčšina slov musí sedieť (odporúčané)<br>
                            <strong>Konzervatívne (80%):</strong> Takmer presná zhoda
                        </p>
                    </td>
                </tr>
                <tr>
                    <th style="color: #fff; width: 200px;">Synonymá</th>
                    <td>
                        <?php $synonyms = get_option('wseo_404_synonyms', ''); ?>
                        <textarea name="wseo_404_synonyms" rows="8" style="width: 100%; max-width: 600px; font-family: monospace; font-size: 13px;" placeholder="webstranky = webstránky, stranky, web&#10;tvorba = vytváranie, vytvorenie&#10;servis = oprava, údržba&#10;prstene = prstienky, snubne&#10;zlato = zlaté, zlata"><?php echo esc_textarea($synonyms); ?></textarea>
                        <p class="description" style="color: rgba(255,255,255,0.8);">
                            Každý riadok: <code>kľúčové_slovo = synonym1, synonym2, synonym3</code><br>
                            Príklad: <code>webstranky = webstránky, stranky, web</code><br>
                            <strong>Pre webstudio.ltd:</strong> webstranky, tvorba, servis, eshop<br>
                            <strong>Pre šperkárstvo:</strong> prstene, snubne, zlato, striebro, diamanty
                        </p>
                    </td>
                </tr>
            </table>
            
            <p style="margin-top: 15px;">
                <button type="submit" name="wseo_save_auto_redirect" class="button button-primary button-large">
                    💾 Uložiť
                </button>
            </p>
        </form>
    </div>
    
    <div class="wseo-admin-card">
        <h2>🚫 404 Chyby</h2>
        <p class="description">Automaticky sledované 404 chyby. Kliknite na "Vytvoriť presmerovanie" pre vytvorenie presmerovania.</p>
        
        <?php
        $logs_404 = get_option('wseo_404_logs', array());
        // Limit to first 20 for performance
        $logs_404 = array_slice($logs_404, 0, 20);
        ?>
        
        <?php if (!empty($logs_404)): ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>URL</th>
                    <th width="80">Počet</th>
                    <th width="250">Návrh</th>
                    <th width="300">Akcia</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($logs_404 as $index => $log): ?>
                <?php 
                $suggestions = Webstudio_SEO_Pro::get_instance()->suggest_redirects_for_404($log['url']);
                $best_suggestion = !empty($suggestions) ? $suggestions[0] : null;
                
                // Store all suggestions in data attribute for refresh
                $suggestions_json = !empty($suggestions) ? json_encode($suggestions) : '[]';
                ?>
                <tr data-url="<?php echo esc_attr($log['url']); ?>" data-suggestions='<?php echo esc_attr($suggestions_json); ?>' data-current-index="0">
                    <td>
                        <code style="background: #ffe0e0; padding: 2px 6px;"><?php echo esc_html($log['url']); ?></code>
                        <?php if (!empty($log['referers'])): ?>
                        <br><small style="color: #666;">Referer: <?php echo esc_html($log['referers'][0]); ?></small>
                        <?php endif; ?>
                    </td>
                    <td><strong style="color: #d63638;"><?php echo $log['count']; ?>×</strong></td>
                    <td class="wseo-suggestion-cell">
                        <?php if ($best_suggestion): ?>
                        <a href="<?php echo esc_url($best_suggestion['url']); ?>" target="_blank" style="text-decoration: none;" class="wseo-suggestion-link">
                            <?php echo esc_html(wp_trim_words($best_suggestion['title'], 5)); ?>
                        </a>
                        <br><small style="color: #666;" class="wseo-suggestion-percent"><?php echo $best_suggestion['similarity']; ?>% zhoda</small>
                        <?php else: ?>
                        <span style="color: #999;" class="wseo-no-suggestion">—</span>
                        <?php endif; ?>
                    </td>
                    <td class="wseo-action-cell">
                        <?php if ($best_suggestion && $best_suggestion['similarity'] >= 30): ?>
                            <!-- Automatický redirect na aktuálny návrh (30%+) -->
                            <form method="post" style="display: inline;" class="wseo-redirect-form">
                                <?php wp_nonce_field('wseo_redirects_settings'); ?>
                                <input type="hidden" name="wseo_redirect_from" value="<?php echo esc_attr($log['url']); ?>">
                                <input type="hidden" name="wseo_redirect_to" value="<?php echo esc_attr($best_suggestion['url']); ?>" class="wseo-redirect-to">
                                <input type="hidden" name="wseo_redirect_type" value="301">
                                <input type="hidden" name="wseo_add_redirect" value="1">
                                <input type="hidden" name="wseo_clear_404" value="<?php echo esc_attr($log['url']); ?>">
                                <button type="submit" class="button button-small button-primary wseo-redirect-btn" title="Presmerovať na: <?php echo esc_attr($best_suggestion['title']); ?> (<?php echo $best_suggestion['similarity']; ?>% zhoda)">
                                    Presmerovať
                                </button>
                            </form>
                        <?php else: ?>
                            <!-- Žiadna zhoda -->
                            <button type="button" class="button button-small wseo-redirect-btn" disabled title="Žiadny podobný príspevok">
                                Presmerovať
                            </button>
                        <?php endif; ?>
                        
                        <!-- Refresh - VŽDY prítomné -->
                        <button type="button" class="button button-small wseo-refresh-suggestion" style="margin-left: 5px;" title="Vyhľadať podobné (aj pod 60%)">
                            Refresh
                        </button>
                        
                        <!-- Ignorovať -->
                        <button type="button" class="button button-small wseo-ignore-404" data-url="<?php echo esc_attr($log['url']); ?>" style="margin-left: 5px;">
                            Ignorovať
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <p style="margin-top: 15px;">
            <form method="post" style="display: inline;">
                <?php wp_nonce_field('wseo_redirects_settings'); ?>
                <input type="hidden" name="wseo_clear_all_404" value="1">
                <button type="submit" class="button" onclick="return confirm('Naozaj chcete vymazať všetky 404 logy?');">
                    🗑️ Vymazať všetky 404 logy
                </button>
            </form>
        </p>
        
        <script>
        jQuery(document).ready(function($) {
            // Refresh suggestion - zobraz ďalší návrh
            $('.wseo-refresh-suggestion').on('click', function() {
                var $btn = $(this);
                var $row = $btn.closest('tr');
                var suggestions = JSON.parse($row.attr('data-suggestions'));
                var currentIndex = parseInt($row.attr('data-current-index'));
                
                // Preskoč na ďalší návrh
                var nextIndex = currentIndex + 1;
                
                // Ak sme na konci, vráť sa na začiatok
                if (nextIndex >= suggestions.length) {
                    nextIndex = 0;
                }
                
                var nextSuggestion = suggestions[nextIndex];
                
                // Update UI
                if (nextSuggestion) {
                    var $cell = $row.find('.wseo-suggestion-cell');
                    var titleShort = nextSuggestion.title.split(' ').slice(0, 5).join(' ');
                    
                    $cell.html(
                        '<a href="' + nextSuggestion.url + '" target="_blank" style="text-decoration: none;" class="wseo-suggestion-link">' +
                        titleShort +
                        '</a>' +
                        '<br><small style="color: #666;" class="wseo-suggestion-percent">' + nextSuggestion.similarity + '% zhoda</small>'
                    );
                    
                    // Update hidden input
                    $row.find('.wseo-redirect-to').val(nextSuggestion.url);
                    
                    // Update button title
                    $row.find('.wseo-redirect-btn').attr('title', 'Presmerovať na: ' + nextSuggestion.title + ' (' + nextSuggestion.similarity + '% zhoda)');
                    
                    // Enable/disable redirect button based on similarity (30%+)
                    if (nextSuggestion.similarity >= 30) {
                        $row.find('.wseo-redirect-btn').prop('disabled', false).removeClass('button').addClass('button button-primary');
                    } else {
                        $row.find('.wseo-redirect-btn').prop('disabled', true).removeClass('button-primary');
                    }
                    
                    // Update current index
                    $row.attr('data-current-index', nextIndex);
                    
                    // Visual feedback
                    $cell.css('background', '#fff9e6');
                    setTimeout(function() {
                        $cell.css('background', '');
                    }, 500);
                }
            });
            
            // Ignore 404
            $('.wseo-ignore-404').on('click', function() {
                var $btn = $(this);
                var url = $btn.data('url');
                
                if (!confirm('Ignorovať túto URL? Nebude sa už zobrazovať v zozname 404 chýb.')) {
                    return;
                }
                
                $btn.prop('disabled', true).text('Ignorujem...');
                
                $.ajax({
                    url: ajaxurl,
                    method: 'POST',
                    data: {
                        action: 'wseo_ignore_404',
                        nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>',
                        url: url
                    },
                    success: function(response) {
                        if (response.success) {
                            $btn.closest('tr').fadeOut(300, function() {
                                $(this).remove();
                            });
                        } else {
                            alert('Chyba: ' + (response.data || 'Neznáma chyba'));
                            $btn.prop('disabled', false).text('Ignorovať');
                        }
                    },
                    error: function() {
                        alert('Chyba pri komunikácii so serverom');
                        $btn.prop('disabled', false).text('Ignorovať');
                    }
                });
            });
        });
        </script>
        <?php else: ?>
        <p style="color: #666; padding: 20px; background: #f9f9f9; text-align: center;">
            ✅ Zatiaľ neboli zaznamenané žiadne 404 chyby.
        </p>
        <?php endif; ?>
    </div>
    
    </div><!-- End Tab: 404 Chyby -->
    
    <!-- Tab Switching JavaScript -->
    <script>
    jQuery(document).ready(function($) {
        // Tab switching
        $('.nav-tab').on('click', function(e) {
            e.preventDefault();
            
            var tab = $(this).data('tab');
            
            // Update nav tabs
            $('.nav-tab').removeClass('nav-tab-active');
            $(this).addClass('nav-tab-active');
            
            // Update content
            $('.wseo-tab-content').removeClass('active').hide();
            $('#tab-' + tab).addClass('active').show();
            
            // Update URL hash without page jump
            history.replaceState(null, null, '#' + tab);
        });
        
        // Handle initial hash on page load
        if (window.location.hash) {
            var hash = window.location.hash.substring(1);
            var $tab = $('.nav-tab[data-tab="' + hash + '"]');
            if ($tab.length) {
                $tab.trigger('click');
            }
        }
    });
    </script>
    
    <style>
    .wseo-tab-content {
        margin-top: 20px;
    }
    .wseo-tab-content.active {
        display: block;
    }
    </style>
</div>
