<?php
/**
 * License Activation Page
 * 
 * @package WebStudio_SEO_Pro
 * @version 2.8.12
 */

if (!defined('ABSPATH')) exit;

// Get license instance
$license = new WSEO_License();
$license_info = $license->get_info();

$license_key = get_option('wseo_license_key');
$has_license = $license_info['has_license'];
$trial_days = $license_info['trial_days_remaining'];
$first_activation = $license_info['first_activation'];

// Show success message after manual check (v2.8.12)
if (isset($_GET['checked'])) {
    echo '<div class="notice notice-success is-dismissible"><p>✅ Licencia bola úspešne skontrolovaná!</p></div>';
}

// Handle form submission
if (isset($_POST['wseo_activate']) && check_admin_referer('wseo_activate_license')) {
    $new_key = sanitize_text_field($_POST['wseo_license_key']);
    update_option('wseo_license_key', $new_key);
    delete_transient('wseo_license_valid'); // Force recheck
    
    echo '<div class="notice notice-success is-dismissible"><p>✅ Licencia uložená. Kontrolujem platnosť...</p></div>';
    echo '<script>setTimeout(function(){ location.reload(); }, 2000);</script>';
}

if (isset($_POST['wseo_deactivate']) && check_admin_referer('wseo_deactivate_license')) {
    delete_option('wseo_license_key');
    delete_transient('wseo_license_valid');
    
    echo '<div class="notice notice-success is-dismissible"><p>✅ Licencia deaktivovaná</p></div>';
    echo '<script>setTimeout(function(){ location.reload(); }, 1500);</script>';
}
?>

<div class="wrap">
    <h1>🔐 WebStudio SEO Pro - Licencia</h1>
    
    <div class="wseo-admin-wrap">
        
        <?php if ($has_license): ?>
            <!-- ═══════════════════════════════════════════════ -->
            <!-- VALID LICENSE -->
            <!-- ═══════════════════════════════════════════════ -->
            
            <div class="wseo-admin-card">
                <div style="background: #d1f0e1; border-left: 4px solid #00a32a; padding: 20px; margin: 0 0 30px 0; border-radius: 4px;">
                    <h2 style="margin: 0 0 10px 0; color: #00a32a;">✅ Licencia je aktívna</h2>
                    <p style="margin: 0; font-size: 16px;">Plugin je plne funkčný a licencovaný pre túto doménu.</p>
                </div>
                
                <table class="form-table" style="margin-top: 0;">
                    <tr>
                        <th style="width: 200px;">Licenčný kľúč</th>
                        <td>
                            <code style="font-size: 14px; padding: 8px 12px; background: #f0f0f1; border-radius: 4px; display: inline-block;">
                                <?php echo esc_html($license_key); ?>
                            </code>
                        </td>
                    </tr>
                    <tr>
                        <th>Doména</th>
                        <td>
                            <strong style="font-size: 16px;"><?php echo esc_html($_SERVER['HTTP_HOST']); ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td>
                            <span style="color: #00a32a; font-weight: bold; font-size: 16px;">✅ Aktívna</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Platí do</th>
                        <td>
                            <?php 
                            $expires = get_option('wseo_license_expires');
                            if ($expires) {
                                $days_left = (strtotime($expires) - time()) / DAY_IN_SECONDS;
                                echo '<strong style="font-size: 16px;">' . date('d.m.Y', strtotime($expires)) . '</strong>';
                                echo ' <span style="color: #666;">(' . round($days_left) . ' dní)</span>';
                                
                                if ($days_left <= 30) {
                                    echo '<br><span style="color: #dba617;">⚠️ Licencia čoskoro vyprší!</span>';
                                }
                            } else {
                                echo 'N/A';
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <th>Posledná kontrola</th>
                        <td>
                            <?php 
                            $last_check = get_option('wseo_license_last_check', 0);
                            if ($last_check) {
                                echo human_time_diff($last_check) . ' ago';
                            } else {
                                echo 'Nikdy';
                            }
                            ?>
                        </td>
                    </tr>
                </table>
                
                <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd;">
                    <form method="post" action="" style="display: inline-block; margin-right: 10px;">
                        <?php wp_nonce_field('wseo_check_license'); ?>
                        <button type="submit" name="wseo_check_license" class="button button-primary">
                            🔄 Skontrolovať licenciu
                        </button>
                    </form>
                    
                    <form method="post" action="" style="display: inline-block;">
                        <?php wp_nonce_field('wseo_deactivate_license'); ?>
                        <button type="submit" name="wseo_deactivate" class="button" 
                                onclick="return confirm('Naozaj chcete deaktivovať licenciu? Plugin prestane fungovať.')">
                            🔒 Deaktivovať licenciu
                        </button>
                    </form>
                    
                    <p style="margin-top: 15px; color: #666;">
                        Pre predĺženie alebo zmenu licencie kontaktujte 
                        <a href="mailto:support@webstudio.ltd">support@webstudio.ltd</a>
                    </p>
                </div>
            </div>
            
        <?php elseif ($trial_days > 0): ?>
            <!-- ═══════════════════════════════════════════════ -->
            <!-- TRIAL ACTIVE -->
            <!-- ═══════════════════════════════════════════════ -->
            
            <div class="wseo-admin-card">
                <div style="background: #fff3cd; border-left: 4px solid #dba617; padding: 20px; margin: 0 0 30px 0; border-radius: 4px;">
                    <h2 style="margin: 0 0 10px 0; color: #9a6700;">⏰ Skúšobná verzia</h2>
                    <p style="margin: 0; font-size: 16px;">Plugin funguje v skúšobnom režime so všetkými funkciami.</p>
                </div>
                
                <table class="form-table" style="margin-top: 0;">
                    <tr>
                        <th style="width: 200px;">Status</th>
                        <td>
                            <span style="color: #dba617; font-weight: bold; font-size: 16px;">⏰ Skúšobná verzia</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Aktivovaná</th>
                        <td>
                            <strong><?php echo date('d.m.Y H:i', $first_activation); ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <th>Zostáva</th>
                        <td>
                            <strong style="font-size: 24px; color: <?php echo $trial_days <= 3 ? '#d63638' : '#dba617'; ?>;">
                                <?php echo $trial_days; ?> dní
                            </strong>
                        </td>
                    </tr>
                    <tr>
                        <th>Vyprší</th>
                        <td>
                            <?php 
                            $trial_end = $first_activation + (14 * DAY_IN_SECONDS);
                            echo '<strong>' . date('d.m.Y H:i', $trial_end) . '</strong>';
                            ?>
                        </td>
                    </tr>
                </table>
                
                <div style="background: #e7f3ff; border-left: 4px solid #0073aa; padding: 20px; margin: 30px 0; border-radius: 4px;">
                    <h3 style="margin: 0 0 15px 0; color: #0073aa;">💡 Aktivujte plnú verziu</h3>
                    <p style="margin: 0 0 20px 0;">
                        Pre neobmedzené používanie a prístup k aktualizáciám zadajte licenčný kľúč:
                    </p>
                    
                    <form method="post" action="">
                        <?php wp_nonce_field('wseo_activate_license'); ?>
                        
                        <table class="form-table" style="margin: 0;">
                            <tr>
                                <th style="width: 200px; padding-left: 0;">
                                    <label for="wseo_license_key">Licenčný kľúč</label>
                                </th>
                                <td style="padding-left: 0;">
                                    <input type="text" id="wseo_license_key" name="wseo_license_key" 
                                           class="regular-text" 
                                           placeholder="WSEO-XXXX-XXXX-XXXX"
                                           style="font-family: monospace; font-size: 14px;"
                                           value="<?php echo esc_attr($license_key); ?>">
                                    <p class="description">
                                        Nemáte licenciu? Kontaktujte 
                                        <a href="mailto:support@webstudio.ltd">support@webstudio.ltd</a>
                                    </p>
                                </td>
                            </tr>
                        </table>
                        
                        <p style="margin-top: 20px;">
                            <button type="submit" name="wseo_activate" class="button button-primary button-large">
                                🔓 Aktivovať licenciu
                            </button>
                        </p>
                    </form>
                </div>
                
                <?php if ($trial_days <= 3): ?>
                    <div style="background: #f8d7da; border-left: 4px solid #d63638; padding: 20px; border-radius: 4px;">
                        <p style="margin: 0; color: #842029;">
                            <strong>⚠️ Upozornenie:</strong> Skúšobná verzia čoskoro vyprší! 
                            Zadajte licenčný kľúč aby plugin neprestal fungovať.
                        </p>
                    </div>
                <?php endif; ?>
            </div>
            
        <?php else: ?>
            <!-- ═══════════════════════════════════════════════ -->
            <!-- TRIAL EXPIRED -->
            <!-- ═══════════════════════════════════════════════ -->
            
            <div class="wseo-admin-card">
                <div style="background: #f8d7da; border-left: 4px solid #d63638; padding: 20px; margin: 0 0 30px 0; border-radius: 4px;">
                    <h2 style="margin: 0 0 10px 0; color: #842029;">❌ Skúšobná verzia vypršala</h2>
                    <p style="margin: 0; font-size: 16px;">
                        Plugin je deaktivovaný. Pre pokračovanie zadajte platný licenčný kľúč.
                    </p>
                </div>
                
                <table class="form-table" style="margin: 0 0 30px 0;">
                    <tr>
                        <th style="width: 200px;">Status</th>
                        <td>
                            <span style="color: #d63638; font-weight: bold; font-size: 16px;">❌ Vypršaná</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Aktivovaná</th>
                        <td>
                            <strong><?php echo date('d.m.Y H:i', $first_activation); ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <th>Vypršala</th>
                        <td>
                            <?php 
                            $trial_end = $first_activation + (14 * DAY_IN_SECONDS);
                            echo '<strong>' . date('d.m.Y H:i', $trial_end) . '</strong>';
                            $days_ago = round((time() - $trial_end) / DAY_IN_SECONDS);
                            echo ' <span style="color: #666;">(pred ' . $days_ago . ' dňami)</span>';
                            ?>
                        </td>
                    </tr>
                </table>
                
                <form method="post" action="">
                    <?php wp_nonce_field('wseo_activate_license'); ?>
                    
                    <table class="form-table">
                        <tr>
                            <th style="width: 200px;">
                                <label for="wseo_license_key">Licenčný kľúč *</label>
                            </th>
                            <td>
                                <input type="text" id="wseo_license_key" name="wseo_license_key" 
                                       class="regular-text" 
                                       placeholder="WSEO-XXXX-XXXX-XXXX"
                                       style="font-family: monospace; font-size: 14px;"
                                       value="<?php echo esc_attr($license_key); ?>"
                                       required>
                                <p class="description">
                                    <strong>Potrebujete licenciu?</strong><br>
                                    Kontaktujte <a href="mailto:support@webstudio.ltd">support@webstudio.ltd</a>
                                </p>
                            </td>
                        </tr>
                    </table>
                    
                    <p style="margin-top: 20px;">
                        <button type="submit" name="wseo_activate" class="button button-primary button-large">
                            🔓 Aktivovať licenciu
                        </button>
                    </p>
                </form>
            </div>
            
        <?php endif; ?>
        
        <!-- INFO BOX -->
        <div class="wseo-admin-card" style="background: #f9f9f9; border-left: 4px solid #0073aa;">
            <h3 style="margin-top: 0;">ℹ️ Informácie o licencii</h3>
            
            <p><strong>Ako funguje licencia?</strong></p>
            <ul style="line-height: 1.8;">
                <li><strong>Trial:</strong> 14 dní zadarmo so všetkými funkciami</li>
                <li><strong>Aktivácia:</strong> Jednoduchá - stačí zadať licenčný kľúč</li>
                <li><strong>Validácia:</strong> Plugin overuje licenciu raz denne</li>
                <li><strong>Domain Lock:</strong> Licencia platí len pre túto doménu</li>
            </ul>
            
            <p><strong>Potrebujete pomoc?</strong></p>
            <p>
                📧 Email: <a href="mailto:support@webstudio.ltd">support@webstudio.ltd</a><br>
                📞 Tel: <a href="tel:+421950216916">+421 950 216 916</a><br>
                🌐 Web: <a href="https://webstudio.ltd" target="_blank">webstudio.ltd</a>
            </p>
        </div>
        
    </div>
</div>

<style>
.wseo-admin-wrap {
    margin-top: 20px;
    max-width: 100%;
}

.wseo-admin-card {
    background: white;
    padding: 30px;
    margin-bottom: 20px;
    border-radius: 8px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.wseo-admin-card h2 {
    margin-top: 0;
}

.wseo-admin-card h3 {
    color: #0073aa;
}

.form-table th {
    font-weight: 600;
    color: #1d2327;
}

.form-table td {
    padding-top: 15px;
    padding-bottom: 15px;
}
</style>
