/**
 * WebStudio SEO Pro - Push Notifications Service Worker
 * v2.10.0
 */

// Install event
self.addEventListener('install', function(event) {
    self.skipWaiting();
});

// Activate event
self.addEventListener('activate', function(event) {
    event.waitUntil(clients.claim());
});

// Push event - receive notification
self.addEventListener('push', function(event) {
    if (!event.data) return;
    
    var data = {};
    try {
        data = event.data.json();
    } catch (e) {
        data = {
            title: 'Nová správa',
            body: event.data.text(),
            icon: '/favicon.ico'
        };
    }
    
    var options = {
        body: data.body || data.message || '',
        icon: data.icon || '/favicon.ico',
        badge: data.badge || data.icon || '/favicon.ico',
        image: data.image || null,
        data: {
            url: data.url || data.link || '/'
        },
        vibrate: [100, 50, 100],
        requireInteraction: false,
        actions: data.actions || []
    };
    
    event.waitUntil(
        self.registration.showNotification(data.title || 'Notifikácia', options)
    );
});

// Notification click event
self.addEventListener('notificationclick', function(event) {
    event.notification.close();
    
    var url = event.notification.data && event.notification.data.url ? event.notification.data.url : '/';
    
    // Handle action buttons
    if (event.action) {
        // Custom action handling
        url = event.action;
    }
    
    event.waitUntil(
        clients.matchAll({ type: 'window', includeUncontrolled: true }).then(function(clientList) {
            // If already open, focus it
            for (var i = 0; i < clientList.length; i++) {
                var client = clientList[i];
                if (client.url === url && 'focus' in client) {
                    return client.focus();
                }
            }
            // Otherwise open new window
            if (clients.openWindow) {
                return clients.openWindow(url);
            }
        })
    );
});

// Notification close event
self.addEventListener('notificationclose', function(event) {
    // Analytics tracking could go here
});
