/**
 * Webstudio SEO Pro - Admin JavaScript
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        // Quick Edit functionality
        initQuickEdit();
    });

    /**
     * Quick Edit - populate fields when opening
     */
    function initQuickEdit() {
        if (typeof inlineEditPost === 'undefined') {
            return;
        }
        
        var originalEdit = inlineEditPost.edit;
        
        inlineEditPost.edit = function(id) {
            originalEdit.apply(this, arguments);
            
            var postId = 0;
            if (typeof id === 'object') {
                postId = parseInt(this.getId(id));
            }
            
            if (postId > 0) {
                var row = $('#post-' + postId);
                var data = row.find('.wseo-quick-edit-data');
                
                if (data.length) {
                    var title = data.find('.wseo-title').text();
                    var description = data.find('.wseo-description').text();
                    var keywords = data.find('.wseo-keywords').text();
                    
                    var editRow = $('#edit-' + postId);
                    editRow.find('input[name="wseo_meta_title"]').val(title);
                    editRow.find('textarea[name="wseo_meta_description"]').val(description);
                    editRow.find('input[name="wseo_meta_keywords"]').val(keywords);
                }
            }
        };
    }

})(jQuery);
