<?php
/**
 * Maintenance & Service Page Template
 * Database optimization, cleanup, and diagnostics
 */

if (!defined('ABSPATH')) exit;

// Get database statistics
global $wpdb;

// Count items to clean
$revisions_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_type = 'revision'");
$autodrafts_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_status = 'auto-draft'");
$trash_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_status = 'trash'");
$spam_comments_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->comments} WHERE comment_approved = 'spam'");
$trashed_comments_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->comments} WHERE comment_approved = 'trash'");
$expired_transients_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_%' AND option_value < UNIX_TIMESTAMP()");

// Count orphaned metadata
$orphaned_postmeta_count = $wpdb->get_var("
    SELECT COUNT(*) FROM {$wpdb->postmeta} pm
    LEFT JOIN {$wpdb->posts} p ON pm.post_id = p.ID
    WHERE p.ID IS NULL
");
$orphaned_commentmeta_count = $wpdb->get_var("
    SELECT COUNT(*) FROM {$wpdb->commentmeta} cm
    LEFT JOIN {$wpdb->comments} c ON cm.comment_id = c.comment_ID
    WHERE c.comment_ID IS NULL
");
$orphaned_termmeta_count = $wpdb->get_var("
    SELECT COUNT(*) FROM {$wpdb->termmeta} tm
    LEFT JOIN {$wpdb->terms} t ON tm.term_id = t.term_id
    WHERE t.term_id IS NULL
");

// Database size
$db_size_result = $wpdb->get_results("
    SELECT 
        SUM(data_length + index_length) / 1024 / 1024 AS size_mb,
        SUM(data_free) / 1024 / 1024 AS overhead_mb
    FROM information_schema.TABLES 
    WHERE table_schema = DATABASE()
");
$db_size = $db_size_result[0]->size_mb ?? 0;
$db_overhead = $db_size_result[0]->overhead_mb ?? 0;

// Autoload size
$autoload_size = $wpdb->get_var("
    SELECT SUM(LENGTH(option_value)) / 1024 / 1024 AS size_mb
    FROM {$wpdb->options}
    WHERE autoload = 'yes'
");

// Get last cleanup time
$last_cleanup = get_option('wseo_last_cleanup_time', false);
$last_cleanup_text = $last_cleanup ? date('d.m.Y H:i', $last_cleanup) : 'Nikdy';

?>

<div class="wrap wseo-maintenance-page">
    <h1>🩺 WordPress Doctor</h1>
    
    <div class="wseo-maintenance-notice notice notice-info" style="margin: 20px 0; padding: 15px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;">
        <p style="margin: 0 0 10px; font-size: 16px;"><strong>💡 Automatická diagnostika a oprava WordPress problémov</strong></p>
        <p style="margin: 0; opacity: 0.9;">WordPress Doctor skenuje váš web a automaticky opravuje bežné problémy - broken links, orphaned data, slow autoload, a ďalšie!</p>
    </div>
    
    <div class="wseo-maintenance-notice notice notice-warning" style="margin: 20px 0; padding: 15px;">
        <p><strong>⚠️ DÔLEŽITÉ UPOZORNENIE:</strong> Pred vykonaním akýchkoľvek čistiacich operácií dôrazne odporúčame vytvoriť zálohu databázy! Operácie sú nevratné.</p>
        <p>
            <a href="<?php echo admin_url('export.php'); ?>" class="button button-secondary" target="_blank">
                <span class="dashicons dashicons-download" style="margin-top: 3px;"></span> Exportovať WordPress obsah
            </a>
            <a href="#" id="wseo-quick-backup" class="button button-primary">
                <span class="dashicons dashicons-database" style="margin-top: 3px;"></span> Vytvoriť SQL zálohu
            </a>
        </p>
    </div>

    <!-- Database Statistics -->
    <div class="wseo-card" style="margin-bottom: 20px;">
        <h2 style="margin-top: 0;">📊 Štatistiky databázy</h2>
        <div class="wseo-stats-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
            <div class="wseo-stat-box">
                <div class="wseo-stat-label">Veľkosť databázy</div>
                <div class="wseo-stat-value"><?php echo number_format($db_size, 2); ?> MB</div>
            </div>
            <div class="wseo-stat-box">
                <div class="wseo-stat-label">Overhead (fragmentácia)</div>
                <div class="wseo-stat-value"><?php echo number_format($db_overhead, 2); ?> MB</div>
            </div>
            <div class="wseo-stat-box">
                <div class="wseo-stat-label">Autoload options</div>
                <div class="wseo-stat-value"><?php echo number_format($autoload_size, 2); ?> MB</div>
            </div>
            <div class="wseo-stat-box">
                <div class="wseo-stat-label">Posledné čistenie</div>
                <div class="wseo-stat-value"><?php echo $last_cleanup_text; ?></div>
            </div>
        </div>
    </div>


    <div class="wseo-maintenance-grid" style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
        
        <!-- FÁZA 1: Quick Cleanup -->
        <div class="wseo-card">
            <h2 style="margin-top: 0;">🗑️ Rýchle čistenie</h2>
            <p style="color: #666;">Bezpečné vymazanie nepotrebných dát.</p>
            
            <div class="wseo-cleanup-list">
                <label class="wseo-cleanup-item">
                    <input type="checkbox" name="cleanup[]" value="revisions" data-count="<?php echo $revisions_count; ?>">
                    <span class="wseo-cleanup-label">
                        <strong>Revízie príspevkov</strong>
                        <span class="wseo-count-badge"><?php echo number_format($revisions_count); ?></span>
                    </span>
                    <span class="wseo-cleanup-desc">Staršie verzie príspevkov (môže ušetriť veľa miesta)</span>
                </label>
                
                <label class="wseo-cleanup-item">
                    <input type="checkbox" name="cleanup[]" value="autodrafts" data-count="<?php echo $autodrafts_count; ?>">
                    <span class="wseo-cleanup-label">
                        <strong>Auto-draft príspevky</strong>
                        <span class="wseo-count-badge"><?php echo number_format($autodrafts_count); ?></span>
                    </span>
                    <span class="wseo-cleanup-desc">Automaticky uložené koncepty</span>
                </label>
                
                <label class="wseo-cleanup-item">
                    <input type="checkbox" name="cleanup[]" value="trash" data-count="<?php echo $trash_count; ?>">
                    <span class="wseo-cleanup-label">
                        <strong>Kôš (Trash)</strong>
                        <span class="wseo-count-badge"><?php echo number_format($trash_count); ?></span>
                    </span>
                    <span class="wseo-cleanup-desc">Príspevky v koši</span>
                </label>
                
                <label class="wseo-cleanup-item">
                    <input type="checkbox" name="cleanup[]" value="spam_comments" data-count="<?php echo $spam_comments_count; ?>">
                    <span class="wseo-cleanup-label">
                        <strong>Spam komentáre</strong>
                        <span class="wseo-count-badge"><?php echo number_format($spam_comments_count); ?></span>
                    </span>
                    <span class="wseo-cleanup-desc">Komentáre označené ako spam</span>
                </label>
                
                <label class="wseo-cleanup-item">
                    <input type="checkbox" name="cleanup[]" value="trashed_comments" data-count="<?php echo $trashed_comments_count; ?>">
                    <span class="wseo-cleanup-label">
                        <strong>Vymazané komentáre</strong>
                        <span class="wseo-count-badge"><?php echo number_format($trashed_comments_count); ?></span>
                    </span>
                    <span class="wseo-cleanup-desc">Komentáre v koši</span>
                </label>
                
                <label class="wseo-cleanup-item">
                    <input type="checkbox" name="cleanup[]" value="expired_transients" data-count="<?php echo $expired_transients_count; ?>">
                    <span class="wseo-cleanup-label">
                        <strong>Expirované transienty</strong>
                        <span class="wseo-count-badge"><?php echo number_format($expired_transients_count); ?></span>
                    </span>
                    <span class="wseo-cleanup-desc">Neplatné dočasné dáta (cache)</span>
                </label>
            </div>
            
            <div class="wseo-cleanup-actions" style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">
                <button type="button" class="button button-primary button-large" id="wseo-cleanup-selected">
                    <span class="dashicons dashicons-trash" style="margin-top: 3px;"></span>
                    Vyčistiť vybrané
                </button>
                <button type="button" class="button button-secondary" id="wseo-cleanup-all">
                    Vyčistiť všetko
                </button>
                <span class="spinner" style="float: none; margin: 0 10px;"></span>
            </div>
            
            <div id="wseo-cleanup-result" style="margin-top: 15px;"></div>
        </div>

        <!-- FÁZA 1 & 2: Database Optimization -->
        <div class="wseo-card">
            <h2 style="margin-top: 0;">🔧 Optimalizácia databázy</h2>
            <p style="color: #666;">Defragmentácia a optimalizácia SQL tabuliek.</p>
            
            <div class="wseo-optimization-info" style="background: #f0f0f1; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
                <p style="margin: 0;"><strong>Overhead:</strong> <?php echo number_format($db_overhead, 2); ?> MB</p>
                <p style="margin: 5px 0 0;">Fragmentovaný priestor, ktorý môže byť uvoľnený optimalizáciou.</p>
            </div>
            
            <div class="wseo-optimization-actions">
                <button type="button" class="button button-primary button-large" id="wseo-optimize-tables">
                    <span class="dashicons dashicons-database-view" style="margin-top: 3px;"></span>
                    Optimalizovať všetky tabulky
                </button>
                <button type="button" class="button button-secondary" id="wseo-analyze-tables">
                    Analyzovať tabulky
                </button>
                <span class="spinner" style="float: none; margin: 0 10px;"></span>
            </div>
            
            <div id="wseo-optimize-result" style="margin-top: 15px;"></div>
            
            <hr style="margin: 30px 0;">
            
            <h3>🧹 Orphaned Metadata</h3>
            <p style="color: #666;">Metadata patriaca k zmazaným záznamom.</p>
            
            <div class="wseo-orphaned-list">
                <div class="wseo-orphaned-item">
                    <span><strong>Post meta:</strong> <?php echo number_format($orphaned_postmeta_count); ?> záznamov</span>
                    <button type="button" class="button button-small" data-type="postmeta">Vyčistiť</button>
                </div>
                <div class="wseo-orphaned-item">
                    <span><strong>Comment meta:</strong> <?php echo number_format($orphaned_commentmeta_count); ?> záznamov</span>
                    <button type="button" class="button button-small" data-type="commentmeta">Vyčistiť</button>
                </div>
                <div class="wseo-orphaned-item">
                    <span><strong>Term meta:</strong> <?php echo number_format($orphaned_termmeta_count); ?> záznamov</span>
                    <button type="button" class="button button-small" data-type="termmeta">Vyčistiť</button>
                </div>
            </div>
            
            <div id="wseo-orphaned-result" style="margin-top: 15px;"></div>
        </div>

        <!-- FÁZA 2: Autoload Optimization -->
        <div class="wseo-card">
            <h2 style="margin-top: 0;">⚡ Autoload Options Optimalizácia</h2>
            <p style="color: #666;">Veľké autoload options spomaľujú každý request.</p>
            
            <div class="wseo-autoload-info" style="background: #f0f0f1; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
                <p style="margin: 0;"><strong>Celková veľkosť autoload:</strong> <?php echo number_format($autoload_size, 2); ?> MB</p>
                <p style="margin: 5px 0 0;">Odporúčaná veľkosť: max 1 MB</p>
            </div>
            
            <button type="button" class="button button-primary" id="wseo-scan-autoload">
                <span class="dashicons dashicons-search" style="margin-top: 3px;"></span>
                Skenovať autoload options
            </button>
            <span class="spinner" style="float: none; margin: 0 10px;"></span>
            
            <div id="wseo-autoload-results" style="margin-top: 20px;"></div>
        </div>

        <!-- FÁZA 3: Scheduled Cleanup -->
        <div class="wseo-card">
            <h2 style="margin-top: 0;">⏰ Automatické čistenie</h2>
            <p style="color: #666;">Naplánujte pravidelné čistenie databázy.</p>
            
            <?php
            $scheduled_cleanup = get_option('wseo_scheduled_cleanup', array(
                'enabled' => false,
                'frequency' => 'weekly',
                'items' => array('revisions', 'autodrafts', 'expired_transients'),
                'email_report' => false
            ));
            ?>
            
            <label class="wseo-toggle-setting">
                <input type="checkbox" name="wseo_scheduled_cleanup_enabled" <?php checked($scheduled_cleanup['enabled'], true); ?>>
                <span>Povoliť automatické čistenie</span>
            </label>
            
            <div class="wseo-scheduled-settings" style="margin-top: 20px; <?php echo !$scheduled_cleanup['enabled'] ? 'opacity: 0.5; pointer-events: none;' : ''; ?>">
                <p>
                    <label><strong>Frekvencia:</strong></label><br>
                    <select name="wseo_scheduled_frequency" style="width: 100%; max-width: 300px;">
                        <option value="daily" <?php selected($scheduled_cleanup['frequency'], 'daily'); ?>>Denne</option>
                        <option value="weekly" <?php selected($scheduled_cleanup['frequency'], 'weekly'); ?>>Týždenne</option>
                        <option value="monthly" <?php selected($scheduled_cleanup['frequency'], 'monthly'); ?>>Mesačne</option>
                    </select>
                </p>
                
                <p><strong>Čo čistiť:</strong></p>
                <label><input type="checkbox" name="wseo_scheduled_items[]" value="revisions" <?php checked(in_array('revisions', $scheduled_cleanup['items'])); ?>> Revízie</label><br>
                <label><input type="checkbox" name="wseo_scheduled_items[]" value="autodrafts" <?php checked(in_array('autodrafts', $scheduled_cleanup['items'])); ?>> Auto-drafts</label><br>
                <label><input type="checkbox" name="wseo_scheduled_items[]" value="expired_transients" <?php checked(in_array('expired_transients', $scheduled_cleanup['items'])); ?>> Expirované transienty</label><br>
                <label><input type="checkbox" name="wseo_scheduled_items[]" value="spam_comments" <?php checked(in_array('spam_comments', $scheduled_cleanup['items'])); ?>> Spam komentáre</label><br>
                <label><input type="checkbox" name="wseo_scheduled_items[]" value="orphaned_meta" <?php checked(in_array('orphaned_meta', $scheduled_cleanup['items'])); ?>> Orphaned metadata (osirelé metadáta)</label><br>
                <label><input type="checkbox" name="wseo_scheduled_items[]" value="optimize_tables" <?php checked(in_array('optimize_tables', $scheduled_cleanup['items'])); ?>> Optimalizácia databázových tabuliek</label><br>
                
                <p style="margin-top: 15px;">
                    <label>
                        <input type="checkbox" name="wseo_scheduled_email_report" <?php checked($scheduled_cleanup['email_report'], true); ?>>
                        Posielať email report po čistení
                    </label>
                </p>
            </div>
            
            <p style="margin-top: 20px;">
                <button type="button" class="button button-primary" id="wseo-save-scheduled">Uložiť nastavenia</button>
            </p>
        </div>

        <!-- FÁZA 3: Image Optimization - Presmerované na novú stránku Obrázky -->
        <div class="wseo-card">
            <h2 style="margin-top: 0;">🖼️ Obrázky</h2>
            <p style="color: #666;">Optimalizácia obrázkov, ALT texty, WebP a AVIF konverzia boli presunuté do samostatnej sekcie.</p>
            
            <a href="<?php echo admin_url('admin.php?page=webstudio-seo-images'); ?>" class="button button-primary" style="font-size: 14px; padding: 8px 20px;">
                <span class="dashicons dashicons-format-gallery" style="margin-top: 3px;"></span>
                Prejsť na správu obrázkov →
            </a>
        </div>

        <!-- FÁZA 3: Diagnostics & Repair -->
        <div class="wseo-card">
            <h2 style="margin-top: 0;">🔍 Diagnostika & Opravy</h2>
            <p style="color: #666;">Kontrola integrity databázy a opravy.</p>
            
            <div class="wseo-diagnostic-actions">
                <button type="button" class="button button-secondary" id="wseo-check-integrity">
                    <span class="dashicons dashicons-search" style="margin-top: 3px;"></span>
                    Skontrolovať integritu DB
                </button>
                <button type="button" class="button button-secondary" id="wseo-repair-tables">
                    <span class="dashicons dashicons-admin-tools" style="margin-top: 3px;"></span>
                    Opraviť poškodené tabulky
                </button>
                <button type="button" class="button button-secondary" id="wseo-export-diagnostic">
                    <span class="dashicons dashicons-download" style="margin-top: 3px;"></span>
                    Export diagnostického reportu
                </button>
                <span class="spinner" style="float: none; margin: 0 10px;"></span>
            </div>
            
            <div id="wseo-diagnostic-results" style="margin-top: 20px;"></div>
        </div>
    </div>
    
    <!-- WordPress Doctor - Auto Fixes -->
    <div class="wseo-card" style="margin-top: 40px; margin-bottom: 20px; background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white; border: none;">
        <h2 style="margin-top: 0; color: white;">🩺 Automatické opravy WordPress problémov</h2>
        <p style="opacity: 0.9; margin-bottom: 20px;">Diagnostika a jedným kliknutím oprava bežných WordPress problémov</p>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px; margin-bottom: 20px;">
            
            <!-- Broken Media Links -->
            <div style="background: rgba(255,255,255,0.15); padding: 20px; border-radius: 8px;">
                <h3 style="margin: 0 0 10px; color: white;">🖼️ Poškodené odkazy médií</h3>
                <p style="font-size: 13px; opacity: 0.9; margin-bottom: 15px;">
                    Po zmene domény môžu mať obrázky poškodené URL adresy. Skenovať a opraviť automaticky!
                </p>
                <button type="button" class="button button-light" id="wseo-scan-media-links" style="background: white; color: #f5576c; margin-right: 5px;">
                    🔍 Skenovať odkazy
                </button>
                <button type="button" class="button button-light" id="wseo-fix-all-media" style="background: #4caf50; color: white;">
                    ✓ Opraviť všetko
                </button>
                <div id="wseo-media-links-result" style="margin-top: 10px;"></div>
            </div>

            <!-- Duplicate Slugs -->
            <div style="background: rgba(255,255,255,0.15); padding: 20px; border-radius: 8px;">
                <h3 style="margin: 0 0 10px; color: white;">🔗 Duplicitné URL slugy</h3>
                <p style="font-size: 13px; opacity: 0.9; margin-bottom: 15px;">
                    Nájdi príspevky s duplicitnými slugmi (moj-prispevok-2, moj-prispevok-3) a vyčisti ich!
                </p>
                <button type="button" class="button button-light" id="wseo-scan-duplicate-slugs" style="background: white; color: #f5576c; margin-right: 5px;">
                    🔍 Nájsť duplicity
                </button>
                <button type="button" class="button button-light" id="wseo-fix-all-duplicates" style="background: #4caf50; color: white;">
                    ✓ Opraviť všetko
                </button>
                <div id="wseo-duplicate-slugs-result" style="margin-top: 10px;"></div>
            </div>

            <!-- UTF-8 Encoding -->
            <div style="background: rgba(255,255,255,0.15); padding: 20px; border-radius: 8px;">
                <h3 style="margin: 0 0 10px; color: white;">🔤 UTF-8 Kódovanie</h3>
                <p style="font-size: 13px; opacity: 0.9; margin-bottom: 10px;">
                    Oprav poškodené znaky (���) spôsobené nesprávnym kódovaním databázy.
                </p>
                <p style="font-size: 11px; opacity: 0.8; margin-bottom: 15px; background: rgba(255,152,0,0.3); padding: 8px; border-radius: 4px;">
                    ⚠️ Bezpečnostné info: Kritické tabuľky (wp_options, wp_usermeta) sú automaticky vylúčené z konverzie pre ochranu nastavení.
                </p>
                <button type="button" class="button button-light" id="wseo-check-encoding" style="background: white; color: #f5576c; margin-right: 5px;">
                    🔍 Skontrolovať kódovanie
                </button>
                <button type="button" class="button button-light" id="wseo-fix-all-encoding" style="background: #4caf50; color: white;">
                    ✓ Opraviť všetko
                </button>
                <div id="wseo-encoding-result" style="margin-top: 10px;"></div>
            </div>

        </div>
        
        <!-- WordPress Recovery Mode - Full Width -->
        <div style="background: rgba(255,0,0,0.2); padding: 25px; border-radius: 8px; border: 2px solid rgba(255,255,255,0.3); margin-top: 20px;">
            <div style="display: grid; grid-template-columns: 1fr 2fr; gap: 20px; align-items: start;">
                
                <!-- Left: Title & Button -->
                <div>
                    <h3 style="margin: 0 0 15px; color: white; font-size: 18px;">🚨 WordPress Recovery Mode</h3>
                    <button type="button" class="button button-light" id="wseo-recovery-mode" style="background: #f44336; color: white; font-weight: bold; font-size: 15px; padding: 12px 24px;">
                        🚨 Spustiť Recovery Mode
                    </button>
                </div>
                
                <!-- Right: Description -->
                <div style="font-size: 13px; line-height: 1.7;">
                    <p style="margin: 0 0 12px; opacity: 0.95;">
                        <strong>KOMPLETNÝ NÚDZOVÝ REŽIM</strong> pre obnovenie WordPress ak web prestane správne fungovať.
                    </p>
                    
                    <div style="background: rgba(0,0,0,0.15); padding: 15px; border-radius: 6px; margin-bottom: 12px;">
                        <strong style="display: block; margin-bottom: 8px;">✅ Čo sa OPRAVÍ (bez vymazania dát):</strong>
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 5px; font-size: 12px;">
                            <div>• Homepage & Blog nastavenia</div>
                            <div>• Komentáre & counts</div>
                            <div>• Permalinky & URL štruktúra</div>
                            <div>• Media Library</div>
                            <div>• Tagy & Kategórie counts</div>
                            <div>• Menu & Widgets</div>
                            <div>• Post metadata</div>
                            <div>• Všetky cache</div>
                        </div>
                    </div>
                    
                    <div style="background: rgba(255,152,0,0.25); padding: 12px; border-radius: 6px; font-size: 12px;">
                        <strong>⚠️ DÔLEŽITÉ:</strong><br>
                        • Recovery Mode <strong>NEMAZŽE žiadne články, stránky, produkty ani používateľov!</strong><br>
                        • Opravuje iba nastavenia, counts, cache a metadata<br>
                        • Použite ak: homepage nefunguje, permalinky 404, tagy/kategórie majú zlé počty, menu chybné
                    </div>
                </div>
                
            </div>
            <div id="wseo-recovery-result" style="margin-top: 15px;"></div>
        </div>
        
    </div>
    <!-- Activity Log -->
    <div class="wseo-card" style="margin-top: 20px;">
        <h2 style="margin-top: 0;">📋 Aktivita servisu</h2>
        <div id="wseo-activity-log">
            <?php
            $activity_log = get_option('wseo_maintenance_log', array());
            if (empty($activity_log)) {
                echo '<p style="color: #666;">Žiadna aktivita zatiaľ.</p>';
            } else {
                echo '<table class="wp-list-table widefat fixed striped" style="margin-top: 10px;">';
                echo '<thead><tr><th>Dátum & Čas</th><th>Akcia</th><th>Detaily</th></tr></thead><tbody>';
                foreach (array_reverse(array_slice($activity_log, -20)) as $entry) {
                    echo '<tr>';
                    echo '<td>' . esc_html($entry['time']) . '</td>';
                    echo '<td>' . esc_html($entry['action']) . '</td>';
                    echo '<td>' . esc_html($entry['details']) . '</td>';
                    echo '</tr>';
                }
                echo '</tbody></table>';
            }
            ?>
        </div>
        <p style="margin-top: 15px;">
            <button type="button" class="button" id="wseo-clear-log">Vymazať log</button>
        </p>
    </div>
</div>

<style>
.wseo-maintenance-page .wseo-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    box-shadow: 0 1px 1px rgba(0,0,0,.04);
    padding: 20px;
}

.wseo-stat-box {
    background: #f0f0f1;
    padding: 15px;
    border-radius: 4px;
    text-align: center;
}

.wseo-stat-label {
    font-size: 12px;
    color: #666;
    margin-bottom: 5px;
}

.wseo-stat-value {
    font-size: 24px;
    font-weight: bold;
    color: #2271b1;
}

.wseo-cleanup-item {
    display: block;
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    margin-bottom: 10px;
    cursor: pointer;
    transition: background 0.2s;
}

.wseo-cleanup-item:hover {
    background: #f6f7f7;
}

.wseo-cleanup-item input[type="checkbox"] {
    margin-right: 10px;
    vertical-align: middle;
}

.wseo-cleanup-label {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 5px;
}

.wseo-count-badge {
    background: #2271b1;
    color: #fff;
    padding: 2px 8px;
    border-radius: 10px;
    font-size: 11px;
    font-weight: bold;
}

.wseo-cleanup-desc {
    display: block;
    font-size: 12px;
    color: #666;
    margin-left: 30px;
}

.wseo-orphaned-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    margin-bottom: 8px;
}

.wseo-result-box {
    background: #f0f6fc;
    border-left: 4px solid #2271b1;
    padding: 12px;
    margin-top: 10px;
}

.wseo-result-box.success {
    background: #edfaef;
    border-left-color: #00a32a;
}

.wseo-result-box.error {
    background: #fcf0f1;
    border-left-color: #d63638;
}

@media (max-width: 782px) {
    .wseo-maintenance-grid {
        grid-template-columns: 1fr !important;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    
    // ========================================
    // AUTO ALT TEXT & IMAGE METADATA (v2.8.10)
    // ========================================
    
    // Load image stats on page load
    wseoLoadImageStats();
    
    function wseoLoadImageStats() {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_get_image_stats',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    var d = response.data;
                    $('#wseo-stat-total').text(d.total);
                    $('#wseo-stat-complete').text(d.complete);
                    $('#wseo-stat-without-alt').text(d.without_alt);
                    
                    // Progress bars
                    var altPct = d.total > 0 ? (d.with_alt / d.total * 100) : 0;
                    var titlePct = d.total > 0 ? (d.with_title / d.total * 100) : 0;
                    var captionPct = d.total > 0 ? (d.with_caption / d.total * 100) : 0;
                    var descPct = d.total > 0 ? (d.with_description / d.total * 100) : 0;
                    
                    $('#wseo-bar-alt').css('width', altPct + '%');
                    $('#wseo-bar-title').css('width', titlePct + '%');
                    $('#wseo-bar-caption').css('width', captionPct + '%');
                    $('#wseo-bar-desc').css('width', descPct + '%');
                    
                    $('#wseo-progress-alt').text(d.with_alt + '/' + d.total);
                    $('#wseo-progress-title').text(d.with_title + '/' + d.total);
                    $('#wseo-progress-caption').text(d.with_caption + '/' + d.total);
                    $('#wseo-progress-desc').text(d.with_description + '/' + d.total);
                }
            }
        });
    }
    
    // Refresh stats button
    $('#wseo-refresh-image-stats').on('click', function() {
        $(this).prop('disabled', true).find('.dashicons').addClass('spin');
        wseoLoadImageStats();
        setTimeout(function() {
            $('#wseo-refresh-image-stats').prop('disabled', false).find('.dashicons').removeClass('spin');
        }, 1000);
    });
    
    // Tab switching
    $('.wseo-tab-btn').on('click', function() {
        var tab = $(this).data('tab');
        $('.wseo-tab-btn').removeClass('active').css({'border-bottom': 'none', 'color': '#666', 'font-weight': 'normal'});
        $(this).addClass('active').css({'border-bottom': '2px solid #2271b1', 'color': '#2271b1', 'font-weight': '500'});
        $('.wseo-tab-content').hide();
        $('.wseo-tab-content[data-tab="' + tab + '"]').show();
    });
    
    // Save templates
    $('#wseo-save-templates').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Ukladám...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_save_image_templates',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                template_alt: $('#wseo-template-alt').val(),
                template_title: $('#wseo-template-title').val(),
                template_caption: $('#wseo-template-caption').val(),
                template_description: $('#wseo-template-description').val(),
                fallback_text: $('#wseo-fallback-text').val()
            },
            success: function(response) {
                if (response.success) {
                    $btn.html('<span class="dashicons dashicons-yes" style="margin-top: 3px;"></span> Uložené!');
                    setTimeout(function() {
                        $btn.html('<span class="dashicons dashicons-saved" style="margin-top: 3px;"></span> Uložiť šablóny').prop('disabled', false);
                    }, 2000);
                }
            },
            error: function() {
                $btn.text('Chyba!').prop('disabled', false);
            }
        });
    });
    
    // Bulk fill buttons
    $('.wseo-fill-btn').on('click', function() {
        var type = $(this).data('type');
        var mode = $(this).data('mode');
        var customText = mode === 'custom' ? $('#wseo-custom-text').val() : '';
        
        if (mode === 'custom' && !customText) {
            alert('Zadajte vlastný text.');
            return;
        }
        
        if (mode === 'overwrite' && !confirm('Prepísať VŠETKY existujúce údaje? Táto akcia je nevratná!')) {
            return;
        }
        
        wseoBulkFillImages(type, mode, customText);
    });
    
    // Clear buttons
    $('.wseo-clear-btn').on('click', function() {
        var type = $(this).data('type');
        
        if (!confirm('Ste si istí, že chcete vymazať údaje? Táto akcia je nevratná!')) {
            return;
        }
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_clear_image_metadata',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                type: type
            },
            success: function(response) {
                if (response.success) {
                    alert('Vymazané: ' + response.data.cleared + ' záznamov');
                    wseoLoadImageStats();
                }
            }
        });
    });
    
    // Bulk fill function with progress
    function wseoBulkFillImages(type, mode, customText, offset) {
        offset = offset || 0;
        
        $('#wseo-bulk-progress').show();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_bulk_fill_images',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                type: type,
                mode: mode,
                custom_text: customText,
                batch_size: 50,
                offset: offset
            },
            success: function(response) {
                if (response.success) {
                    var d = response.data;
                    
                    if (d.completed) {
                        $('#wseo-bulk-progress-bar').css('width', '100%');
                        $('#wseo-bulk-progress-text').text('✓ Hotovo!');
                        wseoLoadImageStats();
                        setTimeout(function() {
                            $('#wseo-bulk-progress').hide();
                        }, 2000);
                    } else {
                        var pct = Math.min(95, (offset / 1000) * 100);
                        $('#wseo-bulk-progress-bar').css('width', pct + '%');
                        $('#wseo-bulk-progress-text').text('Spracované: ' + (offset + d.processed) + ' obrázkov, Vyplnené: ' + d.filled);
                        
                        // Continue with next batch
                        wseoBulkFillImages(type, mode, customText, d.next_offset);
                    }
                }
            },
            error: function() {
                $('#wseo-bulk-progress-text').text('Chyba pri spracovaní!');
            }
        });
    }
    
    // ========================================
    // EXISTING MAINTENANCE FUNCTIONS
    // ========================================
    
    // Cleanup selected items
    $('#wseo-cleanup-selected, #wseo-cleanup-all').on('click', function() {
        var selectAll = $(this).attr('id') === 'wseo-cleanup-all';
        var items = selectAll ? 
            ['revisions', 'autodrafts', 'trash', 'spam_comments', 'trashed_comments', 'expired_transients'] :
            $('input[name="cleanup[]"]:checked').map(function() { return $(this).val(); }).get();
        
        if (items.length === 0) {
            alert('Vyberte aspoň jednu položku na vyčistenie.');
            return;
        }
        
        if (!confirm('Ste si istí, že chcete vymazať vybrané položky? Táto akcia je nevratná!')) {
            return;
        }
        
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-cleanup-result');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_cleanup',
                items: items,
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="wseo-result-box success"><strong>✓ Hotovo!</strong><br>' + response.data.message + '</div>');
                    // Refresh page after 2 seconds
                    setTimeout(function() { location.reload(); }, 2000);
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            error: function() {
                $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> Nepodarilo sa vykonať čistenie.</div>');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Optimize tables
    $('#wseo-optimize-tables').on('click', function() {
        if (!confirm('Ste si istí, že chcete optimalizovať všetky databázové tabulky?')) {
            return;
        }
        
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-optimize-result');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_optimize',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="wseo-result-box success"><strong>✓ Hotovo!</strong><br>' + response.data.message + '</div>');
                    setTimeout(function() { location.reload(); }, 2000);
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            error: function() {
                $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> Nepodarilo sa optimalizovať tabulky.</div>');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Analyze tables
    $('#wseo-analyze-tables').on('click', function() {
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-optimize-result');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_analyze',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="wseo-result-box success"><strong>✓ Hotovo!</strong><br>' + response.data.message + '</div>');
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            error: function() {
                $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> Nepodarilo sa analyzovať tabulky.</div>');
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Clean orphaned metadata
    $('.wseo-orphaned-item button').on('click', function() {
        var type = $(this).data('type');
        
        if (!confirm('Ste si istí, že chcete vymazať orphaned ' + type + '?')) {
            return;
        }
        
        var $btn = $(this);
        var $result = $('#wseo-orphaned-result');
        
        $btn.prop('disabled', true);
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_orphaned',
                type: type,
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="wseo-result-box success"><strong>✓ Hotovo!</strong><br>' + response.data.message + '</div>');
                    setTimeout(function() { location.reload(); }, 2000);
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
            }
        });
    });
    
    // Scan autoload options
    $('#wseo-scan-autoload').on('click', function() {
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-autoload-results');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_scan_autoload',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html(response.data.html);
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Save scheduled cleanup settings
    $('#wseo-save-scheduled').on('click', function() {
        var $btn = $(this);
        var enabled = $('input[name="wseo_scheduled_cleanup_enabled"]').is(':checked');
        var frequency = $('select[name="wseo_scheduled_frequency"]').val();
        var items = $('input[name="wseo_scheduled_items[]"]:checked').map(function() { return $(this).val(); }).get();
        var email_report = $('input[name="wseo_scheduled_email_report"]').is(':checked');
        
        $btn.prop('disabled', true);
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_save_scheduled',
                enabled: enabled,
                frequency: frequency,
                items: items,
                email_report: email_report,
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    alert('✓ Nastavenia boli uložené!');
                } else {
                    alert('✗ Chyba pri ukladaní nastavení.');
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
            }
        });
    });
    
    // Toggle scheduled settings
    $('input[name="wseo_scheduled_cleanup_enabled"]').on('change', function() {
        var $settings = $('.wseo-scheduled-settings');
        if ($(this).is(':checked')) {
            $settings.css({'opacity': '1', 'pointer-events': 'auto'});
        } else {
            $settings.css({'opacity': '0.5', 'pointer-events': 'none'});
        }
    });
    
    // Scan images
    $('#wseo-scan-images').on('click', function() {
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-image-results');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_scan_images',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html(response.data.html);
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Diagnostic actions
    $('#wseo-check-integrity, #wseo-repair-tables, #wseo-export-diagnostic').on('click', function() {
        var action = $(this).attr('id').replace('wseo-', '').replace(/-/g, '_');
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-diagnostic-results');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_' + action,
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    if (response.data.download) {
                        window.location.href = response.data.download;
                        $result.html('<div class="wseo-result-box success">✓ Report stiahnutý!</div>');
                    } else {
                        $result.html('<div class="wseo-result-box success">' + response.data.message + '</div>');
                    }
                } else {
                    $result.html('<div class="wseo-result-box error"><strong>✗ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Quick backup
    $('#wseo-quick-backup').on('click', function(e) {
        e.preventDefault();
        if (!confirm('Chcete vytvoriť SQL dump zálohu databázy? Môže to trvať niekoľko minút.')) {
            return;
        }
        
        var $btn = $(this);
        $btn.prop('disabled', true).text('Vytváram zálohu...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_backup',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success && response.data.download) {
                    window.location.href = response.data.download;
                    alert('✓ Záloha vytvorená a stiahnutá!');
                } else {
                    alert('✗ Chyba pri vytváraní zálohy.');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).html('<span class="dashicons dashicons-database" style="margin-top: 3px;"></span> Vytvoriť SQL zálohu');
            }
        });
    });
    
    // Clear activity log
    $('#wseo-clear-log').on('click', function() {
        if (!confirm('Ste si istí, že chcete vymazať log aktivít?')) {
            return;
        }
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_clear_log',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $('#wseo-activity-log').html('<p style="color: #666;">Žiadna aktivita zatiaľ.</p>');
                }
            }
        });
    });
    
    // ========================================================================
    // WORDPRESS DOCTOR - AUTO-FIX HANDLERS (v2.8.8)
    // ========================================================================
    
    // WordPress Recovery Mode
    $('#wseo-recovery-mode').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-recovery-result');
        
        if (!confirm('🚨 KOMPLETNÝ WORDPRESS RECOVERY 🚨\n\nToto opraví VŠETKY základné WordPress funkcie:\n• Homepage & Blog\n• Permalinky & URL\n• Tagy & Kategórie\n• Post counts & Metadata\n• Komentáre\n• Media Library\n• Menu & Widgets\n• Core WordPress nastavenia\n\nVyčistí všetky cache a regeneruje všetko od nuly.\n\n⚠️ Toto je NÚDZOVÝ režim!\n\nPokračovať?')) {
            return;
        }
        
        $btn.prop('disabled', true).html('🚨 Opravujem celý WordPress...');
        $result.html('<div style="color: white; margin-top: 10px; font-size: 14px; line-height: 1.8;">⏳ Spúšťam KOMPLETNÝ Recovery Mode...<br>Toto môže trvať 30-60 sekúnd...<br><br><div class="spinner is-active" style="float: none; margin: 0;"></div></div>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            timeout: 120000, // 2 minutes
            data: {
                action: 'wseo_recovery_mode',
                nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div style="background: rgba(76,175,80,0.3); padding: 20px; border-radius: 5px; margin-top: 10px; color: white; max-height: 400px; overflow-y: auto;"><strong style="font-size: 16px;">' + response.data.message + '</strong><br><br><div style="font-size: 13px; line-height: 1.8;">' + response.data.details + '</div><br><br><strong style="color: #ffeb3b;">⚠️ DÔLEŽITÉ:</strong><br>1. Vyčistite cache prehliadača (Ctrl+Shift+Delete)<br>2. Obnovte túto stránku (F5)<br>3. Skontrolujte že homepage funguje<br>4. Skontrolujte menu & widgety</div>');
                } else {
                    $result.html('<div style="background: rgba(244,67,54,0.3); padding: 15px; border-radius: 5px; margin-top: 10px; color: white;"><strong>❌ Chyba:</strong> ' + response.data + '</div>');
                }
            },
            error: function(xhr, status, error) {
                if (status === 'timeout') {
                    $result.html('<div style="background: rgba(255,152,0,0.3); padding: 15px; border-radius: 5px; margin-top: 10px; color: white;"><strong>⚠️ Timeout:</strong> Recovery mode prebieha na pozadí. Počkajte 2 minúty a obnovte stránku.</div>');
                } else {
                    $result.html('<div style="background: rgba(244,67,54,0.3); padding: 15px; border-radius: 5px; margin-top: 10px; color: white;"><strong>❌ Kritická chyba!</strong> Kontaktujte podporu.</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).html('🚨 Spustiť Recovery Mode');
            }
        });
    });
    
    // Scan broken media links
    $('#wseo-scan-media-links').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-media-links-result');
        
        $btn.prop('disabled', true).text('🔍 Skenujem...');
        $result.html('<div style="color: white; margin-top: 10px;">Skenujem príspevky...</div>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_scan_media_links',
                nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    if (response.data.broken_count > 0) {
                        var html = '<div style="background: rgba(255,255,255,0.2); padding: 10px; border-radius: 5px; margin-top: 10px;">';
                        html += '<strong>' + response.data.message + '</strong><br>';
                        html += 'Nájdené staré domény:<br>';
                        
                        // Store domains for "Fix All" button
                        window.wseo_broken_domains = [];
                        $.each(response.data.domains, function(domain, count) {
                            html += '• ' + domain + ' (' + count + ' odkazov)<br>';
                            window.wseo_broken_domains.push(domain);
                        });
                        html += '</div>';
                        $result.html(html);
                    } else {
                        $result.html('<div style="color: white; margin-top: 10px;">✅ ' + response.data.message + '</div>');
                    }
                } else {
                    $result.html('<div style="color: #ffeb3b; margin-top: 10px;">❌ Chyba: ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).text('🔍 Skenovať odkazy');
            }
        });
    });
    
    // Fix all broken media links
    $('#wseo-fix-all-media').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-media-links-result');
        
        if (!window.wseo_broken_domains || window.wseo_broken_domains.length === 0) {
            alert('Najprv spustite skenovanie!');
            return;
        }
        
        if (!confirm('Opraviť všetky poškodené odkazy z ' + window.wseo_broken_domains.length + ' domén?')) {
            return;
        }
        
        $btn.prop('disabled', true).text('⏳ Opravujem...');
        
        var fixedCount = 0;
        var totalDomains = window.wseo_broken_domains.length;
        
        // Fix each domain sequentially
        function fixNextDomain(index) {
            if (index >= totalDomains) {
                // All done
                $result.html('<div style="background: rgba(76,175,80,0.3); padding: 10px; border-radius: 5px; margin-top: 10px; color: white;"><strong>✅ Úspešne opravené všetky domény!</strong><br>Celkom opravených: ' + fixedCount + ' príspevkov</div>');
                $btn.hide();
                return;
            }
            
            var domain = window.wseo_broken_domains[index];
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'wseo_fix_media_links',
                    nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>',
                    old_domain: domain
                },
                success: function(response) {
                    if (response.success) {
                        fixedCount += response.data.updated;
                        $result.html('<div style="color: white; margin-top: 10px;">⏳ Opravujem... (' + (index + 1) + '/' + totalDomains + ')<br>Doteraz opravených: ' + fixedCount + ' príspevkov</div>');
                    }
                    // Continue with next domain
                    fixNextDomain(index + 1);
                },
                error: function() {
                    // Skip on error and continue
                    fixNextDomain(index + 1);
                }
            });
        }
        
        fixNextDomain(0);
    });
    
    // Scan duplicate slugs
    $('#wseo-scan-duplicate-slugs').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-duplicate-slugs-result');
        
        $btn.prop('disabled', true).text('🔍 Skenujem...');
        $result.html('<div style="color: white; margin-top: 10px;">Skenujem slugy...</div>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_scan_duplicate_slugs',
                nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div style="color: white; margin-top: 10px;">' + response.data.message + '</div>');
                    
                    if (response.data.count > 0) {
                        window.wseo_duplicate_count = response.data.count;
                    }
                } else {
                    $result.html('<div style="color: #ffeb3b; margin-top: 10px;">❌ ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).text('🔍 Nájsť duplicity');
            }
        });
    });
    
    // Fix all duplicates (manual cleanup info)
    $('#wseo-fix-all-duplicates').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-duplicate-slugs-result');
        
        if (!confirm('Automaticky opraviť všetky duplicitné slugy?\n\nUpozornenie: Toto odstráni čísla (-2, -3) zo slug a upraví URL adresy.')) {
            return;
        }
        
        $btn.prop('disabled', true).text('⏳ Opravujem...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_fix_duplicate_slugs',
                nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div style="background: rgba(76,175,80,0.3); padding: 15px; border-radius: 5px; margin-top: 10px; color: white;"><strong>' + response.data.message + '</strong></div>');
                } else {
                    $result.html('<div style="color: #ffeb3b; margin-top: 10px;">❌ Chyba: ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).text('✓ Opraviť všetko');
            }
        });
    });
    
    // Check UTF-8 encoding
    $('#wseo-check-encoding').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-encoding-result');
        
        $btn.prop('disabled', true).text('🔍 Kontrolujem...');
        $result.html('<div style="color: white; margin-top: 10px;">Kontrolujem kódovanie databázy...</div>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_check_encoding',
                nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div style="color: white; margin-top: 10px;">' + response.data.message + '</div>');
                } else {
                    $result.html('<div style="color: #ffeb3b; margin-top: 10px;">❌ ' + response.data + '</div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false).text('🔍 Skontrolovať kódovanie');
            }
        });
    });
    
    // Fix all encoding issues
    $('#wseo-fix-all-encoding').on('click', function() {
        var $btn = $(this);
        var $result = $('#wseo-encoding-result');
        
        if (!confirm('Konvertovať všetky tabuľky na UTF-8mb4?\n\n⚠️ Toto je NEVRATNÁ operácia!\n⚠️ Odporúčame vytvoriť zálohu databázy!')) {
            return;
        }
        
        $btn.prop('disabled', true).text('⏳ Konvertujem...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_fix_encoding',
                nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div style="background: rgba(76,175,80,0.3); padding: 15px; border-radius: 5px; margin-top: 10px; color: white;"><strong>' + response.data.message + '</strong><br><br>Odporúčanie: Vymažte všetky cache a otestujte web!</div>');
                    $btn.hide();
                } else {
                    $result.html('<div style="color: #ffeb3b; margin-top: 10px;">❌ Chyba: ' + response.data + '</div>');
                    $btn.prop('disabled', false).text('✓ Opraviť všetko');
                }
            }
        });
    });
});

// Helper function for inserting tags (outside jQuery ready)
function wseoInsertTag(tag) {
    // Find the focused input/textarea
    var $focused = jQuery('input:focus, textarea:focus');
    if ($focused.length) {
        var val = $focused.val();
        var cursorPos = $focused[0].selectionStart;
        $focused.val(val.substring(0, cursorPos) + tag + val.substring(cursorPos));
        $focused[0].selectionStart = $focused[0].selectionEnd = cursorPos + tag.length;
        $focused.focus();
    } else {
        // Default to alt template
        var $alt = jQuery('#wseo-template-alt');
        $alt.val($alt.val() + tag).focus();
    }
}
</script>

<style>
/* Auto Alt Text Styles */
.dashicons.spin {
    animation: wseo-spin 1s linear infinite;
}
@keyframes wseo-spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}
.wseo-tab-btn:hover {
    background: #f0f0f1 !important;
}
.wseo-tab-btn.active:hover {
    background: none !important;
}
</style>
