<?php
/**
 * Images Page Template
 * All image-related functions: optimization, ALT text, AVIF, WebP
 * 
 * @package WebStudio_SEO_Pro
 * @version 2.8.10
 */

if (!defined('ABSPATH')) exit;

// Get instance for method calls
$wseo = Webstudio_SEO_Pro::get_instance();

// Check AVIF support
$avif_supported = $wseo->is_avif_supported();
$supported_formats = $wseo->get_supported_image_formats();

// Get current settings
$template_alt = get_option('wseo_image_template_alt', '{parent_title}');
$template_title = get_option('wseo_image_template_title', '{parent_title}');
$template_caption = get_option('wseo_image_template_caption', '{parent_excerpt}');
$template_description = get_option('wseo_image_template_description', '{parent_description}');
$fallback_text = get_option('wseo_image_fallback_text', get_bloginfo('name'));
$generate_avif = get_option('wseo_generate_avif', '1');

?>

<div class="wrap wseo-admin-wrap">
    <h1 style="display: flex; align-items: center; gap: 10px;">
        <span style="font-size: 28px;">🖼️</span> Obrázky
    </h1>
    
    <p style="font-size: 14px; color: #666; margin: 10px 20px 25px;">
        Kompletná správa obrázkov - optimalizácia, ALT texty, WebP a AVIF konverzia, hromadné operácie.
    </p>

    <!-- Štatistiky obrázkov -->
    <div class="wseo-admin-card" style="margin: 0 20px 20px;">
        <h2 style="margin-top: 0;">📊 Štatistiky obrázkov</h2>
        
        <div id="wseo-image-stats">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 15px; margin-bottom: 25px;">
                <div style="background: #f0f0f1; padding: 20px; border-radius: 8px; text-align: center;">
                    <div style="font-size: 36px; font-weight: bold; color: #2271b1;" id="wseo-stat-total">-</div>
                    <div style="color: #666;">Celkom obrázkov</div>
                </div>
                <div style="background: #d4edda; padding: 20px; border-radius: 8px; text-align: center;">
                    <div style="font-size: 36px; font-weight: bold; color: #155724;" id="wseo-stat-complete">-</div>
                    <div style="color: #155724;">Kompletných</div>
                </div>
                <div style="background: #fff3cd; padding: 20px; border-radius: 8px; text-align: center;">
                    <div style="font-size: 36px; font-weight: bold; color: #856404;" id="wseo-stat-without-alt">-</div>
                    <div style="color: #856404;">Bez Alt textu</div>
                </div>
            </div>
            
            <!-- Progress bars -->
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div>
                    <div style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span><strong>Alternatívny text (Alt)</strong></span>
                            <span id="wseo-progress-alt">-/-</span>
                        </div>
                        <div style="background: #e0e0e0; height: 10px; border-radius: 5px; overflow: hidden;">
                            <div id="wseo-bar-alt" style="background: #4caf50; height: 100%; width: 0%; transition: width 0.3s;"></div>
                        </div>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span><strong>Nadpis</strong></span>
                            <span id="wseo-progress-title">-/-</span>
                        </div>
                        <div style="background: #e0e0e0; height: 10px; border-radius: 5px; overflow: hidden;">
                            <div id="wseo-bar-title" style="background: #4caf50; height: 100%; width: 0%; transition: width 0.3s;"></div>
                        </div>
                    </div>
                </div>
                <div>
                    <div style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span><strong>Popisok (Caption)</strong></span>
                            <span id="wseo-progress-caption">-/-</span>
                        </div>
                        <div style="background: #e0e0e0; height: 10px; border-radius: 5px; overflow: hidden;">
                            <div id="wseo-bar-caption" style="background: #ff9800; height: 100%; width: 0%; transition: width 0.3s;"></div>
                        </div>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span><strong>Popis</strong></span>
                            <span id="wseo-progress-desc">-/-</span>
                        </div>
                        <div style="background: #e0e0e0; height: 10px; border-radius: 5px; overflow: hidden;">
                            <div id="wseo-bar-desc" style="background: #ff9800; height: 100%; width: 0%; transition: width 0.3s;"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <button type="button" class="button button-secondary" id="wseo-refresh-image-stats">
                <span class="dashicons dashicons-update" style="margin-top: 3px;"></span> Obnoviť štatistiky
            </button>
        </div>
    </div>

    <!-- Podporované formáty -->
    <div class="wseo-admin-card" style="margin: 0 20px 20px;" style="margin-bottom: 20px;">
        <h2 style="margin-top: 0;">🎨 Podporované formáty</h2>
        
        <div style="display: flex; gap: 15px; flex-wrap: wrap; margin-bottom: 20px;">
            <div style="background: #d4edda; padding: 15px 25px; border-radius: 8px; display: flex; align-items: center; gap: 10px;">
                <span style="font-size: 24px;">✅</span>
                <div>
                    <strong>JPEG/PNG</strong><br>
                    <small style="color: #666;">Vždy podporované</small>
                </div>
            </div>
            <div style="background: <?php echo function_exists('imagewebp') ? '#d4edda' : '#f8d7da'; ?>; padding: 15px 25px; border-radius: 8px; display: flex; align-items: center; gap: 10px;">
                <span style="font-size: 24px;"><?php echo function_exists('imagewebp') ? '✅' : '❌'; ?></span>
                <div>
                    <strong>WebP</strong><br>
                    <small style="color: #666;"><?php echo function_exists('imagewebp') ? '25-35% menšie súbory' : 'Nie je podporované'; ?></small>
                </div>
            </div>
            <div style="background: <?php echo $avif_supported ? '#d4edda' : '#fff3cd'; ?>; padding: 15px 25px; border-radius: 8px; display: flex; align-items: center; gap: 10px;">
                <span style="font-size: 24px;"><?php echo $avif_supported ? '✅' : '⚠️'; ?></span>
                <div>
                    <strong>AVIF</strong><br>
                    <small style="color: #666;"><?php echo $avif_supported ? '30-50% lepšia kompresia ako WebP' : 'Vyžaduje PHP 8.1+ alebo ImageMagick'; ?></small>
                </div>
            </div>
        </div>
        
        <?php if ($avif_supported): ?>
        <div style="background: #e7f3ff; padding: 15px; border-radius: 4px; border-left: 4px solid #2271b1;">
            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                <input type="checkbox" id="wseo-generate-avif" <?php checked($generate_avif, '1'); ?>>
                <span><strong>Generovať AVIF verzie</strong> pri optimalizácii obrázkov (odporúčané)</span>
            </label>
        </div>
        <?php endif; ?>
    </div>

    <!-- Optimalizácia obrázkov -->
    <div class="wseo-admin-card" style="margin: 0 20px 20px;" style="margin-bottom: 20px;">
        <h2 style="margin-top: 0;">⚡ Optimalizácia obrázkov</h2>
        <p style="color: #666;">Komprimujte existujúce obrázky a vytvorte WebP/AVIF verzie pre lepší výkon stránky.</p>
        
        <button type="button" class="button button-primary" id="wseo-scan-images">
            <span class="dashicons dashicons-search" style="margin-top: 3px;"></span>
            Skenovať obrázky
        </button>
        <span class="spinner" style="float: none; margin: 0 10px;"></span>
        
        <div id="wseo-image-results" style="margin-top: 20px;"></div>
    </div>

    <!-- Šablóny pre automatické vyplňovanie -->
    <div class="wseo-admin-card" style="margin: 0 20px 20px;" style="margin-bottom: 20px;">
        <h2 style="margin-top: 0;">⚙️ Šablóny pre automatické vyplňovanie</h2>
        <p style="color: #666;">Nastavte šablóny, ktoré sa použijú pri automatickom vyplňovaní metadát obrázkov.</p>
        
        <table class="form-table">
            <tr>
                <th scope="row" style="width: 180px;">Šablóna Alt textu</th>
                <td>
                    <input type="text" id="wseo-template-alt" class="regular-text" 
                           value="<?php echo esc_attr($template_alt); ?>" 
                           style="width: 100%;">
                </td>
            </tr>
            <tr>
                <th scope="row">Šablóna Nadpisu</th>
                <td>
                    <input type="text" id="wseo-template-title" class="regular-text" 
                           value="<?php echo esc_attr($template_title); ?>" 
                           style="width: 100%;">
                </td>
            </tr>
            <tr>
                <th scope="row">Šablóna Popisku</th>
                <td>
                    <textarea id="wseo-template-caption" class="regular-text" rows="2" 
                              style="width: 100%;"><?php echo esc_textarea($template_caption); ?></textarea>
                </td>
            </tr>
            <tr>
                <th scope="row">Šablóna Popisu</th>
                <td>
                    <textarea id="wseo-template-description" class="regular-text" rows="2" 
                              style="width: 100%;"><?php echo esc_textarea($template_description); ?></textarea>
                </td>
            </tr>
            <tr>
                <th scope="row">Záložný text (Fallback)</th>
                <td>
                    <input type="text" id="wseo-fallback-text" class="regular-text" 
                           value="<?php echo esc_attr($fallback_text); ?>" 
                           style="width: 100%;">
                    <p class="description">Použije sa ak nie je možné určiť hodnotu z nadradeného príspevku.</p>
                </td>
            </tr>
        </table>
        
        <div style="background: #f0f6fc; padding: 20px; border-radius: 8px; margin: 20px 0;">
            <h4 style="margin-top: 0;">📋 Dostupné premenné (tagy)</h4>
            <div style="display: flex; flex-wrap: wrap; gap: 8px; margin-bottom: 15px;">
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{parent_title}">{parent_title}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{parent_excerpt}">{parent_excerpt}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{parent_description}">{parent_description}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{parent_category}">{parent_category}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{filename}">{filename}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{filename_clean}">{filename_clean}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{site_name}">{site_name}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{site_tagline}">{site_tagline}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{date}">{date}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{year}">{year}</code>
                <code class="wseo-tag-btn" style="background: #fff; padding: 6px 12px; border-radius: 4px; cursor: pointer; border: 1px solid #c3c4c7;" data-tag="{fallback}">{fallback}</code>
            </div>
            <div style="font-size: 12px; color: #666; line-height: 1.8;">
                <strong>{parent_title}</strong> – Názov nadradeného príspevku/stránky/produktu &nbsp;|&nbsp;
                <strong>{parent_excerpt}</strong> – Výňatok &nbsp;|&nbsp;
                <strong>{parent_description}</strong> – Meta popis &nbsp;|&nbsp;
                <strong>{parent_category}</strong> – Hlavná kategória<br>
                <strong>{filename}</strong> – Pôvodný názov súboru &nbsp;|&nbsp;
                <strong>{filename_clean}</strong> – Vyčistený názov (bez čísiel) &nbsp;|&nbsp;
                <strong>{site_name}</strong> – Názov webu &nbsp;|&nbsp;
                <strong>{site_tagline}</strong> – Slogan<br>
                <strong>{date}</strong> – Aktuálny dátum &nbsp;|&nbsp;
                <strong>{year}</strong> – Aktuálny rok &nbsp;|&nbsp;
                <strong>{fallback}</strong> – Záložný text
            </div>
        </div>
        
        <button type="button" class="button button-primary" id="wseo-save-templates">
            <span class="dashicons dashicons-saved" style="margin-top: 3px;"></span> Uložiť šablóny
        </button>
    </div>

    <!-- Hromadné operácie -->
    <div class="wseo-admin-card" style="margin: 0 20px 20px;" style="margin-bottom: 20px;">
        <h2 style="margin-top: 0;">🔄 Hromadné operácie</h2>
        <p style="color: #666;">Hromadne vyplňte alebo vymažte metadáta pre všetky obrázky v knižnici médií.</p>
        
        <!-- Tabs -->
        <div style="border-bottom: 2px solid #e0e0e0; margin-bottom: 20px; display: flex; flex-wrap: wrap;">
            <button type="button" class="wseo-tab-btn active" data-tab="fill-missing" style="background: none; border: none; padding: 12px 24px; cursor: pointer; border-bottom: 3px solid #2271b1; margin-bottom: -2px; color: #2271b1; font-weight: 600; font-size: 14px; display: inline-block;">
                ✏️ Vyplniť chýbajúce
            </button>
            <button type="button" class="wseo-tab-btn" data-tab="overwrite" style="background: none; border: none; padding: 12px 24px; cursor: pointer; color: #666; font-size: 14px; display: inline-block;">
                🔄 Prepísať všetko
            </button>
            <button type="button" class="wseo-tab-btn" data-tab="custom" style="background: none; border: none; padding: 12px 24px; cursor: pointer; color: #666; font-size: 14px; display: inline-block;">
                📝 Vlastný text
            </button>
            <button type="button" class="wseo-tab-btn" data-tab="clear" style="background: none; border: none; padding: 12px 24px; cursor: pointer; color: #d63638; font-size: 14px; display: inline-block;">
                🗑️ Vymazať
            </button>
        </div>
        
        <!-- Tab: Fill Missing -->
        <div class="wseo-tab-content" data-tab="fill-missing" style="display: block;">
            <div style="background: #e7f3ff; padding: 15px; border-left: 4px solid #2271b1; border-radius: 4px; margin-bottom: 20px;">
                <strong>ℹ️ Vyplní iba chýbajúce údaje</strong><br>
                <span style="color: #666;">Obrázky s už vyplnenými údajmi nebudú prepísané. Ručne vyplnené hodnoty zostanú zachované.</span>
            </div>
            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="alt" data-mode="missing">Vyplniť Alt text</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="title" data-mode="missing">Vyplniť Nadpis</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="caption" data-mode="missing">Vyplniť Popisok</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="description" data-mode="missing">Vyplniť Popis</button>
                <button type="button" class="button button-primary wseo-fill-btn" data-type="all" data-mode="missing" style="margin-left: 10px;">
                    <strong>Vyplniť všetko</strong>
                </button>
            </div>
        </div>
        
        <!-- Tab: Overwrite -->
        <div class="wseo-tab-content" data-tab="overwrite" style="display: none;">
            <div style="background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; border-radius: 4px; margin-bottom: 20px;">
                <strong>⚠️ Prepíše VŠETKY existujúce údaje</strong><br>
                <span style="color: #666;">Táto akcia prepíše aj ručne vyplnené hodnoty! Používajte opatrne.</span>
            </div>
            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="alt" data-mode="overwrite">Prepísať Alt text</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="title" data-mode="overwrite">Prepísať Nadpis</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="caption" data-mode="overwrite">Prepísať Popisok</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="description" data-mode="overwrite">Prepísať Popis</button>
                <button type="button" class="button button-primary wseo-fill-btn" data-type="all" data-mode="overwrite" style="margin-left: 10px;">
                    <strong>Prepísať všetko</strong>
                </button>
            </div>
        </div>
        
        <!-- Tab: Custom Text -->
        <div class="wseo-tab-content" data-tab="custom" style="display: none;">
            <div style="background: #e7f3ff; padding: 15px; border-left: 4px solid #2271b1; border-radius: 4px; margin-bottom: 20px;">
                <strong>📝 Použiť vlastný text pre všetky obrázky</strong><br>
                <span style="color: #666;">Môžete použiť premenné ako {parent_title}, {site_name}, atď.</span>
            </div>
            <div style="margin-bottom: 20px;">
                <label><strong>Vlastný text:</strong></label>
                <input type="text" id="wseo-custom-text" class="regular-text" style="width: 100%; margin-top: 8px; padding: 10px;" placeholder="Napr: {parent_title} - {site_name}">
            </div>
            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="alt" data-mode="custom">Nastaviť Alt text</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="title" data-mode="custom">Nastaviť Nadpis</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="caption" data-mode="custom">Nastaviť Popisok</button>
                <button type="button" class="button button-secondary wseo-fill-btn" data-type="description" data-mode="custom">Nastaviť Popis</button>
            </div>
        </div>
        
        <!-- Tab: Clear -->
        <div class="wseo-tab-content" data-tab="clear" style="display: none;">
            <div style="background: #f8d7da; padding: 15px; border-left: 4px solid #d63638; border-radius: 4px; margin-bottom: 20px;">
                <strong>🗑️ POZOR: Vymaže údaje zo všetkých obrázkov!</strong><br>
                <span style="color: #666;">Táto akcia je nevratná. Uistite sa, že máte zálohu databázy.</span>
            </div>
            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                <button type="button" class="button wseo-clear-btn" data-type="alt" style="color: #d63638; border-color: #d63638;">Vymazať Alt text</button>
                <button type="button" class="button wseo-clear-btn" data-type="title" style="color: #d63638; border-color: #d63638;">Vymazať Nadpis</button>
                <button type="button" class="button wseo-clear-btn" data-type="caption" style="color: #d63638; border-color: #d63638;">Vymazať Popisok</button>
                <button type="button" class="button wseo-clear-btn" data-type="description" style="color: #d63638; border-color: #d63638;">Vymazať Popis</button>
                <button type="button" class="button wseo-clear-btn" data-type="all" style="background: #d63638; color: white; border-color: #d63638; margin-left: 10px;">
                    <strong>Vymazať všetko</strong>
                </button>
            </div>
        </div>
        
        <!-- Progress -->
        <div id="wseo-bulk-progress" style="display: none; margin-top: 25px; background: #f9f9f9; padding: 20px; border-radius: 8px;">
            <div style="display: flex; align-items: center; gap: 15px; margin-bottom: 10px;">
                <div class="spinner is-active" style="float: none; margin: 0;"></div>
                <span id="wseo-bulk-progress-text" style="font-weight: 500;">Spracúvanie...</span>
            </div>
            <div style="background: #e0e0e0; height: 24px; border-radius: 12px; overflow: hidden;">
                <div id="wseo-bulk-progress-bar" style="background: linear-gradient(90deg, #667eea, #764ba2); height: 100%; width: 0%; transition: width 0.3s; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 12px;"></div>
            </div>
        </div>
    </div>

    <!-- Automatické nastavenia -->
    <div class="wseo-admin-card" style="margin: 0 20px 20px;">
        <h2 style="margin-top: 0;">🤖 Automatické vyplňovanie</h2>
        <div style="background: #d4edda; border: 1px solid #c3e6cb; border-radius: 5px; padding: 15px; margin-bottom: 15px;">
            <strong style="color: #155724;">✅ Plne automatické - žiadna konfigurácia!</strong>
            <p style="color: #155724; margin: 10px 0 0;">
                Pri nahraní každého obrázka sa automaticky vyplní:
            </p>
            <ul style="color: #155724; margin: 10px 0 0; padding-left: 20px;">
                <li><strong>Alt text</strong> - z názvu článku/stránky</li>
                <li><strong>Nadpis</strong> - z názvu článku/stránky</li>
                <li><strong>Popisok (Caption)</strong> - z obsahu článku</li>
                <li><strong>Popis (Description)</strong> - z obsahu článku</li>
            </ul>
        </div>
        <p style="color: #666; font-size: 13px;">
            💡 <strong>Tip:</strong> Ak chcete vlastný text, jednoducho ho prepíšte v Knižnici médií.
        </p>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    
    // Load stats on page load
    wseoLoadImageStats();
    
    function wseoLoadImageStats() {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_get_image_stats',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    var d = response.data;
                    $('#wseo-stat-total').text(d.total.toLocaleString());
                    $('#wseo-stat-complete').text(d.complete.toLocaleString());
                    $('#wseo-stat-without-alt').text(d.without_alt.toLocaleString());
                    
                    var altPct = d.total > 0 ? (d.with_alt / d.total * 100) : 0;
                    var titlePct = d.total > 0 ? (d.with_title / d.total * 100) : 0;
                    var captionPct = d.total > 0 ? (d.with_caption / d.total * 100) : 0;
                    var descPct = d.total > 0 ? (d.with_description / d.total * 100) : 0;
                    
                    $('#wseo-bar-alt').css('width', altPct + '%');
                    $('#wseo-bar-title').css('width', titlePct + '%');
                    $('#wseo-bar-caption').css('width', captionPct + '%');
                    $('#wseo-bar-desc').css('width', descPct + '%');
                    
                    $('#wseo-progress-alt').text(d.with_alt.toLocaleString() + '/' + d.total.toLocaleString());
                    $('#wseo-progress-title').text(d.with_title.toLocaleString() + '/' + d.total.toLocaleString());
                    $('#wseo-progress-caption').text(d.with_caption.toLocaleString() + '/' + d.total.toLocaleString());
                    $('#wseo-progress-desc').text(d.with_description.toLocaleString() + '/' + d.total.toLocaleString());
                }
            }
        });
    }
    
    // Refresh stats
    $('#wseo-refresh-image-stats').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).find('.dashicons').addClass('wseo-spin');
        wseoLoadImageStats();
        setTimeout(function() {
            $btn.prop('disabled', false).find('.dashicons').removeClass('wseo-spin');
        }, 1000);
    });
    
    // Tab switching
    $('.wseo-tab-btn').on('click', function() {
        var tab = $(this).data('tab');
        $('.wseo-tab-btn').removeClass('active').css({
            'border-bottom': 'none',
            'color': tab === 'clear' ? '#d63638' : '#666',
            'font-weight': 'normal'
        });
        $(this).addClass('active').css({
            'border-bottom': '3px solid ' + (tab === 'clear' ? '#d63638' : '#2271b1'),
            'color': tab === 'clear' ? '#d63638' : '#2271b1',
            'font-weight': '600'
        });
        $('.wseo-tab-content').hide();
        $('.wseo-tab-content[data-tab="' + tab + '"]').show();
    });
    
    // Tag buttons
    $('.wseo-tag-btn').on('click', function() {
        var tag = $(this).data('tag');
        var $focused = $('input:focus, textarea:focus');
        if ($focused.length) {
            var val = $focused.val();
            var pos = $focused[0].selectionStart || val.length;
            $focused.val(val.substring(0, pos) + tag + val.substring(pos));
            $focused[0].selectionStart = $focused[0].selectionEnd = pos + tag.length;
            $focused.focus();
        } else {
            var $alt = $('#wseo-template-alt');
            $alt.val($alt.val() + tag).focus();
        }
    });
    
    // Save templates
    $('#wseo-save-templates').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).html('<span class="spinner is-active" style="float:none;margin:0 5px 0 0;"></span> Ukladám...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_save_image_templates',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                template_alt: $('#wseo-template-alt').val(),
                template_title: $('#wseo-template-title').val(),
                template_caption: $('#wseo-template-caption').val(),
                template_description: $('#wseo-template-description').val(),
                fallback_text: $('#wseo-fallback-text').val()
            },
            success: function(response) {
                $btn.html('<span class="dashicons dashicons-yes" style="margin-top:3px;"></span> Uložené!');
                setTimeout(function() {
                    $btn.html('<span class="dashicons dashicons-saved" style="margin-top:3px;"></span> Uložiť šablóny').prop('disabled', false);
                }, 2000);
            }
        });
    });
    
    // Save auto settings
    $('#wseo-save-auto-settings').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin" style="margin-top:3px;"></span> Ukladám...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_save_auto_settings',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                auto_alt: $('#wseo-auto-alt').is(':checked') ? '1' : '0',
                auto_title: $('#wseo-auto-title').is(':checked') ? '1' : '0',
                auto_caption: $('#wseo-auto-caption').is(':checked') ? '1' : '0',
                auto_description: $('#wseo-auto-description').is(':checked') ? '1' : '0'
            },
            success: function(response) {
                if (response.success) {
                    $btn.html('<span class="dashicons dashicons-yes" style="margin-top:3px;"></span> Uložené!');
                    console.log('WSEO Auto-fill saved:', response.data);
                } else {
                    $btn.html('<span class="dashicons dashicons-no" style="margin-top:3px;"></span> Chyba!');
                    console.error('WSEO Save error:', response);
                }
                setTimeout(function() {
                    $btn.html('<span class="dashicons dashicons-saved" style="margin-top:3px;"></span> Uložiť nastavenia').prop('disabled', false);
                }, 2000);
            },
            error: function(xhr, status, error) {
                $btn.html('<span class="dashicons dashicons-no" style="margin-top:3px;"></span> Chyba!');
                console.error('WSEO AJAX error:', error);
                setTimeout(function() {
                    $btn.html('<span class="dashicons dashicons-saved" style="margin-top:3px;"></span> Uložiť nastavenia').prop('disabled', false);
                }, 2000);
            }
        });
    });
    
    // AVIF toggle
    $('#wseo-generate-avif').on('change', function() {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_save_avif_setting',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                generate_avif: $(this).is(':checked') ? '1' : '0'
            }
        });
    });
    
    // Scan images
    $('#wseo-scan-images').on('click', function() {
        var $btn = $(this);
        var $spinner = $btn.siblings('.spinner');
        var $result = $('#wseo-image-results');
        
        $btn.prop('disabled', true);
        $spinner.addClass('is-active');
        $result.html('<p>Skenujem obrázky...</p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_maintenance_scan_images',
                nonce: '<?php echo wp_create_nonce('wseo_maintenance'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $result.html(response.data.html);
                } else {
                    $result.html('<div class="notice notice-error"><p>' + response.data + '</p></div>');
                }
            },
            complete: function() {
                $btn.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });
    
    // Bulk fill buttons
    $('.wseo-fill-btn').on('click', function() {
        var type = $(this).data('type');
        var mode = $(this).data('mode');
        var customText = mode === 'custom' ? $('#wseo-custom-text').val() : '';
        
        if (mode === 'custom' && !customText) {
            alert('Zadajte vlastný text.');
            return;
        }
        
        if (mode === 'overwrite' && !confirm('Prepísať VŠETKY existujúce údaje? Táto akcia je nevratná!')) {
            return;
        }
        
        wseoBulkFillImages(type, mode, customText, 0, 0);
    });
    
    // Clear buttons
    $('.wseo-clear-btn').on('click', function() {
        var type = $(this).data('type');
        
        if (!confirm('Ste si istí, že chcete vymazať údaje? Táto akcia je nevratná!')) {
            return;
        }
        
        var $progress = $('#wseo-bulk-progress');
        $progress.show();
        $('#wseo-bulk-progress-text').text('Mazanie...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_clear_image_metadata',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                type: type
            },
            success: function(response) {
                if (response.success) {
                    $('#wseo-bulk-progress-bar').css('width', '100%');
                    $('#wseo-bulk-progress-text').text('✓ Vymazané: ' + response.data.cleared + ' záznamov');
                    wseoLoadImageStats();
                    setTimeout(function() { $progress.hide(); }, 3000);
                }
            }
        });
    });
    
    // Bulk fill with progress
    function wseoBulkFillImages(type, mode, customText, offset, totalFilled) {
        var $progress = $('#wseo-bulk-progress');
        $progress.show();
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_bulk_fill_images',
                nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>',
                type: type,
                mode: mode,
                custom_text: customText,
                batch_size: 50,
                offset: offset
            },
            success: function(response) {
                if (response.success) {
                    var d = response.data;
                    totalFilled += d.filled;
                    
                    if (d.completed) {
                        $('#wseo-bulk-progress-bar').css('width', '100%').text('100%');
                        $('#wseo-bulk-progress-text').text('✓ Hotovo! Vyplnené: ' + totalFilled + ' položiek');
                        wseoLoadImageStats();
                        setTimeout(function() { $progress.hide(); }, 3000);
                    } else {
                        var processed = offset + d.processed;
                        var pct = Math.min(95, Math.round(processed / 100));
                        $('#wseo-bulk-progress-bar').css('width', pct + '%').text(pct + '%');
                        $('#wseo-bulk-progress-text').text('Spracované: ' + processed + ' obrázkov...');
                        wseoBulkFillImages(type, mode, customText, d.next_offset, totalFilled);
                    }
                }
            },
            error: function() {
                $('#wseo-bulk-progress-text').text('Chyba pri spracovaní!');
            }
        });
    }
});
</script>

<style>
.wseo-admin-wrap .wseo-card {
    background: #fff;
    border: 1px solid #c3c4c7;
    border-radius: 8px;
    padding: 25px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.04);
}
.wseo-admin-wrap .form-table th {
    padding: 15px 10px 15px 0;
}
.wseo-admin-wrap .form-table td {
    padding: 15px 10px;
}
.wseo-admin-wrap .wseo-tag-btn:hover {
    background: #f0f6fc !important;
    border-color: #2271b1 !important;
}
.wseo-admin-wrap .wseo-tab-btn:hover {
    background: #f0f0f1 !important;
}
.wseo-admin-wrap .wseo-tab-btn.active:hover {
    background: none !important;
}
.wseo-spin {
    animation: wseo-spin 1s linear infinite;
}
@keyframes wseo-spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}
</style>
