<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wrap wseo-admin-wrap">
    <h1>🌍 Globálne SEO nastavenia</h1>
    
    <form method="post" action="">
        <?php wp_nonce_field('wseo_global_settings'); ?>
        
        <div class="wseo-admin-card">
            <h2>📝 Základné nastavenia</h2>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_global_site_name">Názov webu</label></th>
                    <td>
                        <input type="text" id="wseo_global_site_name" name="wseo_global_site_name" 
                               value="<?php echo esc_attr(get_option('wseo_global_site_name', get_bloginfo('name'))); ?>" 
                               class="regular-text">
                        <p class="description">Použije sa v Open Graph tagoch a ako sufix pre Meta Title.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_title_separator">Oddeľovač v titulku</label></th>
                    <td>
                        <select id="wseo_title_separator" name="wseo_title_separator">
                            <?php $sep = get_option('wseo_title_separator', ' - '); ?>
                            <option value=" - " <?php selected($sep, ' - '); ?>>- (pomlčka)</option>
                            <option value=" | " <?php selected($sep, ' | '); ?>>| (zvislá čiara)</option>
                            <option value=" · " <?php selected($sep, ' · '); ?>>· (bodka)</option>
                            <option value=" » " <?php selected($sep, ' » '); ?>>> (šípka)</option>
                            <option value=" — " <?php selected($sep, ' — '); ?>>— (dlhá pomlčka)</option>
                        </select>
                        <p class="description">Oddeľovač medzi názvom stránky a názvom webu. Príklad: "Kontakt <strong>-</strong> Webstudio"</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_global_home_title">Meta Title domovskej stránky</label></th>
                    <td>
                        <input type="text" id="wseo_global_home_title" name="wseo_global_home_title" 
                               value="<?php echo esc_attr(get_option('wseo_global_home_title', get_bloginfo('name') . ' - ' . get_bloginfo('description'))); ?>" 
                               class="large-text">
                        <p class="description">Optimálna dĺžka: 50-60 znakov.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_global_home_description">Meta Description domovskej stránky</label></th>
                    <td>
                        <textarea id="wseo_global_home_description" name="wseo_global_home_description" 
                                  rows="3" class="large-text"><?php echo esc_textarea(get_option('wseo_global_home_description', get_bloginfo('description'))); ?></textarea>
                        <p class="description">Optimálna dĺžka: 120-160 znakov.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_global_home_keywords">Meta Keywords domovskej stránky</label></th>
                    <td>
                        <input type="text" id="wseo_global_home_keywords" name="wseo_global_home_keywords" 
                               value="<?php echo esc_attr(get_option('wseo_global_home_keywords', '')); ?>"
                               class="large-text" placeholder="napr. tvorba webstránok Bratislava">
                        <p class="description" style="color: #2271b1;">
                            <strong>💡 TIP:</strong> Zadajte len 1 presnú long tail frázu, nie zoznam slov. Menej je viac!
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">

            <h2>🏢 Schema.org - Organizácia / Local Business</h2>
            <p class="description" style="margin-bottom: 15px;">
                Schema.org štruktúrované dáta pomáhajú vyhľadávačom lepšie pochopiť váš web a zobraziť bohatšie výsledky.
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_schema_type">Typ organizácie</label></th>
                    <td>
                        <select id="wseo_schema_type" name="wseo_schema_type" class="regular-text">
                            <?php $schema_type = get_option('wseo_schema_type', 'Organization'); ?>
                            
                            <optgroup label="🏢 Základné typy">
                                <option value="Organization" <?php selected($schema_type, 'Organization'); ?>>Organizácia (všeobecná)</option>
                                <option value="NewsMediaOrganization" <?php selected($schema_type, 'NewsMediaOrganization'); ?>>Spravodajský portál</option>
                                <option value="LocalBusiness" <?php selected($schema_type, 'LocalBusiness'); ?>>Lokálny podnik</option>
                            </optgroup>
                            
                            <optgroup label="🔨 Stavebníctvo & Domácnosť">
                                <option value="Electrician" <?php selected($schema_type, 'Electrician'); ?>>Elektrikár</option>
                                <option value="GeneralContractor" <?php selected($schema_type, 'GeneralContractor'); ?>>Stavebný dodávateľ</option>
                                <option value="HVACBusiness" <?php selected($schema_type, 'HVACBusiness'); ?>>Kúrenie, vzduchotechnika</option>
                                <option value="HousePainter" <?php selected($schema_type, 'HousePainter'); ?>>Maliar</option>
                                <option value="Locksmith" <?php selected($schema_type, 'Locksmith'); ?>>Zámočník</option>
                                <option value="MovingCompany" <?php selected($schema_type, 'MovingCompany'); ?>>Sťahovacia firma</option>
                                <option value="Plumber" <?php selected($schema_type, 'Plumber'); ?>>Inštalatér</option>
                                <option value="RoofingContractor" <?php selected($schema_type, 'RoofingContractor'); ?>>Pokrývač striech</option>
                            </optgroup>
                            
                            <optgroup label="🚗 Automotive">
                                <option value="AutoRepair" <?php selected($schema_type, 'AutoRepair'); ?>>Autoservis</option>
                                <option value="AutoBodyShop" <?php selected($schema_type, 'AutoBodyShop'); ?>>Autolakovňa</option>
                                <option value="AutoPartsStore" <?php selected($schema_type, 'AutoPartsStore'); ?>>Náhradné diely</option>
                                <option value="AutoRental" <?php selected($schema_type, 'AutoRental'); ?>>Autopožičovňa</option>
                                <option value="AutoWash" <?php selected($schema_type, 'AutoWash'); ?>>Autoumyváreň</option>
                                <option value="GasStation" <?php selected($schema_type, 'GasStation'); ?>>Čerpacia stanica</option>
                                <option value="MotorcycleDealer" <?php selected($schema_type, 'MotorcycleDealer'); ?>>Predajca motoriek</option>
                                <option value="MotorcycleRepair" <?php selected($schema_type, 'MotorcycleRepair'); ?>>Oprava motoriek</option>
                            </optgroup>
                            
                            <optgroup label="🍽️ Stravovanie">
                                <option value="Restaurant" <?php selected($schema_type, 'Restaurant'); ?>>Reštaurácia</option>
                                <option value="Bakery" <?php selected($schema_type, 'Bakery'); ?>>Pekáreň</option>
                                <option value="BarOrPub" <?php selected($schema_type, 'BarOrPub'); ?>>Bar / Pub</option>
                                <option value="Brewery" <?php selected($schema_type, 'Brewery'); ?>>Pivovar</option>
                                <option value="CafeOrCoffeeShop" <?php selected($schema_type, 'CafeOrCoffeeShop'); ?>>Kaviareň</option>
                                <option value="FastFoodRestaurant" <?php selected($schema_type, 'FastFoodRestaurant'); ?>>Rýchle občerstvenie</option>
                                <option value="IceCreamShop" <?php selected($schema_type, 'IceCreamShop'); ?>>Zmrzlináreň</option>
                                <option value="Winery" <?php selected($schema_type, 'Winery'); ?>>Vinárstvo</option>
                                <option value="Distillery" <?php selected($schema_type, 'Distillery'); ?>>Liehovár</option>
                            </optgroup>
                            
                            <optgroup label="🏨 Ubytovanie">
                                <option value="Hotel" <?php selected($schema_type, 'Hotel'); ?>>Hotel</option>
                                <option value="LodgingBusiness" <?php selected($schema_type, 'LodgingBusiness'); ?>>Ubytovanie (všeobecné)</option>
                                <option value="BedAndBreakfast" <?php selected($schema_type, 'BedAndBreakfast'); ?>>Penzión (B&B)</option>
                                <option value="VacationRental" <?php selected($schema_type, 'VacationRental'); ?>>Dovolenková nehnuteľnosť</option>
                                <option value="Campground" <?php selected($schema_type, 'Campground'); ?>>Kemping</option>
                                <option value="Hostel" <?php selected($schema_type, 'Hostel'); ?>>Hostel</option>
                                <option value="Motel" <?php selected($schema_type, 'Motel'); ?>>Motel</option>
                                <option value="Resort" <?php selected($schema_type, 'Resort'); ?>>Resort</option>
                                <option value="SkiResort" <?php selected($schema_type, 'SkiResort'); ?>>Lyžiarsky rezort</option>
                            </optgroup>
                            
                            <optgroup label="💅 Krása & Wellness">
                                <option value="BeautySalon" <?php selected($schema_type, 'BeautySalon'); ?>>Kozmetický salón</option>
                                <option value="HairSalon" <?php selected($schema_type, 'HairSalon'); ?>>Kaderníctvo</option>
                                <option value="DaySpa" <?php selected($schema_type, 'DaySpa'); ?>>Wellness / Spa</option>
                                <option value="HealthAndBeautyBusiness" <?php selected($schema_type, 'HealthAndBeautyBusiness'); ?>>Krása a zdravie</option>
                                <option value="NailSalon" <?php selected($schema_type, 'NailSalon'); ?>>Nechtový salón</option>
                                <option value="TattooParlor" <?php selected($schema_type, 'TattooParlor'); ?>>Tetovací salón</option>
                            </optgroup>
                            
                            <optgroup label="🛒 Obchody">
                                <option value="Store" <?php selected($schema_type, 'Store'); ?>>Obchod (všeobecný)</option>
                                <option value="BikeStore" <?php selected($schema_type, 'BikeStore'); ?>>Bicykle</option>
                                <option value="BookStore" <?php selected($schema_type, 'BookStore'); ?>>Kníhkupectvo</option>
                                <option value="ClothingStore" <?php selected($schema_type, 'ClothingStore'); ?>>Oblečenie</option>
                                <option value="ComputerStore" <?php selected($schema_type, 'ComputerStore'); ?>>Počítače</option>
                                <option value="ConvenienceStore" <?php selected($schema_type, 'ConvenienceStore'); ?>>Večierka</option>
                                <option value="DepartmentStore" <?php selected($schema_type, 'DepartmentStore'); ?>>Obchodný dom</option>
                                <option value="ElectronicsStore" <?php selected($schema_type, 'ElectronicsStore'); ?>>Elektronika</option>
                                <option value="Florist" <?php selected($schema_type, 'Florist'); ?>>Kvetinárstvo</option>
                                <option value="FurnitureStore" <?php selected($schema_type, 'FurnitureStore'); ?>>Nábytok</option>
                                <option value="GardenStore" <?php selected($schema_type, 'GardenStore'); ?>>Záhradníctvo</option>
                                <option value="GroceryStore" <?php selected($schema_type, 'GroceryStore'); ?>>Potraviny</option>
                                <option value="HardwareStore" <?php selected($schema_type, 'HardwareStore'); ?>>Železiarstvo</option>
                                <option value="HobbyShop" <?php selected($schema_type, 'HobbyShop'); ?>>Hobby</option>
                                <option value="HomeGoodsStore" <?php selected($schema_type, 'HomeGoodsStore'); ?>>Domáce potreby</option>
                                <option value="JewelryStore" <?php selected($schema_type, 'JewelryStore'); ?>>Zlatníctvo</option>
                                <option value="LiquorStore" <?php selected($schema_type, 'LiquorStore'); ?>>Predaj alkoholu</option>
                                <option value="MensClothingStore" <?php selected($schema_type, 'MensClothingStore'); ?>>Pánske oblečenie</option>
                                <option value="MobilePhoneStore" <?php selected($schema_type, 'MobilePhoneStore'); ?>>Mobilné telefóny</option>
                                <option value="MusicStore" <?php selected($schema_type, 'MusicStore'); ?>>Hudobný obchod</option>
                                <option value="OfficeEquipmentStore" <?php selected($schema_type, 'OfficeEquipmentStore'); ?>>Kancelárske potreby</option>
                                <option value="OutletStore" <?php selected($schema_type, 'OutletStore'); ?>>Outlet</option>
                                <option value="PawnShop" <?php selected($schema_type, 'PawnShop'); ?>>Záložňa</option>
                                <option value="PetStore" <?php selected($schema_type, 'PetStore'); ?>>Zvieratká</option>
                                <option value="ShoeStore" <?php selected($schema_type, 'ShoeStore'); ?>>Obuv</option>
                                <option value="SportingGoodsStore" <?php selected($schema_type, 'SportingGoodsStore'); ?>>Športové potreby</option>
                                <option value="TireShop" <?php selected($schema_type, 'TireShop'); ?>>Pneumatiky</option>
                                <option value="ToyStore" <?php selected($schema_type, 'ToyStore'); ?>>Hračkárstvo</option>
                                <option value="WholesaleStore" <?php selected($schema_type, 'WholesaleStore'); ?>>Veľkoobchod</option>
                            </optgroup>
                            
                            <optgroup label="⚖️ Profesionálne služby">
                                <option value="ProfessionalService" <?php selected($schema_type, 'ProfessionalService'); ?>>Profesionálne služby</option>
                                <option value="LegalService" <?php selected($schema_type, 'LegalService'); ?>>Právne služby</option>
                                <option value="FinancialService" <?php selected($schema_type, 'FinancialService'); ?>>Finančné služby</option>
                                <option value="RealEstateAgent" <?php selected($schema_type, 'RealEstateAgent'); ?>>Reality</option>
                            </optgroup>
                            
                            <optgroup label="🏥 Zdravotníctvo">
                                <option value="MedicalBusiness" <?php selected($schema_type, 'MedicalBusiness'); ?>>Zdravotníctvo (všeobecné)</option>
                                <option value="Dentist" <?php selected($schema_type, 'Dentist'); ?>>Zubár</option>
                            </optgroup>
                        </select>
                        <p class="description">Vyberte čo najpresnejší typ pre vašu firmu. Schema.org 2026 štandard.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_schema_name">Názov firmy</label></th>
                    <td>
                        <input type="text" id="wseo_schema_name" name="wseo_schema_name" 
                               value="<?php echo esc_attr(get_option('wseo_schema_name', get_option('wseo_global_site_name', get_bloginfo('name')))); ?>" 
                               class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_schema_logo">Logo URL</label></th>
                    <td>
                        <input type="url" id="wseo_schema_logo" name="wseo_schema_logo" 
                               value="<?php echo esc_url(get_option('wseo_schema_logo', '')); ?>" 
                               class="large-text" placeholder="https://example.com/logo.png">
                        <p class="description">Odporúčaná veľkosť: min. 112×112 px, max. 1 MB. Vložte URL obrázka.</p>
                        
                        <?php if (get_option('wseo_schema_logo')): ?>
                        <div class="wseo-image-preview" style="margin-top: 10px;">
                            <img src="<?php echo esc_url(get_option('wseo_schema_logo')); ?>" alt="">
                        </div>
                        <?php endif; ?>
                    </td>
                </tr>
                
                <tr>
                    <th><label for="wseo_schema_image">🖼️ Obrázok organizácie</label></th>
                    <td>
                        <input type="url" id="wseo_schema_image" name="wseo_schema_image" 
                               value="<?php echo esc_url(get_option('wseo_schema_image', '')); ?>" 
                               class="large-text" placeholder="https://example.com/predajna.jpg">
                        <p class="description">
                            <strong>image</strong> - Fotka predajne, budovy, tímu alebo produktu. Ak nevyplníte, použije sa logo.<br>
                            <span style="color: #666;">💡 Tip: Použite reprezentatívnu fotku vašej firmy pre lepšie zobrazenie vo výsledkoch vyhľadávania.</span>
                        </p>
                        
                        <?php if (get_option('wseo_schema_image')): ?>
                        <div class="wseo-image-preview" style="margin-top: 10px;">
                            <img src="<?php echo esc_url(get_option('wseo_schema_image')); ?>" alt="" style="max-width: 300px;">
                        </div>
                        <?php endif; ?>
                    </td>
                </tr>
                
                <tr>
                    <th colspan="2" style="background: #fff3cd; padding: 10px; border-left: 4px solid #ffc107;">
                        <strong>📷 Metadáta loga (Search Console požiadavky)</strong>
                        <p style="margin: 5px 0 0; font-weight: normal; color: #666;">
                            Google Search Console vyžaduje tieto 3 polia pre všetky ImageObject schémy.
                        </p>
                    </th>
                </tr>
                
                <tr>
                    <th><label for="wseo_logo_credit">Autor / Zdroj loga <span style="color: #d63638;">*</span></label></th>
                    <td>
                        <input type="text" id="wseo_logo_credit" name="wseo_logo_credit" 
                               value="<?php echo esc_attr(get_option('wseo_logo_credit', get_bloginfo('name'))); ?>" 
                               class="regular-text" placeholder="<?php echo esc_attr(get_bloginfo('name')); ?>">
                        <p class="description">
                            <strong>creditText</strong> - Uvádza, kto vytvoril alebo vlastní logo (napr. názov vašej firmy, dizajnér).
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th><label for="wseo_logo_license">URL licencie <span style="color: #d63638;">*</span></label></th>
                    <td>
                        <input type="url" id="wseo_logo_license" name="wseo_logo_license" 
                               value="<?php echo esc_url(get_option('wseo_logo_license', 'https://creativecommons.org/licenses/by/4.0/')); ?>" 
                               class="large-text" placeholder="https://creativecommons.org/licenses/by/4.0/">
                        <p class="description">
                            <strong>license</strong> - URL Creative Commons alebo vlastnej licencie.<br>
                            Príklady: <code>https://creativecommons.org/licenses/by/4.0/</code> (CC BY 4.0), 
                            <code>https://creativecommons.org/publicdomain/zero/1.0/</code> (CC0 Public Domain)
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th><label for="wseo_logo_license_page">Stránka s licenciou <span style="color: #d63638;">*</span></label></th>
                    <td>
                        <input type="url" id="wseo_logo_license_page" name="wseo_logo_license_page" 
                               value="<?php echo esc_url(get_option('wseo_logo_license_page', home_url('/image-licenses/'))); ?>" 
                               class="large-text" placeholder="<?php echo home_url('/image-licenses/'); ?>">
                        <p class="description">
                            <strong>acquireLicensePage</strong> - URL stránky, kde je možné získať licenciu alebo info o používaní.<br>
                            <strong>Vytvorte stránku</strong> na adrese <code><?php echo home_url('/image-licenses/'); ?></code> s informáciami o licenciách vašich obrázkov a loga.
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th><label for="wseo_logo_creator">Tvorca/Autor obrázka</label></th>
                    <td>
                        <input type="text" id="wseo_logo_creator" name="wseo_logo_creator" 
                               value="<?php echo esc_attr(get_option('wseo_logo_creator', '')); ?>" 
                               class="regular-text" placeholder="napr. Jan Novák, Grafické štúdio XY">
                        <p class="description">
                            <strong>creator</strong> - Nepovinné pole. Meno osoby alebo organizácie, ktorá vytvorila obrázok/logo.<br>
                            Príklad: <code>Jan Novák</code>, <code>Design Studio s.r.o.</code>
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th><label for="wseo_logo_copyright_notice">Copyright oznámenie</label></th>
                    <td>
                        <input type="text" id="wseo_logo_copyright_notice" name="wseo_logo_copyright_notice" 
                               value="<?php echo esc_attr(get_option('wseo_logo_copyright_notice', '')); ?>" 
                               class="regular-text" placeholder="napr. © 2025 Webstudio.ltd. Všetky práva vyhradené.">
                        <p class="description">
                            <strong>copyrightNotice</strong> - Nepovinné pole. Text s informáciou o autorských právach.<br>
                            Príklad: <code>© 2025 Moja firma s.r.o.</code>, <code>All rights reserved</code>
                        </p>
                    </td>
                </tr>
                
                <!-- Contact fields: ALL schemas -->
                <tr data-schema="contact">
                    <th><label for="wseo_schema_phone">Telefón</label></th>
                    <td>
                        <input type="tel" id="wseo_schema_phone" name="wseo_schema_phone" 
                               value="<?php echo esc_attr(get_option('wseo_schema_phone', '')); ?>" 
                               class="regular-text" placeholder="+421 900 123 456">
                        <p class="description">Voliteľné pre Organization, povinné pre LocalBusiness.</p>
                    </td>
                </tr>
                <tr data-schema="contact">
                    <th><label for="wseo_schema_email">Email</label></th>
                    <td>
                        <input type="email" id="wseo_schema_email" name="wseo_schema_email" 
                               value="<?php echo esc_attr(get_option('wseo_schema_email', '')); ?>" 
                               class="regular-text" placeholder="info@example.com">
                        <p class="description">Voliteľné pre Organization, povinné pre LocalBusiness.</p>
                    </td>
                </tr>
                
                <!-- Address fields: ALL organization types (optional for Organization, required for LocalBusiness) -->
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th colspan="2" style="background: #f0f6fc; padding: 10px;">
                        <strong>Adresa a poloha</strong>
                        <p style="margin: 5px 0 0; font-weight: normal; color: #666;">
                            <?php $current_type = get_option('wseo_schema_type', 'Organization'); ?>
                            <?php if ($current_type === 'Organization'): ?>
                                Voliteľné pre Organization (odporúčané pre lepšie Google Rich Results)
                            <?php else: ?>
                                <span style="color: #d63638;"><strong>Povinné</strong></span> pre LocalBusiness typy (obchody, reštaurácie, služby...)
                            <?php endif; ?>
                        </p>
                        
                        <?php
                        // Check if address is missing for LocalBusiness types
                        $street = get_option('wseo_schema_address_street', '');
                        $city = get_option('wseo_schema_address_city', '');
                        $has_address = !empty($street) || !empty($city);
                        
                        if ($current_type !== 'Organization' && !$has_address):
                        ?>
                        <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px; margin: 10px 0;">
                            <strong>⚠️ UPOZORNENIE:</strong> Typ "<strong><?php echo esc_html($current_type); ?></strong>" vyžaduje adresu (ulicu alebo mesto)!<br>
                            <span style="color: #856404;">
                                Bez adresy sa automaticky použije typ "Organization" aby sa predišlo Google validation chybám.
                                Prosím vyplňte aspoň mesto alebo ulicu nižšie.
                            </span>
                        </div>
                        <?php endif; ?>
                    </th>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th>
                        <label for="wseo_schema_address_street">Ulica 
                            <?php if ($current_type !== 'Organization'): ?><span style="color: #d63638;">*</span><?php endif; ?>
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_schema_address_street" name="wseo_schema_address_street" 
                               value="<?php echo esc_attr(get_option('wseo_schema_address_street', '')); ?>" 
                               class="regular-text" placeholder="Hlavná 123">
                    </td>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_schema_address_city">Mesto</label></th>
                    <td>
                        <input type="text" id="wseo_schema_address_city" name="wseo_schema_address_city" 
                               value="<?php echo esc_attr(get_option('wseo_schema_address_city', '')); ?>" 
                               class="regular-text" placeholder="Bratislava">
                        <?php if ($current_type !== 'Organization'): ?>
                        <p class="description">
                            <strong style="color: #d63638;">* Povinné:</strong> Vyplňte aspoň ulicu ALEBO mesto pre LocalBusiness typy.
                        </p>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_schema_address_zip">PSČ</label></th>
                    <td>
                        <input type="text" id="wseo_schema_address_zip" name="wseo_schema_address_zip" 
                               value="<?php echo esc_attr(get_option('wseo_schema_address_zip', '')); ?>" 
                               class="regular-text" placeholder="811 01">
                    </td>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_schema_address_region">Kraj / Región</label></th>
                    <td>
                        <input type="text" id="wseo_schema_address_region" name="wseo_schema_address_region" 
                               value="<?php echo esc_attr(get_option('wseo_schema_address_region', '')); ?>" 
                               class="regular-text" placeholder="Košický kraj">
                        <p class="description">Kraj alebo región (napr. Košický kraj, Bratislavský kraj, California...)</p>
                    </td>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_schema_address_country">Krajina</label></th>
                    <td>
                        <?php $current_country = get_option('wseo_schema_address_country', 'SK'); ?>
                        <select id="wseo_schema_address_country" name="wseo_schema_address_country" class="regular-text">
                            <optgroup label="🇪🇺 Stredná Európa">
                                <option value="SK" <?php selected($current_country, 'SK'); ?>>🇸🇰 Slovensko (Slovakia)</option>
                                <option value="CZ" <?php selected($current_country, 'CZ'); ?>>🇨🇿 Česko (Czech Republic)</option>
                                <option value="AT" <?php selected($current_country, 'AT'); ?>>🇦🇹 Rakúsko (Austria)</option>
                                <option value="HU" <?php selected($current_country, 'HU'); ?>>🇭🇺 Maďarsko (Hungary)</option>
                                <option value="PL" <?php selected($current_country, 'PL'); ?>>🇵🇱 Poľsko (Poland)</option>
                                <option value="DE" <?php selected($current_country, 'DE'); ?>>🇩🇪 Nemecko (Germany)</option>
                                <option value="CH" <?php selected($current_country, 'CH'); ?>>🇨🇭 Švajčiarsko (Switzerland)</option>
                            </optgroup>
                            <optgroup label="🇪🇺 Západná Európa">
                                <option value="FR" <?php selected($current_country, 'FR'); ?>>🇫🇷 Francúzsko (France)</option>
                                <option value="GB" <?php selected($current_country, 'GB'); ?>>🇬🇧 Spojené kráľovstvo (United Kingdom)</option>
                                <option value="IE" <?php selected($current_country, 'IE'); ?>>🇮🇪 Írsko (Ireland)</option>
                                <option value="NL" <?php selected($current_country, 'NL'); ?>>🇳🇱 Holandsko (Netherlands)</option>
                                <option value="BE" <?php selected($current_country, 'BE'); ?>>🇧🇪 Belgicko (Belgium)</option>
                                <option value="LU" <?php selected($current_country, 'LU'); ?>>🇱🇺 Luxembursko (Luxembourg)</option>
                            </optgroup>
                            <optgroup label="🇪🇺 Južná Európa">
                                <option value="IT" <?php selected($current_country, 'IT'); ?>>🇮🇹 Taliansko (Italy)</option>
                                <option value="ES" <?php selected($current_country, 'ES'); ?>>🇪🇸 Španielsko (Spain)</option>
                                <option value="PT" <?php selected($current_country, 'PT'); ?>>🇵🇹 Portugalsko (Portugal)</option>
                                <option value="GR" <?php selected($current_country, 'GR'); ?>>🇬🇷 Grécko (Greece)</option>
                                <option value="HR" <?php selected($current_country, 'HR'); ?>>🇭🇷 Chorvátsko (Croatia)</option>
                                <option value="SI" <?php selected($current_country, 'SI'); ?>>🇸🇮 Slovinsko (Slovenia)</option>
                            </optgroup>
                            <optgroup label="🇪🇺 Severná Európa">
                                <option value="SE" <?php selected($current_country, 'SE'); ?>>🇸🇪 Švédsko (Sweden)</option>
                                <option value="NO" <?php selected($current_country, 'NO'); ?>>🇳🇴 Nórsko (Norway)</option>
                                <option value="DK" <?php selected($current_country, 'DK'); ?>>🇩🇰 Dánsko (Denmark)</option>
                                <option value="FI" <?php selected($current_country, 'FI'); ?>>🇫🇮 Fínsko (Finland)</option>
                            </optgroup>
                            <optgroup label="🌍 Východná Európa">
                                <option value="UA" <?php selected($current_country, 'UA'); ?>>🇺🇦 Ukrajina (Ukraine)</option>
                                <option value="RU" <?php selected($current_country, 'RU'); ?>>🇷🇺 Rusko (Russia)</option>
                                <option value="BY" <?php selected($current_country, 'BY'); ?>>🇧🇾 Bielorusko (Belarus)</option>
                                <option value="RO" <?php selected($current_country, 'RO'); ?>>🇷🇴 Rumunsko (Romania)</option>
                                <option value="BG" <?php selected($current_country, 'BG'); ?>>🇧🇬 Bulharsko (Bulgaria)</option>
                            </optgroup>
                            <optgroup label="🌎 Amerika">
                                <option value="US" <?php selected($current_country, 'US'); ?>>🇺🇸 USA (United States)</option>
                                <option value="CA" <?php selected($current_country, 'CA'); ?>>🇨🇦 Kanada (Canada)</option>
                                <option value="MX" <?php selected($current_country, 'MX'); ?>>🇲🇽 Mexiko (Mexico)</option>
                                <option value="BR" <?php selected($current_country, 'BR'); ?>>🇧🇷 Brazília (Brazil)</option>
                            </optgroup>
                            <optgroup label="🌏 Ázia a Oceánia">
                                <option value="CN" <?php selected($current_country, 'CN'); ?>>🇨🇳 Čína (China)</option>
                                <option value="JP" <?php selected($current_country, 'JP'); ?>>🇯🇵 Japonsko (Japan)</option>
                                <option value="KR" <?php selected($current_country, 'KR'); ?>>🇰🇷 Južná Kórea (South Korea)</option>
                                <option value="IN" <?php selected($current_country, 'IN'); ?>>🇮🇳 India (India)</option>
                                <option value="AU" <?php selected($current_country, 'AU'); ?>>🇦🇺 Austrália (Australia)</option>
                                <option value="NZ" <?php selected($current_country, 'NZ'); ?>>🇳🇿 Nový Zéland (New Zealand)</option>
                            </optgroup>
                        </select>
                        <p class="description">Vyberte krajinu pre Schema.org údaje.</p>
                    </td>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_schema_geo_lat">GPS súradnice</label></th>
                    <td>
                        <input type="text" id="wseo_schema_geo_lat" name="wseo_schema_geo_lat" 
                               value="<?php echo esc_attr(get_option('wseo_schema_geo_lat', '')); ?>" 
                               class="small-text" placeholder="48.1486" style="width: 120px;">
                        <input type="text" id="wseo_schema_geo_lng" name="wseo_schema_geo_lng" 
                               value="<?php echo esc_attr(get_option('wseo_schema_geo_lng', '')); ?>" 
                               class="small-text" placeholder="17.1077" style="width: 120px;">
                        <button type="button" id="wseo_geocode_btn" class="button button-secondary" style="margin-left: 10px;">
                            Vyhľadať z adresy
                        </button>
                        <span id="wseo_geocode_status" style="margin-left: 10px; display: none;"></span>
                        <p class="description">
                            Presná poloha vašej prevádzky pre Google Maps. 
                            <strong>Tip:</strong> Kliknite na "Vyhľadať z adresy" pre automatické doplnenie z ulice, mesta a PSČ.
                        </p>
                    </td>
                </tr>
                <!-- Opening hours - ONLY for LocalBusiness -->
                <tr data-schema="localbusiness" data-schema-lb-only="yes">
                    <th><label>Otváracie hodiny</label></th>
                    <td>
                        <p class="description" style="margin-bottom: 10px;"><strong>Vyplňte otváracie hodiny pre každý deň</strong> (nechajte prázdne ak máte zatvorené)</p>
                        <table class="wseo-opening-hours" style="width: auto; border-collapse: collapse;">
                            <?php
                            $days = array(
                                'mon' => 'Pondelok',
                                'tue' => 'Utorok',
                                'wed' => 'Streda',
                                'thu' => 'Štvrtok',
                                'fri' => 'Piatok',
                                'sat' => 'Sobota',
                                'sun' => 'Nedeľa'
                            );
                            foreach ($days as $key => $label):
                                $open = get_option("wseo_schema_hours_{$key}_open", '');
                                $close = get_option("wseo_schema_hours_{$key}_close", '');
                            ?>
                            <tr style="border-bottom: 1px solid #ddd;">
                                <td style="padding: 5px 10px 5px 0; width: 100px;"><strong><?php echo $label; ?></strong></td>
                                <td style="padding: 5px;">
                                    <input type="time" name="wseo_schema_hours_<?php echo $key; ?>_open" 
                                           value="<?php echo esc_attr($open); ?>" style="width: 110px;">
                                    <span>-</span>
                                    <input type="time" name="wseo_schema_hours_<?php echo $key; ?>_close" 
                                           value="<?php echo esc_attr($close); ?>" style="width: 110px;">
                                    <?php if ($open && $close): ?>
                                        <span style="color: #00a32a; margin-left: 5px;">✓</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </table>
                        <p class="description" style="margin-top: 10px;">
                            💡 <strong>Tip:</strong> Pre 24h prevádzku zadajte 00:00 - 23:59. Pre zatvorené dni nechajte prázdne.
                        </p>
                    </td>
                </tr>
                <tr data-schema="localbusiness" data-schema-lb-only="yes">
                    <th><label for="wseo_schema_price_range">Cenová kategória</label></th>
                    <td>
                        <select id="wseo_schema_price_range" name="wseo_schema_price_range">
                            <?php $price_range = get_option('wseo_schema_price_range', ''); ?>
                            <option value="" <?php selected($price_range, ''); ?>>-- Nevybrané --</option>
                            <option value="€" <?php selected($price_range, '€'); ?>>€ - Nízke ceny</option>
                            <option value="€€" <?php selected($price_range, '€€'); ?>>€€ - Stredné ceny</option>
                            <option value="€€€" <?php selected($price_range, '€€€'); ?>>€€€ - Vyššie ceny</option>
                            <option value="€€€€" <?php selected($price_range, '€€€€'); ?>>€€€€ - Luxusné</option>
                        </select>
                        <p class="description">Indikátor cenovej úrovne pre reštaurácie a služby.</p>
                    </td>
                </tr>
                <tr data-schema="localbusiness">
                    <th><label for="wseo_schema_description">Popis firmy/ubytovania</label></th>
                    <td>
                        <textarea id="wseo_schema_description" name="wseo_schema_description" 
                                  rows="3" class="large-text" placeholder="Popis vašej firmy alebo ubytovania pre Google Schema..."><?php echo esc_textarea(get_option('wseo_schema_description', '')); ?></textarea>
                        <p class="description"><strong>Odporúčané!</strong> Krátky popis (1-2 vety) pre Google Schema. Zobrazí sa vo výsledkoch vyhľadávania.</p>
                    </td>
                </tr>
                
                <!-- v3.3: Multi-location support - for ALL organization types -->
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th colspan="2" style="background: #e8f4fd; padding: 10px;">
                        <strong>Pobočky / Viacero lokalít</strong> <span style="background: #0073aa; color: #fff; padding: 2px 8px; border-radius: 3px; font-size: 11px; margin-left: 10px;">v3.3</span>
                        <p style="margin: 5px 0 0; font-weight: normal; color: #666;">
                            <?php $current_type = get_option('wseo_schema_type', 'Organization'); ?>
                            <?php if ($current_type === 'Organization'): ?>
                                Máte viacero kancelárií/pobočiek? Každá pobočka bude prepojená s hlavnou organizáciou.
                            <?php else: ?>
                                Máte viacero prevádzok? Každá pobočka dostane vlastný LocalBusiness Schema s unikátnou adresou.
                            <?php endif; ?>
                        </p>
                    </th>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label>Pobočky</label></th>
                    <td>
                        <div id="wseo-locations-container">
                            <?php 
                            $locations = get_option('wseo_schema_locations', array());
                            if (empty($locations)) {
                                $locations = array(); // Empty array = no additional locations
                            }
                            
                            if (!empty($locations)):
                                foreach ($locations as $index => $location): 
                            ?>
                            <div class="wseo-location-item" style="background: #f9f9f9; border: 1px solid #ddd; border-radius: 4px; padding: 15px; margin-bottom: 15px; position: relative;">
                                <button type="button" class="wseo-remove-location" style="position: absolute; top: 10px; right: 10px; background: #d63638; color: #fff; border: none; border-radius: 3px; padding: 5px 10px; cursor: pointer;">✕ Odstrániť</button>
                                
                                <h4 style="margin: 0 0 15px; padding-bottom: 10px; border-bottom: 1px solid #ddd;">
                                    📍 Pobočka #<?php echo $index + 1; ?>
                                </h4>
                                
                                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 10px;">
                                    <div>
                                        <label><strong>Názov pobočky *</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][name]" 
                                               value="<?php echo esc_attr($location['name'] ?? ''); ?>" 
                                               class="regular-text" style="width: 100%;" placeholder="Napr. Pobočka Košice" required>
                                    </div>
                                    <div>
                                        <label><strong>Telefón</strong></label>
                                        <input type="tel" name="wseo_locations[<?php echo $index; ?>][phone]" 
                                               value="<?php echo esc_attr($location['phone'] ?? ''); ?>" 
                                               class="regular-text" style="width: 100%;" placeholder="+421 900 123 456">
                                    </div>
                                </div>
                                
                                <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 10px; margin-bottom: 10px;">
                                    <div>
                                        <label><strong>Ulica *</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][street]" 
                                               value="<?php echo esc_attr($location['street'] ?? ''); ?>" 
                                               class="regular-text" style="width: 100%;" placeholder="Hlavná 123" required>
                                    </div>
                                    <div>
                                        <label><strong>PSČ</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][zip]" 
                                               value="<?php echo esc_attr($location['zip'] ?? ''); ?>" 
                                               class="regular-text" style="width: 100%;" placeholder="040 01">
                                    </div>
                                </div>
                                
                                <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px; margin-bottom: 10px;">
                                    <div>
                                        <label><strong>Mesto *</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][city]" 
                                               value="<?php echo esc_attr($location['city'] ?? ''); ?>" 
                                               class="regular-text" style="width: 100%;" placeholder="Košice" required>
                                    </div>
                                    <div>
                                        <label><strong>Kraj</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][region]" 
                                               value="<?php echo esc_attr($location['region'] ?? ''); ?>" 
                                               class="regular-text" style="width: 100%;" placeholder="Košický kraj">
                                    </div>
                                    <div>
                                        <label><strong>Krajina</strong></label>
                                        <select name="wseo_locations[<?php echo $index; ?>][country]" style="width: 100%;">
                                            <?php $loc_country = $location['country'] ?? 'SK'; ?>
                                            <option value="SK" <?php selected($loc_country, 'SK'); ?>>🇸🇰 Slovensko</option>
                                            <option value="CZ" <?php selected($loc_country, 'CZ'); ?>>🇨🇿 Česko</option>
                                            <option value="AT" <?php selected($loc_country, 'AT'); ?>>🇦🇹 Rakúsko</option>
                                            <option value="HU" <?php selected($loc_country, 'HU'); ?>>🇭🇺 Maďarsko</option>
                                            <option value="PL" <?php selected($loc_country, 'PL'); ?>>🇵🇱 Poľsko</option>
                                            <option value="DE" <?php selected($loc_country, 'DE'); ?>>🇩🇪 Nemecko</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div style="display: grid; grid-template-columns: 1fr 1fr auto; gap: 10px; align-items: end;">
                                    <div>
                                        <label><strong>GPS Lat</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][lat]" 
                                               value="<?php echo esc_attr($location['lat'] ?? ''); ?>" 
                                               class="wseo-loc-lat regular-text" style="width: 100%;" placeholder="48.7164">
                                    </div>
                                    <div>
                                        <label><strong>GPS Lng</strong></label>
                                        <input type="text" name="wseo_locations[<?php echo $index; ?>][lng]" 
                                               value="<?php echo esc_attr($location['lng'] ?? ''); ?>" 
                                               class="wseo-loc-lng regular-text" style="width: 100%;" placeholder="21.2611">
                                    </div>
                                    <div>
                                        <button type="button" class="button wseo-geocode-branch" style="height: 30px;">
                                            Načítať GPS
                                        </button>
                                    </div>
                                </div>
                                
                                <div style="margin-top: 10px;" class="wseo-branch-hours" <?php if ($current_type === 'Organization'): ?>style="display: none;"<?php endif; ?>>
                                    <label><strong>Otváracie hodiny (voliteľné)</strong></label>
                                    <input type="text" name="wseo_locations[<?php echo $index; ?>][hours]" 
                                           value="<?php echo esc_attr($location['hours'] ?? ''); ?>" 
                                           class="large-text" style="width: 100%;" placeholder="Po-Pia: 9:00-17:00, So: 9:00-12:00">
                                    <p class="description" style="margin-top: 5px;">Formát: Po-Pia: 9:00-17:00, So: 9:00-12:00 (alebo nechajte prázdne pre použitie hlavných hodín)</p>
                                </div>
                                
                                <div style="margin-top: 10px;" class="wseo-branch-gbp" <?php if ($current_type === 'Organization'): ?>style="display: none;"<?php endif; ?>>
                                    <label><strong>Google Business Profile - Place ID (voliteľné)</strong></label>
                                    <input type="text" name="wseo_locations[<?php echo $index; ?>][place_id]" 
                                           value="<?php echo esc_attr($location['place_id'] ?? ''); ?>" 
                                           class="large-text" style="width: 100%;" placeholder="ChIJ...">
                                    <p class="description" style="margin-top: 5px;">
                                        Ak má táto pobočka vlastný Google Business Profile, zadajte Place ID.
                                        <a href="https://developers.google.com/maps/documentation/places/web-service/place-id#find-id" target="_blank">Ako nájsť Place ID →</a>
                                    </p>
                                </div>
                            </div>
                            <?php 
                                endforeach;
                            endif; 
                            ?>
                        </div>
                        
                        <!-- GBP Info box for LocalBusiness -->
                        <?php if ($current_type !== 'Organization'): ?>
                        <div style="background: #e7f3ff; border-left: 4px solid #2196F3; padding: 12px; margin: 15px 0;">
                            <strong>Google Business Profile pre pobočky</strong>
                            <p style="margin: 8px 0 0; color: #555;">
                                <strong>Odporúčané pre:</strong> Reštaurácie, obchody, hotely, servisy - kde zákazníci hľadajú "near me"<br>
                                <strong>Nepovinné pre:</strong> Kancelárie, sklady, administratívne pobočky<br><br>
                                Ak pobočka má vlastný GBP profil, zadajte Place ID pre prepojenie. Ak nemá, nechajte prázdne - Schema.org bude fungovať aj bez toho.
                            </p>
                        </div>
                        <?php endif; ?>
                        
                        <button type="button" id="wseo-add-location" class="button button-secondary" style="margin-top: 10px;">
                            + Pridať pobočku
                        </button>
                        
                        <p class="description" style="margin-top: 15px;">
                            <strong>Ako to funguje:</strong><br>
                            <?php if ($current_type === 'Organization'): ?>
                            • Hlavná adresa = hlavné sídlo organizácie<br>
                            • Každá pobočka = prepojená sub-organizácia (bez otváracích hodín)<br>
                            • Vhodné pre korporácie, holdings, firmy s viacerými kanceláriami<br>
                            • GBP nie je potrebný - Organization pobočky sa nezobrazujú v Local Pack
                            <?php else: ?>
                            • Hlavná adresa vyššie = hlavné sídlo (hlavný LocalBusiness Schema)<br>
                            • Každá pobočka = samostatný LocalBusiness Schema s vlastnou adresou a hodinami<br>
                            • Google zobrazí všetky lokality vo vyhľadávaní a na mapách<br>
                            • Odporúčané pre reťazce, franšízy, servisné firmy s viacerými prevádzkami
                            <?php endif; ?>
                        </p>
                        
                        <script>
                        jQuery(function($) {
                            var locationIndex = <?php echo count($locations); ?>;
                            
                            // Add new location
                            $('#wseo-add-location').on('click', function() {
                                var template = `
                                <div class="wseo-location-item" style="background: #f9f9f9; border: 1px solid #ddd; border-radius: 4px; padding: 15px; margin-bottom: 15px; position: relative;">
                                    <button type="button" class="wseo-remove-location" style="position: absolute; top: 10px; right: 10px; background: #d63638; color: #fff; border: none; border-radius: 3px; padding: 5px 10px; cursor: pointer;">✕ Odstrániť</button>
                                    
                                    <h4 style="margin: 0 0 15px; padding-bottom: 10px; border-bottom: 1px solid #ddd;">
                                        📍 Nová pobočka
                                    </h4>
                                    
                                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 10px;">
                                        <div>
                                            <label><strong>Názov pobočky *</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][name]" 
                                                   class="regular-text" style="width: 100%;" placeholder="Napr. Pobočka Košice" required>
                                        </div>
                                        <div>
                                            <label><strong>Telefón</strong></label>
                                            <input type="tel" name="wseo_locations[${locationIndex}][phone]" 
                                                   class="regular-text" style="width: 100%;" placeholder="+421 900 123 456">
                                        </div>
                                    </div>
                                    
                                    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 10px; margin-bottom: 10px;">
                                        <div>
                                            <label><strong>Ulica *</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][street]" 
                                                   class="regular-text" style="width: 100%;" placeholder="Hlavná 123" required>
                                        </div>
                                        <div>
                                            <label><strong>PSČ</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][zip]" 
                                                   class="regular-text" style="width: 100%;" placeholder="040 01">
                                        </div>
                                    </div>
                                    
                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px; margin-bottom: 10px;">
                                        <div>
                                            <label><strong>Mesto *</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][city]" 
                                                   class="regular-text" style="width: 100%;" placeholder="Košice" required>
                                        </div>
                                        <div>
                                            <label><strong>Kraj</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][region]" 
                                                   class="regular-text" style="width: 100%;" placeholder="Košický kraj">
                                        </div>
                                        <div>
                                            <label><strong>Krajina</strong></label>
                                            <select name="wseo_locations[${locationIndex}][country]" style="width: 100%;">
                                                <option value="SK" selected>🇸🇰 Slovensko</option>
                                                <option value="CZ">🇨🇿 Česko</option>
                                                <option value="AT">🇦🇹 Rakúsko</option>
                                                <option value="HU">🇭🇺 Maďarsko</option>
                                                <option value="PL">🇵🇱 Poľsko</option>
                                                <option value="DE">🇩🇪 Nemecko</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div style="display: grid; grid-template-columns: 1fr 1fr auto; gap: 10px; align-items: end;">
                                        <div>
                                            <label><strong>GPS Lat</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][lat]" 
                                                   class="wseo-loc-lat regular-text" style="width: 100%;" placeholder="48.7164">
                                        </div>
                                        <div>
                                            <label><strong>GPS Lng</strong></label>
                                            <input type="text" name="wseo_locations[${locationIndex}][lng]" 
                                                   class="wseo-loc-lng regular-text" style="width: 100%;" placeholder="21.2611">
                                        </div>
                                        <div>
                                            <button type="button" class="button wseo-geocode-branch" style="height: 30px;">
                                                Načítať GPS
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div style="margin-top: 10px;" class="wseo-branch-hours">
                                        <label><strong>Otváracie hodiny (voliteľné)</strong></label>
                                        <input type="text" name="wseo_locations[${locationIndex}][hours]" 
                                               class="large-text" style="width: 100%;" placeholder="Po-Pia: 9:00-17:00, So: 9:00-12:00">
                                        <p class="description" style="margin-top: 5px;">Formát: Po-Pia: 9:00-17:00, So: 9:00-12:00</p>
                                    </div>
                                    
                                    <div style="margin-top: 10px;" class="wseo-branch-gbp">
                                        <label><strong>Google Business Profile - Place ID (voliteľné)</strong></label>
                                        <input type="text" name="wseo_locations[${locationIndex}][place_id]" 
                                               class="large-text" style="width: 100%;" placeholder="ChIJ...">
                                        <p class="description" style="margin-top: 5px;">
                                            Ak má táto pobočka vlastný Google Business Profile, zadajte Place ID.
                                            <a href="https://developers.google.com/maps/documentation/places/web-service/place-id#find-id" target="_blank">Ako nájsť Place ID →</a>
                                        </p>
                                    </div>
                                </div>`;
                                
                                $('#wseo-locations-container').append(template);
                                
                                // Hide hours and GBP fields for Organization type
                                var schemaType = $('#wseo_schema_type').val();
                                if (schemaType === 'Organization' || schemaType === 'Corporation' || schemaType === 'NewsMediaOrganization') {
                                    $('.wseo-branch-hours').hide();
                                    $('.wseo-branch-gbp').hide();
                                }
                                
                                locationIndex++;
                            });
                            
                            // Remove location
                            $(document).on('click', '.wseo-remove-location', function() {
                                if (confirm('Naozaj chcete odstrániť túto pobočku?')) {
                                    $(this).closest('.wseo-location-item').remove();
                                }
                            });
                            
                            // Auto-geocode for branches
                            $(document).on('click', '.wseo-geocode-branch', function() {
                                var $btn = $(this);
                                var $item = $btn.closest('.wseo-location-item');
                                var street = $item.find('input[name*="[street]"]').val();
                                var city = $item.find('input[name*="[city]"]').val();
                                var zip = $item.find('input[name*="[zip]"]').val();
                                var country = $item.find('select[name*="[country]"]').val() || 'SK';
                                
                                if (!street && !city) {
                                    alert('Vyplňte aspoň ulicu alebo mesto.');
                                    return;
                                }
                                
                                var address = [street, zip, city, country].filter(Boolean).join(', ');
                                
                                $btn.prop('disabled', true).text('Hľadám...');
                                
                                // Use Nominatim (OpenStreetMap) - free, no API key needed
                                $.ajax({
                                    url: 'https://nominatim.openstreetmap.org/search',
                                    data: {
                                        q: address,
                                        format: 'json',
                                        limit: 1
                                    },
                                    success: function(data) {
                                        if (data && data.length > 0) {
                                            $item.find('.wseo-loc-lat').val(parseFloat(data[0].lat).toFixed(6));
                                            $item.find('.wseo-loc-lng').val(parseFloat(data[0].lon).toFixed(6));
                                            $btn.text('✓ Nájdené!');
                                            setTimeout(function() {
                                                $btn.prop('disabled', false).text('Načítať GPS');
                                            }, 2000);
                                        } else {
                                            $btn.text('Nenájdené');
                                            setTimeout(function() {
                                                $btn.prop('disabled', false).text('Načítať GPS');
                                            }, 2000);
                                        }
                                    },
                                    error: function() {
                                        $btn.text('Chyba');
                                        setTimeout(function() {
                                            $btn.prop('disabled', false).text('Načítať GPS');
                                        }, 2000);
                                    }
                                });
                            });
                        });
                        </script>
                    </td>
                </tr>
                
                <!-- Sociálne siete -->
                <tr data-schema="social">
                    <th colspan="2" style="background: #f0f6fc; padding: 10px;">
                        <strong>🔗 Sociálne siete (sameAs)</strong>
                        <p style="margin: 5px 0 0; font-weight: normal; color: #666;">
                            Prepojte svoju firmu so sociálnymi sieťami pre lepšie SEO
                        </p>
                    </th>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_facebook">Facebook</label></th>
                    <td>
                        <input type="url" id="wseo_schema_facebook" name="wseo_schema_facebook" 
                               value="<?php echo esc_attr(get_option('wseo_schema_facebook', '')); ?>" 
                               class="regular-text" placeholder="https://facebook.com/vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_instagram">Instagram</label></th>
                    <td>
                        <input type="url" id="wseo_schema_instagram" name="wseo_schema_instagram" 
                               value="<?php echo esc_attr(get_option('wseo_schema_instagram', '')); ?>" 
                               class="regular-text" placeholder="https://instagram.com/vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_twitter">Twitter / X</label></th>
                    <td>
                        <input type="url" id="wseo_schema_twitter" name="wseo_schema_twitter" 
                               value="<?php echo esc_attr(get_option('wseo_schema_twitter', '')); ?>" 
                               class="regular-text" placeholder="https://twitter.com/vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_linkedin">LinkedIn</label></th>
                    <td>
                        <input type="url" id="wseo_schema_linkedin" name="wseo_schema_linkedin" 
                               value="<?php echo esc_attr(get_option('wseo_schema_linkedin', '')); ?>" 
                               class="regular-text" placeholder="https://linkedin.com/company/vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_youtube">YouTube</label></th>
                    <td>
                        <input type="url" id="wseo_schema_youtube" name="wseo_schema_youtube" 
                               value="<?php echo esc_attr(get_option('wseo_schema_youtube', '')); ?>" 
                               class="regular-text" placeholder="https://youtube.com/@vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_tiktok">TikTok</label></th>
                    <td>
                        <input type="url" id="wseo_schema_tiktok" name="wseo_schema_tiktok" 
                               value="<?php echo esc_attr(get_option('wseo_schema_tiktok', '')); ?>" 
                               class="regular-text" placeholder="https://tiktok.com/@vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_pinterest">Pinterest</label></th>
                    <td>
                        <input type="url" id="wseo_schema_pinterest" name="wseo_schema_pinterest" 
                               value="<?php echo esc_attr(get_option('wseo_schema_pinterest', '')); ?>" 
                               class="regular-text" placeholder="https://pinterest.com/vasafirma">
                    </td>
                </tr>
                <tr data-schema="social">
                    <th><label for="wseo_schema_tweetko">Tweetko</label></th>
                    <td>
                        <input type="url" id="wseo_schema_tweetko" name="wseo_schema_tweetko" 
                               value="<?php echo esc_attr(get_option('wseo_schema_tweetko', '')); ?>" 
                               class="regular-text" placeholder="https://tweetko.com/vasafirma">
                    </td>
                </tr>
                
                <!-- v2.9.11: Hodnotenie firmy ODSTRÁNENÉ
                     Google od 2019 nepodporuje aggregateRating pre LocalBusiness a Organization
                     "Self-serving reviews" sú ignorované alebo penalizované
                     Zdroj: https://developers.google.com/search/blog/2019/09/making-review-rich-results-more-helpful
                     
                     Ak potrebujete aggregateRating, použite ho pre:
                     - Product (WooCommerce - automaticky z recenzií)
                     - Service (v meta box jednotlivých stránok)
                     - Course, SoftwareApplication, Recipe, Book
                -->
                
                <!-- UBYTOVANIE - špecifické polia (VacationRental, Hotel, B&B...) -->
                <tr class="wseo-section-header" data-schema="lodging">
                    <th colspan="2">
                        <h3 style="margin: 20px 0 10px; padding-top: 15px; border-top: 2px solid #0073aa;">
                            🏨 Ubytovanie - Povinné polia (Google 2026)
                        </h3>
                        <p class="description" style="font-weight: normal;">Tieto polia sú <strong>povinné</strong> pre VacationRental, Hotel, B&B a podobné typy ubytovania.</p>
                    </th>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_identifier">Identifikátor (ID)</label></th>
                    <td>
                        <input type="text" id="wseo_schema_identifier" name="wseo_schema_identifier" 
                               value="<?php echo esc_attr(get_option('wseo_schema_identifier', '')); ?>" 
                               class="regular-text" placeholder="napr. tokajsky-domcek-001">
                        <p class="description"><strong>Povinné!</strong> Unikátny identifikátor vášho ubytovania (ID nehnuteľnosti).</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_images">Obrázky (min. 8)</label></th>
                    <td>
                        <textarea id="wseo_schema_images" name="wseo_schema_images" 
                                  rows="10" class="large-text" placeholder="https://example.sk/foto1.jpg&#10;https://example.sk/foto2.jpg&#10;https://example.sk/foto3.jpg&#10;https://example.sk/foto4.jpg&#10;https://example.sk/foto5.jpg&#10;https://example.sk/foto6.jpg&#10;https://example.sk/foto7.jpg&#10;https://example.sk/foto8.jpg"><?php echo esc_textarea(get_option('wseo_schema_images', '')); ?></textarea>
                        <p class="description">
                            <strong>⚠️ Google vyžaduje minimálne 8 obrázkov!</strong><br>
                            Jeden URL na riadok. Zahrňte: spálne, kúpeľne, kuchyňu, obývaciu izbu, exteriér.<br>
                            <span style="color: #d63638;">Bez 8+ obrázkov sa ubytovanie nezobrazí v Google Vacation Rentals!</span>
                        </p>
                        <?php 
                        $images = get_option('wseo_schema_images', '');
                        $image_count = $images ? count(array_filter(explode("\n", $images))) : 0;
                        $color = $image_count >= 8 ? '#00a32a' : ($image_count > 0 ? '#dba617' : '#d63638');
                        ?>
                        <p style="margin-top: 10px;">
                            <span style="background: <?php echo $color; ?>; color: white; padding: 3px 10px; border-radius: 3px; font-weight: bold;">
                                📷 Počet obrázkov: <?php echo $image_count; ?>/8
                            </span>
                            <?php if ($image_count >= 8): ?>
                                <span style="color: #00a32a; margin-left: 10px;">✅ OK</span>
                            <?php elseif ($image_count > 0): ?>
                                <span style="color: #dba617; margin-left: 10px;">⚠️ Pridajte ešte <?php echo 8 - $image_count; ?> obrázkov</span>
                            <?php else: ?>
                                <span style="color: #d63638; margin-left: 10px;">❌ Chýbajú obrázky!</span>
                            <?php endif; ?>
                        </p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_num_rooms">Počet izieb</label></th>
                    <td>
                        <input type="number" id="wseo_schema_num_rooms" name="wseo_schema_num_rooms" 
                               value="<?php echo esc_attr(get_option('wseo_schema_num_rooms', '')); ?>" 
                               class="small-text" min="1" placeholder="3">
                        <p class="description"><strong>Povinné!</strong> Celkový počet izieb v ubytovaní.</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_num_beds">Počet spální</label></th>
                    <td>
                        <input type="number" id="wseo_schema_num_beds" name="wseo_schema_num_beds" 
                               value="<?php echo esc_attr(get_option('wseo_schema_num_beds', '')); ?>" 
                               class="small-text" min="1" placeholder="2">
                        <p class="description">Počet spální (bedroom).</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_max_occupancy">Max. kapacita</label></th>
                    <td>
                        <input type="number" id="wseo_schema_max_occupancy" name="wseo_schema_max_occupancy" 
                               value="<?php echo esc_attr(get_option('wseo_schema_max_occupancy', '')); ?>" 
                               class="small-text" min="1" placeholder="6">
                        <span>osôb</span>
                        <p class="description">Maximálny počet hostí.</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_floor_size">Plocha</label></th>
                    <td>
                        <input type="number" id="wseo_schema_floor_size" name="wseo_schema_floor_size" 
                               value="<?php echo esc_attr(get_option('wseo_schema_floor_size', '')); ?>" 
                               class="small-text" min="1" placeholder="80">
                        <span>m²</span>
                        <p class="description">Celková plocha ubytovania v m².</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_num_bathrooms">Počet kúpeľní</label></th>
                    <td>
                        <input type="number" id="wseo_schema_num_bathrooms" name="wseo_schema_num_bathrooms" 
                               value="<?php echo esc_attr(get_option('wseo_schema_num_bathrooms', '')); ?>" 
                               class="small-text" min="0" step="0.5" placeholder="1">
                        <p class="description">Celkový počet kúpeľní (napr. 1.5 = 1 kúpeľňa + 1 WC).</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_room_type">Typ priestoru</label></th>
                    <td>
                        <select id="wseo_schema_room_type" name="wseo_schema_room_type">
                            <?php $room_type = get_option('wseo_schema_room_type', 'EntirePlace'); ?>
                            <option value="EntirePlace" <?php selected($room_type, 'EntirePlace'); ?>>🏠 Celý objekt (EntirePlace)</option>
                            <option value="PrivateRoom" <?php selected($room_type, 'PrivateRoom'); ?>>🚪 Súkromná izba (PrivateRoom)</option>
                            <option value="SharedRoom" <?php selected($room_type, 'SharedRoom'); ?>>👥 Zdieľaná izba (SharedRoom)</option>
                        </select>
                        <p class="description">Typ ubytovania pre Google VacationRental.</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_additional_type">Kategória ubytovania</label></th>
                    <td>
                        <select id="wseo_schema_additional_type" name="wseo_schema_additional_type">
                            <?php $add_type = get_option('wseo_schema_additional_type', ''); ?>
                            <option value="" <?php selected($add_type, ''); ?>>-- Nevybrané --</option>
                            <option value="Apartment" <?php selected($add_type, 'Apartment'); ?>>🏢 Apartmán</option>
                            <option value="Villa" <?php selected($add_type, 'Villa'); ?>>🏡 Vila</option>
                            <option value="House" <?php selected($add_type, 'House'); ?>>🏠 Rodinný dom</option>
                            <option value="Cottage" <?php selected($add_type, 'Cottage'); ?>>🏡 Chalupa</option>
                            <option value="Cabin" <?php selected($add_type, 'Cabin'); ?>>🪵 Zrub / Drevenica</option>
                            <option value="Bungalow" <?php selected($add_type, 'Bungalow'); ?>>🏖️ Bungalov</option>
                            <option value="Chalet" <?php selected($add_type, 'Chalet'); ?>>🏔️ Horská chata</option>
                            <option value="Gite" <?php selected($add_type, 'Gite'); ?>>🏘️ Vidiecka usadlosť</option>
                            <option value="HolidayVillageRental" <?php selected($add_type, 'HolidayVillageRental'); ?>>🏘️ Rekreačný areál</option>
                        </select>
                        <p class="description">Špecifická kategória pre Google VacationRental.</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_bed_type">Typ postele</label></th>
                    <td>
                        <select id="wseo_schema_bed_type" name="wseo_schema_bed_type">
                            <?php $bed_type = get_option('wseo_schema_bed_type', ''); ?>
                            <option value="" <?php selected($bed_type, ''); ?>>-- Nevybrané --</option>
                            <option value="King" <?php selected($bed_type, 'King'); ?>>👑 King (180cm+)</option>
                            <option value="CaliforniaKing" <?php selected($bed_type, 'CaliforniaKing'); ?>>🌴 California King</option>
                            <option value="Queen" <?php selected($bed_type, 'Queen'); ?>>👸 Queen (160cm)</option>
                            <option value="Double" <?php selected($bed_type, 'Double'); ?>>🛏️ Double (140cm)</option>
                            <option value="Full" <?php selected($bed_type, 'Full'); ?>>🛏️ Full</option>
                            <option value="Single" <?php selected($bed_type, 'Single'); ?>>🛏️ Single (90cm)</option>
                            <option value="SemiDouble" <?php selected($bed_type, 'SemiDouble'); ?>>🛏️ Semi-Double</option>
                        </select>
                        <p class="description">Hlavný typ postele.</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_bed_count">Počet postelí</label></th>
                    <td>
                        <input type="number" id="wseo_schema_bed_count" name="wseo_schema_bed_count" 
                               value="<?php echo esc_attr(get_option('wseo_schema_bed_count', '')); ?>" 
                               class="small-text" min="1" placeholder="2">
                        <p class="description">Celkový počet postelí.</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_checkin_time">Check-in čas</label></th>
                    <td>
                        <input type="time" id="wseo_schema_checkin_time" name="wseo_schema_checkin_time" 
                               value="<?php echo esc_attr(get_option('wseo_schema_checkin_time', '14:00')); ?>">
                        <p class="description">Čas check-in (príchod hostí).</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_checkout_time">Check-out čas</label></th>
                    <td>
                        <input type="time" id="wseo_schema_checkout_time" name="wseo_schema_checkout_time" 
                               value="<?php echo esc_attr(get_option('wseo_schema_checkout_time', '10:00')); ?>">
                        <p class="description">Čas check-out (odchod hostí).</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_languages">Jazyky hostiteľa</label></th>
                    <td>
                        <input type="text" id="wseo_schema_languages" name="wseo_schema_languages" 
                               value="<?php echo esc_attr(get_option('wseo_schema_languages', '')); ?>" 
                               class="regular-text" placeholder="sk-SK, en-US, de-DE">
                        <p class="description">Jazyky oddelené čiarkou (ISO kódy: sk-SK, en-US, de-DE, hu-HU...).</p>
                    </td>
                </tr>
                <tr data-schema="lodging">
                    <th><label for="wseo_schema_amenities">Vybavenie</label></th>
                    <td>
                        <input type="text" id="wseo_schema_amenities" name="wseo_schema_amenities" 
                               value="<?php echo esc_attr(get_option('wseo_schema_amenities', '')); ?>" 
                               class="large-text" placeholder="WiFi, Parkovanie, Klimatizácia, Kuchyňa, TV">
                        <p class="description">Vybavenie oddelené čiarkou. Podporované: WiFi, Parkovanie, Klimatizácia, Kuchyňa, TV, Bazén, Vírivka, Kúrenie, Balkón, Terasa, Krb, Výťah, Práčka, Fitness, Detská postieľka, Gril, Mikrovlnka, Raňajky</p>
                    </td>
                </tr>
                <!-- KONIEC UBYTOVANIE -->
                
                <!-- FIRMA - Právne údaje -->
                <tr class="wseo-section-header" data-schema="basic">
                    <th colspan="2">
                        <h3 style="margin: 20px 0 10px; padding-top: 15px; border-top: 2px solid #0073aa;">
                            🏢 Firemné údaje (voliteľné)
                        </h3>
                        <p class="description" style="font-weight: normal;">Právne a identifikačné údaje firmy pre lepšie SEO a dôveryhodnosť.</p>
                    </th>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_legal_name">Právny názov</label></th>
                    <td>
                        <input type="text" id="wseo_schema_legal_name" name="wseo_schema_legal_name" 
                               value="<?php echo esc_attr(get_option('wseo_schema_legal_name', '')); ?>" 
                               class="large-text" placeholder="Moja firma s.r.o.">
                        <p class="description">Oficiálny právny názov firmy (ak je iný ako obchodný názov).</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_tax_id">IČO</label></th>
                    <td>
                        <input type="text" id="wseo_schema_tax_id" name="wseo_schema_tax_id" 
                               value="<?php echo esc_attr(get_option('wseo_schema_tax_id', '')); ?>" 
                               class="regular-text" placeholder="12345678">
                        <p class="description">Identifikačné číslo organizácie.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_vat_id">IČ DPH</label></th>
                    <td>
                        <input type="text" id="wseo_schema_vat_id" name="wseo_schema_vat_id" 
                               value="<?php echo esc_attr(get_option('wseo_schema_vat_id', '')); ?>" 
                               class="regular-text" placeholder="SK1234567890">
                        <p class="description">IČ DPH (VAT ID) pre platcov DPH.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_founding_date">Dátum založenia</label></th>
                    <td>
                        <input type="date" id="wseo_schema_founding_date" name="wseo_schema_founding_date" 
                               value="<?php echo esc_attr(get_option('wseo_schema_founding_date', '')); ?>">
                        <p class="description">Dátum založenia firmy.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_num_employees">Počet zamestnancov</label></th>
                    <td>
                        <input type="number" id="wseo_schema_num_employees" name="wseo_schema_num_employees" 
                               value="<?php echo esc_attr(get_option('wseo_schema_num_employees', '')); ?>" 
                               class="small-text" min="1" placeholder="10">
                        <p class="description">Približný počet zamestnancov.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_slogan">Slogan</label></th>
                    <td>
                        <input type="text" id="wseo_schema_slogan" name="wseo_schema_slogan" 
                               value="<?php echo esc_attr(get_option('wseo_schema_slogan', '')); ?>" 
                               class="large-text" placeholder="Vaša spokojnosť - náš cieľ">
                        <p class="description">Slogan alebo motto firmy.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_area_served">Oblasť pôsobenia</label></th>
                    <td>
                        <input type="text" id="wseo_schema_area_served" name="wseo_schema_area_served" 
                               value="<?php echo esc_attr(get_option('wseo_schema_area_served', '')); ?>" 
                               class="large-text" placeholder="Slovensko, Česko">
                        <p class="description">Krajiny alebo regióny kde pôsobíte.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_payment_accepted">Akceptované platby</label></th>
                    <td>
                        <input type="text" id="wseo_schema_payment_accepted" name="wseo_schema_payment_accepted" 
                               value="<?php echo esc_attr(get_option('wseo_schema_payment_accepted', '')); ?>" 
                               class="large-text" placeholder="Hotovosť, Kartou, Prevodom, PayPal">
                        <p class="description">Akceptované platobné metódy.</p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_currencies_accepted">Akceptované meny</label></th>
                    <td>
                        <input type="text" id="wseo_schema_currencies_accepted" name="wseo_schema_currencies_accepted" 
                               value="<?php echo esc_attr(get_option('wseo_schema_currencies_accepted', '')); ?>" 
                               class="regular-text" placeholder="EUR, CZK, USD">
                        <p class="description">
                            Akceptované meny (ISO 4217 kódy). Príklady: EUR, CZK, USD, PLN, HUF, GBP.
                            <br><small style="color: #666;">Pre LocalBusiness typy - Google to zobrazuje vo výsledkoch vyhľadávania.</small>
                        </p>
                    </td>
                </tr>
                <tr data-schema="basic">
                    <th><label for="wseo_schema_has_map">Google Maps / Moja Firma</label></th>
                    <td>
                        <input type="url" id="wseo_schema_has_map" name="wseo_schema_has_map" 
                               value="<?php echo esc_url(get_option('wseo_schema_has_map', '')); ?>" 
                               class="large-text" placeholder="https://www.google.com/maps/place/...">
                        <p class="description">
                            Odkaz na váš Google Business Profile alebo Google Maps. 
                            <br><strong>Ako získať:</strong> Vyhľadajte svoju firmu na <a href="https://www.google.com/maps" target="_blank">Google Maps</a> → kliknite na "Zdieľať" → skopírujte link.
                            <br><small>Tento odkaz sa automaticky pridá do <code>sameAs</code> pre prepojenie s Google Knowledge Panel.</small>
                        </p>
                    </td>
                </tr>
                <!-- KONIEC FIRMA -->
                
                <!-- v3.3: GOOGLE BUSINESS PROFILE - for ALL organization types -->
                <tr class="wseo-section-header" data-schema="localbusiness" data-schema-org="yes">
                    <th colspan="2">
                        <h3 style="margin: 20px 0 10px; padding-top: 15px; border-top: 2px solid #4285f4;">
                            <svg viewBox="0 0 24 24" style="width: 24px; height: 24px; vertical-align: middle; margin-right: 8px;"><path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/><path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/><path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/><path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/></svg>
                            Google Business Profile <span style="background: #4285f4; color: #fff; padding: 2px 8px; border-radius: 3px; font-size: 11px; margin-left: 8px;">v3.3</span>
                        </h3>
                        <p style="margin: 5px 0 0; font-weight: normal; color: #666;">
                            <?php if ($current_type === 'Organization'): ?>
                                Prepojte váš Google Business Profile pre Knowledge Panel a brand verification.
                            <?php else: ?>
                                Prepojte váš Google Business Profile pre Local Pack, recenzie a zobrazenie na Google Maps.
                            <?php endif; ?>
                        </p>
                        
                        <!-- Info box about GBP benefits -->
                        <div style="background: #e7f3ff; border-left: 4px solid #2196F3; padding: 10px; margin-top: 10px; font-weight: normal;">
                            <?php if ($current_type === 'Organization'): ?>
                                <strong>Pre Organization:</strong> GBP pomáha s Google Knowledge Panel a overením značky. 
                                Recenzie sa nezobrazia v Local Pack, ale zobrazia sa pri brandovom vyhľadávaní.
                            <?php else: ?>
                                <strong>Pre LocalBusiness:</strong> GBP je kľúčový pre Local Pack (top 3 výsledky s mapou), 
                                hviezdičky vo vyhľadávaní a "near me" vyhľadávania.
                            <?php endif; ?>
                        </div>
                    </th>
                </tr>
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_gbp_place_id">Google Place ID</label></th>
                    <td>
                        <input type="text" id="wseo_gbp_place_id" name="wseo_gbp_place_id" 
                               value="<?php echo esc_attr(get_option('wseo_gbp_place_id', '')); ?>" 
                               class="large-text" placeholder="ChIJ...">
                        <p class="description">
                            Váš Google Place ID. 
                            <a href="https://developers.google.com/maps/documentation/places/web-service/place-id#find-id" target="_blank">Ako nájsť Place ID →</a>
                            <br>
                            <small>Alebo vyhľadajte svoju firmu na <a href="https://www.google.com/maps" target="_blank">Google Maps</a>, kliknite na ňu a skopírujte časť URL za "place/".</small>
                        </p>
                        
                        <?php $place_id = get_option('wseo_gbp_place_id', ''); ?>
                        <?php if (!empty($place_id)): ?>
                        <div style="margin-top: 15px; padding: 15px; background: #e8f5e9; border-radius: 8px;">
                            <h4 style="margin: 0 0 10px; color: #2e7d32;">✅ Google Business Profile je prepojený</h4>
                            
                            <div style="display: flex; flex-wrap: wrap; gap: 10px; margin-bottom: 15px;">
                                <a href="https://search.google.com/local/writereview?placeid=<?php echo esc_attr($place_id); ?>" 
                                   target="_blank" 
                                   class="button button-primary" 
                                   style="background: #4285f4; border-color: #4285f4;">
                                    ⭐ Zanechať recenziu
                                </a>
                                <a href="https://www.google.com/maps/place/?q=place_id:<?php echo esc_attr($place_id); ?>" 
                                   target="_blank" 
                                   class="button">
                                    📍 Zobraziť na Google Maps
                                </a>
                                <a href="https://business.google.com/" 
                                   target="_blank" 
                                   class="button">
                                    ⚙️ Spravovať GBP
                                </a>
                            </div>
                            
                            <div style="background: #fff; padding: 12px; border-radius: 4px; border: 1px solid #c8e6c9;">
                                <strong>📋 Review link pre zákazníkov:</strong><br>
                                <code id="wseo-review-link" style="display: block; margin: 8px 0; padding: 8px; background: #f5f5f5; border-radius: 4px; word-break: break-all; font-size: 12px;">https://search.google.com/local/writereview?placeid=<?php echo esc_attr($place_id); ?></code>
                                <button type="button" class="button button-small" onclick="navigator.clipboard.writeText(document.getElementById('wseo-review-link').textContent); this.textContent='✅ Skopírované!'; setTimeout(() => this.textContent='📋 Kopírovať link', 2000);">
                                    📋 Kopírovať link
                                </button>
                                <button type="button" class="button button-small" onclick="window.open('mailto:?subject=Ohodnoťte nás&body=Budeme radi ak nás ohodnotíte: ' + encodeURIComponent(document.getElementById('wseo-review-link').textContent));">
                                    ✉️ Poslať emailom
                                </button>
                            </div>
                            
                            <p class="description" style="margin-top: 10px;">
                                💡 <strong>Tip:</strong> Použite review link v email podpisoch, na faktúrach, QR kódoch alebo na webe.
                            </p>
                        </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <!-- v3.3.7: Review Widget REMOVED - requires external API integration -->
                <tr data-schema="localbusiness" data-schema-org="yes">
                    <th><label for="wseo_gbp_cid">Google CID (voliteľné)</label></th>
                    <td>
                        <input type="text" id="wseo_gbp_cid" name="wseo_gbp_cid" 
                               value="<?php echo esc_attr(get_option('wseo_gbp_cid', '')); ?>" 
                               class="regular-text" placeholder="1234567890123456789">
                        <p class="description">
                            Google Customer ID - nájdete v URL vášho GBP profilu. Používa sa pre alternatívne review linky.
                            <br><small>Formát: https://www.google.com/maps?cid=<strong>1234567890123456789</strong></small>
                        </p>
                    </td>
                </tr>
                
                <!-- REŠTAURÁCIA -->
                <tr class="wseo-section-header" data-schema="restaurant">
                    <th colspan="2">
                        <h3 style="margin: 20px 0 10px; padding-top: 15px; border-top: 2px solid #0073aa;">
                            🍽️ Reštaurácia (len pre Restaurant typy)
                        </h3>
                    </th>
                </tr>
                <tr data-schema="restaurant">
                    <th><label for="wseo_schema_cuisine">Typ kuchyne</label></th>
                    <td>
                        <input type="text" id="wseo_schema_cuisine" name="wseo_schema_cuisine" 
                               value="<?php echo esc_attr(get_option('wseo_schema_cuisine', '')); ?>" 
                               class="regular-text" placeholder="Slovenská, Talianska, Ázijská">
                        <p class="description">Typ kuchyne ktorú ponúkate.</p>
                    </td>
                </tr>
                <tr data-schema="restaurant">
                    <th><label for="wseo_schema_menu_url">URL menu</label></th>
                    <td>
                        <input type="url" id="wseo_schema_menu_url" name="wseo_schema_menu_url" 
                               value="<?php echo esc_url(get_option('wseo_schema_menu_url', '')); ?>" 
                               class="large-text" placeholder="https://example.sk/menu/">
                        <p class="description">Odkaz na stránku s menu.</p>
                    </td>
                </tr>
                <tr data-schema="restaurant">
                    <th><label for="wseo_schema_accepts_reservations">Rezervácie</label></th>
                    <td>
                        <label>
                            <input type="checkbox" id="wseo_schema_accepts_reservations" name="wseo_schema_accepts_reservations" 
                                   value="1" <?php checked(get_option('wseo_schema_accepts_reservations', ''), '1'); ?>>
                            Prijímame rezervácie
                        </label>
                    </td>
                </tr>
                <!-- KONIEC REŠTAURÁCIA -->
            </table>
        </div>
        
        <div class="wseo-admin-card">

            <h2>👤 Predvolené údaje autora/zakladateľa (Person)</h2>
            <p class="description" style="margin-bottom: 15px;">
                Tieto údaje sa použijú ako predvolené pre všetkých autorov a zakladateľa organizácie. Použijú sa na homepage, stránkach a článkoch.
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_default_person_name">Meno</label></th>
                    <td>
                        <input type="text" name="wseo_default_person_name" id="wseo_default_person_name"
                               value="<?php echo esc_attr(get_option('wseo_default_person_name', '')); ?>" 
                               class="large-text" placeholder="Karol Kameniczki">
                        <p class="description">Meno zakladateľa/hlavného autora webu.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_image">Fotka (URL)</label></th>
                    <td>
                        <input type="url" name="wseo_default_person_image" id="wseo_default_person_image"
                               value="<?php echo esc_url(get_option('wseo_default_person_image', '')); ?>" 
                               class="large-text" placeholder="https://example.com/photo.jpg">
                        <p class="description">URL fotografií (alebo sa použije Gravatar automaticky).</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_jobtitle">Pozícia/Titul</label></th>
                    <td>
                        <input type="text" name="wseo_default_person_jobtitle" id="wseo_default_person_jobtitle"
                               value="<?php echo esc_attr(get_option('wseo_default_person_jobtitle', '')); ?>" 
                               class="large-text" placeholder="Founder & CEO">
                        <p class="description">Pracovná pozícia alebo titul (napr. "Founder & CEO", "Webstudio.ltd").</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_url">URL profilu</label></th>
                    <td>
                        <input type="url" name="wseo_default_person_url" id="wseo_default_person_url"
                               value="<?php echo esc_url(get_option('wseo_default_person_url', '')); ?>" 
                               class="large-text" placeholder="https://webstudio.ltd/o-nas/">
                        <p class="description">URL stránky "O nás" alebo LinkedIn profil.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_social">Sociálne siete</label></th>
                    <td>
                        <textarea name="wseo_default_person_social" id="wseo_default_person_social" 
                                  rows="4" class="large-text" placeholder="https://twitter.com/vas-ucet
https://linkedin.com/in/vas-profil
https://facebook.com/vas-profil"><?php echo esc_textarea(get_option('wseo_default_person_social', '')); ?></textarea>
                        <p class="description">Jeden odkaz na riadok. Tieto sa použijú ako Person.sameAs na celom webe.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_email">Email</label></th>
                    <td>
                        <input type="email" name="wseo_default_person_email" id="wseo_default_person_email"
                               value="<?php echo esc_attr(get_option('wseo_default_person_email', '')); ?>" 
                               class="large-text" placeholder="meno@example.com">
                        <p class="description">Kontaktný email autora/zakladateľa (nepovinné).</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_telephone">Telefón</label></th>
                    <td>
                        <input type="tel" name="wseo_default_person_telephone" id="wseo_default_person_telephone"
                               value="<?php echo esc_attr(get_option('wseo_default_person_telephone', '')); ?>" 
                               class="large-text" placeholder="+421 900 123 456">
                        <p class="description">Kontaktný telefón (nepovinné).</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_default_person_address">Adresa</label></th>
                    <td>
                        <input type="text" name="wseo_default_person_address" id="wseo_default_person_address"
                               value="<?php echo esc_attr(get_option('wseo_default_person_address', '')); ?>" 
                               class="large-text" placeholder="Hlavná 123, 811 01 Bratislava, SK">
                        <p class="description">Adresa autora/zakladateľa (nepovinné, ale Google ju odporúča).</p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">

            <h2>🤖 AI popis firmy (pre llms.txt)</h2>
            <p class="description" style="margin-bottom: 15px;">
                Tieto informácie uvidia AI boty (ChatGPT, Claude, Perplexity, Google AI) v súbore <code>/llms.txt</code>.<br>
                Pomôžu AI presne pochopiť čím sa váš klient zaoberá.
            </p>
            <table class="form-table">
                <tr>
                    <th><label for="wseo_ai_company_name">Názov firmy</label></th>
                    <td>
                        <input type="text" id="wseo_ai_company_name" name="wseo_ai_company_name" 
                               value="<?php echo esc_attr(get_option('wseo_ai_company_name', '')); ?>" 
                               class="regular-text" placeholder="napr. CleanPro s.r.o.">
                        <p class="description">Oficiálny názov firmy alebo živnosti.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ai_what_we_do">Čím sa zaoberáme</label></th>
                    <td>
                        <textarea id="wseo_ai_what_we_do" name="wseo_ai_what_we_do" 
                                  rows="2" class="large-text" placeholder="napr. Poskytujeme profesionálne upratovacie služby pre domácnosti a firmy."><?php echo esc_textarea(get_option('wseo_ai_what_we_do', '')); ?></textarea>
                        <p class="description">Stručne opíšte hlavnú činnosť firmy (1-2 vety).</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ai_products_services">Produkty a služby</label></th>
                    <td>
                        <textarea id="wseo_ai_products_services" name="wseo_ai_products_services" 
                                  rows="3" class="large-text" placeholder="napr. Upratovanie kancelárií, bytov, rodinných domov. Čistenie okien, kobercov, čalúnenia. Upratovanie po rekonštrukcii."><?php echo esc_textarea(get_option('wseo_ai_products_services', '')); ?></textarea>
                        <p class="description">Konkrétne produkty alebo služby, ktoré ponúkate.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ai_location">Kde pôsobíme</label></th>
                    <td>
                        <input type="text" id="wseo_ai_location" name="wseo_ai_location" 
                               value="<?php echo esc_attr(get_option('wseo_ai_location', '')); ?>" 
                               class="large-text" placeholder="napr. Trnava, Piešťany, Hlohovec a okolie do 30 km">
                        <p class="description">Mesto, región alebo oblasť pôsobenia.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ai_target_audience">Pre koho sme tu</label></th>
                    <td>
                        <input type="text" id="wseo_ai_target_audience" name="wseo_ai_target_audience" 
                               value="<?php echo esc_attr(get_option('wseo_ai_target_audience', '')); ?>" 
                               class="large-text" placeholder="napr. Domácnosti, malé a stredné firmy, kancelárie, hotely">
                        <p class="description">Cieľová skupina zákazníkov.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ai_extra_info">Doplňujúce informácie</label></th>
                    <td>
                        <textarea id="wseo_ai_extra_info" name="wseo_ai_extra_info" 
                                  rows="2" class="large-text" placeholder="napr. Rodinná firma s 15-ročnou tradíciou. Používame ekologické čistiace prostriedky."><?php echo esc_textarea(get_option('wseo_ai_extra_info', '')); ?></textarea>
                        <p class="description">Čokoľvek dôležité, čo by AI mala vedieť (história, certifikáty, špecializácia...).</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ai_custom_text">📝 Vlastný text pre AI</label></th>
                    <td>
                        <textarea id="wseo_ai_custom_text" name="wseo_ai_custom_text" 
                                  rows="4" class="large-text" placeholder="Sem môžete napísať čokoľvek, čo chcete aby AI vedela o tomto webe. Tento text sa zobrazí v llms.txt presne tak, ako ho napíšete."><?php echo esc_textarea(get_option('wseo_ai_custom_text', '')); ?></textarea>
                        <p class="description">
                            <strong>Voľné pole pre akékoľvek doplnenie.</strong> Sem môžete napísať čokoľvek - upresnenia, špeciálne inštrukcie pre AI, alebo kompletný popis ak nechcete vyplňovať polia vyššie.
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🎙️ Speakable Schema (Voice Search & AI)</h2>
            <p class="description" style="margin-bottom: 15px;">
                <strong>Speakable</strong> označuje časti obsahu vhodné pre hlasové vyhľadávanie a AI asistentov (Google Assistant, Siri, Alexa).<br>
                Pomáha AI prečítať relevantné časti vášho obsahu používateľom.
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_enable_speakable">Povoliť Speakable</label></th>
                    <td>
                        <label class="wseo-toggle">
                            <input type="checkbox" id="wseo_enable_speakable" name="wseo_enable_speakable" value="1" 
                                   <?php checked(get_option('wseo_enable_speakable', '1'), '1'); ?>>
                            <span class="wseo-toggle-slider"></span>
                        </label>
                        <span style="margin-left: 10px;">Pridať Speakable schema do článkov a stránok</span>
                        <p class="description">
                            Automaticky označí titulok a prvý odsek ako vhodné pre text-to-speech (TTS).
                        </p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_speakable_mode">Režim výberu obsahu</label></th>
                    <td>
                        <select id="wseo_speakable_mode" name="wseo_speakable_mode">
                            <option value="auto" <?php selected(get_option('wseo_speakable_mode', 'auto'), 'auto'); ?>>
                                🤖 Automaticky (titulok + prvý odsek)
                            </option>
                            <option value="css" <?php selected(get_option('wseo_speakable_mode', 'auto'), 'css'); ?>>
                                🎯 CSS triedy (vlastné selektory)
                            </option>
                            <option value="manual" <?php selected(get_option('wseo_speakable_mode', 'auto'), 'manual'); ?>>
                                ✏️ Manuálne (zadať v každom príspevku)
                            </option>
                        </select>
                        <p class="description">
                            <strong>Auto:</strong> WSEO automaticky vyberie titulok a úvod článku.<br>
                            <strong>CSS:</strong> Označte elementy s triedou <code>.speakable</code> vo vašom obsahu.<br>
                            <strong>Manuálne:</strong> Zadajte CSS selektory pre každý príspevok v meta boxe.
                        </p>
                    </td>
                </tr>
                <tr id="wseo_speakable_css_row" style="<?php echo get_option('wseo_speakable_mode', 'auto') === 'css' ? '' : 'display:none;'; ?>">
                    <th><label for="wseo_speakable_css_classes">CSS selektory</label></th>
                    <td>
                        <input type="text" id="wseo_speakable_css_classes" name="wseo_speakable_css_classes" 
                               value="<?php echo esc_attr(get_option('wseo_speakable_css_classes', '.speakable, .voice-content')); ?>" 
                               class="large-text" placeholder=".speakable, .voice-content, .summary">
                        <p class="description">
                            Čiarkou oddelené CSS selektory. Elementy s týmito triedami budú označené ako Speakable.<br>
                            Príklad: Pridajte <code>class="speakable"</code> k odstavcom, ktoré chcete aby AI prečítala.
                        </p>
                    </td>
                </tr>
            </table>
            
            <script>
            jQuery(document).ready(function($) {
                $('#wseo_speakable_mode').on('change', function() {
                    if ($(this).val() === 'css') {
                        $('#wseo_speakable_css_row').show();
                    } else {
                        $('#wseo_speakable_css_row').hide();
                    }
                });
            });
            </script>
            
            <div class="wseo-alert info" style="margin-top: 15px;">
                <strong>💡 Tip pre Voice Search optimalizáciu:</strong>
                <ul style="margin: 10px 0 0 20px;">
                    <li>Píšte stručné, jasné vety (20-30 sekúnd na prečítanie)</li>
                    <li>Odpovedajte na otázky priamo v prvom odseku</li>
                    <li>Používajte prirodzený, konverzačný jazyk</li>
                    <li>Vyhýbajte sa skratkám a technickým termínom</li>
                </ul>
            </div>
        </div>
        
        <div class="wseo-admin-card">
            <h2>❓ FAQ Schema Auto-detect</h2>
            <p class="description" style="margin-bottom: 15px;">
                Automaticky nájde otázky a odpovede vo vašom obsahu a vytvorí FAQ Schema pre Google Rich Results.
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_faq_autodetect">Automatická detekcia FAQ</label></th>
                    <td>
                        <label class="wseo-toggle">
                            <input type="checkbox" id="wseo_faq_autodetect" name="wseo_faq_autodetect" value="1" 
                                   <?php checked(get_option('wseo_faq_autodetect', '1'), '1'); ?>>
                            <span class="wseo-toggle-slider"></span>
                        </label>
                        <span style="margin-left: 10px;">Automaticky detekovať FAQ z obsahu článkov</span>
                        <p class="description">
                            Detekuje nadpisy (H2, H3, H4) končiace otáznikom (?) alebo začínajúce slovami ako 
                            <code>Čo</code>, <code>Ako</code>, <code>Prečo</code>, <code>Kedy</code> atď.
                        </p>
                    </td>
                </tr>
            </table>
            
            <div class="wseo-alert info" style="margin-top: 15px;">
                <strong>💡 Ako písať FAQ-friendly obsah:</strong>
                <ul style="margin: 10px 0 0 20px;">
                    <li>Používajte nadpisy ako otázky: <code>&lt;h2&gt;Koľko stojí bazén?&lt;/h2&gt;</code></li>
                    <li>Odpoveď napíšte v nasledujúcom odstavci</li>
                    <li>Maximálne 10 FAQ z jedného článku bude zahrnutých do schémy</li>
                    <li>Manuálne FAQ v meta boxe majú prioritu pred auto-detekciou</li>
                </ul>
            </div>
        </div>
        
        <div class="wseo-admin-card">

            <h2>📱 Sociálne siete</h2>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_global_og_image">Predvolený OG obrázok</label></th>
                    <td>
                        <input type="url" id="wseo_global_og_image" name="wseo_global_og_image" 
                               value="<?php echo esc_url(get_option('wseo_global_og_image', '')); ?>" 
                               class="large-text" placeholder="https://example.com/image.jpg">
                        <p class="description">Odporúčaná veľkosť: 1200×630 pixelov. Vložte URL obrázka.</p>
                        
                        <?php if (get_option('wseo_global_og_image')): ?>
                        <div class="wseo-image-preview" style="margin-top: 10px;">
                            <img src="<?php echo esc_url(get_option('wseo_global_og_image')); ?>" alt="">
                        </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_global_twitter_handle">Twitter účet</label></th>
                    <td>
                        <input type="text" id="wseo_global_twitter_handle" name="wseo_global_twitter_handle" 
                               value="<?php echo esc_attr(get_option('wseo_global_twitter_handle', '')); ?>" 
                               class="regular-text" placeholder="@username">
                        <p class="description">Vaše Twitter/X užívateľské meno.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_global_fb_app_id">Facebook App ID</label></th>
                    <td>
                        <input type="text" id="wseo_global_fb_app_id" name="wseo_global_fb_app_id" 
                               value="<?php echo esc_attr(get_option('wseo_global_fb_app_id', '')); ?>" 
                               class="regular-text" placeholder="123456789012345">
                        <p class="description">Voliteľné. Pre Facebook Insights.</p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">

            <h2>🔗 URL Permalinky</h2>
            <p class="description" style="margin-bottom: 15px;">
                Odstráňte zbytočné prefixy z URL adries pre lepšie SEO a krajšie odkazy.
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Odstrániť /category/ z URL</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_remove_category_base" value="1" 
                                   <?php checked(get_option('wseo_remove_category_base', '1'), '1'); ?>>
                            Odstrániť <code>/category/</code> z URL kategórií
                        </label>
                        <p class="description">
                            <strong>Pred:</strong> <code>example.sk/category/zdravy-domov/</code><br>
                            <strong>Po:</strong> <code>example.sk/zdravy-domov/</code>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>Odstrániť /tag/ z URL</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_remove_tag_base" value="1" 
                                   <?php checked(get_option('wseo_remove_tag_base', '1'), '1'); ?>>
                            Odstrániť <code>/tag/</code> z URL značiek
                        </label>
                        <p class="description">
                            <strong>Pred:</strong> <code>example.sk/tag/bio/</code><br>
                            <strong>Po:</strong> <code>example.sk/bio/</code>
                        </p>
                    </td>
                </tr>
                <?php if (class_exists('WooCommerce')): 
                    $wc_permalinks = get_option('woocommerce_permalinks', array());
                    $current_product_base = isset($wc_permalinks['product_base']) ? trim($wc_permalinks['product_base'], '/') : 'product';
                    $current_category_base = isset($wc_permalinks['category_base']) ? trim($wc_permalinks['category_base'], '/') : 'kategoria-produktu';
                    $remove_product_base = get_option('wseo_remove_product_base', '0');
                    $remove_product_cat_base = get_option('wseo_remove_product_cat_base', '0');
                ?>
                <tr>
                    <th>Odstrániť prefix z URL produktov</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_remove_product_base" value="1" 
                                   <?php checked($remove_product_base, '1'); ?>>
                            Odstrániť <code>/<?php echo esc_html($current_product_base ?: 'produkt'); ?>/</code> z URL produktov
                        </label>
                        <p class="description">
                            <strong>Pred:</strong> <code>example.sk/<?php echo esc_html($current_product_base ?: 'produkt'); ?>/nazov-produktu/</code><br>
                            <strong>Po:</strong> <code>example.sk/nazov-produktu/</code>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>Odstrániť prefix z URL kategórií produktov</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_remove_product_cat_base" value="1" 
                                   <?php checked($remove_product_cat_base, '1'); ?>>
                            Odstrániť <code>/<?php echo esc_html($current_category_base ?: 'kategoria-produktu'); ?>/</code> z URL kategórií
                        </label>
                        <p class="description">
                            <strong>Pred:</strong> <code>example.sk/<?php echo esc_html($current_category_base ?: 'kategoria-produktu'); ?>/pletiva-a-sita/</code><br>
                            <strong>Po:</strong> <code>example.sk/pletiva-a-sita/</code>
                        </p>
                        <p class="description" style="margin-top: 10px; padding: 10px; background: #e8f5e9; border-radius: 4px;">
                            <strong>💡 SEO výhody kratších URL:</strong><br>
                            • Lepšie CTR vo výsledkoch vyhľadávania<br>
                            • Keyword bližšie k doméne<br>
                            • Ľahšie zdieľanie a zapamätanie
                        </p>
                    </td>
                </tr>
                <?php endif; ?>
            </table>
            
            <div style="background: #fff3cd; padding: 15px; border-radius: 4px; margin-top: 15px; border-left: 4px solid #ffc107;">
                <strong>⚠️ Po aktivácii pluginu alebo zmene týchto nastavení:</strong><br>
                1. Prejdite do <strong>Nastavenia → Trvalé odkazy</strong><br>
                2. Kliknite na <strong>"Uložiť zmeny"</strong> (bez zmeny čohokoľvek)<br>
                <span style="color: #666; font-size: 12px;">Tým sa obnovia rewrite pravidlá WordPress-u.</span>
            </div>
            
            <?php if (class_exists('WooCommerce')): ?>
            <div style="background: #d4edda; padding: 15px; border-radius: 4px; margin-top: 15px; border-left: 4px solid #28a745;">
                <strong>✅ Automatické presmerovania:</strong><br>
                Plugin automaticky presmeruje staré URL (<code>/produkt/</code>, <code>/kategoria-produktu/</code>, atď.) na nové čisté URL s 301 redirectom.
                Tým sa zachová SEO ranking zo starých odkazov.
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Google Private Prefetch Proxy - funguje automaticky na pozadí, používateľ nemusí konfigurovať -->
        
        <div class="wseo-admin-card">

            <h2>🥖 Breadcrumbs (Omrvinkové navigácie)</h2>
            <p class="description" style="margin-bottom: 15px;">
                Schema.org breadcrumbs zlepšujú zobrazenie vášho webu vo výsledkoch vyhľadávania Google.
            </p>
            
            <table class="form-table">
                <tr>
                    <td colspan="2">
                        <div style="padding: 15px; background: #d1ecf1; border-left: 4px solid #0c5460; border-radius: 4px;">
                            <strong>ℹ️ Breadcrumbs Schema sú permanentne zapnuté</strong>
                            <p style="margin: 5px 0 0 0;">Breadcrumbs Schema (omrvinkové navigácie) sú automaticky generované na všetkých stránkach pre Google Search Console. Toto nastavenie nemožno vypnúť kvôli zabráneniu chýb v Google.</p>
                        </div>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_breadcrumb_home">Text pre "Domov"</label></th>
                    <td>
                        <input type="text" id="wseo_breadcrumb_home" name="wseo_breadcrumb_home" 
                               value="<?php echo esc_attr(get_option('wseo_breadcrumb_home', 'Domov')); ?>" 
                               class="regular-text" placeholder="Domov">
                        <p class="description">Text pre prvú položku v breadcrumbs (domovská stránka).</p>
                    </td>
                </tr>
            </table>
            
            <div style="background: #f0f0f1; padding: 15px; border-radius: 4px; margin-top: 15px;">
                <strong>📍 Príklad výstupu:</strong><br>
                <code style="display: block; margin-top: 10px; padding: 10px; background: #fff; border-radius: 3px;">
                    Domov › Blog › Technológie › Názov článku
                </code>
                <p class="description" style="margin-top: 10px; margin-bottom: 0;">
                    Google zobrazí breadcrumbs priamo vo výsledkoch vyhľadávania namiesto URL adresy.
                </p>
            </div>
        </div>
        
        <div class="wseo-admin-card">

            <h2>📊 Google Analytics</h2>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_ga_id">Google Analytics 4 (GA4)</label></th>
                    <td>
                        <input type="text" id="wseo_ga_id" name="wseo_ga_id" 
                               value="<?php echo esc_attr(get_option('wseo_ga_id', '')); ?>" 
                               class="regular-text" placeholder="G-XXXXXXXXXX">
                        <p class="description">Measurement ID z Google Analytics 4. Nájdete ho v GA4 → Admin → Data Streams.</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_ga_anonymize">Anonymizovať IP</label></th>
                    <td>
                        <label>
                            <input type="checkbox" id="wseo_ga_anonymize" name="wseo_ga_anonymize" value="1" 
                                   <?php checked(get_option('wseo_ga_anonymize', '1'), '1'); ?>>
                            Anonymizovať IP adresy návštevníkov (odporúčané pre GDPR)
                        </label>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_gtm_id">Google Tag Manager</label></th>
                    <td>
                        <input type="text" id="wseo_gtm_id" name="wseo_gtm_id" 
                               value="<?php echo esc_attr(get_option('wseo_gtm_id', '')); ?>" 
                               class="regular-text" placeholder="GTM-XXXXXXX">
                        <p class="description">Voliteľné. Container ID z Google Tag Manager.</p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">

            <h2>🚀 Auto Performance Optimizer</h2>
            <p class="description" style="margin-bottom: 15px;">
                Automatické optimalizácie výkonu bez nastavení. 100% bezpečné pre všetky weby a page buildery.
            </p>
            
            <div style="background: #d1f2eb; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
                <h3 style="margin-top: 0; color: #155724;">✅ Aktívne optimalizácie (vždy zapnuté)</h3>
                <table class="widefat" style="background: transparent; border: none;">
                    <tr>
                        <td style="padding: 8px 0; border: none;"><strong>🖼️ Lazy Loading obrázkov</strong></td>
                        <td style="padding: 8px 0; border: none;">Obrázky sa načítajú až keď sú viditeľné</td>
                        <td style="padding: 8px 0; border: none; color: #28a745;"><strong>✓ Aktívne</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border: none;"><strong>🎬 Lazy Loading iframes</strong></td>
                        <td style="padding: 8px 0; border: none;">YouTube, Vimeo, mapy sa načítajú pri scrolle</td>
                        <td style="padding: 8px 0; border: none; color: #28a745;"><strong>✓ Aktívne</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border: none;"><strong>⚡ LCP Optimalizácia</strong></td>
                        <td style="padding: 8px 0; border: none;">Prvý obrázok má vysokú prioritu načítania</td>
                        <td style="padding: 8px 0; border: none; color: #28a745;"><strong>✓ Aktívne</strong></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; border: none;"><strong>💾 Browser Cache Headers</strong></td>
                        <td style="padding: 8px 0; border: none;">Opakované návštevy sú okamžité</td>
                        <td style="padding: 8px 0; border: none; color: #28a745;"><strong>✓ Aktívne</strong></td>
                    </tr>
                </table>
            </div>
            
            <?php
            // Check for old cache files
            $old_cache_dir = WP_CONTENT_DIR . '/cache/wseo/';
            $old_cache_exists = is_dir($old_cache_dir) && count(glob($old_cache_dir . '*')) > 1;
            ?>
            
            <?php if ($old_cache_exists): ?>
            <div style="background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; border-radius: 4px; margin-bottom: 20px;">
                <strong>⚠️ Nájdené staré cache súbory</strong><br>
                <p style="margin: 10px 0;">Stará Page Cache z verzie 2.6.2 bola nahradená bezpečnejším riešením.</p>
                <button type="button" class="button button-secondary" id="wseo-clear-cache">
                    🗑️ Vymazať staré cache súbory
                </button>
            </div>
            <?php endif; ?>
            
            <div style="background: #e7f3ff; padding: 15px; border-left: 4px solid #0073aa; border-radius: 4px;">
                <strong>📊 Čo to znamená pre váš web:</strong>
                <ul style="margin: 10px 0 0 20px;">
                    <li><strong>LCP skóre:</strong> zlepšenie o 15-30%</li>
                    <li><strong>Opakované návštevy:</strong> takmer okamžité načítanie</li>
                    <li><strong>Kompatibilita:</strong> funguje so všetkými page buildermi</li>
                    <li><strong>Bezpečnosť:</strong> žiadne riziko rozbitia dizajnu</li>
                </ul>
            </div>
            
            <p class="description" style="margin-top: 15px; font-style: italic;">
                💡 Tieto optimalizácie používajú natívne HTML atribúty podporované všetkými modernými prehliadačmi. 
                Nie je potrebná žiadna konfigurácia.
            </p>
        </div>
        
        <div class="wseo-admin-card">
            <h2>⚡ Critical CSS (Performance)</h2>
            <p class="description" style="margin-bottom: 15px;">
                Inline critical CSS pre rýchlejšie načítanie above-the-fold obsahu. Zlepšuje LCP (Largest Contentful Paint).
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_critical_css_enabled">Critical CSS Inline</label></th>
                    <td>
                        <label class="wseo-toggle">
                            <input type="checkbox" id="wseo_critical_css_enabled" name="wseo_critical_css_enabled" value="1" 
                                   <?php checked(get_option('wseo_critical_css_enabled', '0'), '1'); ?>>
                            <span class="wseo-toggle-slider"></span>
                        </label>
                        <span style="margin-left: 10px;">Vložiť kritické CSS priamo do HTML</span>
                        <p class="description">
                            Vloží základné štýly pre hlavičku, navigáciu a above-the-fold obsah priamo do <code>&lt;head&gt;</code>.<br>
                            <span style="color: #d63638;">⚠️ Experimentálne - otestujte na staging pred produkciou!</span>
                        </p>
                    </td>
                </tr>
                <tr id="wseo_critical_css_custom_row" style="<?php echo get_option('wseo_critical_css_enabled', '0') === '1' ? '' : 'display:none;'; ?>">
                    <th><label for="wseo_critical_css_custom">Vlastné Critical CSS</label></th>
                    <td>
                        <textarea id="wseo_critical_css_custom" name="wseo_critical_css_custom" 
                                  rows="8" class="large-text code" 
                                  placeholder="/* Vlastné kritické CSS */
body { font-family: system-ui, sans-serif; }
.header { background: #fff; }
.hero { min-height: 50vh; }"><?php echo esc_textarea(get_option('wseo_critical_css_custom', '')); ?></textarea>
                        <p class="description">
                            Zadajte vlastné CSS ktoré sa má vložiť inline. Ak necháte prázdne, použije sa predvolené critical CSS.<br>
                            💡 <strong>Tip:</strong> Použite nástroje ako <a href="https://www.criticalcss.com/" target="_blank">Critical CSS Generator</a> 
                            pre extrakciu critical CSS z vašej stránky.
                        </p>
                    </td>
                </tr>
            </table>
            
            <script>
            jQuery(document).ready(function($) {
                $('#wseo_critical_css_enabled').on('change', function() {
                    if ($(this).is(':checked')) {
                        $('#wseo_critical_css_custom_row').show();
                    } else {
                        $('#wseo_critical_css_custom_row').hide();
                    }
                });
            });
            </script>
        </div>
        
        <div class="wseo-admin-card">

            <h2>⚡ Výkon a Prednačítavanie</h2>
            <p class="description" style="margin-bottom: 15px;">
                Inteligentné prednačítavanie stránok, resource hints a optimalizácie pre rýchlejšie načítanie webu.
                <strong>Očakávané zlepšenie:</strong> LCP -30-50%, Navigation -40-60%
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Inteligentné Prefetch</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_enable_prefetch" value="1" 
                                   <?php checked(get_option('wseo_enable_prefetch', '1'), '1'); ?>>
                            Povoliť inteligentné prednačítavanie stránok
                        </label>
                        <p class="description">
                            Automaticky prednačíta stránky pre rýchlejšiu navigáciu. Používa modernú Speculation Rules API s fallbackom.
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Prefetch stratégia</th>
                    <td>
                        <select name="wseo_prefetch_strategy" class="regular-text">
                            <option value="hover" <?php selected(get_option('wseo_prefetch_strategy', 'hover'), 'hover'); ?>>
                                Pri navedení myšou (odporúčané) 🖱️
                            </option>
                            <option value="viewport" <?php selected(get_option('wseo_prefetch_strategy'), 'viewport'); ?>>
                                Keď je link viditeľný 👁️
                            </option>
                            <option value="idle" <?php selected(get_option('wseo_prefetch_strategy'), 'idle'); ?>>
                                Počas idle času ⏱️
                            </option>
                            <option value="eager" <?php selected(get_option('wseo_prefetch_strategy'), 'eager'); ?>>
                                Agresívne (všetko hneď) ⚡
                            </option>
                        </select>
                        <p class="description">
                            <strong>Hover:</strong> Prefetch keď užívateľ navedie myšou (najlepší kompromis)<br>
                            <strong>Viewport:</strong> Prefetch keď link je vo viditeľnej oblasti<br>
                            <strong>Idle:</strong> Prefetch počas nečinnosti prehliadača<br>
                            <strong>Eager:</strong> Prefetch všetkých linkov okamžite (vysoká záťaž)
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Rýchle predvoľby</th>
                    <td>
                        <div style="background: #f0f0f1; padding: 15px; border-radius: 5px;">
                            <strong>⚡ Kliknite na typ vášho webu pre optimálne nastavenia:</strong>
                            <div style="margin-top: 10px; display: flex; gap: 10px; flex-wrap: wrap;">
                                <button type="button" class="button" onclick="setPrefetchPreset('blog')">
                                    📰 Blog/Magazine
                                </button>
                                <button type="button" class="button" onclick="setPrefetchPreset('ecommerce')">
                                    🛒 E-commerce
                                </button>
                                <button type="button" class="button" onclick="setPrefetchPreset('business')">
                                    💼 Portfolio/Business
                                </button>
                            </div>
                        </div>
                        
                        <script>
                        function setPrefetchPreset(type) {
                            var presets = {
                                'blog': { delay: 400, concurrent: 1, pages: 3 },
                                'ecommerce': { delay: 250, concurrent: 1, pages: 5 },
                                'business': { delay: 175, concurrent: 2, pages: 8 }
                            };
                            
                            var preset = presets[type];
                            document.querySelector('input[name="wseo_prefetch_hover_delay"]').value = preset.delay;
                            document.querySelector('input[name="wseo_prefetch_max_concurrent"]').value = preset.concurrent;
                            document.querySelector('input[name="wseo_prefetch_max_pages"]').value = preset.pages;
                            
                            var typeNames = {
                                'blog': 'Blog/Magazine',
                                'ecommerce': 'E-commerce',
                                'business': 'Portfolio/Business'
                            };
                            
                            alert('✅ Nastavené predvoľby pre: ' + typeNames[type] + '\n\n' +
                                  'Hover delay: ' + preset.delay + 'ms\n' +
                                  'Max súbežných: ' + preset.concurrent + '\n' +
                                  'Max stránok: ' + preset.pages + '\n\n' +
                                  'Nezabudnite uložiť zmeny!');
                        }
                        </script>
                    </td>
                </tr>
                
                <tr>
                    <th>Hover delay (ms)</th>
                    <td>
                        <input type="number" name="wseo_prefetch_hover_delay" 
                            value="<?php echo esc_attr(get_option('wseo_prefetch_hover_delay', '250')); ?>" 
                            min="0" max="1000" step="5" class="small-text">
                        <p class="description">
                            Čas v milisekundách pred spustením prefetch pri navedení myšou.<br>
                            <strong>💡 Odporúčané nastavenia podľa typu webu:</strong><br>
                            • <strong>Blog/Magazine (vysoký traffic):</strong> 300-500ms<br>
                            • <strong>E-commerce (stredný traffic):</strong> 250ms<br>
                            • <strong>Portfolio/Business (nízky traffic):</strong> 150-200ms
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Max súbežných prefetch</th>
                    <td>
                        <input type="number" name="wseo_prefetch_max_concurrent" 
                            value="<?php echo esc_attr(get_option('wseo_prefetch_max_concurrent', '1')); ?>" 
                            min="1" max="10" class="small-text">
                        <p class="description">
                            Maximálny počet súbežne načítavaných stránok.<br>
                            <strong>💡 Odporúčané nastavenia podľa typu webu:</strong><br>
                            • <strong>Blog/Magazine (vysoký traffic):</strong> 1<br>
                            • <strong>E-commerce (stredný traffic):</strong> 1<br>
                            • <strong>Portfolio/Business (nízky traffic):</strong> 2
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Max celkovo prefetch stránok</th>
                    <td>
                        <input type="number" name="wseo_prefetch_max_pages" 
                            value="<?php echo esc_attr(get_option('wseo_prefetch_max_pages', '5')); ?>" 
                            min="1" max="50" class="small-text">
                        <p class="description">
                            Maximálny celkový počet prednačítaných stránok za session.<br>
                            <strong>💡 Odporúčané nastavenia podľa typu webu:</strong><br>
                            • <strong>Blog/Magazine (vysoký traffic):</strong> 3<br>
                            • <strong>E-commerce (stredný traffic):</strong> 5<br>
                            • <strong>Portfolio/Business (nízky traffic):</strong> 8
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Vylúčiť z prefetch</th>
                    <td>
                        <textarea name="wseo_prefetch_exclude" rows="5" class="large-text" placeholder="/kontakt/&#10;/checkout/&#10;\?page=admin"><?php 
                            echo esc_textarea(get_option('wseo_prefetch_exclude', '')); 
                        ?></textarea>
                        <p class="description">
                            Regex vzory pre URL, ktoré sa nemajú prednačítať (každý na novom riadku)<br>
                            <strong>Príklady:</strong> <code>/kontakt/</code>, <code>/checkout/</code>, <code>\?page=admin</code><br>
                            <em>WooCommerce stránky (košík, pokladňa) sú automaticky vylúčené.</em>
                        </p>
                    </td>
                </tr>
            </table>
            
            <h3 style="margin-top: 30px;">🔗 Resource Hints</h3>
            <table class="form-table">
                <tr>
                    <th>Auto-detect externé domény</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_auto_detect_external_domains" value="1" 
                                   <?php checked(get_option('wseo_auto_detect_external_domains', '1'), '1'); ?>>
                            Automaticky detekovať externé domény pre DNS prefetch
                        </label>
                        <p class="description">
                            Automaticky pridá <code>&lt;link rel="dns-prefetch"&gt;</code> pre externé domény v obsahu stránky.
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Google Fonts preconnect</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_preconnect_google_fonts" value="1" 
                                   <?php checked(get_option('wseo_preconnect_google_fonts', '1'), '1'); ?>>
                            Preconnect na Google Fonts
                        </label>
                        <p class="description">
                            Pridá <code>&lt;link rel="preconnect"&gt;</code> pre fonts.googleapis.com a fonts.gstatic.com.
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>CDN URL</th>
                    <td>
                        <input type="url" name="wseo_cdn_url" class="regular-text" 
                            value="<?php echo esc_attr(get_option('wseo_cdn_url', '')); ?>" 
                            placeholder="https://cdn.example.com">
                        <p class="description">
                            Preconnect na vašu CDN doménu pre rýchlejšie načítanie statických súborov.
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Custom DNS Prefetch</th>
                    <td>
                        <textarea name="wseo_custom_dns_prefetch" rows="3" class="large-text" placeholder="cdn.example.com&#10;analytics.example.com"><?php 
                            echo esc_textarea(get_option('wseo_custom_dns_prefetch', '')); 
                        ?></textarea>
                        <p class="description">
                            Každá doména na novom riadku (napr. <code>cdn.example.com</code>)
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Custom Preconnect</th>
                    <td>
                        <textarea name="wseo_custom_preconnect" rows="3" class="large-text" placeholder="https://api.example.com&#10;https://cdn.example.com [crossorigin]"><?php 
                            echo esc_textarea(get_option('wseo_custom_preconnect', '')); 
                        ?></textarea>
                        <p class="description">
                            Formát: <code>https://domain.com</code> alebo <code>https://domain.com [crossorigin]</code>
                        </p>
                    </td>
                </tr>
            </table>
            
            <h3 style="margin-top: 30px;">🖼️ Hero Image Preload</h3>
            <table class="form-table">
                <tr>
                    <th>Preload hero images</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_preload_hero_images" value="1" 
                                   <?php checked(get_option('wseo_preload_hero_images', '1'), '1'); ?>>
                            Automaticky preload featured images
                        </label>
                        <p class="description">
                            Pridá <code>&lt;link rel="preload" fetchpriority="high"&gt;</code> pre featured image.<br>
                            <strong>Výhoda:</strong> Zlepší Largest Contentful Paint (LCP) metriku o 30-50%!
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th>Homepage hero image</th>
                    <td>
                        <input type="url" name="wseo_homepage_hero_image" class="large-text" 
                            value="<?php echo esc_attr(get_option('wseo_homepage_hero_image', '')); ?>" 
                            placeholder="https://example.com/hero.jpg">
                        <p class="description">
                            URL hlavného obrázku na domovskej stránke (ak máte).
                        </p>
                    </td>
                </tr>
            </table>
            
            <h3 style="margin-top: 30px;">🧠 Pokročilé</h3>
            <table class="form-table">
                <tr>
                    <th>Adaptívne načítavanie</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_adaptive_loading" value="1" 
                                   <?php checked(get_option('wseo_adaptive_loading', '1'), '1'); ?>>
                            Prispôsobiť stratégiu podľa kvality pripojenia
                        </label>
                        <p class="description">
                            Automaticky vypne prefetch na pomalých pripojeniach (2G/3G) a "Save Data" režime.<br>
                            <strong>Technológia:</strong> Network Information API
                        </p>
                    </td>
                </tr>
            </table>
            
            <div style="background: #d1f2eb; padding: 15px; border-left: 4px solid #28a745; border-radius: 4px; margin-top: 20px;">
                <strong>✅ Odporúčané nastavenia pre start:</strong><br>
                <ul style="margin: 10px 0 0 20px;">
                    <li>Prefetch: <strong>Zapnutý</strong></li>
                    <li>Stratégia: <strong>Hover (65ms delay)</strong></li>
                    <li>Hero Image Preload: <strong>Zapnutý</strong></li>
                    <li>Resource Hints: <strong>Auto-detect</strong></li>
                    <li>Adaptive Loading: <strong>Zapnutý</strong></li>
                </ul>
            </div>
            
            <div style="background: #fff3cd; padding: 15px; border-left: 4px solid #ffc107; border-radius: 4px; margin-top: 15px;">
                <strong>📊 Očakávané zlepšenia výkonu:</strong><br>
                <ul style="margin: 10px 0 0 20px;">
                    <li><strong>LCP (Largest Contentful Paint):</strong> -30-50% (preload hero images)</li>
                    <li><strong>Navigation Speed:</strong> -40-60% (intelligent prefetch)</li>
                    <li><strong>FCP (First Contentful Paint):</strong> -20-30% (resource hints)</li>
                </ul>
                <p style="margin: 10px 0 0 0;"><em>Otestujte na <a href="https://pagespeed.web.dev/" target="_blank">PageSpeed Insights</a> pred a po aktivácii.</em></p>
            </div>
        </div>
        
        <!-- ============================================== -->
        <!-- AUTO PERFORMANCE OPTIMIZER (v2.6.3) -->
        <!-- ============================================== -->
        <div class="wseo-admin-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;">
            <h2 style="color: white; margin-top: 0;">🚀 Automatická optimalizácia obrázkov</h2>
            <p style="font-size: 15px; line-height: 1.6; margin-bottom: 20px;">
                <strong>Každý nový obrázok je automaticky optimalizovaný pri nahratí!</strong>
            </p>
            
            <div style="background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px; margin-bottom: 15px;">
                <h3 style="color: white; margin-top: 0; font-size: 16px;">✨ Čo sa vykonáva automaticky:</h3>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li style="margin-bottom: 8px;">✅ JPEG kompressia kvalita 85% (vizuálne bez rozdielu)</li>
                    <li style="margin-bottom: 8px;">✅ PNG optimalizácia s max kompresiou</li>
                    <li style="margin-bottom: 8px;">✅ Odstránenie EXIF metadát (GPS, fotoaparát, atď.)</li>
                    <li style="margin-bottom: 8px;">✅ Vytvorenie WebP verzií (pre moderné browsery)</li>
                    <li style="margin-bottom: 8px;">✅ Bezpečná záloha originálnych súborov</li>
                </ul>
            </div>
            
            <div style="background: rgba(255,255,255,0.1); padding: 15px; border-radius: 8px;">
                <h3 style="color: white; margin-top: 0; font-size: 16px;">📊 Typická úspora:</h3>
                <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px; margin-top: 10px;">
                    <div style="background: rgba(255,255,255,0.2); padding: 10px; border-radius: 4px; text-align: center;">
                        <div style="font-size: 24px; font-weight: bold;">~25%</div>
                        <div style="font-size: 13px; opacity: 0.9;">JPEG</div>
                    </div>
                    <div style="background: rgba(255,255,255,0.2); padding: 10px; border-radius: 4px; text-align: center;">
                        <div style="font-size: 24px; font-weight: bold;">~35%</div>
                        <div style="font-size: 13px; opacity: 0.9;">PNG</div>
                    </div>
                    <div style="background: rgba(255,255,255,0.2); padding: 10px; border-radius: 4px; text-align: center;">
                        <div style="font-size: 24px; font-weight: bold;">~30%</div>
                        <div style="font-size: 13px; opacity: 0.9;">WebP</div>
                    </div>
                </div>
            </div>
            
            <p style="margin-top: 20px; margin-bottom: 0; opacity: 0.9; font-size: 14px;">
                💡 <strong>Pre optimalizáciu existujúcich obrázkov:</strong> 
                Prejdite na <a href="<?php echo admin_url('admin.php?page=webstudio-seo-images'); ?>" style="color: white; text-decoration: underline;">SEO Pro → Obrázky</a>
            </p>
        </div>
        
        <p class="submit">
            <input type="submit" name="wseo_save_global" class="button button-primary" value="Uložiť nastavenia">
        </p>
    </form>
    
    <script>
    jQuery(document).ready(function($) {
        // v2.9.13: Schema type field visibility configuration
        var localBusinessTypes = [
            'LocalBusiness', 'Restaurant', 'CafeOrCoffeeShop', 'Bakery', 'BarOrPub', 
            'FastFoodRestaurant', 'IceCreamShop', 'Winery', 'Brewery', 'Distillery',
            'Store', 'ClothingStore', 'ElectronicsStore', 'FurnitureStore', 'GroceryStore',
            'HardwareStore', 'JewelryStore', 'LiquorStore', 'PetStore', 'ShoeStore',
            'SportingGoodsStore', 'ToyStore', 'Florist', 'BikeStore', 'BookStore',
            'ComputerStore', 'ConvenienceStore', 'DepartmentStore', 'GardenStore',
            'HobbyShop', 'HomeGoodsStore', 'MensClothingStore', 'MobilePhoneStore',
            'MusicStore', 'OfficeEquipmentStore', 'OutletStore', 'PawnShop', 'TireShop', 'WholesaleStore',
            'Hotel', 'LodgingBusiness', 'BedAndBreakfast', 'Hostel', 'Motel', 'Resort',
            'Campground', 'SkiResort', 'VacationRental',
            'ProfessionalService', 'FinancialService', 'LegalService', 'RealEstateAgent',
            'BeautySalon', 'HairSalon', 'NailSalon', 'DaySpa', 'TattooParlor', 'HealthAndBeautyBusiness',
            'MedicalBusiness', 'Dentist',
            'AutoRepair', 'AutoBodyShop', 'AutoPartsStore', 'AutoRental', 'AutoWash', 
            'GasStation', 'MotorcycleDealer', 'MotorcycleRepair',
            'Electrician', 'GeneralContractor', 'HVACBusiness', 'HousePainter', 
            'Locksmith', 'MovingCompany', 'Plumber', 'RoofingContractor'
        ];
        
        var lodgingTypes = ['VacationRental', 'LodgingBusiness', 'Hotel', 'BedAndBreakfast', 'Hostel', 'Motel', 'Resort', 'Campground', 'SkiResort'];
        var restaurantTypes = ['Restaurant', 'FastFoodRestaurant', 'CafeOrCoffeeShop', 'Bakery', 'BarOrPub', 'Brewery', 'Winery', 'IceCreamShop', 'Distillery'];
        var organizationTypes = ['Organization', 'NewsMediaOrganization'];
        
        // Schema.org conditional fields
        function updateSchemaFields() {
            var schemaType = $('#wseo_schema_type').val();
            var isLocalBusiness = localBusinessTypes.indexOf(schemaType) !== -1;
            var isOrganization = organizationTypes.indexOf(schemaType) !== -1;
            var isLodging = lodgingTypes.indexOf(schemaType) !== -1;
            var isRestaurant = restaurantTypes.indexOf(schemaType) !== -1;
            
            // Hide all conditional sections first
            $('tr[data-schema="localbusiness"]').hide();
            $('tr[data-schema="organization"]').hide();
            $('tr[data-schema="lodging"]').hide();
            $('tr[data-schema="restaurant"]').hide();
            $('.wseo-section-header[data-schema="lodging"]').hide();
            $('.wseo-section-header[data-schema="restaurant"]').hide();
            
            // Always show basic fields (name, logo, description)
            $('tr[data-schema="basic"]').show();
            
            if (isLocalBusiness) {
                // Show ALL LocalBusiness fields (address, GPS, opening hours, price range, contact, social)
                $('tr[data-schema="localbusiness"]').show();
                $('tr[data-schema="contact"]').show();
                $('tr[data-schema="social"]').show();
                
                // Show Lodging section if applicable
                if (isLodging) {
                    $('tr[data-schema="lodging"]').show();
                    $('.wseo-section-header[data-schema="lodging"]').show();
                }
                
                // Show Restaurant section if applicable  
                if (isRestaurant) {
                    $('tr[data-schema="restaurant"]').show();
                    $('.wseo-section-header[data-schema="restaurant"]').show();
                }
                
                // Show address validation warning
                var street = $('#wseo_schema_address_street').val();
                var city = $('#wseo_schema_address_city').val();
                
                if (!street && !city) {
                    if ($('.wseo-address-warning').length === 0) {
                        $('#wseo_schema_address_street').closest('td').prepend(
                            '<div class="wseo-address-warning" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 10px; margin-bottom: 10px;">' +
                            '<strong>⚠️ UPOZORNENIE:</strong> LocalBusiness typ vyžaduje adresu! Vyplňte aspoň ulicu alebo mesto.' +
                            '</div>'
                        );
                    }
                } else {
                    $('.wseo-address-warning').remove();
                }
            } else if (isOrganization) {
                // v3.3: Show contact, social AND address for Organization (address is optional but recommended)
                $('tr[data-schema="organization"]').show();
                $('tr[data-schema="contact"]').show();
                $('tr[data-schema="social"]').show();
                
                // Show address fields that are also useful for Organization (marked with data-schema-org="yes")
                $('tr[data-schema="localbusiness"][data-schema-org="yes"]').show();
                
                // Hide LocalBusiness-only fields (opening hours, price range, branches, GBP)
                $('tr[data-schema-lb-only="yes"]').hide();
                
                $('.wseo-address-warning').remove();
            }
        }
        
        // Run on page load
        updateSchemaFields();
        
        // Run on schema type change
        $('#wseo_schema_type').on('change', function() {
            updateSchemaFields();
        });
        
        // Real-time address validation
        $('#wseo_schema_address_street, #wseo_schema_address_city').on('input', function() {
            updateSchemaFields();
        });
        
        // Clear old cache files button (Smart Performance Optimizer)
        $('#wseo-clear-cache').on('click', function() {
            var $btn = $(this);
            $btn.prop('disabled', true).text('⏳ Mazanie...');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'wseo_clear_cache',
                    nonce: '<?php echo wp_create_nonce('wseo_cache_nonce'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        alert('✅ Cache a transients vymazané! (' + response.data.cleared + ' položiek)');
                        location.reload();
                    } else {
                        alert('❌ Chyba: ' + response.data);
                    }
                },
                error: function() {
                    alert('❌ Chyba pri komunikácii so serverom');
                },
                complete: function() {
                    $btn.prop('disabled', false).text('🗑️ Vymazať staré cache súbory');
                }
            });
        });
        
        // v2.9.11: Auto-geocode from address using Nominatim (OpenStreetMap)
        $('#wseo_geocode_btn').on('click', function() {
            var $btn = $(this);
            var $status = $('#wseo_geocode_status');
            
            // Get address fields
            var street = $('#wseo_schema_address_street').val() || '';
            var city = $('#wseo_schema_address_city').val() || '';
            var zip = $('#wseo_schema_address_zip').val() || '';
            var country = $('#wseo_schema_address_country').val() || 'SK';
            
            // Build search query
            var query = [];
            if (street) query.push(street);
            if (city) query.push(city);
            if (zip) query.push(zip);
            if (country) query.push(country);
            
            if (query.length < 2) {
                alert('❌ Vyplňte aspoň ulicu a mesto pre vyhľadanie GPS súradníc.');
                return;
            }
            
            var searchQuery = query.join(', ');
            
            $btn.prop('disabled', true).text('⏳ Hľadám...');
            $status.hide();
            
            // Use Nominatim API (OpenStreetMap) - free, no API key needed
            $.ajax({
                url: 'https://nominatim.openstreetmap.org/search',
                data: {
                    q: searchQuery,
                    format: 'json',
                    limit: 1,
                    addressdetails: 1
                },
                dataType: 'json',
                headers: {
                    'User-Agent': 'WSEO-Pro-Plugin/2.9.11'
                },
                success: function(data) {
                    if (data && data.length > 0) {
                        var result = data[0];
                        $('#wseo_schema_geo_lat').val(parseFloat(result.lat).toFixed(6));
                        $('#wseo_schema_geo_lng').val(parseFloat(result.lon).toFixed(6));
                        
                        $status.html('<span style="color: #00a32a;">✅ Nájdené: ' + result.display_name.substring(0, 50) + '...</span>').show();
                    } else {
                        $status.html('<span style="color: #d63638;">❌ Adresa nenájdená. Skúste upraviť údaje.</span>').show();
                    }
                },
                error: function() {
                    $status.html('<span style="color: #d63638;">❌ Chyba pripojenia k službe. Skúste neskôr.</span>').show();
                },
                complete: function() {
                    $btn.prop('disabled', false).text('📍 Vyhľadať z adresy');
                }
            });
        });
    });
    </script>
</div>

