<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wrap wseo-admin-wrap">
    <h1>🔍 Indexácia</h1>
    
    <form method="post" action="">
        <?php wp_nonce_field('wseo_files_settings'); ?>
        
        <div class="wseo-admin-card">
            <h2>🤖 Robots.txt</h2>
            <p>
                <a href="<?php echo home_url('/robots.txt'); ?>" target="_blank" class="wseo-file-link">
                    <span class="dashicons dashicons-external"></span>
                    Zobraziť robots.txt
                </a>
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_robots_custom_rules">Vlastné pravidlá</label></th>
                    <td>
                        <textarea id="wseo_robots_custom_rules" name="wseo_robots_custom_rules" 
                                  rows="8" class="large-text code"><?php echo esc_textarea(get_option('wseo_robots_custom_rules', '')); ?></textarea>
                        <p class="description">
                            Pridajte vlastné pravidlá pre robots.txt. Jeden riadok = jedno pravidlo.<br>
                            Príklad: <code>Disallow: /private/</code>
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🗺️ Sitemap</h2>
            <p>
                <a href="<?php echo home_url('/sitemap.xml'); ?>" target="_blank" class="wseo-file-link">
                    <span class="dashicons dashicons-external"></span>
                    Zobraziť sitemap.xml
                </a>
            </p>
            <p class="description">
                Sitemap sa generuje automaticky a obsahuje všetky publikované stránky, články a produkty.
                Stránky označené ako "noindex" sú automaticky vynechané.
            </p>
            
            <?php
            $last_submitted = get_option('wseo_sitemap_last_submitted', '');
            $submit_results = get_option('wseo_sitemap_submit_results', array());
            ?>
            
            <?php if ($last_submitted): ?>
            <div style="background: #e7f7e7; border-left: 4px solid #46b450; padding: 12px; margin: 15px 0;">
                <p style="margin: 0;">
                    <strong>Posledné odoslanie:</strong> <?php echo esc_html($last_submitted); ?>
                </p>
                <?php if (!empty($submit_results)): ?>
                    <p style="margin: 5px 0 0 0; font-size: 12px;">
                        <?php foreach ($submit_results as $engine => $result): ?>
                            <span style="margin-right: 15px;">
                                <?php if ($result['success']): ?>
                                    ✅ <?php echo esc_html(ucfirst($engine)); ?>
                                <?php else: ?>
                                    ❌ <?php echo esc_html(ucfirst($engine)); ?>: <?php echo esc_html($result['message']); ?>
                                <?php endif; ?>
                            </span>
                        <?php endforeach; ?>
                    </p>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px; margin: 15px 0;">
                <p style="margin: 0;">
                    ℹ️ <strong>Sitemap ešte nebola odoslaná do vyhľadávačov.</strong><br>
                    <small>Kliknite na tlačidlo nižšie pre okamžité indexovanie cez IndexNow (Bing & Yandex).</small>
                </p>
            </div>
            <?php endif; ?>
            
            <p>
                <button type="button" id="wseo-submit-sitemap" class="button button-secondary">
                    🚀 Odoslať sitemap (IndexNow)
                </button>
                <span id="wseo-submit-sitemap-status" style="margin-left: 10px;"></span>
            </p>
            
            <script>
            jQuery(document).ready(function($) {
                $('#wseo-submit-sitemap').on('click', function() {
                    var $btn = $(this);
                    var $status = $('#wseo-submit-sitemap-status');
                    
                    $btn.prop('disabled', true).text('⏳ Odosielam...');
                    $status.html('<span style="color: #666;">Čakajte...</span>');
                    
                    $.ajax({
                        url: ajaxurl,
                        method: 'POST',
                        data: {
                            action: 'wseo_submit_sitemap_to_gsc',
                            nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                $status.html('<span style="color: #46b450;">✅ ' + response.data.message + '</span>');
                                setTimeout(function() {
                                    location.reload();
                                }, 2000);
                            } else {
                                $status.html('<span style="color: #dc3232;">❌ ' + (response.data.message || 'Chyba') + '</span>');
                                $btn.prop('disabled', false).text('🚀 Odoslať sitemap (IndexNow)');
                            }
                        },
                        error: function(xhr, status, error) {
                            $status.html('<span style="color: #dc3232;">❌ Chyba pri odosielaní</span>');
                            $btn.prop('disabled', false).text('🚀 Odoslať sitemap (IndexNow)');
                        }
                    });
                });
            });
            </script>
            
            <p class="description" style="margin-top: 10px;">
                💡 <strong>IndexNow:</strong> Moderný protokol pre okamžité indexovanie v Bing a Yandex. 
                Pre Google použite <a href="https://search.google.com/search-console" target="_blank">Google Search Console</a> 
                na manuálne odoslanie sitemap.
            </p>
            
            <!-- v3.3: GeoSitemap for Local SEO -->
            <?php
            $has_lat = get_option('wseo_schema_geo_lat', '');
            $has_lng = get_option('wseo_schema_geo_lng', '');
            $has_gps = !empty($has_lat) && !empty($has_lng);
            $schema_type = get_option('wseo_schema_type', 'Organization');
            $is_local = !in_array($schema_type, array('Organization', 'Corporation', 'NewsMediaOrganization'));
            $locations = get_option('wseo_schema_locations', array());
            $locations_count = count($locations);
            ?>
            
            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">
                <h3 style="margin: 0 0 10px;">🗺️ GeoSitemap (KML) <span style="background: #0073aa; color: #fff; padding: 2px 8px; border-radius: 3px; font-size: 11px; margin-left: 8px;">NOVÉ v3.3</span></h3>
                
                <?php if ($has_gps): ?>
                <p>
                    <a href="<?php echo home_url('/geo-sitemap.kml'); ?>" target="_blank" class="wseo-file-link">
                        <span class="dashicons dashicons-location"></span>
                        Zobraziť geo-sitemap.kml
                    </a>
                    <?php if ($locations_count > 0): ?>
                    <span style="margin-left: 15px; color: #666;">
                        📍 Obsahuje <?php echo $locations_count + 1; ?> lokalít (hlavné sídlo + <?php echo $locations_count; ?> pobočiek)
                    </span>
                    <?php endif; ?>
                </p>
                <p class="description">
                    KML súbor pre Google Earth, Google Maps a lokálne vyhľadávače. 
                    Obsahuje GPS súradnice, adresy a kontaktné údaje vašich prevádzok.
                </p>
                
                <div style="background: #e8f5e9; border-left: 4px solid #4caf50; padding: 12px; margin: 15px 0;">
                    <strong>✅ GeoSitemap je aktívny</strong><br>
                    <small>
                        Hlavné sídlo: <?php echo esc_html(get_option('wseo_schema_address_city', 'Nenastavené')); ?> 
                        (<?php echo esc_html($has_lat); ?>, <?php echo esc_html($has_lng); ?>)
                        <?php if ($locations_count > 0): ?>
                        <br>+ <?php echo $locations_count; ?> ďalších pobočiek
                        <?php endif; ?>
                    </small>
                </div>
                
                <?php else: ?>
                <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px; margin: 10px 0;">
                    <strong>⚠️ GeoSitemap nie je dostupný</strong><br>
                    <small>
                        Pre aktiváciu GeoSitemap nastavte GPS súradnice v 
                        <a href="<?php echo admin_url('admin.php?page=webstudio-seo-global'); ?>">Globálne nastavenia → Schema.org</a>.
                        <?php if (!$is_local): ?>
                        <br>💡 Tip: Zmeňte typ organizácie na LocalBusiness pre plnú podporu Local SEO.
                        <?php endif; ?>
                    </small>
                </div>
                <?php endif; ?>
                
                <p class="description" style="margin-top: 10px;">
                    💡 <strong>Použitie:</strong> GeoSitemap môžete nahrať do Google Business Profile, 
                    importovať do Google My Maps, alebo použiť pre lokálne SEO kampane.
                </p>
            </div>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🤖 llms.txt (pre AI boty)</h2>
            <p>
                <a href="<?php echo home_url('/llms.txt'); ?>" target="_blank" class="wseo-file-link">
                    <span class="dashicons dashicons-external"></span>
                    Zobraziť llms.txt
                </a>
            </p>
            <p class="description">
                Špeciálny súbor pre AI vyhľadávače (ChatGPT, Claude, Perplexity...).
                Obsahuje informácie o vašom webe a povolených AI botoch.
            </p>
        </div>
        
        <div class="wseo-admin-card">
            <h2>✅ Overenie vlastníctva webu</h2>
            <p class="description" style="margin-bottom: 15px;">
                Vložte overovací kód (len hodnotu z content="...") pre pripojenie k nástrojom pre webmasterov.
            </p>
            
            <table class="form-table">
                <tr>
                    <th>
                        <label for="wseo_verify_google">
                            <img src="https://www.google.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Google Search Console
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_google" name="wseo_verify_google" 
                               value="<?php echo esc_attr(get_option('wseo_verify_google', '')); ?>" 
                               class="large-text" placeholder="abc123xyz...">
                        <p class="description">
                            <a href="https://search.google.com/search-console" target="_blank">Google Search Console</a> → 
                            Nastavenia → Overenie vlastníctva → HTML tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="wseo_verify_bing">
                            <img src="https://www.bing.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Bing Webmaster Tools
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_bing" name="wseo_verify_bing" 
                               value="<?php echo esc_attr(get_option('wseo_verify_bing', '')); ?>" 
                               class="large-text" placeholder="ABCDEF123456...">
                        <p class="description">
                            <a href="https://www.bing.com/webmasters" target="_blank">Bing Webmaster Tools</a> → 
                            Add site → XML tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="wseo_verify_yandex">
                            <img src="https://yandex.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Yandex Webmaster
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_yandex" name="wseo_verify_yandex" 
                               value="<?php echo esc_attr(get_option('wseo_verify_yandex', '')); ?>" 
                               class="large-text" placeholder="abcdef123456...">
                        <p class="description">
                            <a href="https://webmaster.yandex.com" target="_blank">Yandex Webmaster</a> → 
                            Add site → Meta tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="wseo_verify_pinterest">
                            <img src="https://www.pinterest.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Pinterest
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_pinterest" name="wseo_verify_pinterest" 
                               value="<?php echo esc_attr(get_option('wseo_verify_pinterest', '')); ?>" 
                               class="large-text" placeholder="abc123...">
                        <p class="description">
                            <a href="https://www.pinterest.com/settings/claim" target="_blank">Pinterest</a> → 
                            Claim → Add HTML tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🚀 Instant Indexing</h2>
            <p class="description" style="margin-bottom: 15px;">
                Automaticky odošle URL do vyhľadávačov ihneď po publikovaní alebo aktualizácii obsahu.
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Povoliť Instant Indexing</th>
                    <td>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox" name="wseo_instant_index_enabled" value="1" 
                                   <?php checked(get_option('wseo_instant_index_enabled', '1'), '1'); ?>>
                            <strong>Automaticky indexovať pri publikovaní</strong>
                        </label>
                        <label style="display: block;">
                            <input type="checkbox" name="wseo_instant_index_on_update" value="1" 
                                   <?php checked(get_option('wseo_instant_index_on_update', '0'), '1'); ?>>
                            Indexovať aj pri aktualizácii existujúceho obsahu
                        </label>
                    </td>
                </tr>
            </table>
            
            <hr style="margin: 20px 0;">
            
            <h3>🔍 Bing & Yandex (IndexNow)</h3>
            <p class="description" style="margin-bottom: 15px;">
                IndexNow je jednoduchý protokol - nevyžaduje žiadne nastavenie. Funguje okamžite!
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Bing IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_bing_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_bing_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Bing IndexNow
                        </label>
                        <p class="description">Okamžité indexovanie v Bing. Žiadna konfigurácia potrebná.</p>
                    </td>
                </tr>
                <tr>
                    <th>Yandex IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_yandex_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_yandex_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Yandex IndexNow
                        </label>
                        <p class="description">Okamžité indexovanie v Yandex. Žiadna konfigurácia potrebná.</p>
                    </td>
                </tr>
                <tr>
                    <th>Seznam.cz IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_seznam_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_seznam_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Seznam.cz IndexNow
                        </label>
                        <p class="description">Okamžité indexovanie v Seznam.cz. Dôležité pre SK/CZ trh.</p>
                    </td>
                </tr>
                <tr>
                    <th>Naver IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_naver_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_naver_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Naver IndexNow
                        </label>
                        <p class="description">Dodatočné pokrytie cez Naver SearchAdvisor.</p>
                    </td>
                </tr>
                <tr>
                    <th>IndexNow API Hub</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_indexnow_api_enabled" value="1" 
                                   <?php checked(get_option('wseo_indexnow_api_enabled', '1'), '1'); ?>>
                            Povoliť IndexNow API Hub
                        </label>
                        <p class="description">Oficiálny IndexNow hub - zdieľaný všetkými účastníkmi protokolu.</p>
                    </td>
                </tr>
                <tr>
                    <th>Yep.com IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_yep_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_yep_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Yep.com IndexNow
                        </label>
                        <p class="description">Yep.com - privacy-focused vyhľadávač s vlastným indexom.</p>
                    </td>
                </tr>
                <tr>
                    <th>IndexNow API kľúč</th>
                    <td>
                        <?php 
                        $indexnow_key = get_option('wseo_indexnow_key', '');
                        if (empty($indexnow_key)) {
                            $indexnow_key = wp_generate_password(32, false);
                            update_option('wseo_indexnow_key', $indexnow_key);
                        }
                        ?>
                        <input type="text" value="<?php echo esc_attr($indexnow_key); ?>" class="regular-text" readonly>
                        <p class="description">Automaticky vygenerovaný kľúč. Súbor <code><?php echo esc_html($indexnow_key); ?>.txt</code> sa vytvorí automaticky.</p>
                    </td>
                </tr>
            </table>
            
            <!-- v3.2: Info about automatic features -->
            <div style="background: #e7f6e7; border-left: 4px solid #00a32a; padding: 12px 15px; margin: 20px 0;">
                <strong>🚀 Automatické funkcie (beží na pozadí):</strong>
                <ul style="margin: 10px 0 0 20px;">
                    <li>✅ <strong>Multi-engine IndexNow</strong> - Ping 6 vyhľadávačov naraz (Bing, Yandex, Seznam, Naver, IndexNow Hub, Yep)</li>
                    <li>✅ <strong>WebSub/PubSubHubbub</strong> - Real-time notifikácia Google o novom obsahu</li>
                    <li>✅ <strong>Pingomatic</strong> - XML-RPC ping pre čerstvé články (&lt;1 hodina)</li>
                    <li>✅ <strong>Sitemap ping</strong> - Automatický ping Google pri publikácii</li>
                    <li>✅ <strong>Agresívny režim</strong> - Pre články &lt;1h starý: žiadny rate limit</li>
                </ul>
                <p style="margin: 10px 0 0; font-size: 12px; color: #555;">
                    <strong>💡 Stratégia:</strong> Viac IndexNow pingov = viac crawler aktivity = Google si všimne a začne crawlovať častejšie.
                    DuckDuckGo, Ecosia a Qwant používajú Bing index, takže sú automaticky pokryté.
                </p>
            </div>
            
            <hr style="margin: 20px 0;">
            
            <h3>🔴 Google Indexing API <span style="font-size: 12px; color: #666; font-weight: normal;">(Voliteľné - pre najrýchlejšiu indexáciu)</span></h3>
            
            <div style="background: #fff8e5; border-left: 4px solid #ffb900; padding: 15px; margin-bottom: 20px;">
                <strong>⚡ Prečo Google Indexing API?</strong>
                <p style="margin: 10px 0 0;">
                    IndexNow (Bing, Yandex, Seznam) funguje okamžite bez konfigurácie. Google Indexing API je <strong>voliteľné</strong> 
                    a poskytuje priamy kanál ku Google - indexácia do 5-10 minút. Vyžaduje jednorazovú 5-minútovú konfiguráciu.
                </p>
            </div>
            
            <?php 
            $json_credentials = get_option('wseo_google_indexing_json', '');
            $is_configured = !empty($json_credentials) && strpos($json_credentials, 'service_account') !== false;
            $service_email = '';
            if ($is_configured) {
                $creds = json_decode($json_credentials, true);
                $service_email = isset($creds['client_email']) ? $creds['client_email'] : '';
            }
            ?>
            
            <div class="wseo-indexing-wizard" style="border: 1px solid #ddd; border-radius: 8px; overflow: hidden;">
                <!-- Step 1 -->
                <div style="padding: 15px; background: <?php echo $is_configured ? '#f0f9f0' : '#f9f9f9'; ?>; border-bottom: 1px solid #eee;">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="width: 30px; height: 30px; border-radius: 50%; background: <?php echo $is_configured ? '#00a32a' : '#2271b1'; ?>; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: bold;">1</span>
                        <div style="flex: 1;">
                            <strong>Vytvoriť Google Cloud Project</strong>
                            <p style="margin: 5px 0 0; color: #666; font-size: 13px;">Potrebujete Google účet. Vytvorenie je zadarmo.</p>
                        </div>
                        <a href="https://console.cloud.google.com/projectcreate" target="_blank" class="button">
                            Otvoriť Google Cloud Console →
                        </a>
                    </div>
                </div>
                
                <!-- Step 2 -->
                <div style="padding: 15px; background: <?php echo $is_configured ? '#f0f9f0' : '#fff'; ?>; border-bottom: 1px solid #eee;">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="width: 30px; height: 30px; border-radius: 50%; background: <?php echo $is_configured ? '#00a32a' : '#2271b1'; ?>; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: bold;">2</span>
                        <div style="flex: 1;">
                            <strong>Aktivovať Indexing API</strong>
                            <p style="margin: 5px 0 0; color: #666; font-size: 13px;">V projekte aktivujte "Web Search Indexing API".</p>
                        </div>
                        <a href="https://console.cloud.google.com/apis/library/indexing.googleapis.com" target="_blank" class="button">
                            Aktivovať API →
                        </a>
                    </div>
                </div>
                
                <!-- Step 3 -->
                <div style="padding: 15px; background: <?php echo $is_configured ? '#f0f9f0' : '#fff'; ?>; border-bottom: 1px solid #eee;">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="width: 30px; height: 30px; border-radius: 50%; background: <?php echo $is_configured ? '#00a32a' : '#2271b1'; ?>; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: bold;">3</span>
                        <div style="flex: 1;">
                            <strong>Vytvoriť Service Account a stiahnuť JSON</strong>
                            <p style="margin: 5px 0 0; color: #666; font-size: 13px;">IAM → Service Accounts → Create → Keys → Add Key → JSON</p>
                        </div>
                        <a href="https://console.cloud.google.com/iam-admin/serviceaccounts" target="_blank" class="button">
                            Vytvoriť Service Account →
                        </a>
                    </div>
                </div>
                
                <!-- Step 4: JSON Upload -->
                <div style="padding: 15px; background: <?php echo $is_configured ? '#f0f9f0' : '#fff'; ?>; border-bottom: 1px solid #eee;">
                    <div style="display: flex; align-items: flex-start; gap: 15px;">
                        <span style="width: 30px; height: 30px; border-radius: 50%; background: <?php echo $is_configured ? '#00a32a' : '#2271b1'; ?>; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: bold; flex-shrink: 0;">4</span>
                        <div style="flex: 1;">
                            <strong>Vložte JSON credentials</strong>
                            <p style="margin: 5px 0 10px; color: #666; font-size: 13px;">Celý obsah stiahnutého JSON súboru:</p>
                            <textarea id="wseo_google_indexing_json" name="wseo_google_indexing_json" 
                                      rows="6" class="large-text code" 
                                      style="font-size: 12px; <?php echo $is_configured ? 'border-color: #00a32a;' : ''; ?>"
                                      placeholder='{"type": "service_account", "project_id": "your-project", "private_key_id": "...", "private_key": "-----BEGIN PRIVATE KEY-----\n...", "client_email": "your-sa@your-project.iam.gserviceaccount.com", ...}'><?php echo esc_textarea($json_credentials); ?></textarea>
                            <?php if ($is_configured): ?>
                            <p style="margin: 8px 0 0; color: #00a32a;">
                                ✅ JSON credentials uložené
                                <?php if ($service_email): ?>
                                <br><code style="font-size: 11px;"><?php echo esc_html($service_email); ?></code>
                                <?php endif; ?>
                            </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Step 5: Add to Search Console -->
                <div style="padding: 15px; background: <?php echo $is_configured ? '#f0f9f0' : '#fff'; ?>; border-bottom: 1px solid #eee;">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="width: 30px; height: 30px; border-radius: 50%; background: <?php echo $is_configured ? '#00a32a' : '#2271b1'; ?>; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: bold;">5</span>
                        <div style="flex: 1;">
                            <strong>Pridať Service Account do Search Console</strong>
                            <?php if ($service_email): ?>
                            <p style="margin: 5px 0 0; color: #666; font-size: 13px;">
                                Pridajte tento email ako <strong>Vlastníka</strong>: 
                                <code style="background: #fff3cd; padding: 2px 6px; border-radius: 3px; user-select: all;"><?php echo esc_html($service_email); ?></code>
                            </p>
                            <?php else: ?>
                            <p style="margin: 5px 0 0; color: #666; font-size: 13px;">Vložte JSON vyššie pre zobrazenie emailu Service Account.</p>
                            <?php endif; ?>
                        </div>
                        <a href="https://search.google.com/search-console/users" target="_blank" class="button">
                            Otvoriť Search Console →
                        </a>
                    </div>
                </div>
                
                <!-- Step 6: Enable -->
                <div style="padding: 15px; background: <?php echo $is_configured && get_option('wseo_google_indexing_enabled', '0') === '1' ? '#e7f6e7' : '#f9f9f9'; ?>;">
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <span style="width: 30px; height: 30px; border-radius: 50%; background: <?php echo $is_configured && get_option('wseo_google_indexing_enabled', '0') === '1' ? '#00a32a' : '#999'; ?>; color: #fff; display: inline-flex; align-items: center; justify-content: center; font-weight: bold;">6</span>
                        <div style="flex: 1;">
                            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                                <input type="checkbox" name="wseo_google_indexing_enabled" value="1" 
                                       <?php checked(get_option('wseo_google_indexing_enabled', '0'), '1'); ?>
                                       <?php echo !$is_configured ? 'disabled' : ''; ?>
                                       style="width: 18px; height: 18px;">
                                <strong style="font-size: 14px;">Aktivovať Google Indexing API</strong>
                            </label>
                            <?php if (!$is_configured): ?>
                            <p style="margin: 5px 0 0; color: #d63638; font-size: 13px;">⚠️ Najprv vložte JSON credentials vyššie.</p>
                            <?php endif; ?>
                        </div>
                        <?php if ($is_configured): ?>
                        <button type="button" class="button" id="wseo-test-google-api">
                            🧪 Testovať pripojenie
                        </button>
                        <?php endif; ?>
                    </div>
                    <div id="wseo-google-api-test-result" style="margin-top: 10px; display: none;"></div>
                </div>
            </div>
            
            <script>
            jQuery(function($) {
                $('#wseo-test-google-api').on('click', function() {
                    var $btn = $(this);
                    var $result = $('#wseo-google-api-test-result');
                    
                    $btn.prop('disabled', true).text('⏳ Testujem...');
                    $result.html('<p style="color: #666;">Testujem pripojenie ku Google Indexing API...</p>').show();
                    
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'wseo_test_google_indexing',
                            nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                $result.html('<p style="color: #00a32a; background: #f0f9f0; padding: 10px; border-radius: 4px;">✅ ' + response.data.message + '</p>');
                            } else {
                                $result.html('<p style="color: #d63638; background: #fcf0f0; padding: 10px; border-radius: 4px;">❌ ' + (response.data.message || 'Chyba pripojenia') + '</p>');
                            }
                        },
                        error: function() {
                            $result.html('<p style="color: #d63638; background: #fcf0f0; padding: 10px; border-radius: 4px;">❌ Chyba komunikácie so serverom</p>');
                        },
                        complete: function() {
                            $btn.prop('disabled', false).text('🧪 Testovať pripojenie');
                        }
                    });
                });
            });
            </script>
            
            <hr style="margin: 20px 0;">
            
            <h3>📋 Posledné indexovania 
                <a href="<?php echo wp_nonce_url(admin_url('admin.php?page=webstudio-seo-files&clear_index_log=1'), 'wseo_clear_log'); ?>" 
                   class="button button-small" style="margin-left: 10px;"
                   onclick="return confirm('Vymazať históriu indexovania?');">🗑️ Vyčistiť log</a>
            </h3>
            <?php
            // Handle clear log
            if (isset($_GET['clear_index_log']) && wp_verify_nonce($_GET['_wpnonce'], 'wseo_clear_log')) {
                update_option('wseo_indexing_log', array());
                echo '<div class="notice notice-success"><p>Log bol vyčistený.</p></div>';
                $log = array();
            } else {
                $log = get_option('wseo_indexing_log', array());
            }
            
            // v3.2: Deduplicate log entries by URL (keep only the latest per URL)
            $unique_log = array();
            foreach ($log as $entry) {
                $url = $entry['url'];
                // Keep only the most recent entry for each URL
                if (!isset($unique_log[$url]) || strtotime($entry['time']) > strtotime($unique_log[$url]['time'])) {
                    $unique_log[$url] = $entry;
                }
            }
            // Sort by time descending and take last 10
            usort($unique_log, function($a, $b) {
                return strtotime($b['time']) - strtotime($a['time']);
            });
            $log = array_slice($unique_log, 0, 10);
            
            if (empty($log)): ?>
                <p class="description">Zatiaľ neboli odoslané žiadne URL. Aktivujte Instant Indexing vyššie.</p>
            <?php else: ?>
                <table class="widefat striped" style="margin-top: 10px;">
                    <thead>
                        <tr>
                            <th>Čas</th>
                            <th>URL</th>
                            <th style="text-align:center;">Google API</th>
                            <th style="text-align:center;">Bing</th>
                            <th style="text-align:center;">Yandex</th>
                            <th style="text-align:center;">Seznam</th>
                            <th style="text-align:center;">WebSub</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($log as $entry): ?>
                        <tr>
                            <td style="white-space:nowrap;"><?php echo esc_html(date('d.m. H:i', strtotime($entry['time']))); ?></td>
                            <td><a href="<?php echo esc_url($entry['url']); ?>" target="_blank" title="<?php echo esc_attr($entry['url']); ?>"><?php 
                                $path = parse_url($entry['url'], PHP_URL_PATH);
                                echo esc_html($path ? $path : '/'); 
                            ?></a></td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['google'])): ?>
                                    <?php echo $entry['results']['google']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['bing'])): ?>
                                    <?php echo $entry['results']['bing']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['yandex'])): ?>
                                    <?php echo $entry['results']['yandex']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['seznam'])): ?>
                                    <?php echo $entry['results']['seznam']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['websub'])): ?>
                                    <?php echo $entry['results']['websub']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        
        <p class="submit">
            <input type="submit" name="wseo_save_files" class="button button-primary" value="Uložiť nastavenia">
        </p>
    </form>
    
    <div class="wseo-admin-card">
        <h2>📋 Náhľad robots.txt</h2>
        <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><?php
$robots = "User-agent: *\n";
$robots .= "Allow: /\n";
$robots .= "Disallow: /wp-admin/\n";
$robots .= "Disallow: /wp-includes/\n";

if (class_exists('WooCommerce')) {
    $robots .= "Disallow: /cart/\n";
    $robots .= "Disallow: /checkout/\n";
    $robots .= "Disallow: /my-account/\n";
}

$custom = get_option('wseo_robots_custom_rules', '');
if ($custom) {
    $robots .= "\n" . $custom . "\n";
}

$robots .= "\nSitemap: " . home_url('/sitemap.xml');

echo esc_html($robots);
        ?></pre>
    </div>
</div>
