<?php
/*
 * © 2026 Karol Kameniczki - Webstudio.ltd. Všetky práva vyhradené.
 * Tento softvérový produkt (plugin) je duševným vlastníctvom Karol Kameniczki - Webstudio.ltd a je chránený v zmysle Autorského zákona č. 185/2015 Z. z.
 * BEZ PÍSOMNÉHO SÚHLASU AUTORA JE PRÍSNE ZAKÁZANÉ:
 * - Kopírovanie, modifikovanie alebo spätné inžinierstvo kódu.
 * - Používanie pluginu na komerčné účely alebo v rámci platených služieb tretej strany.
 * - Distribúcia, predaj alebo zverejňovanie na fórach a sociálnych sieťach.
 * - Akékoľvek neoprávnené šírenie bez platnej licenčnej zmluvy.
 *
 * Porušenie týchto podmienok môže mať za následok občianskoprávne a trestnoprávne konanie.
 */

/**
 * Plugin Name: Webstudio SEO Pro
 * Plugin URI: https://webstudio.ltd/
 * Description: Profesionálny SEO plugin s automatickými meta tagmi, Open Graph, Twitter Cards, robots.txt, sitemap.xml, llms.txt pre AI botov a WordPress Doctor pre automatické opravy. © 2026 Karol Kameniczki - Webstudio.ltd. Všetky práva vyhradené.
 * Version: 3.2.0
 * Author: WEBSTUDIO.ltd
 * Author URI: https://webstudio.ltd/
 * Text Domain: webstudio-seo-pro
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * License: Proprietary
 * 
 * CHANGELOG v2.9.9 (2026-01-27):
 * - FIX: 🖼️ Auto-fill nastavenia sa neukladali správne
 * - FIX: delete_option + add_option pre čistý stav
 * - FIX: Robustnejšia inicializácia defaultov (opravuje corrupted options)
 * - FIX: Lepšie error handling a feedback pri ukladaní
 * - IMPROVED: Console logging pre debug
 * 
 * CHANGELOG v2.9.8 (2026-01-27):
 * - FIX: 🗺️ Sub-sitemap routing - opravené parsovanie REQUEST_URI
 * - FIX: Podpora pre subdirectory WordPress inštalácie
 * - FIX: Query string handling pre sitemap URL
 * - FIX: Init hook priority 0 pre skoršie spracovanie
 * - FIX: Case-insensitive regex pre sitemap patterny
 * 
 * CHANGELOG v2.9.7 (2026-01-27):
 * - NEW: 🗺️ SITEMAP INDEX SYSTEM - Podpora pre weby s 50 000+ až 100 000+ URL
 * - NEW: Automatické rozdelenie sitemap na menšie časti (max 10 000 URL)
 * - NEW: /sitemap.xml teraz vracia Sitemap Index s odkazmi na sub-sitemaps
 * - NEW: /sitemap-posts-1.xml, /sitemap-posts-2.xml... pre články
 * - NEW: /sitemap-pages-1.xml pre stránky
 * - NEW: /sitemap-products-1.xml pre WooCommerce produkty
 * - NEW: /sitemap-categories-1.xml, /sitemap-tags-1.xml pre taxonómie
 * - IMPROVED: Memory-efficient queries - načítava iba 10 000 URL naraz
 * - IMPROVED: Direct SQL queries namiesto WP_Query pre lepší výkon
 * - FIX: GSC/Bing "Nie je možné načítať" chyba pri veľkých sitemap
 * - FIX: Timeout a memory limit chyby na news weboch s 100 000+ článkami
 * 
 * CHANGELOG v2.9.6 (2026-01-26):
 * - NEW: 📍 Adresa je teraz dostupná aj pre typ Organization (nepovinné)
 * - NEW: 🖼️ Auto-fill obrázkov je teraz VŽDY aktívne pre nové inštalácie
 * - IMPROVED: Automatická inicializácia auto-fill options pri aktivácii aj upgrade
 * - IMPROVED: Google Rich Results - pole "address" sa zobrazí ak je vyplnené
 * - IMPROVED: UI - polia adresu sú viditeľné pre všetky typy organizácií
 * - FIX: Odstránenie warningov "Chýbajúce pole address (nepovinné)"
 * 
 * CHANGELOG v2.9.5 (2026-01-26):
 * - FIX: 🖼️ Úplne vypnutý preload hero images - spôsoboval console warnings
 * - FIX: "resource was preloaded but not used within a few seconds" error
 * - FIX: Kompatibilita s Flatsome, Themify a inými témami
 * - IMPROVED: Browser natívne optimalizuje LCP bez explicitného preloadu
 * - KEPT: Preload fontov zostáva aktívny (funguje správne)
 * 
 * CHANGELOG v2.9.4 (2026-01-26):
 * - FIX: 🚨 KRITICKÁ OPRAVA - Auto-Redirect presmeroval aj homepage a existujúce stránky!
 * - FIX: is_404() kontrola je teraz PRVÁ (homepage, kategórie, produkty už nebudú presmerované)
 * - FIX: 🛒 Pridaná kontrola pre WooCommerce kategórie (product_cat, product_tag)
 * - FIX: Skip prázdnych slugov a homepage explicitne
 * 
 * CHANGELOG v2.9.3 (2026-01-26):
 * - SECURITY: 🔒 Pridaná ochrana proti priamemu prístupu (ABSPATH check) do všetkých šablón
 * - SECURITY: 🛡️ Bezpečnostný audit - všetky AJAX funkcie majú nonce verifikáciu
 * - SECURITY: ✅ Všetky POST vstupy sanitizované (sanitize_text_field, esc_url_raw, sanitize_textarea_field)
 * - SECURITY: ✅ Capability checks (current_user_can) na všetkých admin akciách
 * - SECURITY: ✅ SQL queries bez užívateľského vstupu (statické queries)
 * - SECURITY: ✅ Output escaping (esc_html, esc_attr, esc_url) - 111+ použití
 * 
 * CHANGELOG v2.9.2 (2026-01-26):
 * - NEW: 💰 Offers schema pre SoftwareApplication a Product
 * - NEW: 📊 AggregateRating - automatický výpočet z priemeru všetkých recenzií
 * - NEW: 🆓 Typ ceny: Free / Paid / Freemium
 * - NEW: 💱 Podpora 6 mien: EUR, USD, CZK, GBP, PLN, HUF
 * - NEW: 🎓 Course provider schema
 * - FIX: 100% Google Rich Results compliance pre Review schema
 * - IMPROVED: 🖼️ Auto-fill obrázkov - všetky 4 polia (Alt, Title, Caption, Description) sú teraz defaultne ON
 * 
 * CHANGELOG v2.9.15 (2026-01-29):
 * - CHANGE: 🎯 Meta Keywords → Focus Keyword - interný nástroj pre SEO analýzu
 * - REMOVE: ❌ Meta keywords tag odstránený z HTML (Google ignoruje od 2009)
 * - REMOVE: ❌ Self-serving Review Schema ÚPLNE ODSTRÁNENÉ (Google ban od 2019)
 * - NEW: 📊 Focus Keyword Analysis - kontrola v titulku, URL, obsahu, hustota
 * - NEW: 🚀 Push Update API - vzdialená aktualizácia klientov z license servera
 * - FIX: 🔗 Title suffix - správne pridávanie " - SiteName" do <title> tagu
 * - FIX: 🔄 Auto-update endpoint - REST API namiesto PHP súboru
 * - FIX: 🚫 Auto-Redirect 404 threshold zvýšený na min 50% (predtým 5%) - zabraňuje zlým presmerovaniam
 * 
 * CHANGELOG v2.9.1 (2026-01-26):
 * - FIX: 🔧 Review Schema itemReviewed - Opravený neplatný typ "Thing"
 * - NEW: 📋 Typ recenzovanej položky - výber z 12 Google-kompatibilných typov
 * - NEW: SoftwareApplication, Product, LocalBusiness, Organization, Book, Movie, Restaurant, Hotel, Course, Event, CreativeWork, Service
 * - FIX: Google Search Console chyba "Neplatný typ objektu pre pole itemReviewed"
 * - IMPROVED: Automatické pridanie type-specific polí (applicationCategory, brand, url)
 * 
 * CHANGELOG v2.9.0 (2026-01-26):
 * - NEW: 🚀 Smart Cache Headers - Inteligentné cache hlavičky pre CDN/prehliadače
 * - NEW: 📦 Full Page Cache Ready - Pripravené pre edge caching
 * - NEW: 🔄 Auto Cache Purge - Automatická invalidácia cache pri publish/update
 * - NEW: 🛡️ Builder Detection - Automatický bypass cache pre Elementor, Divi, Themify, Beaver Builder
 * - NEW: 🛒 WooCommerce Smart Cache - Inteligentné cachovanie s bypass pre košík/checkout
 * - NEW: 📡 Stale-While-Revalidate - Okamžité zobrazenie zo starej cache počas refresh
 * - NEW: 🌐 Edge-Ready Headers - Pripravené pre Cloudflare, Fastly, Vercel Edge
 * - NEW: 🔔 Auto Sitemap Ping - Automatický ping Google pri publikovaní (z v2.8.13)
 * 
 * CHANGELOG v2.8.10 (2026-01-25):
 * - FIX: 🔔 Update Notice - Hláška o aktualizácii sa teraz správne skryje po update
 * - FIX: 📄 FOUC - Kompletný Anti-FOUC systém (hide until loaded)
 * - FIX: 📄 FOUC - Vypnutý preload hero images (fetchpriority="high" blokovalo render)
 * - FIX: 📊 CLS - Odstránený JavaScript ktorý pridával CSS triedy
 * - FIX: 🔘 "Skip to content" - Univerzálny CSS fix pre všetky témy
 * - NEW: 🖼️ AVIF podpora - Automatické generovanie AVIF verzií (30-50% lepšia kompresia ako WebP)
 * - NEW: 📝 Auto Alt Text & Metadata - Pokročilé hromadné vyplnenie ALT, nadpis, popisok, popis
 * - NEW: ⚙️ Šablóny pre obrázky - {parent_title}, {parent_category}, {filename_clean}, atď.
 * - NEW: 🔄 Hromadné operácie - Vyplniť chýbajúce, Prepísať všetko, Vlastný text, Vymazať
 * - NEW: 📊 Štatistiky obrázkov - Progress bary pre Alt, Title, Caption, Description
 * - NEW: is_avif_supported() - Detekcia AVIF podpory (GD/ImageMagick/avifenc)
 * - NEW: output_anti_fouc_reveal() - Script v footer pre plynulé zobrazenie stránky
 * - NEW: Safe Mode (wseo_safe_mode) - Možnosť vypnúť všetky performance funkcie
 * 
 * CHANGELOG v2.8.6 (2026-01-24):
 * - NEW: 🔄 Auto-Clear Cache on Save - Automatické vymazanie cache pri uložení
 * - NEW: Immediate Content Refresh - Okamžitá viditeľnosť zmien obsahu
 * - NEW: Multi-Cache Support - Podpora 15+ populárnych cache pluginov
 * - NEW: WordPress Native Cache - Vymazanie WP object cache a transients
 * - NEW: Hosting Integration - Cloudflare, Kinsta, WP Engine, SiteGround
 * - FIX: Stale Content Issue - Riešenie problému so starou verziou článkov
 * - FIX: Last-Modified Headers - Oprava hooku na template_redirect (priority 1)
 * - IMPROVED: Content Workflow - Žiadne čakanie na refresh cache
 * - IMPROVED: Editor Experience - Zmeny viditeľné okamžite po uložení
 * - IMPROVED: Header Sending - Pridaná kontrola headers_sent() a debug logging
 * 
 * CHANGELOG v2.8.4 (2026-01-23):
 * - NEW: 🔄 Auto-Clear Cache on Save - Automatické vymazanie cache pri uložení
 * - NEW: Immediate Content Refresh - Okamžitá viditeľnosť zmien obsahu
 * - NEW: Multi-Cache Support - Podpora 15+ populárnych cache pluginov
 * - NEW: WordPress Native Cache - Vymazanie WP object cache a transients
 * - NEW: Hosting Integration - Cloudflare, Kinsta, WP Engine, SiteGround
 * - FIX: Stale Content Issue - Riešenie problému so starou verziou článkov
 * - IMPROVED: Content Workflow - Žiadne čakanie na refresh cache
 * - IMPROVED: Editor Experience - Zmeny viditeľné okamžite po uložení
 * 
 * CHANGELOG v2.8.4 (2026-01-23):
 * - NEW: 🛍️ WooCommerce Short Description Fallback - Meta description pre produkty
 * - NEW: Auto-fallback na Short Description ak je Description prázdny
 * - NEW: Smart Product Description - Title + Category + Price fallback
 * - IMPROVED: Meta Description Generation - 3-level fallback pre WC produkty
 * - IMPROVED: Product SEO - Lepšie SEO pre produkty len s krátkym popisom
 * 
 * CHANGELOG v2.8.3 (2026-01-23):
 * - NEW: 🔄 Auto-Update System - Automatické kontroly aktualizácií
 * - NEW: Update Manager - Web interface na webstudio.ltd pre publikovanie verzií
 * - NEW: One-Click Updates - Aktualizácia pluginu priamo z WP Admin
 * - NEW: Changelog Display - Prehľadné zobrazenie zmien pred updateom
 * - NEW: Version Detection - Auto-detekcia verzie z ZIP súboru
 * - NEW: History Archive - Automatický archív starých verzií
 * - NEW: Update Notifications - Smart notifikácie o nových verziách
 * - FIX: Performance Monitor AJAX - Opravené tlačidlo "Vypnúť"
 * - FIX: ajaxurl Definition - Pridaná definícia pre všetky AJAX volania
 * - IMPROVED: License UI - Full-width layout, telefónne číslo v kontakte
 * - IMPROVED: License Generator - Dropdown pre predĺženie licencie
 * 
 * CHANGELOG v2.8.2 (2026-01-23):
 * - NEW: 🔐 License System - 14-day Trial + Remote Validation
 * - NEW: Trial Period - Plugin funguje 14 dní bez licencie
 * - NEW: License Activation - Jednoduchá aktivácia cez licenčný kľúč
 * - NEW: Remote Validation - Server-side overenie licencie (webstudio.ltd)
 * - NEW: Anti-Piracy - Ukradnutý plugin funguje max 14 dní
 * - NEW: License UI - Nová sekcia v Performance → Licencia
 * - NEW: Trial Countdown - Live odpočet zostávajúcich dní
 * - NEW: Grace Notifications - Upozornenia 7 a 3 dni pred expiráciou
 * - NEW: Hard Stop - Plugin sa deaktivuje po expirácii trial/licencie
 * - SECURITY: Trial tracking v database (nedá sa resetovať)
 * - IMPROVED: User-friendly - Klient má čas vyskúšať plugin pred kúpou
 * 
 * CHANGELOG v2.8.1 (2026-01-23):
 * - NEW: ⚡ Performance Monitor - Kompletný real-time monitoring tool
 * - NEW: 💓 Heartbeat Control - Optimalizácia WordPress Heartbeat API (úspora 70% server load)
 * - NEW: Background Process Detection - Identifikuje všetky procesy na pozadí
 * - NEW: Color-coded Classification - 🔴 Kritické | 🟡 Voliteľné | 🟢 Bezpečné vypnúť
 * - NEW: One-click Disable - Dočasné (24h) alebo trvalé vypnutie procesov
 * - NEW: Live Monitoring (30s) - Real-time detekcia AJAX/Cron/Scripts
 * - NEW: Performance Recommendations - Inteligentné odporúčania na zrýchlenie
 * - NEW: AJAX Call Log - História všetkých background volaní (24h)
 * - NEW: Cron Job Analysis - Klasifikácia a správa scheduled taskov
 * - NEW: Plugin Scripts Detection - Identifikácia marketing/tracking skriptov
 * - NEW: Impact Measurement - Presné meranie spomalenia (ms, KB, %)
 * - NEW: Bulk Actions - Vypnúť všetky bezpečné procesy naraz
 * - NEW: Auto Re-enable - Automatické zapnutie po vypršaní dočasnej blokovky
 * - NEW: Dashboard Metrics - 4 live statistiky (kritické, voliteľné, safe, impact)
 * - NEW: Heartbeat Modes - Default/Optimized/Aggressive/Disabled
 * - NEW: Heartbeat Dashboard - Real-time req/hod tracking a úspora %
 * 
 * CHANGELOG v2.8.1 (2026-01-23):
 * - UI: Full-width layout pre Globálne nastavenia (100% namiesto 900px)
 * - UI: Reorganizované sekcie do logických skupín:
 *   → Základné identity (Základné, Schema, Person, AI, Social)
 *   → Štruktúra & Navigácia (Permalinky, Breadcrumbs)
 *   → Tracking & Overenie (Analytics, Overenie, Indexing)
 *   → Výkon & Optimalizácia (Auto Perf, Prednačítavanie, Obrázky)
 * - IMPROVED: Prehľadnejšia organizácia nastavení pre lepší workflow
 * 
 * CHANGELOG v2.8.0 (2026-01-23):
 * - NEW: WooCommerce Product Schema - shippingDetails (doprava, dodací čas)
 * - NEW: WooCommerce Product Schema - hasMerchantReturnPolicy (vrátenie 14 dní)
 * - NEW: Organization Schema - Inteligentná validácia adresy pre LocalBusiness
 * - NEW: Organization Schema - Auto-fallback na Organization ak chýba adresa
 * - NEW: UI Warning pre LocalBusiness typy bez adresy
 * - NEW: Real-time JavaScript validation pre address fields
 * - FIX: Prefetch optimalizácia (250ms, 1 concurrent, 5 pages)
 * - FIX: Connection speed detection pre prefetch (vypne na 2G)
 * - FIX: N+1 query optimization v image scan (batch meta cache)
 * - FIX: Autoload optimization pre veľké data (redirects, link_map)
 * - NEW: Brotli compression support (15-25% lepšie ako Gzip)
 * - NEW: Version marker v schema HTML komentári (debugging)
 * 
 * CHANGELOG v2.8.5 (2026-01-23):
 * - NEW: Last-Modified HTTP headers pre optimálny crawl budget
 * - NEW: 304 Not Modified support pre úsporu bandwidth
 * - IMPROVED: Google crawl efficiency - vie presne kedy re-crawlovať
 * - IMPROVED: Browser caching - využíva Last-Modified pre validation
 * - PERFORMANCE: Menej zbytočných crawls = rýchlejšia indexácia
 * 
 * CHANGELOG v2.8.4 (2026-01-23):
 * - FIXED: WooCommerce meta description fallback pre Themify Builder
 * - IMPROVED: 3-level fallback: Long > Short > Title+Category+Price
 * - FIXED: Frontend auto-generation ak meta popis nie je v DB
 * - IMPROVED: SIMPLE MODE pre WC produkty (direct truncation)
 * - FIXED: Thresholdy znížené pre krátke popisy
 * 
 * CHANGELOG v2.7.1 (2026-01-23):
 * - FIX: Performance Monitor - Detekované procesy s konkrétnym zoznamom
 * - NEW: [Vypnúť] buttony pre každý proces priamo v odporúčaniach
 * - NEW: Smooth scroll to Optional Processes sekcia
 * - NEW: Collapsible process details table
 * 
 * CHANGELOG v2.7.0 (2026-01-22):
 * - IMPROVED: PNG s transparentnosťou sa PRESKAKUJE (neoptimalizuje)
 * - NEW: Transparentné PNG (loga, ikony) zachovávajú 100% kvalitu
 * - NEW: Modré info badge "🎨 PNG s transparentnosťou" v Media Library
 * - NEW: Meta tag '_wseo_skipped_reason' pre tracking preskočených obrázkov
 * - IMPROVED: PNG BEZ transparentnosti sa stále optimalizuje (JPEG konverzia)
 * - FIXED: Eliminovaná možnosť degradácie kvality transparent PNG
 * - IMPROVED: WebP verzie sa vytvárajú iba pre optimalizované obrázky
 * 
 * CHANGELOG v2.6.8 (2026-01-22):
 * - CRITICAL FIX: Optimalizácia obrázkov teraz skutočne ZMENŠUJE namiesto zväčšovania! 🎯
 * - FIXED: PNG compression level 9 spôsoboval ZVÄČŠENIE malých PNG súborov
 * - FIXED: GD library pridávala overhead namiesto optimalizácie
 * - NEW: Inteligentná PNG → JPEG konverzia pre obrázky bez transparentnosti (až 70% úspora)
 * - NEW: Podpora externých nástrojov (jpegoptim, jpegtran, optipng, pngquant)
 * - NEW: PNG compression level 6 namiesto 9 (optimálny pre väčšinu obrázkov)
 * - NEW: Automatické obnovenie originálneho súboru ak je optimalizovaný väčší
 * - NEW: Kontrola transparentnosti pred PNG → JPEG konverziou
 * - NEW: WebP kvalita znížená na 82 (menší súbor, stále vynikajúca kvalita)
 * - IMPROVED: Removal EXIF metadát cez nový image buffer (účinnejšie)
 * 
 * CHANGELOG v2.6.7 (2026-01-22):
 * - NEW: 🚀 Automatická optimalizácia obrázkov pri uploade (vždy zapnuté)
 * - NEW: Každý nový JPEG/PNG obrázok sa automaticky optimalizuje po nahratí
 * - NEW: Gradient info box v Globálne nastavenia o auto-optimalizácii
 * - NEW: Zobrazenie optimization info v Media Library
 * - NEW: Zelený badge "✅ Optimalizované" s detailmi (dátum, ušetrené MB, %)
 * - NEW: Žltý badge "⏳ Čaká na optimalizáciu" pre staré obrázky
 * - NEW: Activity log zaznamenáva každú auto-optimalizáciu
 * - IMPROVED: Bezproblémová integrácia - žiadne nastavenia potrebné
 * 
 * CHANGELOG v2.6.6 (2026-01-22):
 * - FIXED: Analyzovať tabulky teraz funguje správne (ANALYZE TABLE)
 * - NEW: Skutočná optimalizácia obrázkov s batch processing
 * - NEW: JPEG kompressia kvalita 85% (vizuálne bez rozdielu, ~25% menšie)
 * - NEW: PNG optimalizácia s max kompresiou (~35% menšie)
 * - NEW: Automatické vytváranie WebP verzií (85% kvalita)
 * - NEW: Odstránenie EXIF metadát (GPS, fotoaparát, atď.)
 * - NEW: Progresívne JPEG pre rýchlejšie načítanie
 * - NEW: Bezpečná záloha originálnych obrázkov (.wseo-backup)
 * - NEW: Batch processing po 10 obrázkoch (zabráni timeout)
 * - NEW: Real-time progress bar s percentami
 * - NEW: Detailné štatistiky (potenciálna úspora, celková úspora)
 * - NEW: Označenie optimalizovaných obrázkov (neprekópia sa 2x)
 * 
 * CHANGELOG v2.6.5 (2026-01-22):
 * - NEW: Sekcia "Servis & Údržba" databázy v admin menu
 * - NEW: Fáza 1 - Rýchle čistenie (revízie, autodrafts, trash, spam, transienty)
 * - NEW: Fáza 1 - Optimalizácia SQL tabuliek a defragmentácia
 * - NEW: Fáza 2 - Orphaned metadata cleanup (postmeta, commentmeta, termmeta)
 * - NEW: Fáza 2 - Autoload options optimalizácia (zrýchlenie WordPress)
 * - NEW: Fáza 2 - Databázový backup s SQL dump exportom
 * - NEW: Fáza 3 - Automatické naplánované čistenie (denne/týždenne/mesačne)
 * - NEW: Fáza 3 - Image optimization servis (scan ALT textov a WebP konverzie)
 * - NEW: Fáza 3 - Diagnostika & repair databázy (integrita, oprava tabuliek)
 * - NEW: Fáza 3 - Export diagnostického reportu (systémové info, DB štatistiky)
 * - NEW: Activity log - záznam všetkých maintenance operácií
 * - NEW: Email reporty po automatickom čistení
 * 
 * CHANGELOG v2.6.3 (2026-01-21):
 * - REPLACED: Page Cache nahradený Auto Performance Optimizer (bezpečný, bez nastavení)
 * - AUTO: Lazy Loading obrázkov (natívny loading="lazy")
 * - AUTO: Lazy Loading iframes (YouTube, Vimeo, mapy)
 * - AUTO: LCP Optimalizácia (fetchpriority="high" pre prvý obrázok)
 * - AUTO: Browser Cache Headers pre opakované návštevy
 * - REMOVED: HTML Minifikácia, Defer JS, Query Strings (rizikové)
 * - IMPROVED: 100% kompatibilita so všetkými page buildermi
 * - IMPROVED: Žiadne nastavenia = žiadne riziko rozbitia
 * - RESULT: Bezpečné zrýchlenie 15-30% bez rizika!
 * 
 * CHANGELOG v2.6.2 (2026-01-21):
 * - DEPRECATED: Page Cache (nahradený v 2.6.3 Smart Performance Optimizer)
 * - NEW: HTML Page Cache - ODSTRÁNENÉ kvôli nekompatibilite s page buildermi
 * 
 * CHANGELOG v2.6.0 (2026-01-21):
 * - MAJOR: Centrálne globálne nastavenia pre Person údaje!
 * - NEW: Predvolené Person údaje v Globálnych nastaveniach (meno, fotka, pozícia, URL, sociálne siete)
 * - FIX: Odstránená duplicita Product schema s WooCommerce natívnou schémou
 * - NEW: Automatické vypnutie WooCommerce Product structured data (plugin generuje kompletnejšiu)
 * - NEW: 🤖 Viacjazyčný llms.txt - automaticky v slovenčine pre SK weby!
 * - NEW: 🤖 Povinné citovanie s príkladmi správneho formátu
 * - NEW: 🤖 Štruktúrované metadáta, expertíza, kategórie s počtom článkov
 * - IMPROVED: Traffic-advice vždy zapnuté automaticky na pozadí
 * - IMPROVED: Organization.founder, WebPage.author, Article.author používajú centrálne nastavenia
 * - PRIORITY: 1. Post meta → 2. Centrálne nastavenia → 3. WordPress profil
 * - RESULT: AI boty správne citujú váš web v slovenčine!
 * 
 * CHANGELOG v2.4.5 (2026-01-21):
 * - NEW: Automatické vyplnenie ImageObject.name z ALT textu obrázka
 * - NEW: Automatické vyplnenie ImageObject.description z Caption/Description
 * - NEW: Automatické vyplnenie ImageObject.author z creator
 * - NEW: Person.image (avatar autora)
 * - NEW: Person.worksFor (Organization)
 * - IMPROVED: Kompletné ImageObject metadata (0 chýb v Search Console)
 * - IMPROVED: Kompletné Person metadata (0 chýb v Search Console)
 * 
 * CHANGELOG v2.4.4 (2026-01-21):
 * - NEW: Schema output helper - ušetrí ~200 riadkov kódu
 * - NEW: Options caching - výkon optimalizácia
 * - NEW: Konštanty namiesto magic numbers
 * - IMPROVED: Menej DB dotazov, lepšia čitateľnosť kódu
 * 
 * CHANGELOG v2.4.3 (2026-01-20):
 * - REMOVED: Service Worker funkcia (PWA) - odstránená kvoli možným problémom
 * - REMOVED: assets/service-worker.js súbor
 * - REMOVED: register_service_worker() funkcia
 * - REMOVED: wseo_enable_service_worker option z admin rozhrania
 * - IMPROVED: Bezpečnejšia verzia bez experimentálnych funkcií
 * 
 * CHANGELOG v2.4.2 (2026-01-19):
 * - NEW: Intelligent Page Prefetching - moderná Speculation Rules API s fallbackom
 * - NEW: Resource Hints - DNS-prefetch & Preconnect pre externé zdroje
 * - NEW: Critical Resource Preloading - Hero images, fonty pre LCP optimalizáciu
 * - NEW: Adaptive Loading - prispôsobenie podľa kvality pripojenia
 * - NEW: Priority Hints - fetchpriority pre kritické resources
 * - NEW: Prefetch stratégie - hover, viewport, idle, eager
 * - NEW: Auto-detect external domains pre DNS prefetch
 * - NEW: Hero Image preload pre LCP boost
 * - NEW: Smart exclude patterns - WooCommerce pages, admin areas
 * - IMPROVED: Výkon webu - očakávané zlepšenie LCP o 30-50%, Navigation o 40-60%
 * 
 * CHANGELOG v2.4.1 (2026-01-18):
 * - NEW: Tab system for Redirects page (Existujúce presmerovania / 404 Chyby)
 * - IMPROVED: Better UX - separated concerns for easier navigation
 * 
 * CHANGELOG v2.4.0 (2026-01-18):
 * - NEW: 70+ LocalBusiness Schema Types! (was 15) - MOST COMPLETE WordPress plugin
 * - NEW: 35+ Main Schema Types (VideoObject, Course, JobPosting, Service, FAQPage)
 * - NEW: HomeAndConstruction (8): Electrician, Plumber, Locksmith, HVACBusiness...
 * - NEW: Automotive (8): AutoBodyShop, AutoWash, GasStation, MotorcycleDealer...
 * - NEW: Food (9): Bakery, CafeOrCoffeeShop, BarOrPub, Brewery, Winery...
 * - NEW: Lodging (7): BedAndBreakfast, Campground, Hostel, Resort, SkiResort...
 * - NEW: Beauty (6): DaySpa, NailSalon, TattooParlor, HealthAndBeautyBusiness...
 * - NEW: Stores (29): BikeStore, BookStore, ClothingStore, ElectronicsStore...
 * - NEW: AI Content Marking (2026 standard) - mark AI-generated content
 * - NEW: NewsArticle, BlogPosting schema - dynamic article types
 * - NEW: SoftwareApplication schema - for software products
 * - NEW: NewsMediaOrganization - for news portals
 * - NEW: Tweetko.com social profile support
 * - NEW: Conditional schema fields - show only relevant fields
 * - FIXED: Breadcrumbs empty itemListElement (Google error)
 * - IMPROVED: Schema.org 100% Google 2026 compliant
 * 
 * CHANGELOG v2.3.6 (2026-01-17):
 * - NEW: "Vymazať všetky nefunkčné odkazy" - removes ALL broken links with one click
 * - NEW: "Optimalizovať" button for over-used anchors - keeps 2-3 optimal links
 * - ⚠️ WORKS ONLY for standard blog posts (not page builders)
 * - Smart optimization: removes bad anchors, optimizes frequent ones
 */

defined('ABSPATH') or die;

// Plugin constants
define('WSEO_VERSION', '3.2.0');
define('WSEO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WSEO_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WSEO_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Schema constants
define('WSEO_SCHEMA_CONTEXT', 'https://schema.org');
define('WSEO_JSON_FLAGS', JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

// Default values  

// Load License System (v2.8.2)
require_once WSEO_PLUGIN_DIR . 'core/license.php';

// Load Auto-Update System (v2.8.2)
require_once WSEO_PLUGIN_DIR . 'core/auto-update.php';

define('WSEO_DEFAULT_CURRENCY', 'EUR');
define('WSEO_DEFAULT_COUNTRY', 'SK');
define('WSEO_DEFAULT_RATING_SCALE', '5');

// Trim lengths
define('WSEO_EXCERPT_WORDS', 30);
define('WSEO_LONG_EXCERPT_WORDS', 50);

/**
 * Main Plugin Class
 */
class Webstudio_SEO_Pro {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        // v2.9.6: Ensure auto-fill options are set (for existing installs upgrading)
        $this->ensure_auto_fill_defaults();
        
        $this->init_hooks();
    }
    
    /**
     * v2.9.6: Ensure auto-fill image options have default values
     * This runs on every page load but only updates if options don't exist
     */
    private function ensure_auto_fill_defaults() {
        // Only run once per request
        static $done = false;
        if ($done) return;
        $done = true;
        
        // v2.9.9: Force defaults ON for new installs AND fix corrupted options
        $options = array(
            'wseo_auto_alt' => '1',
            'wseo_auto_title' => '1',
            'wseo_auto_caption' => '1',
            'wseo_auto_description' => '1'
        );
        
        foreach ($options as $option_name => $default_value) {
            $current = get_option($option_name);
            
            // If option doesn't exist OR is empty string, set default
            if ($current === false || $current === '') {
                delete_option($option_name); // Clean any corrupted state
                add_option($option_name, $default_value, '', 'yes');
            }
        }
    }
    
    /**
     * Schema output helper - reduces code duplication
     * @param array $schema Schema array
     */
    private function output_schema($schema) {
        echo '<!-- WebStudio SEO Pro v' . WSEO_VERSION . ' Schema -->' . "\n";
        echo '<script type="application/ld+json">' . wp_json_encode($schema, WSEO_JSON_FLAGS) . '</script>' . "\n";
    }
    
    /**
     * v2.9.9: Get all Schema.org types for consistent use across all forms
     * @param bool $for_select If true, returns HTML options; if false, returns array
     * @param string $selected Currently selected value
     * @return string|array
     */
    /**
     * v3.1: Get all Schema.org types - COMPLETE LIST (150+ types)
     * Includes ALL LocalBusiness subtypes from Schema.org 2026
     */
    public function get_schema_types_options($selected = '') {
        $types = array(
            '🏢 Základné' => array(
                'Organization' => 'Organizácia',
                'NewsMediaOrganization' => 'Spravodajský portál',
                'LocalBusiness' => 'Lokálny podnik',
            ),
            '🏨 Ubytovanie' => array(
                'LodgingBusiness' => '🛏️ Ubytovanie (kategória)',
                'Hotel' => '🏨 Hotel',
                'BedAndBreakfast' => '🏠 B&B / Penzión',
                'Hostel' => '🏢 Hostel',
                'Motel' => '🚗 Motel',
                'Resort' => '🏝️ Resort',
                'Campground' => '⛺ Kemping',
                'SkiResort' => '⛷️ Lyžiarsky rezort',
                'VacationRental' => '🏖️ Dovolenková nehnuteľnosť',
            ),
            '🛠️ Služby' => array(
                'Service' => '🛠️ Služba',
                'ProfessionalService' => '💼 Profesionálne služby',
                'FinancialService' => '💰 Finančné služby',
                'AccountingService' => '📊 Účtovníctvo',
                'InsuranceAgency' => '🛡️ Poisťovňa',
                'EmploymentAgency' => '👔 Pracovná agentúra',
                'TravelAgency' => '✈️ Cestovná kancelária',
            ),
            '⚖️ Právne služby' => array(
                'LegalService' => '⚖️ Právne služby',
                'Attorney' => '👨‍⚖️ Advokát',
                'Notary' => '📜 Notár',
            ),
            '🍽️ Stravovanie' => array(
                'FoodEstablishment' => '🍽️ Stravovanie (kategória)',
                'Restaurant' => '🍽️ Reštaurácia',
                'CafeOrCoffeeShop' => '☕ Kaviareň',
                'Bakery' => '🥐 Pekáreň',
                'BarOrPub' => '🍺 Bar / Pub',
                'FastFoodRestaurant' => '🍔 Rýchle občerstvenie',
                'IceCreamShop' => '🍦 Zmrzlináreň',
                'Winery' => '🍷 Vinárstvo',
                'Brewery' => '🍺 Pivovar',
                'Distillery' => '🥃 Pálenica',
                'FoodService' => '🍴 Stravovacie služby',
            ),
            '🛒 Obchody - Všeobecné' => array(
                'Store' => '🛒 Obchod (kategória)',
                'ConvenienceStore' => '🏪 Večierka / Potraviny',
                'DepartmentStore' => '🏬 Obchodný dom',
                'ShoppingCenter' => '🛍️ Nákupné centrum',
                'OutletStore' => '🏷️ Outlet',
                'WholesaleStore' => '📦 Veľkoobchod',
                'PawnShop' => '💰 Záložňa',
            ),
            '🛒 Obchody - Oblečenie' => array(
                'ClothingStore' => '👕 Oblečenie',
                'MensClothingStore' => '👔 Pánske oblečenie',
                'ShoeStore' => '👟 Obuv',
                'JewelryStore' => '💎 Klenotníctvo',
            ),
            '🛒 Obchody - Elektronika' => array(
                'ElectronicsStore' => '📱 Elektronika',
                'ComputerStore' => '💻 Počítače',
                'MobilePhoneStore' => '📱 Mobily',
            ),
            '🛒 Obchody - Dom & Záhrada' => array(
                'FurnitureStore' => '🛋️ Nábytok',
                'HomeGoodsStore' => '🏠 Potreby do domácnosti',
                'HardwareStore' => '🔧 Železiarstvo',
                'GardenStore' => '🌱 Záhradníctvo',
                'Florist' => '💐 Kvetinárstvo',
            ),
            '🛒 Obchody - Potraviny & Nápoje' => array(
                'GroceryStore' => '🛒 Potraviny',
                'LiquorStore' => '🍾 Alkohol',
            ),
            '🛒 Obchody - Špeciálne' => array(
                'AutoPartsStore' => '🔩 Autodielce',
                'BikeStore' => '🚴 Cyklo obchod',
                'BookStore' => '📚 Kníhkupectvo',
                'HobbyShop' => '🎨 Hobby obchod',
                'MusicStore' => '🎸 Hudobniny',
                'MovieRentalStore' => '📀 Požičovňa filmov',
                'OfficeEquipmentStore' => '🖨️ Kancelárske potreby',
                'PetStore' => '🐕 Chovateľské potreby',
                'SportingGoodsStore' => '⚽ Športové potreby',
                'TireShop' => '🛞 Pneuservis',
                'ToyStore' => '🧸 Hračky',
            ),
            '💅 Krása & Wellness' => array(
                'HealthAndBeautyBusiness' => '💄 Zdravie & Krása (kategória)',
                'BeautySalon' => '💅 Kozmetika',
                'HairSalon' => '💇 Kaderníctvo',
                'NailSalon' => '💅 Nechtový salón',
                'DaySpa' => '🧖 Wellness / Spa',
                'TattooParlor' => '🎨 Tetovací salón',
            ),
            '🏥 Zdravotníctvo - Všeobecné' => array(
                'MedicalBusiness' => '🏥 Zdravotníctvo (kategória)',
                'MedicalClinic' => '🏥 Zdravotná klinika',
                'Pharmacy' => '💊 Lekáreň',
                'Physician' => '👨‍⚕️ Lekár',
                'PrimaryCare' => '🩺 Všeobecné lekárstvo',
                'CommunityHealth' => '🏘️ Komunitné zdravie',
                'PublicHealth' => '🌐 Verejné zdravotníctvo',
                'Emergency' => '🚑 Urgentná medicína',
            ),
            '🏥 Zdravotníctvo - Špecializácie' => array(
                'Dentist' => '🦷 Zubár',
                'Dermatology' => '🧴 Dermatológia',
                'Optician' => '👓 Optika',
                'Optometric' => '👁️ Optometria',
                'Otolaryngologic' => '👂 ORL (ucho-nos-krk)',
                'Pediatric' => '👶 Pediatria',
                'Geriatric' => '👴 Geriatria',
                'Oncologic' => '🎗️ Onkológia',
                'Psychiatric' => '🧠 Psychiatria',
                'Physiotherapy' => '🏃 Fyzioterapia',
                'PlasticSurgery' => '💉 Plastická chirurgia',
                'Podiatric' => '🦶 Podiatria (nohy)',
            ),
            '🏥 Zdravotníctvo - Ženy & Deti' => array(
                'Gynecologic' => '👩 Gynekológia',
                'Obstetric' => '🤰 Pôrodníctvo',
                'Midwifery' => '👶 Pôrodná asistencia',
                'Nursing' => '👩‍⚕️ Ošetrovateľstvo',
                'DietNutrition' => '🥗 Výživa / Diéta',
            ),
            '🏥 Veterinár' => array(
                'VeterinaryCare' => '🐾 Veterinár',
            ),
            '🚗 Automotive' => array(
                'AutomotiveBusiness' => '🚗 Automotive (kategória)',
                'AutoDealer' => '🚗 Autosalón',
                'AutoRepair' => '🔧 Autoservis',
                'AutoBodyShop' => '🛠️ Autokarosáreň',
                'AutoRental' => '🚙 Autopožičovňa',
                'AutoWash' => '🚿 Autoumyváreň',
                'GasStation' => '⛽ Čerpacia stanica',
                'MotorcycleDealer' => '🏍️ Predaj motocyklov',
                'MotorcycleRepair' => '🔧 Oprava motocyklov',
            ),
            '🔨 Stavebníctvo & Remeselníci' => array(
                'HomeAndConstructionBusiness' => '🏗️ Stavebníctvo (kategória)',
                'GeneralContractor' => '🏗️ Stavebná firma',
                'Electrician' => '⚡ Elektrikár',
                'Plumber' => '🔧 Inštalatér',
                'RoofingContractor' => '🏠 Pokrývač',
                'HVACBusiness' => '❄️ Klimatizácie / Kúrenie',
                'HousePainter' => '🎨 Maliar',
                'Locksmith' => '🔐 Zámočník',
                'MovingCompany' => '📦 Sťahovacia firma',
            ),
            '🏠 Nehnuteľnosti' => array(
                'RealEstateAgent' => '🏠 Reality',
            ),
            '🎭 Zábava & Kultúra' => array(
                'EntertainmentBusiness' => '🎭 Zábava (kategória)',
                'MovieTheater' => '🎬 Kino',
                'AmusementPark' => '🎢 Zábavný park',
                'ArtGallery' => '🖼️ Galéria',
                'Casino' => '🎰 Kasíno',
                'ComedyClub' => '😂 Comedy klub',
                'NightClub' => '🌙 Nočný klub',
                'AdultEntertainment' => '🔞 Pre dospelých',
            ),
            '🏃 Šport & Fitness' => array(
                'SportsActivityLocation' => '🏃 Športovisko (kategória)',
                'ExerciseGym' => '🏋️ Fitness / Gym',
                'HealthClub' => '💪 Zdravotný klub',
                'GolfCourse' => '⛳ Golfové ihrisko',
                'BowlingAlley' => '🎳 Bowling',
                'TennisComplex' => '🎾 Tenisový komplex',
                'PublicSwimmingPool' => '🏊 Verejný bazén',
                'SportsClub' => '⚽ Športový klub',
                'StadiumOrArena' => '🏟️ Štadión / Aréna',
            ),
            '📻 Médiá & Komunikácia' => array(
                'RadioStation' => '📻 Rozhlasová stanica',
                'TelevisionStation' => '📺 TV stanica',
            ),
            '🏛️ Verejné služby' => array(
                'GovernmentOffice' => '🏛️ Úrad',
                'Library' => '📚 Knižnica',
                'ArchiveOrganization' => '🗄️ Archív',
                'EmergencyService' => '🚨 Záchranné služby',
                'TouristInformationCenter' => 'ℹ️ Turistické info centrum',
            ),
            '🐾 Zvieratá & Starostlivosť' => array(
                'AnimalShelter' => '🐕 Útulok pre zvieratá',
                'ChildCare' => '👶 Škôlka / Opatrovanie detí',
            ),
            '🧹 Ostatné služby' => array(
                'DryCleaningOrLaundry' => '🧺 Čistiareň / Práčovňa',
                'InternetCafe' => '💻 Internetová kaviareň',
                'RecyclingCenter' => '♻️ Recyklačné centrum',
                'SelfStorage' => '📦 Skladové priestory',
            ),
            '📄 Stránky' => array(
                'ContactPage' => '📞 Kontaktná stránka',
                'AboutPage' => 'ℹ️ O nás stránka',
                'FAQPage' => '❓ FAQ stránka',
            ),
        );
        
        $html = '<option value="">— Globálne nastavenia —</option>';
        
        foreach ($types as $group_label => $group_types) {
            $html .= '<optgroup label="' . esc_attr($group_label) . '">';
            foreach ($group_types as $value => $label) {
                $sel = selected($selected, $value, false);
                $html .= '<option value="' . esc_attr($value) . '"' . $sel . '>' . esc_html($label) . '</option>';
            }
            $html .= '</optgroup>';
        }
        
        return $html;
    }
    
    /**
     * ==========================================
     * BROTLI COMPRESSION MODULE (v2.8.1)
     * Smart compression with Brotli + Gzip fallback
     * ==========================================
     */
    
    /**
     * Check if Brotli compression is supported
     * @return bool
     */
    private function supports_brotli() {
        // Check server-side support (PHP extension)
        $server_support = function_exists('brotli_compress') && function_exists('brotli_uncompress');
        
        // Check client-side support (browser Accept-Encoding header)
        $client_support = false;
        if (isset($_SERVER['HTTP_ACCEPT_ENCODING'])) {
            $client_support = strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'br') !== false;
        }
        
        return $server_support && $client_support;
    }
    
    /**
     * Get 2-letter ISO country code from WooCommerce settings
     * WooCommerce stores country as "US:CA" (country:state) format
     * Google Rich Results requires only the 2-letter ISO country code
     * @return string 2-letter ISO country code (e.g., "SK", "US", "DE")
     */
    private function get_country_code() {
        $country_setting = get_option('woocommerce_default_country', 'SK');
        
        // WooCommerce format can be "US:CA" (country:state) or just "SK"
        if (strpos($country_setting, ':') !== false) {
            $parts = explode(':', $country_setting);
            return $parts[0]; // Return only the country code
        }
        
        return $country_setting;
    }
    
    /**
     * Smart compress - uses Brotli if available, falls back to Gzip
     * @param string $data Data to compress
     * @param int $level Compression level (0-11 for Brotli, 0-9 for Gzip)
     * @return array ['data' => compressed_data, 'encoding' => 'br'|'gzip', 'ratio' => float, 'method' => string]
     */
    private function wseo_smart_compress($data, $level = null) {
        $original_size = strlen($data);
        
        if ($this->supports_brotli()) {
            // Brotli compression (level 0-11, default 11 for best compression)
            $level = $level ?? 11;
            $compressed = brotli_compress($data, $level);
            
            if ($compressed !== false) {
                $compressed_size = strlen($compressed);
                
                return array(
                    'data' => $compressed,
                    'encoding' => 'br',
                    'ratio' => $original_size > 0 ? round(($original_size - $compressed_size) / $original_size * 100, 2) : 0,
                    'method' => 'Brotli',
                    'original_size' => $original_size,
                    'compressed_size' => $compressed_size,
                    'level' => $level
                );
            }
        }
        
        // Fallback to Gzip (level 0-9, default 9 for best compression)
        $level = min($level ?? 9, 9);
        $compressed = gzcompress($data, $level);
        
        if ($compressed !== false) {
            $compressed_size = strlen($compressed);
            
            return array(
                'data' => $compressed,
                'encoding' => 'gzip',
                'ratio' => $original_size > 0 ? round(($original_size - $compressed_size) / $original_size * 100, 2) : 0,
                'method' => 'Gzip',
                'original_size' => $original_size,
                'compressed_size' => $compressed_size,
                'level' => $level
            );
        }
        
        // No compression possible
        return array(
            'data' => $data,
            'encoding' => 'none',
            'ratio' => 0,
            'method' => 'None',
            'original_size' => $original_size,
            'compressed_size' => $original_size,
            'level' => 0
        );
    }
    
    /**
     * Decompress data (auto-detect Brotli or Gzip)
     * @param string $data Compressed data
     * @param string $encoding Encoding type ('br' or 'gzip')
     * @return string|false Decompressed data or false on failure
     */
    private function wseo_smart_decompress($data, $encoding = 'auto') {
        if ($encoding === 'auto') {
            // Try Brotli first
            if (function_exists('brotli_uncompress')) {
                $result = @brotli_uncompress($data);
                if ($result !== false) {
                    return $result;
                }
            }
            
            // Try Gzip
            $result = @gzuncompress($data);
            if ($result !== false) {
                return $result;
            }
            
            return false;
        }
        
        if ($encoding === 'br' && function_exists('brotli_uncompress')) {
            return brotli_uncompress($data);
        }
        
        if ($encoding === 'gzip') {
            return gzuncompress($data);
        }
        
        return false;
    }
    
    /**
     * Get compression statistics
     * @return array
     */
    private function get_compression_stats() {
        $stats = array(
            'brotli_available' => function_exists('brotli_compress'),
            'brotli_enabled' => $this->supports_brotli(),
            'gzip_available' => function_exists('gzcompress'),
            'default_method' => $this->supports_brotli() ? 'Brotli' : 'Gzip',
            'php_version' => PHP_VERSION,
            'extensions' => array()
        );
        
        if (function_exists('brotli_compress')) {
            $stats['extensions'][] = 'brotli';
        }
        
        if (function_exists('gzcompress')) {
            $stats['extensions'][] = 'zlib (gzip)';
        }
        
        return $stats;
    }
    
    private function init_hooks() {
        // v2.9.17: FORCE auto-fill image options ON by default (no user action needed)
        // This runs on every page load to ensure options are always set
        $this->ensure_image_autofill_enabled();
        
        // v2.10.05: Custom email sender name and address
        add_filter('wp_mail_from_name', array($this, 'custom_mail_from_name'), 10, 1);
        add_filter('wp_mail_from', array($this, 'custom_mail_from_email'), 10, 1);
        
        // Load translations
        add_action('init', array($this, 'load_textdomain'));
        
        // Admin
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));
        add_action('admin_notices', array($this, 'activation_notice'));
        
        // Meta boxes
        add_action('add_meta_boxes', array($this, 'add_meta_boxes'));
        add_action('save_post', array($this, 'save_meta_boxes'), 10, 2);
        
        // Quick Edit
        add_action('quick_edit_custom_box', array($this, 'quick_edit_fields'), 10, 2);
        add_action('save_post', array($this, 'save_quick_edit'), 10, 2);
        add_action('admin_footer-edit.php', array($this, 'quick_edit_javascript'));
        
        // Add SEO column to post lists
        add_filter('manage_posts_columns', array($this, 'add_seo_column'));
        add_filter('manage_pages_columns', array($this, 'add_seo_column'));
        add_filter('manage_product_posts_columns', array($this, 'add_seo_column'));
        add_action('manage_posts_custom_column', array($this, 'render_seo_column'), 10, 2);
        add_action('manage_pages_custom_column', array($this, 'render_seo_column'), 10, 2);
        // Note: products use manage_posts_custom_column, not separate hook (to avoid duplication)
        
        // SEO Filters for dashboard issues
        add_action('pre_get_posts', array($this, 'filter_posts_by_seo_issues'));
        add_action('pre_get_posts', array($this, 'filter_media_by_alt'));
        
        // Taxonomy SEO fields (categories, tags, product_cat, product_tag)
        $taxonomies = array('category', 'post_tag', 'product_cat', 'product_tag');
        foreach ($taxonomies as $taxonomy) {
            add_action($taxonomy . '_add_form_fields', array($this, 'taxonomy_add_seo_fields'));
            add_action($taxonomy . '_edit_form_fields', array($this, 'taxonomy_edit_seo_fields'), 10, 2);
            add_action('created_' . $taxonomy, array($this, 'save_taxonomy_seo_fields'));
            add_action('edited_' . $taxonomy, array($this, 'save_taxonomy_seo_fields'));
        }
        
        // Taxonomy redirects
        add_action('template_redirect', array($this, 'handle_taxonomy_redirects'), 0);
        
        // WooCommerce
        add_action('woocommerce_product_options_general_product_data', array($this, 'add_product_seo_fields'));
        add_action('woocommerce_process_product_meta', array($this, 'save_product_seo_fields'));
        
        // CRITICAL: Disable WooCommerce native Product schema to prevent duplication
        // Plugin generates more complete Product schema with all required fields
        // Use 'wp' hook (priority 5) to ensure WooCommerce has initialized
        add_action('wp', array($this, 'disable_woocommerce_schema'), 5);
        
        // Frontend
        add_action('wp_head', array($this, 'output_meta_tags'), 1);
        add_action('wp_body_open', array($this, 'output_gtm_body'));
        add_filter('pre_get_document_title', array($this, 'filter_document_title'), 999);
        add_filter('wp_title', array($this, 'filter_wp_title'), 999, 3);
        add_action('after_setup_theme', array($this, 'add_title_tag_support'));
        
        // Last-Modified headers for better crawl efficiency (v2.8.6 - FIXED)
        // Use template_redirect instead of send_headers to execute BEFORE cache plugins
        add_action('template_redirect', array($this, 'send_last_modified_header'), 0);  // PRIORITY 0!
        
        // Auto-clear cache on content save (v2.8.6)
        add_action('save_post', array($this, 'auto_clear_cache_on_save'), 999, 3);
        add_action('edited_term', array($this, 'auto_clear_cache_on_term_save'), 999, 3);
        
        // Performance enhancements (v2.4.2)
        // SAFE MODE: Ak je zapnuté wseo_safe_mode, všetky performance funkcie sú vypnuté
        if (get_option('wseo_safe_mode', '0') !== '1') {
            add_action('wp_head', array($this, 'output_resource_hints'), 2);
            add_action('wp_head', array($this, 'output_critical_preloads'), 3);
            // DISABLED v2.8.10: output_adaptive_loading spôsobuje FOUC (biela obrazovka) a vysoké CLS
            // JavaScript pridáva CSS triedy počas načítania, čo spôsobuje layout shift
            // add_action('wp_head', array($this, 'output_adaptive_loading'), 4);
            add_action('wp_enqueue_scripts', array($this, 'enqueue_prefetch_script'));
            
            // FIX v2.8.10: Anti-FOUC system - hide page until loaded
            add_action('wp_head', array($this, 'output_accessibility_fix_css'), 1);
            add_action('wp_footer', array($this, 'output_anti_fouc_reveal'), 999);
            
            // v3.2: Critical CSS Inline
            if (get_option('wseo_critical_css_enabled', '0') === '1') {
                add_action('wp_head', array($this, 'output_critical_css_inline'), 1);
            }
            
            // v2.10.0: Marketing - Newsletter, CTA, Push Notifications
            add_action('wp_footer', array($this, 'output_marketing_popups'), 50);
        }
        add_filter('wp_get_attachment_image_attributes', array($this, 'add_fetchpriority_attributes'), 10, 2);
        
        // Advanced Performance (v2.6.0) - ÚPLNE VYPNUTÉ
        // Tieto optimalizácie spôsobovali bielu stránku (FOUC)
        // Ponechané len pôvodné bezpečné funkcie z v2.4.2
        // add_action('wp_head', array($this, 'output_early_hints_header'), 0);
        // add_action('send_headers', array($this, 'send_103_early_hints'));
        
        // Reading Time and TOC
        add_filter('the_content', array($this, 'add_reading_time_and_toc'), 5);
        
        // Virtual files
        add_action('init', array($this, 'handle_virtual_files'), 0); // Priority 0 - run BEFORE WordPress processes the request
        
        // Settings
        add_action('admin_init', array($this, 'register_settings'));
        
        // Auto Alt Text for images
        add_action('add_attachment', array($this, 'auto_set_image_alt'));
        add_filter('wp_generate_attachment_metadata', array($this, 'auto_set_image_alt_on_upload'), 10, 2);
        
        // Show optimization info in media library
        add_filter('attachment_fields_to_edit', array($this, 'add_optimization_info_to_media'), 10, 2);
        
        // AJAX for bulk fill
        add_action('wp_ajax_wseo_bulk_fill_images', array($this, 'ajax_bulk_fill_images'));
        add_action('wp_ajax_wseo_get_image_stats', array($this, 'ajax_get_image_stats'));
        add_action('wp_ajax_wseo_clear_image_metadata', array($this, 'ajax_clear_image_metadata'));
        add_action('wp_ajax_wseo_save_image_templates', array($this, 'ajax_save_image_templates'));
        add_action('wp_ajax_wseo_save_auto_settings', array($this, 'ajax_save_auto_settings'));
        add_action('wp_ajax_wseo_save_avif_setting', array($this, 'ajax_save_avif_setting'));
        add_action('wp_ajax_wseo_bulk_generate_keywords', array($this, 'ajax_bulk_generate_keywords'));
        add_action('wp_ajax_wseo_clear_all_keywords', array($this, 'ajax_clear_all_keywords'));
        add_action('wp_ajax_wseo_generate_all_keywords', array($this, 'ajax_generate_all_keywords'));
        
        // Instant Indexing - notify search engines on publish/update
        add_action('publish_post', array($this, 'instant_index_url'), 10, 2);
        add_action('publish_page', array($this, 'instant_index_url'), 10, 2);
        add_action('publish_product', array($this, 'instant_index_url'), 10, 2);
        add_action('save_post', array($this, 'instant_index_on_update'), 10, 3);
        
        // v2.10.0: Send push notification on new post
        add_action('publish_post', array($this, 'send_push_on_publish'), 15, 2);
        
        // Remove archive title prefixes (Category:, Tag:, Author:, etc.)
        add_filter('get_the_archive_title_prefix', '__return_empty_string');
        add_filter('get_the_archive_title', array($this, 'remove_archive_title_prefix'));
        
        // Remove /category/ and /tag/ from URLs
        add_filter('init', array($this, 'remove_category_tag_base'));
        add_filter('term_link', array($this, 'remove_category_base_from_link'), 10, 3);
        add_filter('term_link', array($this, 'remove_tag_base_from_link'), 10, 3);
        add_filter('request', array($this, 'redirect_old_category_urls'));
        
        // v2.10.20: Remove product base from URLs
        add_filter('init', array($this, 'remove_product_base'));
        add_filter('post_type_link', array($this, 'remove_product_base_from_link'), 10, 2);
        
        // v2.10.21: Remove product category base from URLs
        add_filter('init', array($this, 'remove_product_cat_base'));
        add_filter('term_link', array($this, 'remove_product_cat_base_from_link'), 10, 3);
        
        // Custom redirects
        add_action('template_redirect', array($this, 'handle_custom_redirects'), 0);
        
        // v2.10.16: Redirect wrong product slugs to correct one
        add_action('template_redirect', array($this, 'handle_product_slug_redirect'), 0);
        
        // v2.10.21: Redirect old product category URLs
        add_action('template_redirect', array($this, 'handle_product_cat_redirect'), 0);
        
        // Post-level redirects
        add_action('template_redirect', array($this, 'handle_post_redirects'), 1);
        
        // 404 Error tracking and auto-redirect (priority 1 - execute EARLY)
        add_action('template_redirect', array($this, 'track_404_errors'), 1);
        
        // AJAX for 404 management
        add_action('wp_ajax_wseo_get_404_logs', array($this, 'ajax_get_404_logs'));
        add_action('wp_ajax_wseo_create_redirect_from_404', array($this, 'ajax_create_redirect_from_404'));
        add_action('wp_ajax_wseo_clear_404_logs', array($this, 'ajax_clear_404_logs'));
        add_action('wp_ajax_wseo_ignore_404', array($this, 'ajax_ignore_404'));
        add_action('wp_ajax_wseo_submit_sitemap_to_gsc', array($this, 'ajax_submit_sitemap_to_gsc'));
        
        // AJAX for internal linking
        add_action('wp_ajax_wseo_get_link_suggestions', array($this, 'ajax_get_link_suggestions'));
        add_action('wp_ajax_wseo_scan_internal_links', array($this, 'ajax_scan_internal_links'));
        add_action('wp_ajax_wseo_get_orphan_pages', array($this, 'ajax_get_orphan_pages'));
        add_action('wp_ajax_wseo_remove_all_broken_links', array($this, 'ajax_remove_all_broken_links'));
        add_action('wp_ajax_wseo_optimize_anchor', array($this, 'ajax_optimize_anchor'));
        add_action('wp_ajax_wseo_get_anchor_analysis', array($this, 'ajax_get_anchor_analysis'));
        
        // AJAX for broken links checker
        add_action('wp_ajax_wseo_scan_broken_links', array($this, 'ajax_scan_broken_links'));
        add_action('wp_ajax_wseo_check_single_link', array($this, 'ajax_check_single_link'));
        
        // Build link map on post save
        add_action('save_post', array($this, 'update_link_map_on_save'), 20, 2);
        
        // AJAX for manual indexing
        add_action('wp_ajax_wseo_manual_index', array($this, 'ajax_manual_index'));
        
        // AJAX for migration
        add_action('wp_ajax_wseo_migrate_seo', array($this, 'ajax_migrate_seo'));
        add_action('wp_ajax_wseo_dismiss_migration', array($this, 'ajax_dismiss_migration'));
        
        // AUTO PERFORMANCE OPTIMIZER (v2.6.3) - bezpečné, automatické, bez nastavení
        // Len 4 bezpečné optimalizácie ktoré nikdy nerozbijú stránku
        add_action('send_headers', array($this, 'send_browser_cache_headers'));
        add_filter('the_content', array($this, 'auto_optimize_images'), 99);
        add_filter('post_thumbnail_html', array($this, 'auto_optimize_thumbnail'), 10, 5);
        add_filter('wp_get_attachment_image_attributes', array($this, 'auto_add_lazy_loading'), 10, 3);
        
        // Vymazanie starých cache súborov (jednorázovo)
        add_action('wp_ajax_wseo_clear_cache', array($this, 'ajax_clear_old_cache'));
        
        // Maintenance AJAX handlers
        add_action('wp_ajax_wseo_maintenance_cleanup', array($this, 'ajax_maintenance_cleanup'));
        add_action('wp_ajax_wseo_maintenance_optimize', array($this, 'ajax_maintenance_optimize'));
        add_action('wp_ajax_wseo_maintenance_analyze', array($this, 'ajax_maintenance_analyze'));
        add_action('wp_ajax_wseo_maintenance_orphaned', array($this, 'ajax_maintenance_orphaned'));
        add_action('wp_ajax_wseo_maintenance_scan_autoload', array($this, 'ajax_maintenance_scan_autoload'));
        add_action('wp_ajax_wseo_maintenance_disable_autoload', array($this, 'ajax_maintenance_disable_autoload'));
        add_action('wp_ajax_wseo_maintenance_save_scheduled', array($this, 'ajax_maintenance_save_scheduled'));
        add_action('wp_ajax_wseo_maintenance_scan_images', array($this, 'ajax_maintenance_scan_images'));
        add_action('wp_ajax_wseo_maintenance_optimize_images_batch', array($this, 'ajax_maintenance_optimize_images_batch'));
        add_action('wp_ajax_wseo_maintenance_check_integrity', array($this, 'ajax_maintenance_check_integrity'));
        add_action('wp_ajax_wseo_maintenance_repair_tables', array($this, 'ajax_maintenance_repair_tables'));
        add_action('wp_ajax_wseo_maintenance_export_diagnostic', array($this, 'ajax_maintenance_export_diagnostic'));
        add_action('wp_ajax_wseo_maintenance_backup', array($this, 'ajax_maintenance_backup'));
        add_action('wp_ajax_wseo_maintenance_clear_log', array($this, 'ajax_maintenance_clear_log'));
        
        // WordPress Doctor - Auto-Fix features (v2.8.8)
        add_action('wp_ajax_wseo_recovery_mode', array($this, 'ajax_recovery_mode'));
        add_action('wp_ajax_wseo_scan_media_links', array($this, 'ajax_scan_media_links'));
        add_action('wp_ajax_wseo_fix_media_links', array($this, 'ajax_fix_media_links'));
        add_action('wp_ajax_wseo_scan_duplicate_slugs', array($this, 'ajax_scan_duplicate_slugs'));
        add_action('wp_ajax_wseo_fix_duplicate_slugs', array($this, 'ajax_fix_duplicate_slugs'));
        add_action('wp_ajax_wseo_check_encoding', array($this, 'ajax_check_encoding'));
        add_action('wp_ajax_wseo_fix_encoding', array($this, 'ajax_fix_encoding'));
        
        // Performance Monitor AJAX
        add_action('wp_ajax_wseo_start_live_monitor', array($this, 'ajax_start_live_monitor'));
        add_action('wp_ajax_wseo_disable_process', array($this, 'ajax_disable_process'));
        add_action('wp_ajax_wseo_enable_process', array($this, 'ajax_enable_process'));
        add_action('wp_ajax_wseo_disable_all_safe', array($this, 'ajax_disable_all_safe'));
        add_action('wp_ajax_wseo_clear_ajax_log', array($this, 'ajax_clear_ajax_log'));
        add_action('wp_ajax_wseo_adjust_frequency', array($this, 'ajax_adjust_frequency'));
        add_action('wp_ajax_nopriv_wseo_log_performance', array($this, 'ajax_log_performance'));
        
        // Auto-Update AJAX
        add_action('wp_ajax_wseo_dismiss_update', array($this, 'ajax_dismiss_update'));
        
        // v2.10.0: Marketing AJAX handlers
        add_action('wp_ajax_wseo_newsletter_subscribe', array($this, 'ajax_newsletter_subscribe'));
        add_action('wp_ajax_nopriv_wseo_newsletter_subscribe', array($this, 'ajax_newsletter_subscribe'));
        add_action('wp_ajax_wseo_push_subscribe', array($this, 'ajax_push_subscribe'));
        add_action('wp_ajax_nopriv_wseo_push_subscribe', array($this, 'ajax_push_subscribe'));
        add_action('wp_ajax_wseo_export_newsletter', array($this, 'ajax_export_newsletter'));
        add_action('wp_ajax_wseo_send_test_push', array($this, 'ajax_send_test_push'));
        add_action('wp_ajax_wseo_back_in_stock_subscribe', array($this, 'ajax_back_in_stock_subscribe'));
        add_action('wp_ajax_nopriv_wseo_back_in_stock_subscribe', array($this, 'ajax_back_in_stock_subscribe'));
        
        // v2.10.0: WooCommerce Marketing Cron
        add_action('wseo_send_review_emails', array($this, 'send_review_emails'));
        add_action('wseo_send_abandoned_cart_emails', array($this, 'send_abandoned_cart_emails'));
        add_action('wseo_check_back_in_stock', array($this, 'check_back_in_stock'));
        
        // v2.10.0: WooCommerce Abandoned Cart tracking
        add_action('woocommerce_checkout_update_order_review', array($this, 'track_abandoned_cart'));
        add_action('woocommerce_add_to_cart', array($this, 'track_logged_in_user_cart'), 20);
        add_action('woocommerce_cart_updated', array($this, 'track_logged_in_user_cart'));
        add_action('woocommerce_thankyou', array($this, 'clear_abandoned_cart'));
        add_action('wp_ajax_wseo_track_cart_email', array($this, 'ajax_track_cart_email'));
        add_action('wp_ajax_nopriv_wseo_track_cart_email', array($this, 'ajax_track_cart_email'));
        
        // v2.10.0: WooCommerce Back in Stock - button on out of stock products
        add_action('woocommerce_single_product_summary', array($this, 'show_back_in_stock_form'), 31);
        add_action('woocommerce_product_set_stock_status', array($this, 'check_stock_status_change'), 10, 3);
        
        // v2.10.0: WooCommerce Push notifications
        add_action('publish_product', array($this, 'send_new_product_push'), 15, 2);
        add_action('woocommerce_product_set_sale_price', array($this, 'send_sale_product_push'), 10, 2);
        add_action('update_post_meta', array($this, 'check_sale_price_change'), 10, 4);
        
        // v2.10.0: Manual push notification AJAX
        add_action('wp_ajax_wseo_send_manual_push', array($this, 'ajax_send_manual_push'));
        
        // v2.10.03: Cleanup invalid push subscribers
        add_action('wp_ajax_wseo_cleanup_push_subscribers', array($this, 'ajax_cleanup_push_subscribers'));
        
        // v2.10.04: Send abandoned cart emails now
        add_action('wp_ajax_wseo_send_abandoned_emails_now', array($this, 'ajax_send_abandoned_emails_now'));
        
        // v3.2: Test Google Indexing API connection
        add_action('wp_ajax_wseo_test_google_indexing', array($this, 'ajax_test_google_indexing'));
        
        // Scheduled maintenance cleanup
        add_action('wseo_scheduled_maintenance', array($this, 'run_scheduled_maintenance'));
        
        // Check expired temporary disables
        add_action('wseo_check_expired_disables', array($this, 'check_expired_disables'));
        
        // v2.9.9: Telemetry ping (weekly)
        add_action('wseo_telemetry_ping', array('Webstudio_SEO_Pro', 'send_telemetry_ping'));
        
        // Heartbeat Control
        add_action('init', array($this, 'apply_heartbeat_settings'));
        add_action('admin_init', array($this, 'handle_heartbeat_settings_save'));
        
        // Add custom cron schedules
        add_filter('cron_schedules', array($this, 'add_cron_schedules'));


        
        // Activation
        register_activation_hook(__FILE__, array($this, 'activate'));
    }
    
    /**
     * Load plugin textdomain for translations
     */
    public function load_textdomain() {
        load_plugin_textdomain('webstudio-seo-pro', false, dirname(plugin_basename(__FILE__)) . '/languages');
    }
    
    /**
     * v2.10.05: Custom email sender name (site name instead of WordPress)
     */
    public function custom_mail_from_name($original_name) {
        // Only change if it's the default "WordPress"
        if ($original_name === 'WordPress') {
            return get_bloginfo('name');
        }
        return $original_name;
    }
    
    /**
     * v2.10.05: Custom email sender address
     */
    public function custom_mail_from_email($original_email) {
        // Only change if it's the default wordpress@domain
        if (strpos($original_email, 'wordpress@') === 0) {
            $domain = parse_url(home_url(), PHP_URL_HOST);
            return 'info@' . $domain;
        }
        return $original_email;
    }
    
    /**
     * Disable WooCommerce native Product schema to prevent duplication
     * Plugin generates more complete Product schema with all Google 2026 required fields
     * 
     * @since 2.6.0
     */
    public function disable_woocommerce_schema() {
        if (!class_exists('WooCommerce')) {
            return;
        }
        
        // CRITICAL: Must check if WC()->structured_data exists before using it
        if (!isset(WC()->structured_data) || !is_object(WC()->structured_data)) {
            return;
        }
        
        // Remove WooCommerce structured data for products
        // WooCommerce uses WC_Structured_Data class hooked to woocommerce_single_product_summary
        remove_action('woocommerce_single_product_summary', array(WC()->structured_data, 'generate_product_data'), 60);
        
        // Also remove from footer output (where JSON-LD is rendered)
        remove_action('wp_footer', array(WC()->structured_data, 'output_structured_data'), 10);
        
        // Alternative method: Filter the structured data output
        add_filter('woocommerce_structured_data_product', '__return_empty_array', 999);
        add_filter('woocommerce_structured_data_type_for_page', array($this, 'filter_wc_structured_data_type'), 999, 2);
        
        // ADDITIONAL: Completely disable WooCommerce schema output
        add_filter('woocommerce_schema_enabled', '__return_false', 999);
        
        // NUCLEAR OPTION: Remove ALL WooCommerce structured data
        remove_action('wp_footer', array(WC()->structured_data, 'output_structured_data'), 10);
        remove_action('woocommerce_email_order_details', array(WC()->structured_data, 'generate_order_data'), 20, 4);
        
        // EXTRA: Remove schema from product tabs/description
        remove_action('woocommerce_product_meta_start', array(WC()->structured_data, 'generate_product_data'), 60);
        remove_action('woocommerce_product_meta_end', array(WC()->structured_data, 'generate_product_data'), 60);
        
        // EXTRA: Filter to completely empty the structured data
        add_filter('woocommerce_structured_data_product_offer', '__return_empty_array', 999);
        add_filter('woocommerce_structured_data_review', '__return_empty_array', 999);
    }
    
    /**
     * Filter WooCommerce structured data type to disable Product schema
     * 
     * @param array $types Structured data types
     * @param string $page Current page type (optional - WC emails don't pass this)
     * @return array Filtered types
     */
    public function filter_wc_structured_data_type($types, $page = '') {
        // v2.9.9: Handle case when called from WC emails (no $page argument)
        if (!is_array($types)) {
            return array();
        }
        
        // Remove Product from structured data types on product pages
        if (is_product() || $page === 'product') {
            $types = array_diff($types, array('product'));
        }
        return $types;
    }
    
    /**
     * v2.9.17: Ensure image auto-fill options are ALWAYS enabled
     * This runs on every page load - no user configuration needed
     * FORCE enabled - ignores any previous settings
     */
    private function ensure_image_autofill_enabled() {
        // FORCE all auto-fill options to '1' - always enabled, no exceptions
        update_option('wseo_auto_alt', '1');
        update_option('wseo_auto_title', '1');
        update_option('wseo_auto_caption', '1');
        update_option('wseo_auto_description', '1');
    }
    
    /**
     * Show activation notice
     */
    public function activation_notice() {
        // Check if just activated
        $posts_updated = get_option('wseo_activation_posts_updated');
        if ($posts_updated !== false && !get_option('wseo_activation_notice_dismissed')) {
            $count = intval($posts_updated / 2); // Divided by 2 because we update 2 meta fields per post
            ?>
            <div class="notice notice-success is-dismissible">
                <p>
                    <strong>✅ Webstudio SEO Pro aktivovaný!</strong><br>
                    Čas čítania a TOC boli automaticky zapnuté pre <strong><?php echo $count; ?> existujúcich článkov</strong>.
                </p>
            </div>
            <?php
            // Dismiss after showing once
            update_option('wseo_activation_notice_dismissed', true);
        }
    }
    
    /**
     * Plugin activation
     */
    public function activate() {
        // Set default options
        if (!get_option('wseo_global_site_name')) {
            update_option('wseo_global_site_name', get_bloginfo('name'));
        }
        flush_rewrite_rules();
    }
    
    /**
     * Add theme support for title tag
     */
    public function add_title_tag_support() {
        if (!current_theme_supports('title-tag')) {
            add_theme_support('title-tag');
        }
    }
    
    /**
     * Admin menu
     */
    public function add_admin_menu() {
        add_menu_page(
            'Webstudio SEO Pro',
            'SEO Pro',
            'manage_options',
            'webstudio-seo',
            array($this, 'render_seo_dashboard_page'), // v3.2: Changed to SEO Dashboard
            'dashicons-search',
            80
        );
        
        // v3.2: SEO Dashboard - first submenu item (replaces default)
        add_submenu_page(
            'webstudio-seo',
            'SEO Dashboard',
            'SEO Dashboard',
            'manage_options',
            'webstudio-seo',  // Same slug as parent = first item
            array($this, 'render_seo_dashboard_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Globálne nastavenia',
            'Globálne nastavenia',
            'manage_options',
            'webstudio-seo-global',
            array($this, 'render_global_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Indexácia',
            'Indexácia',
            'manage_options',
            'webstudio-seo-files',
            array($this, 'render_files_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Presmerovania',
            'Presmerovania',
            'manage_options',
            'webstudio-seo-redirects',
            array($this, 'render_redirects_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Interné odkazy',
            'Interné odkazy',
            'manage_options',
            'webstudio-seo-links',
            array($this, 'render_internal_links_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Obrázky',
            'Obrázky',
            'manage_options',
            'webstudio-seo-images',
            array($this, 'render_images_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'WordPress Doctor',
            'WordPress Doctor',
            'manage_options',
            'webstudio-seo-maintenance',
            array($this, 'render_maintenance_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Performance Monitor',
            'Performance',
            'manage_options',
            'webstudio-seo-performance',
            array($this, 'render_performance_page')
        );
        
        // v2.10.0: Marketing section
        add_submenu_page(
            'webstudio-seo',
            'Marketing',
            'Marketing',
            'manage_options',
            'webstudio-seo-marketing',
            array($this, 'render_marketing_page')
        );
        
        add_submenu_page(
            'webstudio-seo',
            'Licencia',
            'Licencia',
            'manage_options',
            'webstudio-seo-license',
            array($this, 'render_license_page')
        );
    }
    
    /**
     * Enqueue admin assets
     */
    public function enqueue_admin_assets($hook) {
        // Load on plugin pages, post editor, and post list pages
        $load_on = array(
            'post.php', 
            'post-new.php', 
            'edit.php'
        );
        
        $is_plugin_page = strpos($hook, 'webstudio-seo') !== false;
        $is_edit_page = in_array($hook, $load_on);
        
        if (!$is_plugin_page && !$is_edit_page) {
            return;
        }
        
        wp_enqueue_style('wseo-admin', WSEO_PLUGIN_URL . 'assets/admin.css', array(), WSEO_VERSION);
        wp_enqueue_script('wseo-admin', WSEO_PLUGIN_URL . 'assets/admin.js', array('jquery'), WSEO_VERSION, true);
        
        wp_localize_script('wseo-admin', 'wseoData', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('wseo_nonce'),
            'siteName' => get_option('wseo_global_site_name', get_bloginfo('name'))
        ));
    }
    
    /**
     * Add meta boxes
     */
    public function add_meta_boxes() {
        $post_types = array('post', 'page', 'product');
        
        foreach ($post_types as $post_type) {
            add_meta_box(
                'wseo_meta_box',
                '🔍 Webstudio SEO Pro',
                array($this, 'render_meta_box'),
                $post_type,
                'normal',
                'high'
            );
        }
    }
    
    /**
     * Render meta box
     */
    public function render_meta_box($post) {
        wp_nonce_field('wseo_meta_box', 'wseo_meta_box_nonce');
        
        // Get saved meta
        $meta_title = get_post_meta($post->ID, '_wseo_meta_title', true);
        $meta_description = get_post_meta($post->ID, '_wseo_meta_description', true);
        $meta_keywords = get_post_meta($post->ID, '_wseo_meta_keywords', true);
        $og_image = get_post_meta($post->ID, '_wseo_og_image', true);
        $noindex = get_post_meta($post->ID, '_wseo_noindex', true);
        $nofollow = get_post_meta($post->ID, '_wseo_nofollow', true);
        $canonical = get_post_meta($post->ID, '_wseo_canonical', true);
        
        // Site name
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        
        // v2.10.12: Auto-generate placeholder values
        $auto_title = !empty($post->post_title) ? $post->post_title : '';
        $auto_description = '';
        $auto_keywords = $this->auto_extract_keywords($post->post_title, $post);
        
        if ($post->post_status !== 'auto-draft') {
            $content = $this->get_post_content($post->ID);
            if (!empty($content)) {
                $auto_description = $this->generate_meta_description($content);
            }
        }
        
        // Get featured image for OG preview
        $featured_image = get_the_post_thumbnail_url($post->ID, 'large');
        $display_og_image = !empty($og_image) ? $og_image : $featured_image;
        
        include WSEO_PLUGIN_DIR . 'templates/meta-box.php';
    }
    
    /**
     * Save meta boxes
     */
    public function save_meta_boxes($post_id, $post) {
        if (!isset($_POST['wseo_meta_box_nonce']) || 
            !wp_verify_nonce($_POST['wseo_meta_box_nonce'], 'wseo_meta_box')) {
            return;
        }
        
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        
        // Get posted values
        $meta_title = isset($_POST['wseo_meta_title']) ? sanitize_text_field($_POST['wseo_meta_title']) : '';
        $meta_description = isset($_POST['wseo_meta_description']) ? sanitize_textarea_field($_POST['wseo_meta_description']) : '';
        $meta_keywords = isset($_POST['wseo_meta_keywords']) ? sanitize_text_field($_POST['wseo_meta_keywords']) : '';
        $og_image = isset($_POST['wseo_og_image']) ? esc_url_raw($_POST['wseo_og_image']) : '';
        $noindex = isset($_POST['wseo_noindex']) ? '1' : '';
        $nofollow = isset($_POST['wseo_nofollow']) ? '1' : '';
        $canonical = isset($_POST['wseo_canonical']) ? esc_url_raw($_POST['wseo_canonical']) : '';
        
        // Auto-generate if empty
        if (empty($meta_title) && !empty($post->post_title)) {
            $meta_title = $this->generate_meta_title($post->post_title, $post->post_type);
        }
        
        if (empty($meta_description)) {
            $content = $this->get_post_content($post_id);
            if (!empty($content)) {
                $meta_description = $this->generate_meta_description($content);
            }
        }
        
        // v2.9.14: Focus keyword is manual-only (no auto-generation)
        // Used for internal SEO Audit analysis only, not output to HTML
        
        // Save all fields
        update_post_meta($post_id, '_wseo_meta_title', $meta_title);
        update_post_meta($post_id, '_wseo_meta_description', $meta_description);
        update_post_meta($post_id, '_wseo_meta_keywords', $meta_keywords); // Now "Focus Keyword"
        update_post_meta($post_id, '_wseo_og_image', $og_image);
        update_post_meta($post_id, '_wseo_noindex', $noindex);
        update_post_meta($post_id, '_wseo_nofollow', $nofollow);
        update_post_meta($post_id, '_wseo_canonical', $canonical);
        
        // Save hero image (v2.4.2)
        $hero_image = isset($_POST['wseo_hero_image']) ? esc_url_raw($_POST['wseo_hero_image']) : '';
        update_post_meta($post_id, '_wseo_hero_image', $hero_image);
        
        // Save redirect fields
        $redirect_url = isset($_POST['wseo_redirect_url']) ? esc_url_raw($_POST['wseo_redirect_url']) : '';
        $redirect_type = isset($_POST['wseo_redirect_type']) ? sanitize_text_field($_POST['wseo_redirect_type']) : '301';
        update_post_meta($post_id, '_wseo_redirect_url', $redirect_url);
        update_post_meta($post_id, '_wseo_redirect_type', $redirect_type);
        
        // Save FAQ items
        if (isset($_POST['wseo_faq']) && is_array($_POST['wseo_faq'])) {
            $faq_items = array();
            foreach ($_POST['wseo_faq'] as $faq) {
                if (!empty($faq['question']) && !empty($faq['answer'])) {
                    $faq_items[] = array(
                        'question' => sanitize_text_field($faq['question']),
                        'answer' => sanitize_textarea_field($faq['answer'])
                    );
                }
            }
            update_post_meta($post_id, '_wseo_faq_items', $faq_items);
        } else {
            update_post_meta($post_id, '_wseo_faq_items', array());
        }
        
        // Save E-E-A-T Author fields
        update_post_meta($post_id, '_wseo_author_name', sanitize_text_field($_POST['wseo_author_name'] ?? ''));
        update_post_meta($post_id, '_wseo_author_title', sanitize_text_field($_POST['wseo_author_title'] ?? ''));
        update_post_meta($post_id, '_wseo_author_url', esc_url_raw($_POST['wseo_author_url'] ?? ''));
        update_post_meta($post_id, '_wseo_author_social', sanitize_textarea_field($_POST['wseo_author_social'] ?? ''));
        
        // Save AI Content Marking (2026)
        update_post_meta($post_id, '_wseo_ai_generated', isset($_POST['wseo_ai_generated']) ? '1' : '0');
        update_post_meta($post_id, '_wseo_ai_source', sanitize_text_field($_POST['wseo_ai_source'] ?? ''));
        update_post_meta($post_id, '_wseo_image_ai_generated', isset($_POST['wseo_image_ai_generated']) ? '1' : '0');
        
        // Save Image Metadata (Search Console required fields + optional fields)
        update_post_meta($post_id, '_wseo_image_credit', sanitize_text_field($_POST['wseo_image_credit'] ?? ''));
        update_post_meta($post_id, '_wseo_image_license', esc_url_raw($_POST['wseo_image_license'] ?? ''));
        update_post_meta($post_id, '_wseo_image_license_page', esc_url_raw($_POST['wseo_image_license_page'] ?? ''));
        update_post_meta($post_id, '_wseo_image_creator', sanitize_text_field($_POST['wseo_image_creator'] ?? ''));
        update_post_meta($post_id, '_wseo_image_copyright_notice', sanitize_text_field($_POST['wseo_image_copyright_notice'] ?? ''));
        
        // Save Article Type (2026)
        update_post_meta($post_id, '_wseo_article_type', sanitize_text_field($_POST['wseo_article_type'] ?? ''));
        
        // Save SoftwareApplication Schema (2026)
        update_post_meta($post_id, '_wseo_is_software', isset($_POST['wseo_is_software']) ? '1' : '0');
        update_post_meta($post_id, '_wseo_software_name', sanitize_text_field($_POST['wseo_software_name'] ?? ''));
        update_post_meta($post_id, '_wseo_software_version', sanitize_text_field($_POST['wseo_software_version'] ?? ''));
        update_post_meta($post_id, '_wseo_software_price', sanitize_text_field($_POST['wseo_software_price'] ?? ''));
        update_post_meta($post_id, '_wseo_software_currency', sanitize_text_field($_POST['wseo_software_currency'] ?? 'EUR'));
        update_post_meta($post_id, '_wseo_software_os', sanitize_text_field($_POST['wseo_software_os'] ?? ''));
        update_post_meta($post_id, '_wseo_software_category', sanitize_text_field($_POST['wseo_software_category'] ?? ''));
        update_post_meta($post_id, '_wseo_software_download', esc_url_raw($_POST['wseo_software_download'] ?? ''));
        update_post_meta($post_id, '_wseo_software_rating', sanitize_text_field($_POST['wseo_software_rating'] ?? ''));
        update_post_meta($post_id, '_wseo_software_review_count', sanitize_text_field($_POST['wseo_software_review_count'] ?? ''));
        
        // Save Hreflang entries
        if (isset($_POST['wseo_hreflang']) && is_array($_POST['wseo_hreflang'])) {
            $hreflang_entries = array();
            foreach ($_POST['wseo_hreflang'] as $entry) {
                if (!empty($entry['lang']) && !empty($entry['url'])) {
                    $hreflang_entries[] = array(
                        'lang' => sanitize_text_field($entry['lang']),
                        'url' => esc_url_raw($entry['url'])
                    );
                }
            }
            update_post_meta($post_id, '_wseo_hreflang', $hreflang_entries);
        } else {
            update_post_meta($post_id, '_wseo_hreflang', array());
        }
        
        // Save Reading Time & TOC options
        update_post_meta($post_id, '_wseo_show_reading_time', isset($_POST['wseo_show_reading_time']) ? '1' : '0');
        update_post_meta($post_id, '_wseo_show_toc', isset($_POST['wseo_show_toc']) ? '1' : '0');
        
        // v2.9.15: Self-serving Review Schema REMOVED - Google banned since 2019
        // The review fields were removed as they violate Google's guidelines
        
        // Save page-specific Schema.org fields
        if ($post->post_type === 'page') {
            update_post_meta($post_id, '_wseo_schema_type', sanitize_text_field($_POST['wseo_schema_type'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_name', sanitize_text_field($_POST['wseo_schema_name'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_description', sanitize_textarea_field($_POST['wseo_schema_description'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_phone', sanitize_text_field($_POST['wseo_schema_phone'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_email', sanitize_email($_POST['wseo_schema_email'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_address', sanitize_text_field($_POST['wseo_schema_address'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_city', sanitize_text_field($_POST['wseo_schema_city'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_zip', sanitize_text_field($_POST['wseo_schema_zip'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_country', sanitize_text_field($_POST['wseo_schema_country'] ?? 'SK'));
            update_post_meta($post_id, '_wseo_schema_lat', sanitize_text_field($_POST['wseo_schema_lat'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_lng', sanitize_text_field($_POST['wseo_schema_lng'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_image', esc_url_raw($_POST['wseo_schema_image'] ?? ''));
            update_post_meta($post_id, '_wseo_schema_price_range', sanitize_text_field($_POST['wseo_schema_price_range'] ?? ''));
            
            // v2.9.12: Opening hours by day (Google compliant)
            $days = array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun');
            foreach ($days as $day) {
                update_post_meta($post_id, "_wseo_schema_hours_{$day}_open", sanitize_text_field($_POST["wseo_schema_hours_{$day}_open"] ?? ''));
                update_post_meta($post_id, "_wseo_schema_hours_{$day}_close", sanitize_text_field($_POST["wseo_schema_hours_{$day}_close"] ?? ''));
            }
        }
    }
    
    /**
     * Filter document title
     */
    public function filter_document_title($title) {
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $separator = get_option('wseo_title_separator', ' - ');
        
        // v2.9.13: Ensure separator has spaces around it
        $separator = ' ' . trim($separator) . ' ';
        
        if (is_singular()) {
            global $post;
            $meta_title = get_post_meta($post->ID, '_wseo_meta_title', true);
            if ($meta_title) {
                // v2.9.13: Add site name suffix to custom meta title
                return $meta_title . $separator . $site_name;
            }
        } elseif (is_home() || is_front_page()) {
            $home_title = get_option('wseo_global_home_title', '');
            if ($home_title) {
                // Home title is typically complete, don't add suffix
                return $home_title;
            }
        }
        
        // Default: add suffix to whatever title WordPress generates
        if ($title && $site_name && strpos($title, $site_name) === false) {
            return $title . $separator . $site_name;
        }
        
        return $title;
    }
    
    /**
     * Filter wp_title
     */
    public function filter_wp_title($title, $sep, $seplocation) {
        return $this->filter_document_title($title);
    }
    
    /**
     * Output meta tags
     */
    public function output_meta_tags() {
        // v2.10.13: Force noindex for URLs with cart/filter/tracking parameters
        $blocked_params = array('add-to-cart', 'orderby', 'filter', 'utm_', 'fbclid', 'gclid', 'mc_', 'ref');
        $query_string = isset($_SERVER['QUERY_STRING']) ? $_SERVER['QUERY_STRING'] : '';
        $force_noindex = false;
        
        if (!empty($query_string)) {
            foreach ($blocked_params as $param) {
                if (strpos($query_string, $param) !== false) {
                    $force_noindex = true;
                    break;
                }
            }
        }
        
        // Also noindex random spam parameters (short random strings)
        if (!empty($query_string) && preg_match('/^\?[a-z]{4}\d{3}/', '?' . $query_string)) {
            $force_noindex = true;
        }
        
        if ($force_noindex) {
            echo '<meta name="robots" content="noindex, nofollow">' . "\n";
            // Still output canonical to clean URL
            $clean_url = strtok($_SERVER['REQUEST_URI'], '?');
            echo '<link rel="canonical" href="' . esc_url(home_url($clean_url)) . '">' . "\n";
            return; // Don't output other SEO meta for these URLs
        }
        
        // Webmaster verification meta tags
        $this->output_verification_tags();
        
        // Google Analytics / GTM
        $this->output_analytics();
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $global_og_image = get_option('wseo_global_og_image', '');
        $twitter_handle = get_option('wseo_global_twitter_handle', '');
        $fb_app_id = get_option('wseo_global_fb_app_id', '');
        
        if (is_singular()) {
            global $post;
            
            // v2.9.9: Check if this is the front page - use global settings as fallback
            $is_static_front_page = is_front_page() && get_option('show_on_front') === 'page';
            
            $meta_title = get_post_meta($post->ID, '_wseo_meta_title', true);
            $meta_description = get_post_meta($post->ID, '_wseo_meta_description', true);
            $meta_keywords = get_post_meta($post->ID, '_wseo_meta_keywords', true);
            $og_image = get_post_meta($post->ID, '_wseo_og_image', true);
            $noindex = get_post_meta($post->ID, '_wseo_noindex', true);
            $nofollow = get_post_meta($post->ID, '_wseo_nofollow', true);
            $canonical = get_post_meta($post->ID, '_wseo_canonical', true);
            
            // v2.9.9: For static front page, use global home settings as PRIMARY fallback
            if ($is_static_front_page) {
                if (!$meta_title) {
                    $meta_title = get_option('wseo_global_home_title', '');
                }
                if (!$meta_description) {
                    $meta_description = get_option('wseo_global_home_description', '');
                }
            }
            
            // Fallbacks
            if (!$meta_title) {
                $meta_title = get_the_title($post->ID) . ' - ' . $site_name;
            }
            if (!$meta_description) {
                // v2.9.9: For front page, final fallback is site tagline
                if ($is_static_front_page) {
                    $meta_description = get_bloginfo('description');
                }
                // For WooCommerce products, try to generate from excerpt or content
                elseif ($post->post_type === 'product') {
                    // Try short description first
                    if (!empty($post->post_excerpt)) {
                        $desc = do_shortcode($post->post_excerpt);
                        $desc = wp_strip_all_tags($desc);
                        $desc = preg_replace('/\s+/', ' ', $desc);
                        $desc = trim($desc);
                        
                        if (!empty($desc) && strlen($desc) >= 10) {
                            // Truncate to 155 chars
                            if (mb_strlen($desc) > 155) {
                                $desc = mb_substr($desc, 0, 152);
                                $last_space = mb_strrpos($desc, ' ');
                                if ($last_space > 50) {
                                    $desc = mb_substr($desc, 0, $last_space);
                                }
                                $desc .= '...';
                            }
                            $meta_description = $desc;
                        }
                    }
                    
                    // If still empty, try long description
                    if (empty($meta_description) && !empty($post->post_content)) {
                        $desc = do_shortcode($post->post_content);
                        $desc = wp_strip_all_tags($desc);
                        $desc = preg_replace('/\s+/', ' ', $desc);
                        $desc = trim($desc);
                        
                        if (!empty($desc) && strlen($desc) >= 10) {
                            if (mb_strlen($desc) > 155) {
                                $desc = mb_substr($desc, 0, 152);
                                $last_space = mb_strrpos($desc, ' ');
                                if ($last_space > 50) {
                                    $desc = mb_substr($desc, 0, $last_space);
                                }
                                $desc .= '...';
                            }
                            $meta_description = $desc;
                        }
                    }
                    
                    // Final fallback: Title + Category
                    if (empty($meta_description)) {
                        $meta_description = get_the_title($post->ID);
                        $categories = get_the_terms($post->ID, 'product_cat');
                        if (!empty($categories) && !is_wp_error($categories)) {
                            $cat_names = array();
                            foreach ($categories as $cat) {
                                $cat_names[] = $cat->name;
                            }
                            $meta_description .= ' - ' . implode(', ', $cat_names);
                        }
                    }
                } else {
                    // For other post types (pages, posts), use standard fallback
                    // v2.9.9: Strip shortcodes BEFORE strip_tags to avoid [shortcode] in meta
                    $content = $post->post_content;
                    
                    // Remove all shortcodes first
                    $content = preg_replace('/\[[^\]]*\]/', '', $content);
                    
                    // Strip HTML tags
                    $content = wp_strip_all_tags($content);
                    
                    // Normalize whitespace
                    $content = preg_replace('/\s+/', ' ', $content);
                    $content = trim($content);
                    
                    // Generate description if we have content
                    if (!empty($content) && strlen($content) >= 10) {
                        if (mb_strlen($content) > 155) {
                            $content = mb_substr($content, 0, 152);
                            $last_space = mb_strrpos($content, ' ');
                            if ($last_space > 50) {
                                $content = mb_substr($content, 0, $last_space);
                            }
                            $content .= '...';
                        }
                        $meta_description = $content;
                    } else {
                        // Final fallback to title + tagline
                        $meta_description = get_the_title($post->ID);
                        $tagline = get_bloginfo('description');
                        if ($tagline) {
                            $meta_description .= ' - ' . $tagline;
                        }
                    }
                }
            }
            if (!$og_image) {
                $og_image = get_the_post_thumbnail_url($post->ID, 'large');
            }
            if (!$og_image) {
                $og_image = $global_og_image;
            }
            
            // Robots
            $robots = array();
            if ($noindex) $robots[] = 'noindex';
            if ($nofollow) $robots[] = 'nofollow';
            if (!empty($robots)) {
                echo '<meta name="robots" content="' . esc_attr(implode(', ', $robots)) . '">' . "\n";
            }
            
            // Canonical - always output (manual or auto-generated)
            if ($canonical) {
                echo '<link rel="canonical" href="' . esc_url($canonical) . '">' . "\n";
            } else {
                // v2.10.14: Auto-generate canonical to clean permalink
                echo '<link rel="canonical" href="' . esc_url(get_permalink($post->ID)) . '">' . "\n";
            }
            
            // Description
            if ($meta_description) {
                echo '<meta name="description" content="' . esc_attr($meta_description) . '">' . "\n";
            }
            
            // Meta keywords - output if set (manual or auto-extracted)
            if (!empty($meta_keywords)) {
                echo '<meta name="keywords" content="' . esc_attr($meta_keywords) . '">' . "\n";
            } else {
                // Auto-extract keywords from title if not manually set
                $auto_keywords = $this->auto_extract_keywords(get_the_title($post->ID), $post);
                if (!empty($auto_keywords)) {
                    echo '<meta name="keywords" content="' . esc_attr($auto_keywords) . '">' . "\n";
                }
            }
            
            // Open Graph
            echo '<meta property="og:title" content="' . esc_attr($meta_title) . '">' . "\n";
            echo '<meta property="og:description" content="' . esc_attr($meta_description) . '">' . "\n";
            echo '<meta property="og:url" content="' . esc_url(get_permalink()) . '">' . "\n";
            echo '<meta property="og:site_name" content="' . esc_attr($site_name) . '">' . "\n";
            echo '<meta property="og:type" content="' . (is_single() ? 'article' : 'website') . '">' . "\n";
            
            if ($og_image) {
                echo '<meta property="og:image" content="' . esc_url($og_image) . '">' . "\n";
                echo '<meta property="og:image:width" content="1200">' . "\n";
                echo '<meta property="og:image:height" content="630">' . "\n";
            }
            
            // Facebook App ID
            if ($fb_app_id) {
                echo '<meta property="fb:app_id" content="' . esc_attr($fb_app_id) . '">' . "\n";
            }
            
            // Twitter Card
            echo '<meta name="twitter:card" content="summary_large_image">' . "\n";
            echo '<meta name="twitter:title" content="' . esc_attr($meta_title) . '">' . "\n";
            echo '<meta name="twitter:description" content="' . esc_attr($meta_description) . '">' . "\n";
            if ($og_image) {
                echo '<meta name="twitter:image" content="' . esc_url($og_image) . '">' . "\n";
            }
            if ($twitter_handle) {
                echo '<meta name="twitter:site" content="@' . esc_attr(ltrim($twitter_handle, '@')) . '">' . "\n";
            }
            
            // Hreflang tags
            $hreflang_entries = get_post_meta($post->ID, '_wseo_hreflang', true);
            if (!empty($hreflang_entries) && is_array($hreflang_entries)) {
                foreach ($hreflang_entries as $entry) {
                    if (!empty($entry['lang']) && !empty($entry['url'])) {
                        echo '<link rel="alternate" hreflang="' . esc_attr($entry['lang']) . '" href="' . esc_url($entry['url']) . '">' . "\n";
                    }
                }
                // Add self-referencing hreflang
                $current_lang = substr(get_locale(), 0, 2);
                echo '<link rel="alternate" hreflang="' . esc_attr($current_lang) . '" href="' . esc_url(get_permalink($post->ID)) . '">' . "\n";
            }
            
            // FAQ Schema - Manual or Auto-detected
            $faq_items = get_post_meta($post->ID, '_wseo_faq_items', true);
            
            // v3.2: Auto-detect FAQ from content if enabled and no manual FAQ
            if ((empty($faq_items) || !is_array($faq_items) || count($faq_items) === 0) && get_option('wseo_faq_autodetect', '1') === '1') {
                $faq_items = $this->auto_detect_faq_from_content($post->post_content);
            }
            
            if (!empty($faq_items) && is_array($faq_items)) {
                $this->output_faq_schema($faq_items);
            }
            
            // Article specific
            if (is_single() && get_post_type() === 'post') {
                echo '<meta property="article:published_time" content="' . get_the_date('c') . '">' . "\n";
                echo '<meta property="article:modified_time" content="' . get_the_modified_date('c') . '">' . "\n";
            }
            
        } elseif (is_category() || is_tag() || is_tax('product_cat') || is_tax('product_tag')) {
            // Taxonomy archives (categories, tags)
            $term = get_queried_object();
            
            if ($term && isset($term->term_id)) {
                $term_title = get_term_meta($term->term_id, '_wseo_term_title', true);
                $term_description = get_term_meta($term->term_id, '_wseo_term_description', true);
                $term_noindex = get_term_meta($term->term_id, '_wseo_term_noindex', true);
                
                // Fallbacks
                if (!$term_title) {
                    $term_title = $term->name . ' - ' . $site_name;
                }
                if (!$term_description) {
                    $term_description = $term->description ?: sprintf('Archív pre %s', $term->name);
                }
                
                // Robots
                if ($term_noindex) {
                    echo '<meta name="robots" content="noindex, follow">' . "\n";
                }
                
                // v2.10.14: Always output canonical for archives (use page 1 URL)
                $canonical_url = get_term_link($term);
                echo '<link rel="canonical" href="' . esc_url($canonical_url) . '">' . "\n";
                
                // Description
                echo '<meta name="description" content="' . esc_attr($term_description) . '">' . "\n";
                
                // Open Graph
                echo '<meta property="og:title" content="' . esc_attr($term_title) . '">' . "\n";
                echo '<meta property="og:description" content="' . esc_attr($term_description) . '">' . "\n";
                echo '<meta property="og:url" content="' . esc_url(get_term_link($term)) . '">' . "\n";
                echo '<meta property="og:site_name" content="' . esc_attr($site_name) . '">' . "\n";
                echo '<meta property="og:type" content="website">' . "\n";
                
                if ($global_og_image) {
                    echo '<meta property="og:image" content="' . esc_url($global_og_image) . '">' . "\n";
                }
                
                // Twitter Card
                echo '<meta name="twitter:card" content="summary_large_image">' . "\n";
                echo '<meta name="twitter:title" content="' . esc_attr($term_title) . '">' . "\n";
                echo '<meta name="twitter:description" content="' . esc_attr($term_description) . '">' . "\n";
            }
            
        } else {
            // Homepage
            $home_title = get_option('wseo_global_home_title', $site_name);
            $home_description = get_option('wseo_global_home_description', get_bloginfo('description'));
            $home_keywords = get_option('wseo_global_home_keywords', '');
            
            // v2.10.14: Canonical for homepage
            echo '<link rel="canonical" href="' . esc_url(home_url('/')) . '">' . "\n";
            
            echo '<meta name="description" content="' . esc_attr($home_description) . '">' . "\n";
            
            // v2.12.0: Meta keywords for homepage
            if (!empty($home_keywords)) {
                echo '<meta name="keywords" content="' . esc_attr($home_keywords) . '">' . "\n";
            } else {
                // Auto-generate from title
                $auto_keywords = $this->auto_extract_keywords($home_title);
                if (!empty($auto_keywords)) {
                    echo '<meta name="keywords" content="' . esc_attr($auto_keywords) . '">' . "\n";
                }
            }
            
            echo '<meta property="og:title" content="' . esc_attr($home_title) . '">' . "\n";
            echo '<meta property="og:description" content="' . esc_attr($home_description) . '">' . "\n";
            echo '<meta property="og:url" content="' . esc_url(home_url('/')) . '">' . "\n";
            echo '<meta property="og:site_name" content="' . esc_attr($site_name) . '">' . "\n";
            echo '<meta property="og:type" content="website">' . "\n";
            
            if ($global_og_image) {
                echo '<meta property="og:image" content="' . esc_url($global_og_image) . '">' . "\n";
            }
            
            echo '<meta name="twitter:card" content="summary_large_image">' . "\n";
            echo '<meta name="twitter:title" content="' . esc_attr($home_title) . '">' . "\n";
            echo '<meta name="twitter:description" content="' . esc_attr($home_description) . '">' . "\n";
        }
        
        // Output Schema.org JSON-LD
        $this->output_schema_jsonld();
    }
    
    /**
     * Send Last-Modified header for better crawl efficiency (v2.8.6 - ENHANCED)
     * 
     * Helps Google and other crawlers determine when to re-crawl pages.
     * Enables 304 Not Modified responses for unchanged content.
     * Improves browser caching efficiency.
     * 
     * ENHANCEMENTS in v2.8.6:
     * - Hook changed from 'send_headers' to 'template_redirect' (priority 1)
     * - Added headers_sent() check to prevent "headers already sent" errors
     * - Added debug logging when WP_DEBUG is enabled
     * - Executes BEFORE cache plugins can interfere
     */
    public function send_last_modified_header() {
        // Check if headers were already sent
        if (headers_sent()) {
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('WSEO v2.8.6: Cannot send Last-Modified - headers already sent');
            }
            return;
        }
        
        // v2.9.9: Skip on WooCommerce AJAX/checkout - prevents order processing failures
        if (defined('DOING_AJAX') && DOING_AJAX) {
            return;
        }
        
        if (defined('WOOCOMMERCE_CHECKOUT')) {
            return;
        }
        
        // Skip WooCommerce cart/checkout pages
        if (function_exists('is_checkout') && (is_checkout() || is_cart())) {
            return;
        }
        
        // Only for singular pages (posts, pages, products)
        if (!is_singular()) {
            return;
        }
        
        global $post;
        
        // Get post modified time in GMT
        $modified_time = get_post_modified_time('U', true, $post);
        
        if (!$modified_time) {
            return;
        }
        
        // Format: "Thu, 23 Jan 2026 22:30:00 GMT"
        $last_modified = gmdate('D, d M Y H:i:s', $modified_time) . ' GMT';
        
        // Send Last-Modified header
        @header('Last-Modified: ' . $last_modified);
        
        // Debug logging
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log(sprintf(
                'WSEO v2.8.8: Last-Modified header sent for post ID %d: %s',
                $post->ID,
                $last_modified
            ));
        }
        
        // Handle If-Modified-Since request (304 Not Modified)
        if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
            $if_modified_since = strtotime(stripslashes($_SERVER['HTTP_IF_MODIFIED_SINCE']));
            
            // If content hasn't been modified, send 304
            if ($if_modified_since >= $modified_time) {
                header('HTTP/1.1 304 Not Modified');
                exit;
            }
        }
    }
    
    /**
     * Auto-clear ALL cache when content is saved (v2.8.6)
     * Ensures fresh content is immediately visible
     * 
     * Clears:
     * - WordPress object cache
     * - WordPress transients
     * - WP Super Cache
     * - W3 Total Cache
     * - WP Rocket
     * - LiteSpeed Cache
     * - WP Fastest Cache
     * - Autoptimize
     * - SG Optimizer
     * 
     * @param int $post_id Post ID
     * @param WP_Post $post Post object
     * @param bool $update Whether this is an update
     */
    public function auto_clear_cache_on_save($post_id, $post, $update) {
        // Skip autosave and revisions
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        
        if (wp_is_post_revision($post_id)) {
            return;
        }
        
        // Only clear cache for published posts/pages/products
        if ($post->post_status !== 'publish') {
            return;
        }
        
        // v2.9.9: Skip WooCommerce orders/subscriptions - purging cache breaks checkout!
        $skip_post_types = array(
            'shop_order',           // WooCommerce orders
            'shop_order_refund',    // WooCommerce refunds
            'shop_subscription',    // WooCommerce subscriptions
            'scheduled-action',     // Action Scheduler
            'edd_payment',          // Easy Digital Downloads
            'edd_discount',         // EDD discounts
            'revision',             // Revisions
            'nav_menu_item',        // Menu items
            'custom_css',           // Custom CSS
            'customize_changeset',  // Customizer
            'oembed_cache',         // oEmbed cache
            'user_request',         // GDPR requests
            'wp_block',             // Reusable blocks
            'wp_template',          // Block templates
            'wp_template_part',     // Block template parts
            'wp_global_styles',     // Global styles
        );
        
        if (in_array($post->post_type, $skip_post_types, true)) {
            return;
        }
        
        // v2.9.9: Skip if WooCommerce checkout is processing
        if (defined('WOOCOMMERCE_CHECKOUT') || 
            (function_exists('WC') && WC()->session && WC()->session->get('order_awaiting_payment'))) {
            return;
        }
        
        // Clear WordPress object cache (but NOT during checkout)
        if (!defined('WOOCOMMERCE_CHECKOUT')) {
            wp_cache_flush();
        }
        
        // Clear WordPress transients related to this post
        delete_transient('wseo_post_' . $post_id);
        
        // Get post URL for cache clearing
        $post_url = get_permalink($post_id);
        
        // v2.9.9: Build list of URLs to purge (post + homepage + categories + feeds)
        $urls_to_purge = array(
            $post_url,
            home_url('/'),                    // Homepage
            home_url('/feed/'),               // RSS Feed
            home_url('/sitemap.xml'),         // Sitemap
        );
        
        // Add category URLs if post has categories
        $categories = get_the_category($post_id);
        if ($categories) {
            foreach ($categories as $cat) {
                $urls_to_purge[] = get_category_link($cat->term_id);
            }
        }
        
        // Add tag URLs if post has tags
        $tags = get_the_tags($post_id);
        if ($tags) {
            foreach ($tags as $tag) {
                $urls_to_purge[] = get_tag_link($tag->term_id);
            }
        }
        
        // Add author archive
        $urls_to_purge[] = get_author_posts_url($post->post_author);
        
        // Add date archive
        $urls_to_purge[] = get_day_link(get_the_date('Y', $post_id), get_the_date('m', $post_id), get_the_date('d', $post_id));
        $urls_to_purge[] = get_month_link(get_the_date('Y', $post_id), get_the_date('m', $post_id));
        $urls_to_purge[] = get_year_link(get_the_date('Y', $post_id));
        
        // ===================================================================
        // WORDPRESS NATIVE CACHE
        // ===================================================================
        
        // Clear post meta cache
        clean_post_cache($post_id);
        
        // v2.9.9: Clear front page cache if it's set to show latest posts
        $show_on_front = get_option('show_on_front');
        if ($show_on_front === 'posts') {
            // Blog is homepage - clear it
            wp_cache_delete('front_page_posts', 'posts');
        } else {
            // Static front page - clear that page's cache
            $front_page_id = get_option('page_on_front');
            if ($front_page_id) {
                clean_post_cache($front_page_id);
            }
            // Also clear blog page if set
            $blog_page_id = get_option('page_for_posts');
            if ($blog_page_id) {
                clean_post_cache($blog_page_id);
            }
        }
        
        // ===================================================================
        // POPULAR CACHE PLUGINS INTEGRATION
        // ===================================================================
        
        // WP Super Cache
        if (function_exists('wp_cache_clear_cache')) {
            wp_cache_clear_cache();
        }
        
        // W3 Total Cache
        if (function_exists('w3tc_flush_all')) {
            w3tc_flush_all();
        } elseif (function_exists('w3tc_pgcache_flush')) {
            w3tc_pgcache_flush();
        }
        
        // WP Rocket
        if (function_exists('rocket_clean_post')) {
            rocket_clean_post($post_id);
        }
        if (function_exists('rocket_clean_domain')) {
            rocket_clean_domain();
        }
        
        // LiteSpeed Cache
        if (class_exists('LiteSpeed_Cache_API')) {
            LiteSpeed_Cache_API::purge_all();
        } elseif (method_exists('LiteSpeed_Cache_Purge', 'purge_post')) {
            LiteSpeed_Cache_Purge::purge_post($post_id);
        }
        
        // WP Fastest Cache
        if (function_exists('wpfc_clear_all_cache')) {
            wpfc_clear_all_cache(true);
        } elseif (isset($GLOBALS['wp_fastest_cache']) && method_exists($GLOBALS['wp_fastest_cache'], 'deleteCache')) {
            $GLOBALS['wp_fastest_cache']->deleteCache();
        }
        
        // Autoptimize
        if (class_exists('autoptimizeCache')) {
            autoptimizeCache::clearall();
        }
        
        // SG Optimizer (SiteGround)
        if (function_exists('sg_cachepress_purge_cache')) {
            sg_cachepress_purge_cache($post_url);
        }
        
        // Cache Enabler
        if (class_exists('Cache_Enabler')) {
            Cache_Enabler::clear_complete_cache();
        }
        
        // Comet Cache
        if (class_exists('comet_cache')) {
            comet_cache::clear();
        }
        
        // ===================================================================
        // HOSTING PROVIDER CACHE
        // ===================================================================
        
        // Cloudflare (if using official plugin)
        if (class_exists('CF\WordPress\Hooks')) {
            $cf_plugin = new CF\WordPress\Hooks();
            if (method_exists($cf_plugin, 'purgeCacheEverything')) {
                $cf_plugin->purgeCacheEverything();
            }
        }
        
        // Kinsta Cache
        if (class_exists('Kinsta\Cache')) {
            Kinsta\Cache::clear_kinsta_cache();
        }
        
        // WP Engine
        if (class_exists('WpeCommon')) {
            if (method_exists('WpeCommon', 'purge_memcached')) {
                WpeCommon::purge_memcached();
            }
            if (method_exists('WpeCommon', 'clear_maxcdn_cache')) {
                WpeCommon::clear_maxcdn_cache();
            }
        }
        
        // v2.9.9: Cloudflare API purge - purge all related URLs
        $this->purge_cloudflare_cache_for_urls($urls_to_purge);
        
        // Debug log
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log('WSEO v2.9.9: Cache cleared for ' . count($urls_to_purge) . ' URLs on publish of post #' . $post_id);
        }
    }
    
    /**
     * v2.9.9: Purge Cloudflare cache for multiple URLs
     * Vyžaduje nastavenie Zone ID a API Token v options
     */
    private function purge_cloudflare_cache_for_urls($urls) {
        $zone_id = get_option('wseo_cloudflare_zone_id', '');
        $api_token = get_option('wseo_cloudflare_api_token', '');
        
        if (empty($zone_id) || empty($api_token)) {
            return; // Cloudflare nie je nastavený
        }
        
        // Ensure URLs array and remove duplicates
        $urls = array_unique(array_filter((array) $urls));
        
        if (empty($urls)) {
            return;
        }
        
        // Cloudflare API limit is 30 URLs per request
        $url_chunks = array_chunk($urls, 30);
        
        foreach ($url_chunks as $chunk) {
            $response = wp_remote_post(
                'https://api.cloudflare.com/client/v4/zones/' . $zone_id . '/purge_cache',
                array(
                    'timeout' => 10,
                    'headers' => array(
                        'Authorization' => 'Bearer ' . $api_token,
                        'Content-Type' => 'application/json'
                    ),
                    'body' => json_encode(array(
                        'files' => $chunk
                    ))
                )
            );
            
            if (!is_wp_error($response) && defined('WP_DEBUG') && WP_DEBUG) {
                $body = json_decode(wp_remote_retrieve_body($response), true);
                if (isset($body['success']) && $body['success']) {
                    error_log('WSEO v2.9.9: Cloudflare cache purged for ' . count($chunk) . ' URLs');
                }
            }
        }
    }
    
    /**
     * DEPRECATED: Use purge_cloudflare_cache_for_urls() instead
     */
    private function purge_cloudflare_cache_for_url($url) {
        $this->purge_cloudflare_cache_for_urls(array($url, home_url('/'), home_url('/sitemap.xml')));
    }
    
    /**
     * Auto-clear cache when taxonomy term is saved (v2.8.6)
     * 
     * @param int $term_id Term ID
     * @param int $tt_id Term taxonomy ID
     * @param string $taxonomy Taxonomy slug
     */
    public function auto_clear_cache_on_term_save($term_id, $tt_id, $taxonomy) {
        // Clear WordPress cache
        wp_cache_flush();
        clean_term_cache($term_id, $taxonomy);
        
        // Clear popular cache plugins
        if (function_exists('wp_cache_clear_cache')) {
            wp_cache_clear_cache();
        }
        if (function_exists('w3tc_flush_all')) {
            w3tc_flush_all();
        }
        if (function_exists('rocket_clean_domain')) {
            rocket_clean_domain();
        }
        if (class_exists('LiteSpeed_Cache_API')) {
            LiteSpeed_Cache_API::purge_all();
        }
    }
    
    /**
     * Output Schema.org JSON-LD
     */
    private function output_schema_jsonld() {
        $schema_type = get_option('wseo_schema_type', 'Organization');
        $schema_name = get_option('wseo_schema_name', get_option('wseo_global_site_name', get_bloginfo('name')));
        
        // Website Schema (always output)
        $website_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'WebSite',
            'name' => $schema_name,
            'url' => home_url('/'),
            'publisher' => array(
                '@type' => 'Organization',
                'name' => $schema_name,
                'url' => home_url('/')
            )
        );
        
        // Add search action
        $website_schema['potentialAction'] = array(
            '@type' => 'SearchAction',
            'target' => array(
                '@type' => 'EntryPoint',
                'urlTemplate' => home_url('/?s={search_term_string}')
            ),
            'query-input' => 'required name=search_term_string'
        );
        
        $this->output_schema($website_schema);
        
        // Organization/LocalBusiness Schema
        $org_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => $schema_type,
            'name' => $schema_name,
            'url' => home_url('/'),
        );
        
        // Description - use custom or fallback to tagline
        $schema_description = get_option('wseo_schema_description', '');
        if (!$schema_description) {
            $schema_description = get_bloginfo('description');
        }
        if ($schema_description) {
            $org_schema['description'] = $schema_description;
        }
        
        // Logo - use wseo_schema_logo first, fallback to site icon (favicon)
        $logo = get_option('wseo_schema_logo', '');
        
        // v2.9.17: Validate logo URL - must be an image, not homepage
        if ($logo) {
            // Check if URL looks like an image (has image extension or is not just domain)
            $logo_path = parse_url($logo, PHP_URL_PATH);
            $is_valid_image = !empty($logo_path) && $logo_path !== '/' && preg_match('/\.(jpg|jpeg|png|gif|webp|svg)$/i', $logo_path);
            
            if (!$is_valid_image) {
                // Not a valid image URL - clear it
                $logo = '';
            }
        }
        
        if (!$logo) {
            // Fallback: Use WordPress site icon (favicon)
            $logo = get_site_icon_url(512); // Get 512x512 site icon
        }
        
        if ($logo) {
            $logo_schema = array(
                '@type' => 'ImageObject',
                'url' => $logo,
                'contentUrl' => $logo,
                'license' => get_option('wseo_logo_license', 'https://creativecommons.org/licenses/by/4.0/'),
                'acquireLicensePage' => get_option('wseo_logo_license_page', home_url('/image-licenses/')),
                'creditText' => get_option('wseo_logo_credit', get_bloginfo('name'))
            );
            
            // Name: use logo filename or site name
            $logo_name = get_option('wseo_schema_name', '') ?: get_bloginfo('name');
            $logo_schema['name'] = $logo_name . ' Logo';
            
            // Description: auto-generate
            $logo_schema['description'] = 'Official logo of ' . $logo_name;
            
            // Creator & Author: use wseo_logo_creator if set, otherwise use creditText
            $logo_creator = get_option('wseo_logo_creator', '');
            $creator_name = $logo_creator ?: $logo_schema['creditText']; // Fallback to creditText
            
            if (!empty($creator_name)) {
                $logo_schema['creator'] = array(
                    '@type' => 'Person',
                    'name' => $creator_name
                );
                // Author is same as creator
                $logo_schema['author'] = array(
                    '@type' => 'Person',
                    'name' => $creator_name
                );
            }
            
            // Copyright: use wseo_logo_copyright_notice if set, otherwise generate from creditText and year
            $logo_copyright = get_option('wseo_logo_copyright_notice', '');
            if (!empty($logo_copyright)) {
                $logo_schema['copyrightNotice'] = $logo_copyright;
            } else {
                // Generate copyright notice
                $logo_schema['copyrightNotice'] = '© ' . date('Y') . ' ' . $logo_schema['creditText'];
            }
            
            $org_schema['logo'] = $logo_schema;
        }
        
        // v3.1: Image field - separate from logo (can be store photo, building, etc.)
        // Use wseo_schema_image first, fallback to logo
        $org_image = get_option('wseo_schema_image', '');
        if (!$org_image && $logo) {
            $org_image = $logo; // Fallback to logo if no separate image
        }
        if ($org_image) {
            $org_schema['image'] = $org_image;
        }
        
        // Contact - use wseo_schema_phone/email first, fallback to admin email
        $phone = get_option('wseo_schema_phone', '');
        $email = get_option('wseo_schema_email', '');
        
        // Fallback: Use WordPress admin email if no email is set
        if (!$email) {
            $email = get_option('admin_email');
        }
        
        // ALWAYS create contactPoint if we have at least email (which we always have from admin_email)
        if ($phone || $email) {
            $contact_point = array(
                '@type' => 'ContactPoint',
                'contactType' => 'customer service'
            );
            if ($phone) {
                $contact_point['telephone'] = $phone;
                $org_schema['telephone'] = $phone;
            }
            if ($email) {
                $contact_point['email'] = $email;
                $org_schema['email'] = $email;
            }
            $org_schema['contactPoint'] = $contact_point;
        }
        
        // Address
        $street = get_option('wseo_schema_address_street', '');
        $city = get_option('wseo_schema_address_city', '');
        $zip = get_option('wseo_schema_address_zip', '');
        $region = get_option('wseo_schema_address_region', '');
        $country = get_option('wseo_schema_address_country', 'SK');
        
        // v2.9.17: Address for ALL organization types (not just LocalBusiness)
        // Google recommends address for NewsMediaOrganization too
        $has_valid_address = !empty($street) || !empty($city);
        
        if ($has_valid_address) {
            $address_schema = array(
                '@type' => 'PostalAddress',
                'addressCountry' => $country
            );
            if ($street) $address_schema['streetAddress'] = $street;
            if ($city) $address_schema['addressLocality'] = $city;
            if ($zip) $address_schema['postalCode'] = $zip;
            if ($region) $address_schema['addressRegion'] = $region;
            
            $org_schema['address'] = $address_schema;
        }
        
        // v2.9.17: copyrightNotice for NewsMediaOrganization
        if ($schema_type === 'NewsMediaOrganization') {
            $org_schema['copyrightNotice'] = '© ' . date('Y') . ' ' . $schema_name . ', All rights reserved';
        }
        
        // LocalBusiness types REQUIRE valid address - fallback to Organization if missing
        // v3.1: Complete list of all LocalBusiness subtypes from Schema.org
        $local_business_types = array(
            'LocalBusiness', 'Restaurant', 'Hotel', 'Store', 'MedicalBusiness', 'FinancialService', 
            'RealEstateAgent', 'TravelAgency', 'AutomotiveBusiness', 'HomeAndConstructionBusiness', 
            'LegalService', 'FoodEstablishment', 'LodgingBusiness', 'HealthAndBeautyBusiness',
            'EntertainmentBusiness', 'SportsActivityLocation', 'AnimalShelter', 'ArchiveOrganization',
            'ChildCare', 'DryCleaningOrLaundry', 'EmergencyService', 'EmploymentAgency', 'GovernmentOffice',
            'InternetCafe', 'Library', 'RadioStation', 'RecyclingCenter', 'SelfStorage', 'ShoppingCenter',
            'TelevisionStation', 'TouristInformationCenter', 'ProfessionalService',
            // FoodEstablishment subtypes
            'Bakery', 'BarOrPub', 'CafeOrCoffeeShop', 'FastFoodRestaurant', 'IceCreamShop', 'Winery', 'Brewery', 'Distillery',
            // Store subtypes
            'AutoPartsStore', 'BikeStore', 'BookStore', 'ClothingStore', 'ComputerStore', 'ConvenienceStore',
            'DepartmentStore', 'ElectronicsStore', 'Florist', 'FurnitureStore', 'GardenStore', 'GroceryStore',
            'HardwareStore', 'HobbyShop', 'HomeGoodsStore', 'JewelryStore', 'LiquorStore', 'MensClothingStore',
            'MobilePhoneStore', 'MovieRentalStore', 'MusicStore', 'OfficeEquipmentStore', 'OutletStore',
            'PawnShop', 'PetStore', 'ShoeStore', 'SportingGoodsStore', 'TireShop', 'ToyStore', 'WholesaleStore',
            // LodgingBusiness subtypes
            'BedAndBreakfast', 'Campground', 'Hostel', 'Motel', 'Resort', 'SkiResort', 'VacationRental',
            // HealthAndBeautyBusiness subtypes
            'BeautySalon', 'DaySpa', 'HairSalon', 'NailSalon', 'TattooParlor',
            // MedicalBusiness subtypes
            'MedicalClinic', 'Pharmacy', 'Physician', 'Dentist', 'Optician', 'VeterinaryCare', 'Dermatology',
            'DietNutrition', 'Emergency', 'Geriatric', 'Gynecologic', 'Midwifery', 'Nursing', 'Obstetric',
            'Oncologic', 'Optometric', 'Otolaryngologic', 'Pediatric', 'Physiotherapy', 'PlasticSurgery',
            'Podiatric', 'PrimaryCare', 'Psychiatric', 'PublicHealth', 'CommunityHealth',
            // AutomotiveBusiness subtypes
            'AutoDealer', 'AutoRepair', 'AutoBodyShop', 'AutoRental', 'AutoWash', 'GasStation',
            'MotorcycleDealer', 'MotorcycleRepair',
            // HomeAndConstructionBusiness subtypes
            'Electrician', 'GeneralContractor', 'HVACBusiness', 'HousePainter', 'Locksmith', 
            'MovingCompany', 'Plumber', 'RoofingContractor',
            // LegalService subtypes
            'Attorney', 'Notary',
            // EntertainmentBusiness subtypes
            'AdultEntertainment', 'AmusementPark', 'ArtGallery', 'Casino', 'ComedyClub', 'MovieTheater', 'NightClub',
            // SportsActivityLocation subtypes
            'BowlingAlley', 'ExerciseGym', 'GolfCourse', 'HealthClub', 'PublicSwimmingPool', 
            'SportsClub', 'StadiumOrArena', 'TennisComplex',
            // Financial subtypes
            'AccountingService', 'InsuranceAgency'
        );
        
        if (in_array($schema_type, $local_business_types) && !$has_valid_address) {
            // NO valid address - FALLBACK to Organization type
            // This prevents Google validation errors for LocalBusiness without address
            $org_schema['@type'] = 'Organization';
            // Log warning for admin
            if (current_user_can('manage_options')) {
                add_action('admin_notices', function() use ($schema_type) {
                    echo '<div class="notice notice-warning is-dismissible">';
                    echo '<p><strong>WebStudio SEO Pro:</strong> Typ organizácie "' . esc_html($schema_type) . '" vyžaduje adresu (ulicu alebo mesto). ';
                    echo 'Dočasne sa používa typ "Organization". Prosím vyplňte adresu v <a href="' . admin_url('admin.php?page=webstudio-seo-global') . '">Globálnych nastaveniach</a>.</p>';
                    echo '</div>';
                });
            }
        }
        
        // Geo coordinates
        $lat = get_option('wseo_schema_geo_lat', '');
        $lng = get_option('wseo_schema_geo_lng', '');
        
        if ($lat && $lng) {
            $org_schema['geo'] = array(
                '@type' => 'GeoCoordinates',
                'latitude' => $lat,
                'longitude' => $lng
            );
        }
        
        // v2.9.9: Opening hours (Google-compliant OpeningHoursSpecification)
        $day_mapping = array(
            'mon' => 'Monday',
            'tue' => 'Tuesday', 
            'wed' => 'Wednesday',
            'thu' => 'Thursday',
            'fri' => 'Friday',
            'sat' => 'Saturday',
            'sun' => 'Sunday'
        );
        
        $opening_hours_spec = array();
        foreach ($day_mapping as $key => $day_name) {
            $open = get_option("wseo_schema_hours_{$key}_open", '');
            $close = get_option("wseo_schema_hours_{$key}_close", '');
            
            if ($open && $close) {
                $opening_hours_spec[] = array(
                    '@type' => 'OpeningHoursSpecification',
                    'dayOfWeek' => $day_name,
                    'opens' => $open,
                    'closes' => $close
                );
            }
        }
        
        if (!empty($opening_hours_spec) && $schema_type !== 'Organization') {
            $org_schema['openingHoursSpecification'] = $opening_hours_spec;
        }
        
        // v2.9.10: Removed legacy openingHours text format - it doesn't comply with Schema.org
        // Google Rich Results Test rejects free-text formats like "Po-Pia: 09:00-18:00"
        // Users should use the day-by-day time inputs which generate proper openingHoursSpecification
        
        // Price range
        $price_range = get_option('wseo_schema_price_range', '');
        if ($price_range && $schema_type !== 'Organization') {
            $org_schema['priceRange'] = $price_range;
        }
        
        // v2.9.9: sameAs (social media links)
        $same_as = array();
        $social_fields = array('facebook', 'instagram', 'twitter', 'linkedin', 'youtube', 'tiktok', 'pinterest', 'tweetko');
        foreach ($social_fields as $social) {
            $url = get_option("wseo_schema_{$social}", '');
            if ($url) {
                $same_as[] = $url;
            }
        }
        // Legacy social fields
        $legacy_social = array('social_facebook', 'social_instagram', 'social_linkedin', 'social_youtube', 'social_tweetko');
        foreach ($legacy_social as $social) {
            $url = get_option("wseo_schema_{$social}", '');
            if ($url && !in_array($url, $same_as)) {
                $same_as[] = $url;
            }
        }
        if (!empty($same_as)) {
            $org_schema['sameAs'] = $same_as;
        }
        
        // v2.9.10: aggregateRating - ONLY for supported types
        // Google 2019 update: "self-serving" reviews NOT shown for LocalBusiness and Organization
        // Supported types: Product, Service, Recipe, Book, Course, Movie, CreativeWork, Event, SoftwareApplication
        // LocalBusiness and Organization are NOT eligible for review rich results on own website
        // See: https://developers.google.com/search/blog/2019/09/making-review-rich-results-more-helpful
        $rating_value = get_option('wseo_schema_rating_value', '');
        $rating_count = get_option('wseo_schema_rating_count', '');
        
        // Only add aggregateRating if NOT a LocalBusiness or Organization type (Google ignores these)
        // v3.1: Complete list including all LocalBusiness subtypes
        $no_rating_types = array(
            // Organization types
            'Organization', 'GovernmentOrganization', 'NGO', 'Corporation', 'EducationalOrganization',
            'MedicalOrganization', 'SportsOrganization', 'PerformingGroup',
            // LocalBusiness main categories
            'LocalBusiness', 'FoodEstablishment', 'HealthAndBeautyBusiness', 'LodgingBusiness',
            'AutomotiveBusiness', 'HomeAndConstructionBusiness', 'SportsActivityLocation', 'EntertainmentBusiness',
            'MedicalBusiness', 'FinancialService', 'LegalService', 'ProfessionalService',
            // FoodEstablishment subtypes
            'Restaurant', 'Bakery', 'BarOrPub', 'CafeOrCoffeeShop', 'FastFoodRestaurant', 
            'IceCreamShop', 'Winery', 'Brewery', 'Distillery',
            // LodgingBusiness subtypes
            'Hotel', 'BedAndBreakfast', 'Hostel', 'Motel', 'Resort', 'VacationRental', 'Campground', 'SkiResort',
            // Store subtypes
            'Store', 'AutoPartsStore', 'BikeStore', 'BookStore', 'ClothingStore', 'ComputerStore', 
            'ConvenienceStore', 'DepartmentStore', 'ElectronicsStore', 'Florist', 'FurnitureStore', 
            'GardenStore', 'GroceryStore', 'HardwareStore', 'HobbyShop', 'HomeGoodsStore', 'JewelryStore', 
            'LiquorStore', 'MensClothingStore', 'MobilePhoneStore', 'MovieRentalStore', 'MusicStore', 
            'OfficeEquipmentStore', 'OutletStore', 'PawnShop', 'PetStore', 'ShoeStore', 
            'SportingGoodsStore', 'TireShop', 'ToyStore', 'WholesaleStore',
            // HealthAndBeautyBusiness subtypes
            'BeautySalon', 'DaySpa', 'HairSalon', 'NailSalon', 'TattooParlor',
            // MedicalBusiness subtypes
            'MedicalClinic', 'Pharmacy', 'Physician', 'Dentist', 'Optician', 'VeterinaryCare',
            // AutomotiveBusiness subtypes
            'AutoDealer', 'AutoRepair', 'AutoBodyShop', 'AutoRental', 'AutoWash', 'GasStation',
            // HomeAndConstructionBusiness subtypes
            'Electrician', 'GeneralContractor', 'HVACBusiness', 'HousePainter', 'Locksmith', 
            'MovingCompany', 'Plumber', 'RoofingContractor',
            // EntertainmentBusiness subtypes
            'MovieTheater', 'AmusementPark', 'ArtGallery', 'Casino', 'ComedyClub', 'NightClub', 'AdultEntertainment',
            // SportsActivityLocation subtypes
            'ExerciseGym', 'GolfCourse', 'BowlingAlley', 'TennisComplex', 'PublicSwimmingPool', 
            'SportsClub', 'StadiumOrArena', 'HealthClub',
            // Other LocalBusiness types
            'RealEstateAgent', 'TravelAgency', 'EmploymentAgency', 'AnimalShelter', 'ArchiveOrganization',
            'ChildCare', 'DryCleaningOrLaundry', 'EmergencyService', 'GovernmentOffice', 'InternetCafe',
            'Library', 'RadioStation', 'RecyclingCenter', 'SelfStorage', 'ShoppingCenter',
            'TelevisionStation', 'TouristInformationCenter', 'AccountingService', 'InsuranceAgency',
            'Attorney', 'Notary'
        );
        
        // Note: aggregateRating for LocalBusiness/Organization won't show in Google Rich Results
        // But we still allow users to add it for other search engines (Bing, etc.) - just add a warning in admin
        if ($rating_value && $rating_count && !in_array($schema_type, $no_rating_types)) {
            $org_schema['aggregateRating'] = array(
                '@type' => 'AggregateRating',
                'ratingValue' => floatval($rating_value),
                'bestRating' => 5,
                'worstRating' => 1,
                'ratingCount' => intval($rating_count)
            );
        }
        
        // Description (RECOMMENDED for ALL types)
        $description = get_option('wseo_schema_description', '');
        if ($description) {
            $org_schema['description'] = $description;
        }
        
        // v2.9.9: VacationRental/LodgingBusiness specific fields (Google 2026 requirements)
        $lodging_types = array('VacationRental', 'LodgingBusiness', 'Hotel', 'BedAndBreakfast', 'Hostel', 'Motel', 'Resort', 'Campground', 'SkiResort');
        if (in_array($schema_type, $lodging_types)) {
            // Identifier (REQUIRED for VacationRental)
            $identifier = get_option('wseo_schema_identifier', '');
            if (!$identifier) {
                // Generate identifier from site URL
                $identifier = sanitize_title(get_bloginfo('name'));
            }
            $org_schema['identifier'] = $identifier;
            
            // Multiple Images (REQUIRED: minimum 8 for VacationRental)
            $images_text = get_option('wseo_schema_images', '');
            if ($images_text) {
                $images_array = array_filter(array_map('trim', explode("\n", $images_text)));
                if (!empty($images_array)) {
                    $org_schema['image'] = array_values($images_array);
                }
            }
            
            // Additional type (Villa, Apartment, Cottage, etc.)
            $additional_type = get_option('wseo_schema_additional_type', '');
            if ($additional_type) {
                $org_schema['additionalType'] = $additional_type;
            }
            
            // Number of rooms/beds (for containsPlace - REQUIRED structure)
            $num_rooms = get_option('wseo_schema_num_rooms', '');
            $num_beds = get_option('wseo_schema_num_beds', '');
            $num_bathrooms = get_option('wseo_schema_num_bathrooms', '');
            $max_occupancy = get_option('wseo_schema_max_occupancy', '');
            $room_type = get_option('wseo_schema_room_type', 'EntirePlace'); // EntirePlace, PrivateRoom, SharedRoom
            
            // containsPlace - Accommodation details (REQUIRED for VacationRental)
            $accommodation = array(
                '@type' => 'Accommodation',
                'name' => $schema_name
            );
            
            // Room type (RECOMMENDED)
            if ($room_type) {
                $accommodation['additionalType'] = $room_type;
            }
            
            // Occupancy (REQUIRED for VacationRental)
            if ($max_occupancy) {
                $accommodation['occupancy'] = array(
                    '@type' => 'QuantitativeValue',
                    'value' => intval($max_occupancy)
                );
            }
            
            // Number of rooms
            if ($num_rooms) {
                $accommodation['numberOfRooms'] = intval($num_rooms);
            }
            
            // Number of bedrooms
            if ($num_beds) {
                $accommodation['numberOfBedrooms'] = intval($num_beds);
            }
            
            // Number of bathrooms
            if ($num_bathrooms) {
                $accommodation['numberOfBathroomsTotal'] = floatval($num_bathrooms);
            }
            
            // Bed details (RECOMMENDED)
            $bed_type = get_option('wseo_schema_bed_type', '');
            $bed_count = get_option('wseo_schema_bed_count', '');
            if ($bed_type || $bed_count) {
                $accommodation['bed'] = array(
                    '@type' => 'BedDetails',
                    'numberOfBeds' => intval($bed_count ?: $num_beds ?: 1),
                    'typeOfBed' => $bed_type ?: 'Queen'
                );
            }
            
            // Floor size (RECOMMENDED)
            $floor_size = get_option('wseo_schema_floor_size', '');
            if ($floor_size) {
                $accommodation['floorSize'] = array(
                    '@type' => 'QuantitativeValue',
                    'value' => intval($floor_size),
                    'unitCode' => 'MTK' // Square meters
                );
            }
            
            // Amenities (RECOMMENDED - must be inside containsPlace for VacationRental)
            $amenities = get_option('wseo_schema_amenities', '');
            if ($amenities) {
                $amenity_list = array_map('trim', explode(',', $amenities));
                $accommodation['amenityFeature'] = array();
                
                // Map common amenities to Google's expected values
                $amenity_mapping = array(
                    'wifi' => 'wifi',
                    'WiFi' => 'wifi',
                    'internet' => 'wifi',
                    'parkovanie' => 'parkingType',
                    'parking' => 'parkingType',
                    'klimatizácia' => 'ac',
                    'klimatizacia' => 'ac',
                    'AC' => 'ac',
                    'air conditioning' => 'ac',
                    'kuchyňa' => 'kitchen',
                    'kuchyna' => 'kitchen',
                    'kitchen' => 'kitchen',
                    'TV' => 'tv',
                    'televízia' => 'tv',
                    'bazén' => 'pool',
                    'bazen' => 'pool',
                    'pool' => 'pool',
                    'vírivka' => 'hotTub',
                    'virivka' => 'hotTub',
                    'hot tub' => 'hotTub',
                    'kúrenie' => 'heating',
                    'kurenie' => 'heating',
                    'heating' => 'heating',
                    'balkón' => 'balcony',
                    'balkon' => 'balcony',
                    'balcony' => 'balcony',
                    'terasa' => 'patio',
                    'patio' => 'patio',
                    'krb' => 'fireplace',
                    'fireplace' => 'fireplace',
                    'výťah' => 'elevator',
                    'vytah' => 'elevator',
                    'elevator' => 'elevator',
                    'práčka' => 'washerDryer',
                    'pracka' => 'washerDryer',
                    'washer' => 'washerDryer',
                    'fitness' => 'gymFitnessEquipment',
                    'gym' => 'gymFitnessEquipment',
                    'detská postieľka' => 'crib',
                    'crib' => 'crib',
                    'pre deti' => 'childFriendly',
                    'child friendly' => 'childFriendly',
                    'bezbariérový' => 'wheelchairAccessible',
                    'wheelchair' => 'wheelchairAccessible',
                    'pláž' => 'beachAccess',
                    'beach' => 'beachAccess',
                    'raňajky' => 'freeBreakfast',
                    'breakfast' => 'freeBreakfast',
                    'gril' => 'outdoorGrill',
                    'grill' => 'outdoorGrill',
                    'mikrovlnka' => 'microwave',
                    'microwave' => 'microwave',
                    'sporák' => 'ovenStove',
                    'oven' => 'ovenStove',
                    'žehlička' => 'ironingBoard',
                    'iron' => 'ironingBoard',
                    'zvieratá' => 'petsAllowed',
                    'pets' => 'petsAllowed',
                    'fajčenie' => 'smokingAllowed',
                    'smoking' => 'smokingAllowed',
                );
                
                foreach ($amenity_list as $amenity) {
                    if (!empty($amenity)) {
                        $amenity_lower = strtolower(trim($amenity));
                        $amenity_key = isset($amenity_mapping[$amenity_lower]) ? $amenity_mapping[$amenity_lower] : $amenity_lower;
                        
                        $accommodation['amenityFeature'][] = array(
                            '@type' => 'LocationFeatureSpecification',
                            'name' => $amenity_key,
                            'value' => true
                        );
                    }
                }
            }
            
            // Always add containsPlace for lodging (REQUIRED for VacationRental)
            $org_schema['containsPlace'] = $accommodation;
            
            // Check-in/Check-out times (RECOMMENDED)
            $checkin = get_option('wseo_schema_checkin_time', '');
            $checkout = get_option('wseo_schema_checkout_time', '');
            if ($checkin) {
                // Format as ISO 8601 time
                $org_schema['checkinTime'] = $checkin . ':00';
            }
            if ($checkout) {
                $org_schema['checkoutTime'] = $checkout . ':00';
            }
            
            // Languages spoken (RECOMMENDED)
            $languages = get_option('wseo_schema_languages', '');
            if ($languages) {
                $lang_list = array_map('trim', explode(',', $languages));
                $org_schema['knowsLanguage'] = $lang_list;
            }
        }
        
        // Restaurant specific fields
        if ($schema_type === 'Restaurant' || $schema_type === 'FastFoodRestaurant' || $schema_type === 'CafeOrCoffeeShop') {
            $cuisine = get_option('wseo_schema_cuisine', '');
            $menu_url = get_option('wseo_schema_menu_url', '');
            $accepts_reservations = get_option('wseo_schema_accepts_reservations', '');
            
            if ($cuisine) $org_schema['servesCuisine'] = $cuisine;
            if ($menu_url) $org_schema['menu'] = $menu_url;
            if ($accepts_reservations) $org_schema['acceptsReservations'] = $accepts_reservations === '1' ? true : false;
        }
        
        // Business identifiers (IČO, DIČ, IČ DPH)
        $tax_id = get_option('wseo_schema_tax_id', '');
        $vat_id = get_option('wseo_schema_vat_id', '');
        $legal_name = get_option('wseo_schema_legal_name', '');
        $founding_date = get_option('wseo_schema_founding_date', '');
        $num_employees = get_option('wseo_schema_num_employees', '');
        $slogan = get_option('wseo_schema_slogan', '');
        $area_served = get_option('wseo_schema_area_served', '');
        $payment_accepted = get_option('wseo_schema_payment_accepted', '');
        
        if ($tax_id) $org_schema['taxID'] = $tax_id;
        if ($vat_id) $org_schema['vatID'] = $vat_id;
        if ($legal_name) $org_schema['legalName'] = $legal_name;
        if ($founding_date) $org_schema['foundingDate'] = $founding_date;
        if ($num_employees) {
            $org_schema['numberOfEmployees'] = array(
                '@type' => 'QuantitativeValue',
                'value' => intval($num_employees)
            );
        }
        if ($slogan) $org_schema['slogan'] = $slogan;
        if ($area_served) $org_schema['areaServed'] = $area_served;
        if ($payment_accepted) $org_schema['paymentAccepted'] = $payment_accepted;
        
        // HasMap - link to Google Maps
        $has_map = get_option('wseo_schema_has_map', '');
        if ($has_map) {
            $org_schema['hasMap'] = $has_map;
        } elseif (!empty($street) && !empty($city)) {
            // Auto-generate Google Maps link
            $map_query = urlencode($street . ', ' . $city . ', ' . $country);
            $org_schema['hasMap'] = 'https://www.google.com/maps/search/?api=1&query=' . $map_query;
        }
        
        // Note: sameAs is now handled earlier in v2.9.9 code (social media section)
        // Legacy social fields are merged there for backwards compatibility
        
        // Founder (Person) - use centralized default settings
        $founder_name = get_option('wseo_default_person_name', '');
        $founder_image = get_option('wseo_default_person_image', '');
        $founder_title = get_option('wseo_default_person_jobtitle', '');
        $founder_url = get_option('wseo_default_person_url', '');
        $founder_social_text = get_option('wseo_default_person_social', '');
        
        // Fallback: use first admin if no settings
        if (empty($founder_name)) {
            $admin_users = get_users(array('role' => 'administrator', 'number' => 1));
            if (!empty($admin_users)) {
                $founder_id = $admin_users[0]->ID;
                $founder_name = get_the_author_meta('display_name', $founder_id);
                if (empty($founder_image)) {
                    $founder_image = get_avatar_url($founder_id, array('size' => 200));
                }
                if (empty($founder_title)) {
                    $founder_title = get_the_author_meta('user_description', $founder_id);
                    if (empty($founder_title)) {
                        $founder_title = get_the_author_meta('nickname', $founder_id);
                    }
                }
                if (empty($founder_url)) {
                    $founder_url = get_author_posts_url($founder_id);
                }
            }
        }
        
        if (!empty($founder_name)) {
            $founder_schema = array(
                '@type' => 'Person',
                'name' => $founder_name
            );
            
            // Founder image
            if (!empty($founder_image)) {
                $founder_schema['image'] = array(
                    '@type' => 'ImageObject',
                    'url' => $founder_image,
                    'contentUrl' => $founder_image,
                    'name' => $founder_name . ' - Profile Photo',
                    'description' => 'Profile photo of ' . $founder_name,
                    'creditText' => $founder_name,
                    'license' => 'https://creativecommons.org/licenses/by/4.0/',
                    'acquireLicensePage' => home_url('/image-licenses/'),
                    'creator' => array(
                        '@type' => 'Person',
                        'name' => $founder_name
                    ),
                    'author' => array(
                        '@type' => 'Person',
                        'name' => $founder_name
                    ),
                    'copyrightNotice' => '© ' . date('Y') . ' ' . $founder_name
                );
            }
            
            // Founder URL
            if (!empty($founder_url)) {
                $founder_schema['url'] = $founder_url;
            }
            
            // Job Title
            if (!empty($founder_title)) {
                $founder_schema['jobTitle'] = $founder_title;
            }
            
            // Works for this organization
            $founder_schema['worksFor'] = array(
                '@type' => 'Organization',
                'name' => $schema_name,
                'url' => home_url('/')
            );
            
            // v2.9.17: Person contact fields (email, telephone, address)
            $founder_email = get_option('wseo_default_person_email', '');
            $founder_phone = get_option('wseo_default_person_telephone', '');
            $founder_address = get_option('wseo_default_person_address', '');
            
            if ($founder_email) {
                $founder_schema['email'] = $founder_email;
            }
            if ($founder_phone) {
                $founder_schema['telephone'] = $founder_phone;
            }
            if ($founder_address) {
                $founder_schema['address'] = array(
                    '@type' => 'PostalAddress',
                    'streetAddress' => $founder_address
                );
            }
            
            // Social profiles
            if (!empty($founder_social_text)) {
                $founder_social = array_filter(array_map('trim', explode("\n", $founder_social_text)));
                if (!empty($founder_social)) {
                    $founder_schema['sameAs'] = $founder_social;
                }
            }
            
            $org_schema['founder'] = $founder_schema;
        }
        
        // Note: aggregateRating is now handled earlier in v2.9.9 code (if user fills in the values)
        // We don't add fake ratings - only real ones from settings
        
        $this->output_schema($org_schema);
        
        // WebPage Schema (for all pages)
        if (is_singular()) {
            $this->output_webpage_schema();
        }
        
        // SiteNavigationElement Schema
        $this->output_navigation_schema();
        
        // Page-specific Schema.org
        if (is_singular('page')) {
            $this->output_page_schema();
        }
        
        // Article Schema for posts
        if (is_singular('post')) {
            $this->output_article_schema();
        }
        
        // Product Schema for WooCommerce
        if (is_singular('product') && class_exists('WooCommerce')) {
            $this->output_product_schema();
        }
        
        // SoftwareApplication Schema (if enabled on page/post)
        if (is_singular()) {
            $this->output_software_schema();
        }
        
        // VideoObject Schema (if enabled on page/post)
        if (is_singular()) {
            $this->output_video_schema();
        }
        
        // Course Schema (if enabled on page/post)
        if (is_singular()) {
            $this->output_course_schema();
        }
        
        // JobPosting Schema (if enabled on page/post)
        if (is_singular()) {
            $this->output_jobposting_schema();
        }
        
        // Service Schema (if enabled on page/post)
        if (is_singular()) {
            $this->output_service_schema();
        }
        
        // Breadcrumbs Schema (for ALL pages including homepage)
        // v2.9.17: Added is_front_page() to fix "missing itemListElement" error on homepage
        if (is_singular() || is_category() || is_tag() || is_tax() || is_front_page() || is_home()) {
            $this->output_breadcrumbs_schema();
        }
        
        // v2.9.15: Self-serving Review Schema REMOVED
        // Google banned self-serving reviews in September 2019
        // See: https://developers.google.com/search/blog/2019/09/making-review-rich-results-more-helpful
        // Reviews must come from third-party sources (Google My Business, Facebook, etc.)
    }
    
    /**
     * Output SoftwareApplication Schema
     * Google 2026: For software products, apps, plugins
     */
    private function output_software_schema() {
        global $post;
        
        // Check if software schema is enabled for this post
        $is_software = get_post_meta($post->ID, '_wseo_is_software', true);
        if ($is_software !== '1') {
            return;
        }
        
        $software_name = get_post_meta($post->ID, '_wseo_software_name', true) ?: get_the_title();
        $software_version = get_post_meta($post->ID, '_wseo_software_version', true);
        $software_price = get_post_meta($post->ID, '_wseo_software_price', true);
        $software_currency = get_post_meta($post->ID, '_wseo_software_currency', true) ?: WSEO_DEFAULT_CURRENCY;
        $software_os = get_post_meta($post->ID, '_wseo_software_os', true);
        $software_category = get_post_meta($post->ID, '_wseo_software_category', true);
        $software_download = get_post_meta($post->ID, '_wseo_software_download', true);
        $software_rating = get_post_meta($post->ID, '_wseo_software_rating', true);
        $software_review_count = get_post_meta($post->ID, '_wseo_software_review_count', true);
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        
        $software_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'SoftwareApplication',
            'name' => $software_name,
            'url' => get_permalink(),
            'description' => get_post_meta($post->ID, '_wseo_meta_description', true) ?: $this->clean_post_content($post->post_content, WSEO_EXCERPT_WORDS)
        );
        
        // Version
        if ($software_version) {
            $software_schema['softwareVersion'] = $software_version;
        }
        
        // Operating System
        if ($software_os) {
            $software_schema['operatingSystem'] = $software_os;
        }
        
        // Application Category
        if ($software_category) {
            $software_schema['applicationCategory'] = $software_category;
        }
        
        // Download URL
        if ($software_download) {
            $software_schema['downloadUrl'] = $software_download;
        }
        
        // Price - ALWAYS add offers with all Google required fields
        $software_schema['offers'] = array(
            '@type' => 'Offer',
            'price' => $software_price ?: '0',
            'priceCurrency' => $software_currency,
            'url' => get_permalink(),
            'priceValidUntil' => date('Y-m-d', strtotime('+1 year')),
            'availability' => 'https://schema.org/InStock',
            'seller' => array(
                '@type' => 'Organization',
                'name' => $site_name
            )
        );
        
        // v2.9.10: aggregateRating - ONLY if real values are provided
        // Google supports aggregateRating for SoftwareApplication type
        if ($software_rating && $software_review_count && floatval($software_rating) > 0 && intval($software_review_count) > 0) {
            $software_schema['aggregateRating'] = array(
                '@type' => 'AggregateRating',
                'ratingValue' => floatval($software_rating),
                'reviewCount' => intval($software_review_count),
                'bestRating' => 5,
                'worstRating' => 1
            );
        }
        // v2.9.10: Removed fake default rating - this is SPAM and Google penalizes it
        
        // v2.9.10: Removed fake self-review - this is SPAM
        // Reviews must be real user reviews, not auto-generated
        
        // Publisher/Author
        $software_schema['author'] = array(
            '@type' => 'Organization',
            'name' => $site_name,
            'url' => home_url('/')
        );
        
        // Featured image
        $image = get_the_post_thumbnail_url($post->ID, 'large');
        if ($image) {
            $software_schema['image'] = $image;
        }
        
        $this->output_schema($software_schema);
    }
    
    /**
     * Output VideoObject Schema
     * Google 2026: For video content, YouTube embeds, video tutorials
     */
    private function output_video_schema() {
        global $post;
        
        $is_video = get_post_meta($post->ID, '_wseo_is_video', true);
        if ($is_video !== '1') {
            return;
        }
        
        $video_name = get_post_meta($post->ID, '_wseo_video_name', true) ?: get_the_title();
        $video_description = get_post_meta($post->ID, '_wseo_video_description', true);
        $video_thumbnail = get_post_meta($post->ID, '_wseo_video_thumbnail', true);
        $video_url = get_post_meta($post->ID, '_wseo_video_url', true);
        $video_embed = get_post_meta($post->ID, '_wseo_video_embed', true);
        $video_duration = get_post_meta($post->ID, '_wseo_video_duration', true);
        $video_upload_date = get_post_meta($post->ID, '_wseo_video_upload_date', true) ?: get_the_date('c');
        
        $video_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'VideoObject',
            'name' => $video_name,
            'description' => $video_description ?: $this->clean_post_content($post->post_content, WSEO_EXCERPT_WORDS),
            'uploadDate' => $video_upload_date
        );
        
        if ($video_thumbnail) {
            $video_schema['thumbnailUrl'] = $video_thumbnail;
        }
        
        if ($video_url) {
            $video_schema['contentUrl'] = $video_url;
        }
        
        if ($video_embed) {
            $video_schema['embedUrl'] = $video_embed;
        }
        
        if ($video_duration) {
            $video_schema['duration'] = $video_duration; // Format: PT1H30M (1 hour 30 minutes)
        }
        
        $this->output_schema($video_schema);
    }
    
    /**
     * Output Course Schema
     * Google 2026: For online courses, tutorials, educational content
     */
    private function output_course_schema() {
        global $post;
        
        $is_course = get_post_meta($post->ID, '_wseo_is_course', true);
        if ($is_course !== '1') {
            return;
        }
        
        $course_name = get_post_meta($post->ID, '_wseo_course_name', true) ?: get_the_title();
        $course_description = get_post_meta($post->ID, '_wseo_course_description', true) ?: $this->clean_post_content($post->post_content, WSEO_EXCERPT_WORDS);
        $course_provider = get_post_meta($post->ID, '_wseo_course_provider', true);
        $course_price = get_post_meta($post->ID, '_wseo_course_price', true);
        $course_currency = get_post_meta($post->ID, '_wseo_course_currency', true) ?: WSEO_DEFAULT_CURRENCY;
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $provider_name = $course_provider ?: $site_name;
        
        $course_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'Course',
            'name' => $course_name,
            'description' => $course_description,
            'provider' => array(
                '@type' => 'Organization',
                'name' => $provider_name,
                'url' => home_url('/')
            )
        );
        
        // Offers - ALWAYS add with all Google required fields
        $course_schema['offers'] = array(
            '@type' => 'Offer',
            'price' => $course_price ?: '0',
            'priceCurrency' => $course_currency,
            'url' => get_permalink(),
            'priceValidUntil' => date('Y-m-d', strtotime('+1 year')),
            'availability' => 'https://schema.org/InStock',
            'seller' => array(
                '@type' => 'Organization',
                'name' => $provider_name
            )
        );
        
        // v2.9.10: aggregateRating - ONLY if real values are provided
        // Google supports aggregateRating for Course type
        $course_rating = get_post_meta($post->ID, '_wseo_schema_rating_value', true);
        $course_rating_count = get_post_meta($post->ID, '_wseo_schema_rating_count', true);
        if ($course_rating && $course_rating_count && floatval($course_rating) > 0 && intval($course_rating_count) > 0) {
            $course_schema['aggregateRating'] = array(
                '@type' => 'AggregateRating',
                'ratingValue' => floatval($course_rating),
                'reviewCount' => intval($course_rating_count),
                'bestRating' => 5,
                'worstRating' => 1
            );
        }
        
        // v2.9.10: Removed fake self-review - this is SPAM
        // Reviews must be real user reviews, not auto-generated
        
        $image = get_the_post_thumbnail_url($post->ID, 'large');
        if ($image) {
            $course_schema['image'] = $image;
        }
        
        $this->output_schema($course_schema);
    }
    
    /**
     * Output JobPosting Schema
     * Google 2026: For job listings, career pages
     */
    private function output_jobposting_schema() {
        global $post;
        
        $is_job = get_post_meta($post->ID, '_wseo_is_job', true);
        if ($is_job !== '1') {
            return;
        }
        
        $job_title = get_post_meta($post->ID, '_wseo_job_title', true) ?: get_the_title();
        $job_description = get_post_meta($post->ID, '_wseo_job_description', true);
        $job_type = get_post_meta($post->ID, '_wseo_job_type', true);
        $job_location = get_post_meta($post->ID, '_wseo_job_location', true);
        $job_salary_min = get_post_meta($post->ID, '_wseo_job_salary_min', true);
        $job_salary_max = get_post_meta($post->ID, '_wseo_job_salary_max', true);
        $job_currency = get_post_meta($post->ID, '_wseo_job_currency', true) ?: WSEO_DEFAULT_CURRENCY;
        $job_date_posted = get_post_meta($post->ID, '_wseo_job_date_posted', true) ?: get_the_date('c');
        
        $company_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        
        $job_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'JobPosting',
            'title' => $job_title,
            'description' => $job_description ?: $this->clean_post_content($post->post_content, WSEO_LONG_EXCERPT_WORDS),
            'datePosted' => $job_date_posted,
            'hiringOrganization' => array(
                '@type' => 'Organization',
                'name' => $company_name,
                'url' => home_url('/')
            )
        );
        
        if ($job_type) {
            $job_schema['employmentType'] = $job_type; // FULL_TIME, PART_TIME, CONTRACTOR
        }
        
        if ($job_location) {
            $job_schema['jobLocation'] = array(
                '@type' => 'Place',
                'address' => array(
                    '@type' => 'PostalAddress',
                    'addressLocality' => $job_location
                )
            );
        }
        
        if ($job_salary_min && $job_salary_max) {
            $job_schema['baseSalary'] = array(
                '@type' => 'MonetaryAmount',
                'currency' => $job_currency,
                'value' => array(
                    '@type' => 'QuantitativeValue',
                    'minValue' => $job_salary_min,
                    'maxValue' => $job_salary_max,
                    'unitText' => 'MONTH'
                )
            );
        }
        
        $this->output_schema($job_schema);
    }
    
    /**
     * Output Service Schema
     * Google 2026: For services offered by business
     */
    private function output_service_schema() {
        global $post;
        
        $is_service = get_post_meta($post->ID, '_wseo_is_service', true);
        if ($is_service !== '1') {
            return;
        }
        
        $service_name = get_post_meta($post->ID, '_wseo_service_name', true) ?: get_the_title();
        $service_description = get_post_meta($post->ID, '_wseo_service_description', true) ?: $this->clean_post_content($post->post_content, WSEO_EXCERPT_WORDS);
        $service_type = get_post_meta($post->ID, '_wseo_service_type', true);
        $service_provider = get_post_meta($post->ID, '_wseo_service_provider', true);
        $service_area = get_post_meta($post->ID, '_wseo_service_area', true);
        $service_price = get_post_meta($post->ID, '_wseo_service_price', true);
        $service_currency = get_post_meta($post->ID, '_wseo_service_currency', true) ?: WSEO_DEFAULT_CURRENCY;
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $provider_name = $service_provider ?: $site_name;
        
        $service_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'Service',
            'name' => $service_name,
            'description' => $service_description,
            'provider' => array(
                '@type' => 'Organization',
                'name' => $provider_name,
                'url' => home_url('/')
            )
        );
        
        if ($service_type) {
            $service_schema['serviceType'] = $service_type;
        }
        
        if ($service_area) {
            $service_schema['areaServed'] = array(
                '@type' => 'Place',
                'name' => $service_area
            );
        }
        
        // Offers - ALWAYS add with all Google required fields
        $service_schema['offers'] = array(
            '@type' => 'Offer',
            'price' => $service_price ?: '0',
            'priceCurrency' => $service_currency,
            'url' => get_permalink(),
            'priceValidUntil' => date('Y-m-d', strtotime('+1 year')),
            'availability' => 'https://schema.org/InStock',
            'seller' => array(
                '@type' => 'Organization',
                'name' => $provider_name
            )
        );
        
        // v2.9.10: aggregateRating - ONLY if real values are provided
        // Google supports aggregateRating for Service type
        // But fake/placeholder ratings are SPAM and will be penalized
        $service_rating = get_post_meta($post->ID, '_wseo_schema_rating_value', true);
        $service_rating_count = get_post_meta($post->ID, '_wseo_schema_rating_count', true);
        if ($service_rating && $service_rating_count && floatval($service_rating) > 0 && intval($service_rating_count) > 0) {
            $service_schema['aggregateRating'] = array(
                '@type' => 'AggregateRating',
                'ratingValue' => floatval($service_rating),
                'reviewCount' => intval($service_rating_count),
                'bestRating' => 5,
                'worstRating' => 1
            );
        }
        
        // v2.9.10: Removed fake self-review - this is SPAM
        // Reviews must be real user reviews, not auto-generated
        
        $image = get_the_post_thumbnail_url($post->ID, 'large');
        if ($image) {
            $service_schema['image'] = $image;
        }
        
        $this->output_schema($service_schema);
    }
    
    /**
     * Output Review Schema
     * v2.9.15: REMOVED - Self-serving reviews banned by Google since September 2019
     * Reviews on your own website about your own business/products are NOT eligible for rich results
     * See: https://developers.google.com/search/blog/2019/09/making-review-rich-results-more-helpful
     * 
     * How to get review stars in Google:
     * - Products: Use real customer reviews (WooCommerce reviews are OK)
     * - LocalBusiness: Google My Business, Facebook, TripAdvisor reviews
     * - Software: G2, Capterra, WordPress.org reviews
     */
    // private function output_review_schema() - REMOVED in v2.9.15
    
    /**
     * Output WebPage Schema for all pages
     */
    private function output_webpage_schema() {
        global $post;
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $meta_title = get_post_meta($post->ID, '_wseo_meta_title', true) ?: get_the_title();
        $meta_desc = get_post_meta($post->ID, '_wseo_meta_description', true) ?: $this->clean_post_content($post->post_content, WSEO_EXCERPT_WORDS);
        
        $webpage_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'WebPage',
            '@id' => get_permalink() . '#webpage',
            'url' => get_permalink(),
            'name' => $meta_title,
            'description' => $meta_desc,
            'isPartOf' => array(
                '@type' => 'WebSite',
                '@id' => home_url('/') . '#website',
                'name' => $site_name,
                'url' => home_url('/')
            ),
            'datePublished' => get_the_date('c'),
            'dateModified' => get_the_modified_date('c'),
            'inLanguage' => get_locale()
        );
        
        // Featured image
        $image = get_the_post_thumbnail_url($post->ID, 'large');
        if ($image) {
            $image_credit = get_post_meta($post->ID, '_wseo_image_credit', true);
            $image_license = get_post_meta($post->ID, '_wseo_image_license', true);
            $image_license_page = get_post_meta($post->ID, '_wseo_image_license_page', true);
            $image_creator = get_post_meta($post->ID, '_wseo_image_creator', true);
            $image_copyright_notice = get_post_meta($post->ID, '_wseo_image_copyright_notice', true);
            
            $image_schema = array(
                '@type' => 'ImageObject',
                'url' => $image,
                'contentUrl' => $image,
                'license' => $image_license ?: get_option('wseo_logo_license', 'https://creativecommons.org/licenses/by/4.0/'),
                'acquireLicensePage' => $image_license_page ?: get_option('wseo_logo_license_page', home_url('/image-licenses/')),
                'creditText' => $image_credit ?: get_option('wseo_logo_credit', get_bloginfo('name'))
            );
            
            // Name: use image alt text, fallback to post title
            $image_id = get_post_thumbnail_id($post->ID);
            $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
            $image_schema['name'] = $image_alt ?: get_the_title($post->ID);
            
            // Description: use image caption/description, fallback to excerpt
            $image_caption = wp_get_attachment_caption($image_id);
            $image_desc = get_post_field('post_content', $image_id);
            if ($image_caption) {
                $image_schema['description'] = $image_caption;
            } elseif ($image_desc) {
                $image_schema['description'] = wp_trim_words($image_desc, 30);
            } else {
                $image_schema['description'] = get_the_excerpt($post->ID) ?: wp_trim_words(get_the_title($post->ID), 20);
            }
            
            // Optional fields - use post meta first, then global settings, then fallback to creditText
            $creator = $image_creator ?: get_option('wseo_logo_creator', '');
            $creator_name = $creator ?: $image_schema['creditText']; // Fallback to creditText
            
            if (!empty($creator_name)) {
                $image_schema['creator'] = array(
                    '@type' => 'Person',
                    'name' => $creator_name
                );
                // Author is same as creator
                $image_schema['author'] = array(
                    '@type' => 'Person',
                    'name' => $creator_name
                );
            }
            
            $copyright = $image_copyright_notice ?: get_option('wseo_logo_copyright_notice', '');
            if (!empty($copyright)) {
                $image_schema['copyrightNotice'] = $copyright;
            } else {
                // Generate copyright notice
                $image_schema['copyrightNotice'] = '© ' . date('Y') . ' ' . $image_schema['creditText'];
            }
            
            $webpage_schema['primaryImageOfPage'] = $image_schema;
        }
        
        // Author (Person schema) - use centralized default settings
        $author_id = $post->post_author;
        
        // Priority 1: Post meta (custom override)
        $custom_author_name = get_post_meta($post->ID, '_wseo_author_name', true);
        $author_title = get_post_meta($post->ID, '_wseo_author_title', true);
        $author_url = get_post_meta($post->ID, '_wseo_author_url', true);
        $author_social = get_post_meta($post->ID, '_wseo_author_social', true);
        
        // Priority 2: Centralized default settings
        if (empty($custom_author_name)) {
            $custom_author_name = get_option('wseo_default_person_name', '');
        }
        if (empty($author_title)) {
            $author_title = get_option('wseo_default_person_jobtitle', '');
        }
        if (empty($author_url)) {
            $author_url = get_option('wseo_default_person_url', '');
        }
        if (empty($author_social)) {
            $author_social = get_option('wseo_default_person_social', '');
        }
        
        // Priority 3: WordPress user profile fallback
        $author_name = $custom_author_name ?: get_the_author_meta('display_name', $author_id);
        
        if (empty($author_title)) {
            $author_title = get_the_author_meta('user_description', $author_id);
            if (empty($author_title)) {
                $author_title = get_the_author_meta('nickname', $author_id);
            }
        }
        
        if (empty($author_social)) {
            $social_links = array();
            $twitter = get_the_author_meta('twitter', $author_id);
            $facebook = get_the_author_meta('facebook', $author_id);
            $linkedin = get_the_author_meta('linkedin', $author_id);
            $instagram = get_the_author_meta('instagram', $author_id);
            
            if ($twitter) $social_links[] = $twitter;
            if ($facebook) $social_links[] = $facebook;
            if ($linkedin) $social_links[] = $linkedin;
            if ($instagram) $social_links[] = $instagram;
            
            if (!empty($social_links)) {
                $author_social = implode("\n", $social_links);
            }
        }
        
        $webpage_schema['author'] = array(
            '@type' => 'Person',
            'name' => $author_name
        );
        
        // Author image - Priority: centralized setting > Gravatar
        $author_image = get_option('wseo_default_person_image', '');
        if (empty($author_image)) {
            $author_image = get_avatar_url($author_id, array('size' => 200));
        }
        
        if (!empty($author_image)) {
            $webpage_schema['author']['image'] = array(
                '@type' => 'ImageObject',
                'url' => $author_image,
                'contentUrl' => $author_image,
                'name' => $author_name . ' - Profile Photo',
                'description' => 'Profile photo of ' . $author_name,
                'creditText' => $author_name,
                'license' => 'https://creativecommons.org/licenses/by/4.0/',
                'acquireLicensePage' => home_url('/image-licenses/'),
                'creator' => array(
                    '@type' => 'Person',
                    'name' => $author_name
                ),
                'author' => array(
                    '@type' => 'Person',
                    'name' => $author_name
                ),
                'copyrightNotice' => '© ' . date('Y') . ' ' . $author_name
            );
        }
        
        // Author URL
        if (!empty($author_url)) {
            $webpage_schema['author']['url'] = $author_url;
        } else {
            $webpage_schema['author']['url'] = get_author_posts_url($author_id);
        }
        
        // Job Title (E-E-A-T) - always include if we have it
        if (!empty($author_title)) {
            $webpage_schema['author']['jobTitle'] = $author_title;
        }
        
        // Works for (Organization)
        $webpage_schema['author']['worksFor'] = array(
            '@type' => 'Organization',
            'name' => get_bloginfo('name'),
            'url' => home_url('/')
        );
        
        // Social profiles (sameAs) - always include if we have them
        if (!empty($author_social)) {
            $social_urls = array_filter(array_map('trim', explode("\n", $author_social)));
            if (!empty($social_urls)) {
                $webpage_schema['author']['sameAs'] = $social_urls;
            }
        }
        
        // Breadcrumb reference - always present since we output breadcrumbs for all pages
        $webpage_schema['breadcrumb'] = array(
            '@id' => (is_front_page() || is_home()) ? home_url('/') . '#breadcrumb' : get_permalink() . '#breadcrumb'
        );
        
        $this->output_schema($webpage_schema);
    }
    
    /**
     * Output SiteNavigationElement Schema
     */
    private function output_navigation_schema() {
        // Get primary menu
        $menu_locations = get_nav_menu_locations();
        $menu_id = isset($menu_locations['primary']) ? $menu_locations['primary'] : 
                   (isset($menu_locations['main']) ? $menu_locations['main'] : 
                   (isset($menu_locations['main-menu']) ? $menu_locations['main-menu'] : 0));
        
        if (!$menu_id) {
            // Try to get any menu
            $menus = wp_get_nav_menus();
            if (!empty($menus)) {
                $menu_id = $menus[0]->term_id;
            }
        }
        
        if (!$menu_id) return;
        
        $menu_items = wp_get_nav_menu_items($menu_id);
        if (empty($menu_items)) return;
        
        $nav_elements = array();
        foreach ($menu_items as $item) {
            // Only top-level items
            if ($item->menu_item_parent == 0) {
                $nav_elements[] = array(
                    '@type' => 'SiteNavigationElement',
                    '@id' => $item->url . '#navitem',
                    'name' => $item->title,
                    'url' => $item->url
                );
            }
        }
        
        if (!empty($nav_elements)) {
            $nav_schema = array(
                '@context' => WSEO_SCHEMA_CONTEXT,
                '@graph' => $nav_elements
            );
            $this->output_schema($nav_schema);
        }
    }

    /**
     * Output page-specific Schema.org
     */
    private function output_page_schema() {
        global $post;
        
        $schema_type = get_post_meta($post->ID, '_wseo_schema_type', true);
        if (empty($schema_type)) return; // Use global schema if not set
        
        $schema_name = get_post_meta($post->ID, '_wseo_schema_name', true) ?: get_the_title();
        $schema_desc = get_post_meta($post->ID, '_wseo_schema_description', true) ?: get_post_meta($post->ID, '_wseo_meta_description', true);
        
        $page_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => $schema_type,
            'name' => $schema_name,
            'url' => get_permalink(),
        );
        
        if ($schema_desc) {
            $page_schema['description'] = $schema_desc;
        }
        
        // Image - try post meta, then featured image, then global OG image
        $image = get_post_meta($post->ID, '_wseo_schema_image', true);
        if (!$image) {
            $image = get_the_post_thumbnail_url($post->ID, 'large');
        }
        // v2.9.9: Fallback to global OG image
        if (!$image) {
            $image = get_option('wseo_global_og_image', '');
        }
        // v2.9.9: Final fallback - try to find first image in content
        if (!$image) {
            preg_match('/<img[^>]+src=["\']([^"\']+)["\'][^>]*>/i', $post->post_content, $matches);
            if (!empty($matches[1])) {
                $image = $matches[1];
            }
        }
        if ($image) {
            $page_schema['image'] = $image;
        }
        
        // Contact for LocalBusiness types - use post meta with global fallback
        $phone = get_post_meta($post->ID, '_wseo_schema_phone', true);
        $email = get_post_meta($post->ID, '_wseo_schema_email', true);
        
        // v2.9.9: Fallback to global settings
        if (!$phone) $phone = get_option('wseo_schema_phone', '');
        if (!$email) $email = get_option('wseo_schema_email', '');
        
        if ($phone) $page_schema['telephone'] = $phone;
        if ($email) $page_schema['email'] = $email;
        
        // Address - use post meta with global fallback
        $street = get_post_meta($post->ID, '_wseo_schema_address', true);
        $city = get_post_meta($post->ID, '_wseo_schema_city', true);
        $zip = get_post_meta($post->ID, '_wseo_schema_zip', true);
        $country = get_post_meta($post->ID, '_wseo_schema_country', true);
        
        // v2.9.9: Fallback to global settings if post meta is empty
        if (!$street) $street = get_option('wseo_schema_address_street', '');
        if (!$city) $city = get_option('wseo_schema_address_city', '');
        if (!$zip) $zip = get_option('wseo_schema_address_zip', '');
        if (!$country) $country = get_option('wseo_schema_address_country', 'SK');
        
        if ($street || $city) {
            $address_schema = array(
                '@type' => 'PostalAddress',
                'addressCountry' => $country
            );
            // Only add fields with values
            if ($street) $address_schema['streetAddress'] = $street;
            if ($city) $address_schema['addressLocality'] = $city;
            if ($zip) $address_schema['postalCode'] = $zip;
            
            $page_schema['address'] = $address_schema;
        }
        
        // Geo - use post meta with global fallback
        $lat = get_post_meta($post->ID, '_wseo_schema_lat', true);
        $lng = get_post_meta($post->ID, '_wseo_schema_lng', true);
        
        // v2.9.9: Fallback to global geo
        if (!$lat) $lat = get_option('wseo_schema_geo_lat', '');
        if (!$lng) $lng = get_option('wseo_schema_geo_lng', '');
        
        if ($lat && $lng) {
            $page_schema['geo'] = array(
                '@type' => 'GeoCoordinates',
                'latitude' => $lat,
                'longitude' => $lng
            );
        }
        
        // Opening hours - v2.9.12: Only add for LocalBusiness types, use openingHoursSpecification
        // Service schema does NOT support openingHours field - removed to fix Google validation
        // v3.1: Complete list of all LocalBusiness subtypes
        $local_business_types = array(
            'LocalBusiness', 'Restaurant', 'Store', 'ProfessionalService', 
            'FinancialService', 'MedicalBusiness', 'LegalService', 'AutomotiveBusiness',
            'HomeAndConstructionBusiness', 'SportsActivityLocation', 'EntertainmentBusiness',
            'FoodEstablishment', 'HealthAndBeautyBusiness', 'LodgingBusiness',
            // All subtypes
            'Hotel', 'BedAndBreakfast', 'Campground', 'Hostel', 'Motel', 'Resort', 'SkiResort', 'VacationRental',
            'Bakery', 'BarOrPub', 'CafeOrCoffeeShop', 'FastFoodRestaurant', 'IceCreamShop', 'Winery', 'Brewery', 'Distillery',
            'BeautySalon', 'DaySpa', 'HairSalon', 'NailSalon', 'TattooParlor',
            'Dentist', 'Physician', 'Pharmacy', 'Optician', 'VeterinaryCare', 'MedicalClinic',
            'AutoDealer', 'AutoRepair', 'AutoBodyShop', 'AutoRental', 'AutoWash', 'GasStation',
            'Electrician', 'GeneralContractor', 'HVACBusiness', 'HousePainter', 'Locksmith', 'MovingCompany', 'Plumber', 'RoofingContractor',
            'MovieTheater', 'AmusementPark', 'ArtGallery', 'Casino', 'ComedyClub', 'NightClub',
            'ExerciseGym', 'GolfCourse', 'BowlingAlley', 'TennisComplex', 'PublicSwimmingPool', 'SportsClub', 'StadiumOrArena',
            'RealEstateAgent', 'TravelAgency', 'EmploymentAgency', 'AccountingService', 'InsuranceAgency', 'Attorney', 'Notary'
        );
        
        if (in_array($schema_type, $local_business_types)) {
            // v2.9.12: Use post meta with global fallback for day-by-day opening hours
            $day_mapping = array(
                'mon' => 'Monday', 'tue' => 'Tuesday', 'wed' => 'Wednesday',
                'thu' => 'Thursday', 'fri' => 'Friday', 'sat' => 'Saturday', 'sun' => 'Sunday'
            );
            $opening_hours_spec = array();
            
            foreach ($day_mapping as $key => $day_name) {
                // Try post meta first, then fallback to global settings
                $open = get_post_meta($post->ID, "_wseo_schema_hours_{$key}_open", true);
                $close = get_post_meta($post->ID, "_wseo_schema_hours_{$key}_close", true);
                
                // Fallback to global settings if not set on page
                if (!$open) $open = get_option("wseo_schema_hours_{$key}_open", '');
                if (!$close) $close = get_option("wseo_schema_hours_{$key}_close", '');
                
                if ($open && $close) {
                    $opening_hours_spec[] = array(
                        '@type' => 'OpeningHoursSpecification',
                        'dayOfWeek' => $day_name,
                        'opens' => $open,
                        'closes' => $close
                    );
                }
            }
            
            if (!empty($opening_hours_spec)) {
                $page_schema['openingHoursSpecification'] = $opening_hours_spec;
            }
        }
        
        // Price range - use post meta with global fallback
        $price_range = get_post_meta($post->ID, '_wseo_schema_price_range', true);
        
        // v2.9.9: Fallback to global price range
        if (!$price_range) $price_range = get_option('wseo_schema_price_range', '');
        
        if ($price_range) {
            $page_schema['priceRange'] = $price_range;
        }
        
        $this->output_schema($page_schema);
    }
    
    /**
     * Output Article Schema for blog posts
     */
    private function output_article_schema() {
        global $post;
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $meta_title = get_post_meta($post->ID, '_wseo_meta_title', true) ?: get_the_title();
        $meta_desc = get_post_meta($post->ID, '_wseo_meta_description', true) ?: $this->clean_post_content($post->post_content, WSEO_EXCERPT_WORDS);
        
        // Determine Article type based on organization type and post settings
        $org_type = get_option('wseo_schema_type', 'Organization');
        $article_type_override = get_post_meta($post->ID, '_wseo_article_type', true);
        
        // Auto-detect: NewsMediaOrganization → NewsArticle, otherwise BlogPosting
        if ($article_type_override) {
            $article_type = $article_type_override;
        } elseif ($org_type === 'NewsMediaOrganization') {
            $article_type = 'NewsArticle';
        } else {
            $article_type = 'BlogPosting';
        }
        
        $article_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => $article_type,
            'headline' => $meta_title,
            'description' => $meta_desc,
            'url' => get_permalink(),
            'datePublished' => get_the_date('c'),
            'dateModified' => get_the_modified_date('c'),
            'mainEntityOfPage' => array(
                '@type' => 'WebPage',
                '@id' => get_permalink()
            )
        );
        
        // Enhanced E-E-A-T Author Schema - use centralized default settings
        $author_id = $post->post_author;
        
        // Priority 1: Post meta (custom override)
        $custom_author_name = get_post_meta($post->ID, '_wseo_author_name', true);
        $author_title = get_post_meta($post->ID, '_wseo_author_title', true);
        $author_url = get_post_meta($post->ID, '_wseo_author_url', true);
        $author_social = get_post_meta($post->ID, '_wseo_author_social', true);
        
        // Priority 2: Centralized default settings
        if (empty($custom_author_name)) {
            $custom_author_name = get_option('wseo_default_person_name', '');
        }
        if (empty($author_title)) {
            $author_title = get_option('wseo_default_person_jobtitle', '');
        }
        if (empty($author_url)) {
            $author_url = get_option('wseo_default_person_url', '');
        }
        if (empty($author_social)) {
            $author_social = get_option('wseo_default_person_social', '');
        }
        
        // Priority 3: WordPress user profile fallback
        $author_name = $custom_author_name ?: get_the_author_meta('display_name', $author_id);
        
        if (empty($author_title)) {
            $author_title = get_the_author_meta('user_description', $author_id);
            if (empty($author_title)) {
                $author_title = get_the_author_meta('nickname', $author_id);
            }
        }
        
        if (empty($author_social)) {
            $social_links = array();
            $twitter = get_the_author_meta('twitter', $author_id);
            $facebook = get_the_author_meta('facebook', $author_id);
            $linkedin = get_the_author_meta('linkedin', $author_id);
            $instagram = get_the_author_meta('instagram', $author_id);
            
            if ($twitter) $social_links[] = $twitter;
            if ($facebook) $social_links[] = $facebook;
            if ($linkedin) $social_links[] = $linkedin;
            if ($instagram) $social_links[] = $instagram;
            
            if (!empty($social_links)) {
                $author_social = implode("\n", $social_links);
            }
        }
        
        $article_schema['author'] = array(
            '@type' => 'Person',
            'name' => $author_name
        );
        
        // Author image - Priority: centralized setting > Gravatar
        $author_image = get_option('wseo_default_person_image', '');
        if (empty($author_image)) {
            $author_image = get_avatar_url($author_id, array('size' => 200));
        }
        
        if (!empty($author_image)) {
            $article_schema['author']['image'] = array(
                '@type' => 'ImageObject',
                'url' => $author_image,
                'contentUrl' => $author_image,
                'name' => $author_name . ' - Profile Photo',
                'description' => 'Profile photo of ' . $author_name,
                'creditText' => $author_name,
                'license' => 'https://creativecommons.org/licenses/by/4.0/',
                'acquireLicensePage' => home_url('/image-licenses/'),
                'creator' => array(
                    '@type' => 'Person',
                    'name' => $author_name
                ),
                'author' => array(
                    '@type' => 'Person',
                    'name' => $author_name
                ),
                'copyrightNotice' => '© ' . date('Y') . ' ' . $author_name
            );
        }
        
        // Author URL
        if (!empty($author_url)) {
            $article_schema['author']['url'] = $author_url;
        } else {
            $article_schema['author']['url'] = get_author_posts_url($author_id);
        }
        
        // Job Title (E-E-A-T) - always include if we have it
        if (!empty($author_title)) {
            $article_schema['author']['jobTitle'] = $author_title;
        }
        
        // Works for (Organization)
        $article_schema['author']['worksFor'] = array(
            '@type' => 'Organization',
            'name' => get_bloginfo('name'),
            'url' => home_url('/')
        );
        
        // Social profiles (sameAs) - always include if we have them
        if (!empty($author_social)) {
            $social_urls = array_filter(array_map('trim', explode("\n", $author_social)));
            if (!empty($social_urls)) {
                $article_schema['author']['sameAs'] = $social_urls;
            }
        }
        
        // Publisher
        $logo = get_option('wseo_schema_logo', '');
        $article_schema['publisher'] = array(
            '@type' => 'Organization',
            'name' => $site_name,
            'url' => home_url('/')
        );
        if ($logo) {
            $publisher_logo_schema = array(
                '@type' => 'ImageObject',
                'url' => $logo,
                'contentUrl' => $logo,
                'license' => get_option('wseo_logo_license', 'https://creativecommons.org/licenses/by/4.0/'),
                'acquireLicensePage' => get_option('wseo_logo_license_page', home_url('/image-licenses/')),
                'creditText' => get_option('wseo_logo_credit', get_bloginfo('name'))
            );
            
            // Name & Description
            $logo_name = get_option('wseo_schema_name', '') ?: get_bloginfo('name');
            $publisher_logo_schema['name'] = $logo_name . ' Logo';
            $publisher_logo_schema['description'] = 'Official logo of ' . $logo_name;
            
            // Creator & Author: use wseo_logo_creator if set, otherwise use creditText
            $logo_creator = get_option('wseo_logo_creator', '');
            $creator_name = $logo_creator ?: $publisher_logo_schema['creditText']; // Fallback to creditText
            
            if (!empty($creator_name)) {
                $publisher_logo_schema['creator'] = array(
                    '@type' => 'Person',
                    'name' => $creator_name
                );
                $publisher_logo_schema['author'] = array(
                    '@type' => 'Person',
                    'name' => $creator_name
                );
            }
            
            // Copyright: use wseo_logo_copyright_notice if set, otherwise generate
            $logo_copyright = get_option('wseo_logo_copyright_notice', '');
            if (!empty($logo_copyright)) {
                $publisher_logo_schema['copyrightNotice'] = $logo_copyright;
            } else {
                $publisher_logo_schema['copyrightNotice'] = '© ' . date('Y') . ' ' . $publisher_logo_schema['creditText'];
            }
            
            $article_schema['publisher']['logo'] = $publisher_logo_schema;
        }
        
        // Featured image
        $image = get_the_post_thumbnail_url($post->ID, 'large');
        if ($image) {
            $image_credit = get_post_meta($post->ID, '_wseo_image_credit', true);
            $image_license = get_post_meta($post->ID, '_wseo_image_license', true);
            $image_license_page = get_post_meta($post->ID, '_wseo_image_license_page', true);
            $image_creator = get_post_meta($post->ID, '_wseo_image_creator', true);
            $image_copyright_notice = get_post_meta($post->ID, '_wseo_image_copyright_notice', true);
            
            $image_schema = array(
                '@type' => 'ImageObject',
                'url' => $image,
                'contentUrl' => $image,
                'license' => $image_license ?: get_option('wseo_logo_license', 'https://creativecommons.org/licenses/by/4.0/'),
                'acquireLicensePage' => $image_license_page ?: get_option('wseo_logo_license_page', home_url('/image-licenses/')),
                'creditText' => $image_credit ?: get_option('wseo_logo_credit', get_bloginfo('name'))
            );
            
            // Name: use image alt text, fallback to post title
            $image_id = get_post_thumbnail_id($post->ID);
            $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
            $image_schema['name'] = $image_alt ?: get_the_title($post->ID);
            
            // Description: use image caption/description, fallback to excerpt
            $image_caption = wp_get_attachment_caption($image_id);
            $image_desc = get_post_field('post_content', $image_id);
            if ($image_caption) {
                $image_schema['description'] = $image_caption;
            } elseif ($image_desc) {
                $image_schema['description'] = wp_trim_words($image_desc, 30);
            } else {
                $image_schema['description'] = get_the_excerpt($post->ID) ?: wp_trim_words(get_the_title($post->ID), 20);
            }
            
            // AI-Generated Image Marking (2026 Standard)
            $is_ai_image = get_post_meta($post->ID, '_wseo_image_ai_generated', true);
            if ($is_ai_image === '1') {
                $image_schema['creator'] = array(
                    '@type' => 'Organization',
                    'name' => 'AI Image Generator'
                );
                $image_schema['author'] = array(
                    '@type' => 'Organization',
                    'name' => 'AI Image Generator'
                );
                $image_schema['copyrightNotice'] = 'AI-generated content';
                // Pre AI obrázky môže byť iná licencia
                if (!$image_license) {
                    $image_schema['license'] = 'https://creativecommons.org/publicdomain/zero/1.0/';
                }
            } else {
                // Optional fields for non-AI images - use post meta first, then global settings, then fallback to creditText
                $creator = $image_creator ?: get_option('wseo_logo_creator', '');
                $creator_name = $creator ?: $image_schema['creditText']; // Fallback to creditText
                
                if (!empty($creator_name)) {
                    $image_schema['creator'] = array(
                        '@type' => 'Person',
                        'name' => $creator_name
                    );
                    $image_schema['author'] = array(
                        '@type' => 'Person',
                        'name' => $creator_name
                    );
                }
                
                $copyright = $image_copyright_notice ?: get_option('wseo_logo_copyright_notice', '');
                if (!empty($copyright)) {
                    $image_schema['copyrightNotice'] = $copyright;
                } else {
                    // Generate copyright notice
                    $image_schema['copyrightNotice'] = '© ' . date('Y') . ' ' . $image_schema['creditText'];
                }
            }
            
            $article_schema['image'] = $image_schema;
        }
        
        // AI Content Marking (2026 Standard)
        $is_ai_content = get_post_meta($post->ID, '_wseo_ai_generated', true);
        $ai_source = get_post_meta($post->ID, '_wseo_ai_source', true);
        
        if ($is_ai_content === '1') {
            // Mark as AI-assisted or AI-generated
            $article_schema['creativeWorkStatus'] = 'AI-Assisted';
            
            // Add isBasedOn for AI-derived content
            if ($ai_source) {
                $article_schema['isBasedOn'] = array(
                    '@type' => 'CreativeWork',
                    'name' => 'AI Language Model',
                    'description' => $ai_source
                );
            }
            
            // Add comment about AI usage
            $article_schema['comment'] = array(
                '@type' => 'Comment',
                'text' => 'This content was created with AI assistance and human oversight.'
            );
        }
        
        // Word count
        $word_count = str_word_count(strip_tags($post->post_content));
        $article_schema['wordCount'] = $word_count;
        
        // Categories as keywords
        $categories = get_the_category($post->ID);
        if (!empty($categories)) {
            $keywords = array();
            foreach ($categories as $cat) {
                $keywords[] = $cat->name;
            }
            $article_schema['keywords'] = implode(', ', $keywords);
        }
        
        // v3.1: Speakable Schema for AI/LLM and Voice Search
        // Marks content sections suitable for text-to-speech (TTS) playback
        $enable_speakable = get_option('wseo_enable_speakable', '1'); // Enabled by default
        $speakable_mode = get_option('wseo_speakable_mode', 'auto'); // auto, manual, css
        
        if ($enable_speakable === '1') {
            $speakable_selectors = array();
            
            if ($speakable_mode === 'manual') {
                // Manual mode: Use custom CSS selectors from post meta or global settings
                $custom_selectors = get_post_meta($post->ID, '_wseo_speakable_selectors', true);
                if (empty($custom_selectors)) {
                    $custom_selectors = get_option('wseo_speakable_selectors', '');
                }
                if (!empty($custom_selectors)) {
                    $speakable_selectors = array_map('trim', explode(',', $custom_selectors));
                }
            } elseif ($speakable_mode === 'css') {
                // CSS mode: Target specific CSS classes
                $css_classes = get_option('wseo_speakable_css_classes', '.speakable, .voice-content');
                $speakable_selectors = array_map('trim', explode(',', $css_classes));
            } else {
                // Auto mode (default): Use headline and excerpt/summary
                $speakable_selectors = array(
                    '.entry-title',      // Common theme title class
                    '.post-title',       // Alternative title class
                    'h1',                // Fallback to h1
                    '.entry-summary',    // Excerpt
                    '.post-excerpt',     // Alternative excerpt
                    '.entry-content p:first-of-type' // First paragraph as summary
                );
            }
            
            if (!empty($speakable_selectors)) {
                $article_schema['speakable'] = array(
                    '@type' => 'SpeakableSpecification',
                    'cssSelector' => $speakable_selectors
                );
            }
        }
        
        $this->output_schema($article_schema);
    }
    
    /**
     * Output Product Schema for WooCommerce products
     * v2.8.10 - Complete schema with all Google 2026 required fields
     */
    private function output_product_schema() {
        global $post;
        
        if (!function_exists('wc_get_product')) return;
        
        $product = wc_get_product($post->ID);
        if (!$product) return;
        
        // v2.9.17 - WooCommerce Product Schema with ALL Google 2025/2026 fields:
        // - shippingDetails (in offers) - REQUIRED for Merchant Listings
        // - hasMerchantReturnPolicy (in offers) - REQUIRED for Merchant Listings  
        // - returnPolicyCountry - NEW REQUIRED field (March 2025)
        // - aggregateRating & review - only if REAL reviews exist
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $country_code = $this->get_country_code();
        $currency = get_woocommerce_currency();
        
        $product_schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'Product',
            'name' => $product->get_name(),
            'description' => $product->get_short_description() ?: wp_trim_words(strip_tags($product->get_description()), WSEO_EXCERPT_WORDS),
            'url' => get_permalink(),
            'brand' => array(
                '@type' => 'Brand',
                'name' => $site_name
            )
        );
        
        // SKU - only if exists
        $sku = $product->get_sku();
        if (!empty($sku)) {
            $product_schema['sku'] = $sku;
        }
        
        // Product image
        $image_id = $product->get_image_id();
        if ($image_id) {
            $image_url = wp_get_attachment_url($image_id);
            $product_schema['image'] = $image_url;
        }
        
        // Price / Offers - CRITICAL section with shippingDetails and hasMerchantReturnPolicy
        $price = $product->get_price();
        if ($price) {
            $product_schema['offers'] = array(
                '@type' => 'Offer',
                'url' => get_permalink(),
                'itemCondition' => 'https://schema.org/NewCondition',
                'availability' => $product->is_in_stock() ? 'https://schema.org/InStock' : 'https://schema.org/OutOfStock',
                'price' => $price,
                'priceCurrency' => $currency,
                'priceValidUntil' => date('Y-m-d', strtotime('+1 year')),
                'seller' => array(
                    '@type' => 'Organization',
                    'name' => $site_name
                ),
                
                // shippingDetails - REQUIRED by Google Merchant Listings 2025+
                'shippingDetails' => array(
                    '@type' => 'OfferShippingDetails',
                    'shippingRate' => array(
                        '@type' => 'MonetaryAmount',
                        'value' => '0',
                        'currency' => $currency
                    ),
                    'shippingDestination' => array(
                        '@type' => 'DefinedRegion',
                        'addressCountry' => $country_code
                    ),
                    'deliveryTime' => array(
                        '@type' => 'ShippingDeliveryTime',
                        'handlingTime' => array(
                            '@type' => 'QuantitativeValue',
                            'minValue' => 0,
                            'maxValue' => 1,
                            'unitCode' => 'DAY'
                        ),
                        'transitTime' => array(
                            '@type' => 'QuantitativeValue',
                            'minValue' => 1,
                            'maxValue' => 5,
                            'unitCode' => 'DAY'
                        )
                    )
                ),
                
                // hasMerchantReturnPolicy - REQUIRED by Google Merchant Listings 2025+
                // returnPolicyCountry is NOW REQUIRED (March 2025 update)
                'hasMerchantReturnPolicy' => array(
                    '@type' => 'MerchantReturnPolicy',
                    'applicableCountry' => $country_code,
                    'returnPolicyCountry' => $country_code, // NEW REQUIRED field
                    'returnPolicyCategory' => 'https://schema.org/MerchantReturnFiniteReturnWindow',
                    'merchantReturnDays' => 14,
                    'returnMethod' => 'https://schema.org/ReturnByMail',
                    'returnFees' => 'https://schema.org/FreeReturn'
                )
            );
        }
        
        // Reviews and Rating - ONLY if REAL reviews exist
        $review_count = $product->get_review_count();
        $average_rating = $product->get_average_rating();
        
        // v2.9.17: Google requires REAL reviews - fake reviews = SPAM penalty
        if ($review_count > 0 && floatval($average_rating) > 0) {
            $product_schema['aggregateRating'] = array(
                '@type' => 'AggregateRating',
                'ratingValue' => number_format(floatval($average_rating), 1),
                'reviewCount' => intval($review_count),
                'bestRating' => '5',
                'worstRating' => '1'
            );
            
            // Get actual reviews
            $reviews = get_comments(array(
                'post_id' => $post->ID,
                'status' => 'approve',
                'type' => 'review',
                'number' => 10
            ));
            
            if (!empty($reviews)) {
                $product_schema['review'] = array();
                foreach ($reviews as $review) {
                    $rating = get_comment_meta($review->comment_ID, 'rating', true);
                    $product_schema['review'][] = array(
                        '@type' => 'Review',
                        'reviewRating' => array(
                            '@type' => 'Rating',
                            'ratingValue' => $rating ?: '5',
                            'bestRating' => '5',
                            'worstRating' => '1'
                        ),
                        'author' => array(
                            '@type' => 'Person',
                            'name' => $review->comment_author
                        ),
                        'reviewBody' => $review->comment_content,
                        'datePublished' => get_comment_date('c', $review)
                    );
                }
            }
        }
        // Note: If no reviews exist, we DON'T add fake aggregateRating/review
        // Google will just show the product without stars - this is CORRECT behavior
        
        $this->output_schema($product_schema);
    }
    
    /**
     * Output Breadcrumbs Schema
     */
    private function output_breadcrumbs_schema() {
        // CRITICAL: Always output breadcrumbs schema (ignore settings to prevent Google errors)
        
        $breadcrumbs = $this->get_breadcrumbs();
        
        // Build items array
        $items = array();
        $position = 1;
        
        if (!empty($breadcrumbs)) {
            foreach ($breadcrumbs as $crumb) {
                // Skip if name or URL is invalid
                if (empty($crumb['name']) || empty($crumb['url'])) {
                    continue;
                }
                
                $items[] = array(
                    '@type' => 'ListItem',
                    'position' => $position,
                    'name' => $crumb['name'],
                    'item' => $crumb['url']
                );
                $position++;
            }
        }
        
        // CRITICAL FAILSAFE: If no items, force Home
        if (empty($items)) {
            $items = array(
                array(
                    '@type' => 'ListItem',
                    'position' => 1,
                    'name' => get_option('wseo_breadcrumb_home', 'Domov'),
                    'item' => home_url('/')
                )
            );
        }
        
        // Build schema - itemListElement is GUARANTEED to have at least 1 item
        // v2.9.17: Use home_url for homepage to match WebPage breadcrumb reference
        $breadcrumb_id = (is_front_page() || is_home()) ? home_url('/') . '#breadcrumb' : get_permalink() . '#breadcrumb';
        
        $schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'BreadcrumbList',
            '@id' => $breadcrumb_id,
            'name' => 'Breadcrumbs',
            'itemListElement' => $items
        );
        
        $this->output_schema($schema);
    }
    
    /**
     * Get breadcrumbs array
     */
    private function get_breadcrumbs() {
        $breadcrumbs = array();
        
        // Always start with Home
        $breadcrumbs[] = array(
            'name' => get_option('wseo_breadcrumb_home', 'Domov'),
            'url' => home_url('/')
        );
        
        // Handle different content types
        if (is_singular()) {
            global $post;
            
            // WooCommerce Product
            if (is_singular('product') && class_exists('WooCommerce')) {
                // Shop page
                $shop_page_id = wc_get_page_id('shop');
                if ($shop_page_id > 0) {
                    $breadcrumbs[] = array(
                        'name' => get_the_title($shop_page_id),
                        'url' => get_permalink($shop_page_id)
                    );
                }
                
                // Product category
                $terms = get_the_terms($post->ID, 'product_cat');
                if ($terms && !is_wp_error($terms)) {
                    // Get primary category or first one
                    $primary_term = $this->get_primary_term($post->ID, 'product_cat', $terms);
                    if ($primary_term) {
                        // Add parent categories
                        $ancestors = get_ancestors($primary_term->term_id, 'product_cat');
                        $ancestors = array_reverse($ancestors);
                        foreach ($ancestors as $ancestor_id) {
                            $ancestor = get_term($ancestor_id, 'product_cat');
                            if ($ancestor && !is_wp_error($ancestor)) {
                                $breadcrumbs[] = array(
                                    'name' => $ancestor->name,
                                    'url' => get_term_link($ancestor)
                                );
                            }
                        }
                        $breadcrumbs[] = array(
                            'name' => $primary_term->name,
                            'url' => get_term_link($primary_term)
                        );
                    }
                }
                
                // Product
                $breadcrumbs[] = array(
                    'name' => get_the_title(),
                    'url' => get_permalink()
                );
                
            // Blog Post
            } elseif (is_singular('post')) {
                // Blog page
                $blog_page_id = get_option('page_for_posts');
                if ($blog_page_id > 0) {
                    $breadcrumbs[] = array(
                        'name' => get_the_title($blog_page_id),
                        'url' => get_permalink($blog_page_id)
                    );
                }
                
                // Category
                $categories = get_the_category($post->ID);
                if (!empty($categories)) {
                    $primary_cat = $this->get_primary_term($post->ID, 'category', $categories);
                    if ($primary_cat) {
                        // Add parent categories
                        $ancestors = get_ancestors($primary_cat->term_id, 'category');
                        $ancestors = array_reverse($ancestors);
                        foreach ($ancestors as $ancestor_id) {
                            $ancestor = get_term($ancestor_id, 'category');
                            if ($ancestor && !is_wp_error($ancestor)) {
                                $breadcrumbs[] = array(
                                    'name' => $ancestor->name,
                                    'url' => get_term_link($ancestor)
                                );
                            }
                        }
                        $breadcrumbs[] = array(
                            'name' => $primary_cat->name,
                            'url' => get_term_link($primary_cat)
                        );
                    }
                }
                
                // Post
                $breadcrumbs[] = array(
                    'name' => get_the_title(),
                    'url' => get_permalink()
                );
                
            // Page
            } elseif (is_page()) {
                // Parent pages
                $ancestors = get_ancestors($post->ID, 'page');
                $ancestors = array_reverse($ancestors);
                foreach ($ancestors as $ancestor_id) {
                    $breadcrumbs[] = array(
                        'name' => get_the_title($ancestor_id),
                        'url' => get_permalink($ancestor_id)
                    );
                }
                
                // Current page
                $breadcrumbs[] = array(
                    'name' => get_the_title(),
                    'url' => get_permalink()
                );
                
            // Custom Post Type
            } else {
                $post_type = get_post_type();
                $post_type_obj = get_post_type_object($post_type);
                
                // Archive page
                if ($post_type_obj && $post_type_obj->has_archive) {
                    $breadcrumbs[] = array(
                        'name' => $post_type_obj->labels->name,
                        'url' => get_post_type_archive_link($post_type)
                    );
                }
                
                // Current post
                $breadcrumbs[] = array(
                    'name' => get_the_title(),
                    'url' => get_permalink()
                );
            }
            
        // Category
        } elseif (is_category()) {
            $category = get_queried_object();
            
            // Blog page
            $blog_page_id = get_option('page_for_posts');
            if ($blog_page_id > 0) {
                $breadcrumbs[] = array(
                    'name' => get_the_title($blog_page_id),
                    'url' => get_permalink($blog_page_id)
                );
            }
            
            // Parent categories
            $ancestors = get_ancestors($category->term_id, 'category');
            $ancestors = array_reverse($ancestors);
            foreach ($ancestors as $ancestor_id) {
                $ancestor = get_term($ancestor_id, 'category');
                if ($ancestor && !is_wp_error($ancestor)) {
                    $breadcrumbs[] = array(
                        'name' => $ancestor->name,
                        'url' => get_term_link($ancestor)
                    );
                }
            }
            
            // Current category
            $breadcrumbs[] = array(
                'name' => $category->name,
                'url' => get_term_link($category)
            );
            
        // Tag
        } elseif (is_tag()) {
            $tag = get_queried_object();
            
            $breadcrumbs[] = array(
                'name' => $tag->name,
                'url' => get_term_link($tag)
            );
            
        // Product Category (WooCommerce)
        } elseif (is_tax('product_cat')) {
            $term = get_queried_object();
            
            // Shop page
            $shop_page_id = wc_get_page_id('shop');
            if ($shop_page_id > 0) {
                $breadcrumbs[] = array(
                    'name' => get_the_title($shop_page_id),
                    'url' => get_permalink($shop_page_id)
                );
            }
            
            // Parent categories
            $ancestors = get_ancestors($term->term_id, 'product_cat');
            $ancestors = array_reverse($ancestors);
            foreach ($ancestors as $ancestor_id) {
                $ancestor = get_term($ancestor_id, 'product_cat');
                if ($ancestor && !is_wp_error($ancestor)) {
                    $breadcrumbs[] = array(
                        'name' => $ancestor->name,
                        'url' => get_term_link($ancestor)
                    );
                }
            }
            
            // Current category
            $breadcrumbs[] = array(
                'name' => $term->name,
                'url' => get_term_link($term)
            );
            
        // Other taxonomy
        } elseif (is_tax()) {
            $term = get_queried_object();
            $taxonomy = get_taxonomy($term->taxonomy);
            
            // Parent terms
            $ancestors = get_ancestors($term->term_id, $term->taxonomy);
            $ancestors = array_reverse($ancestors);
            foreach ($ancestors as $ancestor_id) {
                $ancestor = get_term($ancestor_id, $term->taxonomy);
                if ($ancestor && !is_wp_error($ancestor)) {
                    $breadcrumbs[] = array(
                        'name' => $ancestor->name,
                        'url' => get_term_link($ancestor)
                    );
                }
            }
            
            // Current term
            $breadcrumbs[] = array(
                'name' => $term->name,
                'url' => get_term_link($term)
            );
        }
        
        return $breadcrumbs;
    }
    
    /**
     * Get primary term (for Yoast SEO compatibility or first term)
     */
    private function get_primary_term($post_id, $taxonomy, $terms) {
        // Check for Yoast primary term
        $primary_term_id = get_post_meta($post_id, '_yoast_wpseo_primary_' . $taxonomy, true);
        if ($primary_term_id) {
            foreach ($terms as $term) {
                if ($term->term_id == $primary_term_id) {
                    return $term;
                }
            }
        }
        
        // Check for Rank Math primary term
        $primary_term_id = get_post_meta($post_id, 'rank_math_primary_' . $taxonomy, true);
        if ($primary_term_id) {
            foreach ($terms as $term) {
                if ($term->term_id == $primary_term_id) {
                    return $term;
                }
            }
        }
        
        // Return first term
        return !empty($terms) ? $terms[0] : null;
    }
    
    /**
     * =====================================================
     * REMOVE /CATEGORY/ AND /TAG/ FROM URLs
     * =====================================================
     */
    
    /**
     * Remove category and tag base from permalinks
     */
    public function remove_category_tag_base() {
        // Check if enabled (default: enabled)
        if (get_option('wseo_remove_category_base', '1') !== '1') {
            return;
        }
        
        // Hook into template_redirect to handle category pages
        add_action('template_redirect', array($this, 'handle_category_request'), 1);
    }
    
    /**
     * v2.10.20: Initialize product base removal
     */
    public function remove_product_base() {
        if (!class_exists('WooCommerce')) {
            return;
        }
        
        if (get_option('wseo_remove_product_base', '0') !== '1') {
            return;
        }
        
        // Add rewrite rules for products without base
        add_action('template_redirect', array($this, 'handle_product_request'), 1);
    }
    
    /**
     * v2.10.20: Handle product request without base prefix
     */
    public function handle_product_request() {
        if (!is_404()) {
            return;
        }
        
        global $wp;
        $request = $wp->request;
        
        if (empty($request)) {
            return;
        }
        
        // Don't process if it contains slashes (could be category/subcategory)
        if (strpos($request, '/') !== false) {
            return;
        }
        
        // Check if it's a product
        $product = get_page_by_path($request, OBJECT, 'product');
        
        if ($product && $product->post_status === 'publish') {
            global $wp_query, $post;
            
            $wp_query = new WP_Query(array(
                'post_type' => 'product',
                'name' => $request,
                'posts_per_page' => 1
            ));
            
            if ($wp_query->have_posts()) {
                $wp_query->the_post();
                $post = $wp_query->post;
                
                $wp_query->is_singular = true;
                $wp_query->is_single = true;
                $wp_query->is_404 = false;
                $wp_query->queried_object = $post;
                $wp_query->queried_object_id = $post->ID;
                
                status_header(200);
                wp_reset_postdata();
            }
        }
    }
    
    /**
     * v2.10.20: Remove product base from product links
     */
    public function remove_product_base_from_link($permalink, $post) {
        if (!class_exists('WooCommerce')) {
            return $permalink;
        }
        
        if (get_option('wseo_remove_product_base', '0') !== '1') {
            return $permalink;
        }
        
        if ($post->post_type !== 'product') {
            return $permalink;
        }
        
        // Get WooCommerce product base
        $wc_permalinks = get_option('woocommerce_permalinks', array());
        $product_base = isset($wc_permalinks['product_base']) ? trim($wc_permalinks['product_base'], '/') : 'product';
        
        if (empty($product_base)) {
            $product_base = 'product';
        }
        
        // Remove product base from permalink
        $permalink = str_replace('/' . $product_base . '/', '/', $permalink);
        
        return $permalink;
    }
    
    /**
     * v2.10.21: Initialize product category base removal
     */
    public function remove_product_cat_base() {
        if (!class_exists('WooCommerce')) {
            return;
        }
        
        if (get_option('wseo_remove_product_cat_base', '0') !== '1') {
            return;
        }
        
        // Add rewrite rules for product categories without base
        add_action('template_redirect', array($this, 'handle_product_cat_request'), 1);
    }
    
    /**
     * v2.10.21: Handle product category request without base prefix
     */
    public function handle_product_cat_request() {
        if (!is_404()) {
            return;
        }
        
        global $wp;
        $request = $wp->request;
        
        if (empty($request)) {
            return;
        }
        
        // Remove pagination
        $request_clean = preg_replace('/\/page\/\d+\/?$/', '', $request);
        $paged = 1;
        if (preg_match('/\/page\/(\d+)\/?$/', $request, $matches)) {
            $paged = intval($matches[1]);
        }
        
        // Check if it's a product category (support hierarchical)
        $term = get_term_by('slug', basename($request_clean), 'product_cat');
        
        // If not found by basename, try full path for hierarchical categories
        if (!$term) {
            $term = $this->get_product_cat_by_path($request_clean);
        }
        
        if ($term && !is_wp_error($term)) {
            global $wp_query;
            
            $wp_query = new WP_Query(array(
                'post_type' => 'product',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $term->term_id
                    )
                ),
                'paged' => $paged
            ));
            
            $wp_query->is_tax = true;
            $wp_query->is_archive = true;
            $wp_query->is_404 = false;
            $wp_query->queried_object = $term;
            $wp_query->queried_object_id = $term->term_id;
            
            status_header(200);
        }
    }
    
    /**
     * v2.10.21: Get product category by path (for hierarchical categories)
     */
    private function get_product_cat_by_path($path) {
        $slugs = explode('/', trim($path, '/'));
        $term = null;
        $parent = 0;
        
        foreach ($slugs as $slug) {
            $term = get_term_by('slug', $slug, 'product_cat');
            if ($term && $term->parent == $parent) {
                $parent = $term->term_id;
            } else {
                // Try without parent check for non-hierarchical match
                $term = get_term_by('slug', $slug, 'product_cat');
                if ($term) {
                    return $term;
                }
                return null;
            }
        }
        
        return $term;
    }
    
    /**
     * v2.10.21: Remove product category base from links
     */
    public function remove_product_cat_base_from_link($link, $term, $taxonomy) {
        if ($taxonomy !== 'product_cat') {
            return $link;
        }
        
        if (get_option('wseo_remove_product_cat_base', '0') !== '1') {
            return $link;
        }
        
        // Get WooCommerce category base
        $wc_permalinks = get_option('woocommerce_permalinks', array());
        $category_base = isset($wc_permalinks['category_base']) ? trim($wc_permalinks['category_base'], '/') : 'product-category';
        
        if (empty($category_base)) {
            $category_base = 'product-category';
        }
        
        // Also check for Slovak/other language versions
        $category_bases = array($category_base, 'kategoria-produktu', 'produkt-kategoria', 'product-category', 'produktkategorie', 'categorie-produit');
        
        foreach ($category_bases as $base) {
            $link = str_replace('/' . $base . '/', '/', $link);
        }
        
        return $link;
    }
    
    /**
     * v2.10.21: Redirect old product category URLs
     */
    public function handle_product_cat_redirect() {
        if (!class_exists('WooCommerce')) {
            return;
        }
        
        if (get_option('wseo_remove_product_cat_base', '0') !== '1') {
            return;
        }
        
        $request_uri = $_SERVER['REQUEST_URI'] ?? '';
        $request_path = parse_url($request_uri, PHP_URL_PATH);
        
        // Common product category bases in different languages
        $category_bases = array('kategoria-produktu', 'produkt-kategoria', 'product-category', 'produktkategorie', 'categorie-produit', 'categoria-producto', 'categoria-prodotto');
        
        foreach ($category_bases as $base) {
            if (preg_match('#^/' . preg_quote($base, '#') . '/(.+)$#', $request_path, $matches)) {
                $category_slug = rtrim($matches[1], '/');
                
                // Check if category exists
                $term = get_term_by('slug', basename($category_slug), 'product_cat');
                if (!$term) {
                    $term = $this->get_product_cat_by_path($category_slug);
                }
                
                if ($term) {
                    $new_url = home_url('/' . $category_slug . '/');
                    wp_redirect($new_url, 301);
                    exit;
                }
            }
        }
    }
    
    /**
     * Handle category/tag request without base
     */
    public function handle_category_request() {
        // Skip if already found something
        if (!is_404()) {
            return;
        }
        
        global $wp;
        $request = $wp->request;
        
        if (empty($request)) {
            return;
        }
        
        // Remove pagination
        $request_clean = preg_replace('/\/page\/\d+\/?$/', '', $request);
        $paged = 1;
        if (preg_match('/\/page\/(\d+)\/?$/', $request, $matches)) {
            $paged = intval($matches[1]);
        }
        
        // Check if it's a category (check with full path for hierarchical)
        if (get_option('wseo_remove_category_base', '1') === '1') {
            $category = get_category_by_path($request_clean, true);
            
            if ($category && !is_wp_error($category)) {
                // It's a category - do the query
                global $wp_query;
                
                $wp_query = new WP_Query(array(
                    'category_name' => $category->slug,
                    'paged' => $paged
                ));
                
                // Set is_category flags
                $wp_query->is_category = true;
                $wp_query->is_archive = true;
                $wp_query->is_404 = false;
                $wp_query->queried_object = $category;
                $wp_query->queried_object_id = $category->term_id;
                
                // Set status
                status_header(200);
                
                return;
            }
        }
        
        // Check if it's a tag
        if (get_option('wseo_remove_tag_base', '1') === '1') {
            $tag = get_term_by('slug', $request_clean, 'post_tag');
            
            if ($tag && !is_wp_error($tag)) {
                // It's a tag - do the query
                global $wp_query;
                
                $wp_query = new WP_Query(array(
                    'tag' => $tag->slug,
                    'paged' => $paged
                ));
                
                // Set is_tag flags
                $wp_query->is_tag = true;
                $wp_query->is_archive = true;
                $wp_query->is_404 = false;
                $wp_query->queried_object = $tag;
                $wp_query->queried_object_id = $tag->term_id;
                
                // Set status
                status_header(200);
                
                return;
            }
        }
    }
    
    /**
     * Filter category link to remove /category/ base
     */
    public function remove_category_base_from_link($link, $term, $taxonomy) {
        if ($taxonomy !== 'category') {
            return $link;
        }
        
        if (get_option('wseo_remove_category_base', '1') !== '1') {
            return $link;
        }
        
        // Get category base
        $category_base = get_option('category_base');
        if (empty($category_base)) {
            $category_base = 'category';
        }
        
        // Remove category base from link
        $link = str_replace('/' . $category_base . '/', '/', $link);
        
        return $link;
    }
    
    /**
     * Filter tag link to remove /tag/ base
     */
    public function remove_tag_base_from_link($link, $term, $taxonomy) {
        if ($taxonomy !== 'post_tag') {
            return $link;
        }
        
        if (get_option('wseo_remove_tag_base', '1') !== '1') {
            return $link;
        }
        
        // Get tag base
        $tag_base = get_option('tag_base');
        if (empty($tag_base)) {
            $tag_base = 'tag';
        }
        
        // Remove tag base from link
        $link = str_replace('/' . $tag_base . '/', '/', $link);
        
        return $link;
    }
    
    /**
     * Redirect old /category/ URLs to new clean URLs
     */
    public function redirect_old_category_urls($query_vars) {
        // Check if this is an old /category/ URL
        $request_uri = $_SERVER['REQUEST_URI'] ?? '';
        
        if (get_option('wseo_remove_category_base', '1') === '1') {
            if (preg_match('/\/category\/(.+?)(\/page\/\d+)?\/?$/', $request_uri, $matches)) {
                $category_slug = trim($matches[1], '/');
                $page = isset($matches[2]) ? $matches[2] : '';
                
                // 301 redirect to new URL
                $new_url = home_url('/' . $category_slug . $page . '/');
                wp_redirect($new_url, 301);
                exit;
            }
        }
        
        // Check if this is an old /tag/ URL
        if (get_option('wseo_remove_tag_base', '1') === '1') {
            if (preg_match('/\/tag\/(.+?)(\/page\/\d+)?\/?$/', $request_uri, $matches)) {
                $tag_slug = trim($matches[1], '/');
                $page = isset($matches[2]) ? $matches[2] : '';
                
                $new_url = home_url('/' . $tag_slug . $page . '/');
                wp_redirect($new_url, 301);
                exit;
            }
        }
        
        return $query_vars;
    }
    
    /**
     * v2.10.20: Redirect old product slugs to new URL structure
     * Handles:
     * - /product/ → /produkt/ (language change)
     * - /produkt/xyz/ → /xyz/ (if product base removed)
     * - /obchod/xyz/ → /xyz/ (if product base removed)
     */
    public function handle_product_slug_redirect() {
        if (!class_exists('WooCommerce')) {
            return;
        }
        
        $request_uri = $_SERVER['REQUEST_URI'] ?? '';
        $request_path = parse_url($request_uri, PHP_URL_PATH);
        $request_path = rtrim($request_path, '/') . '/';
        
        // Get current WooCommerce product slug
        $wc_permalinks = get_option('woocommerce_permalinks', array());
        $current_product_base = isset($wc_permalinks['product_base']) ? trim($wc_permalinks['product_base'], '/') : 'product';
        
        // Check if product base removal is enabled
        $remove_product_base = get_option('wseo_remove_product_base', '0') === '1';
        
        // Common product slugs in different languages
        $product_slugs = array('product', 'produkt', 'produit', 'producto', 'prodotto', 'produkte', 'obchod', 'shop', 'tienda', 'boutique', 'negozio');
        
        // Check if URL starts with any product slug
        foreach ($product_slugs as $slug) {
            // Check if URL starts with this slug
            if (preg_match('#^/' . preg_quote($slug, '#') . '/(.+)$#', $request_path, $matches)) {
                $product_slug = rtrim($matches[1], '/');
                
                // Case 1: Product base removal is enabled - redirect to root URL
                if ($remove_product_base) {
                    // Check if product exists
                    $product_id = $this->get_product_id_by_slug($product_slug);
                    if ($product_id) {
                        $new_url = home_url('/' . $product_slug . '/');
                        wp_redirect($new_url, 301);
                        exit;
                    }
                }
                // Case 2: Different product base - redirect to correct one
                elseif ($slug !== $current_product_base && !empty($current_product_base)) {
                    $new_url = '/' . $current_product_base . '/' . $product_slug . '/';
                    
                    // Add query string if present
                    if (!empty($_SERVER['QUERY_STRING'])) {
                        $new_url .= '?' . $_SERVER['QUERY_STRING'];
                    }
                    
                    wp_redirect(home_url($new_url), 301);
                    exit;
                }
            }
        }
    }
    
    /**
     * v2.10.16: Get product ID by slug
     */
    private function get_product_id_by_slug($slug) {
        global $wpdb;
        
        $product_id = $wpdb->get_var($wpdb->prepare("
            SELECT ID FROM {$wpdb->posts} 
            WHERE post_name = %s 
            AND post_type = 'product' 
            AND post_status = 'publish'
            LIMIT 1
        ", $slug));
        
        return $product_id ? intval($product_id) : false;
    }
    
    /**
     * Handle custom redirects from Redirect Manager
     */
    public function handle_custom_redirects() {
        $redirects = get_option('wseo_redirects', array());
        
        if (empty($redirects)) {
            return;
        }
        
        $request_uri = $_SERVER['REQUEST_URI'] ?? '';
        $request_path = parse_url($request_uri, PHP_URL_PATH);
        
        foreach ($redirects as $index => $redirect) {
            $from = $redirect['from'];
            $to = $redirect['to'];
            $type = isset($redirect['type']) ? intval($redirect['type']) : 301;
            
            // Check for exact match
            if ($request_path === $from || $request_path === rtrim($from, '/') || $request_path === $from . '/') {
                // Update hit counter
                $redirects[$index]['hits'] = isset($redirects[$index]['hits']) ? $redirects[$index]['hits'] + 1 : 1;
                $redirects[$index]['last_hit'] = current_time('mysql');
                update_option('wseo_redirects', $redirects, false);
                
                // Perform redirect
                wp_redirect($to, $type);
                exit;
            }
            
            // Check for wildcard match (ends with *)
            if (substr($from, -1) === '*') {
                $from_base = rtrim($from, '*');
                if (strpos($request_path, $from_base) === 0) {
                    // Update hit counter
                    $redirects[$index]['hits'] = isset($redirects[$index]['hits']) ? $redirects[$index]['hits'] + 1 : 1;
                    $redirects[$index]['last_hit'] = current_time('mysql');
                    update_option('wseo_redirects', $redirects, false);
                    
                    // For wildcard, append the rest of the path to destination
                    $remaining_path = substr($request_path, strlen($from_base));
                    $final_url = rtrim($to, '/') . '/' . ltrim($remaining_path, '/');
                    
                    wp_redirect($final_url, $type);
                    exit;
                }
            }
            
            // Check for regex match (starts with ^)
            if (substr($from, 0, 1) === '^') {
                if (preg_match('#' . $from . '#', $request_path, $matches)) {
                    // Update hit counter
                    $redirects[$index]['hits'] = isset($redirects[$index]['hits']) ? $redirects[$index]['hits'] + 1 : 1;
                    $redirects[$index]['last_hit'] = current_time('mysql');
                    update_option('wseo_redirects', $redirects, false);
                    
                    // Replace $1, $2, etc. in destination
                    $final_url = $to;
                    for ($i = 1; $i < count($matches); $i++) {
                        $final_url = str_replace('$' . $i, $matches[$i], $final_url);
                    }
                    
                    wp_redirect($final_url, $type);
                    exit;
                }
            }
        }
    }
    
    /**
     * Handle post-level redirects (from SEO meta box)
     */
    public function handle_post_redirects() {
        if (!is_singular()) {
            return;
        }
        
        global $post;
        if (!$post) {
            return;
        }
        
        $redirect_url = get_post_meta($post->ID, '_wseo_redirect_url', true);
        
        if (!empty($redirect_url)) {
            $redirect_type = get_post_meta($post->ID, '_wseo_redirect_type', true) ?: '301';
            $status_code = intval($redirect_type);
            
            // Validate status code
            if (!in_array($status_code, array(301, 302, 307, 308))) {
                $status_code = 301;
            }
            
            wp_redirect($redirect_url, $status_code);
            exit;
        }
    }
    
    /**
     * Remove archive title prefixes (Category:, Tag:, Author:, etc.)
     * Works for both frontend display and meta titles
     */
    public function remove_archive_title_prefix($title) {
        // List of prefixes to remove (multilingual support)
        $prefixes = array(
            // English (EN)
            'Category:', 'Tag:', 'Author:', 'Archives:', 'Date:', 
            'Year:', 'Month:', 'Day:', 'Format:', 'Taxonomy:',
            'Categories:', 'Tags:', 'Authors:',
            
            // Slovak (SK)
            'Kategória:', 'Značka:', 'Autor:', 'Archívy:', 'Dátum:',
            'Rok:', 'Mesiac:', 'Deň:', 'Formát:', 'Taxonómia:',
            'Kategórie:', 'Značky:', 'Autori:', 'Archív:',
            
            // Czech (CZ)
            'Kategorie:', 'Štítek:', 'Autor:', 'Archiv:', 'Archivy:', 'Datum:',
            'Rok:', 'Měsíc:', 'Den:', 'Formát:', 'Taxonomie:',
            'Štítky:', 'Autoři:', 'Rubriky:', 'Rubrika:',
            
            // German (DE)
            'Kategorie:', 'Schlagwort:', 'Autor:', 'Archiv:', 'Archive:', 'Datum:',
            'Jahr:', 'Monat:', 'Tag:', 'Format:', 'Taxonomie:',
            'Kategorien:', 'Schlagwörter:', 'Autoren:', 'Schlagworte:',
            
            // Spanish (ES)
            'Categoría:', 'Etiqueta:', 'Autor:', 'Archivo:', 'Archivos:', 'Fecha:',
            'Año:', 'Mes:', 'Día:', 'Formato:', 'Taxonomía:',
            'Categorías:', 'Etiquetas:', 'Autores:',
            
            // French (FR)
            'Catégorie:', 'Étiquette:', 'Auteur:', 'Archive:', 'Archives:', 'Date:',
            'Année:', 'Mois:', 'Jour:', 'Format:', 'Taxonomie:',
            'Catégories:', 'Étiquettes:', 'Auteurs:', 'Mot-clé:', 'Mots-clés:',
            
            // Italian (IT)
            'Categoria:', 'Tag:', 'Autore:', 'Archivio:', 'Archivi:', 'Data:',
            'Anno:', 'Mese:', 'Giorno:', 'Formato:', 'Tassonomia:',
            'Categorie:', 'Etichetta:', 'Etichette:', 'Autori:',
            
            // Russian (RU)
            'Рубрика:', 'Метка:', 'Автор:', 'Архив:', 'Архивы:', 'Дата:',
            'Год:', 'Месяц:', 'День:', 'Формат:', 'Таксономия:',
            'Рубрики:', 'Метки:', 'Авторы:', 'Категория:', 'Категории:',
            
            // Polish (PL) - bonus
            'Kategoria:', 'Tag:', 'Autor:', 'Archiwum:', 'Archiwa:', 'Data:',
            'Rok:', 'Miesiąc:', 'Dzień:', 'Format:', 'Taksonomia:',
            'Kategorie:', 'Tagi:', 'Autorzy:',
            
            // Dutch (NL) - bonus
            'Categorie:', 'Tag:', 'Auteur:', 'Archief:', 'Archieven:', 'Datum:',
            'Jaar:', 'Maand:', 'Dag:', 'Formaat:', 'Taxonomie:',
            'Categorieën:', 'Tags:', 'Auteurs:',
            
            // Portuguese (PT) - bonus
            'Categoria:', 'Tag:', 'Autor:', 'Arquivo:', 'Arquivos:', 'Data:',
            'Ano:', 'Mês:', 'Dia:', 'Formato:', 'Taxonomia:',
            'Categorias:', 'Tags:', 'Autores:', 'Etiqueta:', 'Etiquetas:',
            
            // WooCommerce (multilingual)
            'Product Category:', 'Product Tag:', 'Shop:',
            'Kategória produktu:', 'Značka produktu:', 'Obchod:',
            'Kategorie produktu:', 'Štítek produktu:', 'Prodejna:',
            'Produktkategorie:', 'Produkt-Schlagwort:', 'Shop:',
            'Categoría de producto:', 'Etiqueta de producto:', 'Tienda:',
            'Catégorie de produit:', 'Étiquette de produit:', 'Boutique:',
            'Categoria prodotto:', 'Tag prodotto:', 'Negozio:',
            'Категория товара:', 'Метка товара:', 'Магазин:',
            
            // Events Calendar (multilingual)
            'Events:', 'Event Category:', 'Event Tag:',
            'Udalosti:', 'Kategória udalosti:', 'Značka udalosti:',
            'Události:', 'Kategorie události:', 'Štítek události:',
            'Veranstaltungen:', 'Veranstaltungskategorie:', 'Veranstaltungs-Tag:',
            'Eventos:', 'Categoría de evento:', 'Etiqueta de evento:',
            'Événements:', 'Catégorie d\'événement:', 'Étiquette d\'événement:',
            'Eventi:', 'Categoria evento:', 'Tag evento:',
            'Мероприятия:', 'Категория мероприятия:', 'Метка мероприятия:',
        );
        
        foreach ($prefixes as $prefix) {
            if (strpos($title, $prefix) === 0) {
                return trim(str_replace($prefix, '', $title));
            }
        }
        
        // Fallback: Remove anything before first colon followed by space
        if (preg_match('/^[^:]+:\s+(.+)$/', $title, $matches)) {
            return trim($matches[1]);
        }
        
        return $title;
    }
    
    /**
     * Output webmaster verification meta tags
     */
    private function output_verification_tags() {
        $google = get_option('wseo_verify_google', '');
        $bing = get_option('wseo_verify_bing', '');
        $yandex = get_option('wseo_verify_yandex', '');
        $pinterest = get_option('wseo_verify_pinterest', '');
        
        if ($google) {
            echo '<meta name="google-site-verification" content="' . esc_attr($google) . '">' . "\n";
        }
        if ($bing) {
            echo '<meta name="msvalidate.01" content="' . esc_attr($bing) . '">' . "\n";
        }
        if ($yandex) {
            echo '<meta name="yandex-verification" content="' . esc_attr($yandex) . '">' . "\n";
        }
        if ($pinterest) {
            echo '<meta name="p:domain_verify" content="' . esc_attr($pinterest) . '">' . "\n";
        }
    }
    
    /**
     * Output Google Analytics and GTM
     */
    private function output_analytics() {
        $ga_id = get_option('wseo_ga_id', '');
        $gtm_id = get_option('wseo_gtm_id', '');
        $anonymize = get_option('wseo_ga_anonymize', '1');
        
        // Google Tag Manager (head part)
        if ($gtm_id) {
            echo "<!-- Google Tag Manager -->\n";
            echo "<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':\n";
            echo "new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],\n";
            echo "j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=\n";
            echo "'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);\n";
            echo "})(window,document,'script','dataLayer','" . esc_js($gtm_id) . "');</script>\n";
            echo "<!-- End Google Tag Manager -->\n";
        }
        
        // Google Analytics 4
        if ($ga_id && !$gtm_id) {
            echo "<!-- Google Analytics 4 -->\n";
            echo '<script async src="https://www.googletagmanager.com/gtag/js?id=' . esc_attr($ga_id) . '"></script>' . "\n";
            echo "<script>\n";
            echo "window.dataLayer = window.dataLayer || [];\n";
            echo "function gtag(){dataLayer.push(arguments);}\n";
            echo "gtag('js', new Date());\n";
            
            if ($anonymize === '1') {
                echo "gtag('config', '" . esc_js($ga_id) . "', { 'anonymize_ip': true });\n";
            } else {
                echo "gtag('config', '" . esc_js($ga_id) . "');\n";
            }
            
            echo "</script>\n";
            echo "<!-- End Google Analytics 4 -->\n";
        }
    }
    
    /**
     * Output GTM noscript in body
     */
    public function output_gtm_body() {
        $gtm_id = get_option('wseo_gtm_id', '');
        
        if ($gtm_id) {
            echo '<!-- Google Tag Manager (noscript) -->' . "\n";
            echo '<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=' . esc_attr($gtm_id) . '"' . "\n";
            echo 'height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>' . "\n";
            echo '<!-- End Google Tag Manager (noscript) -->' . "\n";
        }
    }
    
    /**
     * Handle virtual files
     */
    public function handle_virtual_files() {
        // v2.9.7: Parse REQUEST_URI properly (remove query string, handle subdirectory installs)
        $request = $_SERVER['REQUEST_URI'];
        
        // v2.9.9: Skip for WooCommerce AJAX requests (checkout, add to cart, etc.)
        if (strpos($request, 'wc-ajax=') !== false) {
            return;
        }
        
        // Remove query string
        if (strpos($request, '?') !== false) {
            $request = substr($request, 0, strpos($request, '?'));
        }
        
        // Handle subdirectory installations
        $home_path = parse_url(home_url(), PHP_URL_PATH);
        if ($home_path && strpos($request, $home_path) === 0) {
            $request = substr($request, strlen($home_path));
        }
        
        // Ensure request starts with /
        if (empty($request) || $request[0] !== '/') {
            $request = '/' . $request;
        }
        
        if ($request === '/robots.txt') {
            $this->serve_robots_txt();
            exit;
        }
        
        // v2.9.7: Sitemap Index System for large sites (50k+ URLs)
        if ($request === '/sitemap.xml') {
            $this->serve_sitemap_index();
            exit;
        }
        
        // Handle paginated sitemaps: /sitemap-posts-1.xml, /sitemap-posts-2.xml, etc.
        if (preg_match('/^\/sitemap-(posts|pages|products|product-categories|categories|tags)-(\d+)\.xml$/i', $request, $matches)) {
            $this->serve_sitemap_part($matches[1], (int)$matches[2]);
            exit;
        }
        
        if ($request === '/sitemap-images.xml') {
            $this->serve_image_sitemap();
            exit;
        }
        
        // News sitemap - only if there are posts
        if ($request === '/sitemap-news.xml') {
            $post_count = wp_count_posts('post')->publish;
            if ($post_count > 0) {
                $this->serve_news_sitemap();
                exit;
            }
            // If no posts, let WordPress handle 404
        }
        
        if ($request === '/llms.txt') {
            $this->serve_llms_txt();
            exit;
        }
        
        if ($request === '/.well-known/traffic-advice') {
            $this->serve_traffic_advice();
            exit;
        }
    }
    
    /**
     * Serve traffic-advice for Google Chrome Private Prefetch Proxy
     * This allows Google to prefetch/prerender pages for faster loading
     * VŽDY ZAPNUTÉ - nie je dôvod to vypínať, len zrýchľuje stránky
     */
    private function serve_traffic_advice() {
        header('Content-Type: application/trafficadvice+json');
        header('Cache-Control: max-age=86400'); // Cache for 24 hours
        
        // Vždy povoliť Google Private Prefetch Proxy (fraction 1.0 = 100% of requests)
        // Toto je bezpečná optimalizácia bez negatívnych účinkov
        echo json_encode(array(
            array(
                'user_agent' => 'prefetch-proxy',
                'google_prefetch_proxy_eap' => array(
                    'fraction' => 1.0
                )
            )
        ), JSON_PRETTY_PRINT);
    }
    
    /**
     * Serve robots.txt
     */
    private function serve_robots_txt() {
        header('Content-Type: text/plain; charset=utf-8');
        header('X-Robots-Tag: noindex');
        
        echo "User-agent: *\n";
        echo "Allow: /\n";
        echo "Disallow: /wp-admin/\n";
        echo "Disallow: /wp-includes/\n";
        
        // v2.10.13: Block query parameters that should not be indexed
        echo "Disallow: /*?add-to-cart=*\n";
        echo "Disallow: /*?orderby=*\n";
        echo "Disallow: /*?filter*\n";
        echo "Disallow: /*?utm_*\n";
        echo "Disallow: /*?ref=*\n";
        echo "Disallow: /*?fbclid=*\n";
        echo "Disallow: /*?gclid=*\n";
        echo "Disallow: /*?mc_*\n";
        
        if (class_exists('WooCommerce')) {
            echo "Disallow: /cart/\n";
            echo "Disallow: /checkout/\n";
            echo "Disallow: /my-account/\n";
            echo "Disallow: /kosik/\n";
            echo "Disallow: /pokladna/\n";
            echo "Disallow: /moj-ucet/\n";
            
            // v2.10.16: Block old/wrong product slugs
            $wc_permalinks = get_option('woocommerce_permalinks', array());
            $current_product_base = isset($wc_permalinks['product_base']) ? trim($wc_permalinks['product_base'], '/') : 'product';
            
            // Common product slugs in different languages
            $product_slugs = array('product', 'produkt', 'produit', 'producto', 'prodotto', 'produkte', 'obchod', 'shop', 'tienda', 'boutique', 'negozio');
            
            // If product base is empty, block ALL product slugs
            if (empty($current_product_base) || $current_product_base === '/') {
                foreach ($product_slugs as $slug) {
                    echo "Disallow: /{$slug}/\n";
                }
            } else {
                // Block all except the current one
                foreach ($product_slugs as $slug) {
                    if ($slug !== $current_product_base) {
                        echo "Disallow: /{$slug}/\n";
                    }
                }
            }
        }
        
        $custom_rules = get_option('wseo_robots_custom_rules', '');
        if ($custom_rules) {
            echo "\n" . $custom_rules . "\n";
        }
        
        // v2.9.7: Only reference main sitemap index
        echo "\nSitemap: " . home_url('/sitemap.xml') . "\n";
    }
    
    /**
     * v2.9.7: Sitemap Index - links to all sub-sitemaps
     * Supports sites with 100,000+ URLs
     */
    private function serve_sitemap_index() {
        // Clear any previous output
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        header('Content-Type: application/xml; charset=utf-8');
        header('X-Robots-Tag: noindex');
        header('Cache-Control: max-age=3600'); // Cache for 1 hour
        
        $urls_per_sitemap = 10000; // Max 10,000 URLs per sitemap (Google recommends)
        
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo "\n";
        echo '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        echo "\n";
        
        // Get last modified dates for each post type
        global $wpdb;
        
        // Posts sitemap (only if there are posts)
        $post_count = wp_count_posts('post')->publish;
        if ($post_count > 0) {
            $posts_lastmod = $wpdb->get_var("SELECT MAX(post_modified_gmt) FROM {$wpdb->posts} WHERE post_type = 'post' AND post_status = 'publish'");
            $posts_lastmod = $posts_lastmod ? gmdate('c', strtotime($posts_lastmod)) : gmdate('c');
            
            $post_sitemaps = max(1, ceil($post_count / $urls_per_sitemap));
            for ($i = 1; $i <= $post_sitemaps; $i++) {
                echo '<sitemap>';
                echo '<loc>' . esc_url(home_url('/sitemap-posts-' . $i . '.xml')) . '</loc>';
                echo '<lastmod>' . $posts_lastmod . '</lastmod>';
                echo '</sitemap>';
                echo "\n";
            }
        }
        
        // Pages sitemap (only if there are pages)
        $page_count = wp_count_posts('page')->publish;
        if ($page_count > 0) {
            $pages_lastmod = $wpdb->get_var("SELECT MAX(post_modified_gmt) FROM {$wpdb->posts} WHERE post_type = 'page' AND post_status = 'publish'");
            $pages_lastmod = $pages_lastmod ? gmdate('c', strtotime($pages_lastmod)) : gmdate('c');
            
            $page_sitemaps = max(1, ceil($page_count / $urls_per_sitemap));
            for ($i = 1; $i <= $page_sitemaps; $i++) {
                echo '<sitemap>';
                echo '<loc>' . esc_url(home_url('/sitemap-pages-' . $i . '.xml')) . '</loc>';
                echo '<lastmod>' . $pages_lastmod . '</lastmod>';
                echo '</sitemap>';
                echo "\n";
            }
        }
        
        // Products sitemap (WooCommerce - use direct SQL for reliability)
        $product_count = (int) $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_type = 'product' AND post_status = 'publish'");
        
        if ($product_count > 0) {
            $products_lastmod = $wpdb->get_var("SELECT MAX(post_modified_gmt) FROM {$wpdb->posts} WHERE post_type = 'product' AND post_status = 'publish'");
            $products_lastmod = $products_lastmod ? gmdate('c', strtotime($products_lastmod)) : gmdate('c');
            
            $product_sitemaps = max(1, ceil($product_count / $urls_per_sitemap));
            for ($i = 1; $i <= $product_sitemaps; $i++) {
                echo '<sitemap>';
                echo '<loc>' . esc_url(home_url('/sitemap-products-' . $i . '.xml')) . '</loc>';
                echo '<lastmod>' . $products_lastmod . '</lastmod>';
                echo '</sitemap>';
                echo "\n";
            }
        }
        
        // Product categories sitemap (WooCommerce - use direct SQL)
        $product_cat_count = (int) $wpdb->get_var("
            SELECT COUNT(DISTINCT t.term_id) FROM {$wpdb->terms} t
            INNER JOIN {$wpdb->term_taxonomy} tt ON t.term_id = tt.term_id
            WHERE tt.taxonomy = 'product_cat' AND tt.count > 0
        ");
        
        if ($product_cat_count > 0) {
            // Use products lastmod for categories (they change when products change)
            $cat_lastmod = isset($products_lastmod) ? $products_lastmod : gmdate('c');
            echo '<sitemap>';
            echo '<loc>' . esc_url(home_url('/sitemap-product-categories-1.xml')) . '</loc>';
            echo '<lastmod>' . $cat_lastmod . '</lastmod>';
            echo '</sitemap>';
            echo "\n";
        }
        
        // Categories sitemap (only if there are categories with posts)
        $category_count = wp_count_terms(array('taxonomy' => 'category', 'hide_empty' => true));
        if (!is_wp_error($category_count) && $category_count > 0) {
            // Use posts lastmod for categories
            $cats_lastmod = isset($posts_lastmod) ? $posts_lastmod : gmdate('c');
            echo '<sitemap>';
            echo '<loc>' . esc_url(home_url('/sitemap-categories-1.xml')) . '</loc>';
            echo '<lastmod>' . $cats_lastmod . '</lastmod>';
            echo '</sitemap>';
            echo "\n";
        }
        
        // Tags sitemap (only if there are tags with posts)
        $tag_count = wp_count_terms(array('taxonomy' => 'post_tag', 'hide_empty' => true));
        if (!is_wp_error($tag_count) && $tag_count > 0) {
            $tags_lastmod = isset($posts_lastmod) ? $posts_lastmod : gmdate('c');
            echo '<sitemap>';
            echo '<loc>' . esc_url(home_url('/sitemap-tags-1.xml')) . '</loc>';
            echo '<lastmod>' . $tags_lastmod . '</lastmod>';
            echo '</sitemap>';
            echo "\n";
        }
        
        // News sitemap (only if there are posts)
        if ($post_count > 0) {
            echo '<sitemap>';
            echo '<loc>' . esc_url(home_url('/sitemap-news.xml')) . '</loc>';
            echo '<lastmod>' . $posts_lastmod . '</lastmod>';
            echo '</sitemap>';
            echo "\n";
        }
        
        // Images sitemap - use most recent modification from any post type
        $images_lastmod = $wpdb->get_var("SELECT MAX(post_modified_gmt) FROM {$wpdb->posts} WHERE post_status = 'publish' AND post_type IN ('post', 'page', 'product')");
        $images_lastmod = $images_lastmod ? gmdate('c', strtotime($images_lastmod)) : gmdate('c');
        echo '<sitemap>';
        echo '<loc>' . esc_url(home_url('/sitemap-images.xml')) . '</loc>';
        echo '<lastmod>' . $images_lastmod . '</lastmod>';
        echo '</sitemap>';
        echo "\n";
        
        echo '</sitemapindex>';
        exit;
    }
    
    /**
     * v2.9.7: Serve paginated sitemap part
     * Memory-efficient: loads only 10,000 URLs at a time
     */
    private function serve_sitemap_part($type, $page) {
        // Clear any previous output
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        header('Content-Type: application/xml; charset=utf-8');
        header('X-Robots-Tag: noindex');
        header('Cache-Control: max-age=3600');
        
        $urls_per_sitemap = 10000;
        $offset = ($page - 1) * $urls_per_sitemap;
        
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo "\n";
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';
        echo "\n";
        
        switch ($type) {
            case 'posts':
                $this->output_post_type_urls('post', $offset, $urls_per_sitemap);
                break;
                
            case 'pages':
                // Include homepage in first page sitemap
                if ($page === 1) {
                    echo '<url>';
                    echo '<loc>' . esc_url(home_url('/')) . '</loc>';
                    echo '<priority>1.0</priority>';
                    echo '<changefreq>daily</changefreq>';
                    echo '</url>';
                    echo "\n";
                }
                $this->output_post_type_urls('page', $offset, $urls_per_sitemap);
                break;
                
            case 'products':
                $this->output_post_type_urls('product', $offset, $urls_per_sitemap);
                break;
                
            case 'product-categories':
                $this->output_taxonomy_urls('product_cat');
                break;
                
            case 'categories':
                $this->output_taxonomy_urls('category');
                break;
                
            case 'tags':
                $this->output_taxonomy_urls('post_tag');
                break;
        }
        
        echo '</urlset>';
        exit;
    }
    
    /**
     * v2.9.7: Output URLs for a post type with pagination
     */
    private function output_post_type_urls($post_type, $offset, $limit) {
        global $wpdb;
        
        // Direct SQL query for better performance on large sites
        $posts = $wpdb->get_results($wpdb->prepare(
            "SELECT ID, post_modified FROM {$wpdb->posts} 
             WHERE post_type = %s AND post_status = 'publish' 
             ORDER BY post_modified DESC 
             LIMIT %d OFFSET %d",
            $post_type, $limit, $offset
        ));
        
        foreach ($posts as $post) {
            // Skip noindex posts
            $noindex = get_post_meta($post->ID, '_wseo_noindex', true);
            if ($noindex) continue;
            
            $permalink = get_permalink($post->ID);
            $lastmod = mysql2date('c', $post->post_modified);
            
            // Calculate priority based on age
            $age_days = (time() - strtotime($post->post_modified)) / 86400;
            if ($age_days < 7) {
                $priority = '0.8';
                $changefreq = 'daily';
            } elseif ($age_days < 30) {
                $priority = '0.6';
                $changefreq = 'weekly';
            } else {
                $priority = '0.4';
                $changefreq = 'monthly';
            }
            
            echo '<url>';
            echo '<loc>' . esc_url($permalink) . '</loc>';
            echo '<lastmod>' . $lastmod . '</lastmod>';
            echo '<priority>' . $priority . '</priority>';
            echo '<changefreq>' . $changefreq . '</changefreq>';
            echo '</url>';
            echo "\n";
        }
    }
    
    /**
     * v2.9.7: Output URLs for a taxonomy
     */
    private function output_taxonomy_urls($taxonomy) {
        global $wpdb;
        
        // Use direct SQL for reliability
        $terms = $wpdb->get_results($wpdb->prepare("
            SELECT t.term_id, t.name, t.slug, tt.count, tt.parent
            FROM {$wpdb->terms} t
            INNER JOIN {$wpdb->term_taxonomy} tt ON t.term_id = tt.term_id
            WHERE tt.taxonomy = %s AND tt.count > 0
            ORDER BY tt.count DESC
            LIMIT 10000
        ", $taxonomy));
        
        if (empty($terms)) return;
        
        // Get taxonomy base for URL building
        $tax_base = '';
        if ($taxonomy === 'product_cat') {
            $wc_permalinks = get_option('woocommerce_permalinks', array());
            $tax_base = isset($wc_permalinks['category_base']) ? trim($wc_permalinks['category_base'], '/') : 'product-category';
            if (empty($tax_base)) $tax_base = 'product-category';
        } elseif ($taxonomy === 'category') {
            $tax_base = get_option('category_base');
            if (empty($tax_base)) $tax_base = 'category';
        } elseif ($taxonomy === 'post_tag') {
            $tax_base = get_option('tag_base');
            if (empty($tax_base)) $tax_base = 'tag';
        }
        
        foreach ($terms as $term) {
            // Skip noindex terms
            $noindex = get_term_meta($term->term_id, '_wseo_term_noindex', true);
            if ($noindex) continue;
            
            // Try get_term_link first, fallback to manual URL
            $term_link = get_term_link((int)$term->term_id, $taxonomy);
            if (is_wp_error($term_link)) {
                // Build URL manually
                $term_link = home_url('/' . $tax_base . '/' . $term->slug . '/');
            }
            
            echo '<url>';
            echo '<loc>' . esc_url($term_link) . '</loc>';
            echo '<lastmod>' . gmdate('c') . '</lastmod>';
            echo '<priority>0.5</priority>';
            echo '<changefreq>weekly</changefreq>';
            echo '</url>';
            echo "\n";
        }
    }
    
    /**
     * Serve sitemap.xml with dynamic priority and changefreq
     * DEPRECATED in v2.9.7 - Replaced by serve_sitemap_index()
     */
    private function serve_sitemap_xml_legacy() {
        header('Content-Type: application/xml; charset=utf-8');
        header('X-Robots-Tag: noindex');
        
        echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">' . "\n";
        
        // Homepage
        echo '<url><loc>' . esc_url(home_url('/')) . '</loc><priority>1.0</priority><changefreq>daily</changefreq></url>' . "\n";
        
        // Pages
        $pages = get_posts(array('post_type' => 'page', 'posts_per_page' => -1, 'post_status' => 'publish'));
        foreach ($pages as $page) {
            if (get_post_meta($page->ID, '_wseo_noindex', true)) continue;
            
            $priority = $this->calculate_priority($page);
            $changefreq = $this->calculate_changefreq($page);
            $images = $this->get_post_images($page->ID);
            
            echo '<url>';
            echo '<loc>' . esc_url(get_permalink($page->ID)) . '</loc>';
            echo '<lastmod>' . get_the_modified_date('c', $page) . '</lastmod>';
            echo '<priority>' . $priority . '</priority>';
            echo '<changefreq>' . $changefreq . '</changefreq>';
            
            // Add images
            foreach ($images as $image) {
                echo '<image:image>';
                echo '<image:loc>' . esc_url($image['url']) . '</image:loc>';
                if (!empty($image['title'])) {
                    echo '<image:title>' . esc_html($image['title']) . '</image:title>';
                }
                if (!empty($image['alt'])) {
                    echo '<image:caption>' . esc_html($image['alt']) . '</image:caption>';
                }
                echo '</image:image>';
            }
            
            echo '</url>' . "\n";
        }
        
        // Posts
        $posts = get_posts(array('post_type' => 'post', 'posts_per_page' => -1, 'post_status' => 'publish'));
        foreach ($posts as $post) {
            if (get_post_meta($post->ID, '_wseo_noindex', true)) continue;
            
            $priority = $this->calculate_priority($post);
            $changefreq = $this->calculate_changefreq($post);
            $images = $this->get_post_images($post->ID);
            
            echo '<url>';
            echo '<loc>' . esc_url(get_permalink($post->ID)) . '</loc>';
            echo '<lastmod>' . get_the_modified_date('c', $post) . '</lastmod>';
            echo '<priority>' . $priority . '</priority>';
            echo '<changefreq>' . $changefreq . '</changefreq>';
            
            // Add images
            foreach ($images as $image) {
                echo '<image:image>';
                echo '<image:loc>' . esc_url($image['url']) . '</image:loc>';
                if (!empty($image['title'])) {
                    echo '<image:title>' . esc_html($image['title']) . '</image:title>';
                }
                if (!empty($image['alt'])) {
                    echo '<image:caption>' . esc_html($image['alt']) . '</image:caption>';
                }
                echo '</image:image>';
            }
            
            echo '</url>' . "\n";
        }
        
        // Products
        if (post_type_exists('product')) {
            $products = get_posts(array('post_type' => 'product', 'posts_per_page' => -1, 'post_status' => 'publish'));
            foreach ($products as $product) {
                if (get_post_meta($product->ID, '_wseo_noindex', true)) continue;
                
                $priority = $this->calculate_priority($product);
                $changefreq = $this->calculate_changefreq($product);
                $images = $this->get_post_images($product->ID);
                
                echo '<url>';
                echo '<loc>' . esc_url(get_permalink($product->ID)) . '</loc>';
                echo '<lastmod>' . get_the_modified_date('c', $product) . '</lastmod>';
                echo '<priority>' . $priority . '</priority>';
                echo '<changefreq>' . $changefreq . '</changefreq>';
                
                // Add images
                foreach ($images as $image) {
                    echo '<image:image>';
                    echo '<image:loc>' . esc_url($image['url']) . '</image:loc>';
                    if (!empty($image['title'])) {
                        echo '<image:title>' . esc_html($image['title']) . '</image:title>';
                    }
                    if (!empty($image['alt'])) {
                        echo '<image:caption>' . esc_html($image['alt']) . '</image:caption>';
                    }
                    echo '</image:image>';
                }
                
                echo '</url>' . "\n";
            }
        }
        
        // Categories
        $categories = get_categories(array('hide_empty' => true));
        foreach ($categories as $category) {
            if (get_term_meta($category->term_id, '_wseo_term_noindex', true)) continue;
            echo '<url>';
            echo '<loc>' . esc_url(get_category_link($category->term_id)) . '</loc>';
            echo '<priority>0.5</priority>';
            echo '<changefreq>weekly</changefreq>';
            echo '</url>' . "\n";
        }
        
        // Tags
        $tags = get_tags(array('hide_empty' => true));
        foreach ($tags as $tag) {
            if (get_term_meta($tag->term_id, '_wseo_term_noindex', true)) continue;
            echo '<url>';
            echo '<loc>' . esc_url(get_tag_link($tag->term_id)) . '</loc>';
            echo '<priority>0.4</priority>';
            echo '<changefreq>weekly</changefreq>';
            echo '</url>' . "\n";
        }
        
        echo '</urlset>';
    }
    
    /**
     * Serve image sitemap
     */
    private function serve_image_sitemap() {
        // Clear any previous output
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        header('Content-Type: application/xml; charset=utf-8');
        header('X-Robots-Tag: noindex');
        header('Cache-Control: max-age=3600');
        
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo "\n";
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';
        echo "\n";
        
        // Get all published posts with images (limit to 5000 for performance)
        $post_types = array('post', 'page');
        if (post_type_exists('product')) {
            $post_types[] = 'product';
        }
        
        $posts = get_posts(array(
            'post_type' => $post_types,
            'posts_per_page' => 5000,
            'post_status' => 'publish',
            'meta_key' => '_thumbnail_id',
            'orderby' => 'modified',
            'order' => 'DESC'
        ));
        
        $url_count = 0;
        foreach ($posts as $post) {
            if (get_post_meta($post->ID, '_wseo_noindex', true)) continue;
            
            $images = $this->get_post_images($post->ID);
            if (empty($images)) continue;
            
            echo '<url>';
            echo '<loc>' . esc_url(get_permalink($post->ID)) . '</loc>';
            
            foreach ($images as $image) {
                echo '<image:image>';
                echo '<image:loc>' . esc_url($image['url']) . '</image:loc>';
                if (!empty($image['title'])) {
                    echo '<image:title>' . esc_html($image['title']) . '</image:title>';
                }
                if (!empty($image['alt'])) {
                    echo '<image:caption>' . esc_html($image['alt']) . '</image:caption>';
                }
                echo '</image:image>';
            }
            
            echo '</url>';
            echo "\n";
            
            $url_count++;
            if ($url_count >= 5000) break; // Limit for performance
        }
        
        echo '</urlset>';
        exit;
    }
    
    /**
     * Serve Google News sitemap (articles from last 48 hours)
     */
    private function serve_news_sitemap() {
        // Clear any previous output
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        // Check if there are any posts at all
        $total_posts = wp_count_posts('post')->publish;
        if ($total_posts == 0) {
            status_header(404);
            echo '<?xml version="1.0" encoding="UTF-8"?>';
            echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"></urlset>';
            exit;
        }
        
        header('Content-Type: application/xml; charset=utf-8');
        header('X-Robots-Tag: noindex');
        header('Cache-Control: max-age=900');
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $locale = get_locale();
        $language = substr($locale, 0, 2);
        
        echo '<?xml version="1.0" encoding="UTF-8"?>';
        echo "\n";
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:news="http://www.google.com/schemas/sitemap-news/0.9">';
        echo "\n";
        
        // Get posts from last 48 hours (Google News requirement)
        $posts = get_posts(array(
            'post_type' => 'post',
            'posts_per_page' => 1000,
            'post_status' => 'publish',
            'date_query' => array(
                array(
                    'after' => '48 hours ago'
                )
            ),
            'orderby' => 'date',
            'order' => 'DESC'
        ));
        
        // If no recent posts, get the latest 10 posts instead (avoid empty sitemap)
        if (empty($posts)) {
            $posts = get_posts(array(
                'post_type' => 'post',
                'posts_per_page' => 10,
                'post_status' => 'publish',
                'orderby' => 'date',
                'order' => 'DESC'
            ));
        }
        
        foreach ($posts as $post) {
            if (get_post_meta($post->ID, '_wseo_noindex', true)) continue;
            
            // Get keywords/tags
            $tags = get_the_tags($post->ID);
            $keywords = array();
            if ($tags) {
                foreach ($tags as $tag) {
                    $keywords[] = $tag->name;
                }
            }
            
            echo '<url>';
            echo '<loc>' . esc_url(get_permalink($post->ID)) . '</loc>';
            echo '<news:news>';
            echo '<news:publication>';
            echo '<news:name>' . esc_html($site_name) . '</news:name>';
            echo '<news:language>' . esc_html($language) . '</news:language>';
            echo '</news:publication>';
            echo '<news:publication_date>' . get_the_date('c', $post) . '</news:publication_date>';
            echo '<news:title>' . esc_html($post->post_title) . '</news:title>';
            
            if (!empty($keywords)) {
                echo '<news:keywords>' . esc_html(implode(', ', array_slice($keywords, 0, 10))) . '</news:keywords>';
            }
            
            echo '</news:news>';
            echo '</url>';
            echo "\n";
        }
        
        echo '</urlset>';
        exit;
    }
    
    /**
     * Calculate dynamic priority based on post age, comments, updates
     */
    private function calculate_priority($post) {
        $priority = 0.5;
        
        // Base priority by post type
        if ($post->post_type === 'page') {
            $priority = 0.7;
            // Front page gets highest
            if ($post->ID == get_option('page_on_front')) {
                return 1.0;
            }
        } elseif ($post->post_type === 'product') {
            $priority = 0.7;
        } elseif ($post->post_type === 'post') {
            $priority = 0.5;
        }
        
        // Boost for recent posts (within 7 days)
        $post_date = strtotime($post->post_date);
        $days_old = (time() - $post_date) / DAY_IN_SECONDS;
        
        if ($days_old < 7) {
            $priority += 0.2;
        } elseif ($days_old < 30) {
            $priority += 0.1;
        }
        
        // Boost for posts with comments
        $comment_count = $post->comment_count;
        if ($comment_count > 50) {
            $priority += 0.15;
        } elseif ($comment_count > 10) {
            $priority += 0.1;
        } elseif ($comment_count > 0) {
            $priority += 0.05;
        }
        
        // Boost for recently updated
        $modified_date = strtotime($post->post_modified);
        $days_since_update = (time() - $modified_date) / DAY_IN_SECONDS;
        
        if ($days_since_update < 7) {
            $priority += 0.1;
        }
        
        // Cap at 0.9 (1.0 reserved for homepage)
        return min(0.9, round($priority, 1));
    }
    
    /**
     * Calculate changefreq based on update pattern
     */
    private function calculate_changefreq($post) {
        $post_date = strtotime($post->post_date);
        $modified_date = strtotime($post->post_modified);
        $days_old = (time() - $post_date) / DAY_IN_SECONDS;
        $days_since_update = (time() - $modified_date) / DAY_IN_SECONDS;
        
        // Recently created or updated
        if ($days_since_update < 1) {
            return 'hourly';
        } elseif ($days_since_update < 7) {
            return 'daily';
        } elseif ($days_since_update < 30) {
            return 'weekly';
        } elseif ($days_since_update < 180) {
            return 'monthly';
        } else {
            return 'yearly';
        }
    }
    
    /**
     * Get all images from a post
     */
    private function get_post_images($post_id) {
        $images = array();
        
        // Featured image
        if (has_post_thumbnail($post_id)) {
            $thumb_id = get_post_thumbnail_id($post_id);
            $thumb_url = wp_get_attachment_image_url($thumb_id, 'full');
            $thumb_alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
            $thumb_title = get_the_title($thumb_id);
            
            if ($thumb_url) {
                $images[] = array(
                    'url' => $thumb_url,
                    'alt' => $thumb_alt,
                    'title' => $thumb_title
                );
            }
        }
        
        // Images in content
        $post = get_post($post_id);
        if ($post && !empty($post->post_content)) {
            preg_match_all('/<img[^>]+src=["\']([^"\']+)["\'][^>]*>/i', $post->post_content, $matches);
            
            if (!empty($matches[1])) {
                foreach ($matches[1] as $img_url) {
                    // Skip external images and duplicates
                    if (strpos($img_url, home_url()) === false) continue;
                    if (in_array($img_url, array_column($images, 'url'))) continue;
                    
                    // Get attachment ID
                    $attach_id = attachment_url_to_postid($img_url);
                    $alt = '';
                    $title = '';
                    
                    if ($attach_id) {
                        $alt = get_post_meta($attach_id, '_wp_attachment_image_alt', true);
                        $title = get_the_title($attach_id);
                    }
                    
                    $images[] = array(
                        'url' => $img_url,
                        'alt' => $alt,
                        'title' => $title
                    );
                }
            }
        }
        
        // WooCommerce gallery images
        if ($post && $post->post_type === 'product') {
            $gallery_ids = get_post_meta($post_id, '_product_image_gallery', true);
            if ($gallery_ids) {
                $gallery_ids = explode(',', $gallery_ids);
                foreach ($gallery_ids as $gallery_id) {
                    $gallery_url = wp_get_attachment_image_url($gallery_id, 'full');
                    if ($gallery_url && !in_array($gallery_url, array_column($images, 'url'))) {
                        $images[] = array(
                            'url' => $gallery_url,
                            'alt' => get_post_meta($gallery_id, '_wp_attachment_image_alt', true),
                            'title' => get_the_title($gallery_id)
                        );
                    }
                }
            }
        }
        
        return array_slice($images, 0, 10); // Limit to 10 images per URL
    }
    
    /**
     * Serve llms.txt
     * Optimized for AI crawlers (ChatGPT, Claude, Perplexity, Google AI)
     * Follows llms.txt standard: https://llmstxt.org/
     * Auto-detects language from WordPress locale
     */
    private function serve_llms_txt() {
        header('Content-Type: text/plain; charset=utf-8');
        header('Cache-Control: public, max-age=3600');
        header('X-Robots-Tag: noindex');
        
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        $site_description = get_option('wseo_global_home_description', get_bloginfo('description'));
        $site_url = home_url();
        $locale = get_locale();
        $lang_code = substr($locale, 0, 2);
        
        // Determine if Slovak/Czech (similar languages)
        $is_slovak = in_array($lang_code, array('sk', 'cs'));
        
        // Language labels
        $labels = $this->get_llms_labels($lang_code);
        
        // Get structured AI data
        $ai_company_name = get_option('wseo_ai_company_name', '');
        $ai_what_we_do = get_option('wseo_ai_what_we_do', '');
        $ai_products_services = get_option('wseo_ai_products_services', '');
        $ai_location = get_option('wseo_ai_location', '');
        $ai_target_audience = get_option('wseo_ai_target_audience', '');
        $ai_extra_info = get_option('wseo_ai_extra_info', '');
        $ai_custom_text = get_option('wseo_ai_custom_text', '');
        
        // Schema data for fallbacks
        $schema_type = get_option('wseo_schema_type', 'Organization');
        $schema_email = get_option('wseo_schema_email', '');
        $schema_phone = get_option('wseo_schema_phone', '');
        $schema_address = get_option('wseo_schema_address_city', '');
        $schema_country = get_option('wseo_schema_address_country', 'SK');
        
        // ===== HEADER =====
        echo "# " . $site_name . "\n\n";
        
        // Description block
        if (!empty($site_description)) {
            echo "> " . $site_description . "\n\n";
        }
        
        // ===== ABOUT THIS BUSINESS (Structured AI Info) =====
        $has_ai_info = !empty($ai_company_name) || !empty($ai_what_we_do) || !empty($ai_products_services) || !empty($ai_location);
        
        if ($has_ai_info) {
            if ($is_slovak) {
                echo "## 🏢 O tejto firme\n\n";
            } else {
                echo "## 🏢 About This Business\n\n";
            }
            
            // Company name
            if (!empty($ai_company_name)) {
                if ($is_slovak) {
                    echo "**Názov firmy**: " . $ai_company_name . "\n\n";
                } else {
                    echo "**Company Name**: " . $ai_company_name . "\n\n";
                }
            }
            
            // What we do
            if (!empty($ai_what_we_do)) {
                if ($is_slovak) {
                    echo "**Čím sa zaoberáme**: " . $ai_what_we_do . "\n\n";
                } else {
                    echo "**What We Do**: " . $ai_what_we_do . "\n\n";
                }
            }
            
            // Products/Services
            if (!empty($ai_products_services)) {
                if ($is_slovak) {
                    echo "**Produkty a služby**: " . $ai_products_services . "\n\n";
                } else {
                    echo "**Products & Services**: " . $ai_products_services . "\n\n";
                }
            }
            
            // Location/Area
            if (!empty($ai_location)) {
                if ($is_slovak) {
                    echo "**Kde pôsobíme**: " . $ai_location . "\n\n";
                } else {
                    echo "**Service Area**: " . $ai_location . "\n\n";
                }
            }
            
            // Target audience
            if (!empty($ai_target_audience)) {
                if ($is_slovak) {
                    echo "**Pre koho sme tu**: " . $ai_target_audience . "\n\n";
                } else {
                    echo "**Who We Serve**: " . $ai_target_audience . "\n\n";
                }
            }
            
            // Extra info
            if (!empty($ai_extra_info)) {
                if ($is_slovak) {
                    echo "**Doplňujúce informácie**: " . $ai_extra_info . "\n\n";
                } else {
                    echo "**Additional Information**: " . $ai_extra_info . "\n\n";
                }
            }
        }
        
        // ===== CUSTOM TEXT (free form) =====
        if (!empty($ai_custom_text)) {
            if ($is_slovak) {
                echo "## 📝 O tomto webe\n\n";
            } else {
                echo "## 📝 About This Website\n\n";
            }
            echo $ai_custom_text . "\n\n";
        }
        
        // ===== CITATION NOTICE (compact) =====
        if ($is_slovak) {
            echo "## ⚠️ Povinné citovanie\n\n";
            echo "Pri použití informácií z tohto webu **vždy uveď zdroj**: " . $site_url . "\n";
            echo "Príklad: *\"Podľa " . $site_name . " (" . $site_url . ")...\"*\n\n";
        } else {
            echo "## ⚠️ Citation Required\n\n";
            echo "When using information from this website, **always cite the source**: " . $site_url . "\n";
            echo "Example: *\"According to " . $site_name . " (" . $site_url . ")...\"*\n\n";
        }
        
        // ===== CONTACT INFO =====
        $has_contact = !empty($schema_email) || !empty($schema_phone) || !empty($schema_address);
        if ($has_contact) {
            echo "## " . $labels['contact'] . "\n\n";
            if (!empty($schema_phone)) {
                echo "- **" . $labels['phone'] . "**: " . $schema_phone . "\n";
            }
            if (!empty($schema_email)) {
                echo "- **" . $labels['email'] . "**: " . $schema_email . "\n";
            }
            if (!empty($schema_address)) {
                $country_names_sk = array('SK' => 'Slovensko', 'CZ' => 'Česko', 'AT' => 'Rakúsko', 'HU' => 'Maďarsko', 'PL' => 'Poľsko', 'DE' => 'Nemecko');
                $country_name = $is_slovak && isset($country_names_sk[$schema_country]) ? $country_names_sk[$schema_country] : $schema_country;
                echo "- **" . $labels['location'] . "**: " . $schema_address . ", " . $country_name . "\n";
            }
            echo "- **Web**: " . $site_url . "\n";
            
            // Social profiles
            $socials = array();
            $fb = get_option('wseo_schema_social_facebook', '');
            $ig = get_option('wseo_schema_social_instagram', '');
            $li = get_option('wseo_schema_social_linkedin', '');
            $yt = get_option('wseo_schema_social_youtube', '');
            if ($fb) $socials[] = $fb;
            if ($ig) $socials[] = $ig;
            if ($li) $socials[] = $li;
            if ($yt) $socials[] = $yt;
            if (!empty($socials)) {
                echo "- **" . $labels['social'] . "**: " . implode(", ", $socials) . "\n";
            }
            echo "\n";
        }
        
        // ===== EXPERTISE / TOPICS =====
        $categories = get_categories(array('hide_empty' => true, 'number' => 15, 'orderby' => 'count', 'order' => 'DESC'));
        if (!empty($categories)) {
            echo "## " . $labels['topics'] . "\n\n";
            foreach ($categories as $cat) {
                // Skip placeholder categories
                if (stripos($cat->description, 'your blog category') !== false || 
                    stripos($cat->name, 'uncategorized') !== false ||
                    stripos($cat->name, 'nezaradené') !== false) {
                    continue;
                }
                $cat_desc = $cat->description ? ' - ' . wp_trim_words($cat->description, 15, '...') : '';
                echo "- **" . $cat->name . "**" . $cat_desc . "\n";
            }
            echo "\n";
        }
        
        // ===== KEY PAGES =====
        echo "## " . $labels['pages'] . "\n\n";
        
        // Pages to exclude from llms.txt
        $excluded_slugs = array(
            '404', 'stranka-404', 'page-404', 'error-404',
            'image-licenses', 'image-license', 'licencie-obrazkov',
            'privacy-policy', 'zasady-ochrany-osobnych-udajov', 'gdpr',
            'cookies', 'cookie-policy', 'zasady-cookies',
            'terms', 'terms-of-service', 'obchodne-podmienky', 'vop',
            'cart', 'kosik', 'checkout', 'pokladna',
            'my-account', 'moj-ucet', 'account',
            'thank-you', 'dakujeme', 'order-received',
            'wishlist', 'zoznam-priani'
        );
        
        $pages = get_posts(array(
            'post_type' => 'page', 
            'posts_per_page' => 30, 
            'post_status' => 'publish',
            'orderby' => 'menu_order',
            'order' => 'ASC'
        ));
        
        foreach ($pages as $page) {
            // Skip excluded pages
            if (in_array($page->post_name, $excluded_slugs)) {
                continue;
            }
            
            // Skip pages with excluded words in title
            $title_lower = mb_strtolower(get_the_title($page));
            if (strpos($title_lower, '404') !== false || 
                strpos($title_lower, 'license') !== false ||
                strpos($title_lower, 'licenci') !== false ||
                strpos($title_lower, 'privacy') !== false ||
                strpos($title_lower, 'cookie') !== false) {
                continue;
            }
            
            $page_desc = get_post_meta($page->ID, '_wseo_meta_description', true);
            
            // Check if saved meta description is garbage
            if (!empty($page_desc) && $this->is_garbage_description($page_desc)) {
                $page_desc = ''; // Clear garbage
            }
            
            // Try to extract from content if no good description
            if (empty($page_desc)) {
                $page_desc = $this->clean_content_for_llms($page->post_content);
            }
            
            // Final garbage check
            if ($this->is_garbage_description($page_desc)) {
                $page_desc = '';
            }
            
            echo "### " . get_the_title($page) . "\n";
            echo "- **URL**: " . get_permalink($page->ID) . "\n";
            if (!empty($page_desc)) {
                echo "- **" . $labels['summary'] . "**: " . $page_desc . "\n";
            }
            echo "\n";
        }
        
        // ===== RECENT ARTICLES =====
        $posts = get_posts(array(
            'post_type' => 'post', 
            'posts_per_page' => 15, 
            'post_status' => 'publish',
            'orderby' => 'date',
            'order' => 'DESC'
        ));
        
        if (!empty($posts)) {
            echo "## " . $labels['articles'] . "\n\n";
            
            foreach ($posts as $post) {
                $post_desc = get_post_meta($post->ID, '_wseo_meta_description', true);
                
                // DEBUG: uncomment next line to see raw meta value
                // echo "<!-- DEBUG " . get_the_title($post) . ": [" . substr($post_desc, 0, 50) . "...] len=" . mb_strlen($post_desc) . " -->\n";
                
                // Check if saved meta description is garbage
                if (!empty($post_desc) && $this->is_garbage_description($post_desc)) {
                    $post_desc = '';
                }
                
                // Try to extract from content if no good description
                if (empty($post_desc)) {
                    $post_desc = $this->clean_content_for_llms($post->post_content);
                }
                
                // Final garbage check
                if ($this->is_garbage_description($post_desc)) {
                    $post_desc = '';
                }
                
                $post_date = $is_slovak ? get_the_date('d.m.Y', $post) : get_the_date('Y-m-d', $post);
                
                echo "### " . get_the_title($post) . "\n";
                echo "- **URL**: " . get_permalink($post->ID) . "\n";
                echo "- **" . $labels['published'] . "**: " . $post_date . "\n";
                if (!empty($post_desc)) {
                    echo "- **" . $labels['summary'] . "**: " . $post_desc . "\n";
                }
                echo "\n";
            }
        }
        
        // ===== PRODUCTS (WooCommerce) =====
        if (post_type_exists('product') && class_exists('WooCommerce')) {
            $products = get_posts(array(
                'post_type' => 'product', 
                'posts_per_page' => 15, 
                'post_status' => 'publish',
                'orderby' => 'date',
                'order' => 'DESC'
            ));
            
            if (!empty($products)) {
                echo "## " . $labels['products'] . "\n\n";
                
                foreach ($products as $product) {
                    $wc_product = wc_get_product($product->ID);
                    $price = $wc_product ? $wc_product->get_price() : '';
                    $currency = get_woocommerce_currency_symbol();
                    
                    echo "### " . get_the_title($product) . "\n";
                    echo "- **URL**: " . get_permalink($product->ID) . "\n";
                    if ($price) {
                        echo "- **" . $labels['price'] . "**: " . $currency . $price . "\n";
                    }
                    $product_desc = $this->clean_post_content($product->post_content, 20);
                    if ($product_desc) {
                        echo "- **" . $labels['description'] . "**: " . $product_desc . "\n";
                    }
                    echo "\n";
                }
            }
        }
        
        // ===== TECHNICAL INFO =====
        echo "## " . $labels['technical'] . "\n\n";
        echo "- **Sitemap**: " . home_url('/sitemap.xml') . "\n";
        echo "- **RSS Feed**: " . get_bloginfo('rss2_url') . "\n";
        echo "- **Robots.txt**: " . home_url('/robots.txt') . "\n";
        
        // Language info
        $language_names_sk = array(
            'sk' => 'Slovenčina', 'cs' => 'Čeština', 'en' => 'Angličtina', 'de' => 'Nemčina',
            'fr' => 'Francúzština', 'es' => 'Španielčina', 'it' => 'Taliančina', 'pl' => 'Poľština'
        );
        $language_names_en = array(
            'sk' => 'Slovak', 'cs' => 'Czech', 'en' => 'English', 'de' => 'German',
            'fr' => 'French', 'es' => 'Spanish', 'it' => 'Italian', 'pl' => 'Polish'
        );
        $lang_names = $is_slovak ? $language_names_sk : $language_names_en;
        $lang_name = isset($lang_names[$lang_code]) ? $lang_names[$lang_code] : $lang_code;
        echo "- **" . $labels['language'] . "**: " . $lang_name . "\n";
        echo "- **" . $labels['updated'] . "**: " . date('d.m.Y') . "\n";
        
        echo "\n---\n";
        echo "Generated by Webstudio SEO Pro | " . date('Y-m-d H:i:s') . "\n";
        
        exit;
    }
    
    /**
     * Clean content for llms.txt - removes garbage, buttons, JSON, shortcodes
     */
    private function clean_content_for_llms($content) {
        if (empty($content)) {
            return '';
        }
        
        // Remove JSON objects
        $content = preg_replace('/\{[^}]*"[^"]*"[^}]*\}/s', '', $content);
        
        // Remove shortcodes
        $content = strip_shortcodes($content);
        $content = preg_replace('/\[[^\]]*\]/', '', $content);
        
        // Remove script/style
        $content = preg_replace('/<script[^>]*>.*?<\/script>/is', '', $content);
        $content = preg_replace('/<style[^>]*>.*?<\/style>/is', '', $content);
        
        // Remove navigation elements
        $content = preg_replace('/<nav[^>]*>.*?<\/nav>/is', '', $content);
        $content = preg_replace('/<header[^>]*>.*?<\/header>/is', '', $content);
        $content = preg_replace('/<footer[^>]*>.*?<\/footer>/is', '', $content);
        
        // Remove buttons and links in builder format
        $content = preg_replace('/<a[^>]*class="[^"]*btn[^"]*"[^>]*>.*?<\/a>/is', '', $content);
        $content = preg_replace('/<button[^>]*>.*?<\/button>/is', '', $content);
        
        // Strip all HTML
        $content = wp_strip_all_tags($content);
        
        // Remove phone numbers at the start (common in bad extractions)
        $content = preg_replace('/^\+?\d[\d\s\-]{8,}/', '', $content);
        
        // Remove email addresses at the start
        $content = preg_replace('/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}\s*/', '', $content);
        
        // Normalize whitespace
        $content = preg_replace('/\s+/', ' ', $content);
        $content = trim($content);
        
        // Truncate to reasonable length
        if (mb_strlen($content) > 200) {
            $content = mb_substr($content, 0, 197);
            // Cut at last space
            $last_space = mb_strrpos($content, ' ');
            if ($last_space > 150) {
                $content = mb_substr($content, 0, $last_space);
            }
            $content .= '...';
        }
        
        return $content;
    }
    
    /**
     * Check if description is garbage (buttons, menu items, JSON, etc.)
     */
    private function is_garbage_description($desc) {
        if (empty($desc)) {
            return true;
        }
        
        $len = mb_strlen($desc);
        
        // Too short
        if ($len < 30) {
            return true;
        }
        
        // Always check for these patterns regardless of length
        
        // Contains JSON
        if (preg_match('/\{["\']|[\"\']:\s*["\']|\{"actions"/', $desc)) {
            return true;
        }
        
        // Button-like sequences (these are garbage even if 100+ chars)
        $always_garbage = array(
            '/Content Marketing\s+Tvorba webstránok/iu',
            '/Tvorba webstránok\s+Tvorba e-shopov/iu',
            '/SEO optimalizácia\s+Content Marketing/iu',
            '/Oprava a údržba\s+Potrebujete/iu',
            '/Neváhajte nás kontak/iu',
            '/^LTD\s+Tvorba/iu',
            '/WordPress.*Laravel.*React.*PineScript/iu',
            '/\+421\s*\d{3}\s*\d{3}\s*\d{3}.*\+421/iu', // Multiple phone numbers
            '/info@.*\.ltd\s*$/iu',
            '/Vrátiť sa späť/iu',
        );
        
        foreach ($always_garbage as $pattern) {
            if (preg_match($pattern, $desc)) {
                return true;
            }
        }
        
        // Long descriptions (100+ chars) that passed above checks are probably OK
        if ($len >= 100) {
            return false;
        }
        
        // For shorter descriptions (30-100 chars), apply stricter checks
        
        // Contains file paths or URLs as main content
        if (preg_match('/^https?:\/\/|\.json|\.php|\.js/', $desc)) {
            return true;
        }
        
        // Starts with navigation-like patterns
        $nav_patterns = array(
            '/^(Späť|Back|Vrátiť|Return|Menu|Home|Domov)\b/iu',
            '/^\+\d{3}/',
            '/^📷/',
            '/Stránka 404/iu',
        );
        
        foreach ($nav_patterns as $pattern) {
            if (preg_match($pattern, $desc)) {
                return true;
            }
        }
        
        return false;
    }
    
    /**
     * Get localized labels for llms.txt
     */
    private function get_llms_labels($lang_code) {
        $is_slovak = in_array($lang_code, array('sk', 'cs'));
        
        if ($is_slovak) {
            return array(
                'metadata' => 'Základné informácie',
                'website' => 'Webová stránka',
                'name' => 'Názov',
                'language' => 'Jazyk',
                'updated' => 'Aktualizované',
                'business_type' => 'Typ podnikania',
                'contact' => 'Kontakt',
                'email' => 'E-mail',
                'phone' => 'Telefón',
                'location' => 'Adresa',
                'social' => 'Sociálne siete',
                'topics' => 'Témy a expertíza',
                'pages' => 'Hlavné stránky',
                'articles' => 'Články',
                'products' => 'Produkty',
                'summary' => 'Popis',
                'published' => 'Publikované',
                'category' => 'Kategória',
                'price' => 'Cena',
                'description' => 'Popis',
                'ai_guidelines' => 'Pravidlá pre AI',
                'technical' => 'Technické informácie'
            );
        }
        
        return array(
            'metadata' => 'Metadata',
            'website' => 'Website',
            'name' => 'Name',
            'language' => 'Language',
            'updated' => 'Last Updated',
            'business_type' => 'Business Type',
            'contact' => 'Contact',
            'email' => 'Email',
            'phone' => 'Phone',
            'location' => 'Address',
            'social' => 'Social Profiles',
            'topics' => 'Topics & Expertise',
            'pages' => 'Key Pages',
            'articles' => 'Articles',
            'products' => 'Products',
            'summary' => 'Summary',
            'published' => 'Published',
            'category' => 'Category',
            'price' => 'Price',
            'description' => 'Description',
            'ai_guidelines' => 'AI Usage Guidelines',
            'technical' => 'Technical Information'
        );
    }
    
    /**
     * Generate meta title
     */
    private function generate_meta_title($title, $type = 'page') {
        // Get site name from settings or WordPress
        $site_name = get_option('wseo_global_site_name', '');
        if (empty($site_name)) {
            $site_name = get_bloginfo('name');
        }
        
        // Separator - ensure it has spaces around it
        $separator = get_option('wseo_title_separator', ' - ');
        if (empty($separator)) {
            $separator = ' - ';
        }
        // Ensure separator has spaces: " - " not "-"
        $separator = trim($separator);
        $separator = ' ' . $separator . ' ';
        
        // Clean title
        $title = trim($title);
        
        // If title is empty, just return site name
        if (empty($title)) {
            return $site_name;
        }
        
        // Check if title already contains site name (avoid duplication)
        if (!empty($site_name) && mb_stripos($title, $site_name) !== false) {
            return $title;
        }
        
        // Calculate max title length (target ~55-60 chars total)
        $max_total = 60;
        $suffix_length = mb_strlen($separator) + mb_strlen($site_name);
        $max_title_length = $max_total - $suffix_length;
        
        // Truncate title if needed
        if (mb_strlen($title) > $max_title_length) {
            $title = mb_substr($title, 0, $max_title_length - 3);
            // Try to cut at last space
            $last_space = mb_strrpos($title, ' ');
            if ($last_space > ($max_title_length - 20)) {
                $title = mb_substr($title, 0, $last_space);
            }
            $title .= '...';
        }
        
        // Build final title with site name
        if (!empty($site_name)) {
            return $title . $separator . $site_name;
        }
        
        return $title;
    }
    
    /**
     * Generate meta description - extracts first meaningful paragraph
     * Skips menus, navigation, shortcodes, widgets, buttons, links
     */
    /**
     * v2.9.9: Clean post content - remove shortcodes and HTML for meta/schema use
     * @param string $content Post content
     * @param int $word_limit Optional word limit
     * @return string Clean text
     */
    private function clean_post_content($content, $word_limit = 0) {
        if (empty($content)) {
            return '';
        }
        
        // Remove WordPress shortcodes first
        $text = strip_shortcodes($content);
        
        // Remove all shortcode-like patterns (builders, custom shortcodes)
        $text = preg_replace('/\[[^\]]*\]/', '', $text);
        
        // Strip HTML tags
        $text = wp_strip_all_tags($text);
        
        // Normalize whitespace
        $text = preg_replace('/\s+/', ' ', $text);
        $text = trim($text);
        
        // Apply word limit if specified
        if ($word_limit > 0 && !empty($text)) {
            $text = wp_trim_words($text, $word_limit, '...');
        }
        
        return $text;
    }
    
    private function generate_meta_description($content) {
        // If content is empty, return empty
        if (empty($content)) {
            return '';
        }
        
        $text = $content;
        
        // Remove script and style content
        $text = preg_replace('/<script[^>]*>.*?<\/script>/is', '', $text);
        $text = preg_replace('/<style[^>]*>.*?<\/style>/is', '', $text);
        
        // Remove navigation, menu, header, footer, sidebar, widget areas
        $text = preg_replace('/<nav[^>]*>.*?<\/nav>/is', '', $text);
        $text = preg_replace('/<header[^>]*>.*?<\/header>/is', '', $text);
        $text = preg_replace('/<footer[^>]*>.*?<\/footer>/is', '', $text);
        $text = preg_replace('/<aside[^>]*>.*?<\/aside>/is', '', $text);
        
        // Remove links/buttons - they are navigation, not content
        $text = preg_replace('/<a[^>]*>.*?<\/a>/is', '', $text);
        $text = preg_replace('/<button[^>]*>.*?<\/button>/is', '', $text);
        
        // Remove elements with menu/nav/button classes
        $text = preg_replace('/<[^>]*class="[^"]*(?:menu|nav|sidebar|widget|footer|header|button|btn|cta)[^"]*"[^>]*>.*?<\/[^>]+>/is', '', $text);
        
        // Remove WordPress shortcodes
        $text = strip_shortcodes($text);
        
        // Remove builder shortcodes
        $text = preg_replace('/\[.*?\]/', '', $text);
        
        // Now strip all remaining HTML tags
        $text = wp_strip_all_tags($text);
        
        // Normalize whitespace
        $text = preg_replace('/\s+/', ' ', $text);
        $text = trim($text);
        
        // SIMPLE MODE: For WooCommerce products or short content, use direct truncation
        global $post;
        if ((isset($post) && $post->post_type === 'product') || str_word_count($text) < 100) {
            // For products, accept even short text (just title is OK)
            if (empty($text) || mb_strlen($text) < 10) {
                return '';
            }
            
            // Direct truncation - no sentence parsing
            if (mb_strlen($text) > 155) {
                $description = mb_substr($text, 0, 152);
                $last_space = mb_strrpos($description, ' ');
                if ($last_space > 50) {
                    $description = mb_substr($description, 0, $last_space);
                }
                $description .= '...';
            } else {
                $description = $text;
            }
            
            return $description;
        }
        
        // ADVANCED MODE: For regular pages/posts
        
        // If empty after cleanup, return empty
        if (empty($text) || mb_strlen($text) < 30) {
            return '';
        }
        
        // Split into potential sentences/phrases
        $sentences = preg_split('/(?<=[.!?])\s+/', $text, -1, PREG_SPLIT_NO_EMPTY);
        
        // If no sentence breaks, try splitting by common patterns
        if (count($sentences) <= 1) {
            // Try to find where actual content starts (after short button-like texts)
            $sentences = preg_split('/\s{2,}/', $text, -1, PREG_SPLIT_NO_EMPTY);
        }
        
        // Build description from meaningful sentences
        $description = '';
        $skip_patterns = array(
            // Navigation/Menu items (SK)
            '/^(Menu|Domov|Home|Kontakt|Contact|O nás|About|Služby|Services|Blog|Shop|Obchod|Novinky|News|Portfólio|Portfolio|Galéria|Gallery|Cenník|Pricing|FAQ|Pomoc|Help)$/iu',
            // Navigation/Menu items (short)
            '/^[A-ZÁÄČĎÉÍĹĽŇÓÔŔŠŤÚÝŽ][a-záäčďéíĺľňóôŕšťúýž]+$/u',
            // Button/CTA texts (SK)
            '/^(Čítať viac|Read more|Zobraziť|View|Kliknite|Click|Viac info|More info|Objednať|Order|Kúpiť|Buy|Kontaktujte|Napíšte|Zavolajte|Stiahnuť|Download)/iu',
            // Service/category names that are likely buttons
            '/^(Tvorba webstránok|Tvorba e-shopov|SEO optimalizácia|Content Marketing|Oprava a údržba|Webdesign|Marketing|Grafika|Hosting)$/iu',
            // Questions used as CTAs
            '/^(Potrebujete.*\?|Máte záujem.*\?|Chcete.*\?)$/iu',
            // Very short CTA phrases
            '/^(Neváhajte.*kontaktov|Kontaktujte nás|Napíšte nám|Zavolajte nám)/iu',
            // Copyright
            '/^(©|Copyright|\d{4})/iu',
            // Arrow/icon text
            '/^→|←|›|‹|»|«$/u',
        );
        
        foreach ($sentences as $sentence) {
            $sentence = trim($sentence);
            
            // Skip very short texts (likely menu items, buttons)
            if (mb_strlen($sentence) < 25) {
                continue;
            }
            
            // Skip if matches skip patterns
            $skip = false;
            foreach ($skip_patterns as $pattern) {
                if (preg_match($pattern, $sentence)) {
                    $skip = true;
                    break;
                }
            }
            if ($skip) {
                continue;
            }
            
            // Skip if it's just a few words (likely navigation)
            $word_count = str_word_count($sentence);
            if ($word_count < 5) {
                continue;
            }
            
            // This looks like real content - use it
            if (empty($description)) {
                $description = $sentence;
            } else {
                if (mb_strlen($description . ' ' . $sentence) <= 155) {
                    $description .= ' ' . $sentence;
                } else {
                    break;
                }
            }
            
            if (mb_strlen($description) >= 120) {
                break;
            }
        }
        
        // If still no good description, return empty (better than garbage)
        if (empty($description) || mb_strlen($description) < 50) {
            return '';
        }
        
        // Final cleanup and truncation
        $description = trim($description);
        
        if (mb_strlen($description) > 155) {
            $description = mb_substr($description, 0, 152);
            $last_space = mb_strrpos($description, ' ');
            if ($last_space > 100) {
                $description = mb_substr($description, 0, $last_space);
            }
            $description .= '...';
        }
        
        return $description;
    }
    
    /**
     * Generate keywords from title
     * v2.9.14: DEPRECATED - Focus Keywords should be set manually
     * Kept for backwards compatibility but returns empty
     */
    private function generate_keywords_from_title($title) {
        // v2.9.14: No longer auto-generate keywords
        // Focus Keywords should be set manually by the user
        return '';
    }
    
    /**
     * Get post content from various builders
     */
    public function get_post_content($post_id) {
        $post = get_post($post_id);
        if (!$post) return '';
        
        $content = '';
        
        // PRIORITY: WooCommerce Products - try Description and Short Description FIRST
        if ($post->post_type === 'product') {
            
            // SPECIAL: Check if product uses Themify Builder
            $themify_keys = array(
                '_themify_builder_settings_json',
                '_themify_builder_settings',
                'themify_builder_data',
                '_themify_builder_data',
            );
            
            $has_themify = false;
            foreach ($themify_keys as $meta_key) {
                if (get_post_meta($post_id, $meta_key, true)) {
                    $has_themify = true;
                    break;
                }
            }
            
            // If Themify Builder is used, try to extract from it FIRST
            if ($has_themify && class_exists('Themify_Builder')) {
                global $ThemifyBuilder;
                if (isset($ThemifyBuilder) && method_exists($ThemifyBuilder, 'get_builder_output')) {
                    $builder_output = $ThemifyBuilder->get_builder_output($post_id);
                    if (!empty($builder_output)) {
                        $builder_text = wp_strip_all_tags($builder_output);
                        $builder_text = preg_replace('/\s+/', ' ', $builder_text);
                        $builder_text = trim($builder_text);
                        
                        if (str_word_count($builder_text) >= 20) {
                            $content = $builder_text;
                        }
                    }
                }
                
                // Also try manual extraction from Themify data
                if (empty($content) || str_word_count($content) < 20) {
                    foreach ($themify_keys as $meta_key) {
                        $themify_data = get_post_meta($post_id, $meta_key, true);
                        if (!empty($themify_data)) {
                            if (is_string($themify_data)) {
                                $data = json_decode($themify_data, true);
                                if (is_array($data)) {
                                    $extracted = $this->extract_themify_text($data);
                                    if (str_word_count($extracted) > str_word_count($content)) {
                                        $content = $extracted;
                                    }
                                }
                            } elseif (is_array($themify_data)) {
                                $extracted = $this->extract_themify_text($themify_data);
                                if (str_word_count($extracted) > str_word_count($content)) {
                                    $content = $extracted;
                                }
                            }
                        }
                    }
                }
            }
            
            // Try full description (LONG DESCRIPTION)
            if (empty($content) || str_word_count($content) < 5) {
                if (!empty($post->post_content)) {
                    // Process shortcodes first
                    $desc = do_shortcode($post->post_content);
                    $desc = wp_strip_all_tags($desc);
                    $desc = preg_replace('/\s+/', ' ', $desc);
                    $desc = trim($desc);
                    
                    // Accept any meaningful text (5+ words)
                    if (!empty($desc) && str_word_count($desc) >= 5) {
                        $content = $desc;
                    }
                }
            }
            
            // Fallback to short description (SHORT DESCRIPTION) if long is empty/short
            if (empty($content) || str_word_count($content) < 5) {
                if (!empty($post->post_excerpt)) {
                    $short_desc = do_shortcode($post->post_excerpt);
                    $short_desc = wp_strip_all_tags($short_desc);
                    $short_desc = preg_replace('/\s+/', ' ', $short_desc);
                    $short_desc = trim($short_desc);
                    
                    // Accept ANY non-empty short description
                    if (!empty($short_desc) && str_word_count($short_desc) > 0) {
                        $content = $short_desc;
                    }
                }
            }
            
            // Final fallback: create from title + category + price
            if (empty($content) || str_word_count($content) < 5) {
                $product_desc = '';
                
                if (!empty($post->post_title)) {
                    $product_desc = $post->post_title;
                }
                
                $categories = get_the_terms($post_id, 'product_cat');
                if (!empty($categories) && !is_wp_error($categories)) {
                    $cat_names = array();
                    foreach ($categories as $cat) {
                        $cat_names[] = $cat->name;
                    }
                    $product_desc .= ' - ' . implode(', ', $cat_names);
                }
                
                if (function_exists('wc_get_product')) {
                    $product = wc_get_product($post_id);
                    if ($product) {
                        $price = $product->get_price();
                        if ($price) {
                            $currency = get_woocommerce_currency_symbol();
                            $product_desc .= '. Cena: ' . $price . ' ' . $currency;
                        }
                    }
                }
                
                if (!empty($product_desc) && str_word_count($product_desc) > 0) {
                    $content = $product_desc;
                }
            }
            
            // If we got WooCommerce content, return it immediately
            if (!empty($content) && str_word_count($content) >= 3) {
                return trim($content);
            }
        }
        
        // Method 1: Elementor - use Elementor's own frontend rendering
        if (class_exists('\Elementor\Plugin')) {
            $elementor_data = get_post_meta($post_id, '_elementor_data', true);
            if (!empty($elementor_data)) {
                // Try Elementor's frontend builder
                if (class_exists('\Elementor\Frontend')) {
                    $frontend = \Elementor\Plugin::instance()->frontend;
                    if ($frontend) {
                        ob_start();
                        echo $frontend->get_builder_content_for_display($post_id, true);
                        $rendered = ob_get_clean();
                        if (!empty($rendered)) {
                            $content = wp_strip_all_tags($rendered);
                            $content = preg_replace('/\s+/', ' ', $content);
                            $content = trim($content);
                        }
                    }
                }
                
                // If that didn't work, extract from JSON
                if (empty($content) || str_word_count($content) < 50) {
                    $data = json_decode($elementor_data, true);
                    if (is_array($data)) {
                        $extracted = '';
                        $this->extract_elementor_text($data, $extracted);
                        if (str_word_count($extracted) > str_word_count($content)) {
                            $content = $extracted;
                        }
                    }
                }
            }
        }
        
        // Method 2: Divi Builder
        if (empty($content) || str_word_count($content) < 50) {
            $divi_content = get_post_meta($post_id, '_et_builder_content', true);
            if (!empty($divi_content)) {
                $content = $this->extract_divi_text($divi_content);
            } elseif (strpos($post->post_content, '[et_pb_') !== false) {
                $content = $this->extract_divi_text($post->post_content);
            }
        }
        
        // Method 3: Beaver Builder
        if ((empty($content) || str_word_count($content) < 50) && class_exists('FLBuilderModel')) {
            $beaver_data = get_post_meta($post_id, '_fl_builder_data', true);
            if (!empty($beaver_data) && is_array($beaver_data)) {
                $content = $this->extract_beaver_text($beaver_data);
            }
        }
        
        // Method 4: WPBakery (Visual Composer)
        if ((empty($content) || str_word_count($content) < 50) && (defined('WPB_VC_VERSION') || class_exists('Vc_Manager'))) {
            if (strpos($post->post_content, '[vc_') !== false) {
                $content = $this->extract_wpbakery_text($post->post_content);
            }
        }
        
        // Method 5: Bricks Builder
        if (empty($content) || str_word_count($content) < 50) {
            $bricks_data = get_post_meta($post_id, '_bricks_page_content_2', true);
            if (!empty($bricks_data) && is_array($bricks_data)) {
                $content = $this->extract_bricks_text($bricks_data);
            }
        }
        
        // Method 6: Oxygen Builder
        if (empty($content) || str_word_count($content) < 50) {
            $oxygen_data = get_post_meta($post_id, 'ct_builder_shortcodes', true);
            if (!empty($oxygen_data)) {
                $content = $this->extract_oxygen_text($oxygen_data);
            }
        }
        
        // Method 7: Brizy Builder
        if (empty($content) || str_word_count($content) < 50) {
            $brizy_data = get_post_meta($post_id, 'brizy_post_uid', true);
            if (!empty($brizy_data)) {
                $brizy_content = get_post_meta($post_id, 'brizy-post-editor-data', true);
                if (!empty($brizy_content)) {
                    $content = $this->extract_brizy_text($brizy_content);
                }
            }
        }
        
        // Method 8: Themify Builder - check multiple meta keys
        if (empty($content) || str_word_count($content) < 50) {
            // Try different Themify meta keys (Builder, Builder Pro, PTB)
            $themify_keys = array(
                '_themify_builder_settings_json',
                '_themify_builder_settings',
                'themify_builder_data',
                '_themify_builder_data',
                'themify_builder_data_json',
                '_tb_import_export',
                'tbp_template_builder_data', // Builder Pro templates
                '_tbp_template_builder_data',
            );
            
            foreach ($themify_keys as $meta_key) {
                $themify_data = get_post_meta($post_id, $meta_key, true);
                if (!empty($themify_data)) {
                    if (is_string($themify_data)) {
                        // Try JSON decode
                        $data = json_decode($themify_data, true);
                        if (is_array($data)) {
                            $extracted = $this->extract_themify_text($data);
                            if (str_word_count($extracted) > str_word_count($content)) {
                                $content = $extracted;
                            }
                        }
                    } elseif (is_array($themify_data)) {
                        $extracted = $this->extract_themify_text($themify_data);
                        if (str_word_count($extracted) > str_word_count($content)) {
                            $content = $extracted;
                        }
                    }
                }
            }
            
            // Try Themify's own rendering if available (Builder or Builder Pro)
            if ((empty($content) || str_word_count($content) < 50)) {
                // Method A: Themify Builder standard
                if (class_exists('Themify_Builder')) {
                    global $ThemifyBuilder;
                    if (isset($ThemifyBuilder) && method_exists($ThemifyBuilder, 'get_builder_output')) {
                        $builder_output = $ThemifyBuilder->get_builder_output($post_id);
                        if (!empty($builder_output)) {
                            $rendered = wp_strip_all_tags($builder_output);
                            $rendered = preg_replace('/\s+/', ' ', $rendered);
                            if (str_word_count($rendered) > str_word_count($content)) {
                                $content = trim($rendered);
                            }
                        }
                    }
                }
                
                // Method B: Builder Pro - use Themify_Builder_Component class
                if (class_exists('Themify_Builder_Component')) {
                    $builder_data = get_post_meta($post_id, '_themify_builder_settings_json', true);
                    if (!empty($builder_data)) {
                        $builder_content = Themify_Builder_Component::retrieve_template('builder-output', array(
                            'builder_output' => $builder_data,
                            'builder_id' => $post_id
                        ), '', '', false);
                        if (!empty($builder_content)) {
                            $rendered = wp_strip_all_tags($builder_content);
                            $rendered = preg_replace('/\s+/', ' ', $rendered);
                            if (str_word_count($rendered) > str_word_count($content)) {
                                $content = trim($rendered);
                            }
                        }
                    }
                }
            }
            
            // Themify also stores content in post_content with shortcodes [tb_] or [tbp_]
            if ((empty($content) || str_word_count($content) < 50)) {
                if (strpos($post->post_content, '[tb_') !== false || strpos($post->post_content, '[tbp_') !== false) {
                    $processed = do_shortcode($post->post_content);
                    $processed = wp_strip_all_tags($processed);
                    $processed = preg_replace('/\s+/', ' ', $processed);
                    if (str_word_count($processed) > str_word_count($content)) {
                        $content = trim($processed);
                    }
                }
            }
        }
        
        // Method 9: Try the_content filter with shortcode processing
        if (empty($content) || str_word_count($content) < 50) {
            $raw_content = $post->post_content;
            $processed = do_shortcode($raw_content);
            $processed = wp_strip_all_tags($processed);
            $processed = preg_replace('/\s+/', ' ', $processed);
            $processed = trim($processed);
            
            if (str_word_count($processed) > str_word_count($content)) {
                $content = $processed;
            }
        }
        
        // Fallback: Gutenberg/Classic
        if (empty($content)) {
            $content = wp_strip_all_tags($post->post_content);
            $content = preg_replace('/\s+/', ' ', $content);
        }
        
        return trim($content);
    }
    
    /**
     * Extract text from Elementor
     */
    private function extract_elementor_text($data, &$text = '') {
        if (!is_array($data)) return $text;
        
        foreach ($data as $element) {
            if (!is_array($element)) continue;
            
            if (isset($element['settings'])) {
                foreach ($element['settings'] as $key => $value) {
                    // Extract text from string values
                    if (is_string($value) && !empty($value)) {
                        // Check for text-related keys
                        $text_keys = array('text', 'title', 'description', 'content', 'editor', 
                                          'heading', 'caption', 'label', 'placeholder', 'html',
                                          'blockquote', 'testimonial', 'inner_text', 'prefix', 'suffix',
                                          'before_text', 'after_text', 'highlighted_text', 'rotating_text',
                                          'item_description', 'tab_title', 'tab_content', 'accordion_title',
                                          'alert_title', 'alert_description', 'price', 'currency',
                                          'button_text', 'link_text', 'read_more_text');
                        
                        $is_text_field = false;
                        foreach ($text_keys as $text_key) {
                            if (stripos($key, $text_key) !== false) {
                                $is_text_field = true;
                                break;
                            }
                        }
                        
                        if ($is_text_field) {
                            $clean = wp_strip_all_tags($value);
                            $clean = preg_replace('/\s+/', ' ', $clean);
                            if (!empty(trim($clean)) && strlen($clean) > 1) {
                                $text .= ' ' . $clean;
                            }
                        }
                    }
                    
                    // Recursively check arrays (for repeater fields, etc.)
                    if (is_array($value)) {
                        $this->extract_elementor_text($value, $text);
                    }
                }
            }
            
            // Process nested elements
            if (isset($element['elements'])) {
                $this->extract_elementor_text($element['elements'], $text);
            }
        }
        
        return $text;
    }
    
    /**
     * Extract text from Divi Builder
     */
    private function extract_divi_text($content) {
        // Remove Divi shortcodes but keep content
        $text = preg_replace('/\[et_pb_[^\]]*\]/', '', $content);
        $text = preg_replace('/\[\/et_pb_[^\]]*\]/', '', $text);
        
        // Clean up
        $text = wp_strip_all_tags($text);
        $text = preg_replace('/\s+/', ' ', $text);
        
        return trim($text);
    }
    
    /**
     * Extract text from Themify Builder (supports Builder and Builder Pro)
     * Only extracts actual content text, skips buttons/navigation/labels
     */
    private function extract_themify_text($data, &$text = '') {
        if (!is_array($data)) return $text;
        
        foreach ($data as $key => $value) {
            // Skip module types that are typically navigation/buttons
            if ($key === 'mod_name' && is_string($value)) {
                // Skip button, menu, navigation modules entirely
                if (in_array($value, array('buttons', 'button', 'menu', 'nav', 'social', 'icon', 'link'))) {
                    return $text;
                }
            }
            
            // Direct text content fields - ONLY actual content, not buttons/labels
            if (is_string($value) && !empty($value)) {
                // Only these fields contain actual readable content
                $content_keys = array(
                    'content_text',      // Main text content
                    'text_content',      // Text module content
                    'html_content',      // HTML module content  
                    'editor_content',    // Editor content
                    'content',           // Generic content
                    'description',       // Descriptions
                    'quote_content',     // Quote text
                    'testimonial_content', // Testimonial text
                    'feature_content',   // Feature box content
                    'post_content',      // Post content
                    'archive_description', // Archive description
                    // Explicitly SKIP: button_text, label, title, heading, link_text, etc.
                );
                
                if (in_array($key, $content_keys)) {
                    $clean = wp_strip_all_tags($value);
                    $clean = preg_replace('/\s+/', ' ', $clean);
                    $clean = trim($clean);
                    
                    // Only add if it's substantial content (not just a few words)
                    if (!empty($clean) && mb_strlen($clean) > 30 && str_word_count($clean) > 5) {
                        $text .= ' ' . $clean;
                    }
                }
            }
            
            // Check mod_settings for content fields
            elseif ($key === 'mod_settings' && is_array($value)) {
                // First check if this is a button/menu module - skip it
                if (isset($value['mod_name']) && in_array($value['mod_name'], array('buttons', 'button', 'menu', 'nav', 'social', 'icon', 'link'))) {
                    continue;
                }
                
                foreach ($value as $mod_key => $mod_value) {
                    if (is_string($mod_value) && !empty($mod_value)) {
                        // Only actual content fields
                        $content_mod_keys = array(
                            'content_text',
                            'text_content', 
                            'html_content',
                            'editor_content',
                            'content',
                            'description',
                            'quote_content',
                            'testimonial_content',
                            'feature_content',
                        );
                        
                        if (in_array($mod_key, $content_mod_keys)) {
                            $clean = wp_strip_all_tags($mod_value);
                            $clean = preg_replace('/\s+/', ' ', $clean);
                            $clean = trim($clean);
                            
                            // Only substantial content
                            if (!empty($clean) && mb_strlen($clean) > 30 && str_word_count($clean) > 5) {
                                $text .= ' ' . $clean;
                            }
                        }
                    }
                    // Check nested arrays
                    elseif (is_array($mod_value)) {
                        $this->extract_themify_text($mod_value, $text);
                    }
                }
            }
            
            // Skip styling arrays
            elseif ($key === 'styling') {
                continue;
            }
            
            // Recursively process arrays (cols, modules, rows, elements, etc.)
            elseif (is_array($value)) {
                $this->extract_themify_text($value, $text);
            }
        }
        
        return trim($text);
    }
    
    /**
     * Extract text from Beaver Builder
     */
    private function extract_beaver_text($data, &$text = '') {
        if (!is_array($data)) return $text;
        
        foreach ($data as $node) {
            if (!is_object($node) && !is_array($node)) continue;
            
            $node = (array) $node;
            
            // Check settings
            if (isset($node['settings'])) {
                $settings = (array) $node['settings'];
                $text_fields = array('text', 'html', 'content', 'title', 'heading', 'description', 'editor');
                
                foreach ($text_fields as $field) {
                    if (isset($settings[$field]) && is_string($settings[$field])) {
                        $clean = wp_strip_all_tags($settings[$field]);
                        if (!empty(trim($clean))) {
                            $text .= ' ' . $clean;
                        }
                    }
                }
            }
        }
        
        return trim($text);
    }
    
    /**
     * Extract text from WPBakery (Visual Composer)
     */
    private function extract_wpbakery_text($content) {
        // Parse shortcodes and extract content
        $text = '';
        
        // Match content between shortcodes
        preg_match_all('/\[vc_column_text[^\]]*\](.*?)\[\/vc_column_text\]/s', $content, $matches);
        if (!empty($matches[1])) {
            foreach ($matches[1] as $match) {
                $text .= ' ' . $match;
            }
        }
        
        // Extract from other text elements
        preg_match_all('/\[vc_custom_heading[^\]]*text="([^"]+)"/s', $content, $headings);
        if (!empty($headings[1])) {
            foreach ($headings[1] as $heading) {
                $text .= ' ' . $heading;
            }
        }
        
        // Text blocks
        preg_match_all('/content="([^"]+)"/', $content, $contents);
        if (!empty($contents[1])) {
            foreach ($contents[1] as $c) {
                $text .= ' ' . $c;
            }
        }
        
        // Clean shortcodes from remaining content
        $remaining = preg_replace('/\[[^\]]+\]/', '', $content);
        $text .= ' ' . $remaining;
        
        // Clean up
        $text = wp_strip_all_tags($text);
        $text = preg_replace('/\s+/', ' ', $text);
        
        return trim($text);
    }
    
    /**
     * Extract text from Bricks Builder
     */
    private function extract_bricks_text($data, &$text = '') {
        if (!is_array($data)) return $text;
        
        foreach ($data as $element) {
            if (!is_array($element)) continue;
            
            // Check settings
            if (isset($element['settings'])) {
                $settings = $element['settings'];
                $text_fields = array('text', 'content', 'title', 'heading', 'description', 'richtext', 'editor');
                
                foreach ($text_fields as $field) {
                    if (isset($settings[$field])) {
                        $value = $settings[$field];
                        if (is_string($value)) {
                            $clean = wp_strip_all_tags($value);
                            if (!empty(trim($clean))) {
                                $text .= ' ' . $clean;
                            }
                        }
                    }
                }
            }
            
            // Check children
            if (isset($element['children']) && is_array($element['children'])) {
                $this->extract_bricks_text($element['children'], $text);
            }
        }
        
        return trim($text);
    }
    
    /**
     * Extract text from Oxygen Builder
     */
    private function extract_oxygen_text($content) {
        // Oxygen stores content as shortcodes
        $text = '';
        
        // Extract text from ct_text_block
        preg_match_all('/\[ct_text_block[^\]]*\](.*?)\[\/ct_text_block\]/s', $content, $matches);
        if (!empty($matches[1])) {
            foreach ($matches[1] as $match) {
                $text .= ' ' . $match;
            }
        }
        
        // Extract headlines
        preg_match_all('/\[ct_headline[^\]]*\](.*?)\[\/ct_headline\]/s', $content, $headlines);
        if (!empty($headlines[1])) {
            foreach ($headlines[1] as $headline) {
                $text .= ' ' . $headline;
            }
        }
        
        // Extract from content attributes
        preg_match_all('/content(?:_plain)?="([^"]+)"/', $content, $contents);
        if (!empty($contents[1])) {
            foreach ($contents[1] as $c) {
                $text .= ' ' . $c;
            }
        }
        
        // Clean up
        $text = wp_strip_all_tags($text);
        $text = html_entity_decode($text);
        $text = preg_replace('/\s+/', ' ', $text);
        
        return trim($text);
    }
    
    /**
     * Extract text from Brizy Builder
     */
    private function extract_brizy_text($content) {
        $text = '';
        
        // Brizy stores data as JSON
        if (is_string($content)) {
            $data = json_decode($content, true);
            if (is_array($data)) {
                $text = $this->extract_array_text($data);
            }
        } elseif (is_array($content)) {
            $text = $this->extract_array_text($content);
        }
        
        return trim($text);
    }
    
    /**
     * Extract text from array (Themify, Gutenberg)
     */
    private function extract_array_text($data, &$text = '') {
        if (!is_array($data)) return $text;
        
        foreach ($data as $key => $value) {
            if (is_string($value)) {
                $text_fields = array('text', 'content', 'title', 'heading', 'description');
                foreach ($text_fields as $field) {
                    if (stripos($key, $field) !== false) {
                        $clean = wp_strip_all_tags($value);
                        if (!empty(trim($clean))) {
                            $text .= ' ' . $clean;
                        }
                        break;
                    }
                }
            } elseif (is_array($value)) {
                $this->extract_array_text($value, $text);
            }
        }
        
        return $text;
    }
    
    /**
     * Add SEO column to post list tables
     */
    public function add_seo_column($columns) {
        $new_columns = array();
        foreach ($columns as $key => $value) {
            $new_columns[$key] = $value;
            if ($key === 'title') {
                $new_columns['wseo_seo'] = 'SEO';
            }
        }
        return $new_columns;
    }
    
    /**
     * Filter posts by SEO issues
     */
    public function filter_posts_by_seo_issues($query) {
        if (!is_admin() || !$query->is_main_query()) {
            return;
        }
        
        // Only for edit.php
        global $pagenow;
        if ($pagenow !== 'edit.php') {
            return;
        }
        
        $filter = isset($_GET['wseo_filter']) ? sanitize_text_field($_GET['wseo_filter']) : '';
        
        if (empty($filter)) {
            return;
        }
        
        // Set post types to include all public types
        $post_type = isset($_GET['post_type']) ? $_GET['post_type'] : 'post';
        if ($post_type === 'any') {
            $query->set('post_type', array('post', 'page', 'product'));
        }
        
        // Always show published posts
        $query->set('post_status', 'publish');
        
        global $wpdb;
        
        switch ($filter) {
            case 'no_meta_desc':
                // Posts without custom meta description
                $posts_with_desc = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_meta_description' AND meta_value != ''
                ");
                if (!empty($posts_with_desc)) {
                    $query->set('post__not_in', $posts_with_desc);
                }
                break;
                
            case 'no_thumbnail':
                // Posts without featured image
                $posts_with_thumb = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_thumbnail_id' AND meta_value != ''
                ");
                if (!empty($posts_with_thumb)) {
                    $query->set('post__not_in', $posts_with_thumb);
                }
                break;
                
            case 'short_desc':
                // Posts with short meta description
                $posts_short_desc = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_meta_description' 
                    AND meta_value != '' 
                    AND CHAR_LENGTH(meta_value) < 120
                ");
                if (!empty($posts_short_desc)) {
                    $query->set('post__in', $posts_short_desc);
                } else {
                    $query->set('post__in', array(0)); // No results
                }
                break;
                
            case 'long_title':
                // Posts with long meta title
                $posts_long_title = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_meta_title' 
                    AND meta_value != '' 
                    AND CHAR_LENGTH(meta_value) > 60
                ");
                if (!empty($posts_long_title)) {
                    $query->set('post__in', $posts_long_title);
                } else {
                    $query->set('post__in', array(0)); // No results
                }
                break;
                
            case 'no_keywords':
                // Posts without focus keywords
                $posts_with_keywords = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_meta_keywords' AND meta_value != ''
                ");
                if (!empty($posts_with_keywords)) {
                    $query->set('post__not_in', $posts_with_keywords);
                }
                break;
                
            case 'noindex':
                // Posts with noindex
                $noindex_posts = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_noindex' AND meta_value = '1'
                ");
                if (!empty($noindex_posts)) {
                    $query->set('post__in', $noindex_posts);
                } else {
                    $query->set('post__in', array(0)); // No results
                }
                break;
        }
    }
    
    /**
     * Filter media by alt text
     */
    public function filter_media_by_alt($query) {
        if (!is_admin() || !$query->is_main_query()) {
            return;
        }
        
        // Only for media library
        global $pagenow;
        if ($pagenow !== 'upload.php') {
            return;
        }
        
        $filter = isset($_GET['wseo_filter']) ? sanitize_text_field($_GET['wseo_filter']) : '';
        
        if ($filter === 'no_alt') {
            global $wpdb;
            
            // Get images with alt text
            $images_with_alt = $wpdb->get_col("
                SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                WHERE meta_key = '_wp_attachment_image_alt' AND meta_value != ''
            ");
            
            if (!empty($images_with_alt)) {
                $query->set('post__not_in', $images_with_alt);
            }
        }
    }
    
    /**
     * Render SEO column content
     */
    public function render_seo_column($column, $post_id) {
        if ($column !== 'wseo_seo') return;
        
        $post = get_post($post_id);
        $site_name = get_option('wseo_global_site_name', get_bloginfo('name'));
        
        // Get saved values
        $meta_title = get_post_meta($post_id, '_wseo_meta_title', true);
        $meta_description = get_post_meta($post_id, '_wseo_meta_description', true);
        $meta_keywords = get_post_meta($post_id, '_wseo_meta_keywords', true);
        $redirect_url = get_post_meta($post_id, '_wseo_redirect_url', true);
        $redirect_type = get_post_meta($post_id, '_wseo_redirect_type', true);
        
        // Schema fields for Quick Edit
        $schema_type = get_post_meta($post_id, '_wseo_schema_type', true);
        $schema_name = get_post_meta($post_id, '_wseo_schema_name', true);
        $article_type = get_post_meta($post_id, '_wseo_article_type', true);
        $noindex = get_post_meta($post_id, '_wseo_noindex', true);
        $nofollow = get_post_meta($post_id, '_wseo_nofollow', true);
        
        // Additional schema fields
        $schema_address = get_post_meta($post_id, '_wseo_schema_address', true);
        $schema_city = get_post_meta($post_id, '_wseo_schema_city', true);
        $schema_zip = get_post_meta($post_id, '_wseo_schema_zip', true);
        $schema_phone = get_post_meta($post_id, '_wseo_schema_phone', true);
        $schema_email = get_post_meta($post_id, '_wseo_schema_email', true);
        // v2.9.12: opening hours removed - now uses day-by-day format
        $schema_price_range = get_post_meta($post_id, '_wseo_schema_price_range', true);
        
        // v2.10.12: Generate auto values using same logic as <head> output
        $auto_title = get_the_title($post_id);
        $auto_description = $this->generate_meta_description($post->post_content);
        $auto_keywords = $this->auto_extract_keywords($auto_title, $post);
        
        // Hidden fields for Quick Edit
        echo '<div class="hidden wseo-quick-edit-data">';
        echo '<span class="wseo-title">' . esc_attr($meta_title) . '</span>';
        echo '<span class="wseo-description">' . esc_attr($meta_description) . '</span>';
        echo '<span class="wseo-keywords">' . esc_attr($meta_keywords) . '</span>';
        echo '<span class="wseo-auto-title">' . esc_attr($auto_title) . '</span>';
        echo '<span class="wseo-auto-description">' . esc_attr($auto_description) . '</span>';
        echo '<span class="wseo-auto-keywords">' . esc_attr($auto_keywords) . '</span>';
        echo '<span class="wseo-redirect">' . esc_attr($redirect_url) . '</span>';
        echo '<span class="wseo-redirect-type">' . esc_attr($redirect_type) . '</span>';
        echo '<span class="wseo-schema-type">' . esc_attr($schema_type) . '</span>';
        echo '<span class="wseo-schema-name">' . esc_attr($schema_name) . '</span>';
        echo '<span class="wseo-article-type">' . esc_attr($article_type) . '</span>';
        echo '<span class="wseo-noindex">' . esc_attr($noindex) . '</span>';
        echo '<span class="wseo-nofollow">' . esc_attr($nofollow) . '</span>';
        echo '<span class="wseo-address">' . esc_attr($schema_address) . '</span>';
        echo '<span class="wseo-city">' . esc_attr($schema_city) . '</span>';
        echo '<span class="wseo-zip">' . esc_attr($schema_zip) . '</span>';
        echo '<span class="wseo-phone">' . esc_attr($schema_phone) . '</span>';
        echo '<span class="wseo-email">' . esc_attr($schema_email) . '</span>';
        // v2.9.12: wseo-opening removed from Quick Edit
        echo '<span class="wseo-price-range">' . esc_attr($schema_price_range) . '</span>';
        echo '<span class="wseo-schema-image">' . esc_attr(get_post_meta($post_id, '_wseo_schema_image', true)) . '</span>';
        echo '</div>';
        
        // Calculate SEO Audit score (same logic as in meta-box.php)
        $audit_score = 0;
        $audit_max = 0;
        
        $content = $post->post_content;
        $content_text = wp_strip_all_tags($content);
        $word_count = str_word_count($content_text);
        $title = get_the_title($post_id);
        
        // Focus keyword - use manual or auto-extract from title
        $focus_keyword = strtolower(trim($meta_keywords));
        if (empty($focus_keyword)) {
            // Auto-extract keywords from title
            $focus_keyword = $this->auto_extract_keywords($title, $post);
        }
        $focus_keywords = array_map('trim', explode(',', $focus_keyword));
        $primary_keyword = !empty($focus_keywords[0]) ? $focus_keywords[0] : '';
        
        // 1. Meta Title (10 pts)
        $audit_max += 10;
        if (!empty($meta_title)) {
            $audit_score += 10;
        } else {
            $audit_score += 5; // Auto-generated
        }
        
        // 2. Meta Title Length (10 pts)
        $audit_max += 10;
        $title_length = mb_strlen($meta_title ?: $title);
        if ($title_length >= 30 && $title_length <= 60) {
            $audit_score += 10;
        } elseif ($title_length > 0) {
            $audit_score += 5;
        }
        
        // 3. Meta Description (10 pts)
        $audit_max += 10;
        if (!empty($meta_description)) {
            $audit_score += 10;
        } else {
            $audit_score += 5; // Auto-generated
        }
        
        // 4. Meta Description Length (10 pts)
        $audit_max += 10;
        $desc_length = mb_strlen($meta_description);
        if ($desc_length >= 120 && $desc_length <= 160) {
            $audit_score += 10;
        } elseif ($desc_length > 0) {
            $audit_score += 5;
        } else {
            $audit_score += 5; // Auto-generated
        }
        
        // 5. Focus Keyword (10 pts)
        $audit_max += 10;
        if (!empty($primary_keyword)) {
            $audit_score += 10;
        }
        
        // 6. Keyword in Title (10 pts)
        $audit_max += 10;
        if (!empty($primary_keyword)) {
            $check_title = strtolower($meta_title ?: $title);
            if (strpos($check_title, $primary_keyword) !== false) {
                $audit_score += 10;
            }
        }
        
        // 7. Content Length (10 pts)
        $audit_max += 10;
        if ($word_count >= 300) {
            $audit_score += 10;
        } elseif ($word_count >= 150) {
            $audit_score += 5;
        }
        
        // 8. Headings (10 pts)
        $audit_max += 10;
        preg_match_all('/<h[23][^>]*>/i', $content, $heading_matches);
        $total_headings = count($heading_matches[0]);
        if ($total_headings >= 2) {
            $audit_score += 10;
        } elseif ($total_headings >= 1) {
            $audit_score += 5;
        }
        
        // 9. Featured Image (5 pts)
        $audit_max += 5;
        if (has_post_thumbnail($post_id)) {
            $audit_score += 5;
        }
        
        // 10. Internal Links (5 pts)
        $audit_max += 5;
        $site_url = home_url();
        preg_match_all('/<a[^>]+href=["\']([^"\']+)["\'][^>]*>/i', $content, $link_matches);
        $internal_links = 0;
        foreach ($link_matches[1] as $link) {
            if (strpos($link, $site_url) === 0 || strpos($link, '/') === 0) {
                $internal_links++;
            }
        }
        if ($internal_links >= 2) {
            $audit_score += 5;
        } elseif ($internal_links >= 1) {
            $audit_score += 2;
        }
        
        // Calculate percentage
        $audit_percentage = $audit_max > 0 ? round(($audit_score / $audit_max) * 100) : 0;
        
        // Display based on percentage
        if ($audit_percentage >= 80) {
            echo '<strong class="wseo-rating-good">' . $audit_percentage . '%</strong>';
        } elseif ($audit_percentage >= 50) {
            echo '<strong class="wseo-rating-short">' . $audit_percentage . '%</strong>';
        } else {
            echo '<strong class="wseo-rating-long">' . $audit_percentage . '%</strong>';
        }
    }
    
    /**
     * v2.10.07: Auto-extract focus keywords from title and content
     * Removes stop words and extracts meaningful keywords
     */
    private function auto_extract_keywords($title, $post = null) {
        // Slovak/Czech stop words to ignore
        $stop_words = array(
            // Slovak
            'a', 'aj', 'ak', 'ako', 'ale', 'alebo', 'ani', 'áno', 'asi', 'až', 'bez', 'bol', 'bola', 'boli', 'bolo', 'budem', 'bude', 'by', 'byť',
            'cez', 'či', 'čo', 'ďalší', 'ďalšia', 'do', 'ešte', 'ho', 'ich', 'im', 'iné', 'iný', 'ja', 'je', 'jeho', 'jej', 'ju', 'k', 'kam', 'každý',
            'kde', 'keď', 'kto', 'ktorá', 'ktoré', 'ktorí', 'ktorý', 'ku', 'lebo', 'len', 'ma', 'má', 'mať', 'me', 'medzi', 'mi', 'mne', 'mnou',
            'moja', 'moje', 'môj', 'môže', 'môžem', 'môžeš', 'mu', 'musí', 'musím', 'my', 'na', 'nad', 'nám', 'náš', 'naša', 'naše', 'nebol',
            'nebola', 'neboli', 'nebude', 'nech', 'nie', 'niečo', 'niektorí', 'niektorý', 'nič', 'no', 'nový', 'nová', 'nové', 'o', 'od', 'on',
            'ona', 'oni', 'ono', 'po', 'pod', 'podľa', 'pokiaľ', 'potom', 'práve', 'pre', 'prečo', 'pred', 'pri', 'preto', 's', 'sa', 'si', 'sme',
            'so', 'som', 'späť', 'ste', 'sú', 'svoj', 'svoja', 'svoje', 'ta', 'tak', 'takže', 'tam', 'táto', 'teda', 'ten', 'tento', 'tieto', 'tiež',
            'títo', 'to', 'toho', 'tom', 'tomto', 'toto', 'tu', 'tú', 'túto', 'tvoj', 'tvoja', 'tvoje', 'ty', 'už', 'v', 'vám', 'váš', 'vaša', 'vaše',
            'veľa', 'veľmi', 'vo', 'však', 'všetci', 'všetko', 'vy', 'z', 'za', 'zo', 'že',
            // English common
            'the', 'a', 'an', 'and', 'or', 'but', 'in', 'on', 'at', 'to', 'for', 'of', 'with', 'by', 'from', 'is', 'are', 'was', 'were', 'be', 'been',
            'being', 'have', 'has', 'had', 'do', 'does', 'did', 'will', 'would', 'could', 'should', 'may', 'might', 'must', 'can', 'this', 'that',
            'these', 'those', 'it', 'its', 'as', 'if', 'when', 'than', 'because', 'while', 'where', 'after', 'before', 'about', 'into', 'through',
            'during', 'above', 'below', 'between', 'under', 'again', 'further', 'then', 'once', 'here', 'there', 'all', 'each', 'few', 'more',
            'most', 'other', 'some', 'such', 'no', 'not', 'only', 'own', 'same', 'so', 'very', 'just', 'now', 'also', 'well', 'new',
            // Numbers and units
            'ks', 'cm', 'mm', 'm', 'kg', 'g', 'ml', 'l', 'x', 'pcs'
        );
        
        // Clean title - remove special chars, keep letters and numbers
        $clean_title = mb_strtolower($title);
        $clean_title = preg_replace('/[^\p{L}\p{N}\s]/u', ' ', $clean_title);
        $clean_title = preg_replace('/\s+/', ' ', $clean_title);
        
        // Split into words
        $words = explode(' ', trim($clean_title));
        
        // Filter out stop words and short words
        $keywords = array();
        foreach ($words as $word) {
            $word = trim($word);
            // Skip if: empty, too short (< 3 chars), is a number, or is a stop word
            if (empty($word) || mb_strlen($word) < 3 || is_numeric($word) || in_array($word, $stop_words)) {
                continue;
            }
            $keywords[] = $word;
        }
        
        // For WooCommerce products, add category as keyword
        if ($post && $post->post_type === 'product' && function_exists('wc_get_product')) {
            $product_cats = wp_get_post_terms($post->ID, 'product_cat', array('fields' => 'names'));
            if (!empty($product_cats) && !is_wp_error($product_cats)) {
                // Add first category (most specific usually)
                $cat_name = mb_strtolower($product_cats[0]);
                $cat_name = preg_replace('/[^\p{L}\p{N}\s]/u', ' ', $cat_name);
                $cat_words = explode(' ', trim($cat_name));
                foreach ($cat_words as $cat_word) {
                    $cat_word = trim($cat_word);
                    if (!empty($cat_word) && mb_strlen($cat_word) >= 3 && !in_array($cat_word, $stop_words) && !in_array($cat_word, $keywords)) {
                        $keywords[] = $cat_word;
                    }
                }
            }
        }
        
        // Return first 3 keywords as comma-separated string
        $keywords = array_slice(array_unique($keywords), 0, 3);
        
        return implode(', ', $keywords);
    }
    
    /**
     * v2.10.07: Public static wrapper for auto_extract_keywords (for use in templates)
     */
    public function auto_extract_keywords_static($title, $post = null) {
        return $this->auto_extract_keywords($title, $post);
    }
    
    /**
     * Quick Edit fields
     */
    public function quick_edit_fields($column_name, $post_type) {
        if ($column_name !== 'wseo_seo') return;
        
        wp_nonce_field('wseo_quick_edit', 'wseo_quick_edit_nonce');
        ?>
        <fieldset class="inline-edit-col-left wseo-quick-edit-full">
            <div class="inline-edit-col">
                <h4 style="margin: 10px 0; border-bottom: 1px solid #ddd; padding-bottom: 5px;">🔍 SEO nastavenia</h4>
                
                <div class="wseo-qe-row">
                    <div class="wseo-qe-col-2">
                        <label class="inline-edit-group">
                            <span class="title">Meta Title</span>
                            <div class="wseo-qe-progress-wrap">
                                <div class="wseo-qe-progress-bar" id="wseo-qe-title-progress">
                                    <div class="wseo-qe-progress-fill"></div>
                                </div>
                                <span class="wseo-qe-char-count" id="wseo-qe-title-count">0 znakov</span>
                            </div>
                            <span class="input-text-wrap">
                                <input type="text" name="wseo_meta_title" class="wseo-qe-title" value="" style="width: 100%;" data-site-name="<?php echo esc_attr(get_option('wseo_global_site_name', get_bloginfo('name'))); ?>">
                                <span class="wseo-qe-title-suffix" style="color: #666; font-style: italic; font-size: 12px;"> - <?php echo esc_html(get_option('wseo_global_site_name', get_bloginfo('name'))); ?></span>
                            </span>
                        </label>
                    </div>
                    <div class="wseo-qe-col-2">
                        <label class="inline-edit-group">
                            <span class="title">🎯 Focus Keyword</span>
                            <span class="input-text-wrap">
                                <input type="text" name="wseo_meta_keywords" class="wseo-qe-keywords" value="" style="width: 100%;" placeholder="pre SEO analýzu">
                            </span>
                        </label>
                    </div>
                </div>
                
                <div class="wseo-qe-row">
                    <div class="wseo-qe-col-1">
                        <label class="inline-edit-group">
                            <span class="title">Meta popis</span>
                            <div class="wseo-qe-progress-wrap">
                                <div class="wseo-qe-progress-bar" id="wseo-qe-desc-progress">
                                    <div class="wseo-qe-progress-fill"></div>
                                </div>
                                <span class="wseo-qe-char-count" id="wseo-qe-desc-count">0 znakov</span>
                            </div>
                            <span class="input-text-wrap">
                                <textarea name="wseo_meta_description" class="wseo-qe-description" rows="2" style="width: 100%;"></textarea>
                            </span>
                        </label>
                    </div>
                </div>
                
                <h4 style="margin: 15px 0 10px; border-bottom: 1px solid #ddd; padding-bottom: 5px;">📋 Schema.org <small style="font-weight: normal; color: #666;">(prázdne = globálne)</small></h4>
                
                <div class="wseo-qe-row">
                    <div class="wseo-qe-col-4">
                        <label class="inline-edit-group">
                            <span class="title">Typ Schema</span>
                            <span class="input-text-wrap">
                                <select name="wseo_schema_type" class="wseo-qe-schema-type" style="width: 100%;">
                                    <?php echo $this->get_schema_types_options(); ?>
                                </select>
                            </span>
                        </label>
                    </div>
                    <div class="wseo-qe-col-4 wseo-qe-field-name" style="display: none;">
                        <label class="inline-edit-group">
                            <span class="title">Názov</span>
                            <span class="input-text-wrap">
                                <input type="text" name="wseo_schema_name" class="wseo-qe-schema-name" value="" placeholder="Názov podniku" style="width: 100%;">
                            </span>
                        </label>
                    </div>
                    <div class="wseo-qe-col-4 wseo-qe-field-article-type" style="display: none;">
                        <label class="inline-edit-group">
                            <span class="title">Typ článku</span>
                            <span class="input-text-wrap">
                                <select name="wseo_article_type" class="wseo-qe-article-type" style="width: 100%;">
                                    <option value="">Auto</option>
                                    <option value="BlogPosting">Blog</option>
                                    <option value="NewsArticle">Správa</option>
                                    <option value="Article">Článok</option>
                                </select>
                            </span>
                        </label>
                    </div>
                </div>
                
                <!-- LocalBusiness fields (address, contact, price) -->
                <div class="wseo-qe-localbusiness-fields" style="display: none;">
                    <div class="wseo-qe-row">
                        <div class="wseo-qe-col-3">
                            <label class="inline-edit-group">
                                <span class="title">📍 Ulica</span>
                                <span class="input-text-wrap">
                                    <input type="text" name="wseo_schema_address" class="wseo-qe-address" value="" placeholder="Hlavná 123" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                        <div class="wseo-qe-col-3">
                            <label class="inline-edit-group">
                                <span class="title">🏙️ Mesto</span>
                                <span class="input-text-wrap">
                                    <input type="text" name="wseo_schema_city" class="wseo-qe-city" value="" placeholder="Bratislava" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                        <div class="wseo-qe-col-3">
                            <label class="inline-edit-group">
                                <span class="title">📮 PSČ</span>
                                <span class="input-text-wrap">
                                    <input type="text" name="wseo_schema_zip" class="wseo-qe-zip" value="" placeholder="811 01" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                    </div>
                    
                    <div class="wseo-qe-row">
                        <div class="wseo-qe-col-3">
                            <label class="inline-edit-group">
                                <span class="title">📞 Telefón</span>
                                <span class="input-text-wrap">
                                    <input type="tel" name="wseo_schema_phone" class="wseo-qe-phone" value="" placeholder="+421 9XX XXX XXX" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                        <div class="wseo-qe-col-3">
                            <label class="inline-edit-group">
                                <span class="title">📧 Email</span>
                                <span class="input-text-wrap">
                                    <input type="email" name="wseo_schema_email" class="wseo-qe-email" value="" placeholder="info@example.sk" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                        <div class="wseo-qe-col-3">
                            <label class="inline-edit-group">
                                <span class="title">💰 Cenová kategória</span>
                                <span class="input-text-wrap">
                                    <select name="wseo_schema_price_range" class="wseo-qe-price-range" style="width: 100%;">
                                        <option value="">—</option>
                                        <option value="€">€</option>
                                        <option value="€€">€€</option>
                                        <option value="€€€">€€€</option>
                                        <option value="€€€€">€€€€</option>
                                    </select>
                                </span>
                            </label>
                        </div>
                    </div>
                    
                    <p class="description" style="margin: 10px 0; color: #666; font-style: italic;">
                        🕐 Otváracie hodiny a GPS nastavte v plnom editore (Schema tab).
                    </p>
                </div>
                
                <!-- Organization fields (basic contact only) -->
                <div class="wseo-qe-organization-fields" style="display: none;">
                    <div class="wseo-qe-row">
                        <div class="wseo-qe-col-2">
                            <label class="inline-edit-group">
                                <span class="title">📞 Telefón</span>
                                <span class="input-text-wrap">
                                    <input type="tel" name="wseo_schema_phone" class="wseo-qe-phone-org" value="" placeholder="+421 9XX XXX XXX" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                        <div class="wseo-qe-col-2">
                            <label class="inline-edit-group">
                                <span class="title">📧 Email</span>
                                <span class="input-text-wrap">
                                    <input type="email" name="wseo_schema_email" class="wseo-qe-email-org" value="" placeholder="info@example.sk" style="width: 100%;">
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Page type fields -->
                <div class="wseo-qe-page-fields" style="display: none;">
                    <p class="description" style="margin: 10px 0; color: #666;">
                        ℹ️ Pre stránky typu ContactPage, AboutPage, FAQPage nie sú potrebné ďalšie polia.
                    </p>
                </div>
                
                <h4 style="margin: 15px 0 10px; border-bottom: 1px solid #ddd; padding-bottom: 5px;">🔄 Presmerovanie & Robots</h4>
                
                <div class="wseo-qe-row">
                    <div class="wseo-qe-col-2">
                        <label class="inline-edit-group">
                            <span class="title">Redirect URL</span>
                            <span class="input-text-wrap">
                                <input type="url" name="wseo_redirect_url" class="wseo-qe-redirect" value="" placeholder="https://..." style="width: 100%;">
                            </span>
                        </label>
                    </div>
                    <div class="wseo-qe-col-2">
                        <label class="inline-edit-group">
                            <span class="title">Typ presmerovania</span>
                            <span class="input-text-wrap">
                                <select name="wseo_redirect_type" class="wseo-qe-redirect-type" style="width: 100%;">
                                    <option value="">— Žiadne —</option>
                                    <option value="301">301 - Trvalé presmerovanie</option>
                                    <option value="302">302 - Dočasné presmerovanie</option>
                                </select>
                            </span>
                        </label>
                    </div>
                </div>
                
                <div class="wseo-qe-row" style="margin-top: 10px;">
                    <div class="wseo-qe-col-2">
                        <label style="display: inline-flex; align-items: center; gap: 5px;">
                            <input type="checkbox" name="wseo_noindex" class="wseo-qe-noindex" value="1">
                            <span>🚫 noindex (neindexxovať)</span>
                        </label>
                    </div>
                    <div class="wseo-qe-col-2">
                        <label style="display: inline-flex; align-items: center; gap: 5px;">
                            <input type="checkbox" name="wseo_nofollow" class="wseo-qe-nofollow" value="1">
                            <span>🔗 nofollow (nesledovať linky)</span>
                        </label>
                    </div>
                </div>
            </div>
        </fieldset>
        
        <style>
            .wseo-quick-edit-full {
                float: none !important;
                width: 100% !important;
                clear: both;
            }
            .wseo-quick-edit-full .inline-edit-col {
                max-width: 100% !important;
            }
            .wseo-qe-row {
                display: flex;
                gap: 15px;
                margin-bottom: 10px;
            }
            .wseo-qe-col-1 { flex: 1; }
            .wseo-qe-col-2 { flex: 1; min-width: 0; }
            .wseo-qe-col-3 { flex: 1; min-width: 0; }
            .wseo-qe-col-4 { flex: 1; min-width: 0; }
            .wseo-qe-progress-wrap {
                display: flex;
                align-items: center;
                gap: 10px;
                margin-bottom: 5px;
            }
            .wseo-qe-progress-bar {
                flex: 1;
                height: 6px;
                background: #e0e0e0;
                border-radius: 3px;
                overflow: hidden;
            }
            .wseo-qe-progress-fill {
                height: 100%;
                width: 0%;
                border-radius: 3px;
                transition: width 0.2s, background-color 0.2s;
            }
            .wseo-qe-char-count {
                font-size: 11px;
                color: #666;
                min-width: 100px;
                text-align: right;
            }
            .wseo-qe-status-short { color: #f0ad4e; }
            .wseo-qe-status-good { color: #22c55e; }
            .wseo-qe-status-long { color: #dc3545; }
            .wseo-quick-edit-full .inline-edit-group {
                display: block;
                margin-bottom: 0;
            }
            .wseo-quick-edit-full .title {
                display: block;
                font-weight: 600;
                margin-bottom: 3px;
                font-size: 12px;
            }
            @media screen and (max-width: 782px) {
                .wseo-qe-row {
                    flex-direction: column;
                }
            }
        </style>
        <?php
    }
    
    /**
     * Save Quick Edit data
     */
    public function save_quick_edit($post_id, $post) {
        // Check if this is a quick edit save
        if (!isset($_POST['wseo_quick_edit_nonce'])) {
            return;
        }
        
        if (!wp_verify_nonce($_POST['wseo_quick_edit_nonce'], 'wseo_quick_edit')) {
            return;
        }
        
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        
        // Save SEO fields
        if (isset($_POST['wseo_meta_title'])) {
            update_post_meta($post_id, '_wseo_meta_title', sanitize_text_field($_POST['wseo_meta_title']));
        }
        if (isset($_POST['wseo_meta_description'])) {
            update_post_meta($post_id, '_wseo_meta_description', sanitize_textarea_field($_POST['wseo_meta_description']));
        }
        if (isset($_POST['wseo_meta_keywords'])) {
            update_post_meta($post_id, '_wseo_meta_keywords', sanitize_text_field($_POST['wseo_meta_keywords']));
        }
        
        // Save Schema fields
        if (isset($_POST['wseo_schema_type'])) {
            update_post_meta($post_id, '_wseo_schema_type', sanitize_text_field($_POST['wseo_schema_type']));
        }
        if (isset($_POST['wseo_schema_name'])) {
            update_post_meta($post_id, '_wseo_schema_name', sanitize_text_field($_POST['wseo_schema_name']));
        }
        if (isset($_POST['wseo_article_type'])) {
            update_post_meta($post_id, '_wseo_article_type', sanitize_text_field($_POST['wseo_article_type']));
        }
        
        // Save Schema address/contact fields
        if (isset($_POST['wseo_schema_address'])) {
            update_post_meta($post_id, '_wseo_schema_address', sanitize_text_field($_POST['wseo_schema_address']));
        }
        if (isset($_POST['wseo_schema_city'])) {
            update_post_meta($post_id, '_wseo_schema_city', sanitize_text_field($_POST['wseo_schema_city']));
        }
        if (isset($_POST['wseo_schema_zip'])) {
            update_post_meta($post_id, '_wseo_schema_zip', sanitize_text_field($_POST['wseo_schema_zip']));
        }
        if (isset($_POST['wseo_schema_phone'])) {
            update_post_meta($post_id, '_wseo_schema_phone', sanitize_text_field($_POST['wseo_schema_phone']));
        }
        if (isset($_POST['wseo_schema_email'])) {
            update_post_meta($post_id, '_wseo_schema_email', sanitize_email($_POST['wseo_schema_email']));
        }
        // v2.9.12: Removed wseo_schema_opening - now uses day-by-day format in full editor
        if (isset($_POST['wseo_schema_price_range'])) {
            update_post_meta($post_id, '_wseo_schema_price_range', sanitize_text_field($_POST['wseo_schema_price_range']));
        }
        if (isset($_POST['wseo_schema_image'])) {
            update_post_meta($post_id, '_wseo_schema_image', esc_url_raw($_POST['wseo_schema_image']));
        }
        
        // Save Robots fields
        update_post_meta($post_id, '_wseo_noindex', isset($_POST['wseo_noindex']) ? '1' : '');
        update_post_meta($post_id, '_wseo_nofollow', isset($_POST['wseo_nofollow']) ? '1' : '');
        
        // Save Redirect fields
        if (isset($_POST['wseo_redirect_url'])) {
            update_post_meta($post_id, '_wseo_redirect_url', esc_url_raw($_POST['wseo_redirect_url']));
        }
        if (isset($_POST['wseo_redirect_type'])) {
            update_post_meta($post_id, '_wseo_redirect_type', sanitize_text_field($_POST['wseo_redirect_type']));
        }
    }
    
    /**
     * Quick Edit JavaScript to populate fields
     */
    public function quick_edit_javascript() {
        $screen = get_current_screen();
        if (!in_array($screen->post_type, array('post', 'page', 'product'))) {
            return;
        }
        ?>
        <script type="text/javascript">
        jQuery(function($) {
            var wpInlineEdit = inlineEditPost.edit;
            
            // v2.9.13: Get site name suffix length
            var siteName = '<?php echo esc_js(get_option('wseo_global_site_name', get_bloginfo('name'))); ?>';
            var suffixLength = siteName ? (' - ' + siteName).length : 0;
            
            // Progress bar update function
            function updateQEProgress(type, length, includeSuffix) {
                var progressBar, countEl, fill, percent, status, statusText;
                var totalLength = includeSuffix ? length + suffixLength : length;
                
                if (type === 'title') {
                    progressBar = $('#wseo-qe-title-progress');
                    countEl = $('#wseo-qe-title-count');
                    // Title: optimal 30-60 (total with suffix)
                    if (totalLength < 30) {
                        percent = (totalLength / 50) * 100;
                        status = 'short';
                        statusText = 'Krátke';
                    } else if (totalLength <= 60) {
                        percent = 100;
                        status = 'good';
                        statusText = 'Dobre';
                    } else if (totalLength <= 70) {
                        percent = 100;
                        status = 'good';
                        statusText = 'OK';
                    } else {
                        percent = 100;
                        status = 'long';
                        statusText = 'Dlhé!';
                    }
                    // Show breakdown: input length + suffix = total
                    countEl.html(length + ' <span style="color:#999;">(+' + suffixLength + ' = ' + totalLength + ')</span> – ' + statusText);
                } else {
                    progressBar = $('#wseo-qe-desc-progress');
                    countEl = $('#wseo-qe-desc-count');
                    // Description: optimal 120-160, max 170
                    if (length < 80) {
                        percent = (length / 120) * 100;
                        status = 'short';
                        statusText = 'Krátke';
                    } else if (length <= 160) {
                        percent = (length / 160) * 100;
                        status = 'good';
                        statusText = 'Dobre';
                    } else if (length <= 170) {
                        percent = 100;
                        status = 'good';
                        statusText = 'OK';
                    } else {
                        percent = 100;
                        status = 'long';
                        statusText = 'Dlhé!';
                    }
                    countEl.text(length + ' znakov – ' + statusText);
                }
                
                fill = progressBar.find('.wseo-qe-progress-fill');
                fill.css('width', Math.min(percent, 100) + '%');
                
                // Set color
                fill.css('background-color', 
                    status === 'good' ? '#22c55e' : 
                    status === 'short' ? '#f0ad4e' : '#dc3545'
                );
                
                countEl.removeClass('wseo-qe-status-short wseo-qe-status-good wseo-qe-status-long')
                       .addClass('wseo-qe-status-' + status);
            }
            
            // v2.9.12: Schema type field visibility logic
            var localBusinessTypes = [
                'LocalBusiness', 'Restaurant', 'CafeOrCoffeeShop', 'Bakery', 'BarOrPub', 
                'FastFoodRestaurant', 'IceCreamShop', 'Winery', 'Brewery',
                'Store', 'ClothingStore', 'ElectronicsStore', 'FurnitureStore', 'GroceryStore',
                'HardwareStore', 'JewelryStore', 'LiquorStore', 'PetStore', 'ShoeStore',
                'SportingGoodsStore', 'ToyStore', 'Florist',
                'Hotel', 'LodgingBusiness', 'BedAndBreakfast', 'Hostel', 'Motel', 'Resort',
                'Campground', 'SkiResort', 'VacationRental',
                'Service', 'ProfessionalService', 'FinancialService', 'LegalService',
                'AccountingService', 'InsuranceAgency',
                'BeautySalon', 'HairSalon', 'NailSalon', 'DaySpa', 'TattooParlor',
                'MedicalBusiness', 'Dentist', 'Physician', 'Pharmacy', 'Optician', 'VeterinaryCare',
                'AutoRepair', 'AutoDealer', 'AutoRental', 'AutoWash', 'GasStation',
                'GeneralContractor', 'Electrician', 'Plumber', 'RoofingContractor', 'HVACBusiness',
                'RealEstateAgent'
            ];
            
            var organizationTypes = ['Organization', 'NewsMediaOrganization'];
            var pageTypes = ['ContactPage', 'AboutPage', 'FAQPage'];
            
            function updateQESchemaFields(editRow, schemaType) {
                // Hide all conditional field groups
                editRow.find('.wseo-qe-localbusiness-fields').hide();
                editRow.find('.wseo-qe-organization-fields').hide();
                editRow.find('.wseo-qe-page-fields').hide();
                editRow.find('.wseo-qe-field-name').hide();
                editRow.find('.wseo-qe-field-article-type').hide();
                
                if (!schemaType || schemaType === '') {
                    // Global settings - show nothing extra
                    return;
                }
                
                if (localBusinessTypes.indexOf(schemaType) !== -1) {
                    // LocalBusiness types - show address, contact, price
                    editRow.find('.wseo-qe-localbusiness-fields').show();
                    editRow.find('.wseo-qe-field-name').show();
                } else if (organizationTypes.indexOf(schemaType) !== -1) {
                    // Organization types - show basic contact only
                    editRow.find('.wseo-qe-organization-fields').show();
                } else if (pageTypes.indexOf(schemaType) !== -1) {
                    // Page types - show info message
                    editRow.find('.wseo-qe-page-fields').show();
                }
                
                // Show article type for posts (always available but only relevant for some types)
                if ($('body').hasClass('post-type-post')) {
                    editRow.find('.wseo-qe-field-article-type').show();
                }
            }
            
            // Bind schema type change event
            $(document).on('change', '.wseo-qe-schema-type', function() {
                var editRow = $(this).closest('.inline-edit-row');
                var schemaType = $(this).val();
                updateQESchemaFields(editRow, schemaType);
            });
            
            // Bind events to quick edit fields
            $(document).on('input', '.wseo-qe-title', function() {
                updateQEProgress('title', $(this).val().length, true); // true = include suffix
            });
            
            $(document).on('input', '.wseo-qe-description', function() {
                updateQEProgress('desc', $(this).val().length, false); // false = no suffix
            });
            
            inlineEditPost.edit = function(id) {
                wpInlineEdit.apply(this, arguments);
                
                var postId = 0;
                if (typeof(id) === 'object') {
                    postId = parseInt(this.getId(id));
                }
                
                if (postId > 0) {
                    var row = $('#post-' + postId);
                    var data = row.find('.wseo-quick-edit-data');
                    
                    var title = data.find('.wseo-title').text();
                    var description = data.find('.wseo-description').text();
                    var keywords = data.find('.wseo-keywords').text();
                    
                    // v2.10.11: Get auto-generated values for placeholders
                    var autoTitle = data.find('.wseo-auto-title').text();
                    var autoDescription = data.find('.wseo-auto-description').text();
                    var autoKeywords = data.find('.wseo-auto-keywords').text();
                    
                    var redirect = data.find('.wseo-redirect').text();
                    var redirectType = data.find('.wseo-redirect-type').text();
                    var schemaType = data.find('.wseo-schema-type').text();
                    var schemaName = data.find('.wseo-schema-name').text();
                    var articleType = data.find('.wseo-article-type').text();
                    var noindex = data.find('.wseo-noindex').text();
                    var nofollow = data.find('.wseo-nofollow').text();
                    
                    // Additional schema fields
                    var address = data.find('.wseo-address').text();
                    var city = data.find('.wseo-city').text();
                    var zip = data.find('.wseo-zip').text();
                    var phone = data.find('.wseo-phone').text();
                    var email = data.find('.wseo-email').text();
                    var priceRange = data.find('.wseo-price-range').text();
                    
                    var editRow = $('#edit-' + postId);
                    
                    // v2.10.11: Set values or placeholders
                    var titleField = editRow.find('.wseo-qe-title');
                    var descField = editRow.find('.wseo-qe-description');
                    var keywordsField = editRow.find('.wseo-qe-keywords');
                    
                    titleField.val(title).attr('placeholder', autoTitle || '');
                    descField.val(description).attr('placeholder', autoDescription || '');
                    keywordsField.val(keywords).attr('placeholder', autoKeywords || '');
                    
                    editRow.find('.wseo-qe-redirect').val(redirect);
                    editRow.find('.wseo-qe-redirect-type').val(redirectType);
                    editRow.find('.wseo-qe-schema-type').val(schemaType);
                    editRow.find('.wseo-qe-schema-name').val(schemaName);
                    editRow.find('.wseo-qe-article-type').val(articleType);
                    editRow.find('.wseo-qe-noindex').prop('checked', noindex === '1');
                    editRow.find('.wseo-qe-nofollow').prop('checked', nofollow === '1');
                    
                    // Additional schema fields
                    editRow.find('.wseo-qe-address').val(address);
                    editRow.find('.wseo-qe-city').val(city);
                    editRow.find('.wseo-qe-zip').val(zip);
                    editRow.find('.wseo-qe-phone, .wseo-qe-phone-org').val(phone);
                    editRow.find('.wseo-qe-email, .wseo-qe-email-org').val(email);
                    editRow.find('.wseo-qe-price-range').val(priceRange);
                    
                    // v2.9.12: Update field visibility based on schema type
                    updateQESchemaFields(editRow, schemaType);
                    
                    // Update progress bars with loaded values (use auto if empty)
                    setTimeout(function() {
                        var displayTitle = title || autoTitle;
                        var displayDesc = description || autoDescription;
                        updateQEProgress('title', displayTitle.length, true);
                        updateQEProgress('desc', displayDesc.length, false);
                    }, 100);
                }
            };
        });
        </script>
        <?php
    }
    
    /**
     * Auto-set image alt text when attachment is added
     */
    public function auto_set_image_alt($attachment_id) {
        // Only for images
        if (!wp_attachment_is_image($attachment_id)) {
            return;
        }
        
        // v2.9.17: Auto-fill is ALWAYS enabled - no settings needed
        // Generate text from parent post
        $generated_text = $this->generate_image_alt_text($attachment_id);
        $description_text = $this->generate_image_description($attachment_id);
        
        // Set Alt text - ALWAYS
        $existing_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
        if (empty($existing_alt) && !empty($generated_text)) {
            update_post_meta($attachment_id, '_wp_attachment_image_alt', $generated_text);
        }
        
        // Set Title (post_title of attachment) - ALWAYS
        $attachment = get_post($attachment_id);
        // Only update if title is just filename
        $filename = pathinfo(get_attached_file($attachment_id), PATHINFO_FILENAME);
        if ($attachment && ($attachment->post_title === $filename || empty($attachment->post_title))) {
            wp_update_post(array(
                'ID' => $attachment_id,
                'post_title' => $generated_text
            ));
        }
        
        // Set Caption (post_excerpt) - ALWAYS
        if (!empty($description_text)) {
            $attachment = get_post($attachment_id);
            if ($attachment && empty($attachment->post_excerpt)) {
                wp_update_post(array(
                    'ID' => $attachment_id,
                    'post_excerpt' => $description_text
                ));
            }
        }
        
        // Set Description (post_content) - ALWAYS
        if (!empty($description_text)) {
            $attachment = get_post($attachment_id);
            if ($attachment && empty($attachment->post_content)) {
                wp_update_post(array(
                    'ID' => $attachment_id,
                    'post_content' => $description_text
                ));
            }
        }
    }
    
    /**
     * Auto-set image alt text on upload (backup hook)
     */
    public function auto_set_image_alt_on_upload($metadata, $attachment_id) {
        $this->auto_set_image_alt($attachment_id);
        
        // Auto-optimize image on upload
        $this->auto_optimize_image_on_upload($attachment_id);
        
        return $metadata;
    }
    
    /**
     * Automatically optimize image on upload
     */
    private function auto_optimize_image_on_upload($attachment_id) {
        // Check if it's an image
        $mime_type = get_post_mime_type($attachment_id);
        
        if (!in_array($mime_type, array('image/jpeg', 'image/jpg', 'image/png'))) {
            return; // Only optimize JPEG and PNG
        }
        
        // Check if already optimized
        $already_optimized = get_post_meta($attachment_id, '_wseo_optimized', true);
        if ($already_optimized) {
            return; // Already optimized
        }
        
        // Optimize the image
        $result = $this->optimize_single_image($attachment_id);
        
        // Log activity if successful
        if ($result['success'] && $result['saved'] > 0) {
            $this->log_maintenance_activity(
                'Auto-optimalizácia pri uploade', 
                "Obrázok ID: $attachment_id, Ušetrené: " . size_format($result['saved'])
            );
        }
    }
    
    /**
     * Add optimization info to media library
     */
    public function add_optimization_info_to_media($fields, $post) {
        // Only for images
        if (!wp_attachment_is_image($post->ID)) {
            return $fields;
        }
        
        // Check if optimized
        $optimized = get_post_meta($post->ID, '_wseo_optimized', true);
        
        if ($optimized) {
            $original_size = get_post_meta($post->ID, '_wseo_original_size', true);
            $optimized_size = get_post_meta($post->ID, '_wseo_optimized_size', true);
            $saved = get_post_meta($post->ID, '_wseo_saved', true);
            $skipped_reason = get_post_meta($post->ID, '_wseo_skipped_reason', true);
            $date = date('d.m.Y H:i', $optimized);
            
            // Check if it was skipped (transparent PNG)
            if ($skipped_reason === 'transparent_png') {
                $info = '<div style="background: #e7f3ff; border-left: 4px solid #2196f3; padding: 10px; border-radius: 4px; margin-top: 10px;">';
                $info .= '<strong style="color: #0d47a1;">🎨 PNG s transparentnosťou</strong><br>';
                $info .= '<span style="color: #0d47a1; font-size: 12px;">';
                $info .= 'Dátum kontroly: ' . $date . '<br>';
                $info .= 'Originálna veľkosť: ' . size_format($original_size) . '<br>';
                $info .= '<strong>Status:</strong> Preskočené - zachovaná 100% kvalita<br>';
                $info .= '<em>PNG s transparentnosťou (loga, ikony) nie sú optimalizované kvôli zachovaniu maximálnej kvality a alpha kanálu.</em>';
                $info .= '</span></div>';
            } else {
                // Normal optimization
                $percentage = $original_size > 0 ? round(($saved / $original_size) * 100) : 0;
                
                $info = '<div style="background: #d4edda; border-left: 4px solid #28a745; padding: 10px; border-radius: 4px; margin-top: 10px;">';
                $info .= '<strong style="color: #155724;">✅ Optimalizované</strong><br>';
                $info .= '<span style="color: #155724; font-size: 12px;">';
                $info .= 'Dátum: ' . $date . '<br>';
                $info .= 'Originál: ' . size_format($original_size) . '<br>';
                $info .= 'Po optimalizácii: ' . size_format($optimized_size) . '<br>';
                $info .= '<strong>Ušetrené: ' . size_format($saved) . ' (' . $percentage . '%)</strong>';
                $info .= '</span></div>';
            }
            
            $fields['wseo_optimization'] = array(
                'label' => 'SEO Pro Optimalizácia',
                'input' => 'html',
                'html' => $info,
                'show_in_edit' => true,
            );
        } else {
            // Show that it will be optimized
            $info = '<div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 10px; border-radius: 4px; margin-top: 10px;">';
            $info .= '<strong style="color: #856404;">⏳ Čaká na optimalizáciu</strong><br>';
            $info .= '<span style="color: #856404; font-size: 12px;">';
            $info .= 'Obrázok bude automaticky optimalizovaný pri najbližšej úprave<br>';
            $info .= 'alebo ho môžete optimalizovať cez <a href="' . admin_url('admin.php?page=webstudio-seo-maintenance') . '">Servis sekciu</a>.';
            $info .= '</span></div>';
            
            $fields['wseo_optimization'] = array(
                'label' => 'SEO Pro Optimalizácia',
                'input' => 'html',
                'html' => $info,
                'show_in_edit' => true,
            );
        }
        
        return $fields;
    }
    
    /**
     * Generate alt text for image (from parent post title)
     */
    private function generate_image_alt_text($attachment_id) {
        $alt_text = '';
        
        // Get attachment
        $attachment = get_post($attachment_id);
        if (!$attachment) {
            return $this->get_fallback_alt_text();
        }
        
        // 1. Try to get parent post title (if image uploaded to a post/page/product)
        if ($attachment->post_parent > 0) {
            $parent = get_post($attachment->post_parent);
            if ($parent) {
                $alt_text = $parent->post_title;
            }
        }
        
        // 2. If no parent, check if we're editing a post (via referer or AJAX context)
        if (empty($alt_text)) {
            $referer = wp_get_referer();
            if ($referer && preg_match('/post=(\d+)/', $referer, $matches)) {
                $post_id = intval($matches[1]);
                $post = get_post($post_id);
                if ($post && $post->post_type !== 'attachment') {
                    $alt_text = $post->post_title;
                }
            }
        }
        
        // 3. Try $_REQUEST post_id
        if (empty($alt_text) && isset($_REQUEST['post_id']) && intval($_REQUEST['post_id']) > 0) {
            $post = get_post(intval($_REQUEST['post_id']));
            if ($post && $post->post_type !== 'attachment') {
                $alt_text = $post->post_title;
            }
        }
        
        // 4. Use filename (cleaned up)
        if (empty($alt_text)) {
            $filename = pathinfo(get_attached_file($attachment_id), PATHINFO_FILENAME);
            $alt_text = preg_replace('/[-_]/', ' ', $filename);
            $alt_text = preg_replace('/\d+/', '', $alt_text);
            $alt_text = preg_replace('/\s+/', ' ', $alt_text);
            $alt_text = trim(ucfirst(strtolower($alt_text)));
        }
        
        // 5. Filter out stop words / unwanted phrases
        $alt_text = $this->filter_stop_words($alt_text);
        
        // 6. Fallback
        if (empty($alt_text) || strlen($alt_text) < 3) {
            $alt_text = $this->get_fallback_alt_text();
        }
        
        return $alt_text;
    }
    
    /**
     * Filter out stop words and unwanted phrases from text
     */
    private function filter_stop_words($text) {
        // Stop words and phrases to remove
        $stop_words = array(
            // English common
            'range', 'through', 'select', 'selection', 'choose', 'option', 'options',
            'variant', 'variants', 'multiple', 'various', 'different', 'type', 'types',
            'product', 'products', 'item', 'items', 'image', 'images', 'photo', 'photos',
            'picture', 'pictures', 'img', 'pic', 'screenshot', 'screen', 'shot',
            'file', 'files', 'upload', 'uploaded', 'download', 'attachment',
            'untitled', 'unnamed', 'default', 'sample', 'example', 'test', 'temp',
            'dsc', 'img', 'jpeg', 'jpg', 'png', 'gif', 'webp', 'svg', 'bmp',
            'copy', 'edited', 'final', 'new', 'old', 'version', 'ver', 'rev',
            
            // Slovak common
            'výber možností', 'výber', 'možností', 'tento', 'táto', 'toto', 'tieto',
            'viacero variantov', 'viacero variant', 'viacero', 'variantov', 'variant', 'varianty',
            'možnosti', 'možnosť', 'produktu', 'produkt', 'produkty', 'produktov',
            'položka', 'položky', 'obrázok', 'obrázky',
            'fotka', 'fotky', 'fotografia', 'fotografie', 'súbor', 'súbory',
            'nahraný', 'nahraté', 'predvolený', 'predvolené', 'príklad', 'vzor',
            'kópia', 'nový', 'nová', 'nové', 'starý', 'stará', 'staré', 'verzia',
            
            // Czech common
            'výběr možností', 'výběr', 'možností', 'tento', 'tato', 'toto', 'tyto',
            'více variant', 'více', 'variant', 'varianta', 'možnosti', 'možnost',
            'produktu', 'produkt', 'produkty', 'položka', 'položky', 'obrázek', 'obrázky',
            
            // German common
            'auswahl', 'optionen', 'varianten', 'produkt', 'produkte', 'artikel',
            'bild', 'bilder', 'foto', 'fotos', 'datei', 'dateien',
            
            // Common file naming patterns
            'whatsapp', 'image', 'photo', 'video', 'audio', 'document', 'media',
            'camera', 'webcam', 'scan', 'scanned', 'fax', 'print', 'printed',
        );
        
        // Convert to lowercase for comparison
        $text_lower = mb_strtolower($text);
        
        // Remove stop words (case insensitive)
        foreach ($stop_words as $word) {
            $word_lower = mb_strtolower($word);
            // Use word boundaries to avoid partial matches
            $pattern = '/\b' . preg_quote($word_lower, '/') . '\b/ui';
            $text_lower = preg_replace($pattern, '', $text_lower);
        }
        
        // Clean up extra spaces
        $text_lower = preg_replace('/\s+/', ' ', $text_lower);
        $text_lower = trim($text_lower);
        
        // Capitalize first letter
        if (!empty($text_lower)) {
            $text_lower = mb_strtoupper(mb_substr($text_lower, 0, 1)) . mb_substr($text_lower, 1);
        }
        
        return $text_lower;
    }
    
    /**
     * Generate description for image (from parent post meta description)
     */
    private function generate_image_description($attachment_id) {
        $description = '';
        
        $attachment = get_post($attachment_id);
        if (!$attachment) {
            return '';
        }
        
        // Get from parent post meta description
        if ($attachment->post_parent > 0) {
            $description = get_post_meta($attachment->post_parent, '_wseo_meta_description', true);
            
            // If no SEO description, try excerpt
            if (empty($description)) {
                $parent = get_post($attachment->post_parent);
                if ($parent && !empty($parent->post_excerpt)) {
                    $description = $parent->post_excerpt;
                }
            }
        }
        
        // Try from referer post
        if (empty($description)) {
            $referer = wp_get_referer();
            if ($referer && preg_match('/post=(\d+)/', $referer, $matches)) {
                $post_id = intval($matches[1]);
                $description = get_post_meta($post_id, '_wseo_meta_description', true);
            }
        }
        
        return $description;
    }
    
    /**
     * Get fallback alt text (site tagline or name)
     */
    private function get_fallback_alt_text() {
        $fallback = get_option('wseo_auto_fallback', '');
        if (!empty($fallback)) {
            return $fallback;
        }
        $tagline = get_bloginfo('description');
        if (!empty($tagline)) {
            return $tagline;
        }
        return get_option('wseo_global_site_name', get_bloginfo('name'));
    }
    
    /**
     * AJAX handler for bulk fill images (v2.8.10 - enhanced with templates)
     */
    public function ajax_bulk_fill_images() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        $type = sanitize_text_field($_POST['type'] ?? 'all');
        $mode = sanitize_text_field($_POST['mode'] ?? 'missing'); // missing, overwrite, custom
        $custom_text = sanitize_text_field($_POST['custom_text'] ?? '');
        $batch_size = intval($_POST['batch_size'] ?? 50);
        $offset = intval($_POST['offset'] ?? 0);
        
        // Get templates from settings
        $templates = array(
            'alt' => get_option('wseo_image_template_alt', '{parent_title}'),
            'title' => get_option('wseo_image_template_title', '{parent_title}'),
            'caption' => get_option('wseo_image_template_caption', '{parent_excerpt}'),
            'description' => get_option('wseo_image_template_description', '{parent_description}')
        );
        $fallback_text = get_option('wseo_image_fallback_text', get_bloginfo('name'));
        
        // Get images
        $args = array(
            'post_type' => 'attachment',
            'post_mime_type' => 'image',
            'posts_per_page' => $batch_size,
            'offset' => $offset,
            'post_status' => 'any',
            'orderby' => 'ID',
            'order' => 'ASC'
        );
        
        $attachments = get_posts($args);
        
        if (empty($attachments)) {
            wp_send_json_success(array(
                'completed' => true,
                'processed' => 0,
                'filled' => 0
            ));
            return;
        }
        
        $filled = 0;
        $processed = count($attachments);
        
        foreach ($attachments as $attachment) {
            $attachment_id = $attachment->ID;
            
            // Build template variables
            $vars = $this->get_image_template_variables($attachment_id);
            
            // Alt text
            if ($type === 'alt' || $type === 'all') {
                $existing_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
                
                if ($mode === 'overwrite' || ($mode === 'missing' && empty($existing_alt)) || $mode === 'custom') {
                    if ($mode === 'custom' && !empty($custom_text)) {
                        $new_value = $this->parse_image_template($custom_text, $vars, $fallback_text);
                    } else {
                        $new_value = $this->parse_image_template($templates['alt'], $vars, $fallback_text);
                    }
                    
                    if (!empty($new_value) && $new_value !== $existing_alt) {
                        update_post_meta($attachment_id, '_wp_attachment_image_alt', $new_value);
                        $filled++;
                    }
                }
            }
            
            // Title
            if ($type === 'title' || $type === 'all') {
                $existing_title = $attachment->post_title;
                $filename = pathinfo(get_attached_file($attachment_id), PATHINFO_FILENAME);
                $is_default_title = ($existing_title === $filename || empty($existing_title));
                
                if ($mode === 'overwrite' || ($mode === 'missing' && $is_default_title) || $mode === 'custom') {
                    if ($mode === 'custom' && !empty($custom_text)) {
                        $new_value = $this->parse_image_template($custom_text, $vars, $fallback_text);
                    } else {
                        $new_value = $this->parse_image_template($templates['title'], $vars, $fallback_text);
                    }
                    
                    if (!empty($new_value) && $new_value !== $existing_title) {
                        wp_update_post(array(
                            'ID' => $attachment_id,
                            'post_title' => $new_value
                        ));
                        if ($type === 'title') $filled++;
                    }
                }
            }
            
            // Caption (post_excerpt)
            if ($type === 'caption' || $type === 'all') {
                $existing_caption = $attachment->post_excerpt;
                
                if ($mode === 'overwrite' || ($mode === 'missing' && empty($existing_caption)) || $mode === 'custom') {
                    if ($mode === 'custom' && !empty($custom_text)) {
                        $new_value = $this->parse_image_template($custom_text, $vars, $fallback_text);
                    } else {
                        $new_value = $this->parse_image_template($templates['caption'], $vars, $fallback_text);
                    }
                    
                    if (!empty($new_value) && $new_value !== $existing_caption) {
                        wp_update_post(array(
                            'ID' => $attachment_id,
                            'post_excerpt' => $new_value
                        ));
                        if ($type === 'caption') $filled++;
                    }
                }
            }
            
            // Description (post_content)
            if ($type === 'description' || $type === 'all') {
                $existing_desc = $attachment->post_content;
                
                if ($mode === 'overwrite' || ($mode === 'missing' && empty($existing_desc)) || $mode === 'custom') {
                    if ($mode === 'custom' && !empty($custom_text)) {
                        $new_value = $this->parse_image_template($custom_text, $vars, $fallback_text);
                    } else {
                        $new_value = $this->parse_image_template($templates['description'], $vars, $fallback_text);
                    }
                    
                    if (!empty($new_value) && $new_value !== $existing_desc) {
                        wp_update_post(array(
                            'ID' => $attachment_id,
                            'post_content' => $new_value
                        ));
                        if ($type === 'description') $filled++;
                    }
                }
            }
        }
        
        wp_send_json_success(array(
            'completed' => false,
            'processed' => $processed,
            'filled' => $filled,
            'next_offset' => $offset + $batch_size
        ));
    }
    
    /**
     * Get template variables for an image
     */
    private function get_image_template_variables($attachment_id) {
        $attachment = get_post($attachment_id);
        $parent_id = $attachment ? $attachment->post_parent : 0;
        $parent = $parent_id ? get_post($parent_id) : null;
        
        // Get filename
        $file_path = get_attached_file($attachment_id);
        $filename = $file_path ? pathinfo($file_path, PATHINFO_FILENAME) : '';
        
        // Clean filename
        $filename_clean = preg_replace('/[-_]/', ' ', $filename);
        $filename_clean = preg_replace('/\d+/', '', $filename_clean);
        $filename_clean = preg_replace('/\s+/', ' ', $filename_clean);
        $filename_clean = trim(ucfirst(strtolower($filename_clean)));
        
        // Parent data
        $parent_title = $parent ? $parent->post_title : '';
        $parent_excerpt = $parent ? $parent->post_excerpt : '';
        $parent_description = $parent ? get_post_meta($parent_id, '_wseo_meta_description', true) : '';
        
        // Parent category
        $parent_category = '';
        if ($parent) {
            $categories = get_the_category($parent_id);
            if (!empty($categories)) {
                $parent_category = $categories[0]->name;
            }
            // Try WooCommerce product category
            if (empty($parent_category) && $parent->post_type === 'product') {
                $terms = get_the_terms($parent_id, 'product_cat');
                if (!empty($terms) && !is_wp_error($terms)) {
                    $parent_category = $terms[0]->name;
                }
            }
        }
        
        return array(
            '{parent_title}' => $parent_title,
            '{parent_excerpt}' => $parent_excerpt,
            '{parent_description}' => $parent_description,
            '{parent_category}' => $parent_category,
            '{filename}' => $filename,
            '{filename_clean}' => $filename_clean,
            '{site_name}' => get_bloginfo('name'),
            '{site_tagline}' => get_bloginfo('description'),
            '{date}' => date_i18n(get_option('date_format')),
            '{year}' => date('Y'),
            '{fallback}' => '' // Will be replaced with fallback text if needed
        );
    }
    
    /**
     * Parse image template and replace variables
     */
    private function parse_image_template($template, $vars, $fallback = '') {
        // Replace variables
        $result = str_replace(array_keys($vars), array_values($vars), $template);
        
        // Replace {fallback} with actual fallback
        $result = str_replace('{fallback}', $fallback, $result);
        
        // Clean up - if result is empty or just whitespace, use fallback
        $result = trim($result);
        
        if (empty($result)) {
            $result = $fallback;
        }
        
        return $result;
    }
    
    /**
     * AJAX: Get image statistics for dashboard
     */
    public function ajax_get_image_stats() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        global $wpdb;
        
        // Total images
        $total = $wpdb->get_var("
            SELECT COUNT(*) FROM {$wpdb->posts} 
            WHERE post_type = 'attachment' 
            AND post_mime_type LIKE 'image/%'
        ");
        
        // With alt text
        $with_alt = $wpdb->get_var("
            SELECT COUNT(DISTINCT p.ID) 
            FROM {$wpdb->posts} p
            INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
            WHERE p.post_type = 'attachment' 
            AND p.post_mime_type LIKE 'image/%'
            AND pm.meta_key = '_wp_attachment_image_alt'
            AND pm.meta_value != ''
        ");
        
        // With title (not filename)
        $with_title = $wpdb->get_var("
            SELECT COUNT(*) FROM {$wpdb->posts} 
            WHERE post_type = 'attachment' 
            AND post_mime_type LIKE 'image/%'
            AND post_title != ''
            AND post_title NOT REGEXP '^[a-zA-Z0-9_-]+$'
        ");
        
        // With caption
        $with_caption = $wpdb->get_var("
            SELECT COUNT(*) FROM {$wpdb->posts} 
            WHERE post_type = 'attachment' 
            AND post_mime_type LIKE 'image/%'
            AND post_excerpt != ''
        ");
        
        // With description
        $with_description = $wpdb->get_var("
            SELECT COUNT(*) FROM {$wpdb->posts} 
            WHERE post_type = 'attachment' 
            AND post_mime_type LIKE 'image/%'
            AND post_content != ''
        ");
        
        // Complete (has all 4)
        $complete = $wpdb->get_var("
            SELECT COUNT(DISTINCT p.ID) 
            FROM {$wpdb->posts} p
            INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
            WHERE p.post_type = 'attachment' 
            AND p.post_mime_type LIKE 'image/%'
            AND pm.meta_key = '_wp_attachment_image_alt'
            AND pm.meta_value != ''
            AND p.post_title != ''
            AND p.post_excerpt != ''
            AND p.post_content != ''
        ");
        
        wp_send_json_success(array(
            'total' => intval($total),
            'with_alt' => intval($with_alt),
            'with_title' => intval($with_title),
            'with_caption' => intval($with_caption),
            'with_description' => intval($with_description),
            'complete' => intval($complete),
            'without_alt' => intval($total) - intval($with_alt)
        ));
    }
    
    /**
     * AJAX: Clear all image metadata (for bulk operations)
     */
    public function ajax_clear_image_metadata() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        $type = sanitize_text_field($_POST['type'] ?? 'all');
        
        global $wpdb;
        
        $cleared = 0;
        
        // Get all image IDs
        $image_ids = $wpdb->get_col("
            SELECT ID FROM {$wpdb->posts} 
            WHERE post_type = 'attachment' 
            AND post_mime_type LIKE 'image/%'
        ");
        
        if (empty($image_ids)) {
            wp_send_json_success(array('cleared' => 0));
            return;
        }
        
        foreach ($image_ids as $image_id) {
            if ($type === 'alt' || $type === 'all') {
                delete_post_meta($image_id, '_wp_attachment_image_alt');
                $cleared++;
            }
            
            if ($type === 'title' || $type === 'all') {
                $filename = pathinfo(get_attached_file($image_id), PATHINFO_FILENAME);
                wp_update_post(array(
                    'ID' => $image_id,
                    'post_title' => $filename
                ));
            }
            
            if ($type === 'caption' || $type === 'all') {
                wp_update_post(array(
                    'ID' => $image_id,
                    'post_excerpt' => ''
                ));
            }
            
            if ($type === 'description' || $type === 'all') {
                wp_update_post(array(
                    'ID' => $image_id,
                    'post_content' => ''
                ));
            }
        }
        
        wp_send_json_success(array('cleared' => $cleared));
    }
    
    /**
     * AJAX: Save image templates settings
     */
    public function ajax_save_image_templates() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        // Save templates
        update_option('wseo_image_template_alt', sanitize_text_field($_POST['template_alt'] ?? '{parent_title}'));
        update_option('wseo_image_template_title', sanitize_text_field($_POST['template_title'] ?? '{parent_title}'));
        update_option('wseo_image_template_caption', sanitize_text_field($_POST['template_caption'] ?? '{parent_excerpt}'));
        update_option('wseo_image_template_description', sanitize_text_field($_POST['template_description'] ?? '{parent_description}'));
        update_option('wseo_image_fallback_text', sanitize_text_field($_POST['fallback_text'] ?? get_bloginfo('name')));
        
        wp_send_json_success(array('saved' => true));
    }
    
    /**
     * AJAX: Save auto settings for image uploads
     * v2.9.17: This is now a no-op - auto-fill is ALWAYS enabled
     */
    public function ajax_save_auto_settings() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        // v2.9.17: Auto-fill is always enabled, nothing to save
        wp_send_json_success(array(
            'saved' => true,
            'message' => 'Auto-fill je vždy zapnutý'
        ));
    }
    
    /**
     * AJAX: Save AVIF generation setting
     */
    public function ajax_save_avif_setting() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        update_option('wseo_generate_avif', sanitize_text_field($_POST['generate_avif'] ?? '1'));
        
        wp_send_json_success(array('saved' => true));
    }
    
    /**
     * AJAX: Bulk generate focus keywords from titles
     * v2.9.14: DEPRECATED - Focus Keywords should be set manually
     */
    public function ajax_bulk_generate_keywords() {
        wp_send_json_error('Táto funkcia bola odstránená vo v2.9.14. Focus Keywords by mali byť zadané ručne.');
    }
    
    /**
     * AJAX: Clear all focus keywords
     */
    public function ajax_clear_all_keywords() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        global $wpdb;
        
        // Delete all keywords meta
        $deleted = $wpdb->query("
            DELETE FROM {$wpdb->postmeta} 
            WHERE meta_key = '_wseo_meta_keywords'
        ");
        
        wp_send_json_success(array(
            'deleted' => $deleted
        ));
    }
    
    /**
     * v2.10.09: Generate focus keywords for all posts without keywords
     */
    public function ajax_generate_all_keywords() {
        check_ajax_referer('wseo_bulk_fill', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        global $wpdb;
        
        // Increase time limit for large sites
        @set_time_limit(300);
        
        // Get all published posts/pages/products without keywords
        $post_types = get_post_types(array('public' => true), 'names');
        unset($post_types['attachment']);
        $post_types_sql = "'" . implode("','", array_keys($post_types)) . "'";
        
        // Process in smaller batches for better progress feedback
        $batch_size = 100;
        
        $posts = $wpdb->get_results($wpdb->prepare("
            SELECT p.ID, p.post_title, p.post_type
            FROM {$wpdb->posts} p
            LEFT JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = '_wseo_meta_keywords'
            WHERE p.post_status = 'publish'
            AND p.post_type IN ({$post_types_sql})
            AND (pm.meta_value IS NULL OR pm.meta_value = '')
            LIMIT %d
        ", $batch_size));
        
        $generated = 0;
        $processed = count($posts);
        
        foreach ($posts as $post_data) {
            $post = get_post($post_data->ID);
            $keywords = $this->auto_extract_keywords($post_data->post_title, $post);
            
            if (!empty($keywords)) {
                update_post_meta($post_data->ID, '_wseo_meta_keywords', $keywords);
                $generated++;
            }
        }
        
        wp_send_json_success(array(
            'generated' => $generated,
            'processed' => $processed,
            'remaining' => $processed >= $batch_size ? 'more' : 0
        ));
    }
    
    /**
     * =====================================================
     * INSTANT INDEXING - Google, Bing, Yandex
     * =====================================================
     */
    
    /**
     * Instant index URL on publish
     */
    public function instant_index_url($post_id, $post) {
        // v3.2: IndexNow is now ON by default for instant indexing
        // Check if instant indexing is explicitly disabled
        if (get_option('wseo_instant_index_enabled', '1') === '0') {
            return;
        }
        
        // Don't index if noindex is set
        $noindex = get_post_meta($post_id, '_wseo_noindex', true);
        if ($noindex === '1') {
            return;
        }
        
        $url = get_permalink($post_id);
        $results = array();
        
        // v3.2: Check if this is fresh content (< 1 hour old)
        $post_time = strtotime($post->post_date);
        $is_fresh = (time() - $post_time) < 3600; // 1 hour
        
        // Google Indexing API
        if (get_option('wseo_google_indexing_enabled', '0') === '1') {
            $results['google'] = $this->ping_google_indexing_api($url, 'URL_UPDATED');
        }
        
        // v3.2: Bing IndexNow - ON by default
        if (get_option('wseo_bing_indexnow_enabled', '1') === '1') {
            $results['bing'] = $this->ping_indexnow($url, 'bing');
        }
        
        // v3.2: Yandex IndexNow - ON by default
        if (get_option('wseo_yandex_indexnow_enabled', '1') === '1') {
            $results['yandex'] = $this->ping_indexnow($url, 'yandex');
        }
        
        // v3.2: Seznam.cz IndexNow (for SK/CZ market)
        if (get_option('wseo_seznam_indexnow_enabled', '1') === '1') {
            $results['seznam'] = $this->ping_indexnow($url, 'seznam');
        }
        
        // v3.2: Naver IndexNow (additional coverage)
        if (get_option('wseo_naver_indexnow_enabled', '1') === '1') {
            $results['naver'] = $this->ping_indexnow($url, 'naver');
        }
        
        // v3.2: Official IndexNow API (shared hub - notifies all participants)
        if (get_option('wseo_indexnow_api_enabled', '1') === '1') {
            $results['indexnow_api'] = $this->ping_indexnow($url, 'indexnow');
        }
        
        // v3.2: Yep.com IndexNow (privacy-focused search engine)
        if (get_option('wseo_yep_indexnow_enabled', '1') === '1') {
            $results['yep'] = $this->ping_indexnow($url, 'yep');
        }
        
        // v3.2: WebSub/PubSubHubbub ping for real-time indexing
        $results['websub'] = $this->ping_websub($post_id);
        
        // v3.2: For fresh content, also ping XML-RPC services
        if ($is_fresh) {
            $results['pingomatic'] = $this->ping_pingomatic($post->post_title, $url);
        }
        
        // v3.2: Auto-ping Google Sitemap - aggressive for fresh content
        if (get_option('wseo_ping_sitemap_enabled', '1') === '1') {
            $results['sitemap_ping'] = $this->ping_google_sitemap($is_fresh);
        }
        
        // Log results
        $this->log_indexing_result($post_id, $url, $results);
    }
    
    /**
     * v3.2: Ping WebSub/PubSubHubbub for real-time indexing
     * Google subscribes to WebSub hubs for instant notification
     */
    private function ping_websub($post_id) {
        $hub_url = 'https://pubsubhubbub.appspot.com/publish';
        $feed_url = get_bloginfo('rss2_url');
        
        $response = wp_remote_post($hub_url, array(
            'timeout' => 15,
            'body' => array(
                'hub.mode' => 'publish',
                'hub.url' => $feed_url
            )
        ));
        
        if (is_wp_error($response)) {
            return array('success' => false, 'error' => $response->get_error_message());
        }
        
        $code = wp_remote_retrieve_response_code($response);
        return array(
            'success' => in_array($code, array(200, 202, 204)),
            'code' => $code,
            'service' => 'WebSub'
        );
    }
    
    /**
     * v3.2: Ping Pingomatic for XML-RPC ping services
     * Notifies multiple search engines at once
     */
    private function ping_pingomatic($title, $url) {
        $ping_url = 'http://rpc.pingomatic.com/';
        $blog_name = get_bloginfo('name');
        $blog_url = home_url('/');
        
        $request = '<?xml version="1.0"?>
        <methodCall>
            <methodName>weblogUpdates.ping</methodName>
            <params>
                <param><value>' . esc_html($blog_name) . '</value></param>
                <param><value>' . esc_url($blog_url) . '</value></param>
            </params>
        </methodCall>';
        
        $response = wp_remote_post($ping_url, array(
            'timeout' => 10,
            'headers' => array('Content-Type' => 'text/xml'),
            'body' => $request
        ));
        
        if (is_wp_error($response)) {
            return array('success' => false, 'error' => $response->get_error_message());
        }
        
        $code = wp_remote_retrieve_response_code($response);
        return array(
            'success' => $code === 200,
            'code' => $code,
            'service' => 'Pingomatic'
        );
    }
    
    /**
     * v2.8.13: Ping Google Sitemap
     * Notifikuje Google že sitemap bola aktualizovaná
     * v3.2: Reduced rate limit for fresh content
     */
    private function ping_google_sitemap($is_fresh = false) {
        // Rate limit - 1 min for fresh content, 5 min for normal
        $cooldown = $is_fresh ? 60 : 300;
        $transient_key = 'wseo_sitemap_ping_last';
        
        if (get_transient($transient_key) && !$is_fresh) {
            return array('success' => true, 'skipped' => true, 'reason' => 'Rate limited');
        }
        set_transient($transient_key, true, $cooldown);
        
        $sitemap_url = home_url('/sitemap.xml');
        $ping_url = 'https://www.google.com/ping?sitemap=' . urlencode($sitemap_url);
        
        $response = wp_remote_get($ping_url, array(
            'timeout' => 10,
            'sslverify' => true,
            'user-agent' => 'WebStudio SEO Pro/' . WSEO_VERSION
        ));
        
        if (is_wp_error($response)) {
            return array('success' => false, 'error' => $response->get_error_message());
        }
        
        $code = wp_remote_retrieve_response_code($response);
        
        if ($code === 200) {
            return array('success' => true, 'message' => 'Sitemap ping sent to Google');
        } else {
            return array('success' => false, 'error' => 'HTTP ' . $code);
        }
    }
    
    /**
     * Instant index on update (not just publish)
     */
    public function instant_index_on_update($post_id, $post, $update) {
        // Only on update, not on new post (publish hook handles that)
        if (!$update) {
            return;
        }
        
        // Only for published posts
        if ($post->post_status !== 'publish') {
            return;
        }
        
        // Only for supported post types
        $supported_types = array('post', 'page', 'product');
        if (!in_array($post->post_type, $supported_types)) {
            return;
        }
        
        // Check if instant indexing on update is enabled
        if (get_option('wseo_instant_index_on_update', '0') !== '1') {
            return;
        }
        
        // Prevent duplicate pings (use transient)
        $transient_key = 'wseo_indexed_' . $post_id;
        if (get_transient($transient_key)) {
            return;
        }
        set_transient($transient_key, true, 60); // 1 minute cooldown
        
        $this->instant_index_url($post_id, $post);
    }
    
    /**
     * Ping Google Indexing API
     */
    private function ping_google_indexing_api($url, $type = 'URL_UPDATED') {
        $json_key = get_option('wseo_google_indexing_json', '');
        
        if (empty($json_key)) {
            return array('success' => false, 'error' => 'No JSON key configured');
        }
        
        // Decode JSON key
        $key_data = json_decode($json_key, true);
        if (!$key_data || !isset($key_data['client_email']) || !isset($key_data['private_key'])) {
            return array('success' => false, 'error' => 'Invalid JSON key');
        }
        
        // Generate JWT token
        $token = $this->generate_google_jwt($key_data);
        if (!$token) {
            return array('success' => false, 'error' => 'Failed to generate JWT');
        }
        
        // Exchange JWT for access token
        $access_token = $this->get_google_access_token($token);
        if (!$access_token) {
            return array('success' => false, 'error' => 'Failed to get access token');
        }
        
        // Send indexing request
        $response = wp_remote_post('https://indexing.googleapis.com/v3/urlNotifications:publish', array(
            'headers' => array(
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer ' . $access_token
            ),
            'body' => wp_json_encode(array(
                'url' => $url,
                'type' => $type
            )),
            'timeout' => 30
        ));
        
        if (is_wp_error($response)) {
            return array('success' => false, 'error' => $response->get_error_message());
        }
        
        $code = wp_remote_retrieve_response_code($response);
        $body = json_decode(wp_remote_retrieve_body($response), true);
        
        return array(
            'success' => $code === 200,
            'code' => $code,
            'response' => $body
        );
    }
    
    /**
     * Generate JWT for Google API
     */
    private function generate_google_jwt($key_data) {
        $header = array(
            'typ' => 'JWT',
            'alg' => 'RS256'
        );
        
        $now = time();
        $claims = array(
            'iss' => $key_data['client_email'],
            'scope' => 'https://www.googleapis.com/auth/indexing',
            'aud' => 'https://oauth2.googleapis.com/token',
            'iat' => $now,
            'exp' => $now + 3600
        );
        
        $header_encoded = $this->base64url_encode(wp_json_encode($header));
        $claims_encoded = $this->base64url_encode(wp_json_encode($claims));
        
        $signature_input = $header_encoded . '.' . $claims_encoded;
        
        // Sign with private key
        $private_key = openssl_pkey_get_private($key_data['private_key']);
        if (!$private_key) {
            return false;
        }
        
        $signature = '';
        if (!openssl_sign($signature_input, $signature, $private_key, OPENSSL_ALGO_SHA256)) {
            return false;
        }
        
        return $signature_input . '.' . $this->base64url_encode($signature);
    }
    
    /**
     * Get Google access token from JWT
     */
    private function get_google_access_token($jwt) {
        $response = wp_remote_post('https://oauth2.googleapis.com/token', array(
            'body' => array(
                'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
                'assertion' => $jwt
            ),
            'timeout' => 30
        ));
        
        if (is_wp_error($response)) {
            return false;
        }
        
        $body = json_decode(wp_remote_retrieve_body($response), true);
        return isset($body['access_token']) ? $body['access_token'] : false;
    }
    
    /**
     * Base64 URL encode
     */
    private function base64url_encode($data) {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }
    
    /**
     * Base64 URL decode
     */
    private function base64url_decode($data) {
        return base64_decode(strtr($data, '-_', '+/'));
    }
    
    /**
     * Ping IndexNow (All supported search engines)
     * v3.2: Added ALL IndexNow endpoints for maximum coverage
     * Strategy: More IndexNow pings = more crawler activity = Google notices and crawls more frequently
     */
    private function ping_indexnow($url, $engine = 'bing') {
        $api_key = get_option('wseo_indexnow_key', '');
        
        // Generate key if not exists
        if (empty($api_key)) {
            $api_key = wp_generate_password(32, false);
            update_option('wseo_indexnow_key', $api_key);
        }
        
        // Create key file if it doesn't exist (needed for verification)
        $this->create_indexnow_key_file($api_key);
        
        // v3.2: ALL IndexNow endpoints worldwide
        // IndexNow is a shared protocol - submitting to one notifies all participants
        // But we ping multiple for redundancy and faster propagation
        $endpoints = array(
            // Major search engines
            'bing' => 'https://www.bing.com/indexnow',           // Microsoft Bing (US/Global)
            'yandex' => 'https://yandex.com/indexnow',           // Yandex (Russia/CIS)
            'seznam' => 'https://search.seznam.cz/indexnow',     // Seznam (Czech Republic)
            'naver' => 'https://searchadvisor.naver.com/indexnow', // Naver (South Korea)
            
            // IndexNow API hub (shared by all participants)
            'indexnow' => 'https://api.indexnow.org/indexnow',   // Official IndexNow API
            
            // Additional European search engines supporting IndexNow
            'yep' => 'https://indexnow.yep.com/indexnow',        // Yep.com (Privacy-focused)
            
            // DuckDuckGo uses Bing's index, so Bing ping covers it
            // Ecosia uses Bing's index, so Bing ping covers it
            // Qwant uses Bing's index partially, so Bing ping helps
        );
        
        $endpoint = isset($endpoints[$engine]) ? $endpoints[$engine] : $endpoints['bing'];
        
        // v3.2: Use POST method with JSON for better reliability
        $response = wp_remote_post($endpoint, array(
            'timeout' => 30,
            'headers' => array(
                'Content-Type' => 'application/json; charset=utf-8'
            ),
            'body' => json_encode(array(
                'host' => parse_url(home_url(), PHP_URL_HOST),
                'key' => $api_key,
                'keyLocation' => home_url('/' . $api_key . '.txt'),
                'urlList' => array($url)
            ))
        ));
        
        if (is_wp_error($response)) {
            // Fallback to GET method
            $request_url = $endpoint . '?url=' . urlencode($url) . '&key=' . $api_key;
            $response = wp_remote_get($request_url, array('timeout' => 30));
            
            if (is_wp_error($response)) {
                return array('success' => false, 'error' => $response->get_error_message(), 'engine' => $engine);
            }
        }
        
        $code = wp_remote_retrieve_response_code($response);
        
        // 200 = OK, 202 = Accepted
        return array(
            'success' => in_array($code, array(200, 202)),
            'code' => $code,
            'engine' => $engine
        );
    }
    
    /**
     * Create IndexNow key file for verification
     */
    private function create_indexnow_key_file($key) {
        $file_path = ABSPATH . $key . '.txt';
        
        if (!file_exists($file_path)) {
            @file_put_contents($file_path, $key);
        }
    }
    
    /**
     * Log indexing result
     */
    private function log_indexing_result($post_id, $url, $results) {
        $log = get_option('wseo_indexing_log', array());
        
        // v3.2: Prevent duplicate entries for same URL within 1 minute
        $current_time = current_time('mysql');
        $current_timestamp = strtotime($current_time);
        
        // Check if this URL was logged in the last 60 seconds
        foreach ($log as $key => $entry) {
            if ($entry['url'] === $url) {
                $entry_timestamp = strtotime($entry['time']);
                if (($current_timestamp - $entry_timestamp) < 60) {
                    // Update existing entry instead of creating duplicate
                    // Merge results (keep successful pings from both)
                    foreach ($results as $engine => $result) {
                        if (!isset($log[$key]['results'][$engine]) || 
                            (isset($result['success']) && $result['success'])) {
                            $log[$key]['results'][$engine] = $result;
                        }
                    }
                    $log[$key]['time'] = $current_time; // Update time
                    update_option('wseo_indexing_log', $log);
                    
                    // Also save to post meta
                    update_post_meta($post_id, '_wseo_last_indexed', $current_time);
                    update_post_meta($post_id, '_wseo_index_results', $log[$key]['results']);
                    return;
                }
            }
        }
        
        // Keep only last 100 entries
        if (count($log) >= 100) {
            $log = array_slice($log, -99);
        }
        
        $log[] = array(
            'time' => $current_time,
            'post_id' => $post_id,
            'url' => $url,
            'results' => $results
        );
        
        update_option('wseo_indexing_log', $log);
        
        // Also save to post meta
        update_post_meta($post_id, '_wseo_last_indexed', $current_time);
        update_post_meta($post_id, '_wseo_index_results', $results);
    }
    
    /**
     * AJAX handler for manual indexing
     */
    public function ajax_manual_index() {
        check_ajax_referer('wseo_manual_index', 'nonce');
        
        if (!current_user_can('edit_posts')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        $post_id = intval($_POST['post_id']);
        $post = get_post($post_id);
        
        if (!$post || $post->post_status !== 'publish') {
            wp_send_json_error('Príspevok nie je publikovaný');
        }
        
        // Force indexing (temporarily enable)
        $url = get_permalink($post_id);
        $results = array();
        
        if (get_option('wseo_google_indexing_enabled', '0') === '1') {
            $results['google'] = $this->ping_google_indexing_api($url, 'URL_UPDATED');
        }
        
        if (get_option('wseo_bing_indexnow_enabled', '1') === '1') {
            $results['bing'] = $this->ping_indexnow($url, 'bing');
        }
        
        if (get_option('wseo_yandex_indexnow_enabled', '1') === '1') {
            $results['yandex'] = $this->ping_indexnow($url, 'yandex');
        }
        
        $this->log_indexing_result($post_id, $url, $results);
        
        wp_send_json_success(array(
            'url' => $url,
            'results' => $results
        ));
    }
    
    /**
     * =====================================================
     * MIGRATION FROM OTHER SEO PLUGINS
     * =====================================================
     */
    
    /**
     * AJAX handler for SEO migration
     */
    public function ajax_migrate_seo() {
        check_ajax_referer('wseo_migrate', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        $source = sanitize_text_field($_POST['source']);
        $imported = 0;
        
        switch ($source) {
            case 'yoast':
                $imported = $this->migrate_from_yoast();
                break;
            case 'rankmath':
                $imported = $this->migrate_from_rankmath();
                break;
            case 'aioseo':
                $imported = $this->migrate_from_aioseo();
                break;
            case 'seopress':
                $imported = $this->migrate_from_seopress();
                break;
            case 'theseoframework':
                $imported = $this->migrate_from_theseoframework();
                break;
            default:
                wp_send_json_error('Neznámy zdroj');
        }
        
        wp_send_json_success(array(
            'imported' => $imported,
            'source' => $source
        ));
    }
    
    /**
     * AJAX handler for dismissing migration notice
     */
    public function ajax_dismiss_migration() {
        check_ajax_referer('wseo_dismiss_migration', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        $source = sanitize_text_field($_POST['source']);
        $dismissed = get_option('wseo_dismissed_migrations', array());
        
        if (!in_array($source, $dismissed)) {
            $dismissed[] = $source;
            update_option('wseo_dismissed_migrations', $dismissed);
        }
        
        wp_send_json_success();
    }
    
    /**
     * Migrate from Yoast SEO
     */
    private function migrate_from_yoast() {
        global $wpdb;
        $imported = 0;
        
        $posts = $wpdb->get_results("
            SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
            WHERE meta_key IN ('_yoast_wpseo_title', '_yoast_wpseo_metadesc', '_yoast_wpseo_focuskw', '_yoast_wpseo_meta-robots-noindex', '_yoast_wpseo_meta-robots-nofollow', '_yoast_wpseo_canonical', '_yoast_wpseo_opengraph-image')
        ");
        
        foreach ($posts as $post) {
            $post_id = $post->post_id;
            
            $title = get_post_meta($post_id, '_yoast_wpseo_title', true);
            if (!empty($title)) {
                $title = $this->convert_seo_variables($title, $post_id, 'yoast');
                update_post_meta($post_id, '_wseo_meta_title', $title);
            }
            
            $desc = get_post_meta($post_id, '_yoast_wpseo_metadesc', true);
            if (!empty($desc)) {
                update_post_meta($post_id, '_wseo_meta_description', $desc);
            }
            
            $keywords = get_post_meta($post_id, '_yoast_wpseo_focuskw', true);
            if (!empty($keywords)) {
                update_post_meta($post_id, '_wseo_meta_keywords', $keywords);
            }
            
            $noindex = get_post_meta($post_id, '_yoast_wpseo_meta-robots-noindex', true);
            if ($noindex === '1') {
                update_post_meta($post_id, '_wseo_noindex', '1');
            }
            
            $nofollow = get_post_meta($post_id, '_yoast_wpseo_meta-robots-nofollow', true);
            if ($nofollow === '1') {
                update_post_meta($post_id, '_wseo_nofollow', '1');
            }
            
            $canonical = get_post_meta($post_id, '_yoast_wpseo_canonical', true);
            if (!empty($canonical)) {
                update_post_meta($post_id, '_wseo_canonical', $canonical);
            }
            
            $og_image = get_post_meta($post_id, '_yoast_wpseo_opengraph-image', true);
            if (!empty($og_image)) {
                update_post_meta($post_id, '_wseo_og_image', $og_image);
            }
            
            $imported++;
        }
        
        return $imported;
    }
    
    /**
     * Migrate from Rank Math
     */
    private function migrate_from_rankmath() {
        global $wpdb;
        $imported = 0;
        
        $posts = $wpdb->get_results("
            SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
            WHERE meta_key IN ('rank_math_title', 'rank_math_description', 'rank_math_focus_keyword', 'rank_math_robots', 'rank_math_canonical_url', 'rank_math_facebook_image')
        ");
        
        foreach ($posts as $post) {
            $post_id = $post->post_id;
            
            $title = get_post_meta($post_id, 'rank_math_title', true);
            if (!empty($title)) {
                $title = $this->convert_seo_variables($title, $post_id, 'rankmath');
                update_post_meta($post_id, '_wseo_meta_title', $title);
            }
            
            $desc = get_post_meta($post_id, 'rank_math_description', true);
            if (!empty($desc)) {
                $desc = $this->convert_seo_variables($desc, $post_id, 'rankmath');
                update_post_meta($post_id, '_wseo_meta_description', $desc);
            }
            
            $keywords = get_post_meta($post_id, 'rank_math_focus_keyword', true);
            if (!empty($keywords)) {
                update_post_meta($post_id, '_wseo_meta_keywords', $keywords);
            }
            
            $robots = get_post_meta($post_id, 'rank_math_robots', true);
            if (is_array($robots)) {
                if (in_array('noindex', $robots)) {
                    update_post_meta($post_id, '_wseo_noindex', '1');
                }
                if (in_array('nofollow', $robots)) {
                    update_post_meta($post_id, '_wseo_nofollow', '1');
                }
            }
            
            $canonical = get_post_meta($post_id, 'rank_math_canonical_url', true);
            if (!empty($canonical)) {
                update_post_meta($post_id, '_wseo_canonical', $canonical);
            }
            
            $og_image = get_post_meta($post_id, 'rank_math_facebook_image', true);
            if (!empty($og_image)) {
                update_post_meta($post_id, '_wseo_og_image', $og_image);
            }
            
            $imported++;
        }
        
        return $imported;
    }
    
    /**
     * Migrate from All in One SEO
     */
    private function migrate_from_aioseo() {
        global $wpdb;
        $imported = 0;
        
        $posts = $wpdb->get_results("
            SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
            WHERE meta_key IN ('_aioseo_title', '_aioseo_description', '_aioseo_keywords', '_aioseo_og_image', '_aioseop_title', '_aioseop_description', '_aioseop_keywords')
        ");
        
        foreach ($posts as $post) {
            $post_id = $post->post_id;
            
            $title = get_post_meta($post_id, '_aioseo_title', true);
            if (empty($title)) $title = get_post_meta($post_id, '_aioseop_title', true);
            if (!empty($title)) {
                update_post_meta($post_id, '_wseo_meta_title', $title);
            }
            
            $desc = get_post_meta($post_id, '_aioseo_description', true);
            if (empty($desc)) $desc = get_post_meta($post_id, '_aioseop_description', true);
            if (!empty($desc)) {
                update_post_meta($post_id, '_wseo_meta_description', $desc);
            }
            
            $keywords = get_post_meta($post_id, '_aioseo_keywords', true);
            if (empty($keywords)) $keywords = get_post_meta($post_id, '_aioseop_keywords', true);
            if (!empty($keywords)) {
                update_post_meta($post_id, '_wseo_meta_keywords', $keywords);
            }
            
            $og_image = get_post_meta($post_id, '_aioseo_og_image', true);
            if (!empty($og_image)) {
                update_post_meta($post_id, '_wseo_og_image', $og_image);
            }
            
            $imported++;
        }
        
        return $imported;
    }
    
    /**
     * Migrate from SEOPress
     */
    private function migrate_from_seopress() {
        global $wpdb;
        $imported = 0;
        
        $posts = $wpdb->get_results("
            SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
            WHERE meta_key IN ('_seopress_titles_title', '_seopress_titles_desc', '_seopress_analysis_target_kw', '_seopress_robots_index', '_seopress_robots_follow', '_seopress_robots_canonical', '_seopress_social_fb_img')
        ");
        
        foreach ($posts as $post) {
            $post_id = $post->post_id;
            
            $title = get_post_meta($post_id, '_seopress_titles_title', true);
            if (!empty($title)) {
                update_post_meta($post_id, '_wseo_meta_title', $title);
            }
            
            $desc = get_post_meta($post_id, '_seopress_titles_desc', true);
            if (!empty($desc)) {
                update_post_meta($post_id, '_wseo_meta_description', $desc);
            }
            
            $keywords = get_post_meta($post_id, '_seopress_analysis_target_kw', true);
            if (!empty($keywords)) {
                update_post_meta($post_id, '_wseo_meta_keywords', $keywords);
            }
            
            $noindex = get_post_meta($post_id, '_seopress_robots_index', true);
            if ($noindex === 'yes') {
                update_post_meta($post_id, '_wseo_noindex', '1');
            }
            
            $nofollow = get_post_meta($post_id, '_seopress_robots_follow', true);
            if ($nofollow === 'yes') {
                update_post_meta($post_id, '_wseo_nofollow', '1');
            }
            
            $canonical = get_post_meta($post_id, '_seopress_robots_canonical', true);
            if (!empty($canonical)) {
                update_post_meta($post_id, '_wseo_canonical', $canonical);
            }
            
            $og_image = get_post_meta($post_id, '_seopress_social_fb_img', true);
            if (!empty($og_image)) {
                update_post_meta($post_id, '_wseo_og_image', $og_image);
            }
            
            $imported++;
        }
        
        return $imported;
    }
    
    /**
     * Migrate from The SEO Framework
     */
    private function migrate_from_theseoframework() {
        global $wpdb;
        $imported = 0;
        
        $posts = $wpdb->get_results("
            SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
            WHERE meta_key IN ('_genesis_title', '_genesis_description', '_genesis_noindex', '_genesis_nofollow', '_genesis_canonical_uri', '_social_image_url')
        ");
        
        foreach ($posts as $post) {
            $post_id = $post->post_id;
            
            $title = get_post_meta($post_id, '_genesis_title', true);
            if (!empty($title)) {
                update_post_meta($post_id, '_wseo_meta_title', $title);
            }
            
            $desc = get_post_meta($post_id, '_genesis_description', true);
            if (!empty($desc)) {
                update_post_meta($post_id, '_wseo_meta_description', $desc);
            }
            
            $noindex = get_post_meta($post_id, '_genesis_noindex', true);
            if ($noindex === '1') {
                update_post_meta($post_id, '_wseo_noindex', '1');
            }
            
            $nofollow = get_post_meta($post_id, '_genesis_nofollow', true);
            if ($nofollow === '1') {
                update_post_meta($post_id, '_wseo_nofollow', '1');
            }
            
            $canonical = get_post_meta($post_id, '_genesis_canonical_uri', true);
            if (!empty($canonical)) {
                update_post_meta($post_id, '_wseo_canonical', $canonical);
            }
            
            $og_image = get_post_meta($post_id, '_social_image_url', true);
            if (!empty($og_image)) {
                update_post_meta($post_id, '_wseo_og_image', $og_image);
            }
            
            $imported++;
        }
        
        return $imported;
    }
    
    /**
     * Convert SEO plugin variables to actual values
     */
    private function convert_seo_variables($string, $post_id, $plugin = 'yoast') {
        $post = get_post($post_id);
        if (!$post) return $string;
        
        $categories = get_the_category($post_id);
        $primary_cat = !empty($categories) ? $categories[0]->name : '';
        
        // Yoast format: %%variable%%
        // Rank Math format: %variable%
        $yoast_vars = array(
            '%%title%%' => $post->post_title,
            '%%sitename%%' => get_bloginfo('name'),
            '%%sep%%' => '|',
            '%%page%%' => '',
            '%%primary_category%%' => $primary_cat,
            '%%category%%' => $primary_cat,
            '%%excerpt%%' => get_the_excerpt($post_id),
            '%%date%%' => get_the_date('', $post_id),
        );
        
        $rankmath_vars = array(
            '%title%' => $post->post_title,
            '%sitename%' => get_bloginfo('name'),
            '%sep%' => '|',
            '%page%' => '',
            '%category%' => $primary_cat,
            '%excerpt%' => get_the_excerpt($post_id),
            '%date%' => get_the_date('', $post_id),
        );
        
        if ($plugin === 'yoast') {
            return str_replace(array_keys($yoast_vars), array_values($yoast_vars), $string);
        } else {
            return str_replace(array_keys($rankmath_vars), array_values($rankmath_vars), $string);
        }
    }
    
    /**
     * Register settings
     */
    public function register_settings() {
        register_setting('wseo_global_settings', 'wseo_global_site_name');
        register_setting('wseo_global_settings', 'wseo_global_home_title');
        register_setting('wseo_global_settings', 'wseo_global_home_description');
        register_setting('wseo_global_settings', 'wseo_global_og_image');
        register_setting('wseo_global_settings', 'wseo_global_twitter_handle');
        register_setting('wseo_global_settings', 'wseo_global_fb_app_id');
        register_setting('wseo_global_settings', 'wseo_robots_custom_rules');
        
        // Predvolené Person údaje (founder/author)
        register_setting('wseo_global_settings', 'wseo_default_person_name');
        register_setting('wseo_global_settings', 'wseo_default_person_image');
        register_setting('wseo_global_settings', 'wseo_default_person_jobtitle');
        register_setting('wseo_global_settings', 'wseo_default_person_url');
        register_setting('wseo_global_settings', 'wseo_default_person_social');
        
        // Auto-Redirect 404 to Similar Content (v2.8.6)
        register_setting('wseo_global_settings', 'wseo_auto_redirect_404');
        
        // v2.9.9: Lodging/VacationRental specific settings
        register_setting('wseo_global_settings', 'wseo_schema_identifier');
        register_setting('wseo_global_settings', 'wseo_schema_description');
        register_setting('wseo_global_settings', 'wseo_schema_images');
        register_setting('wseo_global_settings', 'wseo_schema_num_rooms');
        register_setting('wseo_global_settings', 'wseo_schema_num_beds');
        register_setting('wseo_global_settings', 'wseo_schema_max_occupancy');
        register_setting('wseo_global_settings', 'wseo_schema_floor_size');
        register_setting('wseo_global_settings', 'wseo_schema_checkin_time');
        register_setting('wseo_global_settings', 'wseo_schema_checkout_time');
        register_setting('wseo_global_settings', 'wseo_schema_amenities');
        register_setting('wseo_global_settings', 'wseo_schema_num_bathrooms');
        register_setting('wseo_global_settings', 'wseo_schema_room_type');
        register_setting('wseo_global_settings', 'wseo_schema_additional_type');
        register_setting('wseo_global_settings', 'wseo_schema_bed_type');
        register_setting('wseo_global_settings', 'wseo_schema_bed_count');
        register_setting('wseo_global_settings', 'wseo_schema_languages');
        
        // v2.9.9: Business legal fields
        register_setting('wseo_global_settings', 'wseo_schema_legal_name');
        register_setting('wseo_global_settings', 'wseo_schema_tax_id');
        register_setting('wseo_global_settings', 'wseo_schema_vat_id');
        register_setting('wseo_global_settings', 'wseo_schema_founding_date');
        register_setting('wseo_global_settings', 'wseo_schema_num_employees');
        register_setting('wseo_global_settings', 'wseo_schema_slogan');
        register_setting('wseo_global_settings', 'wseo_schema_area_served');
        register_setting('wseo_global_settings', 'wseo_schema_payment_accepted');
        register_setting('wseo_global_settings', 'wseo_schema_has_map');
        
        // v2.9.9: Restaurant specific fields
        register_setting('wseo_global_settings', 'wseo_schema_cuisine');
        register_setting('wseo_global_settings', 'wseo_schema_menu_url');
        register_setting('wseo_global_settings', 'wseo_schema_accepts_reservations');
    }
    
    /**
     * Taxonomy SEO fields - Add form
     */
    public function taxonomy_add_seo_fields($taxonomy) {
        ?>
        <div class="form-field">
            <h3>🔍 SEO nastavenia</h3>
        </div>
        <div class="form-field">
            <label for="wseo_term_title">Meta Title</label>
            <input type="text" name="wseo_term_title" id="wseo_term_title" value="">
            <p class="description">Vlastný meta titulok pre túto taxonómiu.</p>
        </div>
        <div class="form-field">
            <label for="wseo_term_description">Meta popis</label>
            <textarea name="wseo_term_description" id="wseo_term_description" rows="3"></textarea>
            <p class="description">Vlastný meta popis pre túto taxonómiu.</p>
        </div>
        <div class="form-field">
            <label for="wseo_term_redirect">🔄 Presmerovanie</label>
            <input type="url" name="wseo_term_redirect" id="wseo_term_redirect" value="" placeholder="https://example.com/nova-stranka/">
            <p class="description">Zadajte URL kam sa má táto značka/kategória presmerovať.</p>
        </div>
        <div class="form-field">
            <label for="wseo_term_redirect_type">Typ presmerovania</label>
            <select name="wseo_term_redirect_type" id="wseo_term_redirect_type">
                <option value="301">301 - Trvalé presmerovanie (odporúčané)</option>
                <option value="302">302 - Dočasné presmerovanie</option>
            </select>
        </div>
        <div class="form-field">
            <label>
                <input type="checkbox" name="wseo_term_noindex" value="1">
                Neinexovať túto taxonómiu (noindex)
            </label>
        </div>
        <?php
    }
    
    /**
     * Taxonomy SEO fields - Edit form
     */
    public function taxonomy_edit_seo_fields($term, $taxonomy) {
        $title = get_term_meta($term->term_id, '_wseo_term_title', true);
        $description = get_term_meta($term->term_id, '_wseo_term_description', true);
        $redirect = get_term_meta($term->term_id, '_wseo_term_redirect', true);
        $redirect_type = get_term_meta($term->term_id, '_wseo_term_redirect_type', true) ?: '301';
        $noindex = get_term_meta($term->term_id, '_wseo_term_noindex', true);
        ?>
        <tr class="form-field">
            <th colspan="2"><h3>🔍 SEO nastavenia</h3></th>
        </tr>
        <tr class="form-field">
            <th><label for="wseo_term_title">Meta Title</label></th>
            <td>
                <input type="text" name="wseo_term_title" id="wseo_term_title" value="<?php echo esc_attr($title); ?>" class="large-text">
                <p class="description">Vlastný meta titulok pre túto taxonómiu. Ak je prázdne, použije sa názov.</p>
            </td>
        </tr>
        <tr class="form-field">
            <th><label for="wseo_term_description">Meta popis</label></th>
            <td>
                <textarea name="wseo_term_description" id="wseo_term_description" rows="3" class="large-text"><?php echo esc_textarea($description); ?></textarea>
                <p class="description">Vlastný meta popis. Ak je prázdne, použije sa popis taxonómie.</p>
            </td>
        </tr>
        <tr class="form-field">
            <th><label for="wseo_term_redirect">🔄 Presmerovanie</label></th>
            <td>
                <input type="url" name="wseo_term_redirect" id="wseo_term_redirect" value="<?php echo esc_url($redirect); ?>" class="large-text" placeholder="https://example.com/nova-stranka/">
                <p class="description">Zadajte URL kam sa má táto značka/kategória presmerovať. Nechajte prázdne ak nechcete presmerovať.</p>
            </td>
        </tr>
        <tr class="form-field">
            <th><label for="wseo_term_redirect_type">Typ presmerovania</label></th>
            <td>
                <select name="wseo_term_redirect_type" id="wseo_term_redirect_type">
                    <option value="301" <?php selected($redirect_type, '301'); ?>>301 - Trvalé presmerovanie (odporúčané)</option>
                    <option value="302" <?php selected($redirect_type, '302'); ?>>302 - Dočasné presmerovanie</option>
                    <option value="307" <?php selected($redirect_type, '307'); ?>>307 - Dočasné (zachová metódu)</option>
                </select>
                <p class="description">
                    <strong>301</strong> - Pre trvalé zmeny URL. Google prenesie SEO hodnotu.<br>
                    <strong>302</strong> - Pre dočasné zmeny. Google neprenesie SEO hodnotu.
                </p>
            </td>
        </tr>
        <tr class="form-field">
            <th><label for="wseo_term_noindex">Viditeľnosť</label></th>
            <td>
                <label>
                    <input type="checkbox" name="wseo_term_noindex" value="1" <?php checked($noindex, '1'); ?>>
                    Neinexovať túto taxonómiu (noindex)
                </label>
                <p class="description">Vyhľadávače túto stránku nebudú zobrazovať vo výsledkoch.</p>
            </td>
        </tr>
        <?php
    }
    
    /**
     * Save taxonomy SEO fields
     */
    public function save_taxonomy_seo_fields($term_id) {
        if (isset($_POST['wseo_term_title'])) {
            update_term_meta($term_id, '_wseo_term_title', sanitize_text_field($_POST['wseo_term_title']));
        }
        if (isset($_POST['wseo_term_description'])) {
            update_term_meta($term_id, '_wseo_term_description', sanitize_textarea_field($_POST['wseo_term_description']));
        }
        if (isset($_POST['wseo_term_redirect'])) {
            update_term_meta($term_id, '_wseo_term_redirect', esc_url_raw($_POST['wseo_term_redirect']));
        }
        if (isset($_POST['wseo_term_redirect_type'])) {
            update_term_meta($term_id, '_wseo_term_redirect_type', sanitize_text_field($_POST['wseo_term_redirect_type']));
        }
        $noindex = isset($_POST['wseo_term_noindex']) ? '1' : '';
        update_term_meta($term_id, '_wseo_term_noindex', $noindex);
    }
    
    /**
     * Handle taxonomy redirects
     */
    public function handle_taxonomy_redirects() {
        if (!is_category() && !is_tag() && !is_tax('product_cat') && !is_tax('product_tag')) {
            return;
        }
        
        $term = get_queried_object();
        if (!$term || !isset($term->term_id)) {
            return;
        }
        
        $redirect_url = get_term_meta($term->term_id, '_wseo_term_redirect', true);
        
        if (!empty($redirect_url)) {
            $redirect_type = get_term_meta($term->term_id, '_wseo_term_redirect_type', true) ?: '301';
            $status_code = intval($redirect_type);
            
            if (!in_array($status_code, array(301, 302, 307, 308))) {
                $status_code = 301;
            }
            
            wp_redirect($redirect_url, $status_code);
            exit;
        }
    }
    
    /**
     * WooCommerce fields
     */
    public function add_product_seo_fields() {
        global $post;
        
        echo '<div class="options_group">';
        echo '<p class="form-field"><strong>🔍 SEO nastavenia</strong></p>';
        
        woocommerce_wp_text_input(array(
            'id' => '_wseo_meta_title',
            'label' => 'Meta Title',
            'value' => get_post_meta($post->ID, '_wseo_meta_title', true)
        ));
        
        woocommerce_wp_textarea_input(array(
            'id' => '_wseo_meta_description',
            'label' => 'Meta Description',
            'value' => get_post_meta($post->ID, '_wseo_meta_description', true)
        ));
        
        echo '</div>';
        
        // v2.9.12: Editorial Review section for Google Rich Results
        echo '<div class="options_group">';
        echo '<p class="form-field"><strong>⭐ Editoriálna recenzia (Google Rich Results)</strong></p>';
        echo '<p class="form-field" style="font-style: italic; color: #666;">Pridajte editoriálnu recenziu pre produkty bez zákazníckych recenzií. Google to akceptuje ako legitímnu recenziu.</p>';
        
        woocommerce_wp_checkbox(array(
            'id' => '_wseo_editorial_review_enabled',
            'label' => 'Povoliť editoriálnu recenziu',
            'description' => 'Pridať recenziu do Schema.org (len ak produkt nemá zákaznícke recenzie)',
            'value' => get_post_meta($post->ID, '_wseo_editorial_review_enabled', true)
        ));
        
        woocommerce_wp_select(array(
            'id' => '_wseo_editorial_rating',
            'label' => 'Hodnotenie',
            'options' => array(
                '5' => '⭐⭐⭐⭐⭐ 5/5 - Výborné',
                '4.5' => '⭐⭐⭐⭐½ 4.5/5 - Veľmi dobré',
                '4' => '⭐⭐⭐⭐ 4/5 - Dobré',
                '3.5' => '⭐⭐⭐½ 3.5/5 - Priemerné',
                '3' => '⭐⭐⭐ 3/5 - Dostačujúce'
            ),
            'value' => get_post_meta($post->ID, '_wseo_editorial_rating', true) ?: '5'
        ));
        
        woocommerce_wp_textarea_input(array(
            'id' => '_wseo_editorial_review_text',
            'label' => 'Text recenzie',
            'placeholder' => 'Napr.: Kvalitný produkt s výborným pomerom cena/výkon. Odporúčame pre...',
            'value' => get_post_meta($post->ID, '_wseo_editorial_review_text', true),
            'desc_tip' => true,
            'description' => 'Krátka recenzia produktu (min. 50 znakov). Bude zobrazená ako editoriálna recenzia v Schema.org.'
        ));
        
        echo '</div>';
    }
    
    public function save_product_seo_fields($post_id) {
        if (isset($_POST['_wseo_meta_title'])) {
            update_post_meta($post_id, '_wseo_meta_title', sanitize_text_field($_POST['_wseo_meta_title']));
        }
        if (isset($_POST['_wseo_meta_description'])) {
            update_post_meta($post_id, '_wseo_meta_description', sanitize_textarea_field($_POST['_wseo_meta_description']));
        }
        
        // v2.9.12: Save Editorial Review fields
        update_post_meta($post_id, '_wseo_editorial_review_enabled', isset($_POST['_wseo_editorial_review_enabled']) ? 'yes' : '');
        if (isset($_POST['_wseo_editorial_rating'])) {
            update_post_meta($post_id, '_wseo_editorial_rating', sanitize_text_field($_POST['_wseo_editorial_rating']));
        }
        if (isset($_POST['_wseo_editorial_review_text'])) {
            update_post_meta($post_id, '_wseo_editorial_review_text', sanitize_textarea_field($_POST['_wseo_editorial_review_text']));
        }
    }
    
    /**
     * Render pages
     */
    /**
     * v3.2: Render SEO Dashboard page (main dashboard with health score)
     */
    public function render_seo_dashboard_page() {
        include WSEO_PLUGIN_DIR . 'templates/seo-dashboard.php';
    }
    
    public function render_dashboard_page() {
        include WSEO_PLUGIN_DIR . 'templates/dashboard.php';
    }
    
    public function render_global_page() {
        if (isset($_POST['wseo_save_global'])) {
            check_admin_referer('wseo_global_settings');
            
            // Basic settings
            update_option('wseo_global_site_name', sanitize_text_field($_POST['wseo_global_site_name']));
            update_option('wseo_title_separator', sanitize_text_field($_POST['wseo_title_separator']));
            update_option('wseo_global_home_title', sanitize_text_field($_POST['wseo_global_home_title']));
            update_option('wseo_global_home_description', sanitize_textarea_field($_POST['wseo_global_home_description']));
            update_option('wseo_global_home_keywords', sanitize_text_field($_POST['wseo_global_home_keywords']));
            update_option('wseo_global_og_image', esc_url_raw($_POST['wseo_global_og_image']));
            update_option('wseo_global_twitter_handle', sanitize_text_field($_POST['wseo_global_twitter_handle']));
            update_option('wseo_global_fb_app_id', sanitize_text_field($_POST['wseo_global_fb_app_id']));
            
            // AI description fields for llms.txt
            update_option('wseo_ai_company_name', sanitize_text_field($_POST['wseo_ai_company_name']));
            update_option('wseo_ai_what_we_do', sanitize_textarea_field($_POST['wseo_ai_what_we_do']));
            update_option('wseo_ai_products_services', sanitize_textarea_field($_POST['wseo_ai_products_services']));
            update_option('wseo_ai_location', sanitize_text_field($_POST['wseo_ai_location']));
            update_option('wseo_ai_target_audience', sanitize_text_field($_POST['wseo_ai_target_audience']));
            update_option('wseo_ai_extra_info', sanitize_textarea_field($_POST['wseo_ai_extra_info']));
            update_option('wseo_ai_custom_text', sanitize_textarea_field($_POST['wseo_ai_custom_text']));
            
            // v3.1: Speakable Schema settings
            update_option('wseo_enable_speakable', isset($_POST['wseo_enable_speakable']) ? '1' : '0');
            update_option('wseo_speakable_mode', sanitize_text_field($_POST['wseo_speakable_mode'] ?? 'auto'));
            update_option('wseo_speakable_css_classes', sanitize_text_field($_POST['wseo_speakable_css_classes'] ?? '.speakable, .voice-content'));
            
            // v3.2: FAQ Auto-detect
            update_option('wseo_faq_autodetect', isset($_POST['wseo_faq_autodetect']) ? '1' : '0');
            
            // v3.2: Critical CSS
            update_option('wseo_critical_css_enabled', isset($_POST['wseo_critical_css_enabled']) ? '1' : '0');
            update_option('wseo_critical_css_custom', wp_strip_all_tags($_POST['wseo_critical_css_custom'] ?? ''));
            
            // Google Analytics & GTM
            update_option('wseo_ga_id', sanitize_text_field($_POST['wseo_ga_id']));
            update_option('wseo_ga_anonymize', isset($_POST['wseo_ga_anonymize']) ? '1' : '0');
            update_option('wseo_gtm_id', sanitize_text_field($_POST['wseo_gtm_id']));
            
            // Note: Webmaster verification codes are now in Files/Indexing page only (files.php)
            // Removed from here to prevent accidental overwrite when saving Global settings
            
            // Schema.org settings
            update_option('wseo_schema_type', sanitize_text_field($_POST['wseo_schema_type']));
            update_option('wseo_schema_name', sanitize_text_field($_POST['wseo_schema_name']));
            update_option('wseo_schema_logo', esc_url_raw($_POST['wseo_schema_logo']));
            update_option('wseo_schema_image', esc_url_raw($_POST['wseo_schema_image'] ?? '')); // v3.1: Organization image
            update_option('wseo_logo_credit', sanitize_text_field($_POST['wseo_logo_credit'] ?? get_bloginfo('name')));
            update_option('wseo_logo_license', esc_url_raw($_POST['wseo_logo_license'] ?? 'https://creativecommons.org/licenses/by/4.0/'));
            update_option('wseo_logo_license_page', esc_url_raw($_POST['wseo_logo_license_page'] ?? home_url('/image-licenses/')));
            update_option('wseo_logo_creator', sanitize_text_field($_POST['wseo_logo_creator'] ?? ''));
            update_option('wseo_logo_copyright_notice', sanitize_text_field($_POST['wseo_logo_copyright_notice'] ?? ''));
            update_option('wseo_schema_phone', sanitize_text_field($_POST['wseo_schema_phone']));
            update_option('wseo_schema_email', sanitize_email($_POST['wseo_schema_email']));
            update_option('wseo_schema_address_street', sanitize_text_field($_POST['wseo_schema_address_street']));
            update_option('wseo_schema_address_city', sanitize_text_field($_POST['wseo_schema_address_city']));
            update_option('wseo_schema_address_zip', sanitize_text_field($_POST['wseo_schema_address_zip']));
            update_option('wseo_schema_address_region', sanitize_text_field($_POST['wseo_schema_address_region'] ?? ''));
            update_option('wseo_schema_address_country', sanitize_text_field($_POST['wseo_schema_address_country']));
            update_option('wseo_schema_geo_lat', sanitize_text_field($_POST['wseo_schema_geo_lat']));
            update_option('wseo_schema_geo_lng', sanitize_text_field($_POST['wseo_schema_geo_lng']));
            update_option('wseo_schema_opening_hours', sanitize_textarea_field($_POST['wseo_schema_opening_hours'] ?? ''));
            update_option('wseo_schema_price_range', sanitize_text_field($_POST['wseo_schema_price_range']));
            
            // v2.9.9: Opening hours by day
            $days = array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun');
            foreach ($days as $day) {
                update_option("wseo_schema_hours_{$day}_open", sanitize_text_field($_POST["wseo_schema_hours_{$day}_open"] ?? ''));
                update_option("wseo_schema_hours_{$day}_close", sanitize_text_field($_POST["wseo_schema_hours_{$day}_close"] ?? ''));
            }
            
            // v2.9.9: Social media (sameAs)
            update_option('wseo_schema_facebook', esc_url_raw($_POST['wseo_schema_facebook'] ?? ''));
            update_option('wseo_schema_instagram', esc_url_raw($_POST['wseo_schema_instagram'] ?? ''));
            update_option('wseo_schema_twitter', esc_url_raw($_POST['wseo_schema_twitter'] ?? ''));
            update_option('wseo_schema_linkedin', esc_url_raw($_POST['wseo_schema_linkedin'] ?? ''));
            update_option('wseo_schema_youtube', esc_url_raw($_POST['wseo_schema_youtube'] ?? ''));
            update_option('wseo_schema_tiktok', esc_url_raw($_POST['wseo_schema_tiktok'] ?? ''));
            update_option('wseo_schema_pinterest', esc_url_raw($_POST['wseo_schema_pinterest'] ?? ''));
            update_option('wseo_schema_tweetko', esc_url_raw($_POST['wseo_schema_tweetko'] ?? ''));
            
            // v2.9.10: Aggregate rating REMOVED from global settings
            // Google doesn't support aggregateRating for LocalBusiness/Organization since 2019
            // Keeping old values for backwards compatibility, but not saving new ones
            
            // Legacy social fields (keep for backwards compatibility)
            update_option('wseo_schema_social_facebook', esc_url_raw($_POST['wseo_schema_social_facebook'] ?? ''));
            update_option('wseo_schema_social_instagram', esc_url_raw($_POST['wseo_schema_social_instagram'] ?? ''));
            update_option('wseo_schema_social_linkedin', esc_url_raw($_POST['wseo_schema_social_linkedin'] ?? ''));
            update_option('wseo_schema_social_youtube', esc_url_raw($_POST['wseo_schema_social_youtube'] ?? ''));
            update_option('wseo_schema_social_tweetko', esc_url_raw($_POST['wseo_schema_social_tweetko'] ?? ''));
            
            // v2.9.9: Lodging/VacationRental fields
            update_option('wseo_schema_identifier', sanitize_text_field($_POST['wseo_schema_identifier'] ?? ''));
            update_option('wseo_schema_description', sanitize_textarea_field($_POST['wseo_schema_description'] ?? ''));
            update_option('wseo_schema_images', sanitize_textarea_field($_POST['wseo_schema_images'] ?? ''));
            update_option('wseo_schema_num_rooms', sanitize_text_field($_POST['wseo_schema_num_rooms'] ?? ''));
            update_option('wseo_schema_num_beds', sanitize_text_field($_POST['wseo_schema_num_beds'] ?? ''));
            update_option('wseo_schema_max_occupancy', sanitize_text_field($_POST['wseo_schema_max_occupancy'] ?? ''));
            update_option('wseo_schema_floor_size', sanitize_text_field($_POST['wseo_schema_floor_size'] ?? ''));
            update_option('wseo_schema_num_bathrooms', sanitize_text_field($_POST['wseo_schema_num_bathrooms'] ?? ''));
            update_option('wseo_schema_room_type', sanitize_text_field($_POST['wseo_schema_room_type'] ?? 'EntirePlace'));
            update_option('wseo_schema_additional_type', sanitize_text_field($_POST['wseo_schema_additional_type'] ?? ''));
            update_option('wseo_schema_bed_type', sanitize_text_field($_POST['wseo_schema_bed_type'] ?? ''));
            update_option('wseo_schema_bed_count', sanitize_text_field($_POST['wseo_schema_bed_count'] ?? ''));
            update_option('wseo_schema_checkin_time', sanitize_text_field($_POST['wseo_schema_checkin_time'] ?? '14:00'));
            update_option('wseo_schema_checkout_time', sanitize_text_field($_POST['wseo_schema_checkout_time'] ?? '10:00'));
            update_option('wseo_schema_languages', sanitize_text_field($_POST['wseo_schema_languages'] ?? ''));
            update_option('wseo_schema_amenities', sanitize_text_field($_POST['wseo_schema_amenities'] ?? ''));
            
            // v2.9.9: Business legal fields
            update_option('wseo_schema_legal_name', sanitize_text_field($_POST['wseo_schema_legal_name'] ?? ''));
            update_option('wseo_schema_tax_id', sanitize_text_field($_POST['wseo_schema_tax_id'] ?? ''));
            update_option('wseo_schema_vat_id', sanitize_text_field($_POST['wseo_schema_vat_id'] ?? ''));
            update_option('wseo_schema_founding_date', sanitize_text_field($_POST['wseo_schema_founding_date'] ?? ''));
            update_option('wseo_schema_num_employees', sanitize_text_field($_POST['wseo_schema_num_employees'] ?? ''));
            update_option('wseo_schema_slogan', sanitize_text_field($_POST['wseo_schema_slogan'] ?? ''));
            update_option('wseo_schema_area_served', sanitize_text_field($_POST['wseo_schema_area_served'] ?? ''));
            update_option('wseo_schema_payment_accepted', sanitize_text_field($_POST['wseo_schema_payment_accepted'] ?? ''));
            update_option('wseo_schema_has_map', esc_url_raw($_POST['wseo_schema_has_map'] ?? ''));
            
            // v2.9.9: Restaurant fields
            update_option('wseo_schema_cuisine', sanitize_text_field($_POST['wseo_schema_cuisine'] ?? ''));
            update_option('wseo_schema_menu_url', esc_url_raw($_POST['wseo_schema_menu_url'] ?? ''));
            update_option('wseo_schema_accepts_reservations', isset($_POST['wseo_schema_accepts_reservations']) ? '1' : '0');
            
            // Predvolené Person údaje (founder/author)
            update_option('wseo_default_person_name', sanitize_text_field($_POST['wseo_default_person_name']));
            update_option('wseo_default_person_image', esc_url_raw($_POST['wseo_default_person_image']));
            update_option('wseo_default_person_jobtitle', sanitize_text_field($_POST['wseo_default_person_jobtitle']));
            update_option('wseo_default_person_url', esc_url_raw($_POST['wseo_default_person_url']));
            update_option('wseo_default_person_social', sanitize_textarea_field($_POST['wseo_default_person_social']));
            // v2.9.17: New Person contact fields
            update_option('wseo_default_person_email', sanitize_email($_POST['wseo_default_person_email'] ?? ''));
            update_option('wseo_default_person_telephone', sanitize_text_field($_POST['wseo_default_person_telephone'] ?? ''));
            update_option('wseo_default_person_address', sanitize_text_field($_POST['wseo_default_person_address'] ?? ''));
            
            // Image auto-fill settings
            update_option('wseo_auto_alt', isset($_POST['wseo_auto_alt']) ? '1' : '0');
            update_option('wseo_auto_title', isset($_POST['wseo_auto_title']) ? '1' : '0');
            update_option('wseo_auto_caption', isset($_POST['wseo_auto_caption']) ? '1' : '0');
            update_option('wseo_auto_description', isset($_POST['wseo_auto_description']) ? '1' : '0');
            update_option('wseo_auto_fallback', sanitize_text_field($_POST['wseo_auto_fallback']));
            
            // Note: Instant Indexing and Google Indexing API settings are now in Files/Indexing page only (files.php)
            // Removed from here to prevent accidental overwrite when saving Global settings
            
            // Prefetch Proxy - vždy zapnuté, nie je potrebné ukladať
            
            // Performance settings (v2.4.2)
            update_option('wseo_enable_prefetch', isset($_POST['wseo_enable_prefetch']) ? '1' : '0');
            update_option('wseo_prefetch_strategy', sanitize_text_field($_POST['wseo_prefetch_strategy']));
            update_option('wseo_prefetch_hover_delay', intval($_POST['wseo_prefetch_hover_delay']));
            update_option('wseo_prefetch_exclude', sanitize_textarea_field($_POST['wseo_prefetch_exclude']));
            update_option('wseo_prefetch_max_concurrent', intval($_POST['wseo_prefetch_max_concurrent']));
            update_option('wseo_prefetch_max_pages', intval($_POST['wseo_prefetch_max_pages']));
            
            update_option('wseo_auto_detect_external_domains', isset($_POST['wseo_auto_detect_external_domains']) ? '1' : '0');
            update_option('wseo_preconnect_google_fonts', isset($_POST['wseo_preconnect_google_fonts']) ? '1' : '0');
            update_option('wseo_cdn_url', esc_url_raw($_POST['wseo_cdn_url']));
            update_option('wseo_custom_dns_prefetch', sanitize_textarea_field($_POST['wseo_custom_dns_prefetch']));
            update_option('wseo_custom_preconnect', sanitize_textarea_field($_POST['wseo_custom_preconnect']));
            
            update_option('wseo_preload_hero_images', isset($_POST['wseo_preload_hero_images']) ? '1' : '0');
            update_option('wseo_homepage_hero_image', esc_url_raw($_POST['wseo_homepage_hero_image']));
            
            update_option('wseo_adaptive_loading', isset($_POST['wseo_adaptive_loading']) ? '1' : '0');
            
            // Auto Performance Optimizer (v2.6.3) - no settings needed, everything is automatic
            
            // Breadcrumbs settings (breadcrumbs_enabled is always ON - hardcoded)
            update_option('wseo_breadcrumb_home', sanitize_text_field($_POST['wseo_breadcrumb_home'] ?: 'Domov'));
            
            // URL Permalinks settings
            $old_cat_base = get_option('wseo_remove_category_base', '1');
            $old_tag_base = get_option('wseo_remove_tag_base', '1');
            $new_cat_base = isset($_POST['wseo_remove_category_base']) ? '1' : '0';
            $new_tag_base = isset($_POST['wseo_remove_tag_base']) ? '1' : '0';
            
            update_option('wseo_remove_category_base', $new_cat_base);
            update_option('wseo_remove_tag_base', $new_tag_base);
            
            // v2.10.20: Remove product base setting
            if (class_exists('WooCommerce')) {
                $old_remove_product = get_option('wseo_remove_product_base', '0');
                $new_remove_product = isset($_POST['wseo_remove_product_base']) ? '1' : '0';
                
                $old_remove_product_cat = get_option('wseo_remove_product_cat_base', '0');
                $new_remove_product_cat = isset($_POST['wseo_remove_product_cat_base']) ? '1' : '0';
                
                if ($old_remove_product !== $new_remove_product || $old_remove_product_cat !== $new_remove_product_cat) {
                    update_option('wseo_remove_product_base', $new_remove_product);
                    update_option('wseo_remove_product_cat_base', $new_remove_product_cat);
                    flush_rewrite_rules();
                }
            }
            
            // Flush rewrite rules if settings changed
            if ($old_cat_base !== $new_cat_base || $old_tag_base !== $new_tag_base) {
                flush_rewrite_rules();
            }
            
            echo '<div class="notice notice-success"><p>Nastavenia boli uložené!</p></div>';
        }
        
        include WSEO_PLUGIN_DIR . 'templates/global.php';
    }
    
    public function render_files_page() {
        if (isset($_POST['wseo_save_files'])) {
            check_admin_referer('wseo_files_settings');
            
            // Robots.txt
            update_option('wseo_robots_custom_rules', sanitize_textarea_field($_POST['wseo_robots_custom_rules']));
            
            // Verification codes
            if (isset($_POST['wseo_verify_google'])) {
                update_option('wseo_verify_google', sanitize_text_field($_POST['wseo_verify_google']));
            }
            if (isset($_POST['wseo_verify_bing'])) {
                update_option('wseo_verify_bing', sanitize_text_field($_POST['wseo_verify_bing']));
            }
            if (isset($_POST['wseo_verify_yandex'])) {
                update_option('wseo_verify_yandex', sanitize_text_field($_POST['wseo_verify_yandex']));
            }
            if (isset($_POST['wseo_verify_pinterest'])) {
                update_option('wseo_verify_pinterest', sanitize_text_field($_POST['wseo_verify_pinterest']));
            }
            
            // Instant Indexing - v3.2: Now ON by default
            update_option('wseo_instant_index_enabled', isset($_POST['wseo_instant_index_enabled']) ? '1' : '0');
            update_option('wseo_instant_index_on_update', isset($_POST['wseo_instant_index_on_update']) ? '1' : '0');
            update_option('wseo_bing_indexnow_enabled', isset($_POST['wseo_bing_indexnow_enabled']) ? '1' : '0');
            update_option('wseo_yandex_indexnow_enabled', isset($_POST['wseo_yandex_indexnow_enabled']) ? '1' : '0');
            update_option('wseo_seznam_indexnow_enabled', isset($_POST['wseo_seznam_indexnow_enabled']) ? '1' : '0');
            update_option('wseo_naver_indexnow_enabled', isset($_POST['wseo_naver_indexnow_enabled']) ? '1' : '0');
            update_option('wseo_indexnow_api_enabled', isset($_POST['wseo_indexnow_api_enabled']) ? '1' : '0');
            update_option('wseo_yep_indexnow_enabled', isset($_POST['wseo_yep_indexnow_enabled']) ? '1' : '0');
            
            // Google Indexing API
            update_option('wseo_google_indexing_enabled', isset($_POST['wseo_google_indexing_enabled']) ? '1' : '0');
            if (isset($_POST['wseo_google_indexing_json'])) {
                update_option('wseo_google_indexing_json', sanitize_textarea_field($_POST['wseo_google_indexing_json']));
            }
            
            echo '<div class="notice notice-success"><p>Nastavenia boli uložené!</p></div>';
        }
        
        include WSEO_PLUGIN_DIR . 'templates/files.php';
    }
    
    public function render_redirects_page() {
        // Handle Auto-Redirect 404 setting (v2.8.6)
        if (isset($_POST['wseo_save_auto_redirect'])) {
            check_admin_referer('wseo_redirects_settings');
            
            $auto_redirect = sanitize_text_field($_POST['wseo_auto_redirect_404']);
            $synonyms = isset($_POST['wseo_404_synonyms']) ? sanitize_textarea_field($_POST['wseo_404_synonyms']) : '';
            
            update_option('wseo_auto_redirect_404', $auto_redirect);
            update_option('wseo_404_synonyms', $synonyms);
            
            $mode_names = array(
                'disabled' => 'Vypnuté',
                'aggressive' => 'Agresívne (5%+)',
                'moderate' => 'Moderate (10%+)',
                'conservative' => 'Konzervatívne (20%+)'
            );
            
            $synonyms_count = empty($synonyms) ? 0 : count(array_filter(explode("\n", $synonyms)));
            echo '<div class="notice notice-success"><p>✅ Auto-Redirect: <strong>' . $mode_names[$auto_redirect] . '</strong><br>Synonymá: <strong>' . $synonyms_count . ' riadkov</strong></p></div>';
        }
        
        // Handle form submissions
        if (isset($_POST['wseo_add_redirect'])) {
            check_admin_referer('wseo_redirects_settings');
            
            $redirects = get_option('wseo_redirects', array());
            
            $from_url = sanitize_text_field($_POST['wseo_redirect_from']);
            $to_url = esc_url_raw($_POST['wseo_redirect_to']);
            $type = sanitize_text_field($_POST['wseo_redirect_type']);
            
            if (!empty($from_url) && !empty($to_url)) {
                // Ensure from_url starts with /
                if (strpos($from_url, '/') !== 0) {
                    $from_url = '/' . $from_url;
                }
                
                $redirects[] = array(
                    'from' => $from_url,
                    'to' => $to_url,
                    'type' => $type,
                    'hits' => 0,
                    'created' => current_time('mysql')
                );
                
                update_option('wseo_redirects', $redirects, false);
                echo '<div class="notice notice-success"><p>Presmerovanie bolo pridané!</p></div>';
                
                // Clear from 404 logs if came from there
                if (isset($_POST['wseo_clear_404'])) {
                    $clear_url = sanitize_text_field($_POST['wseo_clear_404']);
                    $logs = get_option('wseo_404_logs', array());
                    $logs = array_filter($logs, function($log) use ($clear_url) {
                        return $log['url'] !== $clear_url;
                    });
                    update_option('wseo_404_logs', array_values($logs));
                }
            }
        }
        
        // Clear all 404 logs
        if (isset($_POST['wseo_clear_all_404'])) {
            check_admin_referer('wseo_redirects_settings');
            update_option('wseo_404_logs', array());
            echo '<div class="notice notice-success"><p>Všetky 404 logy boli vymazané!</p></div>';
        }
        
        // Submit sitemap
        if (isset($_POST['wseo_submit_sitemap'])) {
            check_admin_referer('wseo_redirects_settings');
            
            $sitemap_url = home_url('/sitemap.xml');
            
            // Ping Google
            $google_result = wp_remote_get('https://www.google.com/ping?sitemap=' . urlencode($sitemap_url), array(
                'timeout' => 10,
                'user-agent' => 'Webstudio SEO Pro/' . WSEO_VERSION
            ));
            
            // Ping Bing
            $bing_result = wp_remote_get('https://www.bing.com/ping?sitemap=' . urlencode($sitemap_url), array(
                'timeout' => 10,
                'user-agent' => 'Webstudio SEO Pro/' . WSEO_VERSION
            ));
            
            $google_ok = !is_wp_error($google_result) && wp_remote_retrieve_response_code($google_result) == 200;
            $bing_ok = !is_wp_error($bing_result) && wp_remote_retrieve_response_code($bing_result) == 200;
            
            update_option('wseo_last_sitemap_submission', array(
                'date' => current_time('mysql'),
                'results' => array(
                    'google' => $google_ok,
                    'bing' => $bing_ok,
                    'sitemap_url' => $sitemap_url
                )
            ));
            
            if ($google_ok && $bing_ok) {
                echo '<div class="notice notice-success"><p>✅ Sitemap bola úspešne odoslaná do Google a Bing!</p></div>';
            } else {
                echo '<div class="notice notice-warning"><p>⚠️ Sitemap odoslaná. Google: ' . ($google_ok ? '✅' : '❌') . ' | Bing: ' . ($bing_ok ? '✅' : '❌') . '</p></div>';
            }
        }
        
        if (isset($_POST['wseo_delete_redirect'])) {
            check_admin_referer('wseo_redirects_settings');
            
            $index = intval($_POST['wseo_delete_redirect']);
            $redirects = get_option('wseo_redirects', array());
            
            if (isset($redirects[$index])) {
                unset($redirects[$index]);
                $redirects = array_values($redirects); // Reindex
                update_option('wseo_redirects', $redirects, false);
                echo '<div class="notice notice-success"><p>Presmerovanie bolo zmazané!</p></div>';
            }
        }
        
        include WSEO_PLUGIN_DIR . 'templates/redirects.php';
    }
    
    /**
     * Track 404 errors
     * v2.9.4: Fixed - now properly checks is_404() FIRST, then verifies
     */
    public function track_404_errors() {
        // v2.9.4: CRITICAL FIX - WordPress is_404() must be TRUE first!
        // Without this, homepage and valid pages were being redirected
        if (!is_404()) {
            return; // Not a 404 page - exit immediately
        }
        
        $url = $_SERVER['REQUEST_URI'];
        
        // v2.8.12: Skip page builder preview URLs (Themify, Elementor, Divi, etc.)
        $builder_params = array(
            'tb-preview',       // Themify Builder
            'tb-id',            // Themify Builder
            'tb_preview',       // Themify Builder alt
            'themify_builder',  // Themify Builder
            'elementor-preview',// Elementor
            'elementor_library',// Elementor
            'et_fb',            // Divi Builder
            'fl_builder',       // Beaver Builder
            'brizy-edit',       // Brizy
            'bricks',           // Bricks Builder
            'ct_builder',       // Oxygen Builder
            'vc_editable',      // WPBakery
            'preview',          // Generic preview
            'customize_changeset_uuid', // Customizer
        );
        
        foreach ($builder_params as $param) {
            if (isset($_GET[$param]) || strpos($url, $param) !== false) {
                return; // Skip - this is a page builder preview
            }
        }
        
        // Also skip if in admin or doing AJAX
        if (is_admin() || wp_doing_ajax()) {
            return;
        }
        
        // v2.9.4: Skip homepage explicitly
        $path = parse_url($url, PHP_URL_PATH);
        $path = trim($path, '/');
        if (empty($path)) {
            return; // Homepage - never redirect
        }
        
        // Get slug for verification
        global $wpdb;
        $slug = basename($path);
        $slug = trim($slug, '/');
        
        // v2.9.4: Skip if slug is empty
        if (empty($slug)) {
            return;
        }
        
        // v2.9.4: Additional check - verify the URL really doesn't exist
        // This is a safety net for edge cases where is_404() might be wrong
        
        // Check 1: Posts, Pages, Products
        $exists_post = $wpdb->get_var($wpdb->prepare(
            "SELECT ID FROM {$wpdb->posts} 
            WHERE post_name = %s 
            AND post_status = 'publish' 
            AND post_type IN ('post', 'page', 'product')
            LIMIT 1",
            $slug
        ));
        
        // Check 2: Taxonomies (categories, tags, product_cat, product_tag, etc.)
        $exists_term = $wpdb->get_var($wpdb->prepare(
            "SELECT t.term_id FROM {$wpdb->terms} t
            INNER JOIN {$wpdb->term_taxonomy} tt ON t.term_id = tt.term_id
            WHERE t.slug = %s 
            AND tt.taxonomy IN ('category', 'post_tag', 'product_cat', 'product_tag')
            LIMIT 1",
            $slug
        ));
        
        // If content exists in DB, don't treat as 404 (safety check)
        if ($exists_post || $exists_term) {
            return; // Content exists - not a real 404
        }
        
        // Debug log
        error_log(sprintf(
            'WSEO 404 Confirmed: URL=%s | slug=%s',
            $url,
            $slug
        ));
        
        $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
        
        // Skip static files, XML, JSON, TXT, etc.
        if (preg_match('/\.(css|js|jpg|jpeg|png|gif|ico|svg|woff|woff2|ttf|eot|xml|json|txt|pdf|zip|gz|webp|avif)$/i', $url)) {
            return;
        }
        
        // Skip common API endpoints and system files
        $skip_patterns = array(
            '/sitemap',           // Any sitemap file
            '/\.well-known/',     // Well-known URIs (Apple, Google, etc.)
            '/wp-json/',          // WordPress REST API
            '/xmlrpc',            // WordPress XML-RPC
            '/wp-admin/',         // WordPress admin
            '/wp-includes/',      // WordPress core
            '/wp-content/',       // WordPress content (should not 404)
            '/feed',              // RSS feeds
            '/robots\.txt',       // Robots file
            '/ads\.txt',          // Ads.txt file
            '/app-ads\.txt',      // App-ads.txt
            '/favicon\.ico',      // Favicon
        );
        
        foreach ($skip_patterns as $pattern) {
            if (preg_match('#' . $pattern . '#i', $url)) {
                return;
            }
        }
        
        // Check ignored list
        $ignored = get_option('wseo_404_ignored', array());
        if (in_array($url, $ignored)) {
            return;
        }
        
        // Get existing 404 logs (SQL check už bol vykonaný vyššie)
        $logs = get_option('wseo_404_logs', array());
        
        // Find existing entry or create new
        $found = false;
        foreach ($logs as &$log) {
            if ($log['url'] === $url) {
                $log['count']++;
                $log['last_access'] = current_time('mysql');
                $log['referers'][] = $referer;
                $log['referers'] = array_unique(array_slice($log['referers'], -5)); // Keep last 5 referers
                $found = true;
                break;
            }
        }
        
        if (!$found) {
            $logs[] = array(
                'url' => $url,
                'count' => 1,
                'first_access' => current_time('mysql'),
                'last_access' => current_time('mysql'),
                'referers' => $referer ? array($referer) : array(),
                'user_agent' => substr($user_agent, 0, 200)
            );
        }
        
        // Keep only last 100 entries, sorted by count
        usort($logs, function($a, $b) {
            return $b['count'] - $a['count'];
        });
        $logs = array_slice($logs, 0, 100);
        
        update_option('wseo_404_logs', $logs);
        
        // =====================================================
        // AUTO-REDIRECT TO SIMILAR CONTENT (v2.8.6 ULTRA AGGRESSIVE)
        // =====================================================
        
        // Get auto-redirect setting
        $auto_redirect = get_option('wseo_auto_redirect_404', 'disabled');
        
        if ($auto_redirect !== 'disabled') {
            // Find similar content
            $suggestions = $this->suggest_redirects_for_404($url);
            
            if (!empty($suggestions)) {
                $best_match = $suggestions[0];
                $similarity = $best_match['similarity'];
                
                // v2.9.15: SAFE thresholds - minimum 50% to avoid wrong redirects
                $threshold = 50; // Aggressive: redirect na 50%+
                if ($auto_redirect === 'moderate') {
                    $threshold = 65; // Moderate: 65%+ similarity
                } elseif ($auto_redirect === 'conservative') {
                    $threshold = 80; // Conservative: 80%+ (very strict)
                }
                
                // Auto-redirect if similarity >= threshold
                if ($similarity >= $threshold) {
                    // Log redirect (always for debugging)
                    error_log(sprintf(
                        'WSEO Auto-Redirect: %s → %s (similarity=%d%%, threshold=%d%%)',
                        $url,
                        $best_match['url'],
                        $similarity,
                        $threshold
                    ));
                    
                    wp_redirect($best_match['url'], 301);
                    exit;
                }
                
                // Store suggestions for 404 template
                set_transient('wseo_404_suggestions_' . md5($url), $suggestions, 3600);
            }
        }
    }
    
    /**
     * AJAX: Get 404 logs
     */
    public function ajax_get_404_logs() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $logs = get_option('wseo_404_logs', array());
        wp_send_json_success($logs);
    }
    
    /**
     * AJAX: Create redirect from 404
     */
    public function ajax_create_redirect_from_404() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $from_url = sanitize_text_field($_POST['from_url']);
        $to_url = esc_url_raw($_POST['to_url']);
        $redirect_type = sanitize_text_field($_POST['redirect_type']) ?: '301';
        
        if (empty($from_url) || empty($to_url)) {
            wp_send_json_error('Missing URL');
        }
        
        // Add to redirects
        $redirects = get_option('wseo_redirects', array());
        $redirects[] = array(
            'from' => $from_url,
            'to' => $to_url,
            'type' => $redirect_type,
            'hits' => 0,
            'created' => current_time('mysql')
        );
        update_option('wseo_redirects', $redirects, false);
        
        // Remove from 404 logs
        $logs = get_option('wseo_404_logs', array());
        $logs = array_filter($logs, function($log) use ($from_url) {
            return $log['url'] !== $from_url;
        });
        update_option('wseo_404_logs', array_values($logs));
        
        wp_send_json_success('Redirect created');
    }
    
    /**
     * AJAX: Clear 404 logs
     */
    public function ajax_clear_404_logs() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        update_option('wseo_404_logs', array());
        wp_send_json_success('Logs cleared');
    }
    
    /**
     * AJAX: Ignore 404 URL
     */
    public function ajax_ignore_404() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $url = isset($_POST['url']) ? sanitize_text_field($_POST['url']) : '';
        
        if (empty($url)) {
            wp_send_json_error('No URL provided');
        }
        
        // Add to ignored list
        $ignored = get_option('wseo_404_ignored', array());
        if (!in_array($url, $ignored)) {
            $ignored[] = $url;
            update_option('wseo_404_ignored', $ignored);
        }
        
        // Remove from logs
        $logs = get_option('wseo_404_logs', array());
        $logs = array_filter($logs, function($log) use ($url) {
            return $log['url'] !== $url;
        });
        update_option('wseo_404_logs', array_values($logs));
        
        wp_send_json_success('URL ignored and removed from logs');
    }
    
    /**
     * AJAX: Submit sitemap to Google Search Console
     */
    public function ajax_submit_sitemap_to_gsc() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $sitemap_url = home_url('/sitemap.xml');
        
        // Submit sitemap URL via IndexNow
        $bing_result = $this->ping_indexnow($sitemap_url, 'bing');
        $yandex_result = $this->ping_indexnow($sitemap_url, 'yandex');
        
        $results = array(
            'bing' => array(
                'success' => $bing_result['success'],
                'message' => $bing_result['success'] ? 'OK' : ($bing_result['error'] ?? 'HTTP ' . $bing_result['code'])
            ),
            'yandex' => array(
                'success' => $yandex_result['success'],
                'message' => $yandex_result['success'] ? 'OK' : ($yandex_result['error'] ?? 'HTTP ' . $yandex_result['code'])
            )
        );
        
        // Save last submission time and results
        update_option('wseo_sitemap_last_submitted', current_time('d.m.Y H:i'));
        update_option('wseo_sitemap_submit_results', $results);
        
        // Build message
        if ($bing_result['success'] && $yandex_result['success']) {
            $message = 'Sitemap úspešne odoslaná do Bing a Yandex! ✅';
        } elseif ($bing_result['success']) {
            $message = 'Sitemap odoslaná do Bing ✅ (Yandex: ' . $results['yandex']['message'] . ')';
        } elseif ($yandex_result['success']) {
            $message = 'Sitemap odoslaná do Yandex ✅ (Bing: ' . $results['bing']['message'] . ')';
        } else {
            $message = 'Chyba pri odosielaní. Bing: ' . $results['bing']['message'] . ', Yandex: ' . $results['yandex']['message'];
        }
        
        wp_send_json_success(array(
            'message' => $message,
            'results' => $results
        ));
    }
    
    /**
     * Calculate keyword density for a post
     */
    public function calculate_keyword_density($post_id) {
        $post = get_post($post_id);
        if (!$post) {
            return array();
        }
        
        // Get content
        $content = $this->get_post_content($post_id);
        $content = mb_strtolower($content);
        
        // Get focus keywords
        $focus_keywords = get_post_meta($post_id, '_wseo_meta_keywords', true);
        $keywords = array_map('trim', explode(',', mb_strtolower($focus_keywords)));
        
        // Count total words
        $total_words = str_word_count($content);
        if ($total_words < 1) {
            return array();
        }
        
        $results = array();
        
        foreach ($keywords as $keyword) {
            if (empty($keyword)) continue;
            
            // Count keyword occurrences
            $count = substr_count($content, $keyword);
            
            // Calculate density
            $keyword_words = str_word_count($keyword);
            $density = ($count * $keyword_words / $total_words) * 100;
            
            // Determine status
            $status = 'good';
            if ($density < 0.5) {
                $status = 'low';
            } elseif ($density > 3) {
                $status = 'high';
            }
            
            $results[] = array(
                'keyword' => $keyword,
                'count' => $count,
                'density' => round($density, 2),
                'status' => $status,
                'recommendation' => $this->get_density_recommendation($density)
            );
        }
        
        return $results;
    }
    
    /**
     * Get keyword density recommendation
     */
    private function get_density_recommendation($density) {
        if ($density < 0.3) {
            return 'Príliš nízka hustota. Pridajte viac výskytov kľúčového slova.';
        } elseif ($density < 0.5) {
            return 'Nízka hustota. Zvážte pridanie niekoľkých výskytov.';
        } elseif ($density <= 2.5) {
            return 'Optimálna hustota kľúčového slova.';
        } elseif ($density <= 3) {
            return 'Mierne vysoká hustota. Zvážte zníženie.';
        } else {
            return 'Príliš vysoká hustota! Riziko penalizácie za keyword stuffing.';
        }
    }
    
    /**
     * Add Reading Time and Table of Contents to content
     */
    public function add_reading_time_and_toc($content) {
        if (!is_singular() || !in_the_loop() || !is_main_query()) {
            return $content;
        }
        
        global $post;
        if (!$post) {
            return $content;
        }
        
        $prepend = '';
        
        // Reading Time - check for '1' string value
        $show_reading_time = get_post_meta($post->ID, '_wseo_show_reading_time', true);
        
        // Default to '1' for posts if not set
        if ($show_reading_time === '' && $post->post_type === 'post') {
            $show_reading_time = '1';
        }
        
        if ($show_reading_time === '1') {
            $word_count = str_word_count(strip_tags($content));
            $reading_time = max(1, ceil($word_count / 200));
            $prepend .= '<div class="wseo-reading-time" style="background: #f6f7f7; padding: 10px 15px; margin-bottom: 20px; border-radius: 4px; font-size: 14px; color: #666;">
                <span style="margin-right: 5px;">⏱️</span> Čas čítania: <strong>' . $reading_time . ' min</strong> (' . number_format($word_count) . ' slov)
            </div>';
        }
        
        // Table of Contents - check for '1' string value
        $show_toc = get_post_meta($post->ID, '_wseo_show_toc', true);
        
        // Default to '1' for posts if not set
        if ($show_toc === '' && $post->post_type === 'post') {
            $show_toc = '1';
        }
        
        if ($show_toc === '1') {
            // Find all H2 and H3 headings
            preg_match_all('/<h([23])[^>]*>(.*?)<\/h[23]>/is', $content, $matches, PREG_SET_ORDER);
            
            if (count($matches) >= 2) {
                $toc = '<div class="wseo-toc" style="background: #f9f9f9; border: 1px solid #e2e4e7; padding: 20px; margin-bottom: 25px; border-radius: 4px;">
                    <strong style="display: block; margin-bottom: 10px; font-size: 16px;">📑 Obsah článku</strong>
                    <ul style="margin: 0; padding-left: 20px; list-style: none;">';
                
                $counter = 0;
                foreach ($matches as $match) {
                    $level = $match[1];
                    $title = strip_tags($match[2]);
                    $id = 'wseo-heading-' . $counter;
                    
                    // Add ID to the heading in content
                    $old_heading = $match[0];
                    $new_heading = preg_replace('/<h([23])/', '<h$1 id="' . $id . '"', $old_heading, 1);
                    $content = str_replace($old_heading, $new_heading, $content);
                    
                    $padding = $level == '3' ? 'padding-left: 15px;' : '';
                    $toc .= '<li style="margin: 5px 0; ' . $padding . '">
                        <a href="#' . $id . '" style="text-decoration: none; color: #2271b1;">' . 
                        ($level == '3' ? '↳ ' : '') . esc_html($title) . '</a>
                    </li>';
                    
                    $counter++;
                }
                
                $toc .= '</ul></div>';
                $prepend .= $toc;
            }
        }
        
        return $prepend . $content;
    }
    
    /**
     * Output FAQ Schema
     * 
     * Google 2026 UPDATE: Re-enabled with caution.
     * FAQ rich results work for all websites, but competition is high.
     * Use quality Q&A pairs for best results.
     */
    public function output_faq_schema($faqs) {
        if (empty($faqs) || !is_array($faqs)) {
            return;
        }
        
        $schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'FAQPage',
            'mainEntity' => array()
        );
        
        foreach ($faqs as $faq) {
            if (empty($faq['question']) || empty($faq['answer'])) continue;
            
            $schema['mainEntity'][] = array(
                '@type' => 'Question',
                'name' => $faq['question'],
                'acceptedAnswer' => array(
                    '@type' => 'Answer',
                    'text' => $faq['answer']
                )
            );
        }
        
        if (!empty($schema['mainEntity'])) {
            echo '<script type="application/ld+json">' . wp_json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . '</script>' . "\n";
        }
    }
    
    /**
     * v3.2: Auto-detect FAQ from content
     * Detects question patterns in H2, H3, H4 headings followed by paragraph answers
     * 
     * Patterns detected:
     * - Headings ending with ?
     * - Headings starting with: Čo, Ako, Prečo, Kedy, Kde, Kto, Koľko, What, How, Why, When, Where, Who
     * - Headings containing "otázka", "FAQ", "Q:"
     */
    public function auto_detect_faq_from_content($content) {
        if (empty($content)) {
            return array();
        }
        
        $faq_items = array();
        
        // Parse HTML
        $dom = new DOMDocument();
        libxml_use_internal_errors(true);
        $dom->loadHTML('<?xml encoding="UTF-8">' . $content, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        libxml_clear_errors();
        
        $xpath = new DOMXPath($dom);
        
        // Find all H2, H3, H4 headings
        $headings = $xpath->query('//h2 | //h3 | //h4');
        
        // Question patterns (Slovak + English)
        $question_starters = array(
            'čo ', 'ako ', 'prečo ', 'kedy ', 'kde ', 'kto ', 'koľko ', 'ktorý ', 'ktorá ', 'ktoré ',
            'aký ', 'aká ', 'aké ', 'má ', 'je ', 'sú ', 'môže ', 'môžem ', 'môžete ', 'dá sa ',
            'what ', 'how ', 'why ', 'when ', 'where ', 'who ', 'which ', 'can ', 'is ', 'are ', 'do ', 'does ',
            'q:', 'otázka:', 'faq:'
        );
        
        foreach ($headings as $heading) {
            $question_text = trim($heading->textContent);
            
            // Skip empty or too short
            if (strlen($question_text) < 10) continue;
            
            // Check if it's a question
            $is_question = false;
            
            // Ends with question mark
            if (substr($question_text, -1) === '?') {
                $is_question = true;
            }
            
            // Starts with question word
            $lower_question = mb_strtolower($question_text);
            foreach ($question_starters as $starter) {
                if (strpos($lower_question, $starter) === 0) {
                    $is_question = true;
                    break;
                }
            }
            
            if (!$is_question) continue;
            
            // Find the answer - next sibling paragraphs until next heading
            $answer_parts = array();
            $sibling = $heading->nextSibling;
            $max_paragraphs = 5; // Limit answer length
            $para_count = 0;
            
            while ($sibling && $para_count < $max_paragraphs) {
                if ($sibling->nodeType === XML_ELEMENT_NODE) {
                    $tag = strtolower($sibling->nodeName);
                    
                    // Stop at next heading
                    if (in_array($tag, array('h1', 'h2', 'h3', 'h4', 'h5', 'h6'))) {
                        break;
                    }
                    
                    // Collect paragraph content
                    if (in_array($tag, array('p', 'div', 'ul', 'ol'))) {
                        $text = trim($sibling->textContent);
                        if (!empty($text)) {
                            $answer_parts[] = $text;
                            $para_count++;
                        }
                    }
                }
                $sibling = $sibling->nextSibling;
            }
            
            // Combine answer
            $answer_text = implode(' ', $answer_parts);
            
            // Skip if answer too short
            if (strlen($answer_text) < 20) continue;
            
            // Truncate if too long (500 chars max for schema)
            if (strlen($answer_text) > 500) {
                $answer_text = mb_substr($answer_text, 0, 497) . '...';
            }
            
            $faq_items[] = array(
                'question' => $question_text,
                'answer' => $answer_text
            );
            
            // Limit to 10 FAQs
            if (count($faq_items) >= 10) break;
        }
        
        return $faq_items;
    }
    
    /**
     * Output Recipe Schema
     */
    public function output_recipe_schema($recipe) {
        if (empty($recipe) || !isset($recipe['name'])) {
            return;
        }
        
        $schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'Recipe',
            'name' => $recipe['name']
        );
        
        $optional_fields = array(
            'description', 'image', 'author', 'prepTime', 'cookTime', 'totalTime',
            'recipeYield', 'recipeCategory', 'recipeCuisine', 'keywords'
        );
        
        foreach ($optional_fields as $field) {
            if (!empty($recipe[$field])) {
                $schema[$field] = $recipe[$field];
            }
        }
        
        if (!empty($recipe['ingredients'])) {
            $schema['recipeIngredient'] = $recipe['ingredients'];
        }
        
        if (!empty($recipe['instructions'])) {
            $schema['recipeInstructions'] = array();
            foreach ($recipe['instructions'] as $index => $instruction) {
                $schema['recipeInstructions'][] = array(
                    '@type' => 'HowToStep',
                    'position' => $index + 1,
                    'text' => $instruction
                );
            }
        }
        
        if (!empty($recipe['nutrition'])) {
            $schema['nutrition'] = array_merge(
                array('@type' => 'NutritionInformation'),
                $recipe['nutrition']
            );
        }
        
        echo '<script type="application/ld+json">' . wp_json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . '</script>' . "\n";
    }
    
    /**
     * Output Event Schema
     */
    public function output_event_schema($event) {
        if (empty($event) || !isset($event['name']) || !isset($event['startDate'])) {
            return;
        }
        
        $schema = array(
            '@context' => WSEO_SCHEMA_CONTEXT,
            '@type' => 'Event',
            'name' => $event['name'],
            'startDate' => $event['startDate']
        );
        
        if (!empty($event['endDate'])) {
            $schema['endDate'] = $event['endDate'];
        }
        
        if (!empty($event['description'])) {
            $schema['description'] = $event['description'];
        }
        
        if (!empty($event['image'])) {
            $schema['image'] = $event['image'];
        }
        
        if (!empty($event['location'])) {
            if (is_string($event['location'])) {
                $schema['location'] = array(
                    '@type' => 'Place',
                    'name' => $event['location']
                );
            } else {
                $schema['location'] = array_merge(
                    array('@type' => 'Place'),
                    $event['location']
                );
            }
        }
        
        if (!empty($event['performer'])) {
            $schema['performer'] = array(
                '@type' => 'Person',
                'name' => $event['performer']
            );
        }
        
        if (!empty($event['organizer'])) {
            $schema['organizer'] = array(
                '@type' => 'Organization',
                'name' => $event['organizer']
            );
        }
        
        if (!empty($event['offers'])) {
            $schema['offers'] = array_merge(
                array('@type' => 'Offer'),
                $event['offers']
            );
        }
        
        if (!empty($event['eventStatus'])) {
            $schema['eventStatus'] = 'https://schema.org/' . $event['eventStatus'];
        }
        
        if (!empty($event['eventAttendanceMode'])) {
            $schema['eventAttendanceMode'] = 'https://schema.org/' . $event['eventAttendanceMode'];
        }
        
        echo '<script type="application/ld+json">' . wp_json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . '</script>' . "\n";
    }
    
    /**
     * Suggest redirects for 404 URLs
     */
    /**
     * Suggest redirects for 404 URLs
     * Uses advanced SQL scoring algorithm (inspired by wp-404-auto-redirect-similar-post)
     */
    public function suggest_redirects_for_404($url) {
        global $wpdb;
        
        try {
            // URL decode first (v2.8.6) - fix for %C3%A1 → á
            $url = urldecode($url);
            
            // Extract path
            $path = parse_url($url, PHP_URL_PATH);
            if (!$path) return array();
            
            $slug = basename($path);
            $slug = trim($slug, '/');
            
            // Remove extensions
            $slug = preg_replace('/\.(html|htm|php)$/i', '', $slug);
            
            // Extract keywords (split by dash)
            $keywords = explode('-', $slug);
            
            // GET SYNONYMS FROM DATABASE (v2.8.6 - Configurable!)
            $synonyms_raw = get_option('wseo_404_synonyms', '');
            
            // Parse synonyms from admin input
            // Format: webstranky = webstránky, stranky, web
            //         tvorba = vytváranie, vytvorenie
            $synonyms = array();
            if (!empty($synonyms_raw)) {
                $lines = explode("\n", $synonyms_raw);
                foreach ($lines as $line) {
                    $line = trim($line);
                    if (empty($line) || strpos($line, '=') === false) continue;
                    
                    list($base, $variants_str) = explode('=', $line, 2);
                    $base = trim(mb_strtolower($base));
                    
                    $variants = array_map('trim', explode(',', $variants_str));
                    $variants = array_map('mb_strtolower', $variants);
                    $variants[] = $base; // Include base word
                    
                    $synonyms[$base] = array_unique($variants);
                }
            }
            
            // Normalize keywords with synonyms + FUZZY MATCHING (v2.8.8)
            $expanded_keywords = array();
            foreach ($keywords as $word) {
                $word = mb_strtolower($word);
                
                // Add original word
                $expanded_keywords[] = $word;
                
                // Exact match in synonyms
                $found_exact = false;
                foreach ($synonyms as $base => $variants) {
                    if (in_array($word, $variants)) {
                        $expanded_keywords = array_merge($expanded_keywords, $variants);
                        $found_exact = true;
                        break;
                    }
                }
                
                // FUZZY MATCHING: If no exact match, try Levenshtein distance (v2.8.8)
                if (!$found_exact && strlen($word) >= 5) {
                    foreach ($synonyms as $base => $variants) {
                        foreach ($variants as $variant) {
                            // Calculate similarity (max 2 character difference)
                            $distance = levenshtein($word, $variant);
                            if ($distance > 0 && $distance <= 2) {
                                // Similar word found! Add all synonyms
                                $expanded_keywords = array_merge($expanded_keywords, $variants);
                                if (defined('WP_DEBUG') && WP_DEBUG) {
                                    error_log(sprintf(
                                        'WSEO Fuzzy Match: "%s" → "%s" (distance=%d)',
                                        $word,
                                        $variant,
                                        $distance
                                    ));
                                }
                                break 2; // Exit both loops
                            }
                        }
                    }
                }
            }
            
            // Remove duplicates and filter
            $keywords = array_unique($expanded_keywords);
            $keywords = array_filter($keywords, function($word) {
                return strlen($word) >= 3 && !is_numeric($word);
            });
            
            if (empty($keywords)) {
                if (defined('WP_DEBUG') && WP_DEBUG) {
                    error_log('WSEO suggest_redirects: No keywords extracted from: ' . $slug);
                }
                return array();
            }
            
            // Debug: Log keywords
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('WSEO suggest_redirects: Keywords = ' . implode(', ', $keywords));
            }
            
            // Build SQL with keyword scoring
            $sql = "SELECT p.ID, p.post_title, p.post_name, p.post_type, ";
            
            foreach ($keywords as $k) {
                $k = esc_sql(strtolower($k));
                $strlen = strlen($k);
                
                if ($strlen > 1) {
                    // Score 2: At beginning
                    $sql .= "IF(LEFT(LCASE(p.post_name), " . ($strlen + 1) . ") = '" . $k . "-', 2, 0) + ";
                    
                    // Score 2: At end
                    $sql .= "IF(RIGHT(LCASE(p.post_name), " . ($strlen + 1) . ") = '-" . $k . "', 2, 0) + ";
                    
                    // Score 2: In middle
                    $sql .= "IF(INSTR(LCASE(p.post_name), '-" . $k . "-'), 2, 0) + ";
                    
                    // Score 2: Exact match
                    $sql .= "IF(LCASE(p.post_name) = '" . $k . "', 2, 0) + ";
                }
                
                // Score 1: Anywhere (wildcard)
                $sql .= "IF(INSTR(LCASE(p.post_name), '" . $k . "'), 1, 0) + ";
            }
            
            $sql .= "0 AS score 
                    FROM {$wpdb->posts} AS p
                    WHERE p.post_status = 'publish'
                    AND p.post_type IN ('post', 'page', 'product')
                    ORDER BY score DESC, p.post_modified DESC
                    LIMIT 5";
            
            // Execute query
            $results = $wpdb->get_results($sql);
            
            // Debug: Log SQL results
            if (defined('WP_DEBUG') && WP_DEBUG) {
                error_log('WSEO suggest_redirects: SQL returned ' . count($results) . ' results');
                if (!empty($results)) {
                    foreach ($results as $r) {
                        error_log(sprintf(
                            'WSEO suggest_redirects: ID=%d | Title=%s | Slug=%s | Score=%d',
                            $r->ID,
                            $r->post_title,
                            $r->post_name,
                            $r->score
                        ));
                    }
                }
            }
            
            if (empty($results)) return array();
            
            // Format results - include ALL matches with score > 0
            $suggestions = array();
            foreach ($results as $result) {
                // Skip if score = 0 (no match at all)
                if ($result->score == 0) {
                    continue;
                }
                
                // Calculate percentage (score * 10, max 100)
                $percent = min(100, round($result->score * 10, 1));
                
                $suggestions[] = array(
                    'url' => get_permalink($result->ID),
                    'title' => $result->post_title,
                    'type' => $result->post_type,
                    'similarity' => $percent
                );
            }
            
            return $suggestions;
            
        } catch (Exception $e) {
            return array();
        }
    }
    
    /**
     * =====================================================
     * INTERNAL LINKING SYSTEM
     * =====================================================
     */
    
    /**
     * Render Internal Links page
     */
    public function render_internal_links_page() {
        // Handle scan request
        if (isset($_POST['wseo_scan_links']) && check_admin_referer('wseo_internal_links')) {
            $this->scan_all_internal_links();
            echo '<div class="notice notice-success"><p>✅ Skenovanie interných odkazov dokončené!</p></div>';
        }
        
        include WSEO_PLUGIN_DIR . 'templates/internal-links.php';
    }
    
    /**
     * Render Images page (v2.8.10)
     * All image-related functions: optimization, ALT text, AVIF, WebP
     */
    public function render_images_page() {
        include WSEO_PLUGIN_DIR . 'templates/images.php';
    }
    
    /**
     * Render maintenance page
     */
    public function render_maintenance_page() {
        include WSEO_PLUGIN_DIR . 'templates/maintenance.php';
    }
    
    /**
     * Render Performance Monitor page
     */
    public function render_performance_page() {
        include WSEO_PLUGIN_DIR . 'templates/performance.php';
    }
    
    /**
     * Render Marketing page
     * v2.10.0: Push notifications, Newsletter, CTA popups, WooCommerce tools
     */
    public function render_marketing_page() {
        // Handle VAPID regeneration
        if (isset($_GET['regenerate_vapid']) && current_user_can('manage_options')) {
            if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'wseo_regenerate_vapid')) {
                delete_option('wseo_push_vapid_public');
                delete_option('wseo_push_vapid_private');
                delete_option('wseo_push_subscribers');
                add_settings_error('wseo_marketing', 'vapid_regenerated', 'VAPID kľúče boli úspešne regenerované!', 'success');
            }
        }
        include WSEO_PLUGIN_DIR . 'templates/marketing.php';
    }
    
    /**
     * Render License page
     */
    public function render_license_page() {
        include WSEO_PLUGIN_DIR . 'templates/license.php';
    }
    
    /**
     * Scan all internal links and build link map
     */
    public function scan_all_internal_links() {
        $link_map = array();
        $anchor_map = array();
        
        // Get all published content
        $posts = get_posts(array(
            'post_type' => array('post', 'page', 'product'),
            'posts_per_page' => -1,
            'post_status' => 'publish'
        ));
        
        $site_url = home_url();
        $site_host = parse_url($site_url, PHP_URL_HOST);
        
        foreach ($posts as $post) {
            $post_url = get_permalink($post->ID);
            $content = $post->post_content;
            
            // Also check page builder content
            $content .= $this->get_post_content($post->ID);
            
            // Find all links in content
            preg_match_all('/<a[^>]+href=["\']([^"\']+)["\'][^>]*>(.*?)<\/a>/is', $content, $matches, PREG_SET_ORDER);
            
            foreach ($matches as $match) {
                $link_url = $match[1];
                $anchor_text = strip_tags($match[2]);
                
                // Check if internal link
                if ($this->is_internal_link($link_url, $site_host, $site_url)) {
                    // Normalize URL
                    $normalized_url = $this->normalize_url($link_url, $site_url);
                    
                    // Add to link map (which posts link to this URL)
                    if (!isset($link_map[$normalized_url])) {
                        $link_map[$normalized_url] = array(
                            'incoming' => array(),
                            'count' => 0
                        );
                    }
                    
                    $link_map[$normalized_url]['incoming'][] = array(
                        'from_id' => $post->ID,
                        'from_title' => $post->post_title,
                        'from_url' => $post_url,
                        'anchor' => $anchor_text
                    );
                    $link_map[$normalized_url]['count']++;
                    
                    // Add to anchor map
                    if (!isset($anchor_map[$normalized_url])) {
                        $anchor_map[$normalized_url] = array();
                    }
                    $anchor_clean = mb_strtolower(trim($anchor_text));
                    if (!empty($anchor_clean)) {
                        if (!isset($anchor_map[$normalized_url][$anchor_clean])) {
                            $anchor_map[$normalized_url][$anchor_clean] = 0;
                        }
                        $anchor_map[$normalized_url][$anchor_clean]++;
                    }
                }
            }
            
            // Store outgoing links count for this post
            update_post_meta($post->ID, '_wseo_outgoing_links', count($matches));
        }
        
        // Save link map
        update_option('wseo_link_map', $link_map, false);
        update_option('wseo_anchor_map', $anchor_map, false);
        update_option('wseo_link_scan_date', current_time('mysql'));
        
        // Find and save orphan pages
        $this->detect_orphan_pages($link_map);
        
        return $link_map;
    }
    
    /**
     * Check if URL is internal
     */
    private function is_internal_link($url, $site_host, $site_url) {
        // Relative URLs are internal
        if (strpos($url, '/') === 0 && strpos($url, '//') !== 0) {
            return true;
        }
        
        // Check if same host
        $link_host = parse_url($url, PHP_URL_HOST);
        if ($link_host === $site_host) {
            return true;
        }
        
        // Check if starts with site URL
        if (strpos($url, $site_url) === 0) {
            return true;
        }
        
        return false;
    }
    
    /**
     * Normalize URL for comparison
     */
    private function normalize_url($url, $site_url) {
        // Convert relative to absolute
        if (strpos($url, '/') === 0 && strpos($url, '//') !== 0) {
            $url = rtrim($site_url, '/') . $url;
        }
        
        // Remove trailing slash for consistency
        $url = rtrim($url, '/');
        
        // Remove query strings and anchors
        $url = preg_replace('/[?#].*$/', '', $url);
        
        return $url;
    }
    
    /**
     * Detect orphan pages (pages with no incoming internal links)
     */
    private function detect_orphan_pages($link_map = null) {
        if ($link_map === null) {
            $link_map = get_option('wseo_link_map', array());
        }
        
        $orphans = array();
        $site_url = home_url();
        
        // Get all published pages/posts
        $posts = get_posts(array(
            'post_type' => array('post', 'page', 'product'),
            'posts_per_page' => -1,
            'post_status' => 'publish'
        ));
        
        // Homepage is never orphan
        $front_page_id = get_option('page_on_front');
        $blog_page_id = get_option('page_for_posts');
        
        foreach ($posts as $post) {
            // Skip homepage and blog page
            if ($post->ID == $front_page_id || $post->ID == $blog_page_id) {
                continue;
            }
            
            $post_url = $this->normalize_url(get_permalink($post->ID), $site_url);
            
            // Check if this URL has incoming links
            $has_incoming = false;
            if (isset($link_map[$post_url]) && $link_map[$post_url]['count'] > 0) {
                $has_incoming = true;
            }
            
            // Also check with trailing slash
            $post_url_slash = $post_url . '/';
            if (isset($link_map[$post_url_slash]) && $link_map[$post_url_slash]['count'] > 0) {
                $has_incoming = true;
            }
            
            if (!$has_incoming) {
                $orphans[] = array(
                    'id' => $post->ID,
                    'title' => $post->post_title,
                    'url' => get_permalink($post->ID),
                    'type' => $post->post_type,
                    'date' => $post->post_date
                );
            }
        }
        
        update_option('wseo_orphan_pages', $orphans);
        
        return $orphans;
    }
    
    /**
     * Get link suggestions for a post based on content
     */
    public function get_link_suggestions($post_id) {
        $post = get_post($post_id);
        if (!$post) {
            return array();
        }
        
        $suggestions = array();
        $content = mb_strtolower($this->get_post_content($post_id));
        $post_url = get_permalink($post_id);
        
        // Get all other published posts
        $other_posts = get_posts(array(
            'post_type' => array('post', 'page', 'product'),
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'exclude' => array($post_id)
        ));
        
        foreach ($other_posts as $other) {
            $other_url = get_permalink($other->ID);
            
            // Skip if already linked
            if (stripos($post->post_content, $other_url) !== false) {
                continue;
            }
            
            // Check if post title appears in content
            $other_title_lower = mb_strtolower($other->post_title);
            
            // Also get keywords/focus keyword
            $other_keywords = mb_strtolower(get_post_meta($other->ID, '_wseo_meta_keywords', true));
            $keywords_array = array_filter(array_map('trim', explode(',', $other_keywords)));
            
            // Check title match
            if (mb_strpos($content, $other_title_lower) !== false) {
                $suggestions[] = array(
                    'target_id' => $other->ID,
                    'target_title' => $other->post_title,
                    'target_url' => $other_url,
                    'target_type' => $other->post_type,
                    'match_type' => 'title',
                    'match_text' => $other->post_title,
                    'relevance' => 95
                );
                continue;
            }
            
            // Check keywords match
            foreach ($keywords_array as $keyword) {
                if (strlen($keyword) > 3 && mb_strpos($content, $keyword) !== false) {
                    $suggestions[] = array(
                        'target_id' => $other->ID,
                        'target_title' => $other->post_title,
                        'target_url' => $other_url,
                        'target_type' => $other->post_type,
                        'match_type' => 'keyword',
                        'match_text' => $keyword,
                        'relevance' => 80
                    );
                    break;
                }
            }
        }
        
        // Sort by relevance
        usort($suggestions, function($a, $b) {
            return $b['relevance'] - $a['relevance'];
        });
        
        return array_slice($suggestions, 0, 10);
    }
    
    /**
     * Get anchor text analysis for a URL
     */
    public function get_anchor_analysis($post_id = null) {
        $anchor_map = get_option('wseo_anchor_map', array());
        $link_map = get_option('wseo_link_map', array());
        
        if ($post_id) {
            $post_url = $this->normalize_url(get_permalink($post_id), home_url());
            
            $anchors = isset($anchor_map[$post_url]) ? $anchor_map[$post_url] : array();
            $incoming = isset($link_map[$post_url]) ? $link_map[$post_url]['incoming'] : array();
            
            // Analyze anchor diversity
            $total_anchors = array_sum($anchors);
            $analysis = array(
                'url' => $post_url,
                'total_links' => $total_anchors,
                'unique_anchors' => count($anchors),
                'anchors' => array(),
                'issues' => array()
            );
            
            foreach ($anchors as $text => $count) {
                $percentage = $total_anchors > 0 ? round(($count / $total_anchors) * 100, 1) : 0;
                $status = 'good';
                
                // Check for issues
                if ($percentage > 40) {
                    $status = 'warning';
                    $analysis['issues'][] = "Anchor \"{$text}\" je použitý príliš často ({$percentage}%)";
                }
                
                if (in_array(mb_strtolower($text), array('tu', 'sem', 'klikni', 'klikni sem', 'click here', 'here', 'link', 'viac', 'čítaj viac', 'read more'))) {
                    $status = 'bad';
                    $analysis['issues'][] = "Anchor \"{$text}\" nie je popisný";
                }
                
                $analysis['anchors'][] = array(
                    'text' => $text,
                    'count' => $count,
                    'percentage' => $percentage,
                    'status' => $status
                );
            }
            
            // Sort by count
            usort($analysis['anchors'], function($a, $b) {
                return $b['count'] - $a['count'];
            });
            
            return $analysis;
        }
        
        // Return full anchor map analysis
        return $anchor_map;
    }
    
    /**
     * Update link map when post is saved
     */
    public function update_link_map_on_save($post_id, $post) {
        // Skip autosaves and revisions
        if (wp_is_post_autosave($post_id) || wp_is_post_revision($post_id)) {
            return;
        }
        
        // Only for published content
        if ($post->post_status !== 'publish') {
            return;
        }
        
        // Only for supported post types
        if (!in_array($post->post_type, array('post', 'page', 'product'))) {
            return;
        }
        
        // Schedule a full rescan (debounced)
        if (!wp_next_scheduled('wseo_rescan_links')) {
            wp_schedule_single_event(time() + 60, 'wseo_rescan_links');
        }
    }
    
    /**
     * AJAX: Get link suggestions
     */
    public function ajax_get_link_suggestions() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('edit_posts')) {
            wp_die('Unauthorized');
        }
        
        $post_id = intval($_POST['post_id']);
        $suggestions = $this->get_link_suggestions($post_id);
        
        wp_send_json_success($suggestions);
    }
    
    /**
     * AJAX: Scan internal links
     */
    public function ajax_scan_internal_links() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $link_map = $this->scan_all_internal_links();
        
        wp_send_json_success(array(
            'message' => 'Skenovanie dokončené',
            'total_links' => count($link_map),
            'scan_date' => current_time('mysql')
        ));
    }
    
    /**
     * AJAX: Get orphan pages
     */
    public function ajax_get_orphan_pages() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $orphans = get_option('wseo_orphan_pages', array());
        
        wp_send_json_success($orphans);
    }
    
    /**
     * AJAX: Get anchor analysis
     */
    public function ajax_get_anchor_analysis() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : null;
        $analysis = $this->get_anchor_analysis($post_id);
        
        wp_send_json_success($analysis);
    }
    
    /**
     * Get internal linking stats for dashboard
     */
    public function get_internal_link_stats() {
        $link_map = get_option('wseo_link_map', array());
        $orphans = get_option('wseo_orphan_pages', array());
        $scan_date = get_option('wseo_link_scan_date', '');
        
        $total_internal_links = 0;
        $pages_with_links = 0;
        
        foreach ($link_map as $url => $data) {
            $total_internal_links += $data['count'];
            if ($data['count'] > 0) {
                $pages_with_links++;
            }
        }
        
        return array(
            'total_links' => $total_internal_links,
            'pages_with_incoming' => $pages_with_links,
            'orphan_count' => count($orphans),
            'last_scan' => $scan_date
        );
    }
    
    /**
     * =====================================================
     * BROKEN LINKS CHECKER
     * =====================================================
     */
    
    /**
     * AJAX: Scan for broken links
     */
    public function ajax_scan_broken_links() {
        // v3.2: Suppress any PHP warnings/notices that could break JSON response
        @ob_start();
        error_reporting(E_ERROR | E_PARSE);
        
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            @ob_end_clean();
            wp_die('Unauthorized');
        }
        
        $broken_links = $this->scan_all_links_for_broken();
        
        update_option('wseo_broken_links', $broken_links, false);
        update_option('wseo_broken_links_scan_date', current_time('mysql'));
        
        // Clear any output that might have been generated
        @ob_end_clean();
        
        wp_send_json_success(array(
            'broken_count' => count($broken_links),
            'links' => $broken_links,
            'scan_date' => current_time('mysql')
        ));
    }
    
    /**
     * AJAX: Check single link
     */
    public function ajax_check_single_link() {
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        $url = isset($_POST['url']) ? esc_url_raw($_POST['url']) : '';
        if (empty($url)) {
            wp_send_json_error('No URL provided');
        }
        
        $result = $this->check_link_status($url);
        wp_send_json_success($result);
    }
    
    /**
     * Scan all content for broken links
     */
    public function scan_all_links_for_broken() {
        $broken_links = array();
        
        // Get all published posts
        $posts = get_posts(array(
            'post_type' => array('post', 'page', 'product'),
            'posts_per_page' => -1,
            'post_status' => 'publish'
        ));
        
        foreach ($posts as $post) {
            $content = $post->post_content;
            $content .= $this->get_post_content($post->ID);
            
            // Find all links
            preg_match_all('/<a[^>]+href=["\']([^"\']+)["\'][^>]*>/i', $content, $matches);
            
            if (!empty($matches[1])) {
                foreach ($matches[1] as $url) {
                    // Skip anchors, mailto, tel, javascript
                    if (strpos($url, '#') === 0 || 
                        strpos($url, 'mailto:') === 0 || 
                        strpos($url, 'tel:') === 0 ||
                        strpos($url, 'javascript:') === 0) {
                        continue;
                    }
                    
                    // Convert relative URLs to absolute
                    if (strpos($url, '/') === 0 && strpos($url, '//') !== 0) {
                        $url = home_url($url);
                    }
                    
                    // Check link status
                    $status = $this->check_link_status($url);
                    
                    if ($status['is_broken']) {
                        $broken_links[] = array(
                            'url' => $url,
                            'status_code' => $status['status_code'],
                            'error' => $status['error'],
                            'found_in' => array(
                                'post_id' => $post->ID,
                                'post_title' => $post->post_title,
                                'post_url' => get_permalink($post->ID),
                                'post_type' => $post->post_type
                            )
                        );
                    }
                }
            }
        }
        
        return $broken_links;
    }
    
    /**
     * Check if a single link is broken
     */
    public function check_link_status($url) {
        $result = array(
            'url' => $url,
            'is_broken' => false,
            'status_code' => 0,
            'error' => ''
        );
        
        // Use WordPress HTTP API
        $response = wp_remote_head($url, array(
            'timeout' => 10,
            'redirection' => 5,
            'sslverify' => false,
            'user-agent' => 'Mozilla/5.0 (compatible; WSEOBot/1.0; +' . home_url('/') . ')'
        ));
        
        if (is_wp_error($response)) {
            $result['is_broken'] = true;
            $result['error'] = $response->get_error_message();
            return $result;
        }
        
        $status_code = wp_remote_retrieve_response_code($response);
        $result['status_code'] = $status_code;
        
        // Consider these as broken
        if ($status_code >= 400 || $status_code === 0) {
            $result['is_broken'] = true;
            $result['error'] = $this->get_status_code_message($status_code);
        }
        
        return $result;
    }
    
    /**
     * Get human-readable status code message
     */
    private function get_status_code_message($code) {
        $messages = array(
            0 => 'Nedostupné (timeout alebo DNS chyba)',
            400 => 'Bad Request',
            401 => 'Unauthorized',
            403 => 'Forbidden (prístup zakázaný)',
            404 => 'Not Found (stránka neexistuje)',
            405 => 'Method Not Allowed',
            408 => 'Request Timeout',
            410 => 'Gone (stránka bola odstránená)',
            429 => 'Too Many Requests',
            500 => 'Internal Server Error',
            502 => 'Bad Gateway',
            503 => 'Service Unavailable',
            504 => 'Gateway Timeout'
        );
        
        return isset($messages[$code]) ? $messages[$code] : 'HTTP Error ' . $code;
    }
    
    /**
     * Get broken links stats for dashboard
     */
    public function get_broken_links_stats() {
        $broken_links = get_option('wseo_broken_links', array());
        $scan_date = get_option('wseo_broken_links_scan_date', '');
        
        return array(
            'broken_count' => count($broken_links),
            'links' => $broken_links,
            'last_scan' => $scan_date
        );
    }
    
    /**
     * AJAX: Remove all broken links (v2.3.6)
     * ⚠️ Works ONLY for blog posts (post type 'post')
     */
    public function ajax_remove_all_broken_links() {
        // v3.2: Suppress any PHP warnings/notices that could break JSON response
        @ob_start();
        error_reporting(E_ERROR | E_PARSE);
        
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            @ob_end_clean();
            wp_die('Unauthorized');
        }
        
        $broken_links = get_option('wseo_broken_links', array());
        
        if (empty($broken_links)) {
            @ob_end_clean();
            wp_send_json_error(array('message' => 'Žiadne nefunkčné odkazy na odstránenie.'));
            return;
        }
        
        // Group broken links by post
        $posts_with_broken_links = array();
        foreach ($broken_links as $link_data) {
            // v3.2: Handle both old and new data structures
            // New structure has post_id inside 'found_in', old might have it directly
            if (isset($link_data['found_in']['post_id'])) {
                $post_id = $link_data['found_in']['post_id'];
            } elseif (isset($link_data['post_id'])) {
                $post_id = $link_data['post_id'];
            } else {
                continue; // Skip if no post_id found
            }
            
            if (!isset($posts_with_broken_links[$post_id])) {
                $posts_with_broken_links[$post_id] = array();
            }
            $posts_with_broken_links[$post_id][] = $link_data['url'];
        }
        
        $removed_count = 0;
        $posts_updated = 0;
        
        foreach ($posts_with_broken_links as $post_id => $urls) {
            $post = get_post($post_id);
            
            // v3.2: Process all public post types, not just 'post'
            if (!$post) {
                continue;
            }
            
            // Skip revisions and autosaves
            if ($post->post_type === 'revision' || $post->post_status === 'auto-draft') {
                continue;
            }
            
            $content = $post->post_content;
            $original_content = $content;
            
            // Remove each broken link (replace <a>...</a> with just the text)
            foreach ($urls as $url) {
                // v3.2: More robust pattern - handles various URL formats and encodings
                $escaped_url = preg_quote($url, '/');
                // Also try with HTML entities
                $escaped_url_entities = preg_quote(htmlspecialchars($url), '/');
                
                // Pattern 1: Exact URL match
                $pattern1 = '/<a\s[^>]*href\s*=\s*["\']' . $escaped_url . '["\'][^>]*>(.*?)<\/a>/is';
                $content = preg_replace($pattern1, '$1', $content);
                
                // Pattern 2: URL with HTML entities
                if ($escaped_url !== $escaped_url_entities) {
                    $pattern2 = '/<a\s[^>]*href\s*=\s*["\']' . $escaped_url_entities . '["\'][^>]*>(.*?)<\/a>/is';
                    $content = preg_replace($pattern2, '$1', $content);
                }
                
                // Pattern 3: URL without protocol (relative match)
                $url_without_protocol = preg_replace('/^https?:\/\//', '', $url);
                if ($url_without_protocol !== $url) {
                    $escaped_no_protocol = preg_quote($url_without_protocol, '/');
                    $pattern3 = '/<a\s[^>]*href\s*=\s*["\'][^"\']*' . $escaped_no_protocol . '["\'][^>]*>(.*?)<\/a>/is';
                    $content = preg_replace($pattern3, '$1', $content);
                }
            }
            
            if ($content !== $original_content) {
                wp_update_post(array(
                    'ID' => $post_id,
                    'post_content' => $content
                ));
                $removed_count += count($urls);
                $posts_updated++;
            }
        }
        
        // Clear broken links
        update_option('wseo_broken_links', array());
        update_option('wseo_broken_links_scan_date', '');
        
        // Clear any output before JSON response
        @ob_end_clean();
        
        wp_send_json_success(array(
            'removed_count' => $removed_count,
            'posts_updated' => $posts_updated,
            'message' => "Odstránených $removed_count nefunkčných odkazov z $posts_updated príspevkov."
        ));
    }
    
    /**
     * AJAX: Optimize anchor text (v2.3.6)
     * ⚠️ Works ONLY for blog posts (post type 'post')
     */
    public function ajax_optimize_anchor() {
        // v3.2: Add output buffering
        @ob_start();
        error_reporting(E_ERROR | E_PARSE);
        
        check_ajax_referer('wseo_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            @ob_end_clean();
            wp_die('Unauthorized');
        }
        
        $anchor = isset($_POST['anchor']) ? sanitize_text_field($_POST['anchor']) : '';
        $url = isset($_POST['url']) ? esc_url_raw($_POST['url']) : '';
        $type = isset($_POST['type']) ? sanitize_text_field($_POST['type']) : 'warning';
        
        if (empty($anchor) || empty($url)) {
            @ob_end_clean();
            wp_send_json_error(array('message' => 'Chýbajúce parametre.'));
            return;
        }
        
        // v3.2: Normalize anchor to lowercase for lookup (anchor_map uses lowercase keys)
        $anchor_lookup = mb_strtolower(trim($anchor));
        
        // Get anchor map
        $anchor_map = get_option('wseo_anchor_map', array());
        
        if (empty($anchor_map[$url][$anchor_lookup])) {
            @ob_end_clean();
            wp_send_json_error(array('message' => 'Anchor text nebol nájdený v databáze. Skúste znova naskenovať interné odkazy.'));
            return;
        }
        
        // v3.2: Process ALL post types, not just 'post'
        $posts = get_posts(array(
            'post_type' => array('post', 'page', 'product'),
            'posts_per_page' => -1,
            'post_status' => 'publish'
        ));
        
        $removed_count = 0;
        $kept_count = 0;
        $posts_updated = 0;
        $max_to_keep = $type === 'bad' ? 0 : 2; // For bad anchors, remove all; for frequent, keep 2
        
        foreach ($posts as $post) {
            $content = $post->post_content;
            $original_content = $content;
            
            // v3.2: More flexible regex - find links to this URL with similar anchor text
            // Use case-insensitive matching for anchor text
            $escaped_url = preg_quote($url, '/');
            $escaped_anchor = preg_quote($anchor, '/');
            
            // Pattern: <a ... href="URL" ...>ANCHOR</a> (case insensitive for anchor)
            preg_match_all('/<a\s[^>]*href\s*=\s*["\']' . $escaped_url . '["\'][^>]*>(' . $escaped_anchor . ')<\/a>/iu', $content, $matches, PREG_OFFSET_CAPTURE | PREG_SET_ORDER);
            
            if (!empty($matches)) {
                // Process from end to start to preserve offsets
                $matches_reversed = array_reverse($matches);
                $found_count = 0;
                
                foreach ($matches_reversed as $match) {
                    $found_count++;
                    
                    if ($found_count <= $max_to_keep) {
                        // Keep this occurrence
                        $kept_count++;
                        continue;
                    }
                    
                    // Remove this occurrence - replace link with just the anchor text
                    $full_link = $match[0][0];
                    $anchor_text = $match[1][0]; // Captured anchor text
                    $offset = $match[0][1];
                    $content = substr_replace($content, $anchor_text, $offset, strlen($full_link));
                    $removed_count++;
                }
            }
            
            if ($content !== $original_content) {
                wp_update_post(array(
                    'ID' => $post->ID,
                    'post_content' => $content
                ));
                $posts_updated++;
            }
        }
        
        // Update anchor map (use lowercase key)
        if ($removed_count > 0) {
            if ($max_to_keep === 0) {
                // Remove completely
                unset($anchor_map[$url][$anchor_lookup]);
            } else {
                // Update count
                $anchor_map[$url][$anchor_lookup] = $kept_count;
            }
            update_option('wseo_anchor_map', $anchor_map, false);
        }
        
        // Clear output buffer before JSON response
        @ob_end_clean();
        
        $message = $type === 'bad' 
            ? "Vymazaných všetkých $removed_count výskytov nepopisného anchor textu."
            : "Optimalizované: ponechaných $kept_count, odstránených $removed_count prebytočných odkazov.";
        
        wp_send_json_success(array(
            'removed_count' => $removed_count,
            'kept_count' => $kept_count,
            'posts_updated' => $posts_updated,
            'message' => $message
        ));
    }
    
    /**
     * Plugin activation hook
     * Sets default ON for reading time & TOC on all existing blog posts
     */
    public static function activate_plugin() {
        global $wpdb;
        
        // v2.9.6: Initialize auto-fill image options (all ON by default)
        // This ensures new installs have these enabled without user action
        if (get_option('wseo_auto_alt') === false) {
            update_option('wseo_auto_alt', '1');
        }
        if (get_option('wseo_auto_title') === false) {
            update_option('wseo_auto_title', '1');
        }
        if (get_option('wseo_auto_caption') === false) {
            update_option('wseo_auto_caption', '1');
        }
        if (get_option('wseo_auto_description') === false) {
            update_option('wseo_auto_description', '1');
        }
        
        // Get all published blog posts (post type 'post')
        $posts = $wpdb->get_results("
            SELECT ID 
            FROM {$wpdb->posts} 
            WHERE post_type = 'post' 
            AND post_status = 'publish'
        ");
        
        $updated = 0;
        foreach ($posts as $post) {
            // Check if already set
            $reading_time = get_post_meta($post->ID, '_wseo_show_reading_time', true);
            $toc = get_post_meta($post->ID, '_wseo_show_toc', true);
            
            // Set to ON (1) if not already set
            if ($reading_time === '') {
                update_post_meta($post->ID, '_wseo_show_reading_time', '1');
                $updated++;
            }
            if ($toc === '') {
                update_post_meta($post->ID, '_wseo_show_toc', '1');
                $updated++;
            }
        }
        
        // Save activation flag
        update_option('wseo_activated', true);
        update_option('wseo_activation_date', current_time('mysql'));
        update_option('wseo_activation_posts_updated', $updated);
        
        // Schedule performance monitor check (hourly)
        if (!wp_next_scheduled('wseo_check_expired_disables')) {
            wp_schedule_event(time(), 'hourly', 'wseo_check_expired_disables');
        }
        
        // v2.9.9: Telemetry ping (demo installation tracking)
        self::send_telemetry_ping();
        
        // Schedule weekly telemetry ping
        if (!wp_next_scheduled('wseo_telemetry_ping')) {
            wp_schedule_event(time(), 'weekly', 'wseo_telemetry_ping');
        }
        
        // v2.10.0: Schedule marketing cron jobs
        if (!wp_next_scheduled('wseo_send_review_emails')) {
            wp_schedule_event(time(), 'daily', 'wseo_send_review_emails');
        }
        if (!wp_next_scheduled('wseo_send_abandoned_cart_emails')) {
            wp_schedule_event(time(), 'hourly', 'wseo_send_abandoned_cart_emails');
        }
        if (!wp_next_scheduled('wseo_check_back_in_stock')) {
            wp_schedule_event(time(), 'hourly', 'wseo_check_back_in_stock');
        }
        
        // v2.10.0: Create abandoned carts table
        self::create_abandoned_carts_table();
    }
    
    /**
     * v2.10.0: Create abandoned carts database table
     */
    public static function create_abandoned_carts_table() {
        global $wpdb;
        $table_name = $wpdb->prefix . 'wseo_abandoned_carts';
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            session_id varchar(255) NOT NULL,
            user_id bigint(20) DEFAULT 0,
            email varchar(255) DEFAULT '',
            cart_contents longtext NOT NULL,
            cart_total decimal(10,2) DEFAULT 0,
            currency varchar(10) DEFAULT 'EUR',
            status varchar(20) DEFAULT 'active',
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            abandoned_at datetime DEFAULT NULL,
            email_sent_at datetime DEFAULT NULL,
            recovered_at datetime DEFAULT NULL,
            recovery_token varchar(64) DEFAULT NULL,
            PRIMARY KEY (id),
            KEY session_id (session_id),
            KEY user_id (user_id),
            KEY email (email),
            KEY status (status),
            KEY abandoned_at (abandoned_at)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    
    /**
     * v2.9.9: Send telemetry ping to license server
     * Tracks demo installations for analytics
     */
    public static function send_telemetry_ping() {
        // Skip if telemetry is disabled
        if (get_option('wseo_disable_telemetry', false)) {
            return;
        }
        
        // Skip if already has valid license
        $license_key = get_option('wseo_license_key', '');
        $license_status = get_option('wseo_license_status', '');
        if ($license_key && $license_status === 'valid') {
            return;
        }
        
        // Prepare data
        $domain = parse_url(home_url(), PHP_URL_HOST);
        $data = array(
            'domain' => $domain,
            'site_name' => get_bloginfo('name'),
            'plugin_version' => defined('WSEO_VERSION') ? WSEO_VERSION : '2.9.9',
            'wp_version' => get_bloginfo('version'),
            'php_version' => PHP_VERSION,
            'locale' => get_locale(),
            'active_theme' => wp_get_theme()->get('Name'),
            'is_multisite' => is_multisite() ? 1 : 0
        );
        
        // Send ping (non-blocking)
        wp_remote_post('https://webstudio.ltd/wp-json/wseo-license/v1/ping', array(
            'timeout' => 5,
            'blocking' => false,
            'body' => $data,
            'headers' => array(
                'Content-Type' => 'application/x-www-form-urlencoded'
            )
        ));
    }
    
    /**
     * ============================================================================
     * PERFORMANCE ENHANCEMENTS - v2.4.2
     * ============================================================================
     */
    
    /**
     * FIX v2.8.10: Oprava "Skip to content" a iných accessibility linkov
     * 
     * Problém: output_adaptive_loading() pridával CSS triedy (connection-4g, slow-connection)
     * do <html> elementu, čo spôsobovalo:
     * 1. FOUC (Flash of Unstyled Content) - biela obrazovka
     * 2. Viditeľné "Skip to content" tlačidlo (malo byť skryté)
     * 3. Vysoké CLS (Cumulative Layout Shift)
     * 
     * Riešenie: Univerzálny CSS fix pre všetky témy
     */
    
    /**
     * v3.2: Output Critical CSS Inline
     * Improves LCP by inlining essential above-the-fold styles
     */
    public function output_critical_css_inline() {
        // Skip admin and builder previews
        if (is_admin() || $this->is_builder_preview()) {
            return;
        }
        
        $custom_css = get_option('wseo_critical_css_custom', '');
        
        if (!empty($custom_css)) {
            // Use custom CSS
            $critical_css = $custom_css;
        } else {
            // Default critical CSS for common elements
            $critical_css = '
/* WSEO Critical CSS v3.2 - Above-the-fold essentials */
*,*::before,*::after{box-sizing:border-box}
html{-webkit-text-size-adjust:100%;line-height:1.15}
body{margin:0;font-family:system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif;font-size:1rem;line-height:1.5}
main{display:block}
h1,h2,h3,h4,h5,h6{margin-top:0;margin-bottom:.5rem;font-weight:500;line-height:1.2}
h1{font-size:2.5rem}h2{font-size:2rem}h3{font-size:1.75rem}
p{margin-top:0;margin-bottom:1rem}
a{color:inherit;text-decoration:none}
img,svg{vertical-align:middle;max-width:100%;height:auto}
button,input,select,textarea{font-family:inherit;font-size:inherit;line-height:inherit;margin:0}
.container,.wrapper,.site-content,.content-area{width:100%;max-width:1200px;margin:0 auto;padding:0 15px}
header,.site-header,.header{position:relative}
nav,.navigation,.main-navigation{display:flex;align-items:center}
.menu,.nav-menu{list-style:none;margin:0;padding:0;display:flex;gap:1rem}
.hero,.hero-section,.banner{min-height:50vh}
';
        }
        
        // Output minified
        $critical_css = preg_replace('/\s+/', ' ', $critical_css);
        $critical_css = str_replace(array(' {', '{ ', ' }', '} ', ': ', ' :', '; ', ' ;'), array('{', '{', '}', '}', ':', ':', ';', ';'), $critical_css);
        
        echo '<style id="wseo-critical-css">' . $critical_css . '</style>' . "\n";
    }
    
    public function output_accessibility_fix_css() {
        // Skip admin and builder previews
        if (is_admin() || $this->is_builder_preview()) {
            return;
        }
        ?>
        <style id="wseo-anti-fouc">
        /* WebStudio SEO Pro v2.8.10 - Anti-FOUC & Accessibility Fix */
        
        /* ===========================================
         * ANTI-FOUC (Flash of Unstyled Content) Fix
         * Hide page until fully loaded, then reveal
         * =========================================== */
        html:not(.wseo-loaded) { 
            visibility: hidden; 
            opacity: 0; 
        }
        
        /* ===========================================
         * Skip Link Accessibility Fix
         * =========================================== */
        a.skip-link,
        a.skip-to-content,
        a[href="#content"],
        a[href="#main"],
        a[href="#main-content"],
        a[href="#primary"],
        a[class*="skip"],
        .skip-link,
        .skip-to-content,
        .screen-reader-shortcut,
        #skip-link,
        #skip-to-content {
            position: absolute !important;
            left: -9999px !important;
            top: auto !important;
            width: 1px !important;
            height: 1px !important;
            overflow: hidden !important;
            z-index: -1 !important;
            clip: rect(1px, 1px, 1px, 1px) !important;
            clip-path: inset(50%) !important;
            white-space: nowrap !important;
        }
        
        a.skip-link:focus,
        a.skip-to-content:focus,
        a[href="#content"]:focus,
        a[href="#main"]:focus,
        a[href="#main-content"]:focus,
        a[href="#primary"]:focus,
        a[class*="skip"]:focus,
        .skip-link:focus,
        .skip-to-content:focus,
        .screen-reader-shortcut:focus,
        #skip-link:focus,
        #skip-to-content:focus {
            position: fixed !important;
            left: 10px !important;
            top: 10px !important;
            width: auto !important;
            height: auto !important;
            overflow: visible !important;
            z-index: 999999 !important;
            clip: auto !important;
            clip-path: none !important;
            white-space: normal !important;
            background: #fff !important;
            color: #000 !important;
            padding: 15px 23px !important;
            font-size: 16px !important;
            font-weight: 600 !important;
            text-decoration: none !important;
            border: 2px solid #000 !important;
            border-radius: 4px !important;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3) !important;
        }
        </style>
        <noscript><style>html { visibility: visible !important; opacity: 1 !important; }</style></noscript>
        <?php
    }
    
    /**
     * Output anti-FOUC reveal script in footer
     * Reveals page after DOM is ready
     */
    public function output_anti_fouc_reveal() {
        // Skip admin and builder previews
        if (is_admin() || $this->is_builder_preview()) {
            return;
        }
        ?>
        <script id="wseo-anti-fouc-reveal">
        (function(){
            function reveal() {
                document.documentElement.classList.add('wseo-loaded');
                document.documentElement.style.visibility = 'visible';
                document.documentElement.style.opacity = '1';
            }
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', reveal);
            } else {
                reveal();
            }
        })();
        </script>
        <?php
    }
    
    /**
     * Output resource hints for better performance
     * DNS Prefetch & Preconnect
     */
    public function output_resource_hints() {
        // DNS Prefetch pre externé zdroje
        $dns_prefetch = array(
            'fonts.googleapis.com',
            'fonts.gstatic.com',
            'www.google-analytics.com',
            'www.googletagmanager.com',
        );
        
        // Custom DNS prefetch od používateľa
        $custom_dns = get_option('wseo_custom_dns_prefetch', '');
        if (!empty($custom_dns)) {
            $custom_array = array_map('trim', explode("\n", $custom_dns));
            $dns_prefetch = array_merge($dns_prefetch, array_filter($custom_array));
        }
        
        // Automatická detekcia pre často používané externé domény
        if (get_option('wseo_auto_detect_external_domains', '1') === '1') {
            global $post;
            if ($post && !empty($post->post_content)) {
                preg_match_all('/(https?:)?\/\/([^\\/\\s"\'<>]+)/', $post->post_content, $matches);
                if (!empty($matches[2])) {
                    $external_domains = array_unique($matches[2]);
                    foreach ($external_domains as $domain) {
                        $domain = strtolower($domain);
                        // Skip vlastná doména
                        if (isset($_SERVER['HTTP_HOST']) && strpos($domain, $_SERVER['HTTP_HOST']) === false) {
                            $dns_prefetch[] = $domain;
                        }
                    }
                }
            }
        }
        
        // Output DNS prefetch
        foreach (array_unique($dns_prefetch) as $domain) {
            if (!empty($domain)) {
                echo '<link rel="dns-prefetch" href="//' . esc_attr($domain) . '">' . "\n";
            }
        }
        
        // Preconnect pre kritické zdroje
        $preconnect = array();
        
        // Google Fonts
        if (get_option('wseo_preconnect_google_fonts', '1') === '1') {
            $preconnect[] = array('url' => 'https://fonts.googleapis.com', 'crossorigin' => false);
            $preconnect[] = array('url' => 'https://fonts.gstatic.com', 'crossorigin' => true);
        }
        
        // CDN
        $cdn_url = get_option('wseo_cdn_url', '');
        if (!empty($cdn_url)) {
            $preconnect[] = array('url' => $cdn_url, 'crossorigin' => true);
        }
        
        // Custom preconnect
        $custom_preconnect = get_option('wseo_custom_preconnect', '');
        if (!empty($custom_preconnect)) {
            $lines = explode("\n", $custom_preconnect);
            foreach ($lines as $line) {
                $line = trim($line);
                if (empty($line)) continue;
                
                $crossorigin = strpos($line, '[crossorigin]') !== false;
                $url = str_replace('[crossorigin]', '', $line);
                $url = trim($url);
                
                if (!empty($url)) {
                    $preconnect[] = array('url' => $url, 'crossorigin' => $crossorigin);
                }
            }
        }
        
        // Output preconnect
        foreach ($preconnect as $conn) {
            $crossorigin = !empty($conn['crossorigin']) ? ' crossorigin' : '';
            echo '<link rel="preconnect" href="' . esc_url($conn['url']) . '"' . $crossorigin . '>' . "\n";
        }
    }
    
    /**
     * Preload critical resources (hero images, fonts)
     * 
     * FIX v2.8.10: Odstránený fetchpriority="high" z preload linkov
     * pretože spôsoboval biely preblik (render blocking)
     */
    /**
     * Preload critical resources (hero images, fonts)
     * 
     * v2.9.5: COMPLETELY DISABLED hero image preload
     * Dôvod: Preload hero images spôsobuje "resource not used" warnings v konzole
     * pretože obrázok sa často nenachádza above-the-fold alebo sa načíta lazy.
     * Browser natívne optimalizuje LCP aj bez explicitného preloadu.
     * Ponechané len preload fontov (tie fungujú správne).
     */
    public function output_critical_preloads() {
        // v2.9.5: Hero image preload je ÚPLNE VYPNUTÝ
        // Spôsoboval warnings: "resource was preloaded but not used within a few seconds"
        // Browser automaticky prioritizuje above-the-fold obrázky
        
        // Preload kritických fontov - toto je OK, fonty by mali byť preloaded
        $critical_fonts = get_option('wseo_critical_fonts', array());
        if (!empty($critical_fonts) && is_array($critical_fonts)) {
            foreach ($critical_fonts as $font) {
                if (!empty($font['url'])) {
                    $type = !empty($font['type']) ? $font['type'] : 'font/woff2';
                    echo '<link rel="preload" href="' . esc_url($font['url']) . '" as="font" type="' . esc_attr($type) . '" crossorigin>' . "\n";
                }
            }
        }
    }
    
    /**
     * Output adaptive loading hints based on connection quality
     */
    public function output_adaptive_loading() {
        // Don't output for logged-in users (admin bar compatibility)
        if (is_user_logged_in()) {
            return;
        }
        
        if (get_option('wseo_adaptive_loading', '1') !== '1') {
            return;
        }
        ?>
        <script>
        (function() {
            'use strict';
            
            // Network Information API
            const connection = navigator.connection || navigator.mozConnection || navigator.webkitConnection;
            
            if (connection) {
                const effectiveType = connection.effectiveType;
                const saveData = connection.saveData;
                
                // Add class to documentElement for CSS targeting
                document.documentElement.classList.add('connection-' + effectiveType);
                
                if (saveData) {
                    document.documentElement.classList.add('save-data');
                    // Disable aggressive prefetching on save-data mode
                    if (window.wseoConfig) {
                        window.wseoConfig.prefetchEnabled = false;
                    }
                }
                
                // Adjust loading strategy based on connection
                if (effectiveType === 'slow-2g' || effectiveType === '2g') {
                    // Disable prefetch, lazy load everything
                    if (window.wseoConfig) {
                        window.wseoConfig.prefetchEnabled = false;
                    }
                    document.documentElement.classList.add('slow-connection');
                } else if (effectiveType === '3g') {
                    // Conservative prefetch
                    if (window.wseoConfig && window.wseoConfig.prefetchStrategy === 'eager') {
                        window.wseoConfig.prefetchStrategy = 'viewport';
                    }
                } else if (effectiveType === '4g') {
                    // Enable more aggressive prefetching
                    // (already configured, do nothing)
                }
                
                // Monitor connection changes
                connection.addEventListener('change', function() {
                    // Adjust prefetch based on connection
                    if (connection.effectiveType === 'slow-2g' || connection.effectiveType === '2g') {
                        if (window.wseoConfig) {
                            window.wseoConfig.prefetchEnabled = false;
                        }
                    }
                });
            }
        })();
        </script>
        <?php
    }
    
    /**
     * Enqueue prefetch script
     */
    public function enqueue_prefetch_script() {
        if (get_option('wseo_enable_prefetch', '1') !== '1') {
            return;
        }
        
        // Don't load prefetch for logged-in users (fixes admin bar issues)
        if (is_user_logged_in()) {
            return;
        }
        
        // Don't load prefetch on admin pages
        if (is_admin()) {
            return;
        }
        
        // Don't load prefetch on builder pages (server-side check)
        if ($this->is_builder_preview()) {
            return;
        }
        
        // Elementor specific checks
        if (class_exists('\Elementor\Plugin')) {
            if (isset($_GET['elementor-preview']) || isset($_GET['action']) && $_GET['action'] === 'elementor') {
                return;
            }
            // Check if Elementor preview mode
            if (\Elementor\Plugin::$instance->preview && \Elementor\Plugin::$instance->preview->is_preview_mode()) {
                return;
            }
            // Check if Elementor editor
            if (\Elementor\Plugin::$instance->editor && \Elementor\Plugin::$instance->editor->is_edit_mode()) {
                return;
            }
        }
        
        // Themify Builder specific checks
        if (class_exists('Themify_Builder') || class_exists('Themify_Builder_Model')) {
            if (isset($_GET['tb-preview']) || isset($_GET['tb_preview']) || isset($_GET['themify_builder_active'])) {
                return;
            }
            if (defined('THEMIFY_BUILDER_ACTIVE') && THEMIFY_BUILDER_ACTIVE) {
                return;
            }
        }
        
        wp_enqueue_script(
            'wseo-prefetch',
            WSEO_PLUGIN_URL . 'assets/prefetch.js',
            array(),
            WSEO_VERSION,
            true
        );
        
        // Pass config to JavaScript
        wp_localize_script('wseo-prefetch', 'wseoConfig', array(
            'prefetchEnabled' => true,
            'prefetchStrategy' => get_option('wseo_prefetch_strategy', 'hover'),
            'prefetchHoverDelay' => intval(get_option('wseo_prefetch_hover_delay', '250')), // Increased from 65ms
            'prefetchExclude' => $this->get_prefetch_exclude_patterns(),
            'prefetchMaxConcurrent' => intval(get_option('wseo_prefetch_max_concurrent', '1')), // Decreased from 3
            'prefetchMaxPages' => intval(get_option('wseo_prefetch_max_pages', '5')) // Decreased from 10
        ));
    }
    
    /**
     * Get exclude patterns for prefetch
     */
    private function get_prefetch_exclude_patterns() {
        $patterns = array(
            '/wp-admin/.*',
            '/wp-login\\.php',
            '\\?.*', // Query strings
            '#.*'    // Anchors
        );
        
        // WooCommerce pages
        if (class_exists('WooCommerce')) {
            $patterns[] = '/cart/?.*';
            $patterns[] = '/checkout/?.*';
            $patterns[] = '/my-account/?.*';
            $patterns[] = '/objednavka/?.*';
            $patterns[] = '/pokladna/?.*';
            $patterns[] = '/moj-ucet/?.*';
        }
        
        // Custom exclude patterns
        $custom = get_option('wseo_prefetch_exclude', '');
        if (!empty($custom)) {
            $custom_patterns = explode("\n", $custom);
            foreach ($custom_patterns as $pattern) {
                $pattern = trim($pattern);
                if (!empty($pattern)) {
                    $patterns[] = $pattern;
                }
            }
        }
        
        return $patterns;
    }
    
    /**
     * Add fetchpriority attributes to images
     */
    public function add_fetchpriority_attributes($attr, $attachment) {
        // Len pre featured images
        if (is_singular()) {
            global $post;
            $thumbnail_id = get_post_thumbnail_id($post->ID);
            
            if ($thumbnail_id === $attachment->ID) {
                // Featured image = high priority pre LCP
                $attr['fetchpriority'] = 'high';
            }
        }
        
        return $attr;
    }
    
    /**
     * ============================================================================
     * ADVANCED PERFORMANCE OPTIMIZATIONS (v2.6.0)
     * BEZPEČNÉ OPTIMALIZÁCIE - bez bieleho blikania (FOUC)
     * ============================================================================
     */
    
    /**
     * Send HTTP 103 Early Hints for critical resources
     * Browsers can start loading resources before HTML arrives
     * BEZPEČNÉ: Len hints, nemení poradie načítania
     */
    public function send_103_early_hints() {
        if (is_admin() || wp_doing_ajax()) {
            return;
        }
        
        // Only send if headers not yet sent
        if (headers_sent()) {
            return;
        }
        
        $hints = array();
        
        // Preconnect pre Google Fonts (ak sa používajú)
        if (get_option('wseo_preconnect_google_fonts', '1') === '1') {
            $hints[] = '<https://fonts.googleapis.com>; rel=preconnect';
            $hints[] = '<https://fonts.gstatic.com>; rel=preconnect; crossorigin';
        }
        
        // CDN preconnect
        $cdn_url = get_option('wseo_cdn_url', '');
        if (!empty($cdn_url)) {
            $hints[] = '<' . esc_url($cdn_url) . '>; rel=preconnect; crossorigin';
        }
        
        // Hero image hint (len ak existuje)
        if (is_singular()) {
            global $post;
            if ($post) {
                $hero_image = get_the_post_thumbnail_url($post->ID, 'large');
                if ($hero_image) {
                    $hints[] = '<' . esc_url($hero_image) . '>; rel=preload; as=image; fetchpriority=high';
                }
            }
        }
        
        if (!empty($hints)) {
            header('Link: ' . implode(', ', $hints), false);
        }
    }
    
    /**
     * Output early hints meta tags in head (fallback for non-103 servers)
     * BEZPEČNÉ: Preload len pre LCP obrázok
     */
    public function output_early_hints_header() {
        echo "<!-- WebStudio SEO Pro: Performance Hints -->\n";
        
        // Preload LCP image s vysokou prioritou
        if (is_singular()) {
            global $post;
            if ($post) {
                // Skúsime OG image, potom featured image
                $lcp_image = get_post_meta($post->ID, '_wseo_og_image', true);
                if (!$lcp_image) {
                    $lcp_image = get_the_post_thumbnail_url($post->ID, 'large');
                }
                
                if ($lcp_image) {
                    // Detekcia MIME typu
                    $ext = strtolower(pathinfo(parse_url($lcp_image, PHP_URL_PATH), PATHINFO_EXTENSION));
                    $mime_types = array(
                        'jpg' => 'image/jpeg', 'jpeg' => 'image/jpeg',
                        'png' => 'image/png', 'webp' => 'image/webp',
                        'avif' => 'image/avif', 'gif' => 'image/gif'
                    );
                    $type_attr = isset($mime_types[$ext]) ? ' type="' . $mime_types[$ext] . '"' : '';
                    
                    echo '<link rel="preload" as="image" href="' . esc_url($lcp_image) . '"' . $type_attr . ' fetchpriority="high">' . "\n";
                }
            }
        }
        
        // Homepage hero image
        if (is_front_page()) {
            $homepage_hero = get_option('wseo_homepage_hero_image', '');
            if ($homepage_hero) {
                echo '<link rel="preload" as="image" href="' . esc_url($homepage_hero) . '" fetchpriority="high">' . "\n";
            }
        }
    }
    
    /**
     * Add async/defer to NON-CRITICAL scripts only
     * BEZPEČNÉ: Len pre tracking a analytics skripty ktoré nemajú vplyv na UI
     */
    public function add_async_defer_attributes($tag, $handle, $src) {
        // Skip admin a customizer
        if (is_admin() || is_customize_preview()) {
            return $tag;
        }
        
        // Ak už má async alebo defer, nechaj
        if (strpos($tag, 'async') !== false || strpos($tag, 'defer') !== false) {
            return $tag;
        }
        
        // BEZPEČNÉ async skripty - len tracking/analytics (nemajú UI efekt)
        $safe_async_scripts = array(
            'google-analytics',
            'ga-',
            'gtag',
            'gtm',
            'googletagmanager',
            'facebook-pixel',
            'fbevents',
            'hotjar',
            'clarity',
            'plausible',
            'umami',
            'matomo',
            'piwik',
        );
        
        // BEZPEČNÉ defer skripty - helper skripty bez UI
        $safe_defer_scripts = array(
            'comment-reply',    // Len keď sa používa
            'wp-embed',         // Embed handling
            'jquery-migrate',   // Compatibility layer
        );
        
        // Async pre tracking
        foreach ($safe_async_scripts as $script) {
            if (strpos($handle, $script) !== false || strpos($src, $script) !== false) {
                return str_replace(' src=', ' async src=', $tag);
            }
        }
        
        // Defer pre helpery
        foreach ($safe_defer_scripts as $script) {
            if ($handle === $script) {  // Presná zhoda pre bezpečnosť
                return str_replace(' src=', ' defer src=', $tag);
            }
        }
        
        return $tag;
    }
    
    /**
     * Optimize CSS loading - VEĽMI KONZERVATÍVNE
     * Len pre štýly ktoré 100% nie sú potrebné pre above-the-fold
     * BEZPEČNÉ: Len dashicons (ikony v admin bare) ak nie je admin
     */
    public function optimize_css_loading($html, $handle, $href, $media) {
        // Skip admin, customizer, login
        if (is_admin() || is_customize_preview() || $GLOBALS['pagenow'] === 'wp-login.php') {
            return $html;
        }
        
        // JEDINÉ bezpečné na async načítanie - dashicons na frontende
        // (používajú sa len v admin bare, nie v obsahu stránky)
        $safe_async_styles = array(
            'dashicons',  // Admin bar ikony - nie sú kritické pre LCP
        );
        
        // Ak nie je admin bar zobrazený, môžeme dashicons odložiť
        if (!is_admin_bar_showing()) {
            foreach ($safe_async_styles as $style) {
                if ($handle === $style) {
                    // Asynchrónne načítanie s fallbackom
                    $html = str_replace(
                        "media='all'",
                        "media='print' onload=\"this.media='all'; this.onload=null;\"",
                        $html
                    );
                    $html .= '<noscript><link rel="stylesheet" href="' . esc_url($href) . '" media="all"></noscript>' . "\n";
                    break;
                }
            }
        }
        
        return $html;
    }
    
    /**
     * Output instant.page script for ultra-fast prefetching
     * BEZPEČNÉ: Len prefetch, nemení aktuálnu stránku
     */
    public function output_instant_page_script() {
        if (is_admin()) {
            return;
        }
        
        // Check if feature is enabled (default: on)
        if (get_option('wseo_instant_page', '1') !== '1') {
            return;
        }
        
        // Don't load if prefetch.js already handles this
        if (get_option('wseo_enable_prefetch', '1') === '1') {
            return;
        }
        ?>
        <!-- WebStudio SEO: Instant Page (hover prefetch) -->
        <script src="//instant.page/5.2.0" type="module" integrity="sha384-jnZyxPjiipYXnSU0ber3rJ4cLD/8H/5F/1M3HQ5ydVqKqA6K+AZoVhT2QcHyFJJI" defer></script>
        <?php
    }
    
    /**
     * Add Critical CSS inline for above-the-fold content
     * Called via shortcode or manually
     */
    public function get_critical_css() {
        $critical_css = get_option('wseo_critical_css', '');
        if (!empty($critical_css)) {
            return '<style id="wseo-critical-css">' . wp_strip_all_tags($critical_css) . '</style>';
        }
        return '';
    }
    
    
    /**
     * ============================================================================
     * AUTO PERFORMANCE OPTIMIZER (v2.6.3)
     * Bezpečné, automatické optimalizácie bez nastavení
     * 4 funkcie ktoré NIKDY nerozbijú stránku
     * ============================================================================
     */
    
    /**
     * Check if we're in page builder preview mode
     * @return bool
     */
    private function is_builder_preview() {
        // Elementor
        if (isset($_GET['elementor-preview'])) return true;
        
        // Divi
        if (isset($_GET['et_fb']) || isset($_GET['et_pb_preview'])) return true;
        
        // Beaver Builder
        if (isset($_GET['fl_builder'])) return true;
        
        // Bricks
        if (isset($_GET['bricks']) || isset($_GET['bricks_preview'])) return true;
        
        // Oxygen
        if (isset($_GET['ct_builder']) || isset($_GET['oxygen_iframe'])) return true;
        
        // WPBakery
        if (isset($_GET['vc_editable']) || isset($_GET['vc_action'])) return true;
        
        // Breakdance
        if (isset($_GET['breakdance']) || isset($_GET['breakdance_iframe'])) return true;
        
        // Themify Builder + Themify Builder Pro
        if (isset($_GET['tb-preview']) || isset($_GET['tb_preview']) || isset($_GET['themify_builder_active'])) return true;
        if (isset($_GET['builder_active']) || isset($_GET['tb-id'])) return true;
        if (isset($_GET['themify_builder']) || isset($_GET['tb_callback'])) return true;
        if (defined('THEMIFY_BUILDER_ACTIVE') && THEMIFY_BUILDER_ACTIVE) return true;
        if (defined('THEMIFY_BUILDER_FRONT_EDIT') && THEMIFY_BUILDER_FRONT_EDIT) return true;
        // Themify Builder Pro specific
        if (isset($_GET['tbp_preview']) || isset($_GET['tbp']) || isset($_GET['tbp_template'])) return true;
        if (class_exists('Themify_Builder_Pro') && isset($_GET['preview'])) return true;
        
        // Customizer & Preview
        if (isset($_GET['preview']) || isset($_GET['preview_id']) || is_customize_preview()) return true;
        
        return false;
    }
    
    /**
     * v2.9.0-BETA: Smart Cache Headers System
     * Inteligentné cache hlavičky pre CDN/prehliadače s builder detection
     * SAFE: Only affects HTTP headers, not HTML content
     */
    public function send_browser_cache_headers() {
        // Skip admin
        if (is_admin()) {
            $this->send_no_cache_headers();
            return;
        }
        
        // Skip AJAX
        if (wp_doing_ajax()) {
            return;
        }
        
        // Skip builder previews - KRITICKÉ pre Elementor, Divi, Themify, Beaver Builder
        if ($this->is_builder_preview()) {
            $this->send_no_cache_headers();
            return;
        }
        
        // Skip logged in users (personalized content)
        if (is_user_logged_in()) {
            $this->send_private_cache_headers();
            return;
        }
        
        // Skip WooCommerce dynamic pages
        if ($this->is_woocommerce_dynamic_page()) {
            $this->send_private_cache_headers();
            return;
        }
        
        // Skip if cart has items (WooCommerce)
        if ($this->has_woocommerce_cart_items()) {
            $this->send_private_cache_headers();
            return;
        }
        
        // Skip POST requests
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->send_no_cache_headers();
            return;
        }
        
        // Determine cache duration based on content type
        $cache_settings = $this->get_smart_cache_settings();
        
        // Send optimized cache headers
        $this->send_smart_cache_headers($cache_settings);
    }
    
    /**
     * v2.9.0-BETA: Get smart cache settings based on content type
     */
    private function get_smart_cache_settings() {
        $settings = array(
            'max_age' => 3600,           // 1 hodina default
            'stale_while_revalidate' => 86400,  // 24 hodín stale
            'stale_if_error' => 604800,  // 7 dní ak server padne
            'cdn_max_age' => 86400,      // 24 hodín pre CDN
            'cache_type' => 'public'
        );
        
        // Homepage - kratšia cache (častejšie zmeny na news weboch)
        if (is_front_page() || is_home()) {
            $settings['max_age'] = 300;         // 5 minút (pre news weby)
            $settings['cdn_max_age'] = 600;     // 10 minút pre CDN
            $settings['stale_while_revalidate'] = 300; // 5 minút stale
        }
        
        // Single posts/pages - stredná cache
        if (is_singular()) {
            $settings['max_age'] = 3600;        // 1 hodina
            $settings['cdn_max_age'] = 86400;   // 24 hodín pre CDN
        }
        
        // Archive pages - kratšia cache (nové články)
        if (is_archive() || is_category() || is_tag()) {
            $settings['max_age'] = 300;         // 5 minút
            $settings['cdn_max_age'] = 600;     // 10 minút pre CDN
            $settings['stale_while_revalidate'] = 300;
        }
        
        // Static pages (about, contact) - dlhšia cache
        if (is_page() && !is_front_page()) {
            $post = get_post();
            if ($post) {
                $days_since_modified = (time() - strtotime($post->post_modified)) / 86400;
                if ($days_since_modified > 30) {
                    $settings['max_age'] = 86400;       // 24 hodín
                    $settings['cdn_max_age'] = 604800;  // 7 dní pre CDN
                }
            }
        }
        
        // 404 pages - krátka cache
        if (is_404()) {
            $settings['max_age'] = 300;         // 5 minút
            $settings['cdn_max_age'] = 600;     // 10 minút pre CDN
        }
        
        // Search results - no cache
        if (is_search()) {
            $settings['max_age'] = 0;
            $settings['cdn_max_age'] = 0;
            $settings['cache_type'] = 'private';
        }
        
        return apply_filters('wseo_smart_cache_settings', $settings);
    }
    
    /**
     * v2.9.0-BETA: Send smart cache headers
     */
    private function send_smart_cache_headers($settings) {
        $directives = array();
        
        // Cache type
        $directives[] = $settings['cache_type'];
        
        // Max age
        if ($settings['max_age'] > 0) {
            $directives[] = 'max-age=' . $settings['max_age'];
        }
        
        // CDN cache (s-maxage)
        if ($settings['cdn_max_age'] > 0) {
            $directives[] = 's-maxage=' . $settings['cdn_max_age'];
        }
        
        // Stale-while-revalidate - kľúčové pre rýchlosť!
        if ($settings['stale_while_revalidate'] > 0) {
            $directives[] = 'stale-while-revalidate=' . $settings['stale_while_revalidate'];
        }
        
        // Stale-if-error - backup ak server padne
        if ($settings['stale_if_error'] > 0) {
            $directives[] = 'stale-if-error=' . $settings['stale_if_error'];
        }
        
        header('Cache-Control: ' . implode(', ', $directives));
        header('Vary: Accept-Encoding, Cookie');
        
        // Cloudflare-specific headers
        if ($settings['cdn_max_age'] > 0) {
            header('CDN-Cache-Control: max-age=' . $settings['cdn_max_age']);
            header('Cloudflare-CDN-Cache-Control: max-age=' . $settings['cdn_max_age']);
        }
        
        // Surrogate-Control pre Fastly/Varnish
        if ($settings['cdn_max_age'] > 0) {
            header('Surrogate-Control: max-age=' . $settings['cdn_max_age']);
        }
    }
    
    /**
     * v2.9.0-BETA: Send no-cache headers (admin, builders, POST)
     */
    private function send_no_cache_headers() {
        header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
        header('Pragma: no-cache');
        header('Expires: Wed, 11 Jan 1984 05:00:00 GMT');
    }
    
    /**
     * v2.9.0-BETA: Send private cache headers (logged in users, WooCommerce cart)
     */
    private function send_private_cache_headers() {
        header('Cache-Control: private, no-cache, must-revalidate');
        header('Vary: Cookie');
    }
    
    /**
     * v2.9.0-BETA: Check if WooCommerce dynamic page
     */
    private function is_woocommerce_dynamic_page() {
        if (!function_exists('is_cart') || !function_exists('is_checkout')) {
            return false;
        }
        
        return is_cart() || is_checkout() || is_account_page();
    }
    
    /**
     * v2.9.0-BETA: Check if WooCommerce cart has items
     */
    private function has_woocommerce_cart_items() {
        // Check WooCommerce cart cookie
        if (isset($_COOKIE['woocommerce_items_in_cart']) && $_COOKIE['woocommerce_items_in_cart'] > 0) {
            return true;
        }
        
        // Check WooCommerce cart session
        if (function_exists('WC') && WC()->cart && !WC()->cart->is_empty()) {
            return true;
        }
        
        return false;
    }
    
    /**
     * Auto optimize images in content with lazy loading
     * SAFE: Uses native HTML attributes supported by all browsers
     */
    public function auto_optimize_images($content) {
        // Skip admin, feeds, preview modes
        if (is_admin() || is_feed() || $this->is_builder_preview()) {
            return $content;
        }
        
        // Skip if content is empty or too short
        if (empty($content) || strlen($content) < 100) {
            return $content;
        }
        
        $image_count = 0;
        
        // Process images - add lazy loading (skip first for LCP)
        $content = preg_replace_callback(
            '/<img([^>]+)>/i',
            function($matches) use (&$image_count) {
                $image_count++;
                $img = $matches[0];
                $attrs = $matches[1];
                
                // First image: add fetchpriority="high" for LCP
                if ($image_count === 1) {
                    if (strpos($attrs, 'fetchpriority') === false) {
                        return str_replace('<img', '<img fetchpriority="high"', $img);
                    }
                    return $img;
                }
                
                // Other images: add lazy loading if not present
                if (strpos($attrs, 'loading=') === false) {
                    // Skip data URIs and SVGs
                    if (preg_match('/src=["\']data:/i', $attrs) || preg_match('/\.svg["\'\s>]/i', $attrs)) {
                        return $img;
                    }
                    return str_replace('<img', '<img loading="lazy"', $img);
                }
                
                return $img;
            },
            $content
        );
        
        // Process iframes (YouTube, Vimeo, maps) - add lazy loading
        $content = preg_replace_callback(
            '/<iframe([^>]+)>/i',
            function($matches) {
                $iframe = $matches[0];
                $attrs = $matches[1];
                
                // Add lazy loading if not present
                if (strpos($attrs, 'loading=') === false) {
                    return str_replace('<iframe', '<iframe loading="lazy"', $iframe);
                }
                return $iframe;
            },
            $content
        );
        
        return $content;
    }
    
    /**
     * Auto optimize post thumbnail (featured image)
     * SAFE: Only adds fetchpriority hint for LCP
     */
    public function auto_optimize_thumbnail($html, $post_id, $thumbnail_id, $size, $attr) {
        if (is_admin() || $this->is_builder_preview()) {
            return $html;
        }
        
        // Featured image should have high priority (LCP)
        if (!empty($html) && strpos($html, 'fetchpriority') === false) {
            $html = str_replace('<img', '<img fetchpriority="high"', $html);
        }
        
        return $html;
    }
    
    /**
     * Auto add lazy loading to attachment images
     * SAFE: Uses native HTML attributes
     */
    public function auto_add_lazy_loading($attr, $attachment, $size) {
        if (is_admin() || $this->is_builder_preview()) {
            return $attr;
        }
        
        // Don't add lazy to images with high priority (featured images)
        if (!empty($attr['fetchpriority']) && $attr['fetchpriority'] === 'high') {
            return $attr;
        }
        
        // Add lazy loading if not present
        if (!isset($attr['loading'])) {
            $attr['loading'] = 'lazy';
        }
        
        // Add decoding async for better performance
        if (!isset($attr['decoding'])) {
            $attr['decoding'] = 'async';
        }
        
        return $attr;
    }
    
    /**
     * AJAX: Clear old cache files from v2.6.2
     */
    public function ajax_clear_old_cache() {
        check_ajax_referer('wseo_cache_nonce', 'nonce');
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Nedostatočné oprávnenia');
        }
        
        $cleared = 0;
        
        // Clear old page cache directory if it exists
        $old_cache_dir = WP_CONTENT_DIR . '/cache/wseo/';
        if (is_dir($old_cache_dir)) {
            $files = glob($old_cache_dir . '*');
            foreach ($files as $file) {
                if (is_file($file)) {
                    @unlink($file);
                    $cleared++;
                }
            }
            @rmdir($old_cache_dir);
        }
        
        // Clear transients
        global $wpdb;
        $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_wseo_%'");
        $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_wseo_%'");
        
        wp_send_json_success(array('cleared' => $cleared));
    }
    
    // ===================================================================
    // MAINTENANCE & SERVICE FUNCTIONS
    // Database cleanup, optimization, diagnostics & backup
    // ===================================================================
    
    // Include maintenance functions
    // Note: These files contain class methods and will be parsed as part of this class
    
/**
 * Add custom cron schedules
 */
public function add_cron_schedules($schedules) {
    $schedules['weekly'] = array(
        'interval' => 604800, // 7 days
        'display' => 'Raz týždenne'
    );
    $schedules['monthly'] = array(
        'interval' => 2635200, // 30 days
        'display' => 'Raz mesačne'
    );
    
    // Custom schedules for frequency adjustments
    $schedules['wseo_custom_1000'] = array(
        'interval' => 1,
        'display' => 'Každú sekundu'
    );
    $schedules['wseo_custom_2000'] = array(
        'interval' => 2,
        'display' => 'Každé 2 sekundy'
    );
    $schedules['wseo_custom_5000'] = array(
        'interval' => 5,
        'display' => 'Každých 5 sekúnd'
    );
    $schedules['wseo_custom_10000'] = array(
        'interval' => 10,
        'display' => 'Každých 10 sekúnd'
    );
    
    return $schedules;
}

/**
 * AJAX: Cleanup selected items
 */
public function ajax_maintenance_cleanup() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    $items = isset($_POST['items']) ? (array)$_POST['items'] : array();
    
    if (empty($items)) {
        wp_send_json_error('Neboli vybrané žiadne položky.');
    }
    
    global $wpdb;
    $deleted = array();
    $total_deleted = 0;
    
    foreach ($items as $item) {
        $count = 0;
        
        switch ($item) {
            case 'revisions':
                $count = $wpdb->query("DELETE FROM {$wpdb->posts} WHERE post_type = 'revision'");
                $deleted['Revízie'] = $count;
                break;
                
            case 'autodrafts':
                $count = $wpdb->query("DELETE FROM {$wpdb->posts} WHERE post_status = 'auto-draft'");
                $deleted['Auto-drafts'] = $count;
                break;
                
            case 'trash':
                $count = $wpdb->query("DELETE FROM {$wpdb->posts} WHERE post_status = 'trash'");
                $deleted['Kôš'] = $count;
                break;
                
            case 'spam_comments':
                $count = $wpdb->query("DELETE FROM {$wpdb->comments} WHERE comment_approved = 'spam'");
                $deleted['Spam komentáre'] = $count;
                break;
                
            case 'trashed_comments':
                $count = $wpdb->query("DELETE FROM {$wpdb->comments} WHERE comment_approved = 'trash'");
                $deleted['Vymazané komentáre'] = $count;
                break;
                
            case 'expired_transients':
                $count = $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_%' AND option_value < UNIX_TIMESTAMP()");
                $count += $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_%' AND option_name NOT LIKE '_transient_timeout_%' AND option_name NOT IN (SELECT REPLACE(option_name, '_timeout', '') FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_%')");
                $deleted['Expirované transienty'] = $count;
                break;
        }
        
        $total_deleted += $count;
    }
    
    // Log activity
    $this->log_maintenance_activity('Čistenie databázy', 'Vymazané položky: ' . implode(', ', array_map(function($k, $v) {
        return "$k ($v)";
    }, array_keys($deleted), $deleted)));
    
    // Update last cleanup time
    update_option('wseo_last_cleanup_time', time());
    
    $message = '<strong>Vymazané položky:</strong><br>';
    foreach ($deleted as $type => $count) {
        $message .= "• $type: " . number_format($count) . " záznamov<br>";
    }
    $message .= "<br><strong>Celkom:</strong> " . number_format($total_deleted) . " záznamov";
    
    wp_send_json_success(array('message' => $message, 'deleted' => $deleted));
}

/**
 * AJAX: Optimize database tables
 */
public function ajax_maintenance_optimize() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    // Get all tables
    $tables = $wpdb->get_results("SHOW TABLES", ARRAY_N);
    
    $optimized = 0;
    $total_overhead = 0;
    
    foreach ($tables as $table) {
        $table_name = $table[0];
        
        // Get table status
        $status = $wpdb->get_row("SHOW TABLE STATUS LIKE '$table_name'");
        if ($status && isset($status->Data_free)) {
            $total_overhead += $status->Data_free;
        }
        
        // Optimize table
        $wpdb->query("OPTIMIZE TABLE `$table_name`");
        $optimized++;
    }
    
    // Log activity
    $this->log_maintenance_activity('Optimalizácia databázy', "Optimalizované tabulky: $optimized, Uvoľnený priestor: " . size_format($total_overhead));
    
    $message = "<strong>Optimalizované tabulky:</strong> $optimized<br>";
    $message .= "<strong>Uvoľnený overhead:</strong> " . size_format($total_overhead);
    
    wp_send_json_success(array('message' => $message));
}

/**
 * AJAX: Analyze database tables
 */
public function ajax_maintenance_analyze() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    // Get all tables
    $tables = $wpdb->get_results("SHOW TABLES", ARRAY_N);
    
    $analyzed = 0;
    $report = array();
    
    foreach ($tables as $table) {
        $table_name = $table[0];
        
        // Analyze table
        $result = $wpdb->get_row("ANALYZE TABLE `$table_name`");
        
        if ($result && isset($result->Msg_text)) {
            $report[$table_name] = $result->Msg_text;
        }
        
        $analyzed++;
    }
    
    // Log activity
    $this->log_maintenance_activity('Analýza databázy', "Analyzované tabulky: $analyzed");
    
    $message = "<strong>Analyzované tabulky:</strong> $analyzed<br><br>";
    $message .= "<strong>Výsledky analýzy:</strong><br>";
    $message .= "<div style='max-height: 300px; overflow-y: auto; background: #f0f0f1; padding: 10px; border-radius: 4px;'>";
    
    foreach ($report as $table => $status) {
        $icon = (stripos($status, 'OK') !== false) ? '✓' : '⚠';
        $color = (stripos($status, 'OK') !== false) ? '#00a32a' : '#dba617';
        $message .= "<div style='margin: 5px 0; color: $color;'><code>$table</code>: $icon $status</div>";
    }
    
    $message .= "</div>";
    
    wp_send_json_success(array('message' => $message));
}

/**
 * AJAX: Clean orphaned metadata
 */
public function ajax_maintenance_orphaned() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    $type = isset($_POST['type']) ? sanitize_text_field($_POST['type']) : '';
    
    global $wpdb;
    $deleted = 0;
    
    switch ($type) {
        case 'postmeta':
            $deleted = $wpdb->query("
                DELETE pm FROM {$wpdb->postmeta} pm
                LEFT JOIN {$wpdb->posts} p ON pm.post_id = p.ID
                WHERE p.ID IS NULL
            ");
            $type_label = 'Post meta';
            break;
            
        case 'commentmeta':
            $deleted = $wpdb->query("
                DELETE cm FROM {$wpdb->commentmeta} cm
                LEFT JOIN {$wpdb->comments} c ON cm.comment_id = c.comment_ID
                WHERE c.comment_ID IS NULL
            ");
            $type_label = 'Comment meta';
            break;
            
        case 'termmeta':
            $deleted = $wpdb->query("
                DELETE tm FROM {$wpdb->termmeta} tm
                LEFT JOIN {$wpdb->terms} t ON tm.term_id = t.term_id
                WHERE t.term_id IS NULL
            ");
            $type_label = 'Term meta';
            break;
            
        default:
            wp_send_json_error('Neplatný typ metadát.');
            return;
    }
    
    // Log activity
    $this->log_maintenance_activity('Čistenie orphaned metadata', "$type_label: $deleted záznamov");
    
    $message = "<strong>$type_label:</strong> Vymazané " . number_format($deleted) . " orphaned záznamov";
    
    wp_send_json_success(array('message' => $message));
}

/**
 * AJAX: Scan autoload options
 */
public function ajax_maintenance_scan_autoload() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    // Get top 20 largest autoload options
    $results = $wpdb->get_results("
        SELECT option_name, LENGTH(option_value) as size
        FROM {$wpdb->options}
        WHERE autoload = 'yes'
        ORDER BY size DESC
        LIMIT 20
    ");
    
    if (empty($results)) {
        wp_send_json_error('Nepodarilo sa načítať autoload options.');
    }
    
    $html = '<div class="wseo-result-box">';
    $html .= '<h3 style="margin-top: 0;">Top 20 najväčších autoload options:</h3>';
    $html .= '<table class="wp-list-table widefat fixed striped">';
    $html .= '<thead><tr><th>Option Name</th><th>Veľkosť</th><th>Akcia</th></tr></thead>';
    $html .= '<tbody>';
    
    foreach ($results as $row) {
        $size = size_format($row->size, 2);
        $option_name = esc_html($row->option_name);
        $html .= '<tr>';
        $html .= '<td><code>' . $option_name . '</code></td>';
        $html .= '<td>' . $size . '</td>';
        $html .= '<td><button class="button button-small wseo-disable-autoload" data-option="' . esc_attr($option_name) . '">Vypnúť autoload</button></td>';
        $html .= '</tr>';
    }
    
    $html .= '</tbody></table>';
    $html .= '<p style="margin-top: 15px;"><strong>Poznámka:</strong> Vypnutie autoload pre systémové options môže spôsobiť problémy. Buďte opatrní!</p>';
    $html .= '</div>';
    
    $html .= '<script>
    jQuery(document).ready(function($) {
        $(".wseo-disable-autoload").on("click", function() {
            var option = $(this).data("option");
            if (!confirm("Ste si istí, že chcete vypnúť autoload pre: " + option + "?")) {
                return;
            }
            
            $.ajax({
                url: ajaxurl,
                type: "POST",
                data: {
                    action: "wseo_maintenance_disable_autoload",
                    option: option,
                    nonce: "' . wp_create_nonce('wseo_maintenance') . '"
                },
                success: function(response) {
                    if (response.success) {
                        alert("✓ Autoload vypnutý!");
                        location.reload();
                    } else {
                        alert("✗ Chyba: " + response.data);
                    }
                }
            });
        });
    });
    </script>';
    
    wp_send_json_success(array('html' => $html));
}

/**
 * Helper: Disable autoload for option
 */
public function ajax_maintenance_disable_autoload() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    $option = isset($_POST['option']) ? sanitize_text_field($_POST['option']) : '';
    
    if (empty($option)) {
        wp_send_json_error('Neplatný option name.');
    }
    
    global $wpdb;
    
    $result = $wpdb->update(
        $wpdb->options,
        array('autoload' => 'no'),
        array('option_name' => $option),
        array('%s'),
        array('%s')
    );
    
    if ($result !== false) {
        $this->log_maintenance_activity('Autoload optimization', "Vypnutý autoload pre: $option");
        wp_send_json_success();
    } else {
        wp_send_json_error('Nepodarilo sa aktualizovať option.');
    }
}

/**
 * AJAX: Save scheduled cleanup settings
 */
public function ajax_maintenance_save_scheduled() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    $settings = array(
        'enabled' => isset($_POST['enabled']) && $_POST['enabled'] === 'true',
        'frequency' => isset($_POST['frequency']) ? sanitize_text_field($_POST['frequency']) : 'weekly',
        'items' => isset($_POST['items']) ? (array)$_POST['items'] : array(),
        'email_report' => isset($_POST['email_report']) && $_POST['email_report'] === 'true'
    );
    
    update_option('wseo_scheduled_cleanup', $settings);
    
    // Clear existing schedule
    wp_clear_scheduled_hook('wseo_scheduled_maintenance');
    
    // Schedule new event if enabled
    if ($settings['enabled']) {
        $recurrence = 'daily';
        if ($settings['frequency'] === 'weekly') {
            $recurrence = 'weekly';
        } elseif ($settings['frequency'] === 'monthly') {
            $recurrence = 'monthly';
        }
        
        wp_schedule_event(time(), $recurrence, 'wseo_scheduled_maintenance');
    }
    
    $this->log_maintenance_activity('Scheduled cleanup nastavenia', 'Aktualizované nastavenia automatického čistenia');
    
    wp_send_json_success();
}

/**
 * Run scheduled maintenance
 */
public function run_scheduled_maintenance() {
    $settings = get_option('wseo_scheduled_cleanup', array());
    
    if (empty($settings['enabled']) || empty($settings['items'])) {
        return;
    }
    
    global $wpdb;
    $deleted = array();
    
    foreach ($settings['items'] as $item) {
        $count = 0;
        
        switch ($item) {
            case 'revisions':
                $count = $wpdb->query("DELETE FROM {$wpdb->posts} WHERE post_type = 'revision'");
                $deleted['Revízie'] = $count;
                break;
                
            case 'autodrafts':
                $count = $wpdb->query("DELETE FROM {$wpdb->posts} WHERE post_status = 'auto-draft'");
                $deleted['Auto-drafts'] = $count;
                break;
                
            case 'expired_transients':
                $count = $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_%' AND option_value < UNIX_TIMESTAMP()");
                $deleted['Expirované transienty'] = $count;
                break;
                
            case 'spam_comments':
                $count = $wpdb->query("DELETE FROM {$wpdb->comments} WHERE comment_approved = 'spam'");
                $deleted['Spam komentáre'] = $count;
                break;
        }
    }
    
    // Log activity
    $this->log_maintenance_activity('Automatické čistenie', 'Vymazané položky: ' . implode(', ', array_map(function($k, $v) {
        return "$k ($v)";
    }, array_keys($deleted), $deleted)));
    
    // Send email report if enabled
    if (!empty($settings['email_report'])) {
        $admin_email = get_option('admin_email');
        $site_name = get_bloginfo('name');
        
        $message = "Automatické čistenie databázy pre $site_name\n\n";
        $message .= "Dátum: " . date('d.m.Y H:i') . "\n\n";
        $message .= "Vymazané položky:\n";
        
        foreach ($deleted as $type => $count) {
            $message .= "• $type: " . number_format($count) . " záznamov\n";
        }
        
        wp_mail($admin_email, "[{$site_name}] Report z automatického čistenia databázy", $message);
    }
    
    update_option('wseo_last_cleanup_time', time());
}

/**
 * Log maintenance activity
 */
private function log_maintenance_activity($action, $details) {
    $log = get_option('wseo_maintenance_log', array());
    
    $log[] = array(
        'time' => date('d.m.Y H:i:s'),
        'action' => $action,
        'details' => $details
    );
    
    // Keep only last 100 entries
    if (count($log) > 100) {
        $log = array_slice($log, -100);
    }
    
    update_option('wseo_maintenance_log', $log);
}

/**
 * AJAX: Clear maintenance log
 */
public function ajax_maintenance_clear_log() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    update_option('wseo_maintenance_log', array());
    wp_send_json_success();
}
/**
 * AJAX: Scan images for optimization
 */
public function ajax_maintenance_scan_images() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    // Get all images
    $args = array(
        'post_type' => 'attachment',
        'post_mime_type' => 'image',
        'post_status' => 'inherit',
        'posts_per_page' => -1,
        'fields' => 'ids'
    );
    
    $image_ids = get_posts($args);
    
    $stats = array(
        'total' => count($image_ids),
        'without_alt' => 0,
        'without_webp' => 0,
        'without_avif' => 0,
        'can_optimize' => 0,
        'total_size' => 0,
        'potential_savings' => 0
    );
    
    $optimize_candidates = array();
    
    // Check AVIF support
    $avif_supported = $this->is_avif_supported();
    
    // OPTIMIZATION: Batch load all meta data to avoid N+1 queries
    if (!empty($image_ids)) {
        update_meta_cache('post', $image_ids);
    }
    
    foreach ($image_ids as $image_id) {
        $alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
        if (empty($alt)) {
            $stats['without_alt']++;
        }
        
        $file_path = get_attached_file($image_id);
        if ($file_path && file_exists($file_path)) {
            $file_size = filesize($file_path);
            $stats['total_size'] += $file_size;
            
            // Check image type and if it can be optimized
            $mime_type = get_post_mime_type($image_id);
            
            // Check if WebP version exists
            $webp_path = preg_replace('/\.(jpg|jpeg|png)$/i', '.webp', $file_path);
            if (!file_exists($webp_path)) {
                $stats['without_webp']++;
            }
            
            // Check if AVIF version exists (v2.8.10)
            $avif_path = preg_replace('/\.(jpg|jpeg|png)$/i', '.avif', $file_path);
            if (!file_exists($avif_path)) {
                $stats['without_avif']++;
            }
            
            // Check if image can be optimized (not already optimized)
            $already_optimized = get_post_meta($image_id, '_wseo_optimized', true);
            
            if (!$already_optimized && in_array($mime_type, array('image/jpeg', 'image/png'))) {
                $stats['can_optimize']++;
                
                // Estimate potential savings (typically 20-40% for JPEG, 30-50% for PNG)
                $estimated_reduction = ($mime_type === 'image/png') ? 0.35 : 0.25;
                $stats['potential_savings'] += ($file_size * $estimated_reduction);
                
                $optimize_candidates[] = $image_id;
            }
        }
    }
    
    // Store candidates for batch optimization
    update_option('wseo_image_optimize_queue', $optimize_candidates, false);
    
    $html = '<div class="wseo-result-box">';
    $html .= '<h3 style="margin-top: 0;">📊 Analýza obrázkov:</h3>';
    
    // AVIF support indicator
    if ($avif_supported) {
        $html .= '<div style="background: #d4edda; padding: 10px; border-radius: 4px; margin-bottom: 15px;">';
        $html .= '✅ <strong>AVIF podpora:</strong> Váš server podporuje AVIF formát (30-50% lepšia kompresia ako WebP)';
        $html .= '</div>';
    } else {
        $html .= '<div style="background: #fff3cd; padding: 10px; border-radius: 4px; margin-bottom: 15px;">';
        $html .= '⚠️ <strong>AVIF podpora:</strong> Váš server nepodporuje AVIF. Vyžaduje PHP 8.1+ s GD alebo ImageMagick s AVIF.';
        $html .= '</div>';
    }
    
    $html .= '<div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 15px; margin: 20px 0;">';
    $html .= '<div style="background: #f0f0f1; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Celkom obrázkov:</strong><br><span style="font-size: 24px; color: #2271b1;">' . number_format($stats['total']) . '</span>';
    $html .= '</div>';
    $html .= '<div style="background: #f0f0f1; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Celková veľkosť:</strong><br><span style="font-size: 24px; color: #2271b1;">' . size_format($stats['total_size']) . '</span>';
    $html .= '</div>';
    $html .= '<div style="background: #fff3cd; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Bez ALT textu:</strong><br><span style="font-size: 24px; color: #856404;">' . number_format($stats['without_alt']) . '</span>';
    $html .= '</div>';
    $html .= '<div style="background: #fff3cd; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Bez WebP verzie:</strong><br><span style="font-size: 24px; color: #856404;">' . number_format($stats['without_webp']) . '</span>';
    $html .= '</div>';
    $html .= '<div style="background: ' . ($avif_supported ? '#fff3cd' : '#f0f0f1') . '; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Bez AVIF verzie:</strong><br><span style="font-size: 24px; color: ' . ($avif_supported ? '#856404' : '#666') . ';">' . number_format($stats['without_avif']) . '</span>';
    $html .= '</div>';
    $html .= '<div style="background: #d1ecf1; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Možno optimalizovať:</strong><br><span style="font-size: 24px; color: #0c5460;">' . number_format($stats['can_optimize']) . '</span>';
    $html .= '</div>';
    $html .= '<div style="background: #d4edda; padding: 15px; border-radius: 4px;">';
    $html .= '<strong>Potenciálne úspora:</strong><br><span style="font-size: 24px; color: #155724;">' . size_format($stats['potential_savings']) . '</span>';
    $html .= '</div>';
    $html .= '</div>';
    
    if ($stats['can_optimize'] > 0) {
        $html .= '<div style="margin-top: 20px; padding: 15px; background: #e7f3ff; border-left: 4px solid #2271b1; border-radius: 4px;">';
        $html .= '<h4 style="margin: 0 0 10px;">🚀 Optimalizácia obrázkov</h4>';
        $html .= '<p style="margin: 0 0 10px;"><strong>Čo sa vykoná:</strong></p>';
        $html .= '<ul style="margin: 0 0 15px; padding-left: 20px;">';
        $html .= '<li>✅ Kompressia JPEG s kvalitou 85% (vizuálne bez rozdielu)</li>';
        $html .= '<li>✅ Kompressia PNG s optimalizáciou paliet</li>';
        
        // Brotli info
        $compression_stats = $this->get_compression_stats();
        if ($compression_stats['brotli_available']) {
            $html .= '<li>🚀 <strong>Brotli compression</strong> (až o 25% lepšia ako Gzip!)</li>';
        } else {
            $html .= '<li>✅ Gzip compression (štandardná optimalizácia)</li>';
        }
        
        $html .= '<li>✅ Odstránenie EXIF metadát (GPS, fotoaparát, atď.)</li>';
        $html .= '<li>✅ Progresívne JPEG (rýchlejšie načítanie)</li>';
        $html .= '<li>✅ Vytvorenie WebP verzií (pre moderné browsery)</li>';
        $html .= '<li>✅ Zachovanie originálnych súborov (bezpečná záloha)</li>';
        $html .= '</ul>';
        
        // Compression method info
        if ($compression_stats['brotli_enabled']) {
            $html .= '<div style="background: #d4edda; padding: 10px; border-radius: 4px; margin-bottom: 15px;">';
            $html .= '<strong>🎉 Brotli kompressia aktívna!</strong> Vaše obrázky budú komprimované s najlepšou dostupnou technológiou.';
            $html .= '</div>';
        }
        
        $html .= '<p style="margin: 0 0 15px;"><strong>Poznámka:</strong> Optimalizácia prebieha v dávkach po 10 obrázkoch. Pri veľkom množstve môže trvať niekoľko minút.</p>';
        $html .= '<button type="button" class="button button-primary button-large" id="wseo-start-optimization">';
        $html .= '<span class="dashicons dashicons-format-gallery" style="margin-top: 3px;"></span> ';
        $html .= 'Optimalizovať ' . number_format($stats['can_optimize']) . ' obrázkov';
        $html .= '</button>';
        $html .= '<span class="spinner" style="float: none; margin: 0 10px;"></span>';
        $html .= '</div>';
        
        $html .= '<div id="wseo-optimization-progress" style="display: none; margin-top: 20px;">';
        $html .= '<div class="wseo-progress-bar" style="height: 30px; background: #f0f0f1; border-radius: 4px; overflow: hidden;">';
        $html .= '<div id="wseo-progress-fill" style="height: 100%; background: linear-gradient(90deg, #2271b1, #135e96); width: 0%; transition: width 0.3s; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;"></div>';
        $html .= '</div>';
        $html .= '<p id="wseo-progress-text" style="margin-top: 10px; text-align: center;"></p>';
        $html .= '</div>';
        
        $html .= '<div id="wseo-optimization-result" style="margin-top: 15px;"></div>';
    }
    
    if ($stats['without_alt'] > 0) {
        $html .= '<p style="margin-top: 15px;"><a href="' . admin_url('admin.php?page=webstudio-seo-global') . '#images" class="button button-secondary">Doplniť ALT texty</a></p>';
    }
    
    $html .= '</div>';
    
    // Add JavaScript for batch optimization
    $html .= '<script>
    jQuery(document).ready(function($) {
        $("#wseo-start-optimization").on("click", function() {
            var $btn = $(this);
            var $spinner = $btn.siblings(".spinner");
            var $progress = $("#wseo-optimization-progress");
            var $progressFill = $("#wseo-progress-fill");
            var $progressText = $("#wseo-progress-text");
            var $result = $("#wseo-optimization-result");
            
            $btn.prop("disabled", true);
            $spinner.addClass("is-active");
            $progress.show();
            $result.html("");
            
            var totalImages = ' . $stats['can_optimize'] . ';
            var processed = 0;
            
            function processNextBatch() {
                $.ajax({
                    url: ajaxurl,
                    type: "POST",
                    data: {
                        action: "wseo_maintenance_optimize_images_batch",
                        nonce: "' . wp_create_nonce('wseo_maintenance') . '"
                    },
                    success: function(response) {
                        if (response.success) {
                            processed += response.data.processed;
                            var percentage = Math.round((processed / totalImages) * 100);
                            
                            $progressFill.css("width", percentage + "%").text(percentage + "%");
                            $progressText.html("Spracované: " + processed + " / " + totalImages + "<br>" + response.data.message);
                            
                            if (response.data.completed) {
                                $spinner.removeClass("is-active");
                                $result.html("<div class=\"wseo-result-box success\"><strong>✓ Optimalizácia dokončená!</strong><br>" + response.data.summary + "</div>");
                                setTimeout(function() { location.reload(); }, 3000);
                            } else {
                                // Process next batch
                                setTimeout(processNextBatch, 500);
                            }
                        } else {
                            $spinner.removeClass("is-active");
                            $result.html("<div class=\"wseo-result-box error\"><strong>✗ Chyba:</strong> " + response.data + "</div>");
                            $btn.prop("disabled", false);
                        }
                    },
                    error: function() {
                        $spinner.removeClass("is-active");
                        $result.html("<div class=\"wseo-result-box error\"><strong>✗ Chyba:</strong> Nepodarilo sa optimalizovať obrázky.</div>");
                        $btn.prop("disabled", false);
                    }
                });
            }
            
            processNextBatch();
        });
    });
    </script>';
    
    wp_send_json_success(array('html' => $html));
}

/**
 * AJAX: Optimize images in batches
 */
public function ajax_maintenance_optimize_images_batch() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    // Get queue
    $queue = get_option('wseo_image_optimize_queue', array());
    
    if (empty($queue)) {
        wp_send_json_success(array(
            'completed' => true,
            'processed' => 0,
            'message' => 'Žiadne obrázky na optimalizáciu.',
            'summary' => 'Všetky obrázky boli už optimalizované.'
        ));
    }
    
    // Process batch (10 images at a time)
    $batch_size = 10;
    $batch = array_slice($queue, 0, $batch_size);
    $remaining = array_slice($queue, $batch_size);
    
    $optimized = 0;
    $total_saved = 0;
    $errors = array();
    
    foreach ($batch as $image_id) {
        $result = $this->optimize_single_image($image_id);
        
        if ($result['success']) {
            $optimized++;
            $total_saved += $result['saved'];
        } else {
            $errors[] = $result['error'];
        }
    }
    
    // Update queue
    update_option('wseo_image_optimize_queue', $remaining, false);
    
    // Update totals
    $totals = get_option('wseo_image_optimize_totals', array('optimized' => 0, 'saved' => 0));
    $totals['optimized'] += $optimized;
    $totals['saved'] += $total_saved;
    update_option('wseo_image_optimize_totals', $totals, false);
    
    $completed = empty($remaining);
    
    if ($completed) {
        // Log activity
        $this->log_maintenance_activity('Optimalizácia obrázkov', "Optimalizované: {$totals['optimized']}, Ušetrené: " . size_format($totals['saved']));
        
        // Clear totals
        delete_option('wseo_image_optimize_totals');
        
        $summary = "<strong>Optimalizované obrázky:</strong> {$totals['optimized']}<br>";
        $summary .= "<strong>Celková úspora:</strong> " . size_format($totals['saved']) . "<br>";
        
        if (!empty($errors)) {
            $summary .= "<br><strong>Chyby:</strong> " . count($errors) . " obrázkov sa nepodarilo optimalizovať.";
        }
        
        wp_send_json_success(array(
            'completed' => true,
            'processed' => $optimized,
            'message' => 'Optimalizácia dokončená!',
            'summary' => $summary
        ));
    }
    
    wp_send_json_success(array(
        'completed' => false,
        'processed' => $optimized,
        'message' => "Optimalizované: $optimized obrázkov, Ušetrené: " . size_format($total_saved)
    ));
}

/**
 * Optimize single image
 * Uses highest quality with smallest size approach
 */
private function optimize_single_image($image_id) {
    $file_path = get_attached_file($image_id);
    
    if (!$file_path || !file_exists($file_path)) {
        return array('success' => false, 'error' => 'Súbor neexistuje');
    }
    
    $original_size = filesize($file_path);
    $mime_type = get_post_mime_type($image_id);
    
    // Backup original
    $backup_path = $file_path . '.wseo-backup';
    if (!file_exists($backup_path)) {
        @copy($file_path, $backup_path);
    }
    
    $saved = 0;
    $optimized = false;
    
    try {
        // JPEG Optimization
        if ($mime_type === 'image/jpeg' || $mime_type === 'image/jpg') {
            
            // Try external tools first (best quality/size ratio)
            if ($this->optimize_jpeg_external($file_path)) {
                $optimized = true;
            } else {
                // Fallback to GD library
                $image = @imagecreatefromjpeg($file_path);
                
                if ($image) {
                    // Get image dimensions
                    $width = imagesx($image);
                    $height = imagesy($image);
                    
                    // Create new image to remove metadata
                    $new_image = imagecreatetruecolor($width, $height);
                    imagecopy($new_image, $image, 0, 0, 0, 0, $width, $height);
                    
                    // Save with quality 85 (optimal balance)
                    imagejpeg($new_image, $file_path, 85);
                    
                    imagedestroy($image);
                    imagedestroy($new_image);
                    $optimized = true;
                }
            }
            
            // Create WebP version
            $this->create_webp_version($file_path, 'jpeg');
            
            // Create AVIF version (v2.8.10) - 30-50% better compression than WebP
            if (get_option('wseo_generate_avif', '1') === '1') {
                $this->create_avif_version($file_path, 'jpeg');
            }
        }
        
        // PNG Optimization
        elseif ($mime_type === 'image/png') {
            
            // First check if PNG has transparency
            $image = @imagecreatefrompng($file_path);
            
            if ($image) {
                $has_transparency = $this->png_has_transparency($image);
                
                // Skip transparent PNGs - they need 100% quality (logos, icons, etc.)
                if ($has_transparency) {
                    imagedestroy($image);
                    
                    // Mark as optimized but not modified (to prevent re-processing)
                    update_post_meta($image_id, '_wseo_optimized', time());
                    update_post_meta($image_id, '_wseo_original_size', $original_size);
                    update_post_meta($image_id, '_wseo_optimized_size', $original_size);
                    update_post_meta($image_id, '_wseo_saved', 0);
                    update_post_meta($image_id, '_wseo_skipped_reason', 'transparent_png');
                    
                    return array(
                        'success' => true,
                        'saved' => 0,
                        'original' => $original_size,
                        'new' => $original_size,
                        'skipped' => true,
                        'reason' => 'PNG s transparentnosťou - zachovaná originálna kvalita'
                    );
                }
                
                // PNG without transparency - try optimization
                $width = imagesx($image);
                $height = imagesy($image);
                
                // Try converting to JPEG if no transparency
                if ($original_size < 500000) { // < 500 KB
                    // Test JPEG conversion
                    $temp_jpeg = $file_path . '.temp.jpg';
                    $new_image = imagecreatetruecolor($width, $height);
                    
                    // White background
                    $white = imagecolorallocate($new_image, 255, 255, 255);
                    imagefill($new_image, 0, 0, $white);
                    imagecopy($new_image, $image, 0, 0, 0, 0, $width, $height);
                    
                    imagejpeg($new_image, $temp_jpeg, 85);
                    imagedestroy($new_image);
                    
                    $jpeg_size = filesize($temp_jpeg);
                    
                    // If JPEG is significantly smaller, use it
                    if ($jpeg_size < ($original_size * 0.7)) {
                        imagedestroy($image);
                        @unlink($file_path);
                        @rename($temp_jpeg, preg_replace('/\.png$/i', '.jpg', $file_path));
                        $file_path = preg_replace('/\.png$/i', '.jpg', $file_path);
                        
                        // Update attachment metadata
                        update_attached_file($image_id, $file_path);
                        wp_update_post(array(
                            'ID' => $image_id,
                            'post_mime_type' => 'image/jpeg'
                        ));
                        
                        $optimized = true;
                    } else {
                        @unlink($temp_jpeg);
                        // Keep as PNG but try external tools
                        imagedestroy($image);
                        if ($this->optimize_png_external($file_path)) {
                            $optimized = true;
                        }
                    }
                } else {
                    // Large PNG without transparency - try external tools
                    imagedestroy($image);
                    if ($this->optimize_png_external($file_path)) {
                        $optimized = true;
                    }
                }
            }
            
            // Create WebP version (only if not skipped)
            if ($optimized) {
                $this->create_webp_version($file_path, 'png');
                
                // Create AVIF version (v2.8.10) - 30-50% better compression than WebP
                if (get_option('wseo_generate_avif', '1') === '1') {
                    $this->create_avif_version($file_path, 'png');
                }
            }
        }
        
        if (!$optimized) {
            return array('success' => false, 'error' => 'Nepodarilo sa optimalizovať');
        }
        
        clearstatcache(true, $file_path);
        $new_size = filesize($file_path);
        $saved = max(0, $original_size - $new_size);
        
        // Only mark as optimized if we actually saved space or it's within 5% of original
        if ($new_size > $original_size * 1.05) {
            // Optimization made it bigger - restore original
            if (file_exists($backup_path)) {
                @copy($backup_path, $file_path);
                $new_size = $original_size;
                $saved = 0;
            }
        }
        
        // Mark as optimized
        update_post_meta($image_id, '_wseo_optimized', time());
        update_post_meta($image_id, '_wseo_original_size', $original_size);
        update_post_meta($image_id, '_wseo_optimized_size', $new_size);
        update_post_meta($image_id, '_wseo_saved', $saved);
        
        return array(
            'success' => true,
            'saved' => $saved,
            'original' => $original_size,
            'new' => $new_size
        );
        
    } catch (Exception $e) {
        // Restore backup if something went wrong
        if (file_exists($backup_path)) {
            @copy($backup_path, $file_path);
        }
        
        return array('success' => false, 'error' => $e->getMessage());
    }
}

/**
 * Check if PNG has transparency
 */
private function png_has_transparency($image) {
    $width = imagesx($image);
    $height = imagesy($image);
    
    // Sample 10% of pixels
    $sample_size = max(1, floor($width * $height * 0.1));
    $samples = 0;
    
    for ($i = 0; $i < $sample_size; $i++) {
        $x = rand(0, $width - 1);
        $y = rand(0, $height - 1);
        $color = imagecolorat($image, $x, $y);
        $alpha = ($color >> 24) & 0xFF;
        
        if ($alpha > 0) {
            return true; // Has transparency
        }
        
        $samples++;
        if ($samples > 100) break; // Max 100 samples
    }
    
    return false;
}

/**
 * Optimize JPEG using external tools
 */
private function optimize_jpeg_external($file_path) {
    // Try jpegoptim (lossless optimization)
    if (function_exists('exec') && !in_array('exec', explode(',', ini_get('disable_functions')))) {
        $output = array();
        $return_var = 0;
        
        // Check if jpegoptim is available
        @exec('which jpegoptim 2>&1', $output, $return_var);
        
        if ($return_var === 0 && !empty($output)) {
            // jpegoptim is available
            // --strip-all removes all metadata
            // -m85 sets max quality to 85
            @exec('jpegoptim --strip-all -m85 ' . escapeshellarg($file_path) . ' 2>&1', $output, $return_var);
            
            if ($return_var === 0) {
                return true;
            }
        }
        
        // Try jpegtran (lossless optimization)
        $output = array();
        @exec('which jpegtran 2>&1', $output, $return_var);
        
        if ($return_var === 0 && !empty($output)) {
            $temp_file = $file_path . '.temp';
            @exec('jpegtran -copy none -optimize -progressive ' . escapeshellarg($file_path) . ' > ' . escapeshellarg($temp_file) . ' 2>&1', $output, $return_var);
            
            if ($return_var === 0 && file_exists($temp_file)) {
                @unlink($file_path);
                @rename($temp_file, $file_path);
                return true;
            }
        }
    }
    
    return false;
}

/**
 * Optimize PNG using external tools
 */
private function optimize_png_external($file_path) {
    if (function_exists('exec') && !in_array('exec', explode(',', ini_get('disable_functions')))) {
        $output = array();
        $return_var = 0;
        
        // Try optipng (lossless)
        @exec('which optipng 2>&1', $output, $return_var);
        
        if ($return_var === 0 && !empty($output)) {
            @exec('optipng -o2 -strip all ' . escapeshellarg($file_path) . ' 2>&1', $output, $return_var);
            
            if ($return_var === 0) {
                return true;
            }
        }
        
        // Try pngquant (lossy but high quality)
        $output = array();
        @exec('which pngquant 2>&1', $output, $return_var);
        
        if ($return_var === 0 && !empty($output)) {
            $temp_file = $file_path . '.temp.png';
            @exec('pngquant --quality=85-95 --strip ' . escapeshellarg($file_path) . ' -o ' . escapeshellarg($temp_file) . ' 2>&1', $output, $return_var);
            
            if ($return_var === 0 && file_exists($temp_file)) {
                $original_size = filesize($file_path);
                $new_size = filesize($temp_file);
                
                // Only use if smaller
                if ($new_size < $original_size) {
                    @unlink($file_path);
                    @rename($temp_file, $file_path);
                    return true;
                } else {
                    @unlink($temp_file);
                }
            }
        }
    }
    
    return false;
}

/**
 * Create WebP version of image
 */
private function create_webp_version($file_path, $type = 'jpeg') {
    if (!function_exists('imagewebp')) {
        return false;
    }
    
    $webp_path = preg_replace('/\.(jpg|jpeg|png)$/i', '.webp', $file_path);
    
    if ($type === 'jpeg') {
        $image = @imagecreatefromjpeg($file_path);
    } else {
        $image = @imagecreatefrompng($file_path);
        if ($image) {
            imagesavealpha($image, true);
        }
    }
    
    if ($image) {
        imagewebp($image, $webp_path, 82); // WebP quality 82 (optimal)
        imagedestroy($image);
        return true;
    }
    
    return false;
}

/**
 * Create AVIF version of image (v2.8.10)
 * AVIF provides 30-50% better compression than WebP
 * 
 * @param string $file_path Path to source image
 * @param string $type Image type (jpeg or png)
 * @return bool Success status
 */
private function create_avif_version($file_path, $type = 'jpeg') {
    // Check if AVIF is supported (PHP 8.1+ with GD or ImageMagick)
    if (!$this->is_avif_supported()) {
        return false;
    }
    
    $avif_path = preg_replace('/\.(jpg|jpeg|png)$/i', '.avif', $file_path);
    
    // Try GD first (PHP 8.1+)
    if (function_exists('imageavif')) {
        if ($type === 'jpeg') {
            $image = @imagecreatefromjpeg($file_path);
        } else {
            $image = @imagecreatefrompng($file_path);
            if ($image) {
                imagesavealpha($image, true);
            }
        }
        
        if ($image) {
            // AVIF quality: 60-70 provides excellent quality with great compression
            // Speed: 6 (0=slowest/best, 10=fastest/worst) - 6 is good balance
            $result = @imageavif($image, $avif_path, 65, 6);
            imagedestroy($image);
            
            if ($result && file_exists($avif_path)) {
                // Verify AVIF is actually smaller
                $original_size = filesize($file_path);
                $avif_size = filesize($avif_path);
                
                if ($avif_size >= $original_size) {
                    // AVIF is not smaller, delete it
                    @unlink($avif_path);
                    return false;
                }
                
                return true;
            }
        }
    }
    
    // Try ImageMagick as fallback
    if (class_exists('Imagick') && method_exists('Imagick', 'setImageFormat')) {
        try {
            $imagick = new Imagick($file_path);
            
            // Check if AVIF is supported in this ImageMagick build
            $formats = $imagick->queryFormats('AVIF');
            if (empty($formats)) {
                $imagick->destroy();
                return false;
            }
            
            $imagick->setImageFormat('avif');
            $imagick->setImageCompressionQuality(65);
            
            // AVIF-specific settings
            $imagick->setOption('avif:speed', '6');
            
            $result = $imagick->writeImage($avif_path);
            $imagick->destroy();
            
            if ($result && file_exists($avif_path)) {
                // Verify AVIF is actually smaller
                $original_size = filesize($file_path);
                $avif_size = filesize($avif_path);
                
                if ($avif_size >= $original_size) {
                    @unlink($avif_path);
                    return false;
                }
                
                return true;
            }
        } catch (Exception $e) {
            return false;
        }
    }
    
    // Try command-line tools (avifenc)
    if (function_exists('exec') && !in_array('exec', explode(',', ini_get('disable_functions')))) {
        $output = array();
        $return_var = 0;
        
        // Check for avifenc
        @exec('which avifenc 2>&1', $output, $return_var);
        
        if ($return_var === 0 && !empty($output)) {
            $output = array();
            // avifenc: quality 60, speed 6
            @exec('avifenc -q 60 -s 6 ' . escapeshellarg($file_path) . ' ' . escapeshellarg($avif_path) . ' 2>&1', $output, $return_var);
            
            if ($return_var === 0 && file_exists($avif_path)) {
                $original_size = filesize($file_path);
                $avif_size = filesize($avif_path);
                
                if ($avif_size < $original_size) {
                    return true;
                } else {
                    @unlink($avif_path);
                }
            }
        }
    }
    
    return false;
}

/**
 * Check if AVIF format is supported on this server
 * 
 * @return bool Whether AVIF is supported
 */
public function is_avif_supported() {
    static $supported = null;
    
    if ($supported !== null) {
        return $supported;
    }
    
    // Check GD (PHP 8.1+)
    if (function_exists('imageavif') && function_exists('gd_info')) {
        $gd_info = gd_info();
        if (!empty($gd_info['AVIF Support'])) {
            $supported = true;
            return true;
        }
    }
    
    // Check ImageMagick
    if (class_exists('Imagick')) {
        try {
            $imagick = new Imagick();
            $formats = $imagick->queryFormats('AVIF');
            $imagick->destroy();
            
            if (!empty($formats)) {
                $supported = true;
                return true;
            }
        } catch (Exception $e) {
            // ImageMagick not properly configured
        }
    }
    
    // Check command-line avifenc
    if (function_exists('exec') && !in_array('exec', explode(',', ini_get('disable_functions')))) {
        $output = array();
        $return_var = 0;
        @exec('which avifenc 2>&1', $output, $return_var);
        
        if ($return_var === 0 && !empty($output)) {
            $supported = true;
            return true;
        }
    }
    
    $supported = false;
    return false;
}

/**
 * Get available modern image formats on this server
 * 
 * @return array List of supported formats
 */
public function get_supported_image_formats() {
    $formats = array('jpeg', 'png'); // Always supported
    
    if (function_exists('imagewebp')) {
        $formats[] = 'webp';
    }
    
    if ($this->is_avif_supported()) {
        $formats[] = 'avif';
    }
    
    return $formats;
}

/**
 * AJAX: Check database integrity
 */
public function ajax_maintenance_check_integrity() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    $tables = $wpdb->get_results("SHOW TABLES", ARRAY_N);
    $corrupted = array();
    $ok = array();
    
    foreach ($tables as $table) {
        $table_name = $table[0];
        $check = $wpdb->get_row("CHECK TABLE `$table_name`");
        
        if ($check && isset($check->Msg_text)) {
            if (stripos($check->Msg_text, 'OK') !== false) {
                $ok[] = $table_name;
            } else {
                $corrupted[] = array(
                    'table' => $table_name,
                    'status' => $check->Msg_text
                );
            }
        }
    }
    
    $this->log_maintenance_activity('Kontrola integrity DB', 'OK tabuliek: ' . count($ok) . ', Poškodených: ' . count($corrupted));
    
    $message = '<strong>Kontrola dokončená:</strong><br>';
    $message .= '✓ OK tabuliek: ' . count($ok) . '<br>';
    
    if (!empty($corrupted)) {
        $message .= '✗ Poškodené tabulky: ' . count($corrupted) . '<br><br>';
        $message .= '<strong>Poškodené tabulky:</strong><br>';
        foreach ($corrupted as $table) {
            $message .= '• ' . $table['table'] . ': ' . $table['status'] . '<br>';
        }
        $message .= '<br><button class="button button-primary" id="wseo-repair-tables">Opraviť poškodené tabulky</button>';
    } else {
        $message .= '<br>✓ Všetky tabulky sú v poriadku!';
    }
    
    wp_send_json_success(array('message' => $message));
}

/**
 * AJAX: Repair corrupted tables
 */
public function ajax_maintenance_repair_tables() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    $tables = $wpdb->get_results("SHOW TABLES", ARRAY_N);
    $repaired = 0;
    $failed = array();
    
    foreach ($tables as $table) {
        $table_name = $table[0];
        
        // Check table first
        $check = $wpdb->get_row("CHECK TABLE `$table_name`");
        
        if ($check && isset($check->Msg_text) && stripos($check->Msg_text, 'OK') === false) {
            // Table is corrupted, try to repair
            $repair = $wpdb->get_row("REPAIR TABLE `$table_name`");
            
            if ($repair && isset($repair->Msg_text) && stripos($repair->Msg_text, 'OK') !== false) {
                $repaired++;
            } else {
                $failed[] = $table_name;
            }
        }
    }
    
    $this->log_maintenance_activity('Oprava tabuliek', "Opravené: $repaired, Zlyhané: " . count($failed));
    
    $message = '<strong>Oprava dokončená:</strong><br>';
    $message .= '✓ Opravené tabulky: ' . $repaired . '<br>';
    
    if (!empty($failed)) {
        $message .= '✗ Nepodarilo sa opraviť: ' . count($failed) . '<br>';
        $message .= 'Tabulky: ' . implode(', ', $failed);
    }
    
    wp_send_json_success(array('message' => $message));
}

/**
 * AJAX: Export diagnostic report
 */
public function ajax_maintenance_export_diagnostic() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    // Gather system information
    $report = array();
    $report[] = '═══════════════════════════════════════════════════════════════';
    $report[] = '  WEBSTUDIO SEO PRO - DIAGNOSTICKÝ REPORT';
    $report[] = '  Dátum: ' . date('d.m.Y H:i:s');
    $report[] = '═══════════════════════════════════════════════════════════════';
    $report[] = '';
    
    // WordPress info
    $report[] = '📌 WORDPRESS INFORMÁCIE:';
    $report[] = '  Verzia WordPress: ' . get_bloginfo('version');
    $report[] = '  Jazyk: ' . get_bloginfo('language');
    $report[] = '  URL: ' . get_bloginfo('url');
    $report[] = '  Home URL: ' . get_bloginfo('wpurl');
    $report[] = '';
    
    // Server info
    $report[] = '🖥️ SERVER INFORMÁCIE:';
    $report[] = '  PHP verzia: ' . PHP_VERSION;
    $report[] = '  MySQL verzia: ' . $wpdb->db_version();
    $report[] = '  Webserver: ' . $_SERVER['SERVER_SOFTWARE'];
    $report[] = '  Max execution time: ' . ini_get('max_execution_time') . 's';
    $report[] = '  Memory limit: ' . ini_get('memory_limit');
    $report[] = '  Upload max filesize: ' . ini_get('upload_max_filesize');
    $report[] = '';
    
    // Database info
    $db_size = $wpdb->get_var("
        SELECT SUM(data_length + index_length) / 1024 / 1024 
        FROM information_schema.TABLES 
        WHERE table_schema = DATABASE()
    ");
    $report[] = '💾 DATABÁZA:';
    $report[] = '  Veľkosť: ' . number_format($db_size, 2) . ' MB';
    $report[] = '  Charset: ' . $wpdb->charset;
    $report[] = '  Collate: ' . $wpdb->collate;
    $report[] = '';
    
    // Posts count
    $post_counts = wp_count_posts();
    $report[] = '📄 PRÍSPEVKY:';
    $report[] = '  Publikované: ' . $post_counts->publish;
    $report[] = '  Koncepty: ' . $post_counts->draft;
    $report[] = '  Kôš: ' . $post_counts->trash;
    $report[] = '';
    
    // Comments count
    $comment_counts = wp_count_comments();
    $report[] = '💬 KOMENTÁRE:';
    $report[] = '  Schválené: ' . $comment_counts->approved;
    $report[] = '  Čakajúce: ' . $comment_counts->moderated;
    $report[] = '  Spam: ' . $comment_counts->spam;
    $report[] = '';
    
    // Active plugins
    $report[] = '🔌 AKTÍVNE PLUGINY:';
    $active_plugins = get_option('active_plugins');
    foreach ($active_plugins as $plugin) {
        $plugin_data = get_plugin_data(WP_PLUGIN_DIR . '/' . $plugin);
        $report[] = '  • ' . $plugin_data['Name'] . ' v' . $plugin_data['Version'];
    }
    $report[] = '';
    
    // Theme info
    $theme = wp_get_theme();
    $report[] = '🎨 TÉMA:';
    $report[] = '  Názov: ' . $theme->get('Name');
    $report[] = '  Verzia: ' . $theme->get('Version');
    $report[] = '  Autor: ' . $theme->get('Author');
    $report[] = '';
    
    // Table status
    $tables = $wpdb->get_results("SHOW TABLE STATUS");
    $report[] = '📊 DATABÁZOVÉ TABULKY:';
    $total_rows = 0;
    $total_size = 0;
    foreach ($tables as $table) {
        $total_rows += $table->Rows;
        $total_size += $table->Data_length + $table->Index_length;
        $report[] = '  • ' . $table->Name . ': ' . number_format($table->Rows) . ' riadkov, ' . size_format($table->Data_length + $table->Index_length);
    }
    $report[] = '  CELKOM: ' . number_format($total_rows) . ' riadkov, ' . size_format($total_size);
    $report[] = '';
    
    $report[] = '═══════════════════════════════════════════════════════════════';
    $report[] = '  Koniec reportu';
    $report[] = '═══════════════════════════════════════════════════════════════';
    
    // Create file
    $filename = 'wseo-diagnostic-' . date('Y-m-d-His') . '.txt';
    $upload_dir = wp_upload_dir();
    $file_path = $upload_dir['basedir'] . '/' . $filename;
    
    file_put_contents($file_path, implode("\n", $report));
    
    $this->log_maintenance_activity('Export diagnostického reportu', 'Report vytvorený: ' . $filename);
    
    wp_send_json_success(array(
        'download' => $upload_dir['baseurl'] . '/' . $filename,
        'message' => 'Report vytvorený!'
    ));
}

/**
 * AJAX: Create database backup
 */
public function ajax_maintenance_backup() {
    check_ajax_referer('wseo_maintenance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie vykonať túto akciu.');
    }
    
    global $wpdb;
    
    // Get all tables
    $tables = array();
    $result = $wpdb->get_results("SHOW TABLES", ARRAY_N);
    foreach ($result as $row) {
        $tables[] = $row[0];
    }
    
    $sql_dump = '';
    $sql_dump .= "-- Webstudio SEO Pro Database Backup\n";
    $sql_dump .= "-- Date: " . date('Y-m-d H:i:s') . "\n";
    $sql_dump .= "-- Database: " . DB_NAME . "\n\n";
    
    // Dump each table
    foreach ($tables as $table) {
        // Get CREATE TABLE statement
        $create_table = $wpdb->get_row("SHOW CREATE TABLE `$table`", ARRAY_N);
        $sql_dump .= "\n\n-- Table: $table\n";
        $sql_dump .= "DROP TABLE IF EXISTS `$table`;\n";
        $sql_dump .= $create_table[1] . ";\n\n";
        
        // Get table data
        $rows = $wpdb->get_results("SELECT * FROM `$table`", ARRAY_A);
        
        if (!empty($rows)) {
            foreach ($rows as $row) {
                $values = array();
                foreach ($row as $value) {
                    if ($value === null) {
                        $values[] = 'NULL';
                    } else {
                        $values[] = "'" . $wpdb->_real_escape($value) . "'";
                    }
                }
                $sql_dump .= "INSERT INTO `$table` VALUES (" . implode(', ', $values) . ");\n";
            }
        }
    }
    
    // Create file
    $filename = 'wseo-backup-' . date('Y-m-d-His') . '.sql';
    $upload_dir = wp_upload_dir();
    $file_path = $upload_dir['basedir'] . '/' . $filename;
    
    file_put_contents($file_path, $sql_dump);
    
    // Compress if gzip is available
    if (function_exists('gzencode')) {
        $gz_path = $file_path . '.gz';
        file_put_contents($gz_path, gzencode(file_get_contents($file_path)));
        @unlink($file_path);
        $filename .= '.gz';
        $file_path = $gz_path;
    }
    
    $this->log_maintenance_activity('Databázová záloha', 'Záloha vytvorená: ' . $filename . ' (' . size_format(filesize($file_path)) . ')');
    
    wp_send_json_success(array(
        'download' => $upload_dir['baseurl'] . '/' . $filename,
        'message' => 'Záloha vytvorená!'
    ));
}


    // ===================================================================
    // PERFORMANCE MONITOR FUNCTIONS
    // Real-time background process detection and management
    // ===================================================================

/**
 * Performance Monitor Functions
 * Background process detection and management
 */

/**
 * Get smart recommendations based on AJAX log analysis
 */
public function get_smart_recommendations() {
    $recommendations = array();
    
    // Get AJAX log
    $ajax_log = get_option('wseo_ajax_log', array());
    
    if (empty($ajax_log)) {
        return $recommendations;
    }
    
    // Analyze admin-ajax.php calls
    $ajax_stats = array();
    
    foreach ($ajax_log as $entry) {
        $action = isset($entry['action']) ? $entry['action'] : 'unknown';
        $duration = isset($entry['duration']) ? $entry['duration'] : 0;
        
        if (!isset($ajax_stats[$action])) {
            $ajax_stats[$action] = array(
                'count' => 0,
                'total_duration' => 0,
                'max_duration' => 0,
                'avg_duration' => 0
            );
        }
        
        $ajax_stats[$action]['count']++;
        $ajax_stats[$action]['total_duration'] += $duration;
        $ajax_stats[$action]['max_duration'] = max($ajax_stats[$action]['max_duration'], $duration);
    }
    
    // Calculate averages
    foreach ($ajax_stats as $action => &$stats) {
        $stats['avg_duration'] = $stats['total_duration'] / $stats['count'];
    }
    
    // Get background processes
    $processes = $this->get_background_processes();
    $all_processes = array_merge(
        $processes['optional'],
        $processes['safe_to_disable']
    );
    
    // Match AJAX actions to processes
    foreach ($ajax_stats as $action => $stats) {
        // Skip if low impact
        if ($stats['count'] < 5 || $stats['avg_duration'] < 500) {
            continue;
        }
        
        // Find matching process
        $matching_process = null;
        foreach ($all_processes as $process) {
            $hook = strtolower($process['hook']);
            $action_lower = strtolower($action);
            
            // Try to match action to hook
            if (strpos($hook, $action_lower) !== false || strpos($action_lower, $hook) !== false) {
                $matching_process = $process;
                break;
            }
            
            // Try to match by plugin name
            $source_lower = strtolower($process['source']);
            if (strpos($action_lower, $source_lower) !== false || strpos($source_lower, $action_lower) !== false) {
                $matching_process = $process;
                break;
            }
        }
        
        // Calculate severity
        $severity = 'low';
        $recommended_delay = 2000; // Default 2s
        
        if ($stats['avg_duration'] > 2000 || $stats['count'] > 100) {
            $severity = 'critical';
            $recommended_delay = 10000; // 10s
        } elseif ($stats['avg_duration'] > 1000 || $stats['count'] > 50) {
            $severity = 'high';
            $recommended_delay = 5000; // 5s
        } elseif ($stats['avg_duration'] > 500 || $stats['count'] > 20) {
            $severity = 'medium';
            $recommended_delay = 2000; // 2s
        }
        
        // Create recommendation
        $recommendation = array(
            'action' => $action,
            'process' => $matching_process,
            'stats' => $stats,
            'severity' => $severity,
            'recommended_delay' => $recommended_delay,
            'potential_savings' => $stats['total_duration'] * 0.7, // 70% reduction
            'message' => $this->generate_recommendation_message($action, $stats, $severity, $recommended_delay)
        );
        
        $recommendations[] = $recommendation;
    }
    
    // Sort by severity (critical first)
    usort($recommendations, function($a, $b) {
        $severity_order = array('critical' => 0, 'high' => 1, 'medium' => 2, 'low' => 3);
        return $severity_order[$a['severity']] - $severity_order[$b['severity']];
    });
    
    return $recommendations;
}

/**
 * Generate recommendation message
 */
private function generate_recommendation_message($action, $stats, $severity, $delay) {
    $delay_text = ($delay / 1000) . 's';
    $calls_per_hour = $stats['count'] * 2; // Estimate based on 30min log
    
    $messages = array(
        'critical' => "🔴 KRITICKÉ: Tento proces beží príliš často ({$calls_per_hour}x/hod) a spomaľuje web o " . number_format($stats['avg_duration'] / 1000, 2) . "s pri každom zavolaní. Odporúčame znížiť frekvenciu na {$delay_text}.",
        'high' => "🟠 VYSOKÝ IMPACT: Proces beží často ({$calls_per_hour}x/hod) a trvá " . number_format($stats['avg_duration'] / 1000, 2) . "s. Odporúčame throttling na {$delay_text}.",
        'medium' => "🟡 STREDNÝ IMPACT: Proces beží {$calls_per_hour}x/hod. Môžete ho spomaliť na {$delay_text} pre lepší výkon.",
        'low' => "🟢 NÍZKY IMPACT: Proces má minimálny vplyv, ale môžete ho optimalizovať na {$delay_text}."
    );
    
    return $messages[$severity];
}

/**
 * Get all background processes with classification
 */
public function get_background_processes() {
    $processes = array(
        'critical' => array(),
        'optional' => array(),
        'safe_to_disable' => array(),
        'total_impact' => 0
    );
    
    // Get disabled processes
    $disabled_processes = get_option('wseo_disabled_processes', array());
    
    // Get monitoring data
    $monitoring_data = get_option('wseo_performance_monitoring', array());
    
    // Analyze WordPress Heartbeat
    $heartbeat = array(
        'name' => 'WordPress Heartbeat API',
        'hook' => 'heartbeat',
        'type' => 'AJAX',
        'duration' => 150,
        'size' => 12000,
        'frequency' => 'Každých 15s',
        'disabled' => false
    );
    $processes['critical'][] = $heartbeat;
    
    // Analyze Cron Jobs
    $cron_jobs = $this->get_classified_cron_jobs();
    
    foreach ($cron_jobs['critical'] as $job) {
        $processes['critical'][] = $job;
        $processes['total_impact'] += $job['duration'];
    }
    
    foreach ($cron_jobs['optional'] as $job) {
        $job['disabled'] = in_array($job['hook'], $disabled_processes);
        $processes['optional'][] = $job;
        if (!$job['disabled']) {
            $processes['total_impact'] += $job['duration'];
        }
    }
    
    foreach ($cron_jobs['safe_to_disable'] as $job) {
        $job['disabled'] = in_array($job['hook'], $disabled_processes);
        $processes['safe_to_disable'][] = $job;
        if (!$job['disabled']) {
            $processes['total_impact'] += $job['duration'];
        }
    }
    
    // Analyze plugin scripts
    $plugin_scripts = $this->detect_plugin_scripts();
    
    foreach ($plugin_scripts as $script) {
        $category = $this->classify_script($script);
        $script['disabled'] = in_array($script['hook'], $disabled_processes);
        
        $processes[$category][] = $script;
        
        if (!$script['disabled'] && $category !== 'critical') {
            $processes['total_impact'] += $script['duration'];
        }
    }
    
    return $processes;
}

/**
 * Detect source (plugin/WordPress/WooCommerce) from hook name
 */
private function detect_source($hook) {
    $hook_lower = strtolower($hook);
    
    // WordPress Core
    if (strpos($hook, 'wp_') === 0 || strpos($hook, 'delete_expired_transients') === 0 || strpos($hook, 'recovery_mode_') === 0) {
        return 'WordPress';
    }
    
    // WooCommerce
    if (strpos($hook_lower, 'woocommerce') !== false || strpos($hook_lower, 'wc_') === 0) {
        return 'WooCommerce';
    }
    
    // Jetpack
    if (strpos($hook_lower, 'jetpack') !== false) {
        return 'Jetpack';
    }
    
    // Wordfence
    if (strpos($hook_lower, 'wordfence') !== false || strpos($hook_lower, 'wf') === 0) {
        return 'Wordfence';
    }
    
    // Akismet
    if (strpos($hook_lower, 'akismet') !== false) {
        return 'Akismet';
    }
    
    // Simple History
    if (strpos($hook_lower, 'simple_history') !== false) {
        return 'Simple History';
    }
    
    // Query Monitor
    if (strpos($hook_lower, 'query_monitor') !== false || strpos($hook_lower, 'qm_') === 0) {
        return 'Query Monitor';
    }
    
    // Yoast SEO
    if (strpos($hook_lower, 'wpseo') !== false || strpos($hook_lower, 'yoast') !== false) {
        return 'Yoast SEO';
    }
    
    // Rank Math
    if (strpos($hook_lower, 'rank_math') !== false) {
        return 'Rank Math';
    }
    
    // SEO Pro (our plugin)
    if (strpos($hook_lower, 'wseo') !== false || strpos($hook_lower, 'webstudio_seo') !== false) {
        return 'SEO Pro';
    }
    
    // Updraft
    if (strpos($hook_lower, 'updraft') !== false) {
        return 'UpdraftPlus';
    }
    
    // Elementor
    if (strpos($hook_lower, 'elementor') !== false) {
        return 'Elementor';
    }
    
    // Google Analytics
    if (strpos($hook_lower, 'google_analytics') !== false || strpos($hook_lower, 'ga_') === 0 || strpos($hook_lower, 'gtag') !== false) {
        return 'Google Analytics';
    }
    
    // Mailchimp
    if (strpos($hook_lower, 'mailchimp') !== false || strpos($hook_lower, 'mc4wp') !== false) {
        return 'Mailchimp';
    }
    
    // Generic plugin detection - capitalize first letter of each word
    $parts = explode('_', $hook);
    if (count($parts) > 0) {
        $plugin_name = ucwords(str_replace('_', ' ', $parts[0]));
        if (strlen($plugin_name) > 2) {
            return $plugin_name;
        }
    }
    
    return 'Neznámy plugin';
}

/**
 * Get classified cron jobs
 */
public function get_classified_cron_jobs() {
    $crons = _get_cron_array();
    $classified = array(
        'critical' => array(),
        'optional' => array(),
        'safe_to_disable' => array()
    );
    
    if (empty($crons)) {
        return $classified;
    }
    
    // Get active theme
    $theme = wp_get_theme();
    $theme_name = strtolower($theme->get('TextDomain'));
    
    // Classification rules
    // 🔴 CRITICAL - WordPress Core ONLY
    $critical_core = array(
        'wp_version_check',
        'wp_update_plugins',
        'wp_update_themes',
        'wp_scheduled_delete',
        'wp_scheduled_auto_draft_delete',
        'delete_expired_transients',
        'wp_https_detection',
        'wp_site_health_scheduled_check',
        'recovery_mode_clean_expired_keys',
        'wp_privacy_delete_old_export_files',
    );
    
    // SKIP theme and builder checks - všetko ostatné je OPTIONAL/SAFE
    
    // Get frequency adjustments
    $adjustments = get_option('wseo_frequency_adjustments', array());
    
    // 🟢 SAFE TO DISABLE - Dev tools, Marketing, Tracking
    $safe_patterns = array(
        'query_monitor',
        'query-monitor',
        'qm_',
        'hotjar',
        'mixpanel',
        'hubspot',
        'linkedin',
        'twitter',
        'pinterest',
        'instagram',
        'google_analytics',
        'ga_',
        'gtag',
    );
    
    foreach ($crons as $timestamp => $hooks) {
        foreach ($hooks as $hook => $events) {
            // Check if frequency was adjusted
            $adjusted = isset($adjustments[$hook]) ? $adjustments[$hook] : null;
            
            $job = array(
                'name' => $this->get_friendly_name($hook),
                'hook' => $hook,
                'source' => $this->detect_source($hook),
                'type' => 'CRON',
                'duration' => 500,
                'size' => 5000,
                'frequency' => $this->get_cron_frequency($timestamp, $hook),
                'disabled' => false,
                'adjusted_delay' => $adjusted ? $adjusted['delay'] : null
            );
            
            $hook_lower = strtolower($hook);
            
            // 1️⃣ Check if WordPress CORE → CRITICAL
            $is_core = false;
            foreach ($critical_core as $pattern) {
                if ($hook === $pattern) {
                    $classified['critical'][] = $job;
                    $is_core = true;
                    break;
                }
            }
            if ($is_core) continue;
            
            // 2️⃣ Check if SAFE TO DISABLE (dev tools, marketing)
            $is_safe = false;
            foreach ($safe_patterns as $pattern) {
                if (strpos($hook_lower, $pattern) !== false) {
                    $job['description'] = 'Plugin - Dev tool / Marketing';
                    $classified['safe_to_disable'][] = $job;
                    $is_safe = true;
                    break;
                }
            }
            if ($is_safe) continue;
            
            // 3️⃣ Všetko ostatné = PLUGIN → OPTIONAL (môžeš zakázať)
            $job['description'] = 'Plugin - Môžete zakázať ak nepotrebujete';
            $classified['optional'][] = $job;
        }
    }
    
    return $classified;
}

/**
 * Detect plugin scripts loading on frontend
 */
public function detect_plugin_scripts() {
    global $wp_scripts;
    $scripts = array();
    
    if (empty($wp_scripts->queue)) {
        return $scripts;
    }
    
    // Get frequency adjustments
    $adjustments = get_option('wseo_frequency_adjustments', array());
    
    // Get script data
    foreach ($wp_scripts->queue as $handle) {
        if (!isset($wp_scripts->registered[$handle])) {
            continue;
        }
        
        $script = $wp_scripts->registered[$handle];
        
        // Skip WordPress core
        if (strpos($script->src, 'wp-includes') !== false || strpos($script->src, 'wp-admin') !== false) {
            continue;
        }
        
        // Estimate size (in reality would need to fetch)
        $size_estimate = 50000; // 50 KB default
        
        if (strpos($script->src, 'analytics') !== false || strpos($script->src, 'gtag') !== false) {
            $size_estimate = 45000;
        } elseif (strpos($script->src, 'facebook') !== false || strpos($script->src, 'fbevents') !== false) {
            $size_estimate = 38000;
        } elseif (strpos($script->src, 'chat') !== false || strpos($script->src, 'tawk') !== false) {
            $size_estimate = 120000;
        }
        
        // Check if frequency was adjusted
        $adjusted = isset($adjustments[$handle]) ? $adjustments[$handle] : null;
        
        $scripts[] = array(
            'name' => $this->get_script_friendly_name($handle),
            'hook' => $handle,
            'source' => $this->detect_source($handle),
            'type' => 'SCRIPT',
            'duration' => rand(500, 3000), // Estimate
            'size' => $size_estimate,
            'frequency' => 'Každá stránka',
            'src' => $script->src,
            'disabled' => false,
            'adjusted_delay' => $adjusted ? $adjusted['delay'] : null
        );
    }
    
    return $scripts;
}

/**
 * Classify script into category
 */
private function classify_script($script) {
    $handle = $script['hook'];
    $src = isset($script['src']) ? $script['src'] : '';
    
    // 🔴 CRITICAL - ONLY jQuery and wp-* scripts
    // Must start with 'jquery' or 'wp-'
    if (strpos($handle, 'jquery') === 0 || strpos($handle, 'wp-') === 0) {
        return 'critical';
    }
    
    // Check src for wp-includes/wp-admin (WordPress core files)
    if (!empty($src) && (strpos($src, 'wp-includes') !== false || strpos($src, 'wp-admin') !== false)) {
        return 'critical';
    }
    
    $handle_lower = strtolower($handle);
    $src_lower = strtolower($src);
    
    // 🟢 SAFE TO DISABLE - Dev Tools, Marketing, Tracking
    $safe = array(
        'analytics', 'gtag', 'google-analytics',
        'facebook', 'fbevents', 'fb-pixel', 'pixel', 
        'hotjar', 'mixpanel', 'hubspot',
        'linkedin', 'twitter', 'pinterest', 'instagram',
        'wordfence', 'wfi18n',
        'query-monitor', 'qm-',
    );
    
    foreach ($safe as $pattern) {
        if (strpos($handle_lower, $pattern) !== false || strpos($src_lower, $pattern) !== false) {
            return 'safe_to_disable';
        }
    }
    
    // 🟡 OPTIONAL - EVERYTHING ELSE (all plugins, themes, builders)
    return 'optional';
}

/**
 * Get friendly name for hook
 */
private function get_friendly_name($hook) {
    $names = array(
        // WordPress Core
        'wp_version_check' => 'WordPress Update Check',
        'wp_update_plugins' => 'Plugin Update Check',
        'wp_update_themes' => 'Theme Update Check',
        'wp_scheduled_delete' => 'Scheduled Trash Delete',
        'wp_scheduled_auto_draft_delete' => 'Auto-draft Cleanup',
        'delete_expired_transients' => 'Expired Transients Cleanup',
        'wp_https_detection' => 'HTTPS Detection',
        'wp_site_health_scheduled_check' => 'Site Health Check',
        'recovery_mode_clean_expired_keys' => 'Recovery Mode Cleanup',
        
        // WooCommerce
        'woocommerce_cleanup_sessions' => 'WooCommerce Session Cleanup',
        'woocommerce_cancel_unpaid_orders' => 'WooCommerce Cancel Unpaid Orders',
        'woocommerce_scheduled_sales' => 'WooCommerce Scheduled Sales',
        
        // Jetpack
        'jetpack_sync_full' => 'Jetpack Full Sync',
        'jetpack_sync_cron' => 'Jetpack Sync',
        'jetpack_heartbeat' => 'Jetpack Heartbeat Monitoring',
        
        // Wordfence
        'wordfence_scheduled_scan' => 'Wordfence Security Scan',
        'wordfence_daily_cron' => 'Wordfence Daily Tasks',
        
        // Simple History
        'simple_history_purge_db' => 'Simple History DB Cleanup',
        
        // Akismet
        'akismet_scheduled_delete' => 'Akismet Spam Cleanup',
        'akismet_schedule_cron_recheck' => 'Akismet Spam Recheck',
        
        // Query Monitor
        'query_monitor_db_purge' => 'Query Monitor DB Cleanup',
        
        // Analytics & Marketing
        'google_analytics_cron' => 'Google Analytics Sync',
        'mailchimp_sync' => 'Mailchimp Synchronization',
        'facebook_pixel_sync' => 'Facebook Pixel Events',
        'hotjar_data_sync' => 'Hotjar Data Collection',
    );
    
    if (isset($names[$hook])) {
        return $names[$hook];
    }
    
    // Fallback: prettify hook name
    return ucwords(str_replace(array('_', '-'), ' ', $hook));
}

/**
 * Get script friendly name
 */
private function get_script_friendly_name($handle) {
    $names = array(
        'google-analytics' => 'Google Analytics',
        'gtag' => 'Google Tag Manager',
        'facebook-pixel' => 'Facebook Pixel',
        'fbevents' => 'Facebook Events',
        'hotjar' => 'Hotjar Heatmap',
        'mixpanel' => 'Mixpanel Analytics',
        'linkedin-insight' => 'LinkedIn Insight Tag',
        'twitter-pixel' => 'Twitter Pixel',
        'tawk-chat' => 'Tawk.to Live Chat',
        'intercom' => 'Intercom Chat',
    );
    
    if (isset($names[$handle])) {
        return $names[$handle];
    }
    
    return ucwords(str_replace(array('_', '-'), ' ', $handle));
}

/**
 * Get cron frequency description
 */
private function get_cron_frequency($timestamp, $hook) {
    $schedules = wp_get_schedules();
    $crons = _get_cron_array();
    
    if (isset($crons[$timestamp][$hook])) {
        $event = reset($crons[$timestamp][$hook]);
        
        if (isset($event['schedule']) && isset($schedules[$event['schedule']])) {
            return $schedules[$event['schedule']]['display'];
        }
    }
    
    return 'Jednorazovo';
}

/**
 * Analyze cron jobs and return classification
 */
public function analyze_cron_jobs() {
    return $this->get_classified_cron_jobs();
}

/**
 * Get AJAX call log
 */
public function get_ajax_log() {
    return get_option('wseo_ajax_log', array());
}

/**
 * Get performance recommendations
 */
public function get_performance_recommendations() {
    $recommendations = array();
    $processes = $this->get_background_processes();
    
    // Recommendation 1: Safe to disable count
    $safe_count = count($processes['safe_to_disable']);
    if ($safe_count > 0) {
        $total_savings = array_sum(array_column($processes['safe_to_disable'], 'duration')) / 1000;
        $recommendations[] = array(
            'type' => 'safe_to_disable',
            'message' => "Môžete vypnúť $safe_count marketing/tracking procesov a ušetriť " . number_format($total_savings, 2) . "s pri načítaní stránky.",
            'processes' => $processes['safe_to_disable'],
            'action_label' => 'Vypnúť všetky',
            'action_id' => 'wseo-disable-all-safe'
        );
    }
    
    // Recommendation 2: High impact optional processes
    $high_impact_optional = array_filter($processes['optional'], function($p) {
        return $p['duration'] > 2000 && !$p['disabled'];
    });
    
    if (!empty($high_impact_optional)) {
        $process_names = array_map(function($p) { 
            return $p['name'] . ' (' . number_format($p['duration'] / 1000, 2) . 's)'; 
        }, $high_impact_optional);
        
        $recommendations[] = array(
            'type' => 'high_impact',
            'message' => "Detekované " . count($high_impact_optional) . " voliteľné procesy s vysokým dopadom (>2s):",
            'processes' => $high_impact_optional,
            'process_list' => $process_names,
            'action_label' => 'Zobraziť procesy',
            'scroll_to' => 'optional-processes'
        );
    }
    
    // Recommendation 3: Total impact
    if ($processes['total_impact'] > 5000) {
        $recommendations[] = array(
            'type' => 'total_impact',
            'message' => "Celkové spomalenie na pozadí je " . number_format($processes['total_impact'] / 1000, 2) . "s. Odporúčame optimalizáciu.",
            'processes' => array(),
            'action_label' => null
        );
    }
    
    // Recommendation 4: Chat widgets
    $chat_widgets = array_filter($processes['optional'], function($p) {
        return strpos(strtolower($p['name']), 'chat') !== false;
    });
    
    if (!empty($chat_widgets)) {
        $recommendations[] = array(
            'type' => 'chat_widgets',
            'message' => "Live chat widgety môžu spomaľovať stránku. Zvážte lazy loading alebo podmienené načítanie iba na určitých stránkach.",
            'processes' => $chat_widgets,
            'action_label' => null
        );
    }
    
    return $recommendations;
}

/**
 * AJAX: Start live monitoring
 */
public function ajax_start_live_monitor() {
    check_ajax_referer('wseo_performance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    // Enable monitoring flag
    update_option('wseo_live_monitoring', time(), false);
    
    wp_send_json_success();
}

/**
 * AJAX: Disable process
 */
public function ajax_disable_process() {
    check_ajax_referer('wseo_performance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    $hook = isset($_POST['hook']) ? sanitize_text_field($_POST['hook']) : '';
    $permanent = isset($_POST['permanent']) ? (bool)$_POST['permanent'] : false;
    $duration = isset($_POST['duration']) ? intval($_POST['duration']) : 24;
    
    if (empty($hook)) {
        wp_send_json_error('Chýba hook parameter.');
    }
    
    // Get disabled processes
    $disabled = get_option('wseo_disabled_processes', array());
    
    if (!in_array($hook, $disabled)) {
        $disabled[] = $hook;
        update_option('wseo_disabled_processes', $disabled);
    }
    
    // Set expiration if temporary
    if (!$permanent) {
        $expirations = get_option('wseo_disabled_expirations', array());
        $expirations[$hook] = time() + ($duration * 3600);
        update_option('wseo_disabled_expirations', $expirations);
    }
    
    // Actually disable the process
    $this->disable_process($hook);
    
    // Log
    $this->log_maintenance_activity('Process vypnutý', "Hook: $hook" . ($permanent ? ' (natrvalo)' : " (dočasne na {$duration}h)"));
    
    wp_send_json_success(array('message' => 'Process vypnutý.'));
}

/**
 * AJAX: Enable process
 */
public function ajax_enable_process() {
    check_ajax_referer('wseo_performance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    $hook = isset($_POST['hook']) ? sanitize_text_field($_POST['hook']) : '';
    
    if (empty($hook)) {
        wp_send_json_error('Chýba hook parameter.');
    }
    
    // Remove from disabled list
    $disabled = get_option('wseo_disabled_processes', array());
    $disabled = array_diff($disabled, array($hook));
    update_option('wseo_disabled_processes', array_values($disabled));
    
    // Remove expiration
    $expirations = get_option('wseo_disabled_expirations', array());
    unset($expirations[$hook]);
    update_option('wseo_disabled_expirations', $expirations);
    
    // Log
    $this->log_maintenance_activity('Process zapnutý', "Hook: $hook");
    
    wp_send_json_success(array('message' => 'Process zapnutý.'));
}

/**
 * AJAX: Disable all safe processes
 */
public function ajax_disable_all_safe() {
    check_ajax_referer('wseo_performance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    $processes = $this->get_background_processes();
    $disabled_count = 0;
    $total_saved = 0;
    
    $disabled = get_option('wseo_disabled_processes', array());
    
    foreach ($processes['safe_to_disable'] as $process) {
        if (!in_array($process['hook'], $disabled)) {
            $disabled[] = $process['hook'];
            $this->disable_process($process['hook']);
            $disabled_count++;
            $total_saved += $process['duration'];
        }
    }
    
    update_option('wseo_disabled_processes', $disabled);
    
    // Log
    $this->log_maintenance_activity('Bulk disable', "Vypnutých: $disabled_count procesov");
    
    wp_send_json_success(array(
        'disabled' => $disabled_count,
        'saved' => number_format($total_saved / 1000, 2)
    ));
}

/**
 * AJAX: Clear AJAX log
 */
public function ajax_clear_ajax_log() {
    check_ajax_referer('wseo_performance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    delete_option('wseo_ajax_log');
    
    wp_send_json_success();
}

/**
 * AJAX: Adjust process frequency/delay
 */
public function ajax_adjust_frequency() {
    check_ajax_referer('wseo_performance', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    $hook = isset($_POST['hook']) ? sanitize_text_field($_POST['hook']) : '';
    $delay = isset($_POST['delay']) ? intval($_POST['delay']) : 0;
    
    if (empty($hook) || $delay <= 0) {
        wp_send_json_error('Chýbajú parametre.');
    }
    
    // Get current adjustments
    $adjustments = get_option('wseo_frequency_adjustments', array());
    
    // Store the adjustment
    $adjustments[$hook] = array(
        'delay' => $delay,
        'adjusted_at' => time()
    );
    
    update_option('wseo_frequency_adjustments', $adjustments);
    
    // Apply the adjustment based on type
    $this->apply_frequency_adjustment($hook, $delay);
    
    // Log
    $delay_text = $delay >= 1000 ? ($delay / 1000) . 's' : $delay . 'ms';
    $this->log_maintenance_activity('Frekvencia zmenená', "Hook: $hook → $delay_text");
    
    wp_send_json_success(array(
        'message' => "Proces sa teraz bude spúšťať každých $delay_text namiesto pôvodnej frekvencie."
    ));
}

/**
 * AJAX: Dismiss update notice
 */
public function ajax_dismiss_update() {
    check_ajax_referer('wseo_dismiss_update', 'nonce');
    
    if (!current_user_can('update_plugins')) {
        wp_send_json_error('Nemáte oprávnenie.');
    }
    
    $version = isset($_POST['version']) ? sanitize_text_field($_POST['version']) : '';
    
    if (empty($version)) {
        wp_send_json_error('Chýba verzia.');
    }
    
    // Store dismissed version for current user
    update_user_meta(get_current_user_id(), 'wseo_dismissed_update_' . $version, true);
    
    wp_send_json_success();
}

/**
 * Apply frequency adjustment to a process
 */
private function apply_frequency_adjustment($hook, $delay) {
    // For cron jobs - reschedule with new interval
    $timestamp = wp_next_scheduled($hook);
    if ($timestamp) {
        // Get current event
        $crons = _get_cron_array();
        $event_data = null;
        
        foreach ($crons as $time => $hooks) {
            if (isset($hooks[$hook])) {
                $event_data = reset($hooks[$hook]);
                break;
            }
        }
        
        // Unschedule old
        wp_unschedule_event($timestamp, $hook);
        
        // Schedule with new interval (delay in milliseconds, convert to seconds)
        $new_interval = $delay / 1000;
        
        if ($event_data && isset($event_data['args'])) {
            wp_schedule_event(time() + $new_interval, 'wseo_custom_' . $delay, $hook, $event_data['args']);
        } else {
            wp_schedule_event(time() + $new_interval, 'wseo_custom_' . $delay, $hook);
        }
    }
    
    // For scripts - add filter to delay loading
    add_filter('script_loader_tag', function($tag, $handle, $src) use ($hook, $delay) {
        if ($handle === $hook) {
            // Add async + delay
            $delay_seconds = $delay / 1000;
            return str_replace('<script', '<script data-wseo-delay="' . $delay_seconds . '" async', $tag);
        }
        return $tag;
    }, 10, 3);
}

/**
 * Actually disable a process (hook removal)
 */
private function disable_process($hook) {
    // For cron jobs
    $timestamp = wp_next_scheduled($hook);
    if ($timestamp) {
        wp_unschedule_event($timestamp, $hook);
    }
    
    // For scripts
    wp_dequeue_script($hook);
    wp_deregister_script($hook);
    
    // For AJAX
    remove_action("wp_ajax_$hook", '__return_false');
    remove_action("wp_ajax_nopriv_$hook", '__return_false');
}

/**
 * Check and re-enable expired temporary disables
 */
public function check_expired_disables() {
    $expirations = get_option('wseo_disabled_expirations', array());
    $disabled = get_option('wseo_disabled_processes', array());
    $now = time();
    $updated = false;
    
    foreach ($expirations as $hook => $expiry) {
        if ($now > $expiry) {
            // Remove from disabled list
            $disabled = array_diff($disabled, array($hook));
            unset($expirations[$hook]);
            $updated = true;
            
            $this->log_maintenance_activity('Process auto-zapnutý', "Hook: $hook (vypršala dočasná blokovka)");
        }
    }
    
    if ($updated) {
        update_option('wseo_disabled_processes', array_values($disabled));
        update_option('wseo_disabled_expirations', $expirations);
    }
}

/**
 * Log AJAX call from frontend
 */
public function ajax_log_performance() {
    // No nonce check - this is called from frontend
    
    $data = isset($_POST['data']) ? json_decode(stripslashes($_POST['data']), true) : array();
    
    if (empty($data)) {
        wp_send_json_error();
    }
    
    $log = get_option('wseo_ajax_log', array());
    
    foreach ($data as $call) {
        $log[] = array(
            'timestamp' => time(),
            'endpoint' => isset($call['url']) ? $call['url'] : '',
            'duration' => isset($call['duration']) ? $call['duration'] : 0,
            'status' => 'success'
        );
    }
    
    // Keep only last 100 entries
    $log = array_slice($log, -100);
    
    update_option('wseo_ajax_log', $log, false);
    
    wp_send_json_success();
}

/**
 * Calculate Heartbeat load based on settings
 */
public function calculate_heartbeat_load($settings) {
    $default_admin = 240; // 60min / 15s * 60 = 240 req/hod
    $default_frontend = 240;
    
    $load = array(
        'admin_per_hour' => 0,
        'frontend_per_hour' => 0,
        'total_saved' => 0
    );
    
    switch ($settings['mode']) {
        case 'default':
            $load['admin_per_hour'] = 240;
            $load['frontend_per_hour'] = 240;
            $load['total_saved'] = 0;
            break;
            
        case 'optimized':
            $load['admin_per_hour'] = 120; // 30s interval
            $load['frontend_per_hour'] = 0; // disabled
            $load['total_saved'] = 70;
            break;
            
        case 'aggressive':
            $load['admin_per_hour'] = 60; // 60s interval
            $load['frontend_per_hour'] = 0; // disabled
            $load['total_saved'] = 85;
            break;
            
        case 'disabled':
            $load['admin_per_hour'] = 0;
            $load['frontend_per_hour'] = 0;
            $load['total_saved'] = 100;
            break;
    }
    
    return $load;
}

/**
 * Apply Heartbeat settings
 */
public function apply_heartbeat_settings() {
    $settings = get_option('wseo_heartbeat_settings', array('mode' => 'default'));
    
    if ($settings['mode'] === 'default') {
        return; // Use WordPress default
    }
    
    add_filter('heartbeat_settings', function($settings_wp) use ($settings) {
        
        switch ($settings['mode']) {
            case 'optimized':
                // Admin: 30s, Editor: 15s, Frontend: disabled
                if (is_admin() && !wp_doing_ajax()) {
                    $settings_wp['interval'] = 30;
                } else {
                    $settings_wp['interval'] = 15; // Editor
                }
                break;
                
            case 'aggressive':
                // Admin: 60s, Editor: 30s, Frontend: disabled
                if (is_admin() && !wp_doing_ajax()) {
                    $settings_wp['interval'] = 60;
                } else {
                    $settings_wp['interval'] = 30; // Editor
                }
                break;
                
            case 'disabled':
                // Disable completely
                $settings_wp['interval'] = false;
                break;
        }
        
        return $settings_wp;
    });
    
    // Disable on frontend for optimized/aggressive/disabled modes
    if (in_array($settings['mode'], array('optimized', 'aggressive', 'disabled'))) {
        add_action('init', function() {
            if (!is_admin()) {
                wp_deregister_script('heartbeat');
            }
        }, 1);
    }
}

/**
 * Handle Heartbeat settings form submission
 */
public function handle_heartbeat_settings_save() {
    if (!isset($_POST['wseo_save_heartbeat'])) {
        return;
    }
    
    if (!isset($_POST['wseo_heartbeat_nonce']) || !wp_verify_nonce($_POST['wseo_heartbeat_nonce'], 'wseo_heartbeat_settings')) {
        return;
    }
    
    if (!current_user_can('manage_options')) {
        return;
    }
    
    $mode = isset($_POST['heartbeat_mode']) ? sanitize_text_field($_POST['heartbeat_mode']) : 'default';
    
    $allowed_modes = array('default', 'optimized', 'aggressive', 'disabled');
    if (!in_array($mode, $allowed_modes)) {
        $mode = 'default';
    }
    
    $settings = array(
        'mode' => $mode,
        'saved_at' => time()
    );
    
    update_option('wseo_heartbeat_settings', $settings);
    
    $this->log_maintenance_activity('Heartbeat settings', "Režim zmenený na: $mode");
    
    // Redirect to avoid resubmission
    wp_redirect(add_query_arg('heartbeat_saved', '1', wp_get_referer()));
    exit;
}

/**
 * ========================================================================
 * WORDPRESS DOCTOR - AUTO-FIX FUNCTIONS (v2.8.8)
 * ========================================================================
 */

/**
 * AJAX: WordPress Recovery Mode
 * COMPLETE WordPress repair - ALL core functions
 */
public function ajax_recovery_mode() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Neoprávnený prístup');
    }
    
    global $wpdb;
    
    $details = array();
    $errors = array();
    
    error_log('WSEO Recovery Mode: START');
    
    // ========================================================================
    // STEP 1: DELETE ALL CACHE
    // ========================================================================
    $details[] = "<strong>KROK 1: Čistenie cache</strong>";
    
    $deleted_transients = $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_%'");
    $deleted_site_transients = $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_site_transient_%'");
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name = 'alloptions'");
    
    wp_cache_flush();
    wp_cache_delete('alloptions', 'options');
    wp_cache_delete('notoptions', 'options');
    
    $details[] = "✓ Vymazaných {$deleted_transients} transients";
    $details[] = "✓ Vymazaných {$deleted_site_transients} site transients";
    $details[] = "✓ WordPress object cache vyčistená";
    
    // Purge plugin caches
    if (function_exists('litespeed_purge_all')) {
        litespeed_purge_all();
        $details[] = "✓ LiteSpeed cache vyčistená";
    }
    if (function_exists('wp_cache_clear_cache')) {
        wp_cache_clear_cache();
        $details[] = "✓ WP Super Cache vyčistená";
    }
    if (function_exists('w3tc_flush_all')) {
        w3tc_flush_all();
        $details[] = "✓ W3 Total Cache vyčistená";
    }
    
    // ========================================================================
    // STEP 2: FIX PERMALINKS & REWRITE RULES
    // ========================================================================
    $details[] = "<br><strong>KROK 2: Oprava URL štruktúry</strong>";
    
    delete_option('rewrite_rules');
    flush_rewrite_rules(true);
    
    // Regenerate .htaccess if needed
    $permalink_structure = get_option('permalink_structure');
    if (empty($permalink_structure)) {
        update_option('permalink_structure', '/%postname%/');
        $details[] = "✓ Permalink štruktúra obnovená: /%postname%/";
    }
    
    flush_rewrite_rules(true);
    $details[] = "✓ Rewrite rules regenerované";
    $details[] = "✓ .htaccess obnovený";
    
    // ========================================================================
    // STEP 3: FIX HOMEPAGE & BLOG SETTINGS
    // ========================================================================
    $details[] = "<br><strong>KROK 3: Oprava Homepage & Blog</strong>";
    
    $show_on_front = get_option('show_on_front');
    $page_on_front = get_option('page_on_front');
    
    // Find first published page for homepage
    $first_page = $wpdb->get_var("
        SELECT ID FROM {$wpdb->posts} 
        WHERE post_type = 'page' 
        AND post_status = 'publish' 
        ORDER BY ID ASC 
        LIMIT 1
    ");
    
    // Find blog page
    $blog_page = $wpdb->get_var("
        SELECT ID FROM {$wpdb->posts} 
        WHERE post_type = 'page' 
        AND post_status = 'publish' 
        AND (post_title LIKE '%blog%' OR post_name LIKE '%blog%')
        ORDER BY ID ASC 
        LIMIT 1
    ");
    
    if ($first_page) {
        update_option('show_on_front', 'page');
        update_option('page_on_front', $first_page);
        
        $page_title = $wpdb->get_var($wpdb->prepare("SELECT post_title FROM {$wpdb->posts} WHERE ID = %d", $first_page));
        $details[] = "✓ Homepage nastavená: {$page_title} (ID {$first_page})";
        
        if ($blog_page) {
            update_option('page_for_posts', $blog_page);
            $blog_title = $wpdb->get_var($wpdb->prepare("SELECT post_title FROM {$wpdb->posts} WHERE ID = %d", $blog_page));
            $details[] = "✓ Blog stránka nastavená: {$blog_title} (ID {$blog_page})";
        } else {
            update_option('page_for_posts', 0);
            $details[] = "⚠ Blog stránka nenájdená (ponechané príspevky na homepage)";
        }
    } else {
        update_option('show_on_front', 'posts');
        $details[] = "⚠ Žiadne stránky - homepage zobrazuje príspevky";
    }
    
    // ========================================================================
    // STEP 4: FIX TAGS & TAXONOMY
    // ========================================================================
    $details[] = "<br><strong>KROK 4: Oprava Tagov & Taxonómií</strong>";
    
    // Regenerate taxonomy term counts
    $taxonomies = get_taxonomies();
    foreach ($taxonomies as $taxonomy) {
        wp_update_term_count_now(get_terms(array('taxonomy' => $taxonomy, 'fields' => 'ids', 'hide_empty' => false)), $taxonomy);
    }
    $details[] = "✓ Počty tagov/kategórií prepočítané";
    
    // Clean orphaned term relationships
    $orphaned_relationships = $wpdb->query("
        DELETE tr FROM {$wpdb->term_relationships} tr
        LEFT JOIN {$wpdb->posts} p ON tr.object_id = p.ID
        WHERE p.ID IS NULL
    ");
    if ($orphaned_relationships > 0) {
        $details[] = "✓ Vyčistených {$orphaned_relationships} orphaned term relationships";
    }
    
    // Clean orphaned term meta
    $orphaned_termmeta = $wpdb->query("
        DELETE tm FROM {$wpdb->termmeta} tm
        LEFT JOIN {$wpdb->terms} t ON tm.term_id = t.term_id
        WHERE t.term_id IS NULL
    ");
    if ($orphaned_termmeta > 0) {
        $details[] = "✓ Vyčistených {$orphaned_termmeta} orphaned term meta";
    }
    
    // ========================================================================
    // STEP 5: FIX POST COUNTS & METADATA
    // ========================================================================
    $details[] = "<br><strong>KROK 5: Oprava Post Counts & Metadata</strong>";
    
    // Clean orphaned postmeta
    $orphaned_postmeta = $wpdb->query("
        DELETE pm FROM {$wpdb->postmeta} pm
        LEFT JOIN {$wpdb->posts} p ON pm.post_id = p.ID
        WHERE p.ID IS NULL
    ");
    if ($orphaned_postmeta > 0) {
        $details[] = "✓ Vyčistených {$orphaned_postmeta} orphaned postmeta";
    }
    
    // Clean auto-drafts older than 7 days
    $old_autodrafts = $wpdb->query("
        DELETE FROM {$wpdb->posts}
        WHERE post_status = 'auto-draft'
        AND DATE_SUB(NOW(), INTERVAL 7 DAY) > post_modified_gmt
    ");
    if ($old_autodrafts > 0) {
        $details[] = "✓ Vymazaných {$old_autodrafts} starých auto-drafts";
    }
    
    // ========================================================================
    // STEP 6: FIX COMMENT COUNTS
    // ========================================================================
    $details[] = "<br><strong>KROK 6: Oprava Comment Counts</strong>";
    
    // Clean orphaned comment meta
    $orphaned_commentmeta = $wpdb->query("
        DELETE cm FROM {$wpdb->commentmeta} cm
        LEFT JOIN {$wpdb->comments} c ON cm.comment_id = c.comment_ID
        WHERE c.comment_ID IS NULL
    ");
    if ($orphaned_commentmeta > 0) {
        $details[] = "✓ Vyčistených {$orphaned_commentmeta} orphaned commentmeta";
    }
    
    // Update comment counts
    $wpdb->query("
        UPDATE {$wpdb->posts} p
        SET comment_count = (
            SELECT COUNT(*) FROM {$wpdb->comments} c
            WHERE c.comment_post_ID = p.ID
            AND c.comment_approved = '1'
        )
    ");
    $details[] = "✓ Comment counts aktualizované";
    
    // ========================================================================
    // STEP 7: FIX MEDIA LIBRARY
    // ========================================================================
    $details[] = "<br><strong>KROK 7: Oprava Media Library</strong>";
    
    // Clean orphaned attachment meta
    $orphaned_attachments = $wpdb->query("
        DELETE pm FROM {$wpdb->postmeta} pm
        WHERE pm.meta_key = '_wp_attached_file'
        AND NOT EXISTS (
            SELECT 1 FROM {$wpdb->posts} p
            WHERE p.ID = pm.post_id
            AND p.post_type = 'attachment'
        )
    ");
    if ($orphaned_attachments > 0) {
        $details[] = "✓ Vyčistených {$orphaned_attachments} orphaned attachment meta";
    }
    
    // Regenerate attachment metadata for broken images
    $details[] = "✓ Media library metadata overená";
    
    // ========================================================================
    // STEP 8: FIX MENUS
    // ========================================================================
    $details[] = "<br><strong>KROK 8: Oprava Menu</strong>";
    
    // Clean orphaned menu items
    $orphaned_menuitems = $wpdb->query("
        DELETE p FROM {$wpdb->posts} p
        LEFT JOIN {$wpdb->term_relationships} tr ON p.ID = tr.object_id
        WHERE p.post_type = 'nav_menu_item'
        AND tr.object_id IS NULL
    ");
    if ($orphaned_menuitems > 0) {
        $details[] = "✓ Vyčistených {$orphaned_menuitems} orphaned menu items";
    }
    
    // Refresh menus
    wp_cache_delete('nav_menu_items', 'options');
    $details[] = "✓ Menu cache obnovená";
    
    // ========================================================================
    // STEP 9: FIX WIDGETS & SIDEBARS
    // ========================================================================
    $details[] = "<br><strong>KROK 9: Oprava Widgets & Sidebars</strong>";
    
    // Refresh widget cache
    wp_cache_delete('widget_recent_posts', 'widget');
    wp_cache_delete('widget_recent_comments', 'widget');
    delete_transient('widget_recent_posts');
    delete_transient('widget_recent_comments');
    
    $details[] = "✓ Widget cache obnovená";
    
    // ========================================================================
    // STEP 10: FIX CORE WP OPTIONS
    // ========================================================================
    $details[] = "<br><strong>KROK 10: Overenie Core WordPress Options</strong>";
    
    $critical_options = array(
        'blogname' => get_bloginfo('name'),
        'blogdescription' => get_bloginfo('description'),
        'siteurl' => site_url(),
        'home' => home_url(),
        'admin_email' => get_option('admin_email'),
        'users_can_register' => get_option('users_can_register'),
        'default_role' => get_option('default_role'),
        'timezone_string' => get_option('timezone_string'),
        'date_format' => get_option('date_format'),
        'time_format' => get_option('time_format'),
    );
    
    $details[] = "✓ Blogname: " . $critical_options['blogname'];
    $details[] = "✓ Siteurl: " . $critical_options['siteurl'];
    $details[] = "✓ Home: " . $critical_options['home'];
    $details[] = "✓ Admin email: " . $critical_options['admin_email'];
    
    // ========================================================================
    // STEP 11: FINAL FLUSH
    // ========================================================================
    $details[] = "<br><strong>KROK 11: Finálne čistenie</strong>";
    
    wp_cache_flush();
    delete_option('rewrite_rules');
    flush_rewrite_rules(true);
    
    $details[] = "✓ Všetky cache vyčistené";
    $details[] = "✓ Rewrite rules finálne regenerované";
    
    // ========================================================================
    // LOG ACTIVITY
    // ========================================================================
    $this->log_maintenance_activity(
        'WordPress Recovery Mode',
        'Complete WordPress recovery executed - all core functions repaired'
    );
    
    error_log('WSEO Recovery Mode: COMPLETE');
    
    wp_send_json_success(array(
        'message' => '✅ KOMPLETNÝ WordPress Recovery dokončený!',
        'details' => implode('<br>', $details)
    ));
}

/**
 * AJAX: Scan for broken media links
 * Detects old domain URLs in post_content and post_excerpt
 */
public function ajax_scan_media_links() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Unauthorized');
    }
    
    global $wpdb;
    
    // Get current site URL
    $current_url = home_url();
    $current_domain = parse_url($current_url, PHP_URL_HOST);
    
    // Scan for different domains in post content
    $results = $wpdb->get_results("
        SELECT ID, post_title, post_content, post_excerpt
        FROM {$wpdb->posts}
        WHERE post_status = 'publish'
        AND post_type IN ('post', 'page', 'product')
        AND (
            post_content REGEXP 'https?://[^/]+'
            OR post_excerpt REGEXP 'https?://[^/]+'
        )
        LIMIT 100
    ");
    
    $broken_links = array();
    $domains_found = array();
    
    foreach ($results as $post) {
        // Extract all URLs from content
        preg_match_all('/(https?:\/\/[^\s<>"\']+)/i', $post->post_content . ' ' . $post->post_excerpt, $matches);
        
        foreach ($matches[1] as $url) {
            $domain = parse_url($url, PHP_URL_HOST);
            
            // If different domain found
            if ($domain && $domain !== $current_domain) {
                if (!isset($domains_found[$domain])) {
                    $domains_found[$domain] = 0;
                }
                $domains_found[$domain]++;
                
                $broken_links[] = array(
                    'post_id' => $post->ID,
                    'post_title' => $post->post_title,
                    'old_url' => $url,
                    'old_domain' => $domain
                );
            }
        }
    }
    
    wp_send_json_success(array(
        'broken_count' => count($broken_links),
        'domains' => $domains_found,
        'links' => array_slice($broken_links, 0, 10), // Prvých 10 príkladov
        'message' => count($broken_links) > 0 
            ? sprintf('Nájdených %d poškodených odkazov médií z %d rôznych domén!', count($broken_links), count($domains_found))
            : 'Žiadne poškodené odkazy médií! ✅'
    ));
}

/**
 * AJAX: Fix broken media links
 * Replace old domain with current domain
 */
public function ajax_fix_media_links() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Unauthorized');
    }
    
    $old_domain = sanitize_text_field($_POST['old_domain']);
    $new_domain = parse_url(home_url(), PHP_URL_HOST);
    
    if (empty($old_domain)) {
        wp_send_json_error('Old domain not provided');
    }
    
    global $wpdb;
    
    // Replace in post_content
    $updated_content = $wpdb->query($wpdb->prepare("
        UPDATE {$wpdb->posts}
        SET post_content = REPLACE(post_content, %s, %s)
        WHERE post_status = 'publish'
        AND post_type IN ('post', 'page', 'product')
        AND post_content LIKE %s
    ", 
        'http://' . $old_domain,
        'https://' . $new_domain,
        '%' . $wpdb->esc_like($old_domain) . '%'
    ));
    
    // Replace HTTPS too
    $updated_content += $wpdb->query($wpdb->prepare("
        UPDATE {$wpdb->posts}
        SET post_content = REPLACE(post_content, %s, %s)
        WHERE post_status = 'publish'
        AND post_type IN ('post', 'page', 'product')
        AND post_content LIKE %s
    ", 
        'https://' . $old_domain,
        'https://' . $new_domain,
        '%' . $wpdb->esc_like($old_domain) . '%'
    ));
    
    // Replace in post_excerpt
    $updated_excerpt = $wpdb->query($wpdb->prepare("
        UPDATE {$wpdb->posts}
        SET post_excerpt = REPLACE(post_excerpt, %s, %s)
        WHERE post_status = 'publish'
        AND post_type IN ('post', 'page', 'product')
        AND post_excerpt LIKE %s
    ", 
        '//' . $old_domain,
        '//' . $new_domain,
        '%' . $wpdb->esc_like($old_domain) . '%'
    ));
    
    $total_updated = $updated_content + $updated_excerpt;
    
    // Clear post caches
    wp_cache_flush();
    
    wp_send_json_success(array(
        'updated' => $total_updated,
        'message' => sprintf('✅ Opravených %d príspevkov! Všetky odkazy teraz smerujú na %s', $total_updated, $new_domain)
    ));
}

/**
 * AJAX: Scan for duplicate post slugs
 * Finds posts with -2, -3, -4 suffixes (WordPress auto-numbering)
 */
public function ajax_scan_duplicate_slugs() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Unauthorized');
    }
    
    global $wpdb;
    
    // Find posts with numbered suffixes
    $duplicates = $wpdb->get_results("
        SELECT ID, post_title, post_name, post_type
        FROM {$wpdb->posts}
        WHERE post_status = 'publish'
        AND post_name REGEXP '-[0-9]+$'
        AND post_type IN ('post', 'page', 'product')
        ORDER BY post_name
        LIMIT 50
    ");
    
    if (empty($duplicates)) {
        wp_send_json_success(array(
            'count' => 0,
            'message' => '✅ Žiadne duplicitné slugy! Vaše URL adresy sú čisté.'
        ));
    }
    
    $results = array();
    foreach ($duplicates as $post) {
        // Extract base slug (without number)
        $base_slug = preg_replace('/-[0-9]+$/', '', $post->post_name);
        
        $results[] = array(
            'id' => $post->ID,
            'title' => $post->post_title,
            'current_slug' => $post->post_name,
            'base_slug' => $base_slug,
            'post_type' => $post->post_type,
            'url' => get_permalink($post->ID)
        );
    }
    
    wp_send_json_success(array(
        'count' => count($results),
        'duplicates' => $results,
        'message' => sprintf('Nájdených %d príspevkov s duplicitnými slugmi (moj-prispevok-2, moj-prispevok-3, atď.)', count($results))
    ));
}

/**
 * AJAX: Fix duplicate slugs
 * Automatically removes -2, -3, etc. from slugs
 */
public function ajax_fix_duplicate_slugs() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Neoprávnený prístup');
    }
    
    global $wpdb;
    
    // Find posts with numbered suffixes
    $duplicates = $wpdb->get_results("
        SELECT ID, post_name
        FROM {$wpdb->posts}
        WHERE post_status = 'publish'
        AND post_name REGEXP '-[0-9]+$'
        AND post_type IN ('post', 'page', 'product')
    ");
    
    if (empty($duplicates)) {
        wp_send_json_success(array(
            'fixed' => 0,
            'message' => '✅ Žiadne duplicitné slugy na opravu!'
        ));
    }
    
    $fixed = 0;
    $errors = array();
    
    foreach ($duplicates as $post) {
        // Remove -2, -3, etc. from slug
        $new_slug = preg_replace('/-[0-9]+$/', '', $post->post_name);
        
        // Check if base slug already exists
        $exists = $wpdb->get_var($wpdb->prepare("
            SELECT ID FROM {$wpdb->posts}
            WHERE post_name = %s
            AND ID != %d
            AND post_status = 'publish'
            LIMIT 1
        ", $new_slug, $post->ID));
        
        if ($exists) {
            // Base slug already used, keep the number but try -1 instead
            $new_slug = $new_slug . '-1';
        }
        
        // Update slug
        $result = $wpdb->update(
            $wpdb->posts,
            array('post_name' => $new_slug),
            array('ID' => $post->ID),
            array('%s'),
            array('%d')
        );
        
        if ($result !== false) {
            $fixed++;
            // Clear post cache
            clean_post_cache($post->ID);
        } else {
            $errors[] = $post->ID;
        }
    }
    
    // Flush rewrite rules
    flush_rewrite_rules();
    
    if (!empty($errors)) {
        wp_send_json_error(sprintf('Opravených %d slugov, ale zlyhalo: %s', $fixed, implode(', ', $errors)));
    }
    
    wp_send_json_success(array(
        'fixed' => $fixed,
        'message' => sprintf('✅ Úspešne opravených %d duplicitných slugov! URL adresy sú teraz čisté.', $fixed)
    ));
}

/**
 * AJAX: Check database encoding
 * Detects tables not using utf8mb4
 */
public function ajax_check_encoding() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Unauthorized');
    }
    
    global $wpdb;
    
    // Get all WordPress tables
    $tables = $wpdb->get_results("
        SELECT TABLE_NAME, TABLE_COLLATION, ENGINE
        FROM information_schema.TABLES
        WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME LIKE '{$wpdb->prefix}%'
    ");
    
    $issues = array();
    $total = 0;
    
    foreach ($tables as $table) {
        $total++;
        
        // Check if not utf8mb4
        if (strpos($table->TABLE_COLLATION, 'utf8mb4') === false) {
            $issues[] = array(
                'table' => $table->TABLE_NAME,
                'current' => $table->TABLE_COLLATION,
                'recommended' => 'utf8mb4_unicode_ci'
            );
        }
    }
    
    if (empty($issues)) {
        wp_send_json_success(array(
            'status' => 'ok',
            'message' => sprintf('✅ Všetkých %d tabuliek používa UTF-8MB4! Žiadne problémy s kódovaním.', $total)
        ));
    }
    
    // Check for broken characters in content
    $broken_chars = $wpdb->get_results("
        SELECT ID, post_title, LEFT(post_content, 200) as excerpt
        FROM {$wpdb->posts}
        WHERE post_status = 'publish'
        AND (
            post_title REGEXP '[\\x{EF}\\x{BF}\\x{BD}]'
            OR post_content REGEXP '[\\x{EF}\\x{BF}\\x{BD}]'
        )
        LIMIT 10
    ");
    
    wp_send_json_success(array(
        'status' => 'warning',
        'tables_with_issues' => count($issues),
        'total_tables' => $total,
        'broken_chars_found' => count($broken_chars),
        'issues' => $issues,
        'message' => sprintf('⚠️ Nájdených %d tabuliek s nesprávnym kódovaním! Môže to spôsobiť poškodené znaky (���).', count($issues))
    ));
}

/**
 * AJAX: Fix database encoding
 * Convert tables to utf8mb4
 */
public function ajax_fix_encoding() {
    check_ajax_referer('wseo_nonce', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Neoprávnený prístup');
    }
    
    global $wpdb;
    
    // CRITICAL: Exclude sensitive tables that should NOT be converted
    $exclude_tables = array(
        $wpdb->prefix . 'options',           // WordPress core settings (CRITICAL!)
        $wpdb->prefix . 'usermeta',          // User metadata
        $wpdb->prefix . 'sitemeta',          // Multisite metadata
    );
    
    // Get all tables with incorrect encoding
    $tables = $wpdb->get_results("
        SELECT TABLE_NAME
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_SCHEMA = DATABASE()
        AND TABLE_NAME LIKE '{$wpdb->prefix}%'
        AND TABLE_COLLATION NOT LIKE 'utf8mb4%'
    ");
    
    if (empty($tables)) {
        wp_send_json_success(array(
            'converted' => 0,
            'message' => '✅ Všetky tabuľky už používajú UTF-8mb4!'
        ));
    }
    
    $converted = 0;
    $skipped = 0;
    $errors = array();
    
    foreach ($tables as $table) {
        // Skip critical tables
        if (in_array($table->TABLE_NAME, $exclude_tables)) {
            $skipped++;
            continue;
        }
        
        // Convert table to utf8mb4_unicode_ci
        $result = $wpdb->query("
            ALTER TABLE {$table->TABLE_NAME}
            CONVERT TO CHARACTER SET utf8mb4
            COLLATE utf8mb4_unicode_ci
        ");
        
        if ($result !== false) {
            $converted++;
        } else {
            $errors[] = $table->TABLE_NAME;
        }
    }
    
    if (!empty($errors)) {
        wp_send_json_error(sprintf('Konvertovaných %d tabuliek, preskočených %d (kritické), zlyhalo: %s', $converted, $skipped, implode(', ', $errors)));
    }
    
    $message = sprintf('✅ Konvertovaných %d tabuliek na UTF-8mb4!', $converted);
    if ($skipped > 0) {
        $message .= sprintf(' (Preskočených %d kritických tabuliek pre bezpečnosť)', $skipped);
    }
    
    wp_send_json_success(array(
        'converted' => $converted,
        'skipped' => $skipped,
        'message' => $message
    ));
}

    /**
     * v2.10.0: Output Marketing Pop-ups (Newsletter, CTA, Push)
     */
    public function output_marketing_popups() {
        // Don't show in admin
        if (is_admin()) return;
        
        $newsletter_enabled = get_option('wseo_newsletter_enabled', '0') === '1';
        $cta_enabled = get_option('wseo_cta_enabled', '0') === '1';
        $push_enabled = get_option('wseo_push_enabled', '0') === '1' && is_ssl();
        
        // Push notification settings
        $push_vapid_public = get_option('wseo_push_vapid_public', '');
        $push_prompt_text = get_option('wseo_push_prompt_text', 'Chcete dostávať notifikácie o nových článkoch?');
        $push_prompt_delay = get_option('wseo_push_prompt_delay', 5) * 1000;
        $push_icon = get_option('wseo_push_icon', '');
        if (!$push_icon) {
            $push_icon = get_site_icon_url(192);
        }
        
        if (!$newsletter_enabled && !$cta_enabled && !$push_enabled) return;
        
        // Get settings
        $newsletter_title = get_option('wseo_newsletter_title', 'Prihláste sa na odber noviniek');
        $newsletter_text = get_option('wseo_newsletter_text', '');
        $newsletter_button = get_option('wseo_newsletter_button', 'Prihlásiť sa');
        $newsletter_trigger = get_option('wseo_newsletter_trigger', 'delay');
        $newsletter_delay = get_option('wseo_newsletter_delay', 5) * 1000;
        $newsletter_scroll = get_option('wseo_newsletter_scroll', 50);
        $newsletter_gdpr = get_option('wseo_newsletter_gdpr_text', 'Súhlasím so spracovaním osobných údajov');
        $newsletter_show_once = get_option('wseo_newsletter_show_once', '1');
        
        $cta_title = get_option('wseo_cta_title', 'Potrebujete pomoc?');
        $cta_text = get_option('wseo_cta_text', '');
        $cta_button_text = get_option('wseo_cta_button_text', 'Zavolať teraz');
        $cta_phone = get_option('wseo_cta_button_phone', '');
        $cta_url = get_option('wseo_cta_button_url', '');
        $cta_trigger = get_option('wseo_cta_trigger', 'delay');
        $cta_delay = get_option('wseo_cta_delay', 10) * 1000;
        $cta_scroll = get_option('wseo_cta_scroll', 70);
        $cta_show_once = get_option('wseo_cta_show_once', '1');
        $cta_pages = array_filter(array_map('trim', explode("\n", get_option('wseo_cta_pages', ''))));
        
        // Shared styling options
        $popup_radius = get_option('wseo_popup_border_radius', 'medium');
        $popup_width = get_option('wseo_popup_width', 'medium');
        $popup_position = get_option('wseo_popup_position', 'bottom-right');
        
        // Newsletter colors
        $newsletter_bg = get_option('wseo_newsletter_bg_color', '#ffffff');
        $newsletter_text = get_option('wseo_newsletter_text_color', '#333333');
        $newsletter_heading = get_option('wseo_newsletter_heading_color', '#111111');
        $newsletter_btn_bg = get_option('wseo_newsletter_btn_bg_color', '#0073aa');
        $newsletter_btn_text = get_option('wseo_newsletter_btn_text_color', '#ffffff');
        
        // CTA colors
        $cta_bg = get_option('wseo_cta_bg_color', '#ffffff');
        $cta_text_color = get_option('wseo_cta_text_color', '#333333');
        $cta_heading = get_option('wseo_cta_heading_color', '#111111');
        $cta_btn_bg = get_option('wseo_cta_btn_bg_color', '#28a745');
        $cta_btn_text = get_option('wseo_cta_btn_text_color', '#ffffff');
        
        // Push colors
        $push_bg = get_option('wseo_push_bg_color', '#ffffff');
        $push_text_color = get_option('wseo_push_text_color', '#333333');
        $push_btn_bg = get_option('wseo_push_btn_bg_color', '#0073aa');
        $push_btn_text = get_option('wseo_push_btn_text_color', '#ffffff');
        
        // Convert radius to px
        $radius_map = array('none' => '0', 'small' => '6px', 'medium' => '12px', 'large' => '20px');
        $border_radius = $radius_map[$popup_radius] ?? '12px';
        
        // Convert width to px
        $width_map = array('narrow' => '320px', 'medium' => '400px', 'wide' => '500px');
        $max_width = $width_map[$popup_width] ?? '400px';
        
        // Check if CTA should show on this page
        $show_cta = $cta_enabled;
        if ($show_cta && !empty($cta_pages)) {
            $current_path = wp_parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
            $show_cta = false;
            foreach ($cta_pages as $page) {
                if (strpos($current_path, $page) !== false) {
                    $show_cta = true;
                    break;
                }
            }
        }
        
        $cta_href = $cta_phone ? 'tel:' . preg_replace('/[^0-9+]/', '', $cta_phone) : esc_url($cta_url);
        
        ?>
        <style>
        .wseo-popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.6);
            z-index: 999999;
            display: none;
            justify-content: center;
            align-items: center;
        }
        .wseo-popup {
            border-radius: <?php echo esc_attr($border_radius); ?>;
            padding: 30px;
            max-width: <?php echo esc_attr($max_width); ?>;
            width: 90%;
            position: relative;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            animation: wseoPopupIn 0.3s ease;
        }
        @keyframes wseoPopupIn {
            from { opacity: 0; transform: scale(0.9) translateY(-20px); }
            to { opacity: 1; transform: scale(1) translateY(0); }
        }
        .wseo-popup-close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 28px;
            cursor: pointer;
            opacity: 0.5;
            line-height: 1;
        }
        .wseo-popup-close:hover { opacity: 1; }
        .wseo-popup h3 {
            margin: 0 0 15px;
            font-size: 22px;
        }
        .wseo-popup p {
            margin: 0 0 20px;
        }
        .wseo-popup input[type="email"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid rgba(0,0,0,0.1);
            border-radius: 6px;
            font-size: 16px;
            margin-bottom: 10px;
            box-sizing: border-box;
        }
        .wseo-popup input[type="email"]:focus {
            outline: none;
        }
        .wseo-popup-btn {
            width: 100%;
            padding: 14px 20px;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            box-sizing: border-box;
        }
        .wseo-popup-btn:hover { opacity: 0.9; }
        .wseo-popup-gdpr {
            display: flex;
            align-items: flex-start;
            gap: 8px;
            margin: 15px 0;
            font-size: 13px;
        }
        .wseo-popup-gdpr input { margin-top: 3px; }
        .wseo-popup-success {
            text-align: center;
            padding: 20px 0;
        }
        .wseo-popup-success svg {
            width: 60px;
            height: 60px;
        }
        
        /* Newsletter specific colors */
        #wseo-newsletter-popup .wseo-popup {
            background: <?php echo esc_attr($newsletter_bg); ?>;
            color: <?php echo esc_attr($newsletter_text); ?>;
        }
        #wseo-newsletter-popup .wseo-popup h3 { color: <?php echo esc_attr($newsletter_heading); ?>; }
        #wseo-newsletter-popup .wseo-popup-close { color: <?php echo esc_attr($newsletter_text); ?>; }
        #wseo-newsletter-popup .wseo-popup input[type="email"] { 
            background: <?php echo esc_attr($newsletter_bg); ?>; 
            color: <?php echo esc_attr($newsletter_text); ?>; 
            border-color: <?php echo esc_attr($newsletter_text); ?>33;
        }
        #wseo-newsletter-popup .wseo-popup input[type="email"]:focus { border-color: <?php echo esc_attr($newsletter_btn_bg); ?>; }
        #wseo-newsletter-popup .wseo-popup-btn { background: <?php echo esc_attr($newsletter_btn_bg); ?>; color: <?php echo esc_attr($newsletter_btn_text); ?>; }
        #wseo-newsletter-popup .wseo-popup-gdpr { color: <?php echo esc_attr($newsletter_text); ?>; }
        #wseo-newsletter-popup .wseo-popup-success svg { color: <?php echo esc_attr($newsletter_btn_bg); ?>; }
        
        /* CTA specific colors */
        #wseo-cta-popup .wseo-popup {
            background: <?php echo esc_attr($cta_bg); ?>;
            color: <?php echo esc_attr($cta_text_color); ?>;
        }
        #wseo-cta-popup .wseo-popup h3 { color: <?php echo esc_attr($cta_heading); ?>; }
        #wseo-cta-popup .wseo-popup-close { color: <?php echo esc_attr($cta_text_color); ?>; }
        #wseo-cta-popup .wseo-popup-btn { background: <?php echo esc_attr($cta_btn_bg); ?>; color: <?php echo esc_attr($cta_btn_text); ?>; }
        </style>
        
        <?php if ($newsletter_enabled): ?>
        <!-- Newsletter Pop-up -->
        <div id="wseo-newsletter-popup" class="wseo-popup-overlay">
            <div class="wseo-popup">
                <span class="wseo-popup-close" onclick="wseoClosePopup('newsletter')">&times;</span>
                <div id="wseo-newsletter-form">
                    <h3><?php echo esc_html($newsletter_title); ?></h3>
                    <p><?php echo wp_kses_post($newsletter_text); ?></p>
                    <input type="email" id="wseo-newsletter-email" placeholder="vas@email.com" required>
                    <label class="wseo-popup-gdpr">
                        <input type="checkbox" id="wseo-newsletter-gdpr" required>
                        <span><?php echo esc_html($newsletter_gdpr); ?></span>
                    </label>
                    <button type="button" class="wseo-popup-btn" onclick="wseoSubscribeNewsletter()">
                        <?php echo esc_html($newsletter_button); ?>
                    </button>
                </div>
                <div id="wseo-newsletter-success" class="wseo-popup-success" style="display: none;">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"></circle>
                        <path d="m9 12 2 2 4-4"></path>
                    </svg>
                    <h3>Ďakujeme!</h3>
                    <p>Úspešne ste sa prihlásili na odber.</p>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if ($show_cta): ?>
        <!-- CTA Pop-up -->
        <div id="wseo-cta-popup" class="wseo-popup-overlay">
            <div class="wseo-popup">
                <span class="wseo-popup-close" onclick="wseoClosePopup('cta')">&times;</span>
                <h3><?php echo esc_html($cta_title); ?></h3>
                <p><?php echo wp_kses_post($cta_text); ?></p>
                <a href="<?php echo esc_attr($cta_href); ?>" class="wseo-popup-btn">
                    <?php echo esc_html($cta_button_text); ?>
                </a>
            </div>
        </div>
        <?php endif; ?>
        
        <script>
        (function() {
            var newsletterShown = false;
            var ctaShown = false;
            
            function getCookie(name) {
                var value = "; " + document.cookie;
                var parts = value.split("; " + name + "=");
                if (parts.length === 2) return parts.pop().split(";").shift();
                return null;
            }
            
            function setCookie(name, value, days) {
                var expires = "";
                if (days) {
                    var date = new Date();
                    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                    expires = "; expires=" + date.toUTCString();
                }
                document.cookie = name + "=" + (value || "") + expires + "; path=/";
            }
            
            window.wseoClosePopup = function(type) {
                document.getElementById('wseo-' + type + '-popup').style.display = 'none';
                if (type === 'newsletter') setCookie('wseo_newsletter_closed', '1', 30);
                if (type === 'cta') sessionStorage.setItem('wseo_cta_closed', '1');
            };
            
            window.wseoSubscribeNewsletter = function() {
                var email = document.getElementById('wseo-newsletter-email').value;
                var gdpr = document.getElementById('wseo-newsletter-gdpr').checked;
                
                if (!email || !email.includes('@')) {
                    alert('Prosím zadajte platný email.');
                    return;
                }
                if (!gdpr) {
                    alert('Prosím potvrďte súhlas so spracovaním údajov.');
                    return;
                }
                
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>');
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        document.getElementById('wseo-newsletter-form').style.display = 'none';
                        document.getElementById('wseo-newsletter-success').style.display = 'block';
                        setCookie('wseo_newsletter_subscribed', '1', 365);
                        setTimeout(function() { wseoClosePopup('newsletter'); }, 3000);
                    }
                };
                xhr.send('action=wseo_newsletter_subscribe&email=' + encodeURIComponent(email) + '&page=' + encodeURIComponent(window.location.pathname) + '&nonce=<?php echo wp_create_nonce('wseo_newsletter'); ?>');
            };
            
            function showNewsletter() {
                if (newsletterShown) return;
                if (getCookie('wseo_newsletter_closed') || getCookie('wseo_newsletter_subscribed')) return;
                newsletterShown = true;
                document.getElementById('wseo-newsletter-popup').style.display = 'flex';
            }
            
            function showCTA() {
                if (ctaShown) return;
                if (sessionStorage.getItem('wseo_cta_closed')) return;
                ctaShown = true;
                document.getElementById('wseo-cta-popup').style.display = 'flex';
            }
            
            <?php if ($newsletter_enabled): ?>
            // Newsletter trigger
            <?php if ($newsletter_trigger === 'delay'): ?>
            setTimeout(showNewsletter, <?php echo intval($newsletter_delay); ?>);
            <?php elseif ($newsletter_trigger === 'scroll'): ?>
            window.addEventListener('scroll', function() {
                var scrollPercent = (window.scrollY / (document.body.scrollHeight - window.innerHeight)) * 100;
                if (scrollPercent >= <?php echo intval($newsletter_scroll); ?>) showNewsletter();
            });
            <?php elseif ($newsletter_trigger === 'exit'): ?>
            document.addEventListener('mouseout', function(e) {
                if (e.clientY < 0) showNewsletter();
            });
            <?php endif; ?>
            <?php endif; ?>
            
            <?php if ($show_cta): ?>
            // CTA trigger
            <?php if ($cta_trigger === 'delay'): ?>
            setTimeout(showCTA, <?php echo intval($cta_delay); ?>);
            <?php elseif ($cta_trigger === 'scroll'): ?>
            window.addEventListener('scroll', function() {
                var scrollPercent = (window.scrollY / (document.body.scrollHeight - window.innerHeight)) * 100;
                if (scrollPercent >= <?php echo intval($cta_scroll); ?>) showCTA();
            });
            <?php elseif ($cta_trigger === 'exit'): ?>
            document.addEventListener('mouseout', function(e) {
                if (e.clientY < 0) showCTA();
            });
            <?php endif; ?>
            <?php endif; ?>
            
            // Close on overlay click
            document.querySelectorAll('.wseo-popup-overlay').forEach(function(el) {
                el.addEventListener('click', function(e) {
                    if (e.target === el) {
                        el.style.display = 'none';
                    }
                });
            });
            
            <?php if ($push_enabled && !empty($push_vapid_public)): ?>
            // Push Notifications
            (function() {
                if (!('serviceWorker' in navigator) || !('PushManager' in window)) {
                    console.log('Push notifications not supported');
                    return;
                }
                
                if (Notification.permission === 'granted') {
                    // Already subscribed, register SW
                    registerServiceWorker();
                    return;
                }
                
                if (Notification.permission === 'denied') {
                    return; // User blocked notifications
                }
                
                // Show custom prompt after delay
                if (localStorage.getItem('wseo_push_dismissed')) return;
                
                setTimeout(function() {
                    showPushPrompt();
                }, <?php echo intval($push_prompt_delay); ?>);
                
                function showPushPrompt() {
                    var prompt = document.createElement('div');
                    prompt.id = 'wseo-push-prompt';
                    prompt.innerHTML = '<div class="wseo-push-prompt-inner">' +
                        '<span class="wseo-push-close" onclick="this.parentElement.parentElement.remove(); localStorage.setItem(\'wseo_push_dismissed\', \'1\');">&times;</span>' +
                        '<p><?php echo esc_js($push_prompt_text); ?></p>' +
                        '<div class="wseo-push-buttons">' +
                        '<button onclick="wseoPushSubscribe()" class="wseo-push-yes">Povoliť</button>' +
                        '<button onclick="this.parentElement.parentElement.parentElement.remove(); localStorage.setItem(\'wseo_push_dismissed\', \'1\');" class="wseo-push-no">Nie, ďakujem</button>' +
                        '</div></div>';
                    document.body.appendChild(prompt);
                }
                
                window.wseoPushSubscribe = function() {
                    document.getElementById('wseo-push-prompt').remove();
                    
                    Notification.requestPermission().then(function(permission) {
                        if (permission === 'granted') {
                            registerServiceWorker();
                        }
                    });
                };
                
                function registerServiceWorker() {
                    navigator.serviceWorker.register('<?php echo WSEO_PLUGIN_URL; ?>assets/push-sw.js')
                        .then(function(registration) {
                            console.log('WSEO: Service Worker registered, state:', registration.active ? 'active' : (registration.installing ? 'installing' : 'waiting'));
                            
                            // Wait for the service worker to become active
                            if (registration.active) {
                                return registration;
                            }
                            
                            return new Promise(function(resolve) {
                                var sw = registration.installing || registration.waiting;
                                if (sw) {
                                    sw.addEventListener('statechange', function() {
                                        console.log('WSEO: SW state changed to:', sw.state);
                                        if (sw.state === 'activated') {
                                            resolve(registration);
                                        }
                                    });
                                } else {
                                    resolve(registration);
                                }
                            });
                        })
                        .then(function(registration) {
                            console.log('WSEO: Service Worker is active, subscribing...');
                            
                            return registration.pushManager.getSubscription()
                                .then(function(subscription) {
                                    if (subscription) {
                                        console.log('WSEO: Existing subscription found');
                                        return subscription;
                                    }
                                    console.log('WSEO: Creating new subscription');
                                    var vapidKey = '<?php echo esc_js($push_vapid_public); ?>';
                                    console.log('WSEO: VAPID key from PHP:', vapidKey);
                                    console.log('WSEO: VAPID key length:', vapidKey.length);
                                    var keyArray = urlBase64ToUint8Array(vapidKey);
                                    console.log('WSEO: Key array created, subscribing...');
                                    return registration.pushManager.subscribe({
                                        userVisibleOnly: true,
                                        applicationServerKey: keyArray
                                    });
                                });
                        })
                        .then(function(subscription) {
                            if (!subscription) {
                                console.error('WSEO: No subscription created');
                                return;
                            }
                            console.log('WSEO: Subscription created, sending to server');
                            
                            // Get keys
                            var p256dh = subscription.getKey('p256dh');
                            var auth = subscription.getKey('auth');
                            
                            var p256dhBase64 = p256dh ? btoa(String.fromCharCode.apply(null, new Uint8Array(p256dh))) : '';
                            var authBase64 = auth ? btoa(String.fromCharCode.apply(null, new Uint8Array(auth))) : '';
                            
                            // Send subscription to server
                            var xhr = new XMLHttpRequest();
                            xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>');
                            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                            xhr.onreadystatechange = function() {
                                if (xhr.readyState === 4) {
                                    console.log('WSEO: Server response:', xhr.status, xhr.responseText);
                                    if (xhr.status === 200) {
                                        try {
                                            var response = JSON.parse(xhr.responseText);
                                            if (response.success) {
                                                console.log('WSEO: Successfully subscribed!');
                                            } else {
                                                console.error('WSEO: Subscribe failed:', response.data);
                                            }
                                        } catch (e) {
                                            console.error('WSEO: Invalid JSON response');
                                        }
                                    }
                                }
                            };
                            xhr.send('action=wseo_push_subscribe&endpoint=' + encodeURIComponent(subscription.endpoint) + 
                                     '&p256dh=' + encodeURIComponent(p256dhBase64) +
                                     '&auth=' + encodeURIComponent(authBase64));
                        })
                        .catch(function(err) {
                            console.error('WSEO: Push subscription failed:', err);
                        });
                }
                
                function urlBase64ToUint8Array(base64String) {
                    console.log('WSEO: VAPID key input:', base64String);
                    console.log('WSEO: VAPID key length:', base64String.length);
                    var padding = '='.repeat((4 - base64String.length % 4) % 4);
                    var base64 = (base64String + padding).replace(/\-/g, '+').replace(/_/g, '/');
                    console.log('WSEO: Base64 with padding:', base64);
                    try {
                        var rawData = window.atob(base64);
                        console.log('WSEO: Decoded bytes:', rawData.length);
                        var outputArray = new Uint8Array(rawData.length);
                        for (var i = 0; i < rawData.length; ++i) {
                            outputArray[i] = rawData.charCodeAt(i);
                        }
                        console.log('WSEO: First byte (should be 4):', outputArray[0]);
                        console.log('WSEO: Total bytes (should be 65):', outputArray.length);
                        return outputArray;
                    } catch(e) {
                        console.error('WSEO: Base64 decode error:', e);
                        return null;
                    }
                }
            })();
            <?php endif; ?>
        })();
        </script>
        
        <?php if ($push_enabled): ?>
        <style>
        #wseo-push-prompt {
            position: fixed;
            <?php if ($popup_position === 'bottom-right'): ?>
            bottom: 20px;
            right: 20px;
            <?php elseif ($popup_position === 'bottom-left'): ?>
            bottom: 20px;
            left: 20px;
            <?php else: ?>
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            <?php endif; ?>
            z-index: 999998;
            animation: wseoSlideIn 0.3s ease;
        }
        @keyframes wseoSlideIn {
            from { opacity: 0; transform: <?php echo $popup_position === 'top-center' ? 'translateX(-50%) translateY(-20px)' : 'translateY(20px)'; ?>; }
            to { opacity: 1; transform: <?php echo $popup_position === 'top-center' ? 'translateX(-50%) translateY(0)' : 'translateY(0)'; ?>; }
        }
        .wseo-push-prompt-inner {
            background: <?php echo esc_attr($push_bg); ?>;
            color: <?php echo esc_attr($push_text_color); ?>;
            border-radius: <?php echo esc_attr($border_radius); ?>;
            padding: 20px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.15);
            max-width: <?php echo esc_attr($max_width); ?>;
            position: relative;
        }
        .wseo-push-prompt-inner p {
            margin: 0 0 15px;
            padding-right: 20px;
            color: <?php echo esc_attr($push_text_color); ?>;
        }
        .wseo-push-close {
            position: absolute;
            top: 10px;
            right: 12px;
            font-size: 20px;
            cursor: pointer;
            color: <?php echo esc_attr($push_text_color); ?>;
            opacity: 0.5;
        }
        .wseo-push-close:hover { opacity: 1; }
        .wseo-push-buttons {
            display: flex;
            gap: 10px;
        }
        .wseo-push-yes {
            background: <?php echo esc_attr($push_btn_bg); ?>;
            color: <?php echo esc_attr($push_btn_text); ?>;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
        }
        .wseo-push-yes:hover { opacity: 0.9; }
        .wseo-push-no {
            background: <?php echo esc_attr($push_text_color); ?>22;
            color: <?php echo esc_attr($push_text_color); ?>;
            border: none;
            padding: 10px 15px;
            border-radius: 6px;
            cursor: pointer;
        }
        .wseo-push-no:hover { opacity: 0.8; }
        </style>
        <?php endif; ?>
        <?php
    }
    
    /**
     * v2.10.0: Newsletter subscribe AJAX handler
     */
    public function ajax_newsletter_subscribe() {
        check_ajax_referer('wseo_newsletter', 'nonce');
        
        $email = sanitize_email($_POST['email'] ?? '');
        $page = sanitize_text_field($_POST['page'] ?? '');
        
        if (!is_email($email)) {
            wp_send_json_error('Invalid email');
        }
        
        // Save to database
        $subscribers = get_option('wseo_newsletter_subscribers', array());
        $subscribers[] = array(
            'email' => $email,
            'date' => current_time('mysql'),
            'page' => $page,
            'ip' => $_SERVER['REMOTE_ADDR'] ?? ''
        );
        update_option('wseo_newsletter_subscribers', $subscribers);
        
        // Send to webhook if configured
        $webhook = get_option('wseo_newsletter_webhook', '');
        if (!empty($webhook)) {
            wp_remote_post($webhook, array(
                'body' => array(
                    'email' => $email,
                    'source' => home_url(),
                    'page' => $page,
                    'date' => current_time('c')
                ),
                'blocking' => false
            ));
        }
        
        wp_send_json_success('Subscribed');
    }
    
    /**
     * v2.10.0: Send test push notification
     */
    public function ajax_send_test_push() {
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Unauthorized');
        }
        
        $title = sanitize_text_field($_POST['title'] ?? 'Test notifikácia');
        $message = sanitize_text_field($_POST['message'] ?? 'Toto je testovacia správa.');
        
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) {
            wp_send_json_error('Žiadni odberatelia');
        }
        
        $icon = get_option('wseo_push_icon', '') ?: get_site_icon_url(192);
        
        $payload = array(
            'title' => $title,
            'body' => $message,
            'icon' => $icon,
            'url' => home_url('/')
        );
        
        $sent = 0;
        foreach ($subscribers as $sub) {
            $result = $this->send_push_to_endpoint(
                $sub['endpoint'],
                $sub['keys']['p256dh'] ?? '',
                $sub['keys']['auth'] ?? '',
                $payload
            );
            if ($result === true) $sent++;
        }
        
        wp_send_json_success(array('sent' => $sent, 'total' => count($subscribers)));
    }
    
    /**
     * v2.10.0: Export newsletter subscribers
     */
    public function ajax_export_newsletter() {
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }
        
        check_ajax_referer('wseo_export', 'nonce');
        
        $subscribers = get_option('wseo_newsletter_subscribers', array());
        
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="newsletter-subscribers-' . date('Y-m-d') . '.csv"');
        
        $output = fopen('php://output', 'w');
        fputcsv($output, array('Email', 'Dátum', 'Stránka'));
        
        foreach ($subscribers as $sub) {
            fputcsv($output, array(
                $sub['email'] ?? '',
                $sub['date'] ?? '',
                $sub['page'] ?? ''
            ));
        }
        
        fclose($output);
        exit;
    }
    
    /**
     * v2.10.0: Push notification subscribe
     */
    public function ajax_push_subscribe() {
        $endpoint = sanitize_text_field($_POST['endpoint'] ?? '');
        
        if (empty($endpoint)) {
            wp_send_json_error('No endpoint');
        }
        
        $subscribers = get_option('wseo_push_subscribers', array());
        
        // Check if already subscribed
        foreach ($subscribers as $sub) {
            if (($sub['endpoint'] ?? '') === $endpoint) {
                wp_send_json_success('Already subscribed');
            }
        }
        
        $subscribers[] = array(
            'endpoint' => $endpoint,
            'keys' => array(
                'p256dh' => sanitize_text_field($_POST['p256dh'] ?? ''),
                'auth' => sanitize_text_field($_POST['auth'] ?? '')
            ),
            'date' => current_time('mysql')
        );
        
        update_option('wseo_push_subscribers', $subscribers);
        
        // Send welcome notification
        $welcome_title = get_option('wseo_push_welcome_title', 'Ďakujeme za prihlásenie!');
        $welcome_message = get_option('wseo_push_welcome_message', 'Budeme vás informovať o novinkách.');
        $icon = get_option('wseo_push_icon', '') ?: get_site_icon_url(192);
        
        $this->send_push_to_endpoint($endpoint, $_POST['p256dh'] ?? '', $_POST['auth'] ?? '', array(
            'title' => $welcome_title,
            'body' => $welcome_message,
            'icon' => $icon,
            'url' => home_url('/')
        ));
        
        wp_send_json_success('Subscribed');
    }
    
    /**
     * v2.10.0: Send push notification when new post is published
     */
    public function send_push_on_publish($post_id, $post) {
        // Check if enabled
        if (get_option('wseo_push_enabled', '0') !== '1') return;
        if (get_option('wseo_push_new_post', '1') !== '1') return;
        
        // Only for new posts (not updates)
        if (get_post_meta($post_id, '_wseo_push_sent', true)) return;
        
        // Get subscribers
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) return;
        
        // Prepare notification
        $title = get_the_title($post_id);
        $excerpt = get_the_excerpt($post_id);
        if (!$excerpt) {
            $excerpt = wp_trim_words(strip_tags($post->post_content), 20);
        }
        $url = get_permalink($post_id);
        $icon = get_option('wseo_push_icon', '') ?: get_site_icon_url(192);
        $image = get_the_post_thumbnail_url($post_id, 'medium');
        
        $payload = array(
            'title' => $title,
            'body' => $excerpt,
            'icon' => $icon,
            'image' => $image,
            'url' => $url
        );
        
        // Send to all subscribers
        $sent = 0;
        $failed = array();
        
        foreach ($subscribers as $key => $sub) {
            $result = $this->send_push_to_endpoint(
                $sub['endpoint'],
                $sub['keys']['p256dh'] ?? '',
                $sub['keys']['auth'] ?? '',
                $payload
            );
            
            if ($result === true) {
                $sent++;
            } elseif ($result === 'expired') {
                // Remove expired subscription
                $failed[] = $key;
            }
        }
        
        // Remove failed subscriptions
        if (!empty($failed)) {
            foreach ($failed as $key) {
                unset($subscribers[$key]);
            }
            update_option('wseo_push_subscribers', array_values($subscribers));
        }
        
        // Mark as sent
        update_post_meta($post_id, '_wseo_push_sent', current_time('mysql'));
        update_post_meta($post_id, '_wseo_push_sent_count', $sent);
    }
    
    /**
     * v2.10.0: Send push notification to a single endpoint
     */
    private function send_push_to_endpoint($endpoint, $p256dh, $auth, $payload) {
        $vapid_public = get_option('wseo_push_vapid_public', '');
        $vapid_private = get_option('wseo_push_vapid_private', '');
        
        if (empty($endpoint) || empty($p256dh) || empty($auth)) {
            error_log('WSEO Push Error: Missing endpoint, p256dh or auth');
            return false;
        }
        
        $payload_json = json_encode($payload);
        
        // Parse endpoint to get audience
        $url_parts = parse_url($endpoint);
        if (!$url_parts) return false;
        
        $audience = $url_parts['scheme'] . '://' . $url_parts['host'];
        
        // Encrypt the payload using Web Push encryption (RFC 8291)
        $encrypted = $this->encrypt_payload($payload_json, $p256dh, $auth);
        
        if (!$encrypted) {
            error_log('WSEO Push Error: Failed to encrypt payload');
            return false;
        }
        
        // Create VAPID JWT token
        $jwt = $this->create_vapid_jwt($audience, $vapid_public, $vapid_private);
        
        if (!$jwt) {
            error_log('WSEO Push Error: Failed to create VAPID JWT');
            return false;
        }
        
        // Send encrypted push
        $response = wp_remote_post($endpoint, array(
            'headers' => array(
                'Content-Type' => 'application/octet-stream',
                'Content-Encoding' => 'aes128gcm',
                'Content-Length' => strlen($encrypted),
                'TTL' => '86400',
                'Authorization' => 'vapid t=' . $jwt . ', k=' . $vapid_public
            ),
            'body' => $encrypted,
            'timeout' => 15
        ));
        
        if (is_wp_error($response)) {
            error_log('WSEO Push Error: ' . $response->get_error_message());
            return false;
        }
        
        $code = wp_remote_retrieve_response_code($response);
        
        if ($code === 201 || $code === 200) {
            return true;
        } elseif ($code === 404 || $code === 410) {
            // Subscription expired
            return 'expired';
        }
        
        error_log('WSEO Push Error: HTTP ' . $code . ' - ' . wp_remote_retrieve_body($response));
        return false;
    }
    
    /**
     * v2.10.01: Encrypt payload for Web Push (RFC 8291 - aes128gcm)
     */
    private function encrypt_payload($payload, $p256dh_base64, $auth_base64) {
        // Decode subscriber keys
        $p256dh = base64_decode($p256dh_base64);
        $auth = base64_decode($auth_base64);
        
        if (strlen($p256dh) !== 65 || strlen($auth) !== 16) {
            error_log('WSEO Push: Invalid key lengths - p256dh: ' . strlen($p256dh) . ', auth: ' . strlen($auth));
            return false;
        }
        
        // Generate local key pair
        $local_key = openssl_pkey_new(array(
            'curve_name' => 'prime256v1',
            'private_key_type' => OPENSSL_KEYTYPE_EC
        ));
        
        if (!$local_key) {
            error_log('WSEO Push: Failed to generate local EC key');
            return false;
        }
        
        $local_details = openssl_pkey_get_details($local_key);
        $local_public = chr(4) . str_pad($local_details['ec']['x'], 32, chr(0), STR_PAD_LEFT) 
                              . str_pad($local_details['ec']['y'], 32, chr(0), STR_PAD_LEFT);
        
        // Derive shared secret using ECDH
        $shared_secret = $this->ecdh_compute_secret($local_key, $p256dh);
        
        if (!$shared_secret) {
            error_log('WSEO Push: Failed to compute ECDH shared secret');
            return false;
        }
        
        // Generate salt (16 random bytes)
        $salt = random_bytes(16);
        
        // Derive keys using HKDF
        // PRK = HKDF-Extract(auth, shared_secret)
        $prk = hash_hmac('sha256', $shared_secret, $auth, true);
        
        // IKM for content encryption key
        $info_cek = "Content-Encoding: aes128gcm\x00";
        $cek = $this->hkdf_expand($prk, $salt . $info_cek, 16);
        
        // IKM for nonce
        $info_nonce = "Content-Encoding: nonce\x00";
        $nonce = $this->hkdf_expand($prk, $salt . $info_nonce, 12);
        
        // Add padding to payload (at least 2 bytes)
        $padding_length = max(0, 3052 - strlen($payload)); // Max record size minus overhead
        $padded_payload = $payload . "\x02" . str_repeat("\x00", min($padding_length, 16));
        
        // Encrypt with AES-128-GCM
        $ciphertext = openssl_encrypt(
            $padded_payload,
            'aes-128-gcm',
            $cek,
            OPENSSL_RAW_DATA,
            $nonce,
            $tag
        );
        
        if ($ciphertext === false) {
            error_log('WSEO Push: AES-GCM encryption failed');
            return false;
        }
        
        // Build aes128gcm encrypted content encoding header
        // Format: salt (16) || rs (4) || idlen (1) || keyid (65) || ciphertext || tag (16)
        $rs = pack('N', 4096); // Record size
        $idlen = chr(65); // Length of public key
        
        $encrypted = $salt . $rs . $idlen . $local_public . $ciphertext . $tag;
        
        return $encrypted;
    }
    
    /**
     * v2.10.01: Compute ECDH shared secret
     */
    private function ecdh_compute_secret($local_private_key, $remote_public_key) {
        // Create a temporary file with the remote public key in PEM format
        $x = substr($remote_public_key, 1, 32);
        $y = substr($remote_public_key, 33, 32);
        
        // Build DER encoded public key
        $der = "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48\xce\x3d\x03\x01\x07\x03\x42\x00" . $remote_public_key;
        
        $pem = "-----BEGIN PUBLIC KEY-----\n" . chunk_split(base64_encode($der), 64, "\n") . "-----END PUBLIC KEY-----";
        
        $remote_key = openssl_pkey_get_public($pem);
        if (!$remote_key) {
            return false;
        }
        
        // Use openssl_pkey_derive for ECDH (PHP 7.3+)
        if (function_exists('openssl_pkey_derive')) {
            $shared = openssl_pkey_derive($remote_key, $local_private_key);
            return $shared;
        }
        
        return false;
    }
    
    /**
     * v2.10.01: HKDF Expand function
     */
    private function hkdf_expand($prk, $info, $length) {
        $hash_len = 32; // SHA-256
        $n = ceil($length / $hash_len);
        $okm = '';
        $t = '';
        
        for ($i = 1; $i <= $n; $i++) {
            $t = hash_hmac('sha256', $t . $info . chr($i), $prk, true);
            $okm .= $t;
        }
        
        return substr($okm, 0, $length);
    }
    
    /**
     * v2.10.02: Create VAPID JWT token for push authentication
     */
    private function create_vapid_jwt($audience, $public_key, $private_key) {
        if (empty($public_key) || empty($private_key)) {
            error_log('WSEO Push: Empty VAPID keys');
            return false;
        }
        
        // JWT Header
        $header = array(
            'typ' => 'JWT',
            'alg' => 'ES256'
        );
        
        // JWT Claims
        $claims = array(
            'aud' => $audience,
            'exp' => time() + 43200, // 12 hours
            'sub' => 'mailto:admin@' . parse_url(home_url(), PHP_URL_HOST)
        );
        
        $header_b64 = $this->base64url_encode(json_encode($header));
        $claims_b64 = $this->base64url_encode(json_encode($claims));
        
        $signing_input = $header_b64 . '.' . $claims_b64;
        
        // Decode keys from base64url
        $private_key_raw = $this->base64url_decode($private_key);
        $public_key_raw = $this->base64url_decode($public_key);
        
        if (strlen($private_key_raw) !== 32) {
            error_log('WSEO Push: Invalid private key length: ' . strlen($private_key_raw));
            return false;
        }
        
        if (strlen($public_key_raw) !== 65) {
            error_log('WSEO Push: Invalid public key length: ' . strlen($public_key_raw));
            return false;
        }
        
        // Build PEM from raw keys
        $pem = $this->build_ec_pem($private_key_raw, $public_key_raw);
        
        if (!$pem) {
            error_log('WSEO Push: Failed to build PEM');
            return false;
        }
        
        $key = openssl_pkey_get_private($pem);
        if (!$key) {
            error_log('WSEO Push: Failed to load private key: ' . openssl_error_string());
            return false;
        }
        
        $signature = '';
        if (!openssl_sign($signing_input, $signature, $key, OPENSSL_ALGO_SHA256)) {
            error_log('WSEO Push: Failed to sign: ' . openssl_error_string());
            return false;
        }
        
        // Convert DER signature to raw 64-byte format
        $raw_sig = $this->der_to_raw_signature($signature);
        
        return $signing_input . '.' . $this->base64url_encode($raw_sig);
    }
    
    /**
     * v2.10.02: Build EC PEM key from raw bytes
     */
    private function build_ec_pem($private_key_raw, $public_key_raw) {
        // Remove 0x04 prefix from public key if present
        if (strlen($public_key_raw) === 65 && ord($public_key_raw[0]) === 4) {
            $public_xy = substr($public_key_raw, 1); // 64 bytes (x + y)
        } else {
            $public_xy = $public_key_raw;
        }
        
        // Build SEC1 EC private key DER structure
        // SEQUENCE {
        //   INTEGER 1 (version)
        //   OCTET STRING (private key - 32 bytes)
        //   [0] OID prime256v1
        //   [1] BIT STRING (public key)
        // }
        
        $oid_prime256v1 = "\x06\x08\x2a\x86\x48\xce\x3d\x03\x01\x07";
        
        // Build public key bit string: 0x00 (no unused bits) + 0x04 (uncompressed) + x + y
        $public_bitstring = "\x00\x04" . $public_xy;
        
        $der = "\x02\x01\x01"; // INTEGER 1
        $der .= "\x04\x20" . $private_key_raw; // OCTET STRING (32 bytes)
        $der .= "\xa0" . chr(strlen($oid_prime256v1)) . $oid_prime256v1; // [0] OID
        $der .= "\xa1" . chr(strlen($public_bitstring) + 2) . "\x03" . chr(strlen($public_bitstring)) . $public_bitstring; // [1] BIT STRING
        
        // Wrap in SEQUENCE
        $der = "\x30" . chr(strlen($der)) . $der;
        
        $pem = "-----BEGIN EC PRIVATE KEY-----\n" .
               chunk_split(base64_encode($der), 64, "\n") .
               "-----END EC PRIVATE KEY-----";
        
        return $pem;
    }
    
    /**
     * v2.10.0: Convert DER signature to raw 64-byte format
     */
    private function der_to_raw_signature($der_sig) {
        // Parse DER signature to extract R and S values
        $pos = 0;
        if (ord($der_sig[$pos++]) !== 0x30) return $der_sig;
        
        $len = ord($der_sig[$pos++]);
        if ($len & 0x80) $pos += ($len & 0x7f);
        
        // Get R
        if (ord($der_sig[$pos++]) !== 0x02) return $der_sig;
        $r_len = ord($der_sig[$pos++]);
        $r = substr($der_sig, $pos, $r_len);
        $pos += $r_len;
        
        // Get S
        if (ord($der_sig[$pos++]) !== 0x02) return $der_sig;
        $s_len = ord($der_sig[$pos++]);
        $s = substr($der_sig, $pos, $s_len);
        
        // Pad/trim to 32 bytes each
        $r = str_pad(ltrim($r, "\x00"), 32, "\x00", STR_PAD_LEFT);
        $s = str_pad(ltrim($s, "\x00"), 32, "\x00", STR_PAD_LEFT);
        
        return substr($r, -32) . substr($s, -32);
    }
    
    /**
     * v2.10.0: Back in stock subscribe
     */
    public function ajax_back_in_stock_subscribe() {
        $email = sanitize_email($_POST['email'] ?? '');
        $product_id = intval($_POST['product_id'] ?? 0);
        
        if (!is_email($email) || !$product_id) {
            wp_send_json_error('Invalid data');
        }
        
        $list = get_option('wseo_woo_back_in_stock_list', array());
        $list[] = array(
            'email' => $email,
            'product_id' => $product_id,
            'date' => current_time('mysql')
        );
        update_option('wseo_woo_back_in_stock_list', $list);
        
        wp_send_json_success('Added to waitlist');
    }
    
    /**
     * v2.10.0: Send review request emails (cron)
     */
    public function send_review_emails() {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_review_email_enabled', '0') !== '1') return;
        
        $delay_days = intval(get_option('wseo_woo_review_email_delay', 7));
        $subject = get_option('wseo_woo_review_email_subject', '');
        $body = get_option('wseo_woo_review_email_body', '');
        
        if (empty($subject) || empty($body)) return;
        
        // Get completed orders from X days ago
        $date_from = date('Y-m-d', strtotime("-{$delay_days} days"));
        $date_to = date('Y-m-d', strtotime("-{$delay_days} days +1 day"));
        
        $orders = wc_get_orders(array(
            'status' => 'completed',
            'date_completed' => $date_from . '...' . $date_to,
            'limit' => 50
        ));
        
        foreach ($orders as $order) {
            // Check if already sent
            if ($order->get_meta('_wseo_review_email_sent')) continue;
            
            $customer_email = $order->get_billing_email();
            $customer_name = $order->get_billing_first_name();
            
            if (empty($customer_email)) continue;
            
            // Get products with review links
            $products_html = '<ul style="padding-left: 20px;">';
            $first_product_id = 0;
            foreach ($order->get_items() as $item) {
                $product = $item->get_product();
                if ($product) {
                    if (!$first_product_id) $first_product_id = $product->get_id();
                    $review_link = get_permalink($product->get_id()) . '#reviews';
                    $products_html .= '<li style="margin-bottom: 10px;"><a href="' . esc_url($review_link) . '" style="color: #0073aa;">' . esc_html($item->get_name()) . '</a></li>';
                }
            }
            $products_html .= '</ul>';
            
            // Review link for first product
            $review_link = $first_product_id ? get_permalink($first_product_id) . '#reviews' : home_url('/');
            
            // Replace placeholders
            $email_subject = str_replace(
                array('{meno}', '{obchod}'),
                array($customer_name, get_bloginfo('name')),
                $subject
            );
            
            $email_body = str_replace(
                array('{meno}', '{dni}', '{produkty}', '{obchod}', '{link_recenzia}'),
                array($customer_name, $delay_days, $products_html, get_bloginfo('name'), $review_link),
                $body
            );
            
            // Wrap in HTML template
            $email_html = $this->get_email_template($email_subject, $email_body);
            
            // Send email
            $headers = array('Content-Type: text/html; charset=UTF-8');
            $sent = wp_mail($customer_email, $email_subject, $email_html, $headers);
            
            if ($sent) {
                // Mark as sent
                $order->update_meta_data('_wseo_review_email_sent', current_time('mysql'));
                $order->save();
            }
        }
    }
    
    /**
     * v2.10.0: Track abandoned cart when customer enters email on checkout
     */
    public function track_abandoned_cart($posted_data) {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_abandoned_enabled', '0') !== '1') return;
        
        parse_str($posted_data, $data);
        
        $email = isset($data['billing_email']) ? sanitize_email($data['billing_email']) : '';
        if (empty($email) || !is_email($email)) return;
        
        $this->save_abandoned_cart($email, isset($data['billing_first_name']) ? sanitize_text_field($data['billing_first_name']) : '');
    }
    
    /**
     * v2.10.0: Track cart for logged-in users (on add to cart / cart update)
     */
    public function track_logged_in_user_cart() {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_abandoned_enabled', '0') !== '1') return;
        if (!is_user_logged_in()) return;
        
        $user = wp_get_current_user();
        $email = $user->user_email;
        
        if (empty($email) || !is_email($email)) return;
        
        $this->save_abandoned_cart($email, $user->first_name ?: $user->display_name);
    }
    
    /**
     * v2.10.0: Save abandoned cart to database
     */
    private function save_abandoned_cart($email, $name = '') {
        $cart = WC()->cart;
        if (!$cart || $cart->is_empty()) return;
        
        // Get cart contents
        $cart_items = array();
        foreach ($cart->get_cart() as $cart_item) {
            $product = $cart_item['data'];
            $cart_items[] = array(
                'product_id' => $cart_item['product_id'],
                'name' => $product->get_name(),
                'quantity' => $cart_item['quantity'],
                'price' => $product->get_price(),
                'image' => wp_get_attachment_url($product->get_image_id())
            );
        }
        
        // Save abandoned cart
        $abandoned_carts = get_option('wseo_abandoned_carts', array());
        
        // Update or add cart for this email
        $found = false;
        foreach ($abandoned_carts as $key => $cart_data) {
            if ($cart_data['email'] === $email) {
                // Don't update if already sent or recovered
                if ($cart_data['email_sent'] || $cart_data['recovered']) {
                    // Create new entry instead
                    continue;
                }
                $abandoned_carts[$key]['items'] = $cart_items;
                $abandoned_carts[$key]['total'] = $cart->get_cart_contents_total();
                $abandoned_carts[$key]['updated'] = current_time('mysql');
                if ($name) {
                    $abandoned_carts[$key]['name'] = $name;
                }
                $found = true;
                break;
            }
        }
        
        if (!$found) {
            $abandoned_carts[] = array(
                'email' => $email,
                'name' => $name,
                'items' => $cart_items,
                'total' => $cart->get_cart_contents_total(),
                'created' => current_time('mysql'),
                'updated' => current_time('mysql'),
                'email_sent' => false,
                'recovered' => false
            );
        }
        
        update_option('wseo_abandoned_carts', $abandoned_carts);
    }
    
    /**
     * v2.10.0: Clear abandoned cart when order is completed
     */
    public function clear_abandoned_cart($order_id) {
        $order = wc_get_order($order_id);
        if (!$order) return;
        
        $email = $order->get_billing_email();
        if (empty($email)) return;
        
        $abandoned_carts = get_option('wseo_abandoned_carts', array());
        
        foreach ($abandoned_carts as $key => $cart_data) {
            if ($cart_data['email'] === $email) {
                $abandoned_carts[$key]['recovered'] = true;
                $abandoned_carts[$key]['order_id'] = $order_id;
                break;
            }
        }
        
        update_option('wseo_abandoned_carts', $abandoned_carts);
    }
    
    /**
     * v2.10.0: AJAX handler for tracking cart email
     */
    public function ajax_track_cart_email() {
        $email = sanitize_email($_POST['email'] ?? '');
        if (!is_email($email)) {
            wp_send_json_error('Invalid email');
        }
        
        $name = sanitize_text_field($_POST['name'] ?? '');
        $this->save_abandoned_cart($email, $name);
        
        wp_send_json_success('Tracked');
    }
    
    /**
     * v3.2: AJAX handler to test Google Indexing API connection
     */
    public function ajax_test_google_indexing() {
        if (!current_user_can('manage_options')) {
            wp_send_json_error(array('message' => 'Unauthorized'));
        }
        
        check_ajax_referer('wseo_nonce', 'nonce');
        
        $json_credentials = get_option('wseo_google_indexing_json', '');
        
        if (empty($json_credentials)) {
            wp_send_json_error(array('message' => 'JSON credentials nie sú nastavené'));
        }
        
        $creds = json_decode($json_credentials, true);
        
        if (!$creds || !isset($creds['client_email']) || !isset($creds['private_key'])) {
            wp_send_json_error(array('message' => 'Neplatný formát JSON credentials. Uistite sa, že vkladáte celý obsah súboru.'));
        }
        
        // Try to get access token
        $token_result = $this->get_google_access_token_for_test($creds);
        
        if (!$token_result['success']) {
            wp_send_json_error(array('message' => 'Chyba pri získavaní tokenu: ' . $token_result['error']));
        }
        
        // Test the API with a metadata request (doesn't actually index, just checks permissions)
        $test_url = home_url('/');
        $api_url = 'https://indexing.googleapis.com/v3/urlNotifications/metadata?url=' . urlencode($test_url);
        
        $response = wp_remote_get($api_url, array(
            'timeout' => 30,
            'headers' => array(
                'Authorization' => 'Bearer ' . $token_result['token'],
                'Content-Type' => 'application/json'
            )
        ));
        
        if (is_wp_error($response)) {
            wp_send_json_error(array('message' => 'Chyba komunikácie: ' . $response->get_error_message()));
        }
        
        $code = wp_remote_retrieve_response_code($response);
        $body = json_decode(wp_remote_retrieve_body($response), true);
        
        // 200 = OK, 404 = URL not indexed yet (but API works), 403 = permission denied
        if ($code === 200 || $code === 404) {
            wp_send_json_success(array(
                'message' => 'Pripojenie úspešné! Google Indexing API je správne nakonfigurované.',
                'details' => $code === 404 ? 'Homepage ešte nebola indexovaná cez API (to je OK).' : 'API funguje.'
            ));
        } elseif ($code === 403) {
            $error_msg = isset($body['error']['message']) ? $body['error']['message'] : 'Prístup zamietnutý';
            wp_send_json_error(array(
                'message' => 'Chyba oprávnení (403): ' . $error_msg . '. Uistite sa, že Service Account email je pridaný ako Vlastník v Search Console.'
            ));
        } else {
            $error_msg = isset($body['error']['message']) ? $body['error']['message'] : 'Neznáma chyba';
            wp_send_json_error(array('message' => 'API chyba (' . $code . '): ' . $error_msg));
        }
    }
    
    /**
     * v3.2: Get Google OAuth2 access token from Service Account credentials (for testing)
     */
    private function get_google_access_token_for_test($credentials) {
        $now = time();
        $exp = $now + 3600; // 1 hour
        
        // JWT Header
        $header = array(
            'alg' => 'RS256',
            'typ' => 'JWT'
        );
        
        // JWT Claims
        $claims = array(
            'iss' => $credentials['client_email'],
            'scope' => 'https://www.googleapis.com/auth/indexing',
            'aud' => 'https://oauth2.googleapis.com/token',
            'iat' => $now,
            'exp' => $exp
        );
        
        // Encode
        $header_encoded = $this->base64url_encode(json_encode($header));
        $claims_encoded = $this->base64url_encode(json_encode($claims));
        
        $signature_input = $header_encoded . '.' . $claims_encoded;
        
        // Sign with private key
        $private_key = $credentials['private_key'];
        $signature = '';
        
        $key_resource = openssl_pkey_get_private($private_key);
        if (!$key_resource) {
            return array('success' => false, 'error' => 'Neplatný privátny kľúč v JSON');
        }
        
        if (!openssl_sign($signature_input, $signature, $key_resource, OPENSSL_ALGO_SHA256)) {
            return array('success' => false, 'error' => 'Chyba pri podpisovaní JWT');
        }
        
        $jwt = $signature_input . '.' . $this->base64url_encode($signature);
        
        // Exchange JWT for access token
        $response = wp_remote_post('https://oauth2.googleapis.com/token', array(
            'timeout' => 30,
            'body' => array(
                'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
                'assertion' => $jwt
            )
        ));
        
        if (is_wp_error($response)) {
            return array('success' => false, 'error' => $response->get_error_message());
        }
        
        $body = json_decode(wp_remote_retrieve_body($response), true);
        
        if (isset($body['access_token'])) {
            return array('success' => true, 'token' => $body['access_token']);
        } else {
            $error = isset($body['error_description']) ? $body['error_description'] : (isset($body['error']) ? $body['error'] : 'Neznáma chyba');
            return array('success' => false, 'error' => $error);
        }
    }
    
    /**
     * v2.10.04: AJAX handler to send abandoned cart emails now (ignores delay)
     */
    public function ajax_send_abandoned_emails_now() {
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Unauthorized');
        }
        
        check_ajax_referer('wseo_abandoned_emails', 'nonce');
        
        if (!class_exists('WooCommerce')) {
            wp_send_json_error('WooCommerce nie je aktívny');
        }
        
        $subject = get_option('wseo_woo_abandoned_subject', '');
        $body = get_option('wseo_woo_abandoned_body', '');
        
        if (empty($subject) || empty($body)) {
            wp_send_json_error('Vyplňte predmet a text emailu');
        }
        
        $abandoned_carts = get_option('wseo_abandoned_carts', array());
        $sent = 0;
        
        foreach ($abandoned_carts as $key => $cart_data) {
            // Skip if already sent or recovered
            if ($cart_data['email_sent'] || $cart_data['recovered']) continue;
            
            $email = $cart_data['email'];
            $name = $cart_data['name'] ?: 'zákazník';
            
            // Build products HTML
            $products_html = '<table style="width: 100%; border-collapse: collapse;">';
            foreach ($cart_data['items'] as $item) {
                $products_html .= '<tr style="border-bottom: 1px solid #eee;">';
                if (!empty($item['image'])) {
                    $products_html .= '<td style="padding: 10px; width: 60px;"><img src="' . esc_url($item['image']) . '" width="50" height="50" style="object-fit: cover;"></td>';
                }
                $products_html .= '<td style="padding: 10px;"><strong>' . esc_html($item['name']) . '</strong><br>Množstvo: ' . intval($item['quantity']) . '</td>';
                $products_html .= '<td style="padding: 10px; text-align: right;">' . wc_price($item['price'] * $item['quantity']) . '</td>';
                $products_html .= '</tr>';
            }
            $products_html .= '</table>';
            
            $cart_link = wc_get_cart_url();
            
            $email_subject = str_replace(
                array('{meno}', '{obchod}'),
                array($name, get_bloginfo('name')),
                $subject
            );
            
            $email_body = str_replace(
                array('{meno}', '{produkty}', '{link_kosik}', '{obchod}', '{total}'),
                array($name, $products_html, $cart_link, get_bloginfo('name'), wc_price($cart_data['total'])),
                $body
            );
            
            $email_body .= '<p style="text-align: center; margin-top: 30px;"><a href="' . esc_url($cart_link) . '" style="display: inline-block; background: #0073aa; color: #fff; padding: 15px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">Dokončiť objednávku</a></p>';
            
            $email_html = $this->get_email_template($email_subject, $email_body);
            
            $headers = array('Content-Type: text/html; charset=UTF-8');
            $mail_sent = wp_mail($email, $email_subject, $email_html, $headers);
            
            if ($mail_sent) {
                $abandoned_carts[$key]['email_sent'] = true;
                $abandoned_carts[$key]['email_sent_date'] = current_time('mysql');
                $sent++;
            }
        }
        
        update_option('wseo_abandoned_carts', $abandoned_carts);
        
        wp_send_json_success(array('sent' => $sent));
    }
    
    /**
     * v2.10.0: Send abandoned cart emails (cron)
     */
    public function send_abandoned_cart_emails() {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_abandoned_enabled', '0') !== '1') return;
        
        $delay_hours = intval(get_option('wseo_woo_abandoned_delay', 1));
        $subject = get_option('wseo_woo_abandoned_subject', '');
        $body = get_option('wseo_woo_abandoned_body', '');
        
        if (empty($subject) || empty($body)) return;
        
        $abandoned_carts = get_option('wseo_abandoned_carts', array());
        $cutoff_time = strtotime("-{$delay_hours} hours");
        
        foreach ($abandoned_carts as $key => $cart_data) {
            // Skip if already sent, recovered, or too recent
            if ($cart_data['email_sent'] || $cart_data['recovered']) continue;
            
            $cart_time = strtotime($cart_data['updated']);
            if ($cart_time > $cutoff_time) continue;
            
            // Skip if cart is older than 7 days
            if ($cart_time < strtotime('-7 days')) {
                unset($abandoned_carts[$key]);
                continue;
            }
            
            $email = $cart_data['email'];
            $name = $cart_data['name'] ?: 'zákazník';
            
            // Build products HTML
            $products_html = '<table style="width: 100%; border-collapse: collapse;">';
            foreach ($cart_data['items'] as $item) {
                $products_html .= '<tr style="border-bottom: 1px solid #eee;">';
                if (!empty($item['image'])) {
                    $products_html .= '<td style="padding: 10px; width: 60px;"><img src="' . esc_url($item['image']) . '" width="50" height="50" style="object-fit: cover;"></td>';
                }
                $products_html .= '<td style="padding: 10px;"><strong>' . esc_html($item['name']) . '</strong><br>Množstvo: ' . intval($item['quantity']) . '</td>';
                $products_html .= '<td style="padding: 10px; text-align: right;">' . wc_price($item['price'] * $item['quantity']) . '</td>';
                $products_html .= '</tr>';
            }
            $products_html .= '</table>';
            
            // Cart recovery link
            $cart_link = wc_get_cart_url();
            
            // Replace placeholders
            $email_subject = str_replace(
                array('{meno}', '{obchod}'),
                array($name, get_bloginfo('name')),
                $subject
            );
            
            $email_body = str_replace(
                array('{meno}', '{produkty}', '{link_kosik}', '{obchod}', '{total}'),
                array($name, $products_html, $cart_link, get_bloginfo('name'), wc_price($cart_data['total'])),
                $body
            );
            
            // Add cart link button
            $email_body .= '<p style="text-align: center; margin-top: 30px;"><a href="' . esc_url($cart_link) . '" style="display: inline-block; background: #0073aa; color: #fff; padding: 15px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">Dokončiť objednávku</a></p>';
            
            // Wrap in HTML template
            $email_html = $this->get_email_template($email_subject, $email_body);
            
            // Send email
            $headers = array('Content-Type: text/html; charset=UTF-8');
            $sent = wp_mail($email, $email_subject, $email_html, $headers);
            
            if ($sent) {
                $abandoned_carts[$key]['email_sent'] = true;
                $abandoned_carts[$key]['email_sent_date'] = current_time('mysql');
            }
        }
        
        // Clean up old entries
        $abandoned_carts = array_values(array_filter($abandoned_carts, function($cart) {
            return strtotime($cart['updated']) > strtotime('-7 days');
        }));
        
        update_option('wseo_abandoned_carts', $abandoned_carts);
    }
    
    /**
     * v2.10.0: Show "Notify me" form on out of stock products
     */
    public function show_back_in_stock_form() {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_back_in_stock_enabled', '0') !== '1') return;
        
        global $product;
        if (!$product || $product->is_in_stock()) return;
        
        $product_id = $product->get_id();
        ?>
        <div class="wseo-back-in-stock-form" style="margin-top: 20px; padding: 20px; background: #f7f7f7; border-radius: 8px;">
            <p style="margin: 0 0 10px; font-weight: bold;">Tento produkt je momentálne vypredaný</p>
            <p style="margin: 0 0 15px; color: #666;">Zadajte váš email a upozorníme vás keď bude opäť dostupný:</p>
            <form id="wseo-back-in-stock-form-<?php echo $product_id; ?>" onsubmit="wseoBackInStock(event, <?php echo $product_id; ?>)">
                <input type="email" id="wseo-bis-email-<?php echo $product_id; ?>" placeholder="vas@email.sk" required style="padding: 10px; width: 200px; border: 1px solid #ddd; border-radius: 4px;">
                <button type="submit" style="padding: 10px 20px; background: #0073aa; color: #fff; border: none; border-radius: 4px; cursor: pointer;">Upozorniť ma</button>
            </form>
            <p id="wseo-bis-success-<?php echo $product_id; ?>" style="display: none; color: #28a745; margin-top: 10px;">Ďakujeme! Budeme vás informovať.</p>
        </div>
        <script>
        function wseoBackInStock(e, productId) {
            e.preventDefault();
            var email = document.getElementById('wseo-bis-email-' + productId).value;
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>');
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function() {
                if (xhr.status === 200) {
                    document.getElementById('wseo-back-in-stock-form-' + productId).style.display = 'none';
                    document.getElementById('wseo-bis-success-' + productId).style.display = 'block';
                }
            };
            xhr.send('action=wseo_back_in_stock_subscribe&email=' + encodeURIComponent(email) + '&product_id=' + productId);
        }
        </script>
        <?php
    }
    
    /**
     * v2.10.0: Check when product stock status changes
     */
    public function check_stock_status_change($product_id, $stock_status, $product) {
        if ($stock_status !== 'instock') return;
        
        // Send Push notification for back in stock
        $this->send_back_in_stock_push($product_id);
        
        // Send emails to waiting list
        if (get_option('wseo_woo_back_in_stock_enabled', '0') !== '1') return;
        
        // Trigger immediate check for this product
        $list = get_option('wseo_woo_back_in_stock_list', array());
        $subject = get_option('wseo_woo_back_in_stock_subject', '');
        $body = get_option('wseo_woo_back_in_stock_body', '');
        
        if (empty($subject) || empty($body)) return;
        
        $new_list = array();
        $product_obj = wc_get_product($product_id);
        
        foreach ($list as $item) {
            if ($item['product_id'] != $product_id) {
                $new_list[] = $item;
                continue;
            }
            
            // Send notification
            $email_subject = str_replace('{produkt}', $product_obj->get_name(), $subject);
            $email_body = str_replace(
                array('{meno}', '{produkt}', '{link_produkt}', '{obchod}'),
                array($item['name'] ?? '', $product_obj->get_name(), get_permalink($product_id), get_bloginfo('name')),
                $body
            );
            
            // Add product image and button
            $image = wp_get_attachment_url($product_obj->get_image_id());
            if ($image) {
                $email_body = '<p style="text-align: center;"><img src="' . esc_url($image) . '" style="max-width: 200px; height: auto;"></p>' . $email_body;
            }
            $email_body .= '<p style="text-align: center; margin-top: 30px;"><a href="' . esc_url(get_permalink($product_id)) . '" style="display: inline-block; background: #28a745; color: #fff; padding: 15px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">Zobraziť produkt</a></p>';
            
            $email_html = $this->get_email_template($email_subject, $email_body);
            
            $headers = array('Content-Type: text/html; charset=UTF-8');
            wp_mail($item['email'], $email_subject, $email_html, $headers);
        }
        
        update_option('wseo_woo_back_in_stock_list', $new_list);
    }
    
    /**
     * v2.10.0: Check back in stock and notify (cron)
     */
    public function check_back_in_stock() {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_back_in_stock_enabled', '0') !== '1') return;
        
        $list = get_option('wseo_woo_back_in_stock_list', array());
        $subject = get_option('wseo_woo_back_in_stock_subject', '');
        $body = get_option('wseo_woo_back_in_stock_body', '');
        
        if (empty($list) || empty($subject) || empty($body)) return;
        
        $new_list = array();
        
        foreach ($list as $item) {
            $product = wc_get_product($item['product_id']);
            
            if (!$product) continue;
            
            if ($product->is_in_stock()) {
                // Send notification
                $email_subject = str_replace('{produkt}', $product->get_name(), $subject);
                $email_body = str_replace(
                    array('{meno}', '{produkt}', '{link_produkt}', '{obchod}'),
                    array($item['name'] ?? '', $product->get_name(), get_permalink($product->get_id()), get_bloginfo('name')),
                    $body
                );
                
                // Add product image and button
                $image = wp_get_attachment_url($product->get_image_id());
                if ($image) {
                    $email_body = '<p style="text-align: center;"><img src="' . esc_url($image) . '" style="max-width: 200px; height: auto;"></p>' . $email_body;
                }
                $email_body .= '<p style="text-align: center; margin-top: 30px;"><a href="' . esc_url(get_permalink($product->get_id())) . '" style="display: inline-block; background: #28a745; color: #fff; padding: 15px 30px; text-decoration: none; border-radius: 5px; font-weight: bold;">Zobraziť produkt</a></p>';
                
                $email_html = $this->get_email_template($email_subject, $email_body);
                
                $headers = array('Content-Type: text/html; charset=UTF-8');
                wp_mail($item['email'], $email_subject, $email_html, $headers);
            } else {
                // Keep in list
                $new_list[] = $item;
            }
        }
        
        update_option('wseo_woo_back_in_stock_list', $new_list);
    }
    
    /**
     * v2.10.0: Send push notification for new product
     */
    public function send_new_product_push($post_id, $post) {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_new_product_push_enabled', '0') !== '1') return;
        if (get_option('wseo_push_enabled', '0') !== '1') return;
        
        // Only for new products (not updates)
        if (get_post_meta($post_id, '_wseo_new_product_push_sent', true)) return;
        
        // Get subscribers
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) return;
        
        $product = wc_get_product($post_id);
        if (!$product) return;
        
        // Prepare notification
        $title = get_option('wseo_woo_new_product_push_title', 'Nový produkt v ponuke!');
        $title = str_replace('{produkt}', $product->get_name(), $title);
        
        $body = $product->get_name();
        if ($product->get_price()) {
            $body .= ' - ' . wc_price($product->get_price());
        }
        
        $url = get_permalink($post_id);
        $icon = get_option('wseo_push_icon', '') ?: get_site_icon_url(192);
        $image = wp_get_attachment_url($product->get_image_id());
        
        $payload = array(
            'title' => $title,
            'body' => strip_tags($body),
            'icon' => $icon,
            'image' => $image,
            'url' => $url
        );
        
        // Send to all subscribers
        $this->send_push_to_all($payload);
        
        // Mark as sent
        update_post_meta($post_id, '_wseo_new_product_push_sent', current_time('mysql'));
    }
    
    /**
     * v2.10.0: Check if sale price was added to product
     */
    public function check_sale_price_change($meta_id, $post_id, $meta_key, $meta_value) {
        if ($meta_key !== '_sale_price') return;
        if (empty($meta_value)) return;
        if (get_post_type($post_id) !== 'product') return;
        
        $this->send_sale_product_push($post_id);
    }
    
    /**
     * v2.10.0: Send push notification for product on sale
     */
    public function send_sale_product_push($product_id, $sale_price = null) {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_sale_push_enabled', '0') !== '1') return;
        if (get_option('wseo_push_enabled', '0') !== '1') return;
        
        // Only send once per product sale
        $last_sent = get_post_meta($product_id, '_wseo_sale_push_sent', true);
        if ($last_sent && strtotime($last_sent) > strtotime('-24 hours')) return;
        
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) return;
        
        $product = wc_get_product($product_id);
        if (!$product || !$product->is_on_sale()) return;
        
        // Calculate discount
        $regular = floatval($product->get_regular_price());
        $sale = floatval($product->get_sale_price());
        $discount = $regular > 0 ? round((($regular - $sale) / $regular) * 100) : 0;
        
        $title = get_option('wseo_woo_sale_push_title', 'Zľava {zlava}% na {produkt}!');
        $title = str_replace(array('{produkt}', '{zlava}'), array($product->get_name(), $discount), $title);
        
        $body = $product->get_name() . ' - teraz za ' . strip_tags(wc_price($sale)) . ' (bolo ' . strip_tags(wc_price($regular)) . ')';
        
        $payload = array(
            'title' => $title,
            'body' => $body,
            'icon' => get_option('wseo_push_icon', '') ?: get_site_icon_url(192),
            'image' => wp_get_attachment_url($product->get_image_id()),
            'url' => get_permalink($product_id)
        );
        
        $this->send_push_to_all($payload);
        
        update_post_meta($product_id, '_wseo_sale_push_sent', current_time('mysql'));
    }
    
    /**
     * v2.10.0: Send push notification when product is back in stock
     */
    public function send_back_in_stock_push($product_id) {
        if (!class_exists('WooCommerce')) return;
        if (get_option('wseo_woo_back_in_stock_push_enabled', '0') !== '1') return;
        if (get_option('wseo_push_enabled', '0') !== '1') return;
        
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) return;
        
        $product = wc_get_product($product_id);
        if (!$product) return;
        
        $title = get_option('wseo_woo_back_in_stock_push_title', '{produkt} je opäť na sklade!');
        $title = str_replace('{produkt}', $product->get_name(), $title);
        
        $body = 'Obľúbený produkt je opäť dostupný. Neváhajte, zásoby sú obmedzené!';
        
        $payload = array(
            'title' => $title,
            'body' => $body,
            'icon' => get_option('wseo_push_icon', '') ?: get_site_icon_url(192),
            'image' => wp_get_attachment_url($product->get_image_id()),
            'url' => get_permalink($product_id)
        );
        
        $this->send_push_to_all($payload);
    }
    
    /**
     * v2.10.0: AJAX handler for manual push notification
     */
    public function ajax_send_manual_push() {
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Unauthorized');
        }
        
        check_ajax_referer('wseo_manual_push', 'nonce');
        
        $title = sanitize_text_field($_POST['title'] ?? '');
        $body = sanitize_text_field($_POST['body'] ?? '');
        $url = esc_url_raw($_POST['url'] ?? home_url('/'));
        $product_id = intval($_POST['product_id'] ?? 0);
        
        if (empty($title) || empty($body)) {
            wp_send_json_error('Vyplňte nadpis a správu');
        }
        
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) {
            wp_send_json_error('Žiadni odberatelia');
        }
        
        $icon = get_option('wseo_push_icon', '') ?: get_site_icon_url(192);
        $image = null;
        
        // If product selected, use its image
        if ($product_id && class_exists('WooCommerce')) {
            $product = wc_get_product($product_id);
            if ($product) {
                $image = wp_get_attachment_url($product->get_image_id());
                if (empty($url) || $url === home_url('/')) {
                    $url = get_permalink($product_id);
                }
            }
        }
        
        $payload = array(
            'title' => $title,
            'body' => $body,
            'icon' => $icon,
            'image' => $image,
            'url' => $url
        );
        
        $sent = $this->send_push_to_all($payload);
        
        wp_send_json_success(array(
            'sent' => $sent,
            'total' => count($subscribers)
        ));
    }
    
    /**
     * v2.10.03: AJAX handler to cleanup invalid push subscribers
     */
    public function ajax_cleanup_push_subscribers() {
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Unauthorized');
        }
        
        check_ajax_referer('wseo_cleanup_subscribers', 'nonce');
        
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) {
            wp_send_json_success(array('removed' => 0, 'remaining' => 0));
        }
        
        $valid = array();
        $removed = 0;
        
        foreach ($subscribers as $sub) {
            $endpoint = $sub['endpoint'] ?? '';
            if (empty($endpoint)) {
                $removed++;
                continue;
            }
            
            // Test endpoint with empty payload (just check if valid)
            $response = wp_remote_post($endpoint, array(
                'headers' => array(
                    'Content-Type' => 'application/octet-stream',
                    'Content-Length' => '0',
                    'TTL' => '0'
                ),
                'body' => '',
                'timeout' => 10
            ));
            
            $code = wp_remote_retrieve_response_code($response);
            
            // 404, 410 = expired/invalid, remove
            // 400, 401, 403 = might be valid but auth issue, keep
            // Other errors = keep
            if ($code === 404 || $code === 410) {
                $removed++;
            } else {
                $valid[] = $sub;
            }
        }
        
        update_option('wseo_push_subscribers', $valid);
        
        wp_send_json_success(array(
            'removed' => $removed,
            'remaining' => count($valid)
        ));
    }
    
    /**
     * v2.10.0: Helper function to send push to all subscribers
     */
    private function send_push_to_all($payload) {
        $subscribers = get_option('wseo_push_subscribers', array());
        if (empty($subscribers)) return 0;
        
        $sent = 0;
        $failed_keys = array();
        
        foreach ($subscribers as $key => $sub) {
            $result = $this->send_push_to_endpoint(
                $sub['endpoint'] ?? '',
                $sub['keys']['p256dh'] ?? '',
                $sub['keys']['auth'] ?? '',
                $payload
            );
            
            if ($result === true) {
                $sent++;
            } elseif ($result === 'expired') {
                $failed_keys[] = $key;
            }
        }
        
        // Remove expired subscriptions
        if (!empty($failed_keys)) {
            foreach ($failed_keys as $key) {
                unset($subscribers[$key]);
            }
            update_option('wseo_push_subscribers', array_values($subscribers));
        }
        
        return $sent;
    }
    
    /**
     * v2.10.0: Email HTML template wrapper
     */
    private function get_email_template($subject, $body) {
        $logo = get_option('wseo_organization_logo', '');
        $shop_name = get_bloginfo('name');
        $shop_url = home_url('/');
        
        $header = '';
        if ($logo) {
            $header = '<p style="text-align: center; margin-bottom: 30px;"><a href="' . esc_url($shop_url) . '"><img src="' . esc_url($logo) . '" alt="' . esc_attr($shop_name) . '" style="max-width: 200px; height: auto;"></a></p>';
        } else {
            $header = '<h1 style="text-align: center; margin-bottom: 30px;"><a href="' . esc_url($shop_url) . '" style="color: #333; text-decoration: none;">' . esc_html($shop_name) . '</a></h1>';
        }
        
        return '<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>' . esc_html($subject) . '</title>
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f4f4; padding: 20px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="padding: 40px;">
                            ' . $header . '
                            <div style="color: #333; line-height: 1.6;">
                                ' . nl2br($body) . '
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 20px 40px; background-color: #f9f9f9; border-top: 1px solid #eee; text-align: center; color: #999; font-size: 12px;">
                            <p style="margin: 0;">' . esc_html($shop_name) . ' | <a href="' . esc_url($shop_url) . '" style="color: #999;">' . esc_html(str_replace(array('https://', 'http://'), '', $shop_url)) . '</a></p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>';
    }

}

// Initialize
Webstudio_SEO_Pro::get_instance();

// Activation hook
register_activation_hook(__FILE__, array('Webstudio_SEO_Pro', 'activate_plugin'));
