<?php
/**
 * Marketing Page Template
 * v2.10.0: Push Notifications, Newsletter Pop-up, CTA Pop-up Builder, WooCommerce Tools
 */

if (!defined('ABSPATH')) exit;

// Check WooCommerce
$woo_active = class_exists('WooCommerce');

// Show regeneration message
settings_errors('wseo_marketing');

// Generate VAPID keys if not exists OR regenerate if invalid
$push_vapid_public = get_option('wseo_push_vapid_public', '');
$push_vapid_private = get_option('wseo_push_vapid_private', '');

// VAPID public key must be 65 bytes = 87 chars in base64url
$needs_regeneration = empty($push_vapid_public) || empty($push_vapid_private) || strlen($push_vapid_public) < 85;

if ($needs_regeneration) {
    $generated = false;
    
    // Try OpenSSL with EC key
    if (function_exists('openssl_pkey_new') && defined('OPENSSL_KEYTYPE_EC')) {
        $config = array(
            'curve_name' => 'prime256v1',
            'private_key_type' => OPENSSL_KEYTYPE_EC
        );
        
        $key = @openssl_pkey_new($config);
        
        if ($key) {
            $details = openssl_pkey_get_details($key);
            
            if (isset($details['ec']['x']) && isset($details['ec']['y']) && isset($details['ec']['d'])) {
                // X, Y, D must be exactly 32 bytes
                // If shorter - pad with leading zeros, if longer - take last 32 bytes
                $x = $details['ec']['x'];
                $y = $details['ec']['y'];
                $d = $details['ec']['d'];
                
                // Normalize to exactly 32 bytes
                if (strlen($x) < 32) $x = str_repeat(chr(0), 32 - strlen($x)) . $x;
                if (strlen($x) > 32) $x = substr($x, -32);
                
                if (strlen($y) < 32) $y = str_repeat(chr(0), 32 - strlen($y)) . $y;
                if (strlen($y) > 32) $y = substr($y, -32);
                
                if (strlen($d) < 32) $d = str_repeat(chr(0), 32 - strlen($d)) . $d;
                if (strlen($d) > 32) $d = substr($d, -32);
                
                // Public key: 0x04 + X (32 bytes) + Y (32 bytes) = 65 bytes total
                $public_key_raw = chr(4) . $x . $y;
                $public_key_base64 = rtrim(strtr(base64_encode($public_key_raw), '+/', '-_'), '=');
                
                // Private key: D (32 bytes)
                $private_key_base64 = rtrim(strtr(base64_encode($d), '+/', '-_'), '=');
                
                update_option('wseo_push_vapid_public', $public_key_base64);
                update_option('wseo_push_vapid_private', $private_key_base64);
                $generated = true;
                
                // Reload values
                $push_vapid_public = $public_key_base64;
                $push_vapid_private = $private_key_base64;
            }
        }
    }
    
    if (!$generated) {
        // Mark as failed - don't generate random keys as they won't work
        update_option('wseo_push_vapid_public', '');
        update_option('wseo_push_vapid_private', '');
    }
}

// Save settings
if (isset($_POST['wseo_marketing_save']) && wp_verify_nonce($_POST['wseo_marketing_nonce'], 'wseo_marketing_save')) {
    // Push Notifications
    update_option('wseo_push_enabled', isset($_POST['wseo_push_enabled']) ? '1' : '0');
    update_option('wseo_push_icon', esc_url_raw($_POST['wseo_push_icon'] ?? ''));
    update_option('wseo_push_welcome_title', sanitize_text_field($_POST['wseo_push_welcome_title'] ?? ''));
    update_option('wseo_push_welcome_message', sanitize_text_field($_POST['wseo_push_welcome_message'] ?? ''));
    update_option('wseo_push_new_post', isset($_POST['wseo_push_new_post']) ? '1' : '0');
    update_option('wseo_push_prompt_text', sanitize_text_field($_POST['wseo_push_prompt_text'] ?? ''));
    update_option('wseo_push_prompt_delay', intval($_POST['wseo_push_prompt_delay'] ?? 5));
    
    // Newsletter Pop-up
    update_option('wseo_newsletter_enabled', isset($_POST['wseo_newsletter_enabled']) ? '1' : '0');
    update_option('wseo_newsletter_title', sanitize_text_field($_POST['wseo_newsletter_title'] ?? ''));
    update_option('wseo_newsletter_text', wp_kses_post($_POST['wseo_newsletter_text'] ?? ''));
    update_option('wseo_newsletter_button', sanitize_text_field($_POST['wseo_newsletter_button'] ?? ''));
    update_option('wseo_newsletter_trigger', sanitize_text_field($_POST['wseo_newsletter_trigger'] ?? 'delay'));
    update_option('wseo_newsletter_delay', intval($_POST['wseo_newsletter_delay'] ?? 5));
    update_option('wseo_newsletter_scroll', intval($_POST['wseo_newsletter_scroll'] ?? 50));
    update_option('wseo_newsletter_webhook', esc_url_raw($_POST['wseo_newsletter_webhook'] ?? ''));
    update_option('wseo_newsletter_gdpr_text', sanitize_text_field($_POST['wseo_newsletter_gdpr_text'] ?? ''));
    update_option('wseo_newsletter_show_once', isset($_POST['wseo_newsletter_show_once']) ? '1' : '0');
    
    // CTA Pop-up
    update_option('wseo_cta_enabled', isset($_POST['wseo_cta_enabled']) ? '1' : '0');
    update_option('wseo_cta_title', sanitize_text_field($_POST['wseo_cta_title'] ?? ''));
    update_option('wseo_cta_text', wp_kses_post($_POST['wseo_cta_text'] ?? ''));
    update_option('wseo_cta_button_text', sanitize_text_field($_POST['wseo_cta_button_text'] ?? ''));
    update_option('wseo_cta_button_url', esc_url_raw($_POST['wseo_cta_button_url'] ?? ''));
    update_option('wseo_cta_button_phone', sanitize_text_field($_POST['wseo_cta_button_phone'] ?? ''));
    update_option('wseo_cta_trigger', sanitize_text_field($_POST['wseo_cta_trigger'] ?? 'delay'));
    update_option('wseo_cta_delay', intval($_POST['wseo_cta_delay'] ?? 10));
    update_option('wseo_cta_scroll', intval($_POST['wseo_cta_scroll'] ?? 70));
    update_option('wseo_cta_show_once', isset($_POST['wseo_cta_show_once']) ? '1' : '0');
    update_option('wseo_cta_pages', sanitize_textarea_field($_POST['wseo_cta_pages'] ?? ''));
    
    // Shared styling options
    update_option('wseo_popup_border_radius', sanitize_text_field($_POST['wseo_popup_border_radius'] ?? 'medium'));
    update_option('wseo_popup_width', sanitize_text_field($_POST['wseo_popup_width'] ?? 'medium'));
    update_option('wseo_popup_position', sanitize_text_field($_POST['wseo_popup_position'] ?? 'bottom-right'));
    
    // Newsletter colors
    update_option('wseo_newsletter_bg_color', sanitize_hex_color($_POST['wseo_newsletter_bg_color'] ?? '#ffffff'));
    update_option('wseo_newsletter_text_color', sanitize_hex_color($_POST['wseo_newsletter_text_color'] ?? '#333333'));
    update_option('wseo_newsletter_heading_color', sanitize_hex_color($_POST['wseo_newsletter_heading_color'] ?? '#111111'));
    update_option('wseo_newsletter_btn_bg_color', sanitize_hex_color($_POST['wseo_newsletter_btn_bg_color'] ?? '#0073aa'));
    update_option('wseo_newsletter_btn_text_color', sanitize_hex_color($_POST['wseo_newsletter_btn_text_color'] ?? '#ffffff'));
    
    // CTA colors
    update_option('wseo_cta_bg_color', sanitize_hex_color($_POST['wseo_cta_bg_color'] ?? '#ffffff'));
    update_option('wseo_cta_text_color', sanitize_hex_color($_POST['wseo_cta_text_color'] ?? '#333333'));
    update_option('wseo_cta_heading_color', sanitize_hex_color($_POST['wseo_cta_heading_color'] ?? '#111111'));
    update_option('wseo_cta_btn_bg_color', sanitize_hex_color($_POST['wseo_cta_btn_bg_color'] ?? '#28a745'));
    update_option('wseo_cta_btn_text_color', sanitize_hex_color($_POST['wseo_cta_btn_text_color'] ?? '#ffffff'));
    
    // Push colors
    update_option('wseo_push_bg_color', sanitize_hex_color($_POST['wseo_push_bg_color'] ?? '#ffffff'));
    update_option('wseo_push_text_color', sanitize_hex_color($_POST['wseo_push_text_color'] ?? '#333333'));
    update_option('wseo_push_btn_bg_color', sanitize_hex_color($_POST['wseo_push_btn_bg_color'] ?? '#0073aa'));
    update_option('wseo_push_btn_text_color', sanitize_hex_color($_POST['wseo_push_btn_text_color'] ?? '#ffffff'));
    
    // WooCommerce (if active)
    if ($woo_active) {
        update_option('wseo_woo_review_email_enabled', isset($_POST['wseo_woo_review_email_enabled']) ? '1' : '0');
        update_option('wseo_woo_review_email_delay', intval($_POST['wseo_woo_review_email_delay'] ?? 7));
        update_option('wseo_woo_review_email_subject', sanitize_text_field($_POST['wseo_woo_review_email_subject'] ?? ''));
        update_option('wseo_woo_review_email_body', wp_kses_post($_POST['wseo_woo_review_email_body'] ?? ''));
        
        update_option('wseo_woo_abandoned_enabled', isset($_POST['wseo_woo_abandoned_enabled']) ? '1' : '0');
        update_option('wseo_woo_abandoned_delay', intval($_POST['wseo_woo_abandoned_delay'] ?? 1));
        update_option('wseo_woo_abandoned_subject', sanitize_text_field($_POST['wseo_woo_abandoned_subject'] ?? ''));
        update_option('wseo_woo_abandoned_body', wp_kses_post($_POST['wseo_woo_abandoned_body'] ?? ''));
        
        update_option('wseo_woo_back_in_stock_enabled', isset($_POST['wseo_woo_back_in_stock_enabled']) ? '1' : '0');
        update_option('wseo_woo_back_in_stock_subject', sanitize_text_field($_POST['wseo_woo_back_in_stock_subject'] ?? ''));
        update_option('wseo_woo_back_in_stock_body', wp_kses_post($_POST['wseo_woo_back_in_stock_body'] ?? ''));
        
        // WooCommerce Push notifications
        update_option('wseo_woo_new_product_push_enabled', isset($_POST['wseo_woo_new_product_push_enabled']) ? '1' : '0');
        update_option('wseo_woo_new_product_push_title', sanitize_text_field($_POST['wseo_woo_new_product_push_title'] ?? 'Nový produkt v ponuke!'));
        
        update_option('wseo_woo_sale_push_enabled', isset($_POST['wseo_woo_sale_push_enabled']) ? '1' : '0');
        update_option('wseo_woo_sale_push_title', sanitize_text_field($_POST['wseo_woo_sale_push_title'] ?? 'Zľava {zlava}% na {produkt}!'));
        
        update_option('wseo_woo_back_in_stock_push_enabled', isset($_POST['wseo_woo_back_in_stock_push_enabled']) ? '1' : '0');
        update_option('wseo_woo_back_in_stock_push_title', sanitize_text_field($_POST['wseo_woo_back_in_stock_push_title'] ?? '{produkt} je opäť na sklade!'));
    }
    
    echo '<div class="notice notice-success is-dismissible"><p>Nastavenia uložené!</p></div>';
}

// Get saved values
$push_enabled = get_option('wseo_push_enabled', '0');
$push_icon = get_option('wseo_push_icon', '');
$push_welcome_title = get_option('wseo_push_welcome_title', 'Ďakujeme za prihlásenie!');
$push_welcome_message = get_option('wseo_push_welcome_message', 'Budeme vás informovať o novinkách.');
$push_new_post = get_option('wseo_push_new_post', '1');
$push_prompt_text = get_option('wseo_push_prompt_text', 'Chcete dostávať notifikácie o nových článkoch?');
$push_prompt_delay = get_option('wseo_push_prompt_delay', 5);
$push_vapid_public = get_option('wseo_push_vapid_public', '');
$push_vapid_private = get_option('wseo_push_vapid_private', '');

$newsletter_enabled = get_option('wseo_newsletter_enabled', '0');
$newsletter_title = get_option('wseo_newsletter_title', 'Prihláste sa na odber noviniek');
$newsletter_text = get_option('wseo_newsletter_text', 'Získajte najnovšie správy priamo do vášho emailu.');
$newsletter_button = get_option('wseo_newsletter_button', 'Prihlásiť sa');
$newsletter_trigger = get_option('wseo_newsletter_trigger', 'delay');
$newsletter_delay = get_option('wseo_newsletter_delay', 5);
$newsletter_scroll = get_option('wseo_newsletter_scroll', 50);
$newsletter_webhook = get_option('wseo_newsletter_webhook', '');
$newsletter_gdpr_text = get_option('wseo_newsletter_gdpr_text', 'Súhlasím so spracovaním osobných údajov');
$newsletter_show_once = get_option('wseo_newsletter_show_once', '1');

$cta_enabled = get_option('wseo_cta_enabled', '0');
$cta_title = get_option('wseo_cta_title', 'Potrebujete pomoc?');
$cta_text = get_option('wseo_cta_text', 'Zavolajte nám alebo napíšte správu.');
$cta_button_text = get_option('wseo_cta_button_text', 'Zavolať teraz');
$cta_button_url = get_option('wseo_cta_button_url', '');
$cta_button_phone = get_option('wseo_cta_button_phone', '');
$cta_trigger = get_option('wseo_cta_trigger', 'delay');
$cta_delay = get_option('wseo_cta_delay', 10);
$cta_scroll = get_option('wseo_cta_scroll', 70);
$cta_show_once = get_option('wseo_cta_show_once', '1');
$cta_pages = get_option('wseo_cta_pages', '');

// Shared styling options
$popup_border_radius = get_option('wseo_popup_border_radius', 'medium');
$popup_width = get_option('wseo_popup_width', 'medium');
$popup_position = get_option('wseo_popup_position', 'bottom-right');

// Newsletter colors
$newsletter_bg_color = get_option('wseo_newsletter_bg_color', '#ffffff');
$newsletter_text_color = get_option('wseo_newsletter_text_color', '#333333');
$newsletter_heading_color = get_option('wseo_newsletter_heading_color', '#111111');
$newsletter_btn_bg_color = get_option('wseo_newsletter_btn_bg_color', '#0073aa');
$newsletter_btn_text_color = get_option('wseo_newsletter_btn_text_color', '#ffffff');

// CTA colors
$cta_bg_color = get_option('wseo_cta_bg_color', '#ffffff');
$cta_text_color = get_option('wseo_cta_text_color', '#333333');
$cta_heading_color = get_option('wseo_cta_heading_color', '#111111');
$cta_btn_bg_color = get_option('wseo_cta_btn_bg_color', '#28a745');
$cta_btn_text_color = get_option('wseo_cta_btn_text_color', '#ffffff');

// Push colors
$push_bg_color = get_option('wseo_push_bg_color', '#ffffff');
$push_text_color = get_option('wseo_push_text_color', '#333333');
$push_btn_bg_color = get_option('wseo_push_btn_bg_color', '#0073aa');
$push_btn_text_color = get_option('wseo_push_btn_text_color', '#ffffff');

// WooCommerce options
$woo_review_email_enabled = get_option('wseo_woo_review_email_enabled', '0');
$woo_review_email_delay = get_option('wseo_woo_review_email_delay', 7);
$woo_review_email_subject = get_option('wseo_woo_review_email_subject', 'Ako ste spokojní s vašim nákupom, {meno}?');
$woo_review_email_body = get_option('wseo_woo_review_email_body', "Dobrý deň {meno},\n\nPred {dni} dňami ste u nás nakúpili. Budeme radi, ak nám napíšete ako ste spokojní.\n\nVaša recenzia pomôže ostatným zákazníkom pri výbere.\n\n{produkty}\n\nĎakujeme!\nTím {obchod}");

$woo_abandoned_enabled = get_option('wseo_woo_abandoned_enabled', '0');
$woo_abandoned_delay = get_option('wseo_woo_abandoned_delay', 1);
$woo_abandoned_subject = get_option('wseo_woo_abandoned_subject', 'Zabudli ste niečo v košíku?');
$woo_abandoned_body = get_option('wseo_woo_abandoned_body', "Dobrý deň {meno},\n\nVšimli sme si, že máte v košíku položky ktoré čakajú na dokončenie objednávky.\n\n{produkty}\n\nDokončite objednávku kým sú produkty ešte dostupné!\n\n{link_kosik}");

$woo_back_in_stock_enabled = get_option('wseo_woo_back_in_stock_enabled', '0');
$woo_back_in_stock_subject = get_option('wseo_woo_back_in_stock_subject', '{produkt} je opäť na sklade!');
$woo_back_in_stock_body = get_option('wseo_woo_back_in_stock_body', "Dobrý deň {meno},\n\nProdukt {produkt} na ktorý ste čakali je opäť dostupný!\n\n{link_produkt}\n\nNeváhajte, zásoby sú obmedzené.");

// Get stats
$newsletter_subscribers = get_option('wseo_newsletter_subscribers', array());
$push_subscribers = get_option('wseo_push_subscribers', array());
?>

<div class="wrap">
    <h1>📢 Marketing</h1>
    <p class="description">Nástroje na zvýšenie konverzií, zbieranie kontaktov a komunikáciu so zákazníkmi.</p>
    
    <form method="post" action="">
        <?php wp_nonce_field('wseo_marketing_save', 'wseo_marketing_nonce'); ?>
        
        <!-- Tab Navigation -->
        <h2 class="nav-tab-wrapper">
            <a href="#push" class="nav-tab nav-tab-active" data-tab="push">Push Notifikácie</a>
            <a href="#newsletter" class="nav-tab" data-tab="newsletter">Newsletter Pop-up</a>
            <a href="#cta" class="nav-tab" data-tab="cta">CTA Pop-up</a>
            <a href="#styling" class="nav-tab" data-tab="styling">Vzhľad</a>
            <?php if ($woo_active): ?>
            <a href="#woocommerce" class="nav-tab" data-tab="woocommerce">WooCommerce</a>
            <?php endif; ?>
        </h2>
        
        <!-- Push Notifications Tab -->
        <div id="tab-push" class="wseo-tab-content" style="display: block;">
            <div class="wseo-admin-card">
                <h2>Push Notifikácie</h2>
                <p class="description">Web Push notifikácie - informujte návštevníkov o novinkách bez potreby emailu.</p>
                
                <?php if (!is_ssl()): ?>
                <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin-bottom: 20px;">
                    <strong>Upozornenie:</strong> Push notifikácie vyžadujú HTTPS. Váš web nepoužíva SSL certifikát.
                </div>
                <?php endif; ?>
                
                <?php if (empty($push_vapid_public)): ?>
                <div style="background: #f8d7da; border-left: 4px solid #dc3545; padding: 15px; margin-bottom: 20px;">
                    <strong>Chyba:</strong> Nepodarilo sa vygenerovať VAPID kľúče. Skontrolujte či máte nainštalované OpenSSL rozšírenie.
                </div>
                <?php endif; ?>
                
                <table class="form-table">
                    <tr>
                        <th>Povoliť Push Notifikácie</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_push_enabled" value="1" <?php checked($push_enabled, '1'); ?> <?php if (!is_ssl() || empty($push_vapid_public)) echo 'disabled'; ?>>
                                Aktivovať push notifikácie na webe
                            </label>
                            <p class="description">Návštevníci uvidia výzvu na povolenie notifikácií.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_push_prompt_text">Text výzvy</label></th>
                        <td>
                            <input type="text" name="wseo_push_prompt_text" id="wseo_push_prompt_text" 
                                   value="<?php echo esc_attr($push_prompt_text); ?>" class="large-text"
                                   placeholder="Chcete dostávať notifikácie o nových článkoch?">
                            <p class="description">Text ktorý uvidia návštevníci pred povolením notifikácií.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_push_prompt_delay">Zobraziť výzvu po</label></th>
                        <td>
                            <input type="number" name="wseo_push_prompt_delay" id="wseo_push_prompt_delay" 
                                   value="<?php echo esc_attr($push_prompt_delay); ?>" min="0" max="60" class="small-text"> sekundách
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_push_icon">Ikona notifikácie</label></th>
                        <td>
                            <input type="url" name="wseo_push_icon" id="wseo_push_icon" 
                                   value="<?php echo esc_url($push_icon); ?>" class="large-text" 
                                   placeholder="https://example.com/icon-192x192.png">
                            <p class="description">URL ikony (odporúčané 192x192px). Ak prázdne, použije sa logo webu.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_push_welcome_title">Uvítacia správa - Nadpis</label></th>
                        <td>
                            <input type="text" name="wseo_push_welcome_title" id="wseo_push_welcome_title" 
                                   value="<?php echo esc_attr($push_welcome_title); ?>" class="large-text">
                            <p class="description">Zobrazí sa ihneď po prihlásení na odber.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_push_welcome_message">Uvítacia správa - Text</label></th>
                        <td>
                            <input type="text" name="wseo_push_welcome_message" id="wseo_push_welcome_message" 
                                   value="<?php echo esc_attr($push_welcome_message); ?>" class="large-text">
                        </td>
                    </tr>
                    <tr>
                        <th>Automatické notifikácie</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_push_new_post" value="1" <?php checked($push_new_post, '1'); ?>>
                                Poslať notifikáciu pri publikovaní nového článku
                            </label>
                        </td>
                    </tr>
                </table>
                
                <div style="background: #f0f6fc; border-left: 4px solid #0073aa; padding: 15px; margin-top: 20px;">
                    <h4 style="margin-top: 0;">Štatistiky</h4>
                    <p><strong><?php echo count($push_subscribers); ?></strong> prihlásených odberateľov</p>
                    <?php if (!empty($push_subscribers)): ?>
                    <details>
                        <summary>Zobraziť posledných 10</summary>
                        <ul style="margin-top: 10px;">
                            <?php foreach (array_slice(array_reverse($push_subscribers), 0, 10) as $sub): ?>
                            <li><?php echo esc_html($sub['date'] ?? 'N/A'); ?> - <?php echo esc_html(substr($sub['endpoint'] ?? '', 0, 60)); ?>...</li>
                            <?php endforeach; ?>
                        </ul>
                    </details>
                    <?php endif; ?>
                    
                    <?php if (!empty($push_subscribers)): ?>
                    <hr style="margin: 15px 0;">
                    <h4>Odoslať testovaciu notifikáciu</h4>
                    <p>
                        <input type="text" id="wseo_test_push_title" placeholder="Nadpis" class="regular-text">
                        <input type="text" id="wseo_test_push_message" placeholder="Správa" class="regular-text">
                        <button type="button" class="button" id="wseo_send_test_push">Odoslať test</button>
                    </p>
                    <?php endif; ?>
                </div>
                
                <?php if (!empty($push_vapid_public)): ?>
                <div style="background: #e7f5e9; border-left: 4px solid #28a745; padding: 15px; margin-top: 20px;">
                    <h4 style="margin-top: 0;">VAPID kľúče (automaticky vygenerované)</h4>
                    <p><strong>Public Key:</strong> (<?php echo strlen($push_vapid_public); ?> znakov - <?php echo strlen($push_vapid_public) >= 87 ? '✓ OK' : '✗ Potrebuje regeneráciu'; ?>)<br><code style="word-break: break-all; font-size: 11px;"><?php echo esc_html($push_vapid_public); ?></code></p>
                    <p style="margin-top: 10px;">
                        <a href="<?php echo wp_nonce_url(admin_url('admin.php?page=webstudio-seo-marketing&regenerate_vapid=1'), 'wseo_regenerate_vapid'); ?>" class="button" onclick="return confirm('Regenerovať VAPID kľúče? Existujúci odberatelia prestanú fungovať!');">Regenerovať kľúče</a>
                    </p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Newsletter Tab -->
        <div id="tab-newsletter" class="wseo-tab-content" style="display: none;">
            <div class="wseo-admin-card">
                <h2>📧 Newsletter Pop-up</h2>
                <p class="description">Zbierajte emailové adresy s GDPR súhlasom.</p>
                
                <table class="form-table">
                    <tr>
                        <th>Povoliť Newsletter Pop-up</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_newsletter_enabled" value="1" <?php checked($newsletter_enabled, '1'); ?>>
                                Aktivovať newsletter pop-up
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_newsletter_title">Nadpis</label></th>
                        <td>
                            <input type="text" name="wseo_newsletter_title" id="wseo_newsletter_title" 
                                   value="<?php echo esc_attr($newsletter_title); ?>" class="large-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_newsletter_text">Text</label></th>
                        <td>
                            <textarea name="wseo_newsletter_text" id="wseo_newsletter_text" rows="3" class="large-text"><?php echo esc_textarea($newsletter_text); ?></textarea>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_newsletter_button">Text tlačidla</label></th>
                        <td>
                            <input type="text" name="wseo_newsletter_button" id="wseo_newsletter_button" 
                                   value="<?php echo esc_attr($newsletter_button); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_newsletter_trigger">Kedy zobraziť</label></th>
                        <td>
                            <select name="wseo_newsletter_trigger" id="wseo_newsletter_trigger">
                                <option value="delay" <?php selected($newsletter_trigger, 'delay'); ?>>Po čase na stránke</option>
                                <option value="scroll" <?php selected($newsletter_trigger, 'scroll'); ?>>Po scrollovaní</option>
                                <option value="exit" <?php selected($newsletter_trigger, 'exit'); ?>>Exit intent (opustenie stránky)</option>
                            </select>
                        </td>
                    </tr>
                    <tr class="wseo-trigger-delay" <?php if ($newsletter_trigger !== 'delay') echo 'style="display:none;"'; ?>>
                        <th><label for="wseo_newsletter_delay">Oneskorenie (sekundy)</label></th>
                        <td>
                            <input type="number" name="wseo_newsletter_delay" id="wseo_newsletter_delay" 
                                   value="<?php echo esc_attr($newsletter_delay); ?>" min="1" max="120" class="small-text"> sekúnd
                        </td>
                    </tr>
                    <tr class="wseo-trigger-scroll" <?php if ($newsletter_trigger !== 'scroll') echo 'style="display:none;"'; ?>>
                        <th><label for="wseo_newsletter_scroll">Scrollovanie (%)</label></th>
                        <td>
                            <input type="number" name="wseo_newsletter_scroll" id="wseo_newsletter_scroll" 
                                   value="<?php echo esc_attr($newsletter_scroll); ?>" min="10" max="100" class="small-text"> % stránky
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_newsletter_webhook">Webhook URL</label></th>
                        <td>
                            <input type="url" name="wseo_newsletter_webhook" id="wseo_newsletter_webhook" 
                                   value="<?php echo esc_url($newsletter_webhook); ?>" class="large-text"
                                   placeholder="https://hooks.zapier.com/... alebo Mailchimp/Ecomail API">
                            <p class="description">
                                Email sa odošle POST requestom na tento URL. Podporuje: Zapier, Make, Mailchimp, Ecomail, atď.<br>
                                Ak prázdne, emaily sa uložia len lokálne v databáze.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_newsletter_gdpr_text">GDPR súhlas text</label></th>
                        <td>
                            <input type="text" name="wseo_newsletter_gdpr_text" id="wseo_newsletter_gdpr_text" 
                                   value="<?php echo esc_attr($newsletter_gdpr_text); ?>" class="large-text">
                        </td>
                    </tr>
                    <tr>
                        <th>Zobrazenie</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_newsletter_show_once" value="1" <?php checked($newsletter_show_once, '1'); ?>>
                                Zobraziť len raz (cookie 30 dní)
                            </label>
                        </td>
                    </tr>
                </table>
                
                <div style="background: #f0f6fc; border-left: 4px solid #0073aa; padding: 15px; margin-top: 20px;">
                    <h4 style="margin-top: 0;">Zozbierané emaily: <strong><?php echo count($newsletter_subscribers); ?></strong></h4>
                    <?php if (!empty($newsletter_subscribers)): ?>
                    <table class="wp-list-table widefat fixed striped" style="margin-top: 10px;">
                        <thead>
                            <tr>
                                <th>Email</th>
                                <th>Dátum</th>
                                <th>Stránka</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice(array_reverse($newsletter_subscribers), 0, 20) as $sub): ?>
                            <tr>
                                <td><?php echo esc_html($sub['email'] ?? ''); ?></td>
                                <td><?php echo esc_html($sub['date'] ?? ''); ?></td>
                                <td><?php echo esc_html($sub['page'] ?? ''); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <p style="margin-top: 10px;">
                        <a href="<?php echo admin_url('admin-ajax.php?action=wseo_export_newsletter&nonce=' . wp_create_nonce('wseo_export')); ?>" class="button">
                            📥 Exportovať všetky (CSV)
                        </a>
                    </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- CTA Pop-up Tab -->
        <div id="tab-cta" class="wseo-tab-content" style="display: none;">
            <div class="wseo-admin-card">
                <h2>💬 CTA Pop-up Builder</h2>
                <p class="description">Výzva k akcii - zavolať, napísať, stiahnuť PDF, objednať službu.</p>
                
                <table class="form-table">
                    <tr>
                        <th>Povoliť CTA Pop-up</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_cta_enabled" value="1" <?php checked($cta_enabled, '1'); ?>>
                                Aktivovať CTA pop-up
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_title">Nadpis</label></th>
                        <td>
                            <input type="text" name="wseo_cta_title" id="wseo_cta_title" 
                                   value="<?php echo esc_attr($cta_title); ?>" class="large-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_text">Text</label></th>
                        <td>
                            <textarea name="wseo_cta_text" id="wseo_cta_text" rows="3" class="large-text"><?php echo esc_textarea($cta_text); ?></textarea>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_button_text">Text tlačidla</label></th>
                        <td>
                            <input type="text" name="wseo_cta_button_text" id="wseo_cta_button_text" 
                                   value="<?php echo esc_attr($cta_button_text); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_button_phone">Telefónne číslo</label></th>
                        <td>
                            <input type="tel" name="wseo_cta_button_phone" id="wseo_cta_button_phone" 
                                   value="<?php echo esc_attr($cta_button_phone); ?>" class="regular-text"
                                   placeholder="+421 900 123 456">
                            <p class="description">Ak vyplnené, tlačidlo bude "tel:" odkaz. Inak použite URL nižšie.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_button_url">URL odkaz</label></th>
                        <td>
                            <input type="url" name="wseo_cta_button_url" id="wseo_cta_button_url" 
                                   value="<?php echo esc_url($cta_button_url); ?>" class="large-text"
                                   placeholder="https://example.com/kontakt/">
                            <p class="description">Použije sa ak nie je vyplnené telefónne číslo.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_trigger">Kedy zobraziť</label></th>
                        <td>
                            <select name="wseo_cta_trigger" id="wseo_cta_trigger">
                                <option value="delay" <?php selected($cta_trigger, 'delay'); ?>>Po čase na stránke</option>
                                <option value="scroll" <?php selected($cta_trigger, 'scroll'); ?>>Po scrollovaní</option>
                                <option value="exit" <?php selected($cta_trigger, 'exit'); ?>>Exit intent (opustenie stránky)</option>
                            </select>
                        </td>
                    </tr>
                    <tr class="wseo-cta-trigger-delay" <?php if ($cta_trigger !== 'delay') echo 'style="display:none;"'; ?>>
                        <th><label for="wseo_cta_delay">Oneskorenie (sekundy)</label></th>
                        <td>
                            <input type="number" name="wseo_cta_delay" id="wseo_cta_delay" 
                                   value="<?php echo esc_attr($cta_delay); ?>" min="1" max="120" class="small-text"> sekúnd
                        </td>
                    </tr>
                    <tr class="wseo-cta-trigger-scroll" <?php if ($cta_trigger !== 'scroll') echo 'style="display:none;"'; ?>>
                        <th><label for="wseo_cta_scroll">Scrollovanie (%)</label></th>
                        <td>
                            <input type="number" name="wseo_cta_scroll" id="wseo_cta_scroll" 
                                   value="<?php echo esc_attr($cta_scroll); ?>" min="10" max="100" class="small-text"> % stránky
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_cta_pages">Zobraziť len na stránkach</label></th>
                        <td>
                            <textarea name="wseo_cta_pages" id="wseo_cta_pages" rows="3" class="large-text" 
                                      placeholder="/sluzby/&#10;/kontakt/&#10;/cennik/"><?php echo esc_textarea($cta_pages); ?></textarea>
                            <p class="description">Jedna URL cesta na riadok. Ak prázdne, zobrazí sa všade.</p>
                        </td>
                    </tr>
                    <tr>
                        <th>Zobrazenie</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_cta_show_once" value="1" <?php checked($cta_show_once, '1'); ?>>
                                Zobraziť len raz za session
                            </label>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- Styling Tab -->
        <div id="tab-styling" class="wseo-tab-content" style="display: none;">
            
            <!-- Spoločné nastavenia -->
            <div class="wseo-admin-card">
                <h2>Spoločné nastavenia</h2>
                <table class="form-table">
                    <tr>
                        <th>Zaoblenie rohov</th>
                        <td>
                            <label><input type="radio" name="wseo_popup_border_radius" value="none" <?php checked($popup_border_radius, 'none'); ?>> Ostré (0px)</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_border_radius" value="small" <?php checked($popup_border_radius, 'small'); ?>> Mierne (6px)</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_border_radius" value="medium" <?php checked($popup_border_radius, 'medium'); ?>> Stredné (12px)</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_border_radius" value="large" <?php checked($popup_border_radius, 'large'); ?>> Veľké (20px)</label>
                        </td>
                    </tr>
                    <tr>
                        <th>Šírka okna</th>
                        <td>
                            <label><input type="radio" name="wseo_popup_width" value="narrow" <?php checked($popup_width, 'narrow'); ?>> Úzke (320px)</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_width" value="medium" <?php checked($popup_width, 'medium'); ?>> Stredné (400px)</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_width" value="wide" <?php checked($popup_width, 'wide'); ?>> Široké (500px)</label>
                        </td>
                    </tr>
                    <tr>
                        <th>Pozícia (Push výzva)</th>
                        <td>
                            <label><input type="radio" name="wseo_popup_position" value="bottom-right" <?php checked($popup_position, 'bottom-right'); ?>> Vpravo dole</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_position" value="bottom-left" <?php checked($popup_position, 'bottom-left'); ?>> Vľavo dole</label>
                            <label style="margin-left: 15px;"><input type="radio" name="wseo_popup_position" value="top-center" <?php checked($popup_position, 'top-center'); ?>> Stred hore</label>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Newsletter farby -->
            <div class="wseo-admin-card">
                <h2>Newsletter Pop-up - Farby</h2>
                <table class="form-table">
                    <tr>
                        <th>Pozadie</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_newsletter_bg_color" value="<?php echo esc_attr($newsletter_bg_color); ?>">
                            <input type="text" name="wseo_newsletter_bg_color" id="wseo_newsletter_bg_color" value="<?php echo esc_attr($newsletter_bg_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Text</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_newsletter_text_color" value="<?php echo esc_attr($newsletter_text_color); ?>">
                            <input type="text" name="wseo_newsletter_text_color" id="wseo_newsletter_text_color" value="<?php echo esc_attr($newsletter_text_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Nadpis</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_newsletter_heading_color" value="<?php echo esc_attr($newsletter_heading_color); ?>">
                            <input type="text" name="wseo_newsletter_heading_color" id="wseo_newsletter_heading_color" value="<?php echo esc_attr($newsletter_heading_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Tlačidlo (pozadie)</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_newsletter_btn_bg_color" value="<?php echo esc_attr($newsletter_btn_bg_color); ?>">
                            <input type="text" name="wseo_newsletter_btn_bg_color" id="wseo_newsletter_btn_bg_color" value="<?php echo esc_attr($newsletter_btn_bg_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Tlačidlo (text)</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_newsletter_btn_text_color" value="<?php echo esc_attr($newsletter_btn_text_color); ?>">
                            <input type="text" name="wseo_newsletter_btn_text_color" id="wseo_newsletter_btn_text_color" value="<?php echo esc_attr($newsletter_btn_text_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- CTA farby -->
            <div class="wseo-admin-card">
                <h2>CTA Pop-up - Farby</h2>
                <table class="form-table">
                    <tr>
                        <th>Pozadie</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_cta_bg_color" value="<?php echo esc_attr($cta_bg_color); ?>">
                            <input type="text" name="wseo_cta_bg_color" id="wseo_cta_bg_color" value="<?php echo esc_attr($cta_bg_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Text</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_cta_text_color" value="<?php echo esc_attr($cta_text_color); ?>">
                            <input type="text" name="wseo_cta_text_color" id="wseo_cta_text_color" value="<?php echo esc_attr($cta_text_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Nadpis</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_cta_heading_color" value="<?php echo esc_attr($cta_heading_color); ?>">
                            <input type="text" name="wseo_cta_heading_color" id="wseo_cta_heading_color" value="<?php echo esc_attr($cta_heading_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Tlačidlo (pozadie)</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_cta_btn_bg_color" value="<?php echo esc_attr($cta_btn_bg_color); ?>">
                            <input type="text" name="wseo_cta_btn_bg_color" id="wseo_cta_btn_bg_color" value="<?php echo esc_attr($cta_btn_bg_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Tlačidlo (text)</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_cta_btn_text_color" value="<?php echo esc_attr($cta_btn_text_color); ?>">
                            <input type="text" name="wseo_cta_btn_text_color" id="wseo_cta_btn_text_color" value="<?php echo esc_attr($cta_btn_text_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Push farby -->
            <div class="wseo-admin-card">
                <h2>Push Výzva - Farby</h2>
                <table class="form-table">
                    <tr>
                        <th>Pozadie</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_push_bg_color" value="<?php echo esc_attr($push_bg_color); ?>">
                            <input type="text" name="wseo_push_bg_color" id="wseo_push_bg_color" value="<?php echo esc_attr($push_bg_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Text</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_push_text_color" value="<?php echo esc_attr($push_text_color); ?>">
                            <input type="text" name="wseo_push_text_color" id="wseo_push_text_color" value="<?php echo esc_attr($push_text_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Tlačidlo "Povoliť" (pozadie)</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_push_btn_bg_color" value="<?php echo esc_attr($push_btn_bg_color); ?>">
                            <input type="text" name="wseo_push_btn_bg_color" id="wseo_push_btn_bg_color" value="<?php echo esc_attr($push_btn_bg_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                    <tr>
                        <th>Tlačidlo "Povoliť" (text)</th>
                        <td>
                            <input type="color" class="wseo-color-picker" data-target="wseo_push_btn_text_color" value="<?php echo esc_attr($push_btn_text_color); ?>">
                            <input type="text" name="wseo_push_btn_text_color" id="wseo_push_btn_text_color" value="<?php echo esc_attr($push_btn_text_color); ?>" class="wseo-color-text" maxlength="7" style="width: 80px;">
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <?php if ($woo_active): ?>
        <!-- WooCommerce Tab -->
        <div id="tab-woocommerce" class="wseo-tab-content" style="display: none;">
            
            <!-- Review Email -->
            <div class="wseo-admin-card">
                <h2>⭐ Email výzva na recenzie</h2>
                <p class="description">Automatický email zákazníkom po doručení objednávky s výzvou na napísanie recenzie.</p>
                
                <table class="form-table">
                    <tr>
                        <th>Povoliť</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_woo_review_email_enabled" value="1" <?php checked($woo_review_email_enabled, '1'); ?>>
                                Posielať emaily s výzvou na recenziu
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_review_email_delay">Odoslať po</label></th>
                        <td>
                            <input type="number" name="wseo_woo_review_email_delay" id="wseo_woo_review_email_delay" 
                                   value="<?php echo esc_attr($woo_review_email_delay); ?>" min="1" max="30" class="small-text"> 
                            dňoch od dokončenia objednávky
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_review_email_subject">Predmet emailu</label></th>
                        <td>
                            <input type="text" name="wseo_woo_review_email_subject" id="wseo_woo_review_email_subject" 
                                   value="<?php echo esc_attr($woo_review_email_subject); ?>" class="large-text">
                            <p class="description">Premenné: {meno}, {obchod}</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_review_email_body">Text emailu</label></th>
                        <td>
                            <textarea name="wseo_woo_review_email_body" id="wseo_woo_review_email_body" rows="8" class="large-text"><?php echo esc_textarea($woo_review_email_body); ?></textarea>
                            <p class="description">Premenné: {meno}, {dni}, {produkty}, {obchod}, {link_recenzia}</p>
                        </td>
                    </tr>
                </table>
                
                <?php
                // Count sent review emails
                global $wpdb;
                $review_emails_sent = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_wseo_review_email_sent'");
                ?>
                <div style="background: #e7f5e9; border-left: 4px solid #28a745; padding: 15px; margin-top: 20px;">
                    <p style="margin: 0;"><strong><?php echo intval($review_emails_sent); ?></strong> emailov s výzvou na recenziu bolo odoslaných</p>
                </div>
            </div>
            
            <!-- Abandoned Cart -->
            <div class="wseo-admin-card">
                <h2>Opustený košík</h2>
                <p class="description">Email zákazníkom ktorí pridali produkty do košíka ale nedokončili objednávku.</p>
                
                <table class="form-table">
                    <tr>
                        <th>Povoliť</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_woo_abandoned_enabled" value="1" <?php checked($woo_abandoned_enabled, '1'); ?>>
                                Posielať emaily o opustenom košíku
                            </label>
                            <p class="description">Funguje len pre prihlásených používateľov alebo ak zadali email pri checkout.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_abandoned_delay">Odoslať po</label></th>
                        <td>
                            <input type="number" name="wseo_woo_abandoned_delay" id="wseo_woo_abandoned_delay" 
                                   value="<?php echo esc_attr($woo_abandoned_delay); ?>" min="1" max="72" class="small-text"> 
                            hodinách od opustenia
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_abandoned_subject">Predmet emailu</label></th>
                        <td>
                            <input type="text" name="wseo_woo_abandoned_subject" id="wseo_woo_abandoned_subject" 
                                   value="<?php echo esc_attr($woo_abandoned_subject); ?>" class="large-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_abandoned_body">Text emailu</label></th>
                        <td>
                            <textarea name="wseo_woo_abandoned_body" id="wseo_woo_abandoned_body" rows="8" class="large-text"><?php echo esc_textarea($woo_abandoned_body); ?></textarea>
                            <p class="description">Premenné: {meno}, {produkty}, {link_kosik}, {obchod}, {total}</p>
                        </td>
                    </tr>
                </table>
                
                <?php
                $abandoned_carts = get_option('wseo_abandoned_carts', array());
                $active_carts = array_filter($abandoned_carts, function($c) { return !$c['recovered'] && !$c['email_sent']; });
                $sent_carts = array_filter($abandoned_carts, function($c) { return $c['email_sent'] && !$c['recovered']; });
                $recovered_carts = array_filter($abandoned_carts, function($c) { return $c['recovered']; });
                ?>
                <div style="background: #f0f6fc; border-left: 4px solid #0073aa; padding: 15px; margin-top: 20px;">
                    <h4 style="margin-top: 0;">Štatistiky opustených košíkov</h4>
                    <p>
                        <strong><?php echo count($active_carts); ?></strong> čakajúcich na odoslanie |
                        <strong><?php echo count($sent_carts); ?></strong> odoslaných emailov |
                        <strong><?php echo count($recovered_carts); ?></strong> obnovených objednávok
                        <?php if (count($active_carts) > 0): ?>
                        <button type="button" class="button" id="wseo_send_abandoned_now" style="margin-left: 15px;">
                            📧 Odoslať emaily teraz
                        </button>
                        <span id="wseo_abandoned_status" style="margin-left: 10px;"></span>
                        <?php endif; ?>
                    </p>
                    <?php if (!empty($abandoned_carts)): ?>
                    <details>
                        <summary>Zobraziť posledných 30 opustených košíkov</summary>
                        <table class="wp-list-table widefat fixed striped" style="margin-top: 10px;">
                            <thead>
                                <tr>
                                    <th>Email</th>
                                    <th>Produkty</th>
                                    <th>Suma</th>
                                    <th>Dátum</th>
                                    <th>Stav</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach (array_slice(array_reverse($abandoned_carts), 0, 30) as $cart): ?>
                                <tr>
                                    <td><?php echo esc_html($cart['email']); ?></td>
                                    <td><?php echo count($cart['items']); ?> položiek</td>
                                    <td><?php echo wc_price($cart['total']); ?></td>
                                    <td><?php echo esc_html($cart['updated']); ?></td>
                                    <td>
                                        <?php if ($cart['recovered']): ?>
                                            <span style="color: #28a745;">Obnovený</span>
                                        <?php elseif ($cart['email_sent']): ?>
                                            <span style="color: #ffc107;">Email odoslaný</span>
                                        <?php else: ?>
                                            <span style="color: #dc3545;">Čaká</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </details>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Back in Stock -->
            <div class="wseo-admin-card">
                <h2>Späť na sklade</h2>
                <p class="description">Notifikácie keď sa vypredaný produkt vráti na sklad.</p>
                
                <table class="form-table">
                    <tr>
                        <th>Povoliť</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_woo_back_in_stock_enabled" value="1" <?php checked($woo_back_in_stock_enabled, '1'); ?>>
                                Povoliť "Upozorniť ma" tlačidlo na vypredaných produktoch
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_back_in_stock_subject">Predmet emailu</label></th>
                        <td>
                            <input type="text" name="wseo_woo_back_in_stock_subject" id="wseo_woo_back_in_stock_subject" 
                                   value="<?php echo esc_attr($woo_back_in_stock_subject); ?>" class="large-text">
                            <p class="description">Premenné: {produkt}</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_back_in_stock_body">Text emailu</label></th>
                        <td>
                            <textarea name="wseo_woo_back_in_stock_body" id="wseo_woo_back_in_stock_body" rows="6" class="large-text"><?php echo esc_textarea($woo_back_in_stock_body); ?></textarea>
                            <p class="description">Premenné: {meno}, {produkt}, {link_produkt}, {obchod}</p>
                        </td>
                    </tr>
                </table>
                
                <?php
                $waiting_list = get_option('wseo_woo_back_in_stock_list', array());
                if (!empty($waiting_list)):
                ?>
                <div style="background: #f0f6fc; border-left: 4px solid #0073aa; padding: 15px; margin-top: 20px;">
                    <h4 style="margin-top: 0;">Čakajúci na produkty: <strong><?php echo count($waiting_list); ?></strong></h4>
                    <table class="wp-list-table widefat fixed striped" style="margin-top: 10px;">
                        <thead>
                            <tr>
                                <th>Email</th>
                                <th>Produkt</th>
                                <th>Dátum</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice(array_reverse($waiting_list), 0, 10) as $item): ?>
                            <tr>
                                <td><?php echo esc_html($item['email'] ?? ''); ?></td>
                                <td><?php echo esc_html(get_the_title($item['product_id'] ?? 0)); ?></td>
                                <td><?php echo esc_html($item['date'] ?? ''); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- WooCommerce Push Notifications -->
            <div class="wseo-admin-card">
                <h2>Push notifikácie WooCommerce</h2>
                <p class="description">Automatické push notifikácie pre rôzne udalosti v obchode.</p>
                
                <table class="form-table">
                    <tr>
                        <th colspan="2" style="padding-bottom: 0;"><strong>Nový produkt</strong></th>
                    </tr>
                    <tr>
                        <th>Povoliť</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_woo_new_product_push_enabled" value="1" <?php checked(get_option('wseo_woo_new_product_push_enabled', '0'), '1'); ?>>
                                Push notifikácia pri pridaní nového produktu
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_new_product_push_title">Nadpis</label></th>
                        <td>
                            <input type="text" name="wseo_woo_new_product_push_title" id="wseo_woo_new_product_push_title" 
                                   value="<?php echo esc_attr(get_option('wseo_woo_new_product_push_title', 'Nový produkt v ponuke!')); ?>" class="large-text">
                            <p class="description">Premenné: {produkt}</p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th colspan="2" style="padding-bottom: 0; border-top: 1px solid #eee; padding-top: 20px;"><strong>Produkt v akcii (zľava)</strong></th>
                    </tr>
                    <tr>
                        <th>Povoliť</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_woo_sale_push_enabled" value="1" <?php checked(get_option('wseo_woo_sale_push_enabled', '0'), '1'); ?>>
                                Push notifikácia keď sa nastaví zľava na produkt
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_sale_push_title">Nadpis</label></th>
                        <td>
                            <input type="text" name="wseo_woo_sale_push_title" id="wseo_woo_sale_push_title" 
                                   value="<?php echo esc_attr(get_option('wseo_woo_sale_push_title', 'Zľava {zlava}% na {produkt}!')); ?>" class="large-text">
                            <p class="description">Premenné: {produkt}, {zlava}</p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th colspan="2" style="padding-bottom: 0; border-top: 1px solid #eee; padding-top: 20px;"><strong>Späť na sklade</strong></th>
                    </tr>
                    <tr>
                        <th>Povoliť</th>
                        <td>
                            <label>
                                <input type="checkbox" name="wseo_woo_back_in_stock_push_enabled" value="1" <?php checked(get_option('wseo_woo_back_in_stock_push_enabled', '0'), '1'); ?>>
                                Push notifikácia keď sa vypredaný produkt vráti na sklad
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_woo_back_in_stock_push_title">Nadpis</label></th>
                        <td>
                            <input type="text" name="wseo_woo_back_in_stock_push_title" id="wseo_woo_back_in_stock_push_title" 
                                   value="<?php echo esc_attr(get_option('wseo_woo_back_in_stock_push_title', '{produkt} je opäť na sklade!')); ?>" class="large-text">
                            <p class="description">Premenné: {produkt}</p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Manual Push Notification -->
            <div class="wseo-admin-card">
                <h2>Manuálna push notifikácia</h2>
                <p class="description">Odošlite vlastnú push notifikáciu všetkým odberateľom.</p>
                
                <?php $push_count = count(get_option('wseo_push_subscribers', array())); ?>
                
                <?php if ($push_count > 0): ?>
                <table class="form-table">
                    <tr>
                        <th><label for="wseo_manual_push_title">Nadpis *</label></th>
                        <td>
                            <input type="text" id="wseo_manual_push_title" class="large-text" placeholder="Nadpis notifikácie">
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_manual_push_body">Správa *</label></th>
                        <td>
                            <textarea id="wseo_manual_push_body" class="large-text" rows="3" placeholder="Text notifikácie"></textarea>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_manual_push_url">URL (voliteľné)</label></th>
                        <td>
                            <input type="url" id="wseo_manual_push_url" class="large-text" placeholder="https://example.sk/stranka">
                            <p class="description">Kam sa dostane používateľ po kliknutí. Ak prázdne, otvorí sa homepage.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="wseo_manual_push_product">Produkt (voliteľné)</label></th>
                        <td>
                            <select id="wseo_manual_push_product" class="large-text">
                                <option value="">-- Vybrať produkt (pridá obrázok) --</option>
                                <?php
                                $products = wc_get_products(array('limit' => 50, 'orderby' => 'date', 'order' => 'DESC'));
                                foreach ($products as $product):
                                ?>
                                <option value="<?php echo $product->get_id(); ?>"><?php echo esc_html($product->get_name()); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th></th>
                        <td>
                            <button type="button" class="button button-primary" id="wseo_send_manual_push">
                                Odoslať notifikáciu (<?php echo $push_count; ?> odberateľov)
                            </button>
                            <button type="button" class="button" id="wseo_cleanup_subscribers" style="margin-left: 10px;">
                                🧹 Vyčistiť neplatných
                            </button>
                            <span id="wseo_manual_push_status" style="margin-left: 10px;"></span>
                        </td>
                    </tr>
                </table>
                <?php else: ?>
                <p style="padding: 20px; background: #fff3cd; border-radius: 4px;">
                    Zatiaľ nemáte žiadnych push odberateľov. Najprv povoľte Push notifikácie v záložke "Push Notifikácie".
                </p>
                <?php endif; ?>
            </div>
            
            <!-- WooCommerce Stats -->
            <?php
            global $wpdb;
            $review_emails_sent = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_wseo_review_email_sent'");
            $new_product_pushes = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_wseo_new_product_push_sent'");
            $sale_pushes = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_wseo_sale_push_sent'");
            ?>
            <div class="wseo-admin-card">
                <h2>Štatistiky WooCommerce Marketing</h2>
                <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-top: 15px;">
                    <div style="background: #f0f6fc; padding: 20px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 32px; font-weight: bold; color: #0073aa;"><?php echo intval($review_emails_sent); ?></div>
                        <div style="color: #666;">Review emailov</div>
                    </div>
                    <div style="background: #e7f5e9; padding: 20px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 32px; font-weight: bold; color: #28a745;"><?php echo intval($new_product_pushes); ?></div>
                        <div style="color: #666;">Nový produkt push</div>
                    </div>
                    <div style="background: #fff3cd; padding: 20px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 32px; font-weight: bold; color: #856404;"><?php echo intval($sale_pushes); ?></div>
                        <div style="color: #666;">Zľava push</div>
                    </div>
                    <div style="background: #f8d7da; padding: 20px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 32px; font-weight: bold; color: #721c24;"><?php echo count($waiting_list); ?></div>
                        <div style="color: #666;">Čaká na tovar</div>
                    </div>
                    <div style="background: #f8d7da; padding: 20px; border-radius: 8px; text-align: center;">
                        <?php
                        $review_emails_sent = get_option('wseo_review_emails_sent_count', 0);
                        ?>
                        <div style="font-size: 32px; font-weight: bold; color: #721c24;"><?php echo intval($review_emails_sent); ?></div>
                        <div style="color: #666;">Odoslaných recenzií</div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <p class="submit">
            <button type="submit" name="wseo_marketing_save" class="button button-primary button-hero">
                💾 Uložiť všetky nastavenia
            </button>
        </p>
    </form>
</div>

<style>
.wseo-admin-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
    margin: 20px 0;
    box-shadow: 0 1px 1px rgba(0,0,0,.04);
}
.wseo-admin-card h2 {
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}
.nav-tab-wrapper {
    margin-bottom: 0;
}
.wseo-tab-content {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-top: none;
    padding: 0;
}
</style>

<script>
jQuery(document).ready(function($) {
    // Color picker + text input synchronization
    $('.wseo-color-picker').on('input change', function() {
        var targetId = $(this).data('target');
        $('#' + targetId).val($(this).val());
    });
    
    $('.wseo-color-text').on('input change', function() {
        var val = $(this).val();
        // Add # if missing
        if (val && val.charAt(0) !== '#') {
            val = '#' + val;
            $(this).val(val);
        }
        // Validate hex color
        if (/^#[0-9A-Fa-f]{6}$/.test(val)) {
            $(this).prev('.wseo-color-picker').val(val);
        }
    });
    
    // Tab switching
    $('.nav-tab').on('click', function(e) {
        e.preventDefault();
        var tab = $(this).data('tab');
        
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        $('.wseo-tab-content').hide();
        $('#tab-' + tab).show();
    });
    
    // Newsletter trigger visibility
    $('#wseo_newsletter_trigger').on('change', function() {
        var val = $(this).val();
        $('.wseo-trigger-delay, .wseo-trigger-scroll').hide();
        if (val === 'delay') $('.wseo-trigger-delay').show();
        if (val === 'scroll') $('.wseo-trigger-scroll').show();
    });
    
    // CTA trigger visibility
    $('#wseo_cta_trigger').on('change', function() {
        var val = $(this).val();
        $('.wseo-cta-trigger-delay, .wseo-cta-trigger-scroll').hide();
        if (val === 'delay') $('.wseo-cta-trigger-delay').show();
        if (val === 'scroll') $('.wseo-cta-trigger-scroll').show();
    });
    
    // Test Push notification
    $('#wseo_send_test_push').on('click', function() {
        var $btn = $(this);
        var title = $('#wseo_test_push_title').val() || 'Test notifikácia';
        var message = $('#wseo_test_push_message').val() || 'Toto je testovacia správa.';
        
        $btn.prop('disabled', true).text('Odosielam...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_send_test_push',
                title: title,
                message: message
            },
            success: function(response) {
                if (response.success) {
                    alert('Odoslané ' + response.data.sent + ' z ' + response.data.total + ' odberateľom.');
                } else {
                    alert('Chyba: ' + (response.data || 'Neznáma chyba'));
                }
                $btn.prop('disabled', false).text('Odoslať test');
            },
            error: function() {
                alert('Chyba pri odosielaní.');
                $btn.prop('disabled', false).text('Odoslať test');
            }
        });
    });
    
    // Manual Push notification (WooCommerce)
    $('#wseo_send_manual_push').on('click', function() {
        var $btn = $(this);
        var title = $('#wseo_manual_push_title').val();
        var body = $('#wseo_manual_push_body').val();
        var url = $('#wseo_manual_push_url').val();
        var product_id = $('#wseo_manual_push_product').val();
        
        if (!title || !body) {
            alert('Vyplňte nadpis a správu.');
            return;
        }
        
        $btn.prop('disabled', true).text('Odosielam...');
        $('#wseo_manual_push_status').text('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_send_manual_push',
                nonce: '<?php echo wp_create_nonce('wseo_manual_push'); ?>',
                title: title,
                body: body,
                url: url,
                product_id: product_id
            },
            success: function(response) {
                if (response.success) {
                    $('#wseo_manual_push_status').html('<span style="color: #28a745;">✓ Odoslané ' + response.data.sent + ' z ' + response.data.total + ' odberateľom</span>');
                    // Clear form
                    $('#wseo_manual_push_title, #wseo_manual_push_body, #wseo_manual_push_url').val('');
                    $('#wseo_manual_push_product').val('');
                } else {
                    $('#wseo_manual_push_status').html('<span style="color: #dc3545;">✗ ' + (response.data || 'Chyba') + '</span>');
                }
                $btn.prop('disabled', false).text($btn.text().replace('Odosielam...', 'Odoslať notifikáciu'));
            },
            error: function() {
                $('#wseo_manual_push_status').html('<span style="color: #dc3545;">✗ Chyba pri odosielaní</span>');
                $btn.prop('disabled', false);
            }
        });
    });
    
    // Cleanup invalid subscribers
    $('#wseo_cleanup_subscribers').on('click', function() {
        if (!confirm('Otestovať všetkých odberateľov a odstrániť neplatných?')) return;
        
        var $btn = $(this);
        $btn.prop('disabled', true).text('Čistím...');
        $('#wseo_manual_push_status').text('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_cleanup_push_subscribers',
                nonce: '<?php echo wp_create_nonce('wseo_cleanup_subscribers'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $('#wseo_manual_push_status').html('<span style="color: #28a745;">✓ Odstránených ' + response.data.removed + ' neplatných, zostáva ' + response.data.remaining + '</span>');
                    if (response.data.removed > 0) {
                        setTimeout(function() { location.reload(); }, 2000);
                    }
                } else {
                    $('#wseo_manual_push_status').html('<span style="color: #dc3545;">✗ ' + (response.data || 'Chyba') + '</span>');
                }
                $btn.prop('disabled', false).text('🧹 Vyčistiť neplatných');
            },
            error: function() {
                $('#wseo_manual_push_status').html('<span style="color: #dc3545;">✗ Chyba</span>');
                $btn.prop('disabled', false).text('🧹 Vyčistiť neplatných');
            }
        });
    });
    
    // Send abandoned cart emails now
    $('#wseo_send_abandoned_now').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Odosielam...');
        $('#wseo_abandoned_status').text('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wseo_send_abandoned_emails_now',
                nonce: '<?php echo wp_create_nonce('wseo_abandoned_emails'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    $('#wseo_abandoned_status').html('<span style="color: #28a745;">✓ Odoslaných ' + response.data.sent + ' emailov</span>');
                    if (response.data.sent > 0) {
                        setTimeout(function() { location.reload(); }, 2000);
                    }
                } else {
                    $('#wseo_abandoned_status').html('<span style="color: #dc3545;">✗ ' + (response.data || 'Chyba') + '</span>');
                }
                $btn.prop('disabled', false).text('📧 Odoslať emaily teraz');
            },
            error: function() {
                $('#wseo_abandoned_status').html('<span style="color: #dc3545;">✗ Chyba</span>');
                $btn.prop('disabled', false).text('📧 Odoslať emaily teraz');
            }
        });
    });
});
</script>
