<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wseo-meta-box">
    
    <!-- Tabs Navigation -->
    <div class="wseo-tabs-nav">
        <button type="button" class="wseo-tab-btn active" data-tab="general" title="Meta titulok, popis a kľúčové slová pre vyhľadávače">
            <span class="dashicons dashicons-admin-generic"></span>
            <span class="wseo-tab-text">SEO</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="social" title="Open Graph tagy pre Facebook, Twitter a LinkedIn">
            <span class="dashicons dashicons-share"></span>
            <span class="wseo-tab-text">Social</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="audit" title="SEO skóre a analýza optimalizácie obsahu">
            <span class="dashicons dashicons-yes-alt"></span>
            <span class="wseo-tab-text">Audit</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="links" title="Prehľad interných a externých odkazov v obsahu">
            <span class="dashicons dashicons-admin-links"></span>
            <span class="wseo-tab-text">Odkazy</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="faq" title="FAQ Schema pre zobrazenie otázok a odpovedí vo výsledkoch Google">
            <span class="dashicons dashicons-editor-help"></span>
            <span class="wseo-tab-text">FAQ</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="advanced" title="Breadcrumbs, vlastné Schema.org značky a ďalšie nastavenia">
            <span class="dashicons dashicons-admin-tools"></span>
            <span class="wseo-tab-text">Rozšírené</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="copywriting" title="Analýza čitateľnosti - dĺžka viet, prechodové slová, pasívne tvary">
            <span class="dashicons dashicons-edit-page"></span>
            <span class="wseo-tab-text">Čitateľnosť</span>
        </button>
        <button type="button" class="wseo-tab-btn" data-tab="visibility" title="301 presmerovanie, noindex, nofollow a canonical URL">
            <span class="dashicons dashicons-visibility"></span>
            <span class="wseo-tab-text">Viditeľnosť</span>
        </button>
        <?php if ($post->post_type === 'page'): ?>
        <button type="button" class="wseo-tab-btn" data-tab="schema" title="Štruktúrované dáta JSON-LD pre rich snippets v Google">
            <span class="dashicons dashicons-code-standards"></span>
            <span class="wseo-tab-text">Schema</span>
        </button>
        <?php endif; ?>
    </div>

    <!-- Tab: General -->
    <div class="wseo-tab-content active" id="wseo-tab-general">
        
        <!-- Meta Title -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_meta_title">
                    <strong>Meta titulok</strong>
                    <span class="wseo-help" title="Zobrazuje sa vo výsledkoch vyhľadávania ako názov stránky.">?</span>
                </label>
                <div class="wseo-char-info">
                    Characters: <span id="wseo-title-count"><?php echo mb_strlen($meta_title); ?></span>
                    <span class="wseo-rating" id="wseo-title-rating"></span>
                </div>
            </div>
            <div class="wseo-field-input">
                <div class="wseo-progress-bar">
                    <div class="wseo-progress-fill" id="wseo-title-progress"></div>
                </div>
                <div class="wseo-title-wrap" style="display: flex; align-items: center; gap: 0;">
                    <input 
                        type="text" 
                        id="wseo_meta_title" 
                        name="wseo_meta_title" 
                        value="<?php echo esc_attr($meta_title); ?>"
                        placeholder="<?php echo esc_attr($auto_title); ?>"
                        class="large-text"
                        data-site-name="<?php echo esc_attr($site_name); ?>"
                        data-separator="<?php echo esc_attr(get_option('wseo_title_separator', ' - ')); ?>"
                        style="flex: 1;"
                    ><span class="wseo-title-addition" id="wseo-title-addition" style="color: #666; font-style: italic; white-space: nowrap; padding: 5px 10px; background: #f0f0f1; border: 1px solid #8c8f94; border-left: 0; border-radius: 0 4px 4px 0;"><?php echo esc_html(get_option('wseo_title_separator', ' - ') . $site_name); ?></span>
                </div>
                <p class="wseo-field-note">
                    Celková dĺžka vrátane "<?php echo esc_html(get_option('wseo_title_separator', ' - ') . $site_name); ?>" by mala byť 30-60 znakov.
                </p>
            </div>
        </div>

        <!-- Meta Description -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_meta_description">
                    <strong>Meta popis</strong>
                    <span class="wseo-help" title="Krátky popis stránky pre vyhľadávače.">?</span>
                </label>
                <div class="wseo-char-info">
                    Characters: <span id="wseo-desc-count"><?php echo mb_strlen($meta_description); ?></span>
                    <span class="wseo-rating" id="wseo-desc-rating"></span>
                </div>
            </div>
            <div class="wseo-field-input">
                <div class="wseo-progress-bar">
                    <div class="wseo-progress-fill" id="wseo-desc-progress"></div>
                </div>
                <textarea 
                    id="wseo_meta_description" 
                    name="wseo_meta_description" 
                    rows="3"
                    class="large-text"
                    placeholder="<?php echo esc_attr($auto_description); ?>"
                ><?php echo esc_textarea($meta_description); ?></textarea>
            </div>
        </div>

        <!-- Focus Keyword (v2.9.14) -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_meta_keywords">
                    <strong>Focus Keyword</strong>
                    <span class="wseo-help" title="Hlavné kľúčové slovo pre SEO analýzu a meta keywords tag.">?</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input 
                    type="text" 
                    id="wseo_meta_keywords" 
                    name="wseo_meta_keywords" 
                    value="<?php echo esc_attr($meta_keywords); ?>"
                    class="large-text"
                    placeholder="<?php echo esc_attr($auto_keywords ?: 'napr. servis pre WordPress'); ?>"
                >
                <p class="wseo-field-note" style="color: #2271b1; font-size: 12px; margin-top: 5px;">
                    <strong>💡 TIP:</strong> Zadajte len 1 presnú long tail frázu (napr. "servis pre WordPress"), nie zoznam slov. Menej je viac!
                </p>
                
                <?php if (!empty($meta_keywords)): ?>
                <!-- Focus Keyword Analysis -->
                <div id="wseo-focus-keyword-analysis" style="margin-top: 15px; padding: 15px; background: #f8f9fa; border-radius: 8px; border-left: 4px solid #667eea;">
                    <strong style="display: block; margin-bottom: 10px;">Analýza Focus Keyword: "<?php echo esc_html($meta_keywords); ?>"</strong>
                    <?php
                    $focus_kw = strtolower(trim($meta_keywords));
                    $focus_words = array_map('trim', explode(',', $focus_kw));
                    $primary_kw = $focus_words[0];
                    
                    // Check in title
                    $in_title = stripos($meta_title, $primary_kw) !== false;
                    
                    // Check in URL/slug
                    $post_slug = $post->post_name;
                    $in_url = stripos($post_slug, sanitize_title($primary_kw)) !== false;
                    
                    // Check in content
                    $content = $post->post_content;
                    $content_text = strip_tags($content);
                    $in_content = stripos($content_text, $primary_kw) !== false;
                    
                    // Check in first paragraph
                    $first_para = mb_substr($content_text, 0, 300);
                    $in_first_para = stripos($first_para, $primary_kw) !== false;
                    
                    // Keyword density - SAME calculation as SEO Audit
                    $word_count = str_word_count($content_text);
                    $keyword_count = substr_count(mb_strtolower($content_text), mb_strtolower($primary_kw));
                    $keyword_words = str_word_count($primary_kw); // počet slov v keyword fráze
                    $density = $word_count > 0 ? round(($keyword_count * $keyword_words / $word_count) * 100, 2) : 0;
                    ?>
                    <div style="display: grid; gap: 8px;">
                        <div><?php echo $in_title ? '✅' : '❌'; ?> Keyword v titulku</div>
                        <div><?php echo $in_url ? '✅' : '⚠️'; ?> Keyword v URL</div>
                        <div><?php echo $in_first_para ? '✅' : '⚠️'; ?> Keyword v prvom odstavci</div>
                        <div><?php echo $in_content ? '✅' : '❌'; ?> Keyword v obsahu (<?php echo $keyword_count; ?>×)</div>
                        <div><?php echo ($density >= 0.5 && $density <= 2.5) ? '✅' : '⚠️'; ?> Hustota: <?php echo $density; ?>% <?php echo $density < 0.5 ? '(príliš nízka)' : ($density > 2.5 ? '(príliš vysoká)' : '(OK)'); ?></div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

    </div>

    <!-- Tab: Social -->
    <div class="wseo-tab-content" id="wseo-tab-social">
        
        <!-- OG Image -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_og_image">
                    <strong>Sociálny obrázok</strong>
                    <span class="wseo-help" title="Obrázok pre Facebook, Twitter, LinkedIn atď.">?</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input 
                    type="url" 
                    id="wseo_og_image" 
                    name="wseo_og_image" 
                    value="<?php echo esc_url($og_image); ?>"
                    class="large-text"
                    placeholder="https://example.com/image.jpg"
                >
                <p class="wseo-field-note">
                    <?php if ($featured_image && !$og_image): ?>
                        ✅ Automaticky sa použije hlavný obrázok stránky. Pre vlastný obrázok vložte URL vyššie.
                    <?php else: ?>
                        Odporúčaná veľkosť: 1200×630 pixelov. Vložte URL obrázka.
                    <?php endif; ?>
                </p>
                
                <?php if ($display_og_image): ?>
                <div class="wseo-image-preview">
                    <img src="<?php echo esc_url($display_og_image); ?>" alt="OG Image Preview">
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Hero Image for LCP (v2.4.2) -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_hero_image">
                    <strong>⚡ Hero Image (LCP optimalizácia)</strong>
                    <span class="wseo-help" title="Hlavný obrázok stránky pre preload - zrýchľuje LCP o 30-50%">?</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input 
                    type="url" 
                    id="wseo_hero_image" 
                    name="wseo_hero_image" 
                    value="<?php echo esc_url(get_post_meta($post->ID, '_wseo_hero_image', true)); ?>"
                    class="large-text"
                    placeholder="https://example.com/hero-image.jpg"
                >
                <p class="wseo-field-note">
                    ⚡ Hero image bude automaticky preloadovaný s <code>fetchpriority="high"</code> pre zrýchlenie LCP.<br>
                    Nechajte prázdne pre automatické použitie Featured Image. Odporúčaná veľkosť: Full size (1920px+).
                </p>
            </div>
        </div>

        <!-- Social Preview -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <strong>Náhľad pri zdieľaní</strong>
            </div>
            <div class="wseo-field-input">
                <div class="wseo-social-preview">
                    <div class="wseo-social-preview-image">
                        <?php if ($display_og_image): ?>
                            <img src="<?php echo esc_url($display_og_image); ?>" alt="">
                        <?php else: ?>
                            <div class="wseo-no-image">Žiadny obrázok</div>
                        <?php endif; ?>
                    </div>
                    <div class="wseo-social-preview-content">
                        <div class="wseo-social-preview-url"><?php echo esc_url(parse_url(get_permalink($post->ID), PHP_URL_HOST)); ?></div>
                        <div class="wseo-social-preview-title" id="wseo-social-title"><?php echo esc_html($meta_title ?: get_the_title($post->ID)); ?></div>
                        <div class="wseo-social-preview-desc" id="wseo-social-desc"><?php echo esc_html(wp_trim_words($meta_description, 20)); ?></div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Tab: SEO Audit -->
    <div class="wseo-tab-content" id="wseo-tab-audit">
        <?php
        // Perform SEO Audit
        $audit_results = array();
        $audit_score = 0;
        $audit_max = 0;
        
        // Get content - use plugin's get_post_content method for page builder support
        $wseo_instance = Webstudio_SEO_Pro::get_instance();
        $content_text = $wseo_instance->get_post_content($post->ID);
        
        // For headings/images/links analysis, we need the raw HTML content
        $content = $post->post_content;
        
        // Also check Elementor data for structure analysis
        if (class_exists('\Elementor\Plugin')) {
            $elementor_data = get_post_meta($post->ID, '_elementor_data', true);
            if ($elementor_data) {
                $content .= ' ' . $elementor_data; // Add JSON for regex matching
            }
        }
        
        $word_count = str_word_count($content_text);
        $title = get_the_title($post->ID);
        
        // Get focus keyword - use manual or auto-extract from title
        $focus_keyword = strtolower(trim($meta_keywords));
        $auto_extracted = false;
        if (empty($focus_keyword)) {
            // Auto-extract keywords from title
            $focus_keyword = Webstudio_SEO_Pro::get_instance()->auto_extract_keywords_static($title, $post);
            $auto_extracted = true;
        }
        $focus_keywords = array_map('trim', explode(',', $focus_keyword));
        $primary_keyword = !empty($focus_keywords[0]) ? $focus_keywords[0] : '';
        
        // 1. Meta Title Check
        $audit_max += 10;
        if (!empty($meta_title)) {
            $audit_results['meta_title'] = array('status' => 'good', 'text' => 'Meta titulok je vyplnený', 'points' => 10);
            $audit_score += 10;
        } else {
            $audit_results['meta_title'] = array('status' => 'warning', 'text' => 'Meta titulok nie je vyplnený (použije sa automatický)', 'points' => 5);
            $audit_score += 5;
        }
        
        // 2. Meta Title Length
        $audit_max += 5;
        $title_length = mb_strlen($meta_title ?: $title);
        if ($title_length >= 30 && $title_length <= 60) {
            $audit_results['meta_title_length'] = array('status' => 'good', 'text' => "Dĺžka titulku je optimálna ({$title_length} znakov)", 'points' => 5);
            $audit_score += 5;
        } elseif ($title_length > 0 && $title_length < 30) {
            $audit_results['meta_title_length'] = array('status' => 'warning', 'text' => "Titulok je príliš krátky ({$title_length} znakov, odporúčané 30-60)", 'points' => 2);
            $audit_score += 2;
        } elseif ($title_length > 60) {
            $audit_results['meta_title_length'] = array('status' => 'warning', 'text' => "Titulok je príliš dlhý ({$title_length} znakov, odporúčané 30-60)", 'points' => 2);
            $audit_score += 2;
        } else {
            $audit_results['meta_title_length'] = array('status' => 'bad', 'text' => 'Titulok chýba', 'points' => 0);
        }
        
        // 3. Meta Description Check
        $audit_max += 10;
        if (!empty($meta_description)) {
            $audit_results['meta_desc'] = array('status' => 'good', 'text' => 'Meta popis je vyplnený', 'points' => 10);
            $audit_score += 10;
        } else {
            $audit_results['meta_desc'] = array('status' => 'warning', 'text' => 'Meta popis nie je vyplnený (vygeneruje sa automaticky)', 'points' => 5);
            $audit_score += 5;
        }
        
        // 4. Meta Description Length
        $audit_max += 5;
        $desc_length = mb_strlen($meta_description);
        if ($desc_length >= 120 && $desc_length <= 160) {
            $audit_results['meta_desc_length'] = array('status' => 'good', 'text' => "Dĺžka popisu je optimálna ({$desc_length} znakov)", 'points' => 5);
            $audit_score += 5;
        } elseif ($desc_length > 0 && $desc_length < 120) {
            $audit_results['meta_desc_length'] = array('status' => 'warning', 'text' => "Popis je krátky ({$desc_length} znakov, odporúčané 120-160)", 'points' => 2);
            $audit_score += 2;
        } elseif ($desc_length > 160) {
            $audit_results['meta_desc_length'] = array('status' => 'warning', 'text' => "Popis je dlhý ({$desc_length} znakov, odporúčané 120-160)", 'points' => 2);
            $audit_score += 2;
        } else {
            $audit_results['meta_desc_length'] = array('status' => 'info', 'text' => 'Popis sa vygeneruje automaticky z obsahu', 'points' => 2);
            $audit_score += 2;
        }
        
        // 5. Focus Keyword
        $audit_max += 10;
        if (!empty($primary_keyword)) {
            if ($auto_extracted) {
                $audit_results['focus_keyword'] = array('status' => 'good', 'text' => "Focus keyword (auto): \"{$primary_keyword}\"", 'points' => 8);
                $audit_score += 8;
            } else {
                $audit_results['focus_keyword'] = array('status' => 'good', 'text' => "Focus keyword: \"{$primary_keyword}\"", 'points' => 10);
                $audit_score += 10;
            }
        } else {
            $audit_results['focus_keyword'] = array('status' => 'warning', 'text' => 'Focus keyword sa nepodarilo extrahovať', 'points' => 0);
        }
        
        // 6. Keyword in Title
        $audit_max += 10;
        if (!empty($primary_keyword)) {
            $check_title = strtolower($meta_title ?: $title);
            if (strpos($check_title, $primary_keyword) !== false) {
                $audit_results['keyword_title'] = array('status' => 'good', 'text' => 'Focus keyword je v titulku', 'points' => 10);
                $audit_score += 10;
            } else {
                $audit_results['keyword_title'] = array('status' => 'warning', 'text' => 'Focus keyword nie je v titulku', 'points' => 0);
            }
        }
        
        // 7. Keyword in Description
        $audit_max += 5;
        if (!empty($primary_keyword) && !empty($meta_description)) {
            if (stripos($meta_description, $primary_keyword) !== false) {
                $audit_results['keyword_desc'] = array('status' => 'good', 'text' => 'Focus keyword je v meta popisu', 'points' => 5);
                $audit_score += 5;
            } else {
                $audit_results['keyword_desc'] = array('status' => 'info', 'text' => 'Focus keyword nie je v meta popisu', 'points' => 0);
            }
        }
        
        // 8. Content Length with detailed recommendations
        $audit_max += 10;
        
        // Determine optimal length based on post type
        $post_type = $post->post_type;
        $optimal_min = 300;
        $optimal_max = 2500;
        $ideal_length = 1500;
        
        if ($post_type === 'page') {
            $optimal_min = 200;
            $optimal_max = 2000;
            $ideal_length = 800;
        } elseif ($post_type === 'product') {
            $optimal_min = 150;
            $optimal_max = 1500;
            $ideal_length = 400;
        }
        
        // Evaluate content length
        if ($word_count >= $optimal_min && $word_count <= $optimal_max) {
            // Optimal range
            $length_text = "Obsah má optimálnu dĺžku ({$word_count} slov)";
            if ($word_count >= $ideal_length) {
                $length_text .= " ✨ Výborné!";
            } else {
                $words_to_ideal = $ideal_length - $word_count;
                $length_text .= ". Pre ideálnu dĺžku pridajte cca {$words_to_ideal} slov.";
            }
            $audit_results['content_length'] = array('status' => 'good', 'text' => $length_text, 'points' => 10);
            $audit_score += 10;
        } elseif ($word_count > $optimal_max) {
            // Too long
            $audit_results['content_length'] = array(
                'status' => 'warning', 
                'text' => "Obsah je veľmi dlhý ({$word_count} slov). Zvážte rozdelenie na viac článkov.", 
                'points' => 7
            );
            $audit_score += 7;
        } elseif ($word_count >= $optimal_min / 2) {
            // Short but acceptable
            $words_needed = $optimal_min - $word_count;
            $audit_results['content_length'] = array(
                'status' => 'warning', 
                'text' => "Obsah je krátky ({$word_count} slov). Pridajte ešte cca {$words_needed} slov.", 
                'points' => 5
            );
            $audit_score += 5;
        } else {
            // Too short
            $words_needed = $optimal_min - $word_count;
            $audit_results['content_length'] = array(
                'status' => 'bad', 
                'text' => "Obsah je príliš krátky ({$word_count} slov). Pridajte ešte cca {$words_needed} slov.", 
                'points' => 0
            );
        }
        
        // 9. Headings Check (H1, H2, H3) - check both post_content and builder data
        $audit_max += 10;
        
        // Combine all possible content sources for heading detection
        $heading_content = $content;
        
        // Add Themify Builder content
        $themify_data = get_post_meta($post->ID, '_themify_builder_settings_json', true);
        if (!empty($themify_data)) {
            $heading_content .= ' ' . $themify_data;
        }
        
        // Add Elementor content
        $elementor_data = get_post_meta($post->ID, '_elementor_data', true);
        if (!empty($elementor_data)) {
            $heading_content .= ' ' . $elementor_data;
        }
        
        preg_match_all('/<h1[^>]*>/i', $heading_content, $h1_matches);
        preg_match_all('/<h2[^>]*>/i', $heading_content, $h2_matches);
        preg_match_all('/<h3[^>]*>/i', $heading_content, $h3_matches);
        $h1_count = count($h1_matches[0]);
        $h2_count = count($h2_matches[0]);
        $h3_count = count($h3_matches[0]);
        
        // Check heading hierarchy
        if ($h2_count >= 1 && $h3_count >= 1) {
            // Ideal: has both H2 and H3
            $audit_results['headings'] = array('status' => 'good', 'text' => "Obsah má správnu štruktúru nadpisov (H2: {$h2_count}, H3: {$h3_count})", 'points' => 10);
            $audit_score += 10;
        } elseif ($h2_count >= 1 && $h3_count == 0) {
            // Has H2 but no H3
            $audit_results['headings'] = array('status' => 'warning', 'text' => "Obsah má H2 ({$h2_count}), ale chýba H3. Pridajte podnadpisy.", 'points' => 7);
            $audit_score += 7;
        } elseif ($h2_count == 0 && $h3_count >= 1) {
            // Has H3 but no H2 - wrong hierarchy!
            $audit_results['headings'] = array('status' => 'bad', 'text' => "Chyba hierarchie! Máte H3 ({$h3_count}) bez H2. Pridajte najprv H2.", 'points' => 2);
            $audit_score += 2;
        } else {
            // No headings at all
            $audit_results['headings'] = array('status' => 'bad', 'text' => 'Obsah nemá nadpisy. Pridajte minimálne jeden H2 a H3.', 'points' => 0);
        }
        
        // 10. Images Check
        $audit_max += 5;
        
        // Get all images - both from content and attached to post
        preg_match_all('/<img[^>]+>/i', $content, $img_matches);
        $img_count = count($img_matches[0]);
        
        // Also check for attached images
        $attached_images = get_attached_media('image', $post->ID);
        $attached_count = count($attached_images);
        
        // Use whichever is higher
        $total_images = max($img_count, $attached_count);
        
        if ($total_images > 0) {
            $audit_results['images'] = array('status' => 'good', 'text' => "Obsah obsahuje obrázky ({$total_images})", 'points' => 5);
            $audit_score += 5;
        } else {
            $audit_results['images'] = array('status' => 'info', 'text' => 'Obsah neobsahuje obrázky', 'points' => 0);
        }
        
        // 11. Images Alt Text - Check attached images in media library
        $audit_max += 5;
        if ($total_images > 0) {
            $imgs_with_alt = 0;
            $imgs_checked = 0;
            
            // Method 1: Check attached images (most reliable)
            if (!empty($attached_images)) {
                foreach ($attached_images as $attachment) {
                    $imgs_checked++;
                    $alt_text = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
                    if (!empty($alt_text)) {
                        $imgs_with_alt++;
                    }
                }
            }
            
            // Method 2: Check images in content by ID
            if ($img_count > 0 && $imgs_checked == 0) {
                foreach ($img_matches[0] as $img_tag) {
                    $imgs_checked++;
                    $has_alt = false;
                    
                    // Check inline alt attribute first
                    if (preg_match('/alt=["\']([^"\']+)["\']/i', $img_tag, $alt_match)) {
                        if (!empty(trim($alt_match[1]))) {
                            $has_alt = true;
                        }
                    }
                    
                    // Try to get attachment ID from wp-image-XXX class
                    if (!$has_alt && preg_match('/wp-image-(\d+)/i', $img_tag, $id_match)) {
                        $attachment_id = intval($id_match[1]);
                        $attachment_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
                        if (!empty($attachment_alt)) {
                            $has_alt = true;
                        }
                    }
                    
                    // Try data-id attribute
                    if (!$has_alt && preg_match('/data-id=["\'](\d+)["\']/i', $img_tag, $id_match)) {
                        $attachment_id = intval($id_match[1]);
                        $attachment_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
                        if (!empty($attachment_alt)) {
                            $has_alt = true;
                        }
                    }
                    
                    // Try to find by URL (slowest)
                    if (!$has_alt && preg_match('/src=["\']([^"\']+)["\']/i', $img_tag, $src_match)) {
                        $attachment_id = attachment_url_to_postid($src_match[1]);
                        if ($attachment_id) {
                            $attachment_alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
                            if (!empty($attachment_alt)) {
                                $has_alt = true;
                            }
                        }
                    }
                    
                    if ($has_alt) {
                        $imgs_with_alt++;
                    }
                }
            }
            
            // If we still have no checked images, use attached count
            if ($imgs_checked == 0) {
                $imgs_checked = $total_images;
            }
            
            if ($imgs_with_alt >= $imgs_checked && $imgs_with_alt > 0) {
                $audit_results['images_alt'] = array('status' => 'good', 'text' => "Všetky obrázky majú alt text ({$imgs_with_alt}/{$imgs_checked})", 'points' => 5);
                $audit_score += 5;
            } elseif ($imgs_with_alt > 0) {
                $audit_results['images_alt'] = array('status' => 'warning', 'text' => "Niektoré obrázky nemajú alt text ({$imgs_with_alt}/{$imgs_checked})", 'points' => 2);
                $audit_score += 2;
            } else {
                // Last resort - check if featured image has alt
                $thumbnail_id = get_post_thumbnail_id($post->ID);
                if ($thumbnail_id) {
                    $thumb_alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
                    if (!empty($thumb_alt)) {
                        $audit_results['images_alt'] = array('status' => 'good', 'text' => "Náhľadový obrázok má alt text", 'points' => 5);
                        $audit_score += 5;
                    } else {
                        $audit_results['images_alt'] = array('status' => 'bad', 'text' => 'Obrázky nemajú alt text', 'points' => 0);
                    }
                } else {
                    $audit_results['images_alt'] = array('status' => 'bad', 'text' => 'Obrázky nemajú alt text', 'points' => 0);
                }
            }
        }
        
        // 12. Internal Links
        $audit_max += 5;
        $site_url = home_url();
        preg_match_all('/<a[^>]+href=["\']([^"\']+)["\'][^>]*>/i', $content, $link_matches);
        $internal_links = 0;
        $external_links = 0;
        foreach ($link_matches[1] as $link) {
            if (strpos($link, $site_url) === 0 || strpos($link, '/') === 0) {
                $internal_links++;
            } elseif (strpos($link, 'http') === 0) {
                $external_links++;
            }
        }
        if ($internal_links >= 2) {
            $audit_results['internal_links'] = array('status' => 'good', 'text' => "Obsah má interné odkazy ({$internal_links})", 'points' => 5);
            $audit_score += 5;
        } elseif ($internal_links >= 1) {
            $audit_results['internal_links'] = array('status' => 'warning', 'text' => "Obsah má málo interných odkazov ({$internal_links})", 'points' => 2);
            $audit_score += 2;
        } else {
            $audit_results['internal_links'] = array('status' => 'info', 'text' => 'Obsah nemá interné odkazy', 'points' => 0);
        }
        
        // 13. Featured Image
        $audit_max += 5;
        if (has_post_thumbnail($post->ID)) {
            $audit_results['featured_image'] = array('status' => 'good', 'text' => 'Príspevok má náhľadový obrázok', 'points' => 5);
            $audit_score += 5;
        } else {
            $audit_results['featured_image'] = array('status' => 'warning', 'text' => 'Príspevok nemá náhľadový obrázok', 'points' => 0);
        }
        
        // 14. URL Slug
        $audit_max += 5;
        $slug = $post->post_name;
        if (strlen($slug) <= 75 && strpos($slug, '--') === false) {
            if (!empty($primary_keyword) && stripos($slug, sanitize_title($primary_keyword)) !== false) {
                $audit_results['url_slug'] = array('status' => 'good', 'text' => 'URL obsahuje focus keyword', 'points' => 5);
                $audit_score += 5;
            } elseif (!empty($primary_keyword)) {
                $audit_results['url_slug'] = array('status' => 'warning', 'text' => 'URL neobsahuje focus keyword (-2 body)', 'points' => 3);
                $audit_score += 3;
            } else {
                $audit_results['url_slug'] = array('status' => 'info', 'text' => 'URL je v poriadku (nastavte focus keyword pre +2 body)', 'points' => 3);
                $audit_score += 3;
            }
        } else {
            $audit_results['url_slug'] = array('status' => 'warning', 'text' => 'URL je príliš dlhá alebo obsahuje duplicitné pomlčky', 'points' => 0);
        }
        
        // 15. Keyword Density with detailed recommendations
        if (!empty($primary_keyword) && $word_count > 0) {
            $keyword_count = substr_count(mb_strtolower($content_text), mb_strtolower($primary_keyword));
            $keyword_words = str_word_count($primary_keyword);
            $density = ($keyword_count * $keyword_words / $word_count) * 100;
            $density = round($density, 2);
            
            // Calculate optimal occurrences based on word count
            $optimal_min_count = max(1, floor($word_count * 0.005)); // 0.5%
            $optimal_max_count = ceil($word_count * 0.03); // 3%
            
            if ($density < 0.5) {
                $needed = max(1, $optimal_min_count - $keyword_count);
                $audit_results['keyword_density'] = array(
                    'status' => 'info', 
                    'text' => "Hustota kľúčového slova: {$density}% ({$keyword_count}×) - nízka. Pridajte keyword ešte {$needed}× do textu.", 
                    'points' => 0
                );
            } elseif ($density > 3) {
                // Calculate how many to remove to get to ~2.5%
                $target_count = floor($word_count * 0.025 / $keyword_words);
                $remove = $keyword_count - $target_count;
                if ($remove > 0) {
                    $audit_results['keyword_density'] = array(
                        'status' => 'warning', 
                        'text' => "⚠️ Hustota kľúčového slova: {$density}% ({$keyword_count}×) - príliš vysoká! Znížte na cca {$target_count}× (ideálne 1-2.5%).", 
                        'points' => 0
                    );
                } else {
                    $audit_results['keyword_density'] = array(
                        'status' => 'warning', 
                        'text' => "⚠️ Hustota kľúčového slova: {$density}% ({$keyword_count}×) - príliš vysoká! Pridajte viac textu alebo použite synonymá.", 
                        'points' => 0
                    );
                }
            } elseif ($density >= 1 && $density <= 2.5) {
                $audit_results['keyword_density'] = array(
                    'status' => 'good', 
                    'text' => "✅ Hustota kľúčového slova: {$density}% ({$keyword_count}×) - ideálna!", 
                    'points' => 0
                );
            } else {
                $audit_results['keyword_density'] = array(
                    'status' => 'good', 
                    'text' => "Hustota kľúčového slova: {$density}% ({$keyword_count}×) - v poriadku", 
                    'points' => 0
                );
            }
        }
        
        // 16. Content Recommendations Summary
        $recommendations = array();
        if ($word_count < $optimal_min) {
            $recommendations[] = "📝 Pridajte viac obsahu (min. {$optimal_min} slov)";
        }
        if (empty($meta_title)) {
            $recommendations[] = "✏️ Vyplňte vlastný Meta Title";
        }
        if (empty($meta_description)) {
            $recommendations[] = "📄 Vyplňte vlastný Meta Description";
        }
        if (empty($primary_keyword)) {
            $recommendations[] = "Nastavte Focus Keyword";
        }
        if ($h2_count == 0) {
            $recommendations[] = "📑 Pridajte nadpis H2";
        } elseif ($h3_count == 0) {
            $recommendations[] = "📑 Pridajte podnadpis H3";
        }
        if (!has_post_thumbnail($post->ID)) {
            $recommendations[] = "🖼️ Pridajte náhľadový obrázok";
        }
        
        if (!empty($recommendations)) {
            $audit_results['recommendations'] = array(
                'status' => 'info',
                'text' => 'Odporúčania: ' . implode(' | ', array_slice($recommendations, 0, 3)),
                'points' => 0
            );
        }
        
        // Calculate percentage
        $audit_percentage = $audit_max > 0 ? round(($audit_score / $audit_max) * 100) : 0;
        
        // Determine overall status
        if ($audit_percentage >= 80) {
            $overall_status = 'good';
            $overall_text = 'Výborné SEO';
        } elseif ($audit_percentage >= 50) {
            $overall_status = 'warning';
            $overall_text = 'Potrebuje vylepšenie';
        } else {
            $overall_status = 'bad';
            $overall_text = 'Slabé SEO';
        }
        ?>
        
        <style>
        .wseo-audit-score {
            text-align: center;
            padding: 20px;
            background: #f9f9f9;
            border-bottom: 1px solid #e2e4e7;
        }
        .wseo-audit-circle {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            font-weight: 700;
            color: #fff;
            margin-bottom: 10px;
        }
        .wseo-audit-circle.good { background: linear-gradient(135deg, #00a32a, #00c853); }
        .wseo-audit-circle.warning { background: linear-gradient(135deg, #dba617, #f0c14b); }
        .wseo-audit-circle.bad { background: linear-gradient(135deg, #d63638, #f44336); }
        .wseo-audit-status {
            font-size: 16px;
            font-weight: 600;
        }
        .wseo-audit-status.good { color: #00a32a; }
        .wseo-audit-status.warning { color: #dba617; }
        .wseo-audit-status.bad { color: #d63638; }
        .wseo-audit-list {
            padding: 15px;
        }
        .wseo-audit-item {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 8px 0;
            border-bottom: 1px solid #f0f0f1;
            font-size: 13px;
        }
        .wseo-audit-item:last-child { border-bottom: none; }
        .wseo-audit-icon {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            flex-shrink: 0;
        }
        .wseo-audit-icon.good { background: #edfaef; color: #00a32a; }
        .wseo-audit-icon.warning { background: #fef8e7; color: #dba617; }
        .wseo-audit-icon.bad { background: #fcf0f0; color: #d63638; }
        .wseo-audit-icon.info { background: #f0f6fc; color: #2271b1; }
        .wseo-audit-text { flex: 1; color: #1d2327; }
        .wseo-audit-points {
            font-size: 11px;
            color: #646970;
            background: #f0f0f1;
            padding: 2px 6px;
            border-radius: 3px;
        }
        </style>
        
        <div class="wseo-audit-score">
            <div class="wseo-audit-circle <?php echo $overall_status; ?>">
                <?php echo $audit_percentage; ?>%
            </div>
            <div class="wseo-audit-status <?php echo $overall_status; ?>">
                <?php echo $overall_text; ?>
            </div>
            <div style="color: #646970; font-size: 12px; margin-top: 5px;">
                <?php echo $audit_score; ?>/<?php echo $audit_max; ?> bodov
            </div>
        </div>
        
        <div class="wseo-audit-list">
            <?php foreach ($audit_results as $key => $result): ?>
            <div class="wseo-audit-item">
                <div class="wseo-audit-icon <?php echo $result['status']; ?>">
                    <?php 
                    if ($result['status'] === 'good') echo '✓';
                    elseif ($result['status'] === 'warning') echo '!';
                    elseif ($result['status'] === 'bad') echo '✗';
                    else echo 'i';
                    ?>
                </div>
                <div class="wseo-audit-text"><?php echo esc_html($result['text']); ?></div>
                <div class="wseo-audit-points">+<?php echo $result['points']; ?></div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="wseo-info-box" style="margin: 0;">
            <p>💡 <strong>Tip:</strong> Pre lepšie SEO skóre vyplňte Meta titulok, Meta popis a Focus keyword. Používajte nadpisy H2/H3 a pridajte interné odkazy.</p>
        </div>
    </div>

    <!-- Tab: Copywriting (v2.8.9) -->
    <div class="wseo-tab-content" id="wseo-tab-copywriting">
        <?php
        // Get language for readability analysis
        $locale = get_locale();
        $lang_code = substr($locale, 0, 2);
        
        // Language-specific transition words
        $transition_words = array(
            'sk' => array('preto', 'pretože', 'avšak', 'však', 'navyše', 'okrem toho', 'teda', 'takže', 'následne', 'potom', 'najprv', 'nakoniec', 'v prvom rade', 'predovšetkým', 'napríklad', 'konkrétne', 'to znamená', 'inými slovami', 'na druhej strane', 'napriek tomu', 'aj keď', 'hoci', 'zatiaľ čo', 'kým', 'rovnako', 'podobne', 'naopak', 'zároveň', 'súčasne', 'naviac', 'tiež', 'taktiež', 'hlavne', 'najmä', 'v skutočnosti', 'samozrejme', 'určite', 'pravdepodobne', 'možno', 'pravda', 'skutočne', 'v závere', 'na záver', 'celkovo', 'stručne povedané', 'v skratke'),
            'cs' => array('proto', 'protože', 'avšak', 'však', 'navíc', 'kromě toho', 'tedy', 'takže', 'následně', 'potom', 'nejprve', 'nakonec', 'v první řadě', 'především', 'například', 'konkrétně', 'to znamená', 'jinými slovy', 'na druhé straně', 'navzdory tomu', 'ačkoli', 'přestože', 'zatímco', 'dokud', 'rovněž', 'podobně', 'naopak', 'zároveň', 'současně', 'také', 'taktéž', 'hlavně', 'zejména', 've skutečnosti', 'samozřejmě', 'určitě', 'pravděpodobně', 'možná', 'závěrem', 'celkově', 'stručně řečeno'),
            'en' => array('therefore', 'because', 'however', 'moreover', 'furthermore', 'thus', 'consequently', 'then', 'first', 'finally', 'for example', 'specifically', 'in other words', 'on the other hand', 'despite', 'although', 'while', 'similarly', 'likewise', 'in contrast', 'meanwhile', 'also', 'additionally', 'mainly', 'especially', 'actually', 'certainly', 'probably', 'perhaps', 'in conclusion', 'overall', 'in summary', 'as a result', 'hence', 'accordingly', 'nevertheless', 'nonetheless', 'besides', 'indeed', 'in fact'),
            'de' => array('deshalb', 'weil', 'jedoch', 'außerdem', 'darüber hinaus', 'also', 'folglich', 'dann', 'zuerst', 'schließlich', 'zum beispiel', 'insbesondere', 'mit anderen worten', 'andererseits', 'trotzdem', 'obwohl', 'während', 'ähnlich', 'ebenso', 'im gegenteil', 'gleichzeitig', 'auch', 'zusätzlich', 'hauptsächlich', 'besonders', 'tatsächlich', 'sicherlich', 'wahrscheinlich', 'vielleicht', 'abschließend', 'insgesamt', 'zusammenfassend', 'daher', 'dennoch', 'außerdem', 'in der tat'),
            'fr' => array('donc', 'parce que', 'cependant', 'de plus', 'en outre', 'ainsi', 'par conséquent', 'ensuite', 'premièrement', 'finalement', 'par exemple', 'notamment', 'autrement dit', 'en revanche', 'malgré', 'bien que', 'tandis que', 'de même', 'également', 'au contraire', 'en même temps', 'aussi', 'de surcroît', 'principalement', 'surtout', 'en fait', 'certainement', 'probablement', 'peut-être', 'en conclusion', 'globalement', 'en résumé', 'néanmoins', 'toutefois', 'par ailleurs'),
            'ru' => array('поэтому', 'потому что', 'однако', 'кроме того', 'более того', 'таким образом', 'следовательно', 'затем', 'сначала', 'наконец', 'например', 'в частности', 'другими словами', 'с другой стороны', 'несмотря на', 'хотя', 'в то время как', 'аналогично', 'также', 'напротив', 'одновременно', 'тоже', 'дополнительно', 'главным образом', 'особенно', 'фактически', 'конечно', 'вероятно', 'возможно', 'в заключение', 'в целом', 'короче говоря')
        );
        
        // Language-specific passive voice patterns
        $passive_patterns = array(
            'sk' => '/\b(bol|bola|bolo|boli|je|sú|bude|budú)\s+(vytvorený|vytvorená|vytvorené|urobený|urobená|urobené|napísaný|napísaná|napísané|považovaný|považovaná|považované|nazývaný|nazývaná|nazývané|spôsobený|spôsobená|spôsobené|použitý|použitá|použité|videný|videná|videné)\b/iu',
            'cs' => '/\b(byl|byla|bylo|byli|je|jsou|bude|budou)\s+(vytvořen|vytvořena|vytvořeno|udělán|udělána|uděláno|napsán|napsána|napsáno|považován|považována|považováno|nazýván|nazývána|nazýváno|způsoben|způsobena|způsobeno|použit|použita|použito)\b/iu',
            'en' => '/\b(is|are|was|were|been|being|be)\s+(\w+ed|made|done|given|taken|seen|known|found|written|built|called|considered)\b/i',
            'de' => '/\b(wird|werden|wurde|wurden|ist|sind|war|waren)\s+(\w+t|gemacht|getan|gegeben|genommen|gesehen|genannt|geschrieben|gebaut)\b/i',
            'fr' => '/\b(est|sont|était|étaient|sera|seront|été)\s+(\w+é|fait|donné|pris|vu|écrit|construit|appelé|considéré)\b/i',
            'ru' => '/\b(был|была|было|были|будет|будут)\s+(\w+ан|создан|сделан|написан|построен|назван|найден)\b/iu'
        );
        
        // Get content
        $wseo_instance = Webstudio_SEO_Pro::get_instance();
        $content_text = $wseo_instance->get_post_content($post->ID);
        $content_html = $post->post_content;
        
        // Clean text for analysis
        $clean_text = strip_tags($content_text);
        $clean_text = preg_replace('/\s+/', ' ', $clean_text);
        $clean_text = trim($clean_text);
        
        // Word count
        $words = preg_split('/\s+/', $clean_text, -1, PREG_SPLIT_NO_EMPTY);
        $word_count = count($words);
        
        // Sentence count
        $sentences = preg_split('/[.!?]+/', $clean_text, -1, PREG_SPLIT_NO_EMPTY);
        $sentence_count = count(array_filter($sentences, function($s) { return mb_strlen(trim($s)) > 3; }));
        
        // Paragraph count
        $paragraphs = preg_split('/\n\n+/', $content_text, -1, PREG_SPLIT_NO_EMPTY);
        $paragraph_count = count(array_filter($paragraphs, function($p) { return mb_strlen(trim($p)) > 10; }));
        
        // Average words per sentence
        $avg_words_per_sentence = $sentence_count > 0 ? round($word_count / $sentence_count, 1) : 0;
        
        // Average words per paragraph
        $avg_words_per_paragraph = $paragraph_count > 0 ? round($word_count / $paragraph_count, 1) : 0;
        
        // Transition words analysis
        $current_transitions = isset($transition_words[$lang_code]) ? $transition_words[$lang_code] : $transition_words['en'];
        $transition_count = 0;
        $content_lower = mb_strtolower($clean_text);
        foreach ($current_transitions as $tw) {
            $transition_count += substr_count($content_lower, mb_strtolower($tw));
        }
        $transition_percentage = $sentence_count > 0 ? round(($transition_count / $sentence_count) * 100, 1) : 0;
        
        // Passive voice analysis
        $passive_pattern = isset($passive_patterns[$lang_code]) ? $passive_patterns[$lang_code] : $passive_patterns['en'];
        preg_match_all($passive_pattern, $clean_text, $passive_matches);
        $passive_count = count($passive_matches[0]);
        $passive_percentage = $sentence_count > 0 ? round(($passive_count / $sentence_count) * 100, 1) : 0;
        
        // Long sentences (>20 words)
        $long_sentences = 0;
        foreach ($sentences as $sentence) {
            $sentence_words = preg_split('/\s+/', trim($sentence), -1, PREG_SPLIT_NO_EMPTY);
            if (count($sentence_words) > 20) {
                $long_sentences++;
            }
        }
        $long_sentence_percentage = $sentence_count > 0 ? round(($long_sentences / $sentence_count) * 100, 1) : 0;
        
        // Flesch Reading Ease (adapted for language)
        $syllable_count = 0;
        foreach ($words as $word) {
            $syllable_count += max(1, preg_match_all('/[aeiouyáéíóúýäëïöüàèìòùâêîôûąęółńśćżźаеёиоуыэюя]/iu', $word));
        }
        
        // Language-specific Flesch coefficients
        $flesch_coefficients = array(
            'sk' => array(206.835, 1.3, 60.1),
            'cs' => array(206.835, 1.3, 60.1),
            'en' => array(206.835, 1.015, 84.6),
            'de' => array(180.0, 1.0, 58.5),
            'fr' => array(207.0, 1.015, 73.6),
            'ru' => array(206.835, 1.3, 60.1)
        );
        $coeffs = isset($flesch_coefficients[$lang_code]) ? $flesch_coefficients[$lang_code] : $flesch_coefficients['en'];
        
        $flesch_score = 0;
        if ($word_count > 0 && $sentence_count > 0) {
            $flesch_score = $coeffs[0] - ($coeffs[1] * ($word_count / $sentence_count)) - ($coeffs[2] * ($syllable_count / $word_count));
            $flesch_score = max(0, min(100, round($flesch_score)));
        }
        
        // Focus keyword analysis
        $focus_kw = strtolower(trim($meta_keywords));
        if (empty($focus_kw)) {
            $focus_kw = strtolower($wseo_instance->auto_extract_keywords($post->post_title, $post));
        }
        $primary_kw = explode(',', $focus_kw)[0];
        $primary_kw = trim($primary_kw);
        
        // Keyword in first paragraph
        $first_para = isset($paragraphs[0]) ? mb_strtolower($paragraphs[0]) : '';
        $kw_in_first_para = !empty($primary_kw) && strpos($first_para, $primary_kw) !== false;
        
        // Keyword density
        $kw_count = !empty($primary_kw) ? substr_count($content_lower, $primary_kw) : 0;
        $kw_density = $word_count > 0 ? round(($kw_count / $word_count) * 100, 2) : 0;
        
        // Keyword in headings
        preg_match_all('/<h[2-3][^>]*>(.*?)<\/h[2-3]>/is', $content_html, $headings);
        $headings_text = mb_strtolower(implode(' ', $headings[1]));
        $kw_in_headings = !empty($primary_kw) && strpos($headings_text, $primary_kw) !== false;
        
        // Internal and external links
        preg_match_all('/<a[^>]+href=["\']([^"\']+)["\'][^>]*>/i', $content_html, $links);
        $internal_links = 0;
        $external_links = 0;
        $site_host = parse_url(home_url(), PHP_URL_HOST);
        foreach ($links[1] as $link) {
            $link_host = parse_url($link, PHP_URL_HOST);
            if (empty($link_host) || $link_host === $site_host) {
                $internal_links++;
            } else {
                $external_links++;
            }
        }
        
        // Images with alt
        preg_match_all('/<img[^>]+>/i', $content_html, $images);
        $total_images = count($images[0]);
        $images_with_alt = 0;
        foreach ($images[0] as $img) {
            if (preg_match('/alt=["\'][^"\']+["\']/i', $img)) {
                $images_with_alt++;
            }
        }
        
        // Calculate overall scores
        $seo_score = 0;
        $seo_max = 100;
        $readability_score = 0;
        $readability_max = 100;
        
        // SEO Score calculation
        if (!empty($primary_kw)) $seo_score += 15;
        if ($kw_in_first_para) $seo_score += 15;
        if ($kw_density >= 0.5 && $kw_density <= 2.5) $seo_score += 15;
        elseif ($kw_density > 0) $seo_score += 7;
        if ($kw_in_headings) $seo_score += 15;
        if ($internal_links > 0) $seo_score += 10;
        if ($external_links > 0) $seo_score += 10;
        if ($word_count >= 300) $seo_score += 10;
        elseif ($word_count >= 150) $seo_score += 5;
        if ($total_images > 0 && $images_with_alt === $total_images) $seo_score += 10;
        elseif ($total_images > 0 && $images_with_alt > 0) $seo_score += 5;
        
        // Readability Score calculation
        if ($flesch_score >= 60) $readability_score += 25;
        elseif ($flesch_score >= 40) $readability_score += 15;
        elseif ($flesch_score >= 20) $readability_score += 5;
        
        if ($avg_words_per_sentence <= 20) $readability_score += 20;
        elseif ($avg_words_per_sentence <= 25) $readability_score += 10;
        
        if ($long_sentence_percentage <= 20) $readability_score += 15;
        elseif ($long_sentence_percentage <= 30) $readability_score += 7;
        
        if ($transition_percentage >= 30) $readability_score += 20;
        elseif ($transition_percentage >= 20) $readability_score += 10;
        elseif ($transition_percentage >= 10) $readability_score += 5;
        
        if ($passive_percentage <= 10) $readability_score += 20;
        elseif ($passive_percentage <= 20) $readability_score += 10;
        
        // Language names
        $lang_names = array('sk' => 'Slovenčina', 'cs' => 'Čeština', 'en' => 'English', 'de' => 'Deutsch', 'fr' => 'Français', 'ru' => 'Русский');
        $current_lang_name = isset($lang_names[$lang_code]) ? $lang_names[$lang_code] : $lang_code;
        
        // Determine overall status based on readability
        if ($readability_score >= 70) {
            $writing_status = 'good';
            $writing_text = 'Výborná čitateľnosť';
        } elseif ($readability_score >= 40) {
            $writing_status = 'warning';
            $writing_text = 'Potrebuje vylepšenie';
        } else {
            $writing_status = 'bad';
            $writing_text = 'Slabá čitateľnosť';
        }
        ?>
        
        <!-- Score Circle -->
        <div class="wseo-audit-score">
            <div class="wseo-audit-circle <?php echo $writing_status; ?>">
                <?php echo $readability_score; ?>%
            </div>
            <div class="wseo-audit-status <?php echo $writing_status; ?>">
                <?php echo $writing_text; ?>
            </div>
            <div style="color: #646970; font-size: 12px; margin-top: 5px;">
                <?php echo esc_html($current_lang_name); ?> | <?php echo number_format($word_count); ?> slov | <?php echo $sentence_count; ?> viet
            </div>
        </div>
        
        <!-- Readability Analysis List -->
        <div class="wseo-audit-list">
            <div class="wseo-audit-item">
                <div class="wseo-audit-icon <?php echo $flesch_score >= 60 ? 'good' : ($flesch_score >= 40 ? 'warning' : 'bad'); ?>">
                    <?php echo $flesch_score >= 60 ? '✓' : '!'; ?>
                </div>
                <div class="wseo-audit-text">
                    Index čitateľnosti: <?php echo $flesch_score; ?>/100 
                    <?php 
                    if ($flesch_score >= 80) echo '(veľmi ľahké)';
                    elseif ($flesch_score >= 60) echo '(ľahké)';
                    elseif ($flesch_score >= 40) echo '(stredné)';
                    else echo '(náročné)';
                    ?>
                    <?php if ($flesch_score < 60): ?>
                    <div class="wseo-audit-tip">💡 Používajte kratšie slová a jednoduchšie vety. Rozdeľte dlhé súvetia bodkou.</div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="wseo-audit-item">
                <div class="wseo-audit-icon <?php echo $avg_words_per_sentence <= 20 ? 'good' : ($avg_words_per_sentence <= 25 ? 'warning' : 'bad'); ?>">
                    <?php echo $avg_words_per_sentence <= 20 ? '✓' : '!'; ?>
                </div>
                <div class="wseo-audit-text">
                    Priemerná dĺžka viet: <?php echo $avg_words_per_sentence; ?> slov <?php echo $avg_words_per_sentence <= 20 ? '' : '(max 20)'; ?>
                    <?php if ($avg_words_per_sentence > 20): ?>
                    <div class="wseo-audit-tip">💡 Rozdeľte dlhé vety na kratšie. Čiarka často môže byť bodka.</div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="wseo-audit-item">
                <div class="wseo-audit-icon <?php echo $long_sentence_percentage <= 20 ? 'good' : ($long_sentence_percentage <= 30 ? 'warning' : 'bad'); ?>">
                    <?php echo $long_sentence_percentage <= 20 ? '✓' : '!'; ?>
                </div>
                <div class="wseo-audit-text">
                    Dlhé vety (20+ slov): <?php echo $long_sentence_percentage; ?>% <?php echo $long_sentence_percentage <= 20 ? '' : '(max 20%)'; ?>
                    <?php if ($long_sentence_percentage > 20): ?>
                    <div class="wseo-audit-tip">💡 Nájdite vety s viac ako 20 slovami a skráťte ich. Ideálna veta má 10-15 slov.</div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="wseo-audit-item">
                <div class="wseo-audit-icon <?php echo $transition_percentage >= 30 ? 'good' : ($transition_percentage >= 20 ? 'warning' : 'bad'); ?>">
                    <?php echo $transition_percentage >= 30 ? '✓' : '!'; ?>
                </div>
                <div class="wseo-audit-text">
                    Prechodové slová: <?php echo $transition_percentage; ?>% viet <?php echo $transition_percentage >= 30 ? '' : '(min 30%)'; ?>
                    <?php if ($transition_percentage < 30): ?>
                    <div class="wseo-audit-tip">💡 Pridajte: <em>preto, navyše, avšak, teda, napríklad, samozrejme, v prvom rade, na záver</em></div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="wseo-audit-item">
                <div class="wseo-audit-icon <?php echo $passive_percentage <= 10 ? 'good' : ($passive_percentage <= 20 ? 'warning' : 'bad'); ?>">
                    <?php echo $passive_percentage <= 10 ? '✓' : '!'; ?>
                </div>
                <div class="wseo-audit-text">
                    Pasívne vety: <?php echo $passive_percentage; ?>% <?php echo $passive_percentage <= 10 ? '' : '(max 10%)'; ?>
                    <?php if ($passive_percentage > 10): ?>
                    <div class="wseo-audit-tip">💡 Zmeňte pasív na aktív: "Stránka bola vytvorená" → "Vytvorili sme stránku"</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- General Tips -->
        <?php if ($readability_score < 70): ?>
        <div class="wseo-info-box" style="margin: 0; background: #fff3e0; border-left-color: #ff9800;">
            <p style="margin: 0;"><strong>📝 Rýchle zlepšenie:</strong></p>
            <ol style="margin: 8px 0 0 20px; padding: 0; line-height: 1.8;">
                <li>Každú vetu s čiarkou skúste rozdeliť bodkou</li>
                <li>Na začiatok odstavcov pridajte: "Preto...", "Navyše...", "V praxi..."</li>
                <li>Nahraďte "je robené" za "robíme"</li>
            </ol>
        </div>
        <?php else: ?>
        <div class="wseo-info-box" style="margin: 0;">
            <p style="margin: 0;">✅ <strong>Výborná práca!</strong> Obsah je dobre čitateľný.</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Tab: Visibility -->
    <div class="wseo-tab-content" id="wseo-tab-visibility">
        
        <!-- 301 Redirect -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_redirect_url">
                    <strong>🔄 Presmerovanie (301)</strong>
                    <span class="wseo-help" title="Presmeruje túto stránku na inú URL. Užitočné pri presúvaní obsahu.">?</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <?php 
                $redirect_url = get_post_meta($post->ID, '_wseo_redirect_url', true);
                $redirect_type = get_post_meta($post->ID, '_wseo_redirect_type', true) ?: '301';
                ?>
                <input 
                    type="url" 
                    id="wseo_redirect_url" 
                    name="wseo_redirect_url" 
                    value="<?php echo esc_url($redirect_url); ?>"
                    class="large-text"
                    placeholder="https://example.com/nova-stranka/"
                >
                <p class="wseo-field-note" style="margin-bottom: 10px;">
                    Zadajte URL kam sa má stránka presmerovať. Nechajte prázdne ak nechcete presmerovať.
                </p>
                <select name="wseo_redirect_type" id="wseo_redirect_type" style="width: auto;">
                    <option value="301" <?php selected($redirect_type, '301'); ?>>301 - Trvalé presmerovanie (odporúčané)</option>
                    <option value="302" <?php selected($redirect_type, '302'); ?>>302 - Dočasné presmerovanie</option>
                    <option value="307" <?php selected($redirect_type, '307'); ?>>307 - Dočasné (zachová metódu)</option>
                </select>
                <p class="wseo-field-note">
                    <strong>301</strong> - Pre trvalé zmeny URL. Google prenesie SEO hodnotu.<br>
                    <strong>302</strong> - Pre dočasné zmeny. Google neprenesie SEO hodnotu.
                </p>
            </div>
        </div>

        <hr style="margin: 20px 0; border: none; border-top: 1px solid #ddd;">

        <!-- Robots -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <strong>Robots nastavenia</strong>
                <span class="wseo-help" title="Tieto nastavenia ovplyvňujú ako vyhľadávače indexujú túto stránku.">?</span>
            </div>
            <div class="wseo-field-input">
                <label class="wseo-checkbox">
                    <input type="checkbox" name="wseo_noindex" value="1" <?php checked($noindex, '1'); ?>>
                    <span>Neinexovať túto stránku (noindex)</span>
                </label>
                <p class="wseo-field-note">Vyhľadávače túto stránku nebudú zobrazovať vo výsledkoch.</p>
                
                <label class="wseo-checkbox">
                    <input type="checkbox" name="wseo_nofollow" value="1" <?php checked($nofollow, '1'); ?>>
                    <span>Nesledovať odkazy (nofollow)</span>
                </label>
                <p class="wseo-field-note">Vyhľadávače nebudú sledovať odkazy na tejto stránke.</p>
            </div>
        </div>

        <!-- Canonical URL -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_canonical">
                    <strong>Canonical URL</strong>
                    <span class="wseo-help" title="Použite ak máte duplicitný obsah na viacerých URL.">?</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input 
                    type="url" 
                    id="wseo_canonical" 
                    name="wseo_canonical" 
                    value="<?php echo esc_url($canonical); ?>"
                    class="large-text"
                    placeholder="<?php echo esc_url(get_permalink($post->ID)); ?>"
                >
                <p class="wseo-field-note">
                    Nechajte prázdne pre použitie aktuálnej URL stránky.
                </p>
            </div>
        </div>

    </div>

    <!-- Tab: Links -->
    <div class="wseo-tab-content" id="wseo-tab-links">
        <?php
        // Get link suggestions
        $wseo = Webstudio_SEO_Pro::get_instance();
        $suggestions = $wseo->get_link_suggestions($post->ID);
        
        // Get incoming links
        $link_map = get_option('wseo_link_map', array());
        $post_url = rtrim(get_permalink($post->ID), '/');
        $incoming_links = isset($link_map[$post_url]) ? $link_map[$post_url] : array('incoming' => array(), 'count' => 0);
        
        // Get outgoing links count
        $outgoing_count = get_post_meta($post->ID, '_wseo_outgoing_links', true) ?: 0;
        
        // Check if scan was done
        $scan_date = get_option('wseo_link_scan_date', '');
        $has_been_scanned = !empty($scan_date);
        
        // Determine status based on actual incoming links count
        $has_incoming = $incoming_links['count'] > 0;
        ?>
        
        <!-- Link Stats -->
        <div class="wseo-field-row">
            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; margin-bottom: 20px;">
                <div style="text-align: center; padding: 15px; background: #f6f7f7; border-radius: 8px;">
                    <div style="font-size: 24px; font-weight: bold; color: #2271b1;"><?php echo $incoming_links['count']; ?></div>
                    <div style="font-size: 12px; color: #666;">Prichádzajúce odkazy</div>
                </div>
                <div style="text-align: center; padding: 15px; background: #f6f7f7; border-radius: 8px;">
                    <div style="font-size: 24px; font-weight: bold; color: #00a32a;"><?php echo $outgoing_count; ?></div>
                    <div style="font-size: 12px; color: #666;">Odchádzajúce odkazy</div>
                </div>
                <div style="text-align: center; padding: 15px; background: <?php 
                    if (!$has_been_scanned) {
                        echo '#f6f7f7';
                    } elseif ($has_incoming) {
                        echo '#e7f7e7';
                    } else {
                        echo '#ffe0e0';
                    }
                ?>; border-radius: 8px;">
                    <div style="font-size: 24px;"><?php 
                        if (!$has_been_scanned) {
                            echo '❓';
                        } elseif ($has_incoming) {
                            echo '✅';
                        } else {
                            echo '⚠️';
                        }
                    ?></div>
                    <div style="font-size: 12px; color: <?php 
                        if (!$has_been_scanned) {
                            echo '#666';
                        } elseif ($has_incoming) {
                            echo '#00a32a';
                        } else {
                            echo '#d63638';
                        }
                    ?>;">
                        <?php 
                        if (!$has_been_scanned) {
                            echo 'Spustite skenovanie';
                        } elseif ($has_incoming) {
                            echo 'Má prichádzajúce odkazy';
                        } else {
                            echo 'Osirotená stránka!';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        
        <?php if ($has_been_scanned && !$has_incoming): ?>
        <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px 15px; margin-bottom: 20px;">
            <strong>⚠️ Táto stránka je osirotená!</strong><br>
            <small>Žiadna iná stránka na ňu neodkazuje. Pridajte odkaz z relevantných článkov.</small>
        </div>
        <?php elseif (!$has_been_scanned): ?>
        <div style="background: #f0f6fc; border-left: 4px solid #2271b1; padding: 12px 15px; margin-bottom: 20px;">
            <strong>ℹ️ Skenovanie ešte nebolo spustené</strong><br>
            <small>Pre analýzu interných odkazov navštívte <a href="<?php echo admin_url('admin.php?page=webstudio-seo-links'); ?>">SEO Pro → Interné odkazy</a> a kliknite na "Skenovať odkazy".</small>
        </div>
        <?php endif; ?>
        
        <!-- Link Suggestions -->
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <strong>💡 Návrhy na prepojenie</strong>
                <p class="description">Stránky ktoré by mohli byť relevantné pre prepojenie z tohto obsahu.</p>
            </div>
            <div class="wseo-field-input">
                <?php if (!empty($suggestions)): ?>
                <table class="widefat" style="margin-top: 10px;">
                    <thead>
                        <tr>
                            <th>Stránka</th>
                            <th width="120">Zhoda</th>
                            <th width="100">Akcia</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($suggestions as $suggestion): ?>
                        <tr>
                            <td>
                                <strong><?php echo esc_html($suggestion['target_title']); ?></strong>
                                <br><small style="color: #666;">
                                    <?php echo $suggestion['match_type'] === 'title' ? '📌 Zhoda s názvom' : '🔑 Zhoda s keyword'; ?>:
                                    "<?php echo esc_html($suggestion['match_text']); ?>"
                                </small>
                            </td>
                            <td>
                                <span style="display: inline-block; padding: 3px 8px; background: <?php echo $suggestion['relevance'] >= 90 ? '#e7f7e7' : '#f6f7f7'; ?>; border-radius: 4px; font-weight: bold; color: <?php echo $suggestion['relevance'] >= 90 ? '#00a32a' : '#666'; ?>;">
                                    <?php echo $suggestion['relevance']; ?>%
                                </span>
                            </td>
                            <td>
                                <button type="button" class="button button-small wseo-copy-link" data-url="<?php echo esc_url($suggestion['target_url']); ?>" data-title="<?php echo esc_attr($suggestion['target_title']); ?>">
                                    📋 Kopírovať
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <script>
                jQuery(function($) {
                    $('.wseo-copy-link').on('click', function() {
                        var url = $(this).data('url');
                        
                        navigator.clipboard.writeText(url).then(function() {
                            alert('URL skopírovaná do schránky:\n' + url);
                        });
                    });
                });
                </script>
                <?php else: ?>
                <p style="color: #666; padding: 15px; background: #f6f7f7; border-radius: 4px;">
                    Žiadne návrhy na prepojenie. Uistite sa, že máte nastavené Focus Keywords na iných stránkach.
                </p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Incoming Links -->
        <?php if (!empty($incoming_links['incoming'])): ?>
        <div class="wseo-field-row" style="margin-top: 20px;">
            <div class="wseo-field-label">
                <strong>📥 Prichádzajúce odkazy</strong>
                <p class="description">Stránky ktoré odkazujú na túto stránku.</p>
            </div>
            <div class="wseo-field-input">
                <ul style="margin: 0; padding: 0; list-style: none;">
                    <?php foreach (array_slice($incoming_links['incoming'], 0, 10) as $link): ?>
                    <li style="padding: 8px 0; border-bottom: 1px solid #eee;">
                        <a href="<?php echo esc_url($link['from_url']); ?>" target="_blank"><?php echo esc_html($link['from_title']); ?></a>
                        <?php if (!empty($link['anchor'])): ?>
                        <br><small style="color: #666;">Anchor: "<em><?php echo esc_html($link['anchor']); ?></em>"</small>
                        <?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php if (count($incoming_links['incoming']) > 10): ?>
                <p style="color: #666; margin-top: 10px;">... a <?php echo count($incoming_links['incoming']) - 10; ?> ďalších</p>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="wseo-info-box" style="margin-top: 20px;">
            <p>💡 <strong>Tip:</strong> Pre úplnú analýzu interných odkazov navštívte <a href="<?php echo admin_url('admin.php?page=webstudio-seo-links'); ?>">SEO Pro → Interné odkazy</a>.</p>
        </div>
    </div>

    <!-- Tab: FAQ Schema -->
    <div class="wseo-tab-content" id="wseo-tab-faq">
        <?php
        $faq_items = get_post_meta($post->ID, '_wseo_faq_items', true);
        if (!is_array($faq_items)) {
            $faq_items = array();
        }
        ?>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <strong>❓ FAQ Schema</strong>
            </div>
        </div>
        <div class="wseo-field-row">
            <p class="description" style="margin: 0 0 20px; padding-left: 5px; color: #666;">Pridajte otázky a odpovede pre FAQ rich snippets v Google.</p>
        </div>
        
        <div id="wseo-faq-container">
            <?php if (!empty($faq_items)): ?>
                <?php foreach ($faq_items as $index => $item): ?>
                <div class="wseo-faq-item" style="background: #f9f9f9; padding: 15px; margin-bottom: 10px; border-radius: 4px; border-left: 4px solid #2271b1;">
                    <div style="margin-bottom: 10px;">
                        <label><strong>Otázka:</strong></label>
                        <input type="text" name="wseo_faq[<?php echo $index; ?>][question]" value="<?php echo esc_attr($item['question']); ?>" class="large-text" placeholder="Napíšte otázku...">
                    </div>
                    <div style="margin-bottom: 10px;">
                        <label><strong>Odpoveď:</strong></label>
                        <textarea name="wseo_faq[<?php echo $index; ?>][answer]" class="large-text" rows="3" placeholder="Napíšte odpoveď..."><?php echo esc_textarea($item['answer']); ?></textarea>
                    </div>
                    <button type="button" class="button wseo-remove-faq" style="color: #d63638;">✕ Odstrániť</button>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <div style="margin-top: 15px;">
            <button type="button" id="wseo-add-faq" class="button button-primary">
                ➕ Pridať otázku
            </button>
        </div>
        
        <script>
        jQuery(function($) {
            var faqIndex = <?php echo count($faq_items); ?>;
            
            $('#wseo-add-faq').on('click', function() {
                var html = '<div class="wseo-faq-item" style="background: #f9f9f9; padding: 15px; margin-bottom: 10px; border-radius: 4px; border-left: 4px solid #2271b1;">' +
                    '<div style="margin-bottom: 10px;">' +
                    '<label><strong>Otázka:</strong></label>' +
                    '<input type="text" name="wseo_faq[' + faqIndex + '][question]" class="large-text" placeholder="Napíšte otázku...">' +
                    '</div>' +
                    '<div style="margin-bottom: 10px;">' +
                    '<label><strong>Odpoveď:</strong></label>' +
                    '<textarea name="wseo_faq[' + faqIndex + '][answer]" class="large-text" rows="3" placeholder="Napíšte odpoveď..."></textarea>' +
                    '</div>' +
                    '<button type="button" class="button wseo-remove-faq" style="color: #d63638;">✕ Odstrániť</button>' +
                    '</div>';
                $('#wseo-faq-container').append(html);
                faqIndex++;
            });
            
            $(document).on('click', '.wseo-remove-faq', function() {
                $(this).closest('.wseo-faq-item').remove();
            });
        });
        </script>
        
        <div class="wseo-info-box" style="margin-top: 20px;">
            <p>💡 <strong>Tip:</strong> FAQ Schema pomáha zobraziť vaše otázky priamo vo výsledkoch vyhľadávania Google ako rozbaľovacie položky.</p>
        </div>
    </div>

    <!-- Tab: Advanced (E-E-A-T, Hreflang, Reading Time) -->
    <div class="wseo-tab-content" id="wseo-tab-advanced">
        <?php
        // Get saved values
        $author_name = get_post_meta($post->ID, '_wseo_author_name', true);
        $author_title = get_post_meta($post->ID, '_wseo_author_title', true);
        $author_url = get_post_meta($post->ID, '_wseo_author_url', true);
        $author_social = get_post_meta($post->ID, '_wseo_author_social', true);
        $hreflang_entries = get_post_meta($post->ID, '_wseo_hreflang', true);
        if (!is_array($hreflang_entries)) {
            $hreflang_entries = array();
        }
        $show_reading_time = get_post_meta($post->ID, '_wseo_show_reading_time', true);
        $show_toc = get_post_meta($post->ID, '_wseo_show_toc', true);
        
        // Default ON pre blog články, OFF pre ostatné
        if ($show_reading_time === '') {
            $show_reading_time = ($post->post_type === 'post') ? '1' : '0';
        }
        if ($show_toc === '') {
            $show_toc = ($post->post_type === 'post') ? '1' : '0';
        }
        
        // Calculate reading time
        $content = $this->get_post_content($post->ID);
        $word_count = str_word_count(strip_tags($content));
        $reading_time = max(1, ceil($word_count / 200)); // 200 slov za minútu
        ?>
        
        <!-- E-E-A-T: Author Information -->
        <div class="wseo-field-row">
            <h3 style="margin: 0 0 5px; padding: 0 0 10px 15px; border-bottom: 1px solid #ddd;">E-E-A-T: Informácie o autorovi</h3>
        </div>
        <div class="wseo-field-row">
            <p class="description" style="margin: 0 0 20px; padding-left: 15px; color: #666;">Google vyžaduje jasné autorstvo pre lepšie hodnotenie (Experience, Expertise, Authoritativeness, Trustworthiness).</p>
        </div>
        
        <?php if ($post->post_type === 'post'): ?>
        <!-- Article Type (2026) -->
        <?php $article_type = get_post_meta($post->ID, '_wseo_article_type', true); ?>
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_article_type"><strong>Typ článku (Schema.org)</strong></label>
            </div>
            <div class="wseo-field-input">
                <select id="wseo_article_type" name="wseo_article_type" class="regular-text">
                    <option value="">Auto-detect (<?php echo get_option('wseo_schema_type') === 'NewsMediaOrganization' ? 'NewsArticle' : 'BlogPosting'; ?>)</option>
                    <option value="BlogPosting" <?php selected($article_type, 'BlogPosting'); ?>>BlogPosting (blog článok)</option>
                    <option value="NewsArticle" <?php selected($article_type, 'NewsArticle'); ?>>NewsArticle (správa)</option>
                    <option value="Article" <?php selected($article_type, 'Article'); ?>>Article (všeobecný článok)</option>
                </select>
                <p class="description">Google 2026: BlogPosting pre blogy, NewsArticle pre správy. Auto-detect podľa typu organizácie.</p>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_author_name"><strong>Meno autora</strong></label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_author_name" name="wseo_author_name" value="<?php echo esc_attr($author_name ?: get_the_author_meta('display_name', $post->post_author)); ?>" class="regular-text" placeholder="<?php echo esc_attr(get_the_author_meta('display_name', $post->post_author)); ?>">
                <p class="description">Ak necháte prázdne, použije sa meno autora z WordPress profilu.</p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_author_title"><strong>Pozícia / Titul</strong></label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_author_title" name="wseo_author_title" value="<?php echo esc_attr($author_title); ?>" class="regular-text" placeholder="napr. CEO, Šéfredaktor, SEO Špecialista">
                <p class="description">Zobrazí sa v Author Schema pre Google (jobTitle).</p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_author_url"><strong>URL profilu autora</strong></label>
            </div>
            <div class="wseo-field-input">
                <input type="url" id="wseo_author_url" name="wseo_author_url" value="<?php echo esc_url($author_url); ?>" class="regular-text" placeholder="https://example.com/o-nas/jan-novak/">
                <p class="description">Odkaz na stránku "O autorovi" alebo LinkedIn profil.</p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_author_social"><strong>Sociálne siete autora</strong></label>
            </div>
            <div class="wseo-field-input">
                <textarea id="wseo_author_social" name="wseo_author_social" class="large-text" rows="3" placeholder="https://linkedin.com/in/jan-novak&#10;https://twitter.com/jannovak"><?php echo esc_textarea($author_social); ?></textarea>
                <p class="description">Jeden odkaz na riadok. Použije sa v Schema.org (sameAs).</p>
            </div>
        </div>
        
        <!-- AI Content Marking (2026 Standard) -->
        <?php
        $is_ai_content = get_post_meta($post->ID, '_wseo_ai_generated', true);
        $ai_source = get_post_meta($post->ID, '_wseo_ai_source', true);
        $is_ai_image = get_post_meta($post->ID, '_wseo_image_ai_generated', true);
        ?>
        
        <div class="wseo-field-row" style="margin-top: 30px;">
            <h3 style="margin: 0 0 5px; padding: 0 0 10px 15px; border-bottom: 1px solid #ddd;">🤖 AI Content Marking (Google 2026)</h3>
        </div>
        <div class="wseo-field-row">
            <p class="description" style="margin: 0 0 20px; padding-left: 15px; color: #666;">
                <strong>Nový štandard Google 2026:</strong> Transparentné označenie AI-generovaného obsahu zvyšuje dôveryhodnosť.
            </p>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_ai_generated"><strong>AI-generovaný obsah</strong></label>
            </div>
            <div class="wseo-field-input">
                <label style="display: inline-flex; align-items: center;">
                    <input type="checkbox" name="wseo_ai_generated" id="wseo_ai_generated" value="1" <?php checked($is_ai_content, '1'); ?>>
                    <span style="margin-left: 8px;">Tento obsah bol vytvorený s pomocou AI (ChatGPT, Claude, atď.)</span>
                </label>
                <p class="description">Označí článok ako "AI-Assisted" v Schema.org. Neznamená penalizáciu, ale transparentnosť.</p>
            </div>
        </div>
        
        <div class="wseo-field-row" id="wseo-ai-source-row" style="<?php echo ($is_ai_content !== '1') ? 'display: none;' : ''; ?>">
            <div class="wseo-field-label">
                <label for="wseo_ai_source"><strong>AI Model použitý</strong></label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_ai_source" name="wseo_ai_source" value="<?php echo esc_attr($ai_source); ?>" class="regular-text" placeholder="napr. ChatGPT 4, Claude 3.5 Sonnet, Gemini Pro">
                <p class="description">Voliteľné: Špecifikujte AI model pre "isBasedOn" schema.</p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_image_ai_generated"><strong>AI-generovaný obrázok</strong></label>
            </div>
            <div class="wseo-field-input">
                <label style="display: inline-flex; align-items: center;">
                    <input type="checkbox" name="wseo_image_ai_generated" id="wseo_image_ai_generated" value="1" <?php checked($is_ai_image, '1'); ?>>
                    <span style="margin-left: 8px;">Featured image bol vygenerovaný AI (DALL-E, Midjourney, Stable Diffusion)</span>
                </label>
                <p class="description">Pridá metadata do ImageObject schema podľa Google 2026 štandardov.</p>
            </div>
        </div>
        
        <?php
        // Načítať hodnoty z post meta, ak neexistujú, použiť globálne nastavenia
        $image_credit = get_post_meta($post->ID, '_wseo_image_credit', true);
        $image_license = get_post_meta($post->ID, '_wseo_image_license', true);
        $image_license_page = get_post_meta($post->ID, '_wseo_image_license_page', true);
        $image_creator = get_post_meta($post->ID, '_wseo_image_creator', true);
        $image_copyright_notice = get_post_meta($post->ID, '_wseo_image_copyright_notice', true);
        
        // Ak nie sú nastavené v post meta, použiť hodnoty z globálnych nastavení
        if (empty($image_credit)) {
            $image_credit = get_option('wseo_logo_credit', get_bloginfo('name'));
        }
        if (empty($image_license)) {
            $image_license = get_option('wseo_logo_license', 'https://creativecommons.org/licenses/by/4.0/');
        }
        if (empty($image_license_page)) {
            $image_license_page = get_option('wseo_logo_license_page', home_url('/image-licenses/'));
        }
        if (empty($image_creator)) {
            $image_creator = get_option('wseo_logo_creator', '');
        }
        if (empty($image_copyright_notice)) {
            $image_copyright_notice = get_option('wseo_logo_copyright_notice', '');
        }
        ?>
        
        <div class="wseo-field-row" style="margin-top: 20px;">
            <h4 style="margin: 0 0 5px; padding: 0 0 5px 15px; border-bottom: 1px solid #eee; color: #d63638;">📷 Metadáta obrázka (povinné pre Search Console)</h4>
            <p class="description" style="margin: 5px 0 0; padding-left: 15px; color: #666;">
                <strong>💡 Tip:</strong> Polia sú automaticky predvyplnené z globálnych nastavení. Môžete ich ponechať alebo zmeniť pre tento konkrétny obrázok.
            </p>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_image_credit">
                    <strong>Autor / Zdroj obrázka</strong>
                    <span style="color: #d63638;">*</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_image_credit" name="wseo_image_credit" value="<?php echo esc_attr($image_credit); ?>" class="regular-text" placeholder="napr. Jan Novák, Unsplash, vlastná fotografia">
                <p class="description">
                    <strong>creditText</strong> - Povinné pole pre Search Console. Uvádza autora alebo zdroj obrázka.<br>
                    <em style="color: #059669;">✓ Predvyplnené z globálnych nastavení</em>
                </p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_image_license">
                    <strong>URL alebo typ licencie</strong>
                    <span style="color: #d63638;">*</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_image_license" name="wseo_image_license" value="<?php echo esc_attr($image_license); ?>" class="large-text" placeholder="https://creativecommons.org/licenses/by/4.0/">
                <p class="description">
                    <strong>license</strong> - Povinné pole. Zadajte URL Creative Commons licencie alebo inú platnú licenciu.<br>
                    Príklady: <code>https://creativecommons.org/licenses/by/4.0/</code>, <code>https://creativecommons.org/publicdomain/zero/1.0/</code><br>
                    <em style="color: #059669;">✓ Predvyplnené z globálnych nastavení</em>
                </p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_image_license_page">
                    <strong>Stránka s licenčnými informáciami</strong>
                    <span style="color: #d63638;">*</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_image_license_page" name="wseo_image_license_page" value="<?php echo esc_attr($image_license_page); ?>" class="large-text" placeholder="<?php echo home_url('/image-licenses/'); ?>">
                <p class="description">
                    <strong>acquireLicensePage</strong> - Povinné pole. URL stránky, kde možno získať licenciu alebo info o používaní.<br>
                    Vytvorte stránku na vašom webe (napr. <code>/image-licenses/</code>) s informáciami o licenciách obrázkov.<br>
                    <em style="color: #059669;">✓ Predvyplnené z globálnych nastavení</em>
                </p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_image_creator">
                    <strong>Tvorca/Autor obrázka</strong>
                </label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_image_creator" name="wseo_image_creator" value="<?php echo esc_attr($image_creator); ?>" class="regular-text" placeholder="napr. Jan Novák, Grafické štúdio XY">
                <p class="description">
                    <strong>creator</strong> - Nepovinné pole. Meno osoby alebo organizácie, ktorá vytvorila obrázok.<br>
                    <em style="color: #059669;">✓ Predvyplnené z globálnych nastavení</em>
                </p>
            </div>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_image_copyright_notice">
                    <strong>Copyright oznámenie</strong>
                </label>
            </div>
            <div class="wseo-field-input">
                <input type="text" id="wseo_image_copyright_notice" name="wseo_image_copyright_notice" value="<?php echo esc_attr($image_copyright_notice); ?>" class="regular-text" placeholder="napr. © 2025 Webstudio.ltd. Všetky práva vyhradené.">
                <p class="description">
                    <strong>copyrightNotice</strong> - Nepovinné pole. Text s informáciou o autorských právach.<br>
                    <em style="color: #059669;">✓ Predvyplnené z globálnych nastavení</em>
                </p>
            </div>
        </div>
        
        <script>
        jQuery(document).ready(function($) {
            $('#wseo_ai_generated').on('change', function() {
                if ($(this).is(':checked')) {
                    $('#wseo-ai-source-row').slideDown(200);
                } else {
                    $('#wseo-ai-source-row').slideUp(200);
                }
            });
        });
        </script>
        
        <!-- Hreflang -->
        <div class="wseo-field-row" style="margin-top: 30px;">
            <h3 style="margin: 0 0 5px; padding: 0 0 10px 15px; border-bottom: 1px solid #ddd;">Hreflang (Viacjazyčné verzie)</h3>
        </div>
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label><strong>Preklady stránky</strong></label>
            </div>
            <div class="wseo-field-input">
                <p class="description" style="margin: 0 0 15px;">Prepojte túto stránku s jej prekladmi v iných jazykoch.</p>
        
                <div id="wseo-hreflang-container">
                    <?php if (!empty($hreflang_entries)): ?>
                        <?php foreach ($hreflang_entries as $index => $entry): ?>
                        <div class="wseo-hreflang-item" style="display: flex; gap: 10px; margin-bottom: 10px; align-items: center;">
                            <select name="wseo_hreflang[<?php echo $index; ?>][lang]" style="width: 150px;">
                                <option value="">-- Jazyk --</option>
                                <option value="sk" <?php selected($entry['lang'], 'sk'); ?>>Slovenčina (sk)</option>
                                <option value="cs" <?php selected($entry['lang'], 'cs'); ?>>Čeština (cs)</option>
                                <option value="en" <?php selected($entry['lang'], 'en'); ?>>English (en)</option>
                                <option value="de" <?php selected($entry['lang'], 'de'); ?>>Deutsch (de)</option>
                                <option value="hu" <?php selected($entry['lang'], 'hu'); ?>>Magyar (hu)</option>
                                <option value="pl" <?php selected($entry['lang'], 'pl'); ?>>Polski (pl)</option>
                                <option value="uk" <?php selected($entry['lang'], 'uk'); ?>>Українська (uk)</option>
                                <option value="ru" <?php selected($entry['lang'], 'ru'); ?>>Русский (ru)</option>
                                <option value="fr" <?php selected($entry['lang'], 'fr'); ?>>Français (fr)</option>
                                <option value="es" <?php selected($entry['lang'], 'es'); ?>>Español (es)</option>
                                <option value="it" <?php selected($entry['lang'], 'it'); ?>>Italiano (it)</option>
                                <option value="x-default" <?php selected($entry['lang'], 'x-default'); ?>>x-default</option>
                            </select>
                            <input type="url" name="wseo_hreflang[<?php echo $index; ?>][url]" value="<?php echo esc_url($entry['url']); ?>" class="regular-text" placeholder="https://example.com/en/page/">
                            <button type="button" class="button wseo-remove-hreflang" style="color: #d63638;">✕</button>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <div style="margin-top: 10px;">
                    <button type="button" id="wseo-add-hreflang" class="button">➕ Pridať jazykovú verziu</button>
                </div>
            </div>
        </div>
        
        <script>
        jQuery(function($) {
            var hreflangIndex = <?php echo count($hreflang_entries); ?>;
            
            $('#wseo-add-hreflang').on('click', function() {
                var html = '<div class="wseo-hreflang-item" style="display: flex; gap: 10px; margin-bottom: 10px; align-items: center;">' +
                    '<select name="wseo_hreflang[' + hreflangIndex + '][lang]" style="width: 150px;">' +
                    '<option value="">-- Jazyk --</option>' +
                    '<option value="sk">Slovenčina (sk)</option>' +
                    '<option value="cs">Čeština (cs)</option>' +
                    '<option value="en">English (en)</option>' +
                    '<option value="de">Deutsch (de)</option>' +
                    '<option value="hu">Magyar (hu)</option>' +
                    '<option value="pl">Polski (pl)</option>' +
                    '<option value="uk">Українська (uk)</option>' +
                    '<option value="ru">Русский (ru)</option>' +
                    '<option value="fr">Français (fr)</option>' +
                    '<option value="es">Español (es)</option>' +
                    '<option value="it">Italiano (it)</option>' +
                    '<option value="x-default">x-default</option>' +
                    '</select>' +
                    '<input type="url" name="wseo_hreflang[' + hreflangIndex + '][url]" class="regular-text" placeholder="https://example.com/en/page/">' +
                    '<button type="button" class="button wseo-remove-hreflang" style="color: #d63638;">✕</button>' +
                    '</div>';
                $('#wseo-hreflang-container').append(html);
                hreflangIndex++;
            });
            
            $(document).on('click', '.wseo-remove-hreflang', function() {
                $(this).closest('.wseo-hreflang-item').remove();
            });
        });
        </script>
        
        <!-- Reading Time & TOC -->
        <div class="wseo-field-row" style="margin-top: 30px;">
            <h3 style="margin: 0 0 5px; padding: 0 0 10px 15px; border-bottom: 1px solid #ddd;">Čas čítania & Obsah</h3>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label><strong>Automatické funkcie</strong></label>
            </div>
            <div class="wseo-field-input">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div style="background: #f6f7f7; padding: 20px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 36px; font-weight: bold; color: #2271b1;"><?php echo $reading_time; ?> min</div>
                        <div style="color: #666;">Odhadovaný čas čítania</div>
                        <div style="margin-top: 10px;">
                            <label>
                                <input type="checkbox" name="wseo_show_reading_time" value="1" <?php checked($show_reading_time, '1'); ?>>
                                Zobraziť na stránke
                            </label>
                        </div>
                    </div>
                    <div style="background: #f6f7f7; padding: 20px; border-radius: 8px; text-align: center;">
                        <div style="font-size: 36px;">📑</div>
                        <div style="color: #666;">Automatický obsah (TOC)</div>
                        <div style="margin-top: 10px;">
                            <label>
                                <input type="checkbox" name="wseo_show_toc" value="1" <?php checked($show_toc, '1'); ?>>
                                Generovať z H2/H3
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- v2.9.13: Review Schema REMOVED - Google penalty risk -->
        <div class="wseo-field-row" style="margin-top: 30px;">
            <h3 style="margin: 0 0 5px; padding: 0 0 10px 15px; border-bottom: 1px solid #ddd;">⚠️ Review Schema - Upozornenie</h3>
        </div>
        
        <div class="wseo-field-row" style="background: #fff3cd; padding: 20px; border-radius: 4px; border-left: 4px solid #ffc107;">
            <div class="wseo-field-input">
                <h4 style="margin: 0 0 10px; color: #856404;">🚫 Self-serving Reviews sú zakázané od 2019</h4>
                <p style="margin: 0 0 15px; color: #856404;">
                    <strong>Google od septembra 2019 nepodporuje</strong> vlastné recenzie (self-serving reviews) pre LocalBusiness, Organization, Restaurant, Hotel a podobné typy.
                </p>
                <p style="margin: 0 0 15px; color: #333;">
                    <strong>Čo to znamená?</strong><br>
                    • Recenzie ktoré si pridáte sami na svoju stránku <strong>nebudú zobrazené</strong> v Google Rich Results<br>
                    • Použitie fake recenzií môže viesť k <strong>penalizácii</strong> vašej stránky<br>
                    • Google akceptuje len recenzie od <strong>tretích strán</strong> (Google Reviews, Yelp, TripAdvisor...)
                </p>
                <p style="margin: 0; color: #333;">
                    <strong>✅ Ako získať hviezdičky v Google:</strong><br>
                    • Pre <strong>produkty</strong> (WooCommerce): Použite skutočné zákaznícke recenzie - plugin ich automaticky zobrazí<br>
                    • Pre <strong>firmy</strong>: Zbierajte recenzie na Google My Business, Facebook, TripAdvisor<br>
                    • Pre <strong>softvér</strong>: Zbierajte recenzie na WordPress.org, G2, Capterra
                </p>
                <p style="margin: 15px 0 0; font-size: 12px; color: #666;">
                    📖 Zdroj: <a href="https://developers.google.com/search/blog/2019/09/making-review-rich-results-more-helpful" target="_blank">Google Search Central Blog (2019)</a>
                </p>
            </div>
        </div>
    </div>

    <!-- Info Box -->
    <div class="wseo-info-box">
        <p>💡 <strong>Tip:</strong> Ak necháte polia prázdne, plugin automaticky vygeneruje SEO z názvu a obsahu stránky.</p>
    </div>

    <?php if ($post->post_type === 'page'): 
        // Get saved schema values
        $page_schema_type = get_post_meta($post->ID, '_wseo_schema_type', true);
        $page_schema_name = get_post_meta($post->ID, '_wseo_schema_name', true);
        $page_schema_description = get_post_meta($post->ID, '_wseo_schema_description', true);
        $page_schema_phone = get_post_meta($post->ID, '_wseo_schema_phone', true);
        $page_schema_email = get_post_meta($post->ID, '_wseo_schema_email', true);
        $page_schema_address = get_post_meta($post->ID, '_wseo_schema_address', true);
        $page_schema_city = get_post_meta($post->ID, '_wseo_schema_city', true);
        $page_schema_zip = get_post_meta($post->ID, '_wseo_schema_zip', true);
        $page_schema_country = get_post_meta($post->ID, '_wseo_schema_country', true);
        $page_schema_lat = get_post_meta($post->ID, '_wseo_schema_lat', true);
        $page_schema_lng = get_post_meta($post->ID, '_wseo_schema_lng', true);
        $page_schema_image = get_post_meta($post->ID, '_wseo_schema_image', true);
        $page_schema_price_range = get_post_meta($post->ID, '_wseo_schema_price_range', true);
        // v2.9.12: Removed $page_schema_opening - now using day-by-day fields
    ?>
    <!-- Tab: Schema -->
    <div class="wseo-tab-content" id="wseo-tab-schema">
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_schema_type">
                    <strong>Typ Schema.org</strong>
                    <span class="wseo-help" title="Vyberte typ štruktúrovaných dát pre túto stránku.">?</span>
                </label>
            </div>
            <div class="wseo-field-input">
                <select id="wseo_schema_type" name="wseo_schema_type" class="large-text">
                    <?php echo Webstudio_SEO_Pro::get_instance()->get_schema_types_options($page_schema_type); ?>
                </select>
                <p class="wseo-field-note">Vyberte špecifický typ pre túto stránku alebo nechajte prázdne pre globálne nastavenia.</p>
            </div>
        </div>
        
        <!-- Dynamic schema fields container -->
        <div id="wseo-schema-dynamic-fields">
            
            <!-- LocalBusiness fields -->
            <div id="wseo-schema-localbusiness-fields" style="display: none;">
                
                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label for="wseo_schema_name"><strong>Názov podniku</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <input type="text" id="wseo_schema_name" name="wseo_schema_name" 
                               value="<?php echo esc_attr($page_schema_name); ?>" class="large-text"
                               placeholder="Názov firmy/služby pre túto stránku">
                    </div>
                </div>

                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label for="wseo_schema_description"><strong>Popis</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <textarea id="wseo_schema_description" name="wseo_schema_description" 
                                  rows="2" class="large-text" placeholder="Krátky popis pre Schema.org"><?php echo esc_textarea($page_schema_description); ?></textarea>
                    </div>
                </div>

                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label><strong>Kontakt</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <input type="tel" name="wseo_schema_phone" id="wseo_schema_phone" value="<?php echo esc_attr($page_schema_phone); ?>" 
                               class="regular-text" placeholder="Telefón: +421 900 123 456" style="margin-bottom: 8px;">
                        <input type="email" name="wseo_schema_email" id="wseo_schema_email" value="<?php echo esc_attr($page_schema_email); ?>" 
                               class="regular-text" placeholder="Email: info@example.com">
                    </div>
                </div>

                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label><strong>Adresa</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <input type="text" name="wseo_schema_address" id="wseo_schema_address" value="<?php echo esc_attr($page_schema_address); ?>" 
                               class="large-text" placeholder="Ulica a číslo" style="margin-bottom: 8px;">
                        <input type="text" name="wseo_schema_city" id="wseo_schema_city" value="<?php echo esc_attr($page_schema_city); ?>" 
                               class="regular-text" placeholder="Mesto" style="margin-bottom: 8px;">
                        <input type="text" name="wseo_schema_zip" id="wseo_schema_zip" value="<?php echo esc_attr($page_schema_zip); ?>" 
                               class="small-text" placeholder="PSČ" style="width: 100px; margin-right: 10px;">
                        <input type="text" name="wseo_schema_country" value="<?php echo esc_attr($page_schema_country ?: 'SK'); ?>" 
                               class="small-text" placeholder="SK" style="width: 60px;">
                    </div>
                </div>

                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label><strong>GPS súradnice</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <input type="text" id="wseo_schema_lat" name="wseo_schema_lat" value="<?php echo esc_attr($page_schema_lat); ?>" 
                               class="small-text" placeholder="48.1486" style="width: 120px; margin-right: 10px;">
                        <input type="text" id="wseo_schema_lng" name="wseo_schema_lng" value="<?php echo esc_attr($page_schema_lng); ?>" 
                               class="small-text" placeholder="17.1077" style="width: 120px; margin-right: 10px;">
                        <button type="button" id="wseo_page_geocode_btn" class="button button-secondary">
                            📍 Vyhľadať z adresy
                        </button>
                        <span id="wseo_page_geocode_status" style="margin-left: 10px; display: none;"></span>
                    </div>
                </div>

                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label for="wseo_schema_image"><strong>Obrázok</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <input type="url" id="wseo_schema_image" name="wseo_schema_image" 
                               value="<?php echo esc_url($page_schema_image); ?>" class="large-text"
                               placeholder="https://example.com/image.jpg">
                    </div>
                </div>

                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label for="wseo_schema_price_range"><strong>Cenová kategória</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <select id="wseo_schema_price_range" name="wseo_schema_price_range">
                            <option value="" <?php selected($page_schema_price_range, ''); ?>>— Nevybrané —</option>
                            <option value="€" <?php selected($page_schema_price_range, '€'); ?>>€ - Nízke ceny</option>
                            <option value="€€" <?php selected($page_schema_price_range, '€€'); ?>>€€ - Stredné ceny</option>
                            <option value="€€€" <?php selected($page_schema_price_range, '€€€'); ?>>€€€ - Vyššie ceny</option>
                            <option value="€€€€" <?php selected($page_schema_price_range, '€€€€'); ?>>€€€€ - Luxusné</option>
                        </select>
                    </div>
                </div>

                <!-- Opening Hours -->
                <div class="wseo-field-row">
                    <div class="wseo-field-label">
                        <label><strong>Otváracie hodiny</strong></label>
                    </div>
                    <div class="wseo-field-input">
                        <p class="wseo-field-note" style="margin-bottom: 10px;">Vyplňte pre každý deň (nechajte prázdne ak je zatvorené)</p>
                        <table style="width: auto; border-collapse: collapse;">
                            <?php
                            $days = array(
                                'mon' => 'Pondelok',
                                'tue' => 'Utorok',
                                'wed' => 'Streda',
                                'thu' => 'Štvrtok',
                                'fri' => 'Piatok',
                                'sat' => 'Sobota',
                                'sun' => 'Nedeľa'
                            );
                            foreach ($days as $key => $label):
                                $open = get_post_meta($post->ID, "_wseo_schema_hours_{$key}_open", true);
                                $close = get_post_meta($post->ID, "_wseo_schema_hours_{$key}_close", true);
                            ?>
                            <tr style="border-bottom: 1px solid #ddd;">
                                <td style="padding: 5px 10px 5px 0; width: 80px;"><strong><?php echo $label; ?></strong></td>
                                <td style="padding: 5px;">
                                    <input type="time" name="wseo_schema_hours_<?php echo $key; ?>_open" 
                                           value="<?php echo esc_attr($open); ?>" style="width: 100px;">
                                    <span>-</span>
                                    <input type="time" name="wseo_schema_hours_<?php echo $key; ?>_close" 
                                           value="<?php echo esc_attr($close); ?>" style="width: 100px;">
                                    <?php if ($open && $close): ?>
                                        <span style="color: #00a32a; margin-left: 5px;">✓</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </table>
                    </div>
                </div>
            </div>
            
            <!-- Organization fields (simpler) - REMOVED duplicate fields in v3.1 -->
            <!-- Phone/email are already in LocalBusiness fields above -->
            <div id="wseo-schema-organization-fields" style="display: none;">
                <div class="wseo-info-box">
                    <p>ℹ️ Pre typ <strong>Organization</strong> môžete vyplniť kontaktné údaje vyššie v sekcii LocalBusiness.</p>
                </div>
            </div>
            
            <!-- Page type fields -->
            <div id="wseo-schema-page-fields" style="display: none;">
                <div class="wseo-info-box">
                    <p>ℹ️ Pre stránky typu <strong>ContactPage</strong>, <strong>AboutPage</strong>, <strong>FAQPage</strong> nie sú potrebné ďalšie polia - Google automaticky rozpozná typ stránky.</p>
                </div>
            </div>
            
            <!-- Empty state -->
            <div id="wseo-schema-empty-fields">
                <div class="wseo-info-box">
                    <p>👆 Vyberte typ Schema.org vyššie pre zobrazenie relevantných polí.</p>
                </div>
            </div>
            
        </div>

        <div class="wseo-info-box" style="margin-top: 20px;">
            <p>💡 <strong>Tip:</strong> Schema.org pre túto stránku prepíše globálne nastavenia. Ideálne pre kontaktnú stránku, pobočky, služby.</p>
        </div>
        
        <!-- Schema type field visibility JavaScript -->
        <script>
        jQuery(document).ready(function($) {
            var localBusinessTypes = [
                'LocalBusiness', 'Restaurant', 'CafeOrCoffeeShop', 'Bakery', 'BarOrPub', 
                'FastFoodRestaurant', 'IceCreamShop', 'Winery', 'Brewery',
                'Store', 'ClothingStore', 'ElectronicsStore', 'FurnitureStore', 'GroceryStore',
                'HardwareStore', 'JewelryStore', 'LiquorStore', 'PetStore', 'ShoeStore',
                'SportingGoodsStore', 'ToyStore', 'Florist',
                'Hotel', 'LodgingBusiness', 'BedAndBreakfast', 'Hostel', 'Motel', 'Resort',
                'Campground', 'SkiResort', 'VacationRental',
                'Service', 'ProfessionalService', 'FinancialService', 'LegalService',
                'AccountingService', 'InsuranceAgency',
                'BeautySalon', 'HairSalon', 'NailSalon', 'DaySpa', 'TattooParlor',
                'MedicalBusiness', 'Dentist', 'Physician', 'Pharmacy', 'Optician', 'VeterinaryCare',
                'AutoRepair', 'AutoDealer', 'AutoRental', 'AutoWash', 'GasStation',
                'GeneralContractor', 'Electrician', 'Plumber', 'RoofingContractor', 'HVACBusiness',
                'RealEstateAgent'
            ];
            
            var organizationTypes = ['Organization', 'NewsMediaOrganization'];
            var pageTypes = ['ContactPage', 'AboutPage', 'FAQPage'];
            
            function updateSchemaFields(schemaType) {
                // Hide all field groups
                $('#wseo-schema-localbusiness-fields').hide();
                $('#wseo-schema-organization-fields').hide();
                $('#wseo-schema-page-fields').hide();
                $('#wseo-schema-empty-fields').hide();
                
                if (!schemaType || schemaType === '') {
                    $('#wseo-schema-empty-fields').show();
                    return;
                }
                
                if (localBusinessTypes.indexOf(schemaType) !== -1) {
                    $('#wseo-schema-localbusiness-fields').show();
                } else if (organizationTypes.indexOf(schemaType) !== -1) {
                    $('#wseo-schema-organization-fields').show();
                } else if (pageTypes.indexOf(schemaType) !== -1) {
                    $('#wseo-schema-page-fields').show();
                } else {
                    // Unknown type - show LocalBusiness fields as default
                    $('#wseo-schema-localbusiness-fields').show();
                }
            }
            
            // Initial state
            updateSchemaFields($('#wseo_schema_type').val());
            
            // On change
            $('#wseo_schema_type').on('change', function() {
                updateSchemaFields($(this).val());
            });
            
            // Auto-geocode button
            $('#wseo_page_geocode_btn').on('click', function() {
                var $btn = $(this);
                var $status = $('#wseo_page_geocode_status');
                
                var street = $('#wseo_schema_address').val() || '';
                var city = $('#wseo_schema_city').val() || '';
                var zip = $('#wseo_schema_zip').val() || '';
                var country = $('input[name="wseo_schema_country"]').val() || 'SK';
                
                var query = [];
                if (street) query.push(street);
                if (city) query.push(city);
                if (zip) query.push(zip);
                if (country) query.push(country);
                
                if (query.length < 2) {
                    alert('❌ Vyplňte aspoň ulicu a mesto.');
                    return;
                }
                
                $btn.prop('disabled', true).text('⏳ Hľadám...');
                $status.hide();
                
                $.ajax({
                    url: 'https://nominatim.openstreetmap.org/search',
                    data: { q: query.join(', '), format: 'json', limit: 1 },
                    dataType: 'json',
                    success: function(data) {
                        if (data && data.length > 0) {
                            $('#wseo_schema_lat').val(parseFloat(data[0].lat).toFixed(6));
                            $('#wseo_schema_lng').val(parseFloat(data[0].lon).toFixed(6));
                            $status.html('<span style="color: #00a32a;">✅ Nájdené!</span>').show();
                        } else {
                            $status.html('<span style="color: #d63638;">❌ Nenájdené</span>').show();
                        }
                    },
                    error: function() {
                        $status.html('<span style="color: #d63638;">❌ Chyba</span>').show();
                    },
                    complete: function() {
                        $btn.prop('disabled', false).text('📍 Vyhľadať z adresy');
                    }
                });
            });
        });
        </script>
        
        <!-- SoftwareApplication Schema (2026) -->
        <?php
        $is_software = get_post_meta($post->ID, '_wseo_is_software', true);
        $software_name = get_post_meta($post->ID, '_wseo_software_name', true);
        $software_version = get_post_meta($post->ID, '_wseo_software_version', true);
        $software_price = get_post_meta($post->ID, '_wseo_software_price', true);
        $software_currency = get_post_meta($post->ID, '_wseo_software_currency', true) ?: 'EUR';
        $software_os = get_post_meta($post->ID, '_wseo_software_os', true);
        $software_category = get_post_meta($post->ID, '_wseo_software_category', true);
        $software_download = get_post_meta($post->ID, '_wseo_software_download', true);
        $software_rating = get_post_meta($post->ID, '_wseo_software_rating', true);
        $software_review_count = get_post_meta($post->ID, '_wseo_software_review_count', true);
        ?>
        
        <div class="wseo-field-row" style="margin-top: 30px;">
            <h3 style="margin: 0 0 5px; padding: 0 0 10px 15px; border-bottom: 1px solid #ddd;">💻 SoftwareApplication Schema (2026)</h3>
        </div>
        <div class="wseo-field-row">
            <p class="description" style="margin: 0 0 20px; padding-left: 15px; color: #666;">
                Pre stránky predávajúce softvér, aplikácie, pluginy. Google 2026 štandard.
            </p>
        </div>
        
        <div class="wseo-field-row">
            <div class="wseo-field-label">
                <label for="wseo_is_software"><strong>Povoliť Software Schema</strong></label>
            </div>
            <div class="wseo-field-input">
                <label>
                    <input type="checkbox" name="wseo_is_software" id="wseo_is_software" value="1" <?php checked($is_software, '1'); ?>>
                    Táto stránka predstavuje softvérový produkt
                </label>
            </div>
        </div>
        
        <div id="wseo-software-fields" style="<?php echo ($is_software !== '1') ? 'display: none;' : ''; ?>">
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label for="wseo_software_name"><strong>Názov softvéru</strong></label>
                </div>
                <div class="wseo-field-input">
                    <input type="text" id="wseo_software_name" name="wseo_software_name" value="<?php echo esc_attr($software_name); ?>" class="regular-text" placeholder="<?php echo esc_attr(get_the_title()); ?>">
                </div>
            </div>
            
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label for="wseo_software_version"><strong>Verzia</strong></label>
                </div>
                <div class="wseo-field-input">
                    <input type="text" id="wseo_software_version" name="wseo_software_version" value="<?php echo esc_attr($software_version); ?>" class="regular-text" placeholder="1.0.0">
                </div>
            </div>
            
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label for="wseo_software_os"><strong>Operačný systém</strong></label>
                </div>
                <div class="wseo-field-input">
                    <input type="text" id="wseo_software_os" name="wseo_software_os" value="<?php echo esc_attr($software_os); ?>" class="regular-text" placeholder="Windows, macOS, Linux, iOS, Android">
                </div>
            </div>
            
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label for="wseo_software_category"><strong>Kategória</strong></label>
                </div>
                <div class="wseo-field-input">
                    <select id="wseo_software_category" name="wseo_software_category" class="regular-text">
                        <option value="">-- Vyberte --</option>
                        <option value="BrowserApplication" <?php selected($software_category, 'BrowserApplication'); ?>>Browser Extension</option>
                        <option value="DeveloperApplication" <?php selected($software_category, 'DeveloperApplication'); ?>>Developer Tool</option>
                        <option value="GameApplication" <?php selected($software_category, 'GameApplication'); ?>>Game</option>
                        <option value="MobileApplication" <?php selected($software_category, 'MobileApplication'); ?>>Mobile App</option>
                        <option value="WebApplication" <?php selected($software_category, 'WebApplication'); ?>>Web App</option>
                        <option value="DesktopEnhancementApplication" <?php selected($software_category, 'DesktopEnhancementApplication'); ?>>Desktop Enhancement</option>
                    </select>
                </div>
            </div>
            
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label for="wseo_software_download"><strong>Download URL</strong></label>
                </div>
                <div class="wseo-field-input">
                    <input type="url" id="wseo_software_download" name="wseo_software_download" value="<?php echo esc_url($software_download); ?>" class="large-text" placeholder="https://example.com/download">
                </div>
            </div>
            
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label><strong>Cena</strong></label>
                </div>
                <div class="wseo-field-input">
                    <div style="display: flex; gap: 10px;">
                        <input type="number" step="0.01" name="wseo_software_price" value="<?php echo esc_attr($software_price); ?>" placeholder="49.99" style="width: 150px;">
                        <select name="wseo_software_currency" style="width: 100px;">
                            <option value="EUR" <?php selected($software_currency, 'EUR'); ?>>EUR</option>
                            <option value="USD" <?php selected($software_currency, 'USD'); ?>>USD</option>
                            <option value="GBP" <?php selected($software_currency, 'GBP'); ?>>GBP</option>
                            <option value="CZK" <?php selected($software_currency, 'CZK'); ?>>CZK</option>
                        </select>
                    </div>
                    <p class="description">Nechajte prázdne pre free softvér.</p>
                </div>
            </div>
            
            <div class="wseo-field-row">
                <div class="wseo-field-label">
                    <label><strong>Hodnotenie</strong></label>
                </div>
                <div class="wseo-field-input">
                    <div style="display: flex; gap: 10px; align-items: center;">
                        <input type="number" step="0.1" min="0" max="5" name="wseo_software_rating" value="<?php echo esc_attr($software_rating); ?>" placeholder="4.5" style="width: 80px;">
                        <span>/5 stars z</span>
                        <input type="number" name="wseo_software_review_count" value="<?php echo esc_attr($software_review_count); ?>" placeholder="150" style="width: 100px;">
                        <span>recenzií</span>
                    </div>
                </div>
            </div>
        </div>
        
        <script>
        jQuery(document).ready(function($) {
            $('#wseo_is_software').on('change', function() {
                if ($(this).is(':checked')) {
                    $('#wseo-software-fields').slideDown(200);
                } else {
                    $('#wseo-software-fields').slideUp(200);
                }
            });
        });
        </script>
    </div>
    <?php endif; ?>

</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Tabs
    $('.wseo-tab-btn').on('click', function(e) {
        e.preventDefault();
        var tabId = $(this).data('tab');
        $('.wseo-tab-btn').removeClass('active');
        $(this).addClass('active');
        $('.wseo-tab-content').removeClass('active');
        $('#wseo-tab-' + tabId).addClass('active');
    });
    
    // v2.9.13: Get site name and separator for title calculation
    var $titleInput = $('#wseo_meta_title');
    var siteName = $titleInput.attr('data-site-name') || '';
    var separator = $titleInput.attr('data-separator') || ' - ';
    var titleSuffix = siteName ? separator + siteName : '';
    var suffixLength = titleSuffix.length;
    
    // Character counters - TITLE includes suffix length
    function updateTitleCounter(input, countEl, ratingEl, progressEl, min, max) {
        var len = input.val().length;
        var totalLen = len + suffixLength; // Include suffix in count
        
        countEl.text(len);
        progressEl.css('width', Math.min((totalLen / max) * 100, 100) + '%');
        
        if (totalLen >= min && totalLen <= max) {
            ratingEl.text('– Dobre').removeClass('okay bad').addClass('good');
            progressEl.removeClass('okay bad').addClass('good');
        } else if (totalLen > 0 && totalLen < min) {
            ratingEl.text('– Krátke').removeClass('good bad').addClass('okay');
            progressEl.removeClass('good bad').addClass('okay');
        } else if (totalLen > max) {
            ratingEl.text('– Príliš dlhé!').removeClass('good okay').addClass('bad');
            progressEl.removeClass('good okay').addClass('bad');
        } else {
            ratingEl.text('');
            progressEl.removeClass('okay bad').addClass('good');
        }
    }
    
    // Character counter for description (no suffix)
    function updateCounter(input, countEl, ratingEl, progressEl, min, max) {
        var len = input.val().length;
        countEl.text(len);
        progressEl.css('width', Math.min((len / max) * 100, 100) + '%');
        
        if (len >= min && len <= max) {
            ratingEl.text('– Dobre').removeClass('okay bad').addClass('good');
            progressEl.removeClass('okay bad').addClass('good');
        } else if (len > 0 && len < min) {
            ratingEl.text('– Krátke').removeClass('good bad').addClass('okay');
            progressEl.removeClass('good bad').addClass('okay');
        } else if (len > max) {
            ratingEl.text('– Príliš dlhé').removeClass('good okay').addClass('bad');
            progressEl.removeClass('good okay').addClass('bad');
        } else {
            ratingEl.text('');
            progressEl.removeClass('okay bad').addClass('good');
        }
    }
    
    $('#wseo_meta_title').on('input', function() {
        updateTitleCounter($(this), $('#wseo-title-count'), $('#wseo-title-rating'), $('#wseo-title-progress'), 30, 60);
    }).trigger('input');
    
    $('#wseo_meta_description').on('input', function() {
        updateCounter($(this), $('#wseo-desc-count'), $('#wseo-desc-rating'), $('#wseo-desc-progress'), 120, 160);
    }).trigger('input');
});
</script>
