<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wrap wseo-admin-wrap">
    <h1 style="display: flex; align-items: center; gap: 10px;">
        <span style="font-size: 28px;">🔗</span> Interné odkazy
    </h1>
    
    <?php
    $link_map = get_option('wseo_link_map', array());
    $orphans = get_option('wseo_orphan_pages', array());
    $anchor_map = get_option('wseo_anchor_map', array());
    $scan_date = get_option('wseo_link_scan_date', '');
    
    // Calculate stats
    $total_links = 0;
    $pages_with_links = 0;
    foreach ($link_map as $url => $data) {
        $total_links += $data['count'];
        if ($data['count'] > 0) {
            $pages_with_links++;
        }
    }
    ?>
    
    <!-- Stats Cards -->
    <div class="wseo-stats-grid" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin: 30px 20px; padding: 0; max-width: none;">
        <div class="wseo-admin-card" style="text-align: center; padding: 30px 20px; display: flex; flex-direction: column; justify-content: center; align-items: center; min-height: 140px;">
            <div style="font-size: 42px; font-weight: bold; color: #2271b1; line-height: 1;"><?php echo number_format($total_links); ?></div>
            <div style="color: #666; margin-top: 8px; font-size: 14px;">Interných odkazov</div>
        </div>
        <div class="wseo-admin-card" style="text-align: center; padding: 30px 20px; display: flex; flex-direction: column; justify-content: center; align-items: center; min-height: 140px;">
            <div style="font-size: 42px; font-weight: bold; color: #00a32a; line-height: 1;"><?php echo number_format($pages_with_links); ?></div>
            <div style="color: #666; margin-top: 8px; font-size: 14px;">Stránok s odkazmi</div>
        </div>
        <div class="wseo-admin-card" style="text-align: center; padding: 30px 20px; display: flex; flex-direction: column; justify-content: center; align-items: center; min-height: 140px;">
            <div style="font-size: 42px; font-weight: bold; color: <?php echo count($orphans) > 0 ? '#d63638' : '#00a32a'; ?>; line-height: 1;"><?php echo number_format(count($orphans)); ?></div>
            <div style="color: #666; margin-top: 8px; font-size: 14px;">Osirotených stránok</div>
        </div>
        <div class="wseo-admin-card" style="text-align: center; padding: 30px 20px; display: flex; flex-direction: column; justify-content: center; align-items: center; min-height: 140px;">
            <?php if ($scan_date): ?>
                <div style="font-size: 13px; color: #666;">Posledné skenovanie:</div>
                <div style="font-size: 18px; font-weight: bold; color: #1d2327; margin: 5px 0;"><?php echo date('d.m.Y', strtotime($scan_date)); ?></div>
                <div style="font-size: 13px; color: #666; margin-bottom: 10px;"><?php echo date('H:i', strtotime($scan_date)); ?></div>
            <?php else: ?>
                <div style="font-size: 13px; color: #d63638; margin-bottom: 10px;">Ešte neskenované</div>
            <?php endif; ?>
            <form method="post" style="margin: 0;">
                <?php wp_nonce_field('wseo_internal_links'); ?>
                <button type="submit" name="wseo_scan_links" class="button button-primary">
                    🔄 Skenovať odkazy
                </button>
            </form>
        </div>
    </div>
    
    <!-- Orphan Pages -->
    <div class="wseo-admin-card">
        <h2>🚨 Osirotené stránky</h2>
        <p class="description">Stránky na ktoré nevedie žiadny interný odkaz. Google ich môže ťažšie nájsť a indexovať.</p>
        
        <?php if (!empty($orphans)): ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>Stránka</th>
                    <th width="100">Typ</th>
                    <th width="120">Dátum</th>
                    <th width="150">Akcia</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orphans as $orphan): ?>
                <tr>
                    <td>
                        <strong><a href="<?php echo esc_url($orphan['url']); ?>" target="_blank"><?php echo esc_html($orphan['title']); ?></a></strong>
                        <br><small style="color: #666;"><?php echo esc_url($orphan['url']); ?></small>
                    </td>
                    <td>
                        <?php 
                        $type_labels = array('post' => '📝 Článok', 'page' => '📄 Stránka', 'product' => '🛒 Produkt');
                        echo isset($type_labels[$orphan['type']]) ? $type_labels[$orphan['type']] : $orphan['type'];
                        ?>
                    </td>
                    <td><?php echo date('d.m.Y', strtotime($orphan['date'])); ?></td>
                    <td>
                        <a href="<?php echo admin_url('post.php?post=' . $orphan['id'] . '&action=edit'); ?>" class="button button-small">
                            ✏️ Upraviť
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div style="margin-top: 15px; padding: 15px; background: #fff3cd; border-left: 4px solid #ffc107;">
            <strong>💡 Tip:</strong> Pridajte na tieto stránky odkazy z iných relevantných článkov alebo z navigačného menu.
        </div>
        <?php else: ?>
        <div style="padding: 40px; text-align: center; background: #f0f9f0; border-radius: 8px;">
            <span style="font-size: 48px;">✅</span>
            <p style="font-size: 16px; color: #00a32a; margin: 10px 0 0;">
                <?php if ($scan_date): ?>
                    Výborne! Všetky stránky majú interné odkazy.
                <?php else: ?>
                    Kliknite na "Skenovať odkazy" pre analýzu.
                <?php endif; ?>
            </p>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Top Linked Pages -->
    <div class="wseo-admin-card">
        <h2>📊 Najodkazovanejšie stránky</h2>
        <p class="description">Stránky s najväčším počtom prichádzajúcich interných odkazov.</p>
        
        <?php if (!empty($link_map)): 
            // Sort by link count
            uasort($link_map, function($a, $b) {
                return $b['count'] - $a['count'];
            });
            $top_linked = array_slice($link_map, 0, 15, true);
        ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>URL</th>
                    <th width="100">Odkazy</th>
                    <th width="250">Odkazujúce stránky</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($top_linked as $url => $data): ?>
                <tr>
                    <td>
                        <a href="<?php echo esc_url($url); ?>" target="_blank"><?php echo esc_html($url); ?></a>
                    </td>
                    <td>
                        <strong style="color: #2271b1; font-size: 16px;"><?php echo $data['count']; ?></strong>
                    </td>
                    <td>
                        <?php 
                        $sources = array_slice($data['incoming'], 0, 3);
                        foreach ($sources as $source): 
                        ?>
                            <a href="<?php echo esc_url($source['from_url']); ?>" title="<?php echo esc_attr($source['from_title']); ?>" style="text-decoration: none;">
                                📄
                            </a>
                        <?php endforeach; 
                        if (count($data['incoming']) > 3): ?>
                            <span style="color: #666;">+<?php echo count($data['incoming']) - 3; ?> ďalších</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
        <p style="color: #666; padding: 20px; text-align: center;">Najprv spustite skenovanie odkazov.</p>
        <?php endif; ?>
    </div>
    
    <!-- Anchor Text Analysis -->
    <div class="wseo-admin-card">
        <h2>🏷️ Analýza Anchor textov</h2>
        <p class="description">Kontrola diverzity a kvality anchor textov interných odkazov.</p>
        
        <?php if (!empty($anchor_map)): 
            // Find problematic anchors
            $bad_anchors = array('tu', 'sem', 'klikni', 'klikni sem', 'click here', 'here', 'link', 'viac', 'čítaj viac', 'read more', 'toto', 'tento');
            $issues = array();
            
            foreach ($anchor_map as $url => $anchors) {
                $total = array_sum($anchors);
                foreach ($anchors as $anchor => $count) {
                    $percentage = ($count / $total) * 100;
                    
                    if (in_array(mb_strtolower($anchor), $bad_anchors)) {
                        $issues[] = array(
                            'url' => $url,
                            'anchor' => $anchor,
                            'count' => $count,
                            'issue' => 'Nepopisný anchor text',
                            'type' => 'bad'
                        );
                    } elseif ($percentage > 50 && $count > 3) {
                        $issues[] = array(
                            'url' => $url,
                            'anchor' => $anchor,
                            'count' => $count,
                            'issue' => 'Príliš častý anchor (' . round($percentage) . '%)',
                            'type' => 'warning'
                        );
                    }
                }
            }
        ?>
        
        <?php if (!empty($issues)): ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>Anchor text</th>
                    <th width="80">Počet</th>
                    <th>Problém</th>
                    <th>Cieľová URL</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach (array_slice($issues, 0, 20) as $index => $issue): ?>
                <tr>
                    <td>
                        <code style="background: <?php echo $issue['type'] === 'bad' ? '#ffe0e0' : '#fff3cd'; ?>; padding: 2px 6px;">
                            <?php echo esc_html($issue['anchor']); ?>
                        </code>
                    </td>
                    <td><?php echo $issue['count']; ?>×</td>
                    <td>
                        <span style="color: <?php echo $issue['type'] === 'bad' ? '#d63638' : '#dba617'; ?>;">
                            <?php echo $issue['type'] === 'bad' ? '❌' : '⚠️'; ?>
                            <?php echo esc_html($issue['issue']); ?>
                        </span>
                    </td>
                    <td>
                        <small><?php echo esc_html(substr($issue['url'], 0, 50)); ?>...</small>
                        <br>
                        <button type="button" 
                                class="button button-small wseo-optimize-anchor" 
                                data-anchor="<?php echo esc_attr($issue['anchor']); ?>"
                                data-url="<?php echo esc_attr($issue['url']); ?>"
                                data-count="<?php echo $issue['count']; ?>"
                                data-type="<?php echo $issue['type']; ?>"
                                style="margin-top: 5px;">
                            ⚡ Optimalizovať
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div style="margin-top: 15px; padding: 15px; background: #f0f6fc; border-left: 4px solid #2271b1;">
            <strong>💡 Odporúčania pre anchor texty:</strong>
            <ul style="margin: 10px 0 0 20px;">
                <li>Používajte popisné texty, nie "klikni sem" alebo "tu"</li>
                <li>Variujte anchor texty - nepoužívajte stále rovnaký</li>
                <li>Anchor by mal popisovať cieľovú stránku</li>
                <li>Ideálna dĺžka je 2-5 slov</li>
            </ul>
        </div>
        <?php else: ?>
        <div style="padding: 20px; text-align: center; background: #f0f9f0; border-radius: 8px;">
            ✅ Žiadne problémy s anchor textami neboli nájdené.
        </div>
        <?php endif; ?>
        
        <?php else: ?>
        <p style="color: #666; padding: 20px; text-align: center;">Najprv spustite skenovanie odkazov.</p>
        <?php endif; ?>
    </div>
    
    <!-- Link Suggestions Info -->
    <div class="wseo-admin-card">
        <h2>💡 Návrhy na prepojenie</h2>
        <p class="description">Automatické návrhy na interné prepojenia nájdete priamo v editore príspevkov.</p>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-top: 20px;">
            <div style="background: #f6f7f7; padding: 20px; border-radius: 8px;">
                <h4 style="margin-top: 0;">📝 Ako to funguje:</h4>
                <ol style="margin: 0; padding-left: 20px; color: #666;">
                    <li>Otvorte príspevok na úpravu</li>
                    <li>V SEO meta boxe nájdete tab "🔗 Odkazy"</li>
                    <li>Plugin analyzuje váš obsah</li>
                    <li>Navrhne relevantné interné odkazy</li>
                </ol>
            </div>
            <div style="background: #f6f7f7; padding: 20px; border-radius: 8px;">
                <h4 style="margin-top: 0;">🎯 Na čo sa zameriava:</h4>
                <ul style="margin: 0; padding-left: 20px; color: #666;">
                    <li>Zhoda s názvami iných článkov</li>
                    <li>Zhoda s focus keywords</li>
                    <li>Tematická relevancia</li>
                    <li>Stránky bez odkazov (priorita)</li>
                </ul>
            </div>
        </div>
    </div>
    
    <!-- Broken Links Checker -->
    <div class="wseo-admin-card">
        <h2>🔗 Nefunkčné odkazy (Broken Links)</h2>
        <p class="description">Skontrolujte všetky odkazy na vašom webe a nájdite nefunkčné.</p>
        
        <?php
        $broken_links = get_option('wseo_broken_links', array());
        $broken_scan_date = get_option('wseo_broken_links_scan_date', '');
        ?>
        
        <div style="display: flex; gap: 20px; align-items: center; margin: 20px 0; flex-wrap: wrap;">
            <button type="button" id="wseo-scan-broken-links" class="button button-primary">
                🔍 Skenovať nefunkčné odkazy
            </button>
            <?php if (!empty($broken_links)): ?>
            <button type="button" id="wseo-remove-all-broken-links" class="button" style="background: #d63638; color: white; border-color: #d63638;">
                🗑️ Vymazať všetky nefunkčné odkazy (<?php echo count($broken_links); ?>)
            </button>
            <?php endif; ?>
            <span id="wseo-broken-scan-status">
                <?php if ($broken_scan_date): ?>
                    Posledné skenovanie: <strong><?php echo date('d.m.Y H:i', strtotime($broken_scan_date)); ?></strong>
                    | Nájdených: <strong style="color: <?php echo count($broken_links) > 0 ? '#d63638' : '#00a32a'; ?>;"><?php echo count($broken_links); ?></strong>
                <?php else: ?>
                    <span style="color: #666;">Ešte neskenované</span>
                <?php endif; ?>
            </span>
        </div>
        
        <div id="wseo-broken-links-progress" style="display: none; margin: 20px 0;">
            <div style="background: #f0f0f0; border-radius: 4px; overflow: hidden;">
                <div id="wseo-broken-progress-bar" style="background: #2271b1; height: 20px; width: 0%; transition: width 0.3s;"></div>
            </div>
            <p id="wseo-broken-progress-text" style="margin: 10px 0; color: #666;">Skenuje sa...</p>
        </div>
        
        <?php if (!empty($broken_links)): ?>
        <table class="wp-list-table widefat fixed striped" id="wseo-broken-links-table">
            <thead>
                <tr>
                    <th>Nefunkčný odkaz</th>
                    <th width="100">Stav</th>
                    <th width="250">Nájdený v</th>
                    <th width="100">Akcia</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($broken_links as $link): ?>
                <tr>
                    <td>
                        <code style="background: #ffe0e0; padding: 2px 6px; word-break: break-all;"><?php echo esc_html($link['url']); ?></code>
                    </td>
                    <td>
                        <span style="color: #d63638; font-weight: bold;">
                            <?php echo $link['status_code'] ? $link['status_code'] : '❌'; ?>
                        </span>
                        <br><small><?php echo esc_html($link['error']); ?></small>
                    </td>
                    <td>
                        <a href="<?php echo admin_url('post.php?post=' . $link['found_in']['post_id'] . '&action=edit'); ?>">
                            <?php echo esc_html($link['found_in']['post_title']); ?>
                        </a>
                        <br><small style="color: #666;"><?php echo $link['found_in']['post_type']; ?></small>
                    </td>
                    <td>
                        <a href="<?php echo admin_url('post.php?post=' . $link['found_in']['post_id'] . '&action=edit'); ?>" class="button button-small">
                            ✏️ Opraviť
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
        <div style="padding: 30px; text-align: center; background: #f0f9f0; border-radius: 8px;" id="wseo-no-broken-links">
            <?php if ($broken_scan_date): ?>
                <span style="font-size: 36px;">✅</span>
                <p style="color: #00a32a; margin: 10px 0 0;">Výborne! Žiadne nefunkčné odkazy neboli nájdené.</p>
            <?php else: ?>
                <span style="font-size: 36px;">🔍</span>
                <p style="color: #666; margin: 10px 0 0;">Kliknite na "Skenovať nefunkčné odkazy" pre kontrolu.</p>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <script>
        jQuery(function($) {
            // Scan broken links
            $('#wseo-scan-broken-links').on('click', function() {
                var $btn = $(this);
                $btn.prop('disabled', true).text('⏳ Skenuje sa...');
                $('#wseo-broken-links-progress').show();
                $('#wseo-broken-progress-bar').css('width', '50%');
                $('#wseo-broken-progress-text').text('Kontrolujú sa všetky odkazy na webe...');
                
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'wseo_scan_broken_links',
                        nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
                    },
                    success: function(response) {
                        $('#wseo-broken-progress-bar').css('width', '100%');
                        if (response.success) {
                            $('#wseo-broken-progress-text').html('<span style="color: #00a32a;">✅ Hotovo! Nájdených ' + response.data.broken_count + ' nefunkčných odkazov.</span>');
                            setTimeout(function() {
                                location.reload();
                            }, 1500);
                        } else {
                            $('#wseo-broken-progress-text').html('<span style="color: #d63638;">❌ ' + (response.data.message || 'Chyba pri skenovaní.') + '</span>');
                            setTimeout(function() {
                                $('#wseo-broken-links-progress').hide();
                            }, 5000);
                        }
                    },
                    error: function(xhr, status, error) {
                        $('#wseo-broken-progress-text').html('<span style="color: #d63638;">❌ Chyba pri skenovaní: ' + error + '</span>');
                        setTimeout(function() {
                            $('#wseo-broken-links-progress').hide();
                        }, 5000);
                    },
                    complete: function() {
                        $btn.prop('disabled', false).text('🔍 Skenovať nefunkčné odkazy');
                    }
                });
            });
            
            // Remove all broken links
            $('#wseo-remove-all-broken-links').on('click', function() {
                if (!confirm('Naozaj chcete vymazať VŠETKY nefunkčné odkazy? Táto akcia je nevratná!\n\nOdporúčame najprv vytvoriť zálohu webu.')) {
                    return;
                }
                
                var $btn = $(this);
                $btn.prop('disabled', true).html('⏳ Mažú sa odkazy...');
                $('#wseo-broken-links-progress').show();
                $('#wseo-broken-progress-bar').css('width', '50%');
                $('#wseo-broken-progress-text').text('Odstraňujú sa nefunkčné odkazy z obsahu...');
                
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'wseo_remove_all_broken_links',
                        nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
                    },
                    success: function(response) {
                        $('#wseo-broken-progress-bar').css('width', '100%');
                        if (response.success) {
                            $('#wseo-broken-progress-text').html('<span style="color: #00a32a;">✅ Hotovo! Vymazaných ' + response.data.removed_count + ' odkazov z ' + response.data.posts_updated + ' príspevkov.</span>');
                            setTimeout(function() {
                                location.reload();
                            }, 2000);
                        } else {
                            $('#wseo-broken-progress-text').html('<span style="color: #d63638;">❌ ' + (response.data.message || 'Chyba pri mazaní.') + '</span>');
                            setTimeout(function() {
                                $('#wseo-broken-links-progress').hide();
                            }, 5000);
                        }
                    },
                    error: function(xhr, status, error) {
                        $('#wseo-broken-progress-text').html('<span style="color: #d63638;">❌ Chyba: ' + error + '</span>');
                        setTimeout(function() {
                            $('#wseo-broken-links-progress').hide();
                        }, 5000);
                    },
                    complete: function() {
                        $btn.prop('disabled', false).html('🗑️ Vymazať všetky nefunkčné odkazy');
                    }
                });
            });
            // Optimize anchor text
            $('.wseo-optimize-anchor').on('click', function() {
                var $btn = $(this);
                var anchor = $btn.data('anchor');
                var url = $btn.data('url');
                var count = $btn.data('count');
                var type = $btn.data('type');
                
                var message = type === 'bad' 
                    ? 'Vymazať všetky odkazy s anchor textom "' + anchor + '"?\n\n' +
                      'Tento anchor text je nepopisný a negatívne vplýva na SEO.\n' +
                      'Odkazy budú nahradené len textom bez linku.'
                    : 'Optimalizovať anchor text "' + anchor + '"?\n\n' +
                      'Nájdených: ' + count + '× použití\n' +
                      'Plugin ponechá optimálny počet (2-3) a ostatné vymaže.\n\n' +
                      'Táto akcia je nevratná! Odporúčame zálohu.';
                
                if (!confirm(message)) {
                    return;
                }
                
                $btn.prop('disabled', true).text('⏳ Optimalizuje sa...');
                
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'wseo_optimize_anchor',
                        anchor: anchor,
                        url: url,
                        type: type,
                        nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
                    },
                    success: function(response) {
                        if (response.success) {
                            alert('✅ Hotovo!\n\n' + response.data.message);
                            location.reload();
                        } else {
                            alert('❌ Chyba: ' + (response.data.message || 'Nepodarilo sa optimalizovať.'));
                            $btn.prop('disabled', false).text('⚡ Optimalizovať');
                        }
                    },
                    error: function() {
                        alert('❌ Chyba pri komunikácii so serverom.');
                        $btn.prop('disabled', false).text('⚡ Optimalizovať');
                    }
                });
            });
        });
        </script>
        
        <div style="margin-top: 15px; padding: 15px; background: #fff3cd; border-left: 4px solid #ffc107;">
            <strong>⚠️ Upozornenie:</strong> Skenovanie môže trvať niekoľko minút v závislosti od počtu odkazov na webe. Odporúčame spúšťať raz týždenne.
        </div>
        
        <div style="margin-top: 15px; padding: 15px; background: #e7f3ff; border-left: 4px solid #2271b1;">
            <strong>ℹ️ Požiadavky:</strong> Pre funkciu Broken Links je potrebné mať povolený odchádzajúci HTTP prístup na server. Ak skenovanie nefunguje, skontrolujte:
            <ul style="margin: 10px 0 0 20px;">
                <li>Firewall nastavenia servera</li>
                <li>PHP funkcie <code>wp_remote_head()</code> a <code>curl</code> musia byť povolené</li>
                <li>Odchádzajúce HTTP requesty nie sú blokované</li>
            </ul>
        </div>
    </div>
</div>

<style>
.wseo-admin-wrap .wseo-admin-card {
    background: #fff;
    border: 1px solid #c3c4c7;
    border-radius: 4px;
    padding: 20px;
    margin-bottom: 20px;
}
.wseo-admin-wrap .wseo-admin-card h2 {
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}
</style>
