<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wrap wseo-admin-wrap">
    <h1>🔍 Indexácia</h1>
    
    <form method="post" action="">
        <?php wp_nonce_field('wseo_files_settings'); ?>
        
        <div class="wseo-admin-card">
            <h2>🤖 Robots.txt</h2>
            <p>
                <a href="<?php echo home_url('/robots.txt'); ?>" target="_blank" class="wseo-file-link">
                    <span class="dashicons dashicons-external"></span>
                    Zobraziť robots.txt
                </a>
            </p>
            
            <table class="form-table">
                <tr>
                    <th><label for="wseo_robots_custom_rules">Vlastné pravidlá</label></th>
                    <td>
                        <textarea id="wseo_robots_custom_rules" name="wseo_robots_custom_rules" 
                                  rows="8" class="large-text code"><?php echo esc_textarea(get_option('wseo_robots_custom_rules', '')); ?></textarea>
                        <p class="description">
                            Pridajte vlastné pravidlá pre robots.txt. Jeden riadok = jedno pravidlo.<br>
                            Príklad: <code>Disallow: /private/</code>
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🗺️ Sitemap</h2>
            <p>
                <a href="<?php echo home_url('/sitemap.xml'); ?>" target="_blank" class="wseo-file-link">
                    <span class="dashicons dashicons-external"></span>
                    Zobraziť sitemap.xml
                </a>
            </p>
            <p class="description">
                Sitemap sa generuje automaticky a obsahuje všetky publikované stránky, články a produkty.
                Stránky označené ako "noindex" sú automaticky vynechané.
            </p>
            
            <?php
            $last_submitted = get_option('wseo_sitemap_last_submitted', '');
            $submit_results = get_option('wseo_sitemap_submit_results', array());
            ?>
            
            <?php if ($last_submitted): ?>
            <div style="background: #e7f7e7; border-left: 4px solid #46b450; padding: 12px; margin: 15px 0;">
                <p style="margin: 0;">
                    <strong>Posledné odoslanie:</strong> <?php echo esc_html($last_submitted); ?>
                </p>
                <?php if (!empty($submit_results)): ?>
                    <p style="margin: 5px 0 0 0; font-size: 12px;">
                        <?php foreach ($submit_results as $engine => $result): ?>
                            <span style="margin-right: 15px;">
                                <?php if ($result['success']): ?>
                                    ✅ <?php echo esc_html(ucfirst($engine)); ?>
                                <?php else: ?>
                                    ❌ <?php echo esc_html(ucfirst($engine)); ?>: <?php echo esc_html($result['message']); ?>
                                <?php endif; ?>
                            </span>
                        <?php endforeach; ?>
                    </p>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px; margin: 15px 0;">
                <p style="margin: 0;">
                    ℹ️ <strong>Sitemap ešte nebola odoslaná do vyhľadávačov.</strong><br>
                    <small>Kliknite na tlačidlo nižšie pre okamžité indexovanie cez IndexNow (Bing & Yandex).</small>
                </p>
            </div>
            <?php endif; ?>
            
            <p>
                <button type="button" id="wseo-submit-sitemap" class="button button-secondary">
                    🚀 Odoslať sitemap (IndexNow)
                </button>
                <span id="wseo-submit-sitemap-status" style="margin-left: 10px;"></span>
            </p>
            
            <script>
            jQuery(document).ready(function($) {
                $('#wseo-submit-sitemap').on('click', function() {
                    var $btn = $(this);
                    var $status = $('#wseo-submit-sitemap-status');
                    
                    $btn.prop('disabled', true).text('⏳ Odosielam...');
                    $status.html('<span style="color: #666;">Čakajte...</span>');
                    
                    $.ajax({
                        url: ajaxurl,
                        method: 'POST',
                        data: {
                            action: 'wseo_submit_sitemap_to_gsc',
                            nonce: '<?php echo wp_create_nonce('wseo_nonce'); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                $status.html('<span style="color: #46b450;">✅ ' + response.data.message + '</span>');
                                setTimeout(function() {
                                    location.reload();
                                }, 2000);
                            } else {
                                $status.html('<span style="color: #dc3232;">❌ ' + (response.data.message || 'Chyba') + '</span>');
                                $btn.prop('disabled', false).text('🚀 Odoslať sitemap (IndexNow)');
                            }
                        },
                        error: function(xhr, status, error) {
                            $status.html('<span style="color: #dc3232;">❌ Chyba pri odosielaní</span>');
                            $btn.prop('disabled', false).text('🚀 Odoslať sitemap (IndexNow)');
                        }
                    });
                });
            });
            </script>
            
            <p class="description" style="margin-top: 10px;">
                💡 <strong>IndexNow:</strong> Moderný protokol pre okamžité indexovanie v Bing a Yandex. 
                Pre Google použite <a href="https://search.google.com/search-console" target="_blank">Google Search Console</a> 
                na manuálne odoslanie sitemap.
            </p>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🤖 llms.txt (pre AI boty)</h2>
            <p>
                <a href="<?php echo home_url('/llms.txt'); ?>" target="_blank" class="wseo-file-link">
                    <span class="dashicons dashicons-external"></span>
                    Zobraziť llms.txt
                </a>
            </p>
            <p class="description">
                Špeciálny súbor pre AI vyhľadávače (ChatGPT, Claude, Perplexity...).
                Obsahuje informácie o vašom webe a povolených AI botoch.
            </p>
        </div>
        
        <div class="wseo-admin-card">
            <h2>✅ Overenie vlastníctva webu</h2>
            <p class="description" style="margin-bottom: 15px;">
                Vložte overovací kód (len hodnotu z content="...") pre pripojenie k nástrojom pre webmasterov.
            </p>
            
            <table class="form-table">
                <tr>
                    <th>
                        <label for="wseo_verify_google">
                            <img src="https://www.google.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Google Search Console
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_google" name="wseo_verify_google" 
                               value="<?php echo esc_attr(get_option('wseo_verify_google', '')); ?>" 
                               class="large-text" placeholder="abc123xyz...">
                        <p class="description">
                            <a href="https://search.google.com/search-console" target="_blank">Google Search Console</a> → 
                            Nastavenia → Overenie vlastníctva → HTML tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="wseo_verify_bing">
                            <img src="https://www.bing.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Bing Webmaster Tools
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_bing" name="wseo_verify_bing" 
                               value="<?php echo esc_attr(get_option('wseo_verify_bing', '')); ?>" 
                               class="large-text" placeholder="ABCDEF123456...">
                        <p class="description">
                            <a href="https://www.bing.com/webmasters" target="_blank">Bing Webmaster Tools</a> → 
                            Add site → XML tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="wseo_verify_yandex">
                            <img src="https://yandex.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Yandex Webmaster
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_yandex" name="wseo_verify_yandex" 
                               value="<?php echo esc_attr(get_option('wseo_verify_yandex', '')); ?>" 
                               class="large-text" placeholder="abcdef123456...">
                        <p class="description">
                            <a href="https://webmaster.yandex.com" target="_blank">Yandex Webmaster</a> → 
                            Add site → Meta tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
                <tr>
                    <th>
                        <label for="wseo_verify_pinterest">
                            <img src="https://www.pinterest.com/favicon.ico" alt="" style="width:16px;height:16px;vertical-align:middle;margin-right:5px;">
                            Pinterest
                        </label>
                    </th>
                    <td>
                        <input type="text" id="wseo_verify_pinterest" name="wseo_verify_pinterest" 
                               value="<?php echo esc_attr(get_option('wseo_verify_pinterest', '')); ?>" 
                               class="large-text" placeholder="abc123...">
                        <p class="description">
                            <a href="https://www.pinterest.com/settings/claim" target="_blank">Pinterest</a> → 
                            Claim → Add HTML tag → skopírujte hodnotu z content="..."
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="wseo-admin-card">
            <h2>🚀 Instant Indexing</h2>
            <p class="description" style="margin-bottom: 15px;">
                Automaticky odošle URL do vyhľadávačov ihneď po publikovaní alebo aktualizácii obsahu.
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Povoliť Instant Indexing</th>
                    <td>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox" name="wseo_instant_index_enabled" value="1" 
                                   <?php checked(get_option('wseo_instant_index_enabled', '0'), '1'); ?>>
                            <strong>Automaticky indexovať pri publikovaní</strong>
                        </label>
                        <label style="display: block;">
                            <input type="checkbox" name="wseo_instant_index_on_update" value="1" 
                                   <?php checked(get_option('wseo_instant_index_on_update', '0'), '1'); ?>>
                            Indexovať aj pri aktualizácii existujúceho obsahu
                        </label>
                    </td>
                </tr>
            </table>
            
            <hr style="margin: 20px 0;">
            
            <h3>🔍 Bing & Yandex (IndexNow)</h3>
            <p class="description" style="margin-bottom: 15px;">
                IndexNow je jednoduchý protokol - nevyžaduje žiadne nastavenie. Funguje okamžite!
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Bing IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_bing_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_bing_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Bing IndexNow
                        </label>
                        <p class="description">Okamžité indexovanie v Bing. Žiadna konfigurácia potrebná.</p>
                    </td>
                </tr>
                <tr>
                    <th>Yandex IndexNow</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_yandex_indexnow_enabled" value="1" 
                                   <?php checked(get_option('wseo_yandex_indexnow_enabled', '1'), '1'); ?>>
                            Povoliť Yandex IndexNow
                        </label>
                        <p class="description">Okamžité indexovanie v Yandex. Žiadna konfigurácia potrebná.</p>
                    </td>
                </tr>
                <tr>
                    <th>IndexNow API kľúč</th>
                    <td>
                        <?php 
                        $indexnow_key = get_option('wseo_indexnow_key', '');
                        if (empty($indexnow_key)) {
                            $indexnow_key = wp_generate_password(32, false);
                            update_option('wseo_indexnow_key', $indexnow_key);
                        }
                        ?>
                        <input type="text" value="<?php echo esc_attr($indexnow_key); ?>" class="regular-text" readonly>
                        <p class="description">Automaticky vygenerovaný kľúč. Súbor <code><?php echo esc_html($indexnow_key); ?>.txt</code> sa vytvorí automaticky.</p>
                    </td>
                </tr>
            </table>
            
            <hr style="margin: 20px 0;">
            
            <h3>🔴 Google Indexing API</h3>
            <p class="description" style="margin-bottom: 15px;">
                Google Indexing API vyžaduje nastavenie Service Account v Google Cloud Console.
                <a href="https://developers.google.com/search/apis/indexing-api/v3/quickstart" target="_blank">Návod →</a>
            </p>
            
            <table class="form-table">
                <tr>
                    <th>Google Indexing API</th>
                    <td>
                        <label>
                            <input type="checkbox" name="wseo_google_indexing_enabled" value="1" 
                                   <?php checked(get_option('wseo_google_indexing_enabled', '0'), '1'); ?>>
                            Povoliť Google Indexing API
                        </label>
                        <p class="description">Vyžaduje nastavenie Service Account (pokročilé).</p>
                    </td>
                </tr>
                <tr>
                    <th><label for="wseo_google_indexing_json">Service Account JSON</label></th>
                    <td>
                        <textarea id="wseo_google_indexing_json" name="wseo_google_indexing_json" 
                                  rows="5" class="large-text code" 
                                  placeholder='{"type": "service_account", "project_id": "...", ...}'><?php echo esc_textarea(get_option('wseo_google_indexing_json', '')); ?></textarea>
                        <p class="description">
                            Vložte celý obsah JSON súboru zo Service Account.<br>
                            <strong>Kroky:</strong> Google Cloud Console → APIs → Credentials → Create Service Account → Keys → Add Key → JSON
                        </p>
                    </td>
                </tr>
            </table>
            
            <hr style="margin: 20px 0;">
            
            <h3>📋 Posledné indexovania</h3>
            <?php
            $log = get_option('wseo_indexing_log', array());
            $log = array_reverse(array_slice($log, -10)); // Last 10, newest first
            
            if (empty($log)): ?>
                <p class="description">Zatiaľ neboli odoslané žiadne URL. Aktivujte Instant Indexing vyššie.</p>
            <?php else: ?>
                <table class="widefat striped" style="margin-top: 10px;">
                    <thead>
                        <tr>
                            <th>Čas</th>
                            <th>URL</th>
                            <th style="text-align:center;">Google</th>
                            <th style="text-align:center;">Bing</th>
                            <th style="text-align:center;">Yandex</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($log as $entry): ?>
                        <tr>
                            <td style="white-space:nowrap;"><?php echo esc_html(date('d.m. H:i', strtotime($entry['time']))); ?></td>
                            <td><a href="<?php echo esc_url($entry['url']); ?>" target="_blank" title="<?php echo esc_attr($entry['url']); ?>"><?php 
                                $path = parse_url($entry['url'], PHP_URL_PATH);
                                echo esc_html($path ? $path : '/'); 
                            ?></a></td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['google'])): ?>
                                    <?php echo $entry['results']['google']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['bing'])): ?>
                                    <?php echo $entry['results']['bing']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                            <td style="text-align:center;">
                                <?php if (isset($entry['results']['yandex'])): ?>
                                    <?php echo $entry['results']['yandex']['success'] ? '✅' : '❌'; ?>
                                <?php else: ?>
                                    <span style="color:#999;">—</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        
        <p class="submit">
            <input type="submit" name="wseo_save_files" class="button button-primary" value="Uložiť nastavenia">
        </p>
    </form>
    
    <div class="wseo-admin-card">
        <h2>📋 Náhľad robots.txt</h2>
        <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><?php
$robots = "User-agent: *\n";
$robots .= "Allow: /\n";
$robots .= "Disallow: /wp-admin/\n";
$robots .= "Disallow: /wp-includes/\n";

if (class_exists('WooCommerce')) {
    $robots .= "Disallow: /cart/\n";
    $robots .= "Disallow: /checkout/\n";
    $robots .= "Disallow: /my-account/\n";
}

$custom = get_option('wseo_robots_custom_rules', '');
if ($custom) {
    $robots .= "\n" . $custom . "\n";
}

$robots .= "\nSitemap: " . home_url('/sitemap.xml');

echo esc_html($robots);
        ?></pre>
    </div>
</div>
