<?php defined("ABSPATH") or die("No direct access"); ?>
<div class="wrap wseo-admin-wrap">
    <h1>🔍 Webstudio SEO Pro</h1>
    
    <?php
    global $wpdb;
    
    // Check if we're filtering
    $wseo_filter = isset($_GET['wseo_filter']) ? sanitize_text_field($_GET['wseo_filter']) : '';
    
    if (!empty($wseo_filter)) {
        // Show filtered results
        $post_types = array('post', 'page');
        if (post_type_exists('product')) {
            $post_types[] = 'product';
        }
        $post_types_sql = "'" . implode("','", $post_types) . "'";
        
        $filter_title = '';
        $filtered_posts = array();
        
        switch ($wseo_filter) {
            case 'no_meta_desc':
                $filter_title = 'Príspevky s automatickým Meta Description';
                $posts_with_desc = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_meta_description' AND meta_value != ''
                ");
                $exclude_ids = !empty($posts_with_desc) ? implode(',', array_map('intval', $posts_with_desc)) : '0';
                $filtered_posts = $wpdb->get_results("
                    SELECT ID, post_title, post_type FROM {$wpdb->posts} 
                    WHERE post_status = 'publish' AND post_type IN ({$post_types_sql})
                    AND ID NOT IN ({$exclude_ids})
                    ORDER BY post_title ASC
                ");
                break;
                
            case 'no_alt':
                $filter_title = 'Obrázky bez Alt textu';
                $images_with_alt = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wp_attachment_image_alt' AND meta_value != ''
                ");
                $exclude_ids = !empty($images_with_alt) ? implode(',', array_map('intval', $images_with_alt)) : '0';
                $filtered_posts = $wpdb->get_results("
                    SELECT ID, post_title, post_type, guid FROM {$wpdb->posts} 
                    WHERE post_type = 'attachment' AND post_mime_type LIKE 'image/%'
                    AND ID NOT IN ({$exclude_ids})
                    ORDER BY post_title ASC
                ");
                break;
                
            case 'no_thumbnail':
                $filter_title = 'Príspevky bez náhľadového obrázka';
                $posts_with_thumb = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_thumbnail_id' AND meta_value != ''
                ");
                $exclude_ids = !empty($posts_with_thumb) ? implode(',', array_map('intval', $posts_with_thumb)) : '0';
                $filtered_posts = $wpdb->get_results("
                    SELECT ID, post_title, post_type FROM {$wpdb->posts} 
                    WHERE post_status = 'publish' AND post_type IN ({$post_types_sql})
                    AND ID NOT IN ({$exclude_ids})
                    ORDER BY post_title ASC
                ");
                break;
                
            case 'short_desc':
                $filter_title = 'Krátke vlastné Meta Description (<120 znakov)';
                $filtered_posts = $wpdb->get_results("
                    SELECT p.ID, p.post_title, p.post_type, pm.meta_value as meta_desc FROM {$wpdb->posts} p
                    INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
                    WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
                    AND pm.meta_key = '_wseo_meta_description' 
                    AND pm.meta_value != '' 
                    AND CHAR_LENGTH(pm.meta_value) < 120
                    ORDER BY p.post_title ASC
                ");
                break;
                
            case 'long_title':
                $filter_title = 'Dlhé vlastné Meta Title (>60 znakov)';
                $filtered_posts = $wpdb->get_results("
                    SELECT p.ID, p.post_title, p.post_type, pm.meta_value as meta_title FROM {$wpdb->posts} p
                    INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
                    WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
                    AND pm.meta_key = '_wseo_meta_title' 
                    AND pm.meta_value != '' 
                    AND CHAR_LENGTH(pm.meta_value) > 60
                    ORDER BY p.post_title ASC
                ");
                break;
                
            case 'no_keywords':
                $filter_title = 'Príspevky bez Focus Keywords';
                $posts_with_keywords = $wpdb->get_col("
                    SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                    WHERE meta_key = '_wseo_meta_keywords' AND meta_value != ''
                ");
                $exclude_ids = !empty($posts_with_keywords) ? implode(',', array_map('intval', $posts_with_keywords)) : '0';
                $filtered_posts = $wpdb->get_results("
                    SELECT ID, post_title, post_type FROM {$wpdb->posts} 
                    WHERE post_status = 'publish' AND post_type IN ({$post_types_sql})
                    AND ID NOT IN ({$exclude_ids})
                    ORDER BY post_title ASC
                ");
                break;
                
            case 'noindex':
                $filter_title = 'Stránky s Noindex';
                $filtered_posts = $wpdb->get_results("
                    SELECT p.ID, p.post_title, p.post_type FROM {$wpdb->posts} p
                    INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
                    WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
                    AND pm.meta_key = '_wseo_noindex' AND pm.meta_value = '1'
                    ORDER BY p.post_title ASC
                ");
                break;
        }
        ?>
        
        <div class="wseo-admin-card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h2 style="margin: 0;">🔍 <?php echo esc_html($filter_title); ?> (<?php echo count($filtered_posts); ?>)</h2>
                <a href="<?php echo admin_url('admin.php?page=webstudio-seo'); ?>" class="button">← Späť na prehľad</a>
            </div>
            
            <?php if (empty($filtered_posts)): ?>
                <p style="color: #646970; padding: 20px 0;">Žiadne výsledky.</p>
            <?php else: ?>
                <style>
                .wseo-filter-table { width: 100%; border-collapse: collapse; }
                .wseo-filter-table th, .wseo-filter-table td { padding: 10px 12px; text-align: left; border-bottom: 1px solid #e2e4e7; }
                .wseo-filter-table th { background: #f9f9f9; font-weight: 600; }
                .wseo-filter-table tr:hover { background: #f9f9f9; }
                .wseo-filter-table .post-type { 
                    display: inline-block; padding: 2px 8px; border-radius: 3px; font-size: 11px; 
                    background: #f0f0f1; color: #646970; text-transform: uppercase;
                }
                .wseo-filter-table .post-type-post { background: #e7f3ff; color: #0073aa; }
                .wseo-filter-table .post-type-page { background: #f0e6ff; color: #7b1fa2; }
                .wseo-filter-table .post-type-product { background: #e8f5e9; color: #2e7d32; }
                .wseo-filter-table .post-type-attachment { background: #fff3e0; color: #e65100; }
                .wseo-filter-table .meta-info { font-size: 12px; color: #646970; margin-top: 4px; }
                .wseo-filter-table img.thumb { width: 40px; height: 40px; object-fit: cover; border-radius: 4px; }
                </style>
                
                <table class="wseo-filter-table">
                    <thead>
                        <tr>
                            <?php if ($wseo_filter === 'no_alt'): ?>
                                <th style="width: 50px;">Náhľad</th>
                            <?php endif; ?>
                            <th>Názov</th>
                            <th style="width: 100px;">Typ</th>
                            <?php if (in_array($wseo_filter, array('short_desc', 'long_title'))): ?>
                                <th>Meta</th>
                            <?php endif; ?>
                            <th style="width: 100px;">Akcia</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($filtered_posts as $post): ?>
                        <tr>
                            <?php if ($wseo_filter === 'no_alt'): ?>
                                <td>
                                    <?php 
                                    $thumb_url = wp_get_attachment_image_url($post->ID, 'thumbnail');
                                    if ($thumb_url): ?>
                                        <img src="<?php echo esc_url($thumb_url); ?>" class="thumb" alt="">
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <td>
                                <strong><?php echo esc_html($post->post_title ?: '(bez názvu)'); ?></strong>
                            </td>
                            <td>
                                <span class="post-type post-type-<?php echo esc_attr($post->post_type); ?>">
                                    <?php 
                                    $type_labels = array('post' => 'Článok', 'page' => 'Stránka', 'product' => 'Produkt', 'attachment' => 'Obrázok');
                                    echo isset($type_labels[$post->post_type]) ? $type_labels[$post->post_type] : $post->post_type;
                                    ?>
                                </span>
                            </td>
                            <?php if ($wseo_filter === 'short_desc'): ?>
                                <td>
                                    <div class="meta-info"><?php echo esc_html(mb_substr($post->meta_desc, 0, 60)); ?>... (<?php echo mb_strlen($post->meta_desc); ?> zn.)</div>
                                </td>
                            <?php elseif ($wseo_filter === 'long_title'): ?>
                                <td>
                                    <div class="meta-info"><?php echo esc_html(mb_substr($post->meta_title, 0, 60)); ?>... (<?php echo mb_strlen($post->meta_title); ?> zn.)</div>
                                </td>
                            <?php endif; ?>
                            <td>
                                <?php if ($wseo_filter === 'no_alt'): ?>
                                    <a href="<?php echo admin_url('post.php?post=' . $post->ID . '&action=edit'); ?>" class="button button-small">Upraviť</a>
                                <?php else: ?>
                                    <a href="<?php echo admin_url('post.php?post=' . $post->ID . '&action=edit'); ?>" class="button button-small">Upraviť</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        
        <?php
        return; // Don't show the rest of dashboard
    }
    ?>
    
    <?php
    // Get all published posts count
    $post_types = array('post', 'page');
    if (post_type_exists('product')) {
        $post_types[] = 'product';
    }
    $post_types_sql = "'" . implode("','", $post_types) . "'";
    
    $total_posts = $wpdb->get_var("
        SELECT COUNT(*) FROM {$wpdb->posts} 
        WHERE post_status = 'publish' AND post_type IN ({$post_types_sql})
    ");
    
    // Count posts with custom meta title (our field)
    $with_custom_meta_title = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_meta_title' AND pm.meta_value != ''
    ");
    
    // All posts have title (native WordPress title), so Meta Title = total posts
    // But we show custom vs auto-generated
    $with_meta_title = $total_posts; // All posts have title (either custom or auto from post_title)
    
    // Count posts with custom meta description
    $with_custom_meta_desc = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_meta_description' AND pm.meta_value != ''
    ");
    
    // Posts with content (can auto-generate description)
    $with_content = $wpdb->get_var("
        SELECT COUNT(*) FROM {$wpdb->posts} 
        WHERE post_status = 'publish' AND post_type IN ({$post_types_sql})
        AND post_content != ''
    ");
    
    // Meta description = custom + those with content (auto-generated)
    $with_meta_desc = $total_posts; // All get description (custom or auto from content/excerpt)
    
    // Count posts with focus keywords
    $with_keywords = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_meta_keywords' AND pm.meta_value != ''
    ");
    
    // Count posts with OG image
    $with_og_image = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_og_image' AND pm.meta_value != ''
    ");
    
    // Also count posts with featured image as OG fallback
    $with_thumbnail = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_thumbnail_id' AND pm.meta_value != ''
    ");
    $with_any_image = max($with_og_image, $with_thumbnail);
    
    // Count images
    $total_images = $wpdb->get_var("
        SELECT COUNT(*) FROM {$wpdb->posts} 
        WHERE post_type = 'attachment' AND post_mime_type LIKE 'image/%'
    ");
    
    // Count images with alt text
    $images_with_alt = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_type = 'attachment' AND p.post_mime_type LIKE 'image/%'
        AND pm.meta_key = '_wp_attachment_image_alt' AND pm.meta_value != ''
    ");
    
    // Calculate percentages
    $pct_title = $total_posts > 0 ? round(($with_meta_title / $total_posts) * 100) : 0;
    $pct_desc = $total_posts > 0 ? round(($with_meta_desc / $total_posts) * 100) : 0;
    $pct_keywords = $total_posts > 0 ? round(($with_keywords / $total_posts) * 100) : 0;
    $pct_image = $total_posts > 0 ? round(($with_any_image / $total_posts) * 100) : 0;
    $pct_alt = $total_images > 0 ? round(($images_with_alt / $total_images) * 100) : 0;
    
    // For display - show custom vs auto
    $pct_custom_title = $total_posts > 0 ? round(($with_custom_meta_title / $total_posts) * 100) : 0;
    $pct_custom_desc = $total_posts > 0 ? round(($with_custom_meta_desc / $total_posts) * 100) : 0;
    
    // Issues detection
    $issues = array();
    
    // Posts without CUSTOM meta description (optional optimization)
    $without_custom_desc = $total_posts - $with_custom_meta_desc;
    if ($without_custom_desc > 0 && $with_custom_meta_desc > 0) {
        // Only show if some are customized (otherwise it's just auto mode)
        $issues[] = array(
            'type' => 'info',
            'icon' => '💡',
            'text' => "Príspevky s automatickým Meta Description",
            'count' => $without_custom_desc,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=no_meta_desc')
        );
    }
    
    // Images without alt
    $without_alt = $total_images - $images_with_alt;
    if ($without_alt > 0) {
        $issues[] = array(
            'type' => 'error',
            'icon' => '❌',
            'text' => "Obrázky bez Alt textu",
            'count' => $without_alt,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=no_alt')
        );
    }
    
    // Posts without featured image (no OG image fallback)
    $without_image = $total_posts - $with_any_image;
    if ($without_image > 0) {
        $issues[] = array(
            'type' => 'warning',
            'icon' => '⚠️',
            'text' => "Príspevky bez náhľadového obrázka",
            'count' => $without_image,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=no_thumbnail')
        );
    }
    
    // Short custom meta descriptions (less than 120 chars)
    $short_desc = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_meta_description' 
        AND pm.meta_value != '' 
        AND CHAR_LENGTH(pm.meta_value) < 120
    ");
    if ($short_desc > 0) {
        $issues[] = array(
            'type' => 'warning',
            'icon' => '⚠️',
            'text' => "Krátke vlastné Meta Description (<120 znakov)",
            'count' => $short_desc,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=short_desc')
        );
    }
    
    // Long custom meta titles (more than 60 chars)
    $long_title = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_meta_title' 
        AND pm.meta_value != '' 
        AND CHAR_LENGTH(pm.meta_value) > 60
    ");
    if ($long_title > 0) {
        $issues[] = array(
            'type' => 'warning',
            'icon' => '⚠️',
            'text' => "Dlhé vlastné Meta Title (>60 znakov)",
            'count' => $long_title,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=long_title')
        );
    }
    
    // Posts without focus keywords
    $without_keywords = $total_posts - $with_keywords;
    if ($without_keywords > 0) {
        $issues[] = array(
            'type' => 'info',
            'icon' => '💡',
            'text' => "Príspevky bez Focus Keywords",
            'count' => $without_keywords,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=no_keywords')
        );
    }
    
    // Noindex pages
    $noindex_count = $wpdb->get_var("
        SELECT COUNT(DISTINCT p.ID) FROM {$wpdb->posts} p
        INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
        WHERE p.post_status = 'publish' AND p.post_type IN ({$post_types_sql})
        AND pm.meta_key = '_wseo_noindex' AND pm.meta_value = '1'
    ");
    if ($noindex_count > 0) {
        $issues[] = array(
            'type' => 'info',
            'icon' => '🚫',
            'text' => "Stránky s Noindex (skryté z vyhľadávania)",
            'count' => $noindex_count,
            'link' => admin_url('admin.php?page=webstudio-seo&wseo_filter=noindex')
        );
    }
    ?>
    
    <div class="wseo-admin-card">
        <h2>📊 Prehľad</h2>
        
        <div class="wseo-stats-grid">
            <div class="wseo-stat-box">
                <div class="wseo-stat-number">
                    <?php echo wp_count_posts('page')->publish; ?>
                </div>
                <div class="wseo-stat-label">Stránok</div>
            </div>
            
            <div class="wseo-stat-box">
                <div class="wseo-stat-number">
                    <?php echo wp_count_posts('post')->publish; ?>
                </div>
                <div class="wseo-stat-label">Článkov</div>
            </div>
            
            <?php if (post_type_exists('product')): ?>
            <div class="wseo-stat-box">
                <div class="wseo-stat-number">
                    <?php echo wp_count_posts('product')->publish; ?>
                </div>
                <div class="wseo-stat-label">Produktov</div>
            </div>
            <?php endif; ?>
            
            <div class="wseo-stat-box">
                <div class="wseo-stat-number">
                    <?php echo $total_images; ?>
                </div>
                <div class="wseo-stat-label">Obrázkov</div>
            </div>
        </div>
    </div>
    
    <div class="wseo-admin-card">
        <h2>📈 SEO Prehľad obsahu</h2>
        <p class="description" style="margin-bottom: 20px;">Stav SEO optimalizácie vášho obsahu (vrátane automaticky generovaných)</p>
        
        <style>
        .wseo-progress-row {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 12px 0;
            border-bottom: 1px solid #f0f0f1;
        }
        .wseo-progress-row:last-child {
            border-bottom: none;
        }
        .wseo-progress-row .label {
            flex: 0 0 200px;
            font-size: 13px;
            font-weight: 500;
            color: #1d2327;
        }
        .wseo-progress-row .label small {
            color: #646970;
            font-weight: 400;
        }
        .wseo-progress-row .bar-wrap {
            flex: 1;
            height: 6px;
            background: #e2e4e7;
            border-radius: 3px;
            overflow: hidden;
        }
        .wseo-progress-row .bar {
            height: 100%;
            border-radius: 3px;
            transition: width 0.5s ease;
        }
        .wseo-progress-row .pct {
            flex: 0 0 50px;
            text-align: right;
            font-size: 14px;
            font-weight: 600;
            color: #1d2327;
        }
        </style>
        
        <?php
        function wseo_get_bar_color($pct) {
            if ($pct >= 80) return '#00a32a';
            if ($pct >= 50) return '#dba617';
            return '#d63638';
        }
        ?>
        
        <div class="wseo-seo-overview">
            <!-- Meta Title -->
            <div class="wseo-progress-row">
                <div class="label">Meta Title <small><?php echo $with_meta_title; ?>/<?php echo $total_posts; ?> (<?php echo $with_custom_meta_title; ?> vlastných)</small></div>
                <div class="bar-wrap">
                    <div class="bar" style="width: <?php echo $pct_title; ?>%; background: <?php echo wseo_get_bar_color($pct_title); ?>;"></div>
                </div>
                <div class="pct"><?php echo $pct_title; ?>%</div>
            </div>
            
            <!-- Meta Description -->
            <div class="wseo-progress-row">
                <div class="label">Meta Description <small><?php echo $with_meta_desc; ?>/<?php echo $total_posts; ?> (<?php echo $with_custom_meta_desc; ?> vlastných)</small></div>
                <div class="bar-wrap">
                    <div class="bar" style="width: <?php echo $pct_desc; ?>%; background: <?php echo wseo_get_bar_color($pct_desc); ?>;"></div>
                </div>
                <div class="pct"><?php echo $pct_desc; ?>%</div>
            </div>
            
            <!-- Focus Keywords -->
            <div class="wseo-progress-row">
                <div class="label">Focus Keywords <small><?php echo $with_keywords; ?>/<?php echo $total_posts; ?></small></div>
                <div class="bar-wrap">
                    <div class="bar" style="width: <?php echo max($pct_keywords, 3); ?>%; background: <?php echo wseo_get_bar_color($pct_keywords); ?>;"></div>
                </div>
                <div class="pct"><?php echo $pct_keywords; ?>%</div>
            </div>
            
            <!-- OG Image -->
            <div class="wseo-progress-row">
                <div class="label">Social Image (OG) <small><?php echo $with_any_image; ?>/<?php echo $total_posts; ?></small></div>
                <div class="bar-wrap">
                    <div class="bar" style="width: <?php echo $pct_image; ?>%; background: <?php echo wseo_get_bar_color($pct_image); ?>;"></div>
                </div>
                <div class="pct"><?php echo $pct_image; ?>%</div>
            </div>
            
            <!-- Alt Texts -->
            <div class="wseo-progress-row">
                <div class="label">Alt texty obrázkov <small><?php echo $images_with_alt; ?>/<?php echo $total_images; ?></small></div>
                <div class="bar-wrap">
                    <div class="bar" style="width: <?php echo $pct_alt; ?>%; background: <?php echo wseo_get_bar_color($pct_alt); ?>;"></div>
                </div>
                <div class="pct"><?php echo $pct_alt; ?>%</div>
            </div>
        </div>
        
        <p class="description" style="margin-top: 15px; font-size: 12px;">
            💡 <strong>Tip:</strong> Meta Title a Description sa automaticky generujú z názvu a obsahu príspevku, ak nie sú vlastné vyplnené.
        </p>
    </div>
    
    <?php if (!empty($issues)): ?>
    <div class="wseo-admin-card">
        <h2>⚠️ Potrebuje pozornosť</h2>
        <p class="description" style="margin-bottom: 15px;">Problémy ktoré by ste mali vyriešiť pre lepšie SEO</p>
        
        <div class="wseo-issues-list">
            <?php foreach ($issues as $issue): ?>
            <div class="wseo-issue-item wseo-issue-<?php echo $issue['type']; ?>">
                <span class="wseo-issue-icon"><?php echo $issue['icon']; ?></span>
                <span class="wseo-issue-text"><?php echo esc_html($issue['text']); ?></span>
                <span class="wseo-issue-count"><?php echo $issue['count']; ?></span>
                <?php if (!empty($issue['link'])): ?>
                <a href="<?php echo esc_url($issue['link']); ?>" class="wseo-issue-link">Zobraziť →</a>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="wseo-admin-card">
        <h2>📅 Posledná aktivita</h2>
        
        <?php
        // Last indexed URLs
        $indexing_log = get_option('wseo_indexing_log', array());
        $last_indexed = array_slice(array_reverse($indexing_log), 0, 3);
        
        // Today's indexed count
        $today = date('Y-m-d');
        $today_indexed = 0;
        foreach ($indexing_log as $entry) {
            if (isset($entry['time']) && strpos($entry['time'], $today) === 0) {
                $today_indexed++;
            }
        }
        
        // Last published posts
        $last_posts = get_posts(array(
            'post_type' => array('post', 'page', 'product'),
            'post_status' => 'publish',
            'numberposts' => 3,
            'orderby' => 'date',
            'order' => 'DESC'
        ));
        
        // Images with auto alt text today
        $auto_alt_today = $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(*) FROM {$wpdb->postmeta} 
            WHERE meta_key = '_wp_attachment_image_alt' 
            AND meta_value != ''
            AND post_id IN (
                SELECT ID FROM {$wpdb->posts} 
                WHERE post_type = 'attachment' 
                AND post_date >= %s
            )
        ", $today . ' 00:00:00'));
        ?>
        
        <div class="wseo-activity-list">
            <!-- Instant Indexing Status -->
            <div class="wseo-activity-item">
                <span class="wseo-activity-icon">🚀</span>
                <span class="wseo-activity-text">
                    <strong>Dnes indexované:</strong> <?php echo $today_indexed; ?> URL
                    <?php if ($today_indexed > 0 && !empty($last_indexed)): ?>
                        <?php 
                        $last = $last_indexed[0];
                        $google_ok = isset($last['results']['google']['success']) && $last['results']['google']['success'];
                        $bing_ok = isset($last['results']['bing']['success']) && $last['results']['bing']['success'];
                        $yandex_ok = isset($last['results']['yandex']['success']) && $last['results']['yandex']['success'];
                        ?>
                        <span class="wseo-activity-status">
                            (Google <?php echo $google_ok ? '✅' : '—'; ?>, 
                            Bing <?php echo $bing_ok ? '✅' : '—'; ?>, 
                            Yandex <?php echo $yandex_ok ? '✅' : '—'; ?>)
                        </span>
                    <?php endif; ?>
                </span>
                <?php if (get_option('wseo_instant_index_enabled', '0') !== '1'): ?>
                    <span class="wseo-activity-badge wseo-badge-warning">Vypnuté</span>
                <?php endif; ?>
            </div>
            
            <!-- Last Published -->
            <?php if (!empty($last_posts)): ?>
            <div class="wseo-activity-item">
                <span class="wseo-activity-icon">📝</span>
                <span class="wseo-activity-text">
                    <strong>Posledný príspevok:</strong> 
                    <a href="<?php echo get_edit_post_link($last_posts[0]->ID); ?>">
                        <?php echo esc_html(wp_trim_words($last_posts[0]->post_title, 8)); ?>
                    </a>
                    <span class="wseo-activity-time">
                        — <?php echo human_time_diff(strtotime($last_posts[0]->post_date), current_time('timestamp')); ?> dozadu
                    </span>
                </span>
            </div>
            <?php endif; ?>
            
            <!-- Auto Alt Text -->
            <div class="wseo-activity-item">
                <span class="wseo-activity-icon">🖼️</span>
                <span class="wseo-activity-text">
                    <strong>Auto Alt text:</strong> <?php echo $auto_alt_today; ?> obrázkov dnes
                </span>
                <?php if (get_option('wseo_auto_alt', '1') !== '1'): ?>
                    <span class="wseo-activity-badge wseo-badge-warning">Vypnuté</span>
                <?php endif; ?>
            </div>
            
            <!-- SEO Score -->
            <?php 
            $seo_score = round(($pct_title + $pct_desc + $pct_image + $pct_alt) / 4);
            $score_class = $seo_score >= 80 ? 'good' : ($seo_score >= 50 ? 'okay' : 'bad');
            ?>
            <div class="wseo-activity-item">
                <span class="wseo-activity-icon">📊</span>
                <span class="wseo-activity-text">
                    <strong>Celkové SEO skóre:</strong> 
                    <span class="wseo-score wseo-score-<?php echo $score_class; ?>"><?php echo $seo_score; ?>%</span>
                </span>
            </div>
            
            <!-- Sitemap Info -->
            <?php
            $sitemap_posts = $wpdb->get_var("
                SELECT COUNT(*) FROM {$wpdb->posts} 
                WHERE post_status = 'publish' 
                AND post_type IN ('post', 'page', 'product')
            ");
            ?>
            <div class="wseo-activity-item">
                <span class="wseo-activity-icon">🗺️</span>
                <span class="wseo-activity-text">
                    <strong>Sitemap:</strong> <?php echo $sitemap_posts; ?> URL v sitemap.xml
                </span>
                <a href="<?php echo home_url('/sitemap.xml'); ?>" target="_blank" class="wseo-activity-link">Zobraziť →</a>
            </div>
        </div>
    </div>
    
    <?php
    // Detect other SEO plugins
    $detected_plugins = array();
    $dismissed_plugins = get_option('wseo_dismissed_migrations', array());
    
    // Yoast SEO
    $yoast_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_yoast_wpseo_title' AND meta_value != ''");
    if (($yoast_count > 0 || defined('WPSEO_VERSION')) && !in_array('yoast', $dismissed_plugins)) {
        $detected_plugins['yoast'] = array(
            'name' => 'Yoast SEO',
            'icon' => '🟢',
            'count' => $yoast_count
        );
    }
    
    // Rank Math
    $rankmath_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = 'rank_math_title' AND meta_value != ''");
    if (($rankmath_count > 0 || defined('RANK_MATH_VERSION')) && !in_array('rankmath', $dismissed_plugins)) {
        $detected_plugins['rankmath'] = array(
            'name' => 'Rank Math',
            'icon' => '🔴',
            'count' => $rankmath_count
        );
    }
    
    // All in One SEO
    $aioseo_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_aioseo_title' AND meta_value != ''");
    if (($aioseo_count > 0 || defined('AIOSEO_VERSION')) && !in_array('aioseo', $dismissed_plugins)) {
        $detected_plugins['aioseo'] = array(
            'name' => 'All in One SEO',
            'icon' => '🔵',
            'count' => $aioseo_count
        );
    }
    
    // SEOPress
    $seopress_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_seopress_titles_title' AND meta_value != ''");
    if (($seopress_count > 0 || defined('SEOPRESS_VERSION')) && !in_array('seopress', $dismissed_plugins)) {
        $detected_plugins['seopress'] = array(
            'name' => 'SEOPress',
            'icon' => '🟣',
            'count' => $seopress_count
        );
    }
    
    // The SEO Framework
    $tsf_count = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = '_genesis_title' AND meta_value != ''");
    if (($tsf_count > 0 || defined('THE_SEO_FRAMEWORK_VERSION')) && !in_array('theseoframework', $dismissed_plugins)) {
        $detected_plugins['theseoframework'] = array(
            'name' => 'The SEO Framework',
            'icon' => '⚫',
            'count' => $tsf_count
        );
    }
    
    if (!empty($detected_plugins)):
    ?>
    <div class="wseo-admin-card">
        <h2>🔄 Migrácia z iných SEO pluginov</h2>
        <p class="description" style="margin-bottom: 15px;">
            Detekovali sme SEO dáta z iných pluginov. Môžete ich importovať do Webstudio SEO Pro.
        </p>
        
        <div id="wseo-migration-status" style="display: none; margin-bottom: 15px; padding: 15px; background: #f0f0f1; border-radius: 4px;">
            <span class="wseo-migration-message"></span>
            <div class="wseo-migration-progress" style="margin-top: 10px; background: #ddd; height: 20px; border-radius: 3px; overflow: hidden;">
                <div class="wseo-migration-progress-bar" style="width: 0%; height: 100%; background: #2271b1; transition: width 0.3s;"></div>
            </div>
        </div>
        
        <table class="widefat striped" style="margin-bottom: 15px;">
            <thead>
                <tr>
                    <th>Plugin</th>
                    <th>Nájdené záznamy</th>
                    <th>Akcia</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($detected_plugins as $key => $plugin): ?>
                <tr class="wseo-migration-row" data-source="<?php echo esc_attr($key); ?>">
                    <td>
                        <strong><?php echo $plugin['icon']; ?> <?php echo esc_html($plugin['name']); ?></strong>
                    </td>
                    <td><?php echo intval($plugin['count']); ?> príspevkov</td>
                    <td>
                        <button type="button" class="button button-primary wseo-migrate-btn" data-source="<?php echo esc_attr($key); ?>">
                            Importovať
                        </button>
                        <button type="button" class="button wseo-dismiss-btn" data-source="<?php echo esc_attr($key); ?>">
                            Zrušiť
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <p class="description">
            ⚠️ <strong>Upozornenie:</strong> Import prepíše existujúce SEO dáta v Webstudio SEO Pro. 
            Odporúčame najprv zálohovať databázu.
        </p>
    </div>
    
    <script>
    jQuery(document).ready(function($) {
        $('.wseo-migrate-btn').on('click', function() {
            var btn = $(this);
            var source = btn.data('source');
            var $status = $('#wseo-migration-status');
            var $message = $status.find('.wseo-migration-message');
            var $progress = $status.find('.wseo-migration-progress-bar');
            
            if (!confirm('Naozaj chcete importovať SEO dáta? Existujúce dáta budú prepísané.')) {
                return;
            }
            
            btn.prop('disabled', true).text('Importujem...');
            $status.show();
            $message.text('Spúšťam import...');
            $progress.css('width', '10%');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'wseo_migrate_seo',
                    source: source,
                    nonce: '<?php echo wp_create_nonce('wseo_migrate'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        $progress.css('width', '100%');
                        $message.html('✅ <strong>Import dokončený!</strong> Importovaných: ' + response.data.imported + ' príspevkov.');
                        btn.text('Dokončené').addClass('button-primary');
                    } else {
                        $message.html('❌ Chyba: ' + response.data);
                        btn.prop('disabled', false).text('Importovať');
                    }
                },
                error: function() {
                    $message.html('❌ Chyba pripojenia.');
                    btn.prop('disabled', false).text('Importovať');
                }
            });
        });
        
        // Dismiss/Cancel button
        $('.wseo-dismiss-btn').on('click', function() {
            var btn = $(this);
            var source = btn.data('source');
            var row = btn.closest('.wseo-migration-row');
            
            row.fadeOut(300, function() {
                $(this).remove();
                
                // If no more rows, hide the whole section
                if ($('.wseo-migration-row').length === 0) {
                    row.closest('.wseo-admin-card').fadeOut(300);
                }
            });
            
            // Save dismissed state
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'wseo_dismiss_migration',
                    source: source,
                    nonce: '<?php echo wp_create_nonce('wseo_dismiss_migration'); ?>'
                }
            });
        });
    });
    </script>
    <?php endif; ?>
    
    <script>
    jQuery(document).ready(function($) {
        // v2.10.10: Generate all focus keywords with batch processing
        var totalGenerated = 0;
        var totalToProcess = 0;
        var processedCount = 0;
        
        function generateKeywordsBatch($btn) {
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                timeout: 120000, // 2 minute timeout
                data: {
                    action: 'wseo_generate_all_keywords',
                    nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        totalGenerated += response.data.generated;
                        processedCount += response.data.processed || response.data.generated;
                        
                        // Update progress bar
                        var pct = totalToProcess > 0 ? Math.round((processedCount / totalToProcess) * 100) : 0;
                        $('#wseo-keywords-progress-bar').css('width', pct + '%').text(pct + '%');
                        $('#wseo-keywords-progress-text').text('Generujem keywords...');
                        $('#wseo-keywords-progress-count').text(processedCount + '/' + totalToProcess);
                        
                        // If there are more, continue
                        if (response.data.remaining === 'more') {
                            generateKeywordsBatch($btn);
                        } else {
                            $('#wseo-keywords-progress-bar').css('width', '100%').text('100%');
                            $('#wseo-keywords-progress-text').text('✓ Hotovo! Vygenerované: ' + totalGenerated + ' keywords');
                            $btn.prop('disabled', false).text('✨ Vygenerovať Focus Keywords');
                            setTimeout(function() { location.reload(); }, 2000);
                        }
                    } else {
                        $('#wseo-keywords-progress-text').text('❌ Chyba: ' + response.data);
                        $btn.prop('disabled', false).text('✨ Vygenerovať Focus Keywords');
                    }
                },
                error: function(xhr, status, error) {
                    $('#wseo-keywords-progress-text').text('❌ Chyba: ' + error);
                    $btn.prop('disabled', false).text('✨ Vygenerovať Focus Keywords');
                }
            });
        }
        
        $(document).on('click', '.wseo-generate-all-keywords', function(e) {
            e.preventDefault();
            
            var $btn = $(this);
            
            if (!confirm('Vygenerovať Focus Keywords pre všetky príspevky bez keywords?\n\nToto automaticky extrahuje kľúčové slová z titulkov.')) {
                return;
            }
            
            totalGenerated = 0;
            processedCount = 0;
            totalToProcess = <?php echo max(1, $total_posts - $with_keywords); ?>;
            
            $btn.prop('disabled', true).text('Generujem...');
            $('#wseo-keywords-progress').show();
            $('#wseo-keywords-progress-bar').css('width', '0%').text('0%');
            $('#wseo-keywords-progress-text').text('Spúšťam...');
            $('#wseo-keywords-progress-count').text('0/' + totalToProcess);
            
            generateKeywordsBatch($btn);
        });
        
        // Clear all keywords
        $(document).on('click', '.wseo-clear-all-keywords', function(e) {
            e.preventDefault();
            
            var $btn = $(this);
            
            if (!confirm('⚠️ POZOR!\n\nNaozaj vymazať VŠETKY Focus Keywords zo všetkých príspevkov?\n\nTáto akcia sa nedá vrátiť späť!')) {
                return;
            }
            
            $btn.prop('disabled', true).text('Mažem...');
            $('#wseo-keywords-status').html('<span style="color: #666;">Mažem...</span>');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'wseo_clear_all_keywords',
                    nonce: '<?php echo wp_create_nonce('wseo_bulk_fill'); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        $('#wseo-keywords-status').html('<span style="color: #28a745;">✅ Vymazané ' + response.data.deleted + ' keywords!</span>');
                        setTimeout(function() { location.reload(); }, 1500);
                    } else {
                        $('#wseo-keywords-status').html('<span style="color: #dc3545;">❌ ' + response.data + '</span>');
                        $btn.prop('disabled', false).text('🗑️ Vymazať Focus Keywords');
                    }
                },
                error: function() {
                    $('#wseo-keywords-status').html('<span style="color: #dc3545;">❌ Chyba pripojenia</span>');
                    $btn.prop('disabled', false).text('🗑️ Vymazať Focus Keywords');
                }
            });
        });
    });
    </script>
    
    <!-- Focus Keywords Info -->
    <div class="wseo-admin-card">
        <h2>🎯 Focus Keywords</h2>
        <p class="description">
            Focus Keywords slúžia na <strong>SEO analýzu</strong> - kontrolu či je keyword v titulku, URL, obsahu atď.
            <br>Stav: <strong><?php echo $with_keywords; ?>/<?php echo $total_posts; ?></strong> príspevkov má manuálne Focus Keyword (<?php echo $pct_keywords; ?>%)
        </p>
        
        <div style="margin-top: 15px;">
            <button type="button" 
                    class="button button-primary wseo-generate-all-keywords">
                ✨ Vygenerovať Focus Keywords
            </button>
            <?php if ($with_keywords > 0): ?>
            <button type="button" 
                    class="button wseo-clear-all-keywords" style="margin-left: 10px;">
                🗑️ Vymazať Focus Keywords
            </button>
            <?php endif; ?>
        </div>
        
        <!-- Progress bar -->
        <div id="wseo-keywords-progress" style="display: none; margin-top: 15px; background: #f9f9f9; padding: 15px; border-radius: 8px;">
            <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                <span id="wseo-keywords-progress-text" style="font-weight: 500;">Spracovávam...</span>
                <span id="wseo-keywords-progress-count" style="color: #666;">0/0</span>
            </div>
            <div style="background: #e0e0e0; height: 20px; border-radius: 10px; overflow: hidden;">
                <div id="wseo-keywords-progress-bar" style="background: linear-gradient(90deg, #667eea, #764ba2); height: 100%; width: 0%; transition: width 0.3s; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 12px;"></div>
            </div>
        </div>
        
        <div style="margin-top: 15px; padding: 15px; background: #fff3e0; border-left: 4px solid #ff9800; border-radius: 4px;">
            <strong>💡 TIP: Menej je viac!</strong>
            <p style="margin: 10px 0 0 0; line-height: 1.8;">
                Zadávajte len <strong>1 presnú long tail frázu</strong> (napr. "servis pre WordPress"), nie zoznam slov.<br>
                Nespamujte! Google odmeňuje kvalitu, nie kvantitu.
            </p>
        </div>
        
        <div style="margin-top: 15px; padding: 15px; background: #e8f5e9; border-left: 4px solid #4caf50; border-radius: 4px;">
            <strong>Ako fungujú Focus Keywords</strong>
            <ul style="margin: 10px 0 0 20px; line-height: 1.8;">
                <li><strong>Automatická extrakcia:</strong> Ak nie je manuálne zadaný, plugin automaticky extrahuje kľúčové slová z titulku</li>
                <li><strong>Odstránenie stop slov:</strong> Automaticky sa odstránia bežné slová (a, je, pre, na...)</li>
                <li><strong>Kategórie produktov:</strong> Pre WooCommerce produkty sa pridá aj kategória</li>
                <li><strong>Manuálne = lepšie:</strong> Manuálne zadané keyword dostane plný počet bodov (10), auto-extrahované 8 bodov</li>
            </ul>
        </div>
        
        <div style="margin-top: 15px; padding: 15px; background: #e3f2fd; border-left: 4px solid #2196f3; border-radius: 4px;">
            <strong>✅ Dobrý príklad:</strong> "servis pre WordPress"<br>
            <strong>❌ Zlý príklad:</strong> "servis, WordPress, web, stránky, údržba, opravy"
        </div>
    </div>
    
    <div class="wseo-admin-card">
        <h2>📁 Automatické súbory</h2>
        <p>Plugin automaticky generuje tieto súbory:</p>
        
        <a href="<?php echo home_url('/robots.txt'); ?>" target="_blank" class="wseo-file-link">
            <span class="dashicons dashicons-media-text"></span>
            robots.txt
        </a>
        
        <a href="<?php echo home_url('/sitemap.xml'); ?>" target="_blank" class="wseo-file-link">
            <span class="dashicons dashicons-networking"></span>
            sitemap.xml
        </a>
        
        <a href="<?php echo home_url('/llms.txt'); ?>" target="_blank" class="wseo-file-link">
            <span class="dashicons dashicons-welcome-learn-more"></span>
            llms.txt
        </a>
    </div>
    
    <div class="wseo-admin-card">
        <h2>🚀 Rýchle odkazy</h2>
        
        <p>
            <a href="<?php echo admin_url('admin.php?page=webstudio-seo-global'); ?>" class="button button-primary">
                Globálne nastavenia
            </a>
            
            <a href="<?php echo admin_url('admin.php?page=webstudio-seo-files'); ?>" class="button">
                Indexácia
            </a>
        </p>
    </div>
    
    <div class="wseo-admin-card">
        <h2>ℹ️ O plugine</h2>
        <p>
            <strong>Verzia:</strong> <?php echo WSEO_VERSION; ?><br>
            <strong>Autor:</strong> <a href="https://webstudio.ltd/" target="_blank">WEBSTUDIO.ltd</a>
        </p>
    </div>
</div>
