# 🎨 UI Mockup - Ako to vyzerá v praxi

## 📸 Screenshot 1: Globálne nastavenia

```
┌─────────────────────────────────────────────────────────────────┐
│  SEO PRO → Globálne nastavenia                                  │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  Schema.org nastavenia                                          │
│  ━━━━━━━━━━━━━━━━━━━                                           │
│                                                                 │
│  Logo URL                                                       │
│  [https://webstudio.ltd/logo.png                          ]    │
│  Odporúčaná veľkosť: min. 112×112 px                          │
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ 📷 Metadáta loga (Search Console požiadavky)           │   │
│  │ Google Search Console vyžaduje tieto 3 polia           │   │
│  ├─────────────────────────────────────────────────────────┤   │
│  │                                                         │   │
│  │ Autor / Zdroj loga *                                    │   │
│  │ [Webstudio.ltd                                    ]     │   │
│  │ creditText - Uvádza, kto vytvoril alebo vlastní logo   │   │
│  │                                                         │   │
│  │ URL licencie *                                          │   │
│  │ [https://creativecommons.org/licenses/by/4.0/    ]     │   │
│  │ license - URL Creative Commons alebo vlastnej licencie │   │
│  │                                                         │   │
│  │ Stránka s licenciou *                                   │   │
│  │ [https://webstudio.ltd/image-licenses/           ]     │   │
│  │ acquireLicensePage - URL stránky s licenčnými info     │   │
│  │                                                         │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  [Uložiť zmeny]                                                 │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

---

## 📸 Screenshot 2: Meta-box pri príspevku (NOVÉ - s predvyplnením!)

```
┌─────────────────────────────────────────────────────────────────┐
│  Upraviť príspevok: "Nový článok o SEO"                         │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  [Všeobecné] [Sociálne] [SEO Audit] [Odkazy] [FAQ] [Rozšírené]│
│                                                 └──────────┘    │
│                                                  ↑ aktívny tab  │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ 🤖 AI Content Marking (Google 2026)                     │   │
│  │ ☐ AI-generovaný obsah                                   │   │
│  │ ☐ AI-generovaný obrázok                                 │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  ┌─────────────────────────────────────────────────────────┐   │
│  │ 📷 Metadáta obrázka (povinné pre Search Console)        │   │
│  │ 💡 Tip: Polia sú automaticky predvyplnené z globálnych  │   │
│  │    nastavení. Môžete ich ponechať alebo zmeniť.         │   │
│  ├─────────────────────────────────────────────────────────┤   │
│  │                                                          │   │
│  │ Autor / Zdroj obrázka *                                  │   │
│  │ [Webstudio.ltd                                    ] ✓    │   │
│  │ creditText - Povinné pole pre Search Console             │   │
│  │ ✓ Predvyplnené z globálnych nastavení                    │   │
│  │                                                          │   │
│  │ URL alebo typ licencie *                                 │   │
│  │ [https://creativecommons.org/licenses/by/4.0/    ] ✓    │   │
│  │ license - Povinné pole. URL Creative Commons...          │   │
│  │ ✓ Predvyplnené z globálnych nastavení                    │   │
│  │                                                          │   │
│  │ Stránka s licenčnými informáciami *                      │   │
│  │ [https://webstudio.ltd/image-licenses/           ] ✓    │   │
│  │ acquireLicensePage - Povinné pole. URL stránky...        │   │
│  │ ✓ Predvyplnené z globálnych nastavení                    │   │
│  │                                                          │   │
│  └─────────────────────────────────────────────────────────┘   │
│                                                                 │
│  [Aktualizovať]  [Náhľad]                                       │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

---

## 🔄 Porovnanie: Pred vs. Po

### PRED (v2.4.4 - bez predvyplnenia)

```
Otvorím príspevok:

┌────────────────────────────────────┐
│ Autor / Zdroj obrázka *            │
│ [                            ] ❌   │  ← PRÁZDNE!
│                                    │
│ URL alebo typ licencie *           │
│ [                            ] ❌   │  ← PRÁZDNE!
│                                    │
│ Stránka s licenčnými info *        │
│ [                            ] ❌   │  ← PRÁZDNE!
└────────────────────────────────────┘

Musím VYPLNIŤ všetky 3 polia! 😤
Čas: 2-3 minúty
```

### PO (v2.4.4 FINAL - s predvyplnením)

```
Otvorím príspevok:

┌────────────────────────────────────┐
│ Autor / Zdroj obrázka *            │
│ [Webstudio.ltd             ] ✅     │  ← UŽ VYPLNENÉ!
│ ✓ Predvyplnené z globálnych        │
│                                    │
│ URL alebo typ licencie *           │
│ [https://creativecommons...] ✅     │  ← UŽ VYPLNENÉ!
│ ✓ Predvyplnené z globálnych        │
│                                    │
│ Stránka s licenčnými info *        │
│ [https://webstudio.ltd/... ] ✅     │  ← UŽ VYPLNENÉ!
│ ✓ Predvyplnené z globálnych        │
└────────────────────────────────────┘

Nemusím nič vyplňovať! 😊
Čas: 0 sekúnd
Môžem ZMENIŤ ak chcem
```

---

## 💚 Zelené indikátory

Zelená farba `#059669` sa používa pre:
- ✓ Zaškrtnutie pri každom poli
- Text "Predvyplnené z globálnych nastavení"

```css
color: #059669;  /* Tmavá zelená */
```

Prečo zelená?
- ✅ Pozitívna farba (= všetko OK)
- ✅ Kontrastná (dobre viditeľná)
- ✅ WordPress friendly (ladí s admin témou)

---

## 📱 Responzívny dizajn

### Desktop (širšia obrazovka)

```
┌──────────────────────────────────────────────────┐
│ Autor / Zdroj obrázka *                          │
│ [Webstudio.ltd                             ] ✓   │
│ ✓ Predvyplnené z globálnych nastavení            │
└──────────────────────────────────────────────────┘
```

### Tablet/Mobile (užšia obrazovka)

```
┌─────────────────────────────────┐
│ Autor / Zdroj obrázka *         │
│ [Webstudio.ltd            ] ✓   │
│ ✓ Predvyplnené z globálnych     │
└─────────────────────────────────┘
```

Funguje na všetkých zariadeniach! 📱💻🖥️

---

## 🎨 Farebné schémy v UI

### Hlavička sekcie

```
┌─────────────────────────────────────────────────┐
│ 📷 Metadáta obrázka (povinné pre Search Console)│  ← Červená: #d63638
│ 💡 Tip: Polia sú automaticky predvyplnené...    │  ← Šedá: #666
└─────────────────────────────────────────────────┘
```

### Polia

```
[hodnota                                      ] ✓   ← Zelená: #059669
creditText - Povinné pole...                       ← Čierna: #333
✓ Predvyplnené z globálnych nastavení              ← Zelená: #059669
```

### Legenda farieb

| Farba | Hex | Použitie |
|-------|-----|----------|
| 🟥 Červená | #d63638 | Hlavička sekcie, povinné * |
| 🟩 Zelená | #059669 | ✓ Indikátory, potvrdenia |
| ⬛ Čierna | #333 | Štandardný text |
| 🟦 Modrá | #0073aa | Odkazy, tlačidlá |
| ⬜ Šedá | #666 | Pomocný text, tipy |

---

## 👁️ Vizuálna hierarchia

```
Priorita 1 (najdôležitejšie):
━━━━━━━━━━━━━━━━━━━━━━━━
📷 Metadáta obrázka         ← veľký nadpis, červená


Priorita 2 (dôležité):
━━━━━━━━━━━━━━━━━━━
💡 Tip: Polia sú...          ← zvýraznený tip, šedá


Priorita 3 (štandardné):
━━━━━━━━━━━━━━━━━━
Autor / Zdroj obrázka *     ← label pola, čierna
[hodnota                ]   ← input pole


Priorita 4 (pomocné):
━━━━━━━━━━━━━━━━
creditText - Povinné...     ← popis poľa, šedá
✓ Predvyplnené z...         ← status, zelená
```

---

## 🖱️ Interakcia používateľa

### Scenár 1: Používateľ je spokojný s predvyplenými hodnotami

```
1. Otvorí príspevok
   └─→ Vidí predvyplnené polia ✓
   
2. Skontroluje hodnoty
   └─→ "OK, toto sedí"
   
3. Klikne na [Aktualizovať]
   └─→ Hotovo!

Čas: 5 sekúnd ⏱️
```

### Scenár 2: Používateľ chce zmeniť hodnotu pre konkrétny obrázok

```
1. Otvorí príspevok
   └─→ Vidí predvyplnené polia ✓
   
2. Klikne do poľa "Autor / Zdroj obrázka"
   └─→ Označí text a prepíše: "John Doe via Unsplash"
   
3. Ostatné polia nechá
   └─→ Licencia a stránka zostanú predvyplnené
   
4. Klikne na [Aktualizovať]
   └─→ Hotovo!

Čas: 30 sekúnd ⏱️
```

---

## 📊 Vizuálne štatistiky úspory času

```
Čas potrebný na vyplnenie metadát:

PRED:  ████████████████████ 200 min (100 príspevkov)
       2 min/príspevok × 100

PO:    ██ 3 min (globálne nastavenie)
       0 min/príspevok × 100

ÚSPORA: ▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓ 197 min = 3.3 hodiny! 🎉
```

---

## 🎭 Emoji používané v UI

| Emoji | Význam | Kde |
|-------|--------|-----|
| 📷 | Fotografia | Hlavička sekcie |
| 💡 | Tip | Informačná hláška |
| ✓ | Zaškrtnutie | Indikátor predvyplnenia |
| * | Povinné | Pri názvoch polí |
| 🤖 | AI | Sekcia AI Content |

---

## 🎨 Finálny vzhľad - ASCII Art

```
┌───────────────────────────────────────────────────────┐
│                    WEBSTUDIO SEO PRO                  │
│                       v2.4.4 FINAL                    │
├───────────────────────────────────────────────────────┤
│                                                       │
│  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓  │
│  ┃ 📷 Metadáta obrázka (Search Console)         ┃  │
│  ┃ 💡 Polia predvyplnené z globálnych nastavení ┃  │
│  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛  │
│                                                       │
│  Autor: [Webstudio.ltd                      ] ✓      │
│         ✓ Predvyplnené z globálnych                  │
│                                                       │
│  Licencia: [https://creativecommons.org/... ] ✓      │
│            ✓ Predvyplnené z globálnych               │
│                                                       │
│  Stránka: [https://webstudio.ltd/licenses/ ] ✓      │
│           ✓ Predvyplnené z globálnych                │
│                                                       │
│  [  Aktualizovať  ]  [  Náhľad  ]                    │
│                                                       │
└───────────────────────────────────────────────────────┘

        ✨ Šetrí váš čas! Funguje automaticky! ✨
```

---

**Poznámka:** Toto je textová reprezentácia. Reálny vzhľad v WordPress adminu používa WordPress admin štýly, Dashicons ikony a responzívny grid layout.
