# 🇸🇰 Rýchla príručka - Oprava Search Console chýb (v2.4.4 FINAL)

## 🎯 Čo tento update rieši?

Google Search Console hlásil 3 chyby v štruktúrovaných dátach pre obrázky:

❌ Chýbajúce pole **acquireLicensePage**  
❌ Chýbajúce pole **creditText**  
❌ Chýbajúce pole **license**

✅ **Všetky 3 chyby sú teraz vyriešené!**

## ⭐ NOVÁ FUNKCIA v2.4.4

**Automatické predvyplnenie polí!**

Keď nastavíte metadáta v globálnych nastaveniach, všetky nové aj existujúce príspevky/stránky budú mať tieto hodnoty **automaticky predvyplnené**. Nemusíte už nič vypisovať manuálne! 🎉

---

## ⚡ Rýchle kroky (3 minúty!)

### 1️⃣ Nahrajte aktualizovaný plugin

1. Stiahnite si `webstudio-seo-pro-2_4_4-FINAL.zip`
2. WordPress Admin → **Pluginy → Pridať nový → Nahrať plugin**
3. Vyberte ZIP súbor a aktivujte

### 2️⃣ Nastavte globálne údaje (jednorazovo!)

1. Choďte do **SEO PRO → Globálne nastavenia**
2. Sekcia **"Schema.org"** → nájdite **"Logo URL"**
3. Pod logom nájdete **žltú sekciu**:
   
   ```
   📷 Metadáta loga (Search Console požiadavky)
   ```

4. Vyplňte 3 polia:

   | Pole | Príklad hodnoty |
   |------|----------------|
   | **Autor / Zdroj loga** | Webstudio.ltd |
   | **URL licencie** | https://creativecommons.org/licenses/by/4.0/ |
   | **Stránka s licenciou** | https://webstudio.ltd/image-licenses/ |

5. Kliknite **"Uložiť zmeny"**

✅ **Hotovo!** Tieto hodnoty sa teraz automaticky použijú pre všetky príspevky!

### 3️⃣ Vytvorte stránku s licenciami

1. **Stránky → Pridať novú**
2. Názov: **"Licencie obrázkov"**
3. URL slug: **`image-licenses`**
4. Obsah (príklad):

```
Licencie obrázkov
=================

Logo firmy
----------
• Autor: Webstudio.ltd
• Licencia: Creative Commons BY 4.0
• Kontakt: info@webstudio.ltd

Obrázky v článkoch
------------------
Ak nie je uvedené inak, obrázky sú:
• Vlastné fotografie (© Webstudio.ltd)
• Stock fotografie z Unsplash (CC0 Public Domain)
• AI-generované obrázky (CC0)

Kontakt: legal@webstudio.ltd
```

5. **Publikovať**

### 4️⃣ Skontrolujte príspevky (voliteľné)

Otvorte ľubovoľný príspevok → Tab **"Rozšírené"** → Sekcia **"Metadáta obrázka"**

**Uvidíte:**
```
📷 Metadáta obrázka (povinné pre Search Console)
💡 Tip: Polia sú automaticky predvyplnené z globálnych nastavení.

✓ Autor / Zdroj obrázka: Webstudio.ltd
✓ URL licencie: https://creativecommons.org/licenses/by/4.0/
✓ Stránka s licenciou: https://webstudio.ltd/image-licenses/
```

**Zelené zaškrtnutie (✓)** znamená, že hodnoty sú predvyplnené!

Ak chcete zmeniť hodnoty pre konkrétny obrázok, jednoducho prepíšte predvyplnené hodnoty.

---

## 🔍 Overenie

### Test 1: Zdrojový kód

1. Otvorte ľubovoľný príspevok
2. Zobrazte zdrojový kód (Ctrl+U / Cmd+U)
3. Hľadajte `ImageObject`
4. Mali by ste vidieť:

```json
{
  "@type": "ImageObject",
  "url": "...",
  "license": "https://creativecommons.org/licenses/by/4.0/",
  "acquireLicensePage": "https://webstudio.ltd/image-licenses/",
  "creditText": "Webstudio.ltd"
}
```

### Test 2: Google Rich Results

1. Otvorte: https://search.google.com/test/rich-results
2. Zadajte URL príspevku
3. Stlačte **"Testovať URL"**
4. **Kontrola**: Mali by ste vidieť ✅ **bez chýb** pre ImageObject

---

## ⭐ Výhody automatického predvyplnenia

### Predtým (bez predvyplnenia):
❌ Museli ste vyplniť 3 polia pri **každom** príspevku  
❌ Zaberie to 2-3 minúty na príspevok  
❌ Pri 100 príspevkoch = **5+ hodín** práce  
❌ Riziko preklepy a nekonzistentnosti

### Teraz (s predvyplnením):
✅ Vyplníte raz v globálnych nastaveniach  
✅ Všetky príspevky majú automaticky správne hodnoty  
✅ Pri 100 príspevkoch = **3 minúty** nastavenia  
✅ Konzistentné hodnoty na celom webe  
✅ Môžete zmeniť individuálne ak treba

---

## 💡 Ako to funguje?

```
GLOBÁLNE NASTAVENIA (jednorazovo)
         ↓
   [nastavíte 3 polia]
         ↓
┌─────────────────────────────┐
│  Automaticky sa použijú pre: │
├─────────────────────────────┤
│  ✓ Nové príspevky           │
│  ✓ Existujúce príspevky     │
│  ✓ Stránky                  │
│  ✓ WooCommerce produkty     │
│  ✓ Vlastné post types       │
└─────────────────────────────┘
         ↓
   Pri úprave príspevku:
   Polia sú predvyplnené ✓
         ↓
   [môžete zmeniť ak chcete]
```

---

## 🎯 Príklady použitia

### Scenár 1: Rovnaké hodnoty všade (najjednoduchšie)

**Globálne nastavenia:**
```
Autor: Moja firma s.r.o.
Licencia: https://creativecommons.org/licenses/by/4.0/
Stránka: https://mojafirma.sk/licencie/
```

**Výsledok:** Všetky príspevky majú tieto hodnoty → **0 minút** práce na príspevok!

### Scenár 2: Rôzne hodnoty pre niektoré príspevky

**Globálne nastavenia:** (ako Scenár 1)

**Pri konkrétnom príspevku s fotkou od Unsplash:**
```
Autor: John Doe via Unsplash  [prepíšete predvyplnenú hodnotu]
Licencia: https://unsplash.com/license  [prepíšete]
Stránka: https://mojafirma.sk/licencie/  [necháte]
```

**Výsledok:** Väčšina príspevkov má predvolené hodnoty, len výnimky zmeníte!

---

## 📊 Štatistika času

| Akcia | Bez predvyplnenia | S predvyplnením |
|-------|-------------------|-----------------|
| Globálne nastavenie | - | **3 min** |
| 1 príspevok (rovnaké hodnoty) | 2 min | **0 min** ✅ |
| 1 príspevok (zmena hodnôt) | 2 min | **1 min** |
| 10 príspevkov | 20 min | **0-10 min** |
| 100 príspevkov | 200 min (3.3 hod) | **0-100 min** |

**Úspora času pri 100 príspevkoch: až 3 hodiny!** ⏱️

---

## ❓ Často kladené otázky

**Q: Čo sa stane s už existujúcimi príspevkami?**  
A: Pri otvorení existujúceho príspevku sa automaticky použijú hodnoty z globálnych nastavení. Nemusíte robiť nič!

**Q: Ak zmením globálne nastavenia, zmení sa to v existujúcich príspevkoch?**  
A: Nie. Zmena sa prejaví len pri **novom otvorení** príspevku v editore. Už uložené hodnoty zostanú.

**Q: Môžem mať rôzne hodnoty pre rôzne príspevky?**  
A: Áno! Predvyplnené hodnoty môžete kedykoľvek prepísať pri úprave konkrétneho príspevku.

**Q: Čo ak nevyplním globálne nastavenia?**  
A: Plugin použije úplne predvolené hodnoty (názov webu, CC BY 4.0, /image-licenses/).

**Q: Funguje to aj pre WooCommerce produkty?**  
A: Áno! Funguje pre všetky post types (príspevky, stránky, produkty, custom post types).

---

## ✅ Checklist

- [ ] Aktualizoval som plugin na verziu 2.4.4 FINAL
- [ ] Vyplnil som 3 polia v globálnych nastaveniach (JEDNORAZOVO!)
- [ ] Vytvoril som stránku `/image-licenses/`
- [ ] Otvoril som jeden príspevok a overil predvyplnenie ✓
- [ ] Otestoval som v Google Rich Results Test
- [ ] Žiadne chyby pre ImageObject ✅

---

## 🎉 Zhrnutie

**PREDTÝM:**
- ❌ Museli ste vyplniť polia pri každom príspevku
- ❌ Časovo náročné
- ❌ Riziko chýb

**TERAZ:**
- ✅ Vyplníte raz, použije sa všade
- ✅ Automatické predvyplnenie
- ✅ 0 minút na príspevok
- ✅ Konzistentné dáta

**Hotovo za 3 minúty!** 🚀

Google Search Console by mal chyby odstrániť do 1-2 týždňov.

---

*Verzia: 2.4.4 FINAL | Január 2026*
