# 🇸🇰 Rýchla príručka - v2.4.4 FINAL (5 polí)

## 🎯 Čo tento update rieši?

Google Search Console hlásil **5 chýb** v štruktúrovaných dátach pre obrázky:

### Povinné polia:
❌ Chýbajúce pole **acquireLicensePage**  
❌ Chýbajúce pole **creditText**  
❌ Chýbajúce pole **license**

### Nepovinné polia (ale odporúčané):
❌ Chýbajúce pole **creator**  
❌ Chýbajúce pole **copyrightNotice**

✅ **Všetkých 5 chýb je teraz vyriešených!**

---

## ⭐ Hlavné funkcie

### 1. Automatické predvyplnenie
- Nastavíte **jednoraz** v globálnych nastaveniach
- Všetky príspevky/stránky majú hodnoty **automaticky predvyplnené**
- Šetrí 98% času!

### 2. Kompletné Image Metadata
- **3 povinné polia** (creditText, license, acquireLicensePage)
- **2 nepovinné polia** (creator, copyrightNotice)
- Plná kompatibilita s Google Search Console 2026

---

## ⚡ Rýchle kroky (3 minúty)

### Krok 1: Nahrajte plugin (30 sekúnd)
```
WordPress Admin → Pluginy → Pridať nový → Nahrať plugin
→ Vyberte: webstudio-seo-pro-2_4_4-FINAL.zip
→ Aktivovať
```

### Krok 2: Nastavte globálne údaje (2 minúty)
```
SEO PRO → Globálne nastavenia
→ Sekcia "Metadáta loga (Search Console požiadavky)"
→ Vyplňte 5 polí:
```

| Pole | Príklad | Povinné |
|------|---------|---------|
| **Autor / Zdroj loga** | Webstudio.ltd | ✅ Áno |
| **URL licencie** | https://creativecommons.org/licenses/by/4.0/ | ✅ Áno |
| **Stránka s licenciou** | https://webstudio.ltd/image-licenses/ | ✅ Áno |
| **Tvorca/Autor obrázka** | Jan Novák | ⚪ Nie |
| **Copyright oznámenie** | © 2025 Webstudio.ltd | ⚪ Nie |

```
→ Uložiť zmeny
```

### Krok 3: Vytvorte stránku s licenciami
```
Stránky → Pridať novú
→ Názov: "Licencie obrázkov"
→ URL: /image-licenses/
→ Publikovať
```

**Hotovo!** Všetky príspevky majú teraz automaticky všetky metadata! 🎉

---

## 📋 Polia v detaile

### Povinné polia (3):

**1. creditText** - Autor/Zdroj obrázka
```
Príklad: "Webstudio.ltd"
Schema: "creditText": "Webstudio.ltd"
```

**2. license** - URL licencie
```
Príklad: "https://creativecommons.org/licenses/by/4.0/"
Schema: "license": "https://creativecommons.org/licenses/by/4.0/"
```

**3. acquireLicensePage** - Stránka s licenciou
```
Príklad: "https://webstudio.ltd/image-licenses/"
Schema: "acquireLicensePage": "https://webstudio.ltd/image-licenses/"
```

### Nepovinné polia (2):

**4. creator** - Tvorca/Autor obrázka
```
Príklad: "Jan Novák"
Schema: "creator": {"@type": "Person", "name": "Jan Novák"}
```

**5. copyrightNotice** - Copyright oznámenie
```
Príklad: "© 2025 Webstudio.ltd. Všetky práva vyhradené."
Schema: "copyrightNotice": "© 2025 Webstudio.ltd. Všetky práva vyhradené."
```

---

## 🔍 Výsledná Schema.org štruktúra

Po nastavení budú vaše obrázky mať kompletnú schému:

```json
{
  "@type": "ImageObject",
  "url": "https://webstudio.ltd/image.jpg",
  "contentUrl": "https://webstudio.ltd/image.jpg",
  "creditText": "Webstudio.ltd",
  "license": "https://creativecommons.org/licenses/by/4.0/",
  "acquireLicensePage": "https://webstudio.ltd/image-licenses/",
  "creator": {
    "@type": "Person",
    "name": "Jan Novák"
  },
  "copyrightNotice": "© 2025 Webstudio.ltd. Všetky práva vyhradené."
}
```

✅ Všetky polia vyplnené  
✅ Validné podľa Schema.org  
✅ Bez chýb v Google Search Console

---

## 💡 Kde sa tieto polia použijú?

Plugin automaticky pridáva všetky polia do **4 miest**:

1. **Logo organizácie** (Organization schema)
2. **Featured image na stránkach** (WebPage schema)
3. **Publisher logo v článkoch** (Article schema)
4. **Featured image v článkoch** (Article schema)

Všade rovnaké hodnoty (ak ich nezmeníte individuálne)!

---

## 🎨 Ako to vyzerá v admin rozhraní?

### Globálne nastavenia:

```
┌─────────────────────────────────────────────┐
│ 📷 Metadáta loga (Search Console)          │
├─────────────────────────────────────────────┤
│ Autor / Zdroj loga * ✅                     │
│ [Webstudio.ltd                        ]     │
│                                             │
│ URL licencie * ✅                           │
│ [https://creativecommons.org/licenses...    │
│                                             │
│ Stránka s licenciou * ✅                    │
│ [https://webstudio.ltd/image-licenses/]    │
│                                             │
│ Tvorca/Autor obrázka ⚪                     │
│ [Jan Novák                            ]     │
│                                             │
│ Copyright oznámenie ⚪                      │
│ [© 2025 Webstudio.ltd                 ]     │
└─────────────────────────────────────────────┘

✅ = Povinné pole
⚪ = Nepovinné pole
```

### V každom príspevku (automaticky predvyplnené!):

```
┌─────────────────────────────────────────────┐
│ 📷 Metadáta obrázka                         │
│ 💡 Predvyplnené z globálnych nastavení     │
├─────────────────────────────────────────────┤
│ Autor / Zdroj * [Webstudio.ltd       ] ✓   │
│ URL licencie * [https://creative...   ] ✓   │
│ Stránka * [https://webstudio.ltd/... ] ✓   │
│ Tvorca [Jan Novák                    ] ✓   │
│ Copyright [© 2025 Webstudio.ltd      ] ✓   │
└─────────────────────────────────────────────┘

✓ = Predvyplnené z globálnych nastavení
```

---

## ❓ Časté otázky

**Q: Musím vyplniť všetky polia?**  
A: **Povinné** (prvé 3) áno, **nepovinné** (creator, copyright) nie - ale odporúčame!

**Q: Aký je rozdiel medzi creditText a creator?**  
A: 
- **creditText** = zdroj/vlastník (napr. "Webstudio.ltd")
- **creator** = konkrétna osoba/firma ktorá to vytvorila (napr. "Jan Novák")

**Q: Môžem mať rovnaké hodnoty v creditText aj creator?**  
A: Áno! Ak ste sami vytvorili logo, môžete dať rovnaké hodnoty.

**Q: Čo ak nevyplním nepovinné polia?**  
A: Nič sa nestane - plugin jednoducho nezahrnie tieto polia do schémy. Povinné polia stačia.

**Q: Prečo je lepšie vyplniť aj nepovinné polia?**  
A: 
- Kompletnejšie metadata pre Google
- Lepšia ochrana autorských práv
- Profesionálnejšia prezentácia

**Q: Môžem použiť rôzne hodnoty pre rôzne obrázky?**  
A: Áno! Pri úprave príspevku môžete prepísať predvyplnené hodnoty.

---

## 🎯 Príklady použitia

### Príklad 1: Firma s vlastným logom

**Globálne nastavenia:**
```
creditText: Webstudio.ltd
license: https://webstudio.ltd/copyright/
acquireLicensePage: https://webstudio.ltd/image-licenses/
creator: Jan Novák (Graphic Designer)
copyrightNotice: © 2025 Webstudio.ltd. All rights reserved.
```

### Príklad 2: Blog s mix obrázkami

**Globálne (default pre väčšinu obrázkov):**
```
creditText: Blog.sk
license: https://creativecommons.org/licenses/by/4.0/
acquireLicensePage: https://blog.sk/licencie/
creator: Blog.sk Team
copyrightNotice: © 2025 Blog.sk
```

**Individuálne (pre konkrétny obrázok z Unsplash):**
```
creditText: John Doe via Unsplash
license: https://unsplash.com/license
acquireLicensePage: https://blog.sk/licencie/
creator: John Doe
copyrightNotice: Unsplash License
```

### Príklad 3: E-commerce s produktovými fotkami

**Globálne:**
```
creditText: Obchod.sk
license: https://obchod.sk/copyright/
acquireLicensePage: https://obchod.sk/image-rights/
creator: Professional Product Photography s.r.o.
copyrightNotice: © 2025 Obchod.sk. Unauthorized use prohibited.
```

---

## ✅ Checklist

- [ ] Plugin aktivovaný
- [ ] Vyplnené **3 povinné polia** v globálnych nastaveniach
- [ ] (Voliteľné) Vyplnené **2 nepovinné polia** v globálnych nastaveniach
- [ ] Vytvorená stránka `/image-licenses/`
- [ ] Otvorený jeden príspevok - overené predvyplnenie ✓
- [ ] Testované v Google Rich Results Test
- [ ] Žiadne chyby ✅

---

## 📊 Porovnanie: Predtým vs. Teraz

| Aspekt | Pred updateom | Po updatee |
|--------|---------------|------------|
| **Počet chýb** | 5 | 0 ✅ |
| **Vyplnené polia** | 0/5 | 5/5 ✅ |
| **Čas na nastavenie** | 5 min/príspevok | 3 min celkovo ✅ |
| **Predvyplnenie** | ❌ | ✅ |
| **Konzistentnosť** | Rôzne hodnoty | Jednotné ✅ |

---

## 🚀 Zhrnutie

**Webstudio SEO PRO v2.4.4 FINAL:**

✅ Opravuje **5 chýb** (3 povinné + 2 nepovinné)  
✅ **Automatické predvyplnenie** všetkých polí  
✅ **3 minúty** nastavenia celkom  
✅ **98% úspora času** pri vyplňovaní  
✅ **Kompletné Image Metadata** pre Google  

**Najrýchlejšie a najkompletnejšie riešenie na trhu!** 🏆

---

*Verzia: 2.4.4 FINAL | 21. január 2026*
