# ⚡ Expresná príručka - v2.4.5 (Automatizácia)

## 🎯 Čo je nové?

Plugin teraz **automaticky vyplní VŠETKY odporúčané polia** z WordPress dát!

**Žiadna manuálna práca!** 🎉

---

## 📋 Čo sa automaticky vyplní?

### ImageObject:
- ✅ **name** → z ALT textu obrázka
- ✅ **description** → z Caption obrázka
- ✅ **author** → z creator

### Person:
- ✅ **image** → WordPress avatar
- ✅ **worksFor** → váš web

---

## ⚡ Setup (1 minúta)

### Nová inštalácia:

```
1. Nahrať plugin
2. Aktivovať
3. Nastaviť 5 polí v globálnych nastaveniach
4. HOTOVO!
```

### Upgrade z v2.4.4:

```
1. Nahrať nový ZIP
2. Prepísať starú verziu
3. HOTOVO! (globálne nastavenia zostávajú)
```

**Nič iné sa nemusí robiť!** ✅

---

## 🎨 Odkiaľ sa berú dáta?

| Pole | Zdroj | Ako nastaviť |
|------|-------|--------------|
| **name** | ALT text | Médiá → Upraviť → Alt Text |
| **description** | Caption | Médiá → Upraviť → Caption |
| **author** | creator | Globálne nastavenia |
| **image** | Avatar | Profile → Gravatar |
| **worksFor** | Názov webu | Nastavenia → Všeobecné |

---

## 💡 Best practices

### 1. Nastavte ALT texty

```
Zlý ALT: "IMG_1234"
Dobrý ALT: "Moderné SEO stratégie 2026"
```

WordPress → Médiá → Upraviť obrázok → Alt Text

### 2. Použite Caption

```
Príklad: "Infografika SEO trendov pre rok 2026"
```

WordPress → Médiá → Upraviť obrázok → Caption

### 3. Nastavte avatary

```
Gravatar.com → Nahrať fotku
```

Automaticky sa zobrazí vo všetkých článkoch!

---

## 🔍 Výsledok

### ImageObject - Pred:
```json
{
  "url": "...",
  "creditText": "..."
}
```
❌ 5/8 polí

### ImageObject - Po:
```json
{
  "url": "...",
  "name": "SEO stratégie 2026",
  "description": "Infografika...",
  "author": {"name": "Jan Novák"},
  "creditText": "..."
}
```
✅ 8/8 polí!

---

## ❓ FAQ

**Q: Musím mať ALT texty?**  
A: Nie, ale odporúčame! Plugin použije názov príspevku ako fallback.

**Q: Čo ak nemám Caption?**  
A: Plugin použije Excerpt alebo názov príspevku.

**Q: Funguje to aj pre staré príspevky?**  
A: Áno! Automaticky pri ďalšej reindexácii.

**Q: Musia autori mať avatary?**  
A: WordPress použije Gravatar default. Pole sa vždy vyplní.

---

## ✅ Checklist

Po inštalácii:

- [ ] Plugin aktivovaný
- [ ] Globálne nastavenia vyplnené (z v2.4.4)
- [ ] (Voliteľné) ALT texty nastavené
- [ ] (Voliteľné) Captions pridané
- [ ] (Voliteľné) Gravatar avatary
- [ ] Test v Google Rich Results → 0 chýb ✅

---

## 🎉 Výsledok

**ImageObject: 8/8 polí (100%)** ✅  
**Person: 6/6 polí (100%)** ✅  
**Organization: 5/5 polí (100%)** ✅  

**0 chýb v Search Console!** 🏆

---

## 📊 Porovnanie verzií

| Verzia | Automatizácia | Pokrytie polí |
|--------|---------------|---------------|
| v2.4.4 | 63% | 5/8 |
| **v2.4.5** | **100%** ✅ | **8/8** ✅ |

**Najlepší SEO plugin 2026!** 🚀

---

*Verzia: 2.4.5 | 21. január 2026*
