// SEO Audit by webstudio.ltd - Multi-language support

var auditData = null;
var currentFilter = null;
var auditIssues = { errors: [], warnings: [], passed: [] };
var currentLang = 'sk';
var fileChecks = { robots: null, sitemap: null, llms: null };
var schemaData = [];

// Translations
var translations = {
  sk: {
    tabAudit: 'Audit',
    tabKeywords: 'Kľúčové slová',
    tabExport: 'Export',
    analyze: 'Analyzovať',
    analyzing: 'Analyzujem stránku...',
    passed: 'Prešlo',
    errors: 'Chyby',
    warnings: 'Varovania',
    showAll: 'Zobraziť všetky',
    filter: 'Filter',
    totalWords: 'Celkom slov',
    uniqueWords: 'Unikátnych',
    keywordsCloud: 'Keywords cloud',
    topKeywords: 'Top kľúčové slová',
    twoWordPhrases: 'Dvojslovné frázy',
    threeWordPhrases: 'Trojslovné frázy',
    exportTitle: 'Export HTML Report (White Label)',
    companyName: 'Webstránka',
    companyPhone: 'Telefón',
    exportBtn: 'Exportovať HTML Report',
    settings: 'Nastavenia',
    save: 'Uložiť',
    basicInfo: 'Základné informácie',
    pageAnalysis: 'Analýza stránky',
    headingsStructure: 'Štruktúra nadpisov',
    technicalParams: 'Technické parametre',
    socialStructured: 'Sociálne siete & Štruktúrované dáta',
    links: 'Odkazy',
    title: 'Titulok',
    metaDesc: 'Meta popis',
    canonical: 'Canonical URL',
    h1heading: 'H1 nadpis',
    images: 'Obrázky',
    textHtmlRatio: 'Text/HTML pomer',
    viewport: 'Viewport',
    favicon: 'Favicon',
    openGraph: 'Open Graph',
    twitterCard: 'Twitter Card',
    schemaOrg: 'Schema.org',
    internalLinks: 'Interné odkazy',
    externalLinks: 'Externé odkazy',
    nofollowLinks: 'Nofollow odkazy',
    chars: 'znakov',
    optimal: 'optimálne',
    tooLong: 'príliš dlhý',
    tooShort: 'príliš krátky',
    missing: 'Chýba',
    set: 'Nastavený',
    correct: 'správne',
    recommended: 'odporúčaný je',
    headings: 'nadpisov',
    allImagesHaveAlt: 'Všetkých {0} obrázkov má ALT atribút',
    imagesWithoutAlt: '{0} z {1} obrázkov nemá ALT atribút',
    noImagesOnPage: 'Žiadne obrázky na stránke',
    excellent: 'výborné',
    acceptable: 'prijateľné',
    tooLow: 'príliš nízke',
    metaViewportSet: 'Meta viewport je nastavený',
    missingMetaViewport: 'Chýba meta viewport tag',
    faviconSet: 'Favicon je nastavený',
    missingFavicon: 'Chýba favicon',
    tagsFound: 'tagov nájdených',
    noTags: 'Žiadne',
    typesFound: 'typov nájdených',
    types: 'Typy',
    noStructuredData: 'Žiadne štruktúrované dáta',
    linksCount: 'odkazov',
    clickToShow: 'klikni pre zobrazenie',
    keyword: 'Kľúčové slovo',
    count: 'Počet',
    density: 'Hustota',
    noData: 'Žiadne dáta',
    language: 'Jazyk',
    encoding: 'Kódovanie',
    notSet: 'Nenastavený',
    noHeadingsOnPage: 'Žiadne nadpisy na stránke',
    cannotAnalyze: 'Túto stránku nie je možné analyzovať',
    analyzeFirst: 'Najprv analyzujte stránku',
    analysisDate: 'Dátum analýzy',
    analyzedUrl: 'Analyzovaná URL',
    notFound: 'Nenájdené',
    noPhrasesWithFreq: 'Žiadne frázy s frekvenciou ≥ 2',
    robotsTxt: 'Robots.txt',
    sitemapXml: 'Sitemap.xml',
    llmsTxt: 'LLMs.txt',
    found: 'Nájdený',
    notFoundFile: 'Nenájdený',
    checking: 'Kontrolujem...',
    open: 'otvoriť',
    tabSchema: 'Schema',
    schemaTypes: 'Typy',
    valid: 'Validné',
    errorsFound: 'Chyby',
    googleTest: 'Testovať v Google',
    schemaValidation: 'Validácia Schema.org',
    required: 'povinné',
    recommended: 'odporúčané',
    fieldMissing: 'chýba',
    noSchemaFound: 'Žiadne Schema.org dáta na stránke'
  },
  en: {
    tabAudit: 'Audit',
    tabKeywords: 'Keywords',
    tabExport: 'Export',
    analyze: 'Analyze',
    analyzing: 'Analyzing page...',
    passed: 'Passed',
    errors: 'Errors',
    warnings: 'Warnings',
    showAll: 'Show all',
    filter: 'Filter',
    totalWords: 'Total words',
    uniqueWords: 'Unique',
    keywordsCloud: 'Keywords cloud',
    topKeywords: 'Top keywords',
    twoWordPhrases: 'Two-word phrases',
    threeWordPhrases: 'Three-word phrases',
    exportTitle: 'Export HTML Report (White Label)',
    companyName: 'Website',
    companyPhone: 'Phone',
    exportBtn: 'Export HTML Report',
    settings: 'Settings',
    save: 'Save',
    basicInfo: 'Basic information',
    pageAnalysis: 'Page analysis',
    headingsStructure: 'Headings structure',
    technicalParams: 'Technical parameters',
    socialStructured: 'Social media & Structured data',
    links: 'Links',
    title: 'Title',
    metaDesc: 'Meta description',
    canonical: 'Canonical URL',
    h1heading: 'H1 heading',
    images: 'Images',
    textHtmlRatio: 'Text/HTML ratio',
    viewport: 'Viewport',
    favicon: 'Favicon',
    openGraph: 'Open Graph',
    twitterCard: 'Twitter Card',
    schemaOrg: 'Schema.org',
    internalLinks: 'Internal links',
    externalLinks: 'External links',
    nofollowLinks: 'Nofollow links',
    chars: 'characters',
    optimal: 'optimal',
    tooLong: 'too long',
    tooShort: 'too short',
    missing: 'Missing',
    set: 'Set',
    correct: 'correct',
    recommended: 'recommended is',
    headings: 'headings',
    allImagesHaveAlt: 'All {0} images have ALT attribute',
    imagesWithoutAlt: '{0} of {1} images missing ALT attribute',
    noImagesOnPage: 'No images on page',
    excellent: 'excellent',
    acceptable: 'acceptable',
    tooLow: 'too low',
    metaViewportSet: 'Meta viewport is set',
    missingMetaViewport: 'Missing meta viewport tag',
    faviconSet: 'Favicon is set',
    missingFavicon: 'Missing favicon',
    tagsFound: 'tags found',
    noTags: 'No',
    typesFound: 'types found',
    types: 'Types',
    noStructuredData: 'No structured data',
    linksCount: 'links',
    clickToShow: 'click to show',
    keyword: 'Keyword',
    count: 'Count',
    density: 'Density',
    noData: 'No data',
    language: 'Language',
    encoding: 'Encoding',
    notSet: 'Not set',
    noHeadingsOnPage: 'No headings on page',
    cannotAnalyze: 'Cannot analyze this page',
    analyzeFirst: 'Analyze a page first',
    analysisDate: 'Analysis date',
    analyzedUrl: 'Analyzed URL',
    notFound: 'Not found',
    noPhrasesWithFreq: 'No phrases with frequency ≥ 2',
    robotsTxt: 'Robots.txt',
    sitemapXml: 'Sitemap.xml',
    llmsTxt: 'LLMs.txt',
    found: 'Found',
    notFoundFile: 'Not found',
    checking: 'Checking...',
    open: 'open',
    tabSchema: 'Schema',
    schemaTypes: 'Types',
    valid: 'Valid',
    errorsFound: 'Errors',
    googleTest: 'Test in Google',
    schemaValidation: 'Schema.org Validation',
    required: 'required',
    recommended: 'recommended',
    fieldMissing: 'missing',
    noSchemaFound: 'No Schema.org data found on page'
  },
  de: {
    tabAudit: 'Audit',
    tabKeywords: 'Schlüsselwörter',
    tabExport: 'Export',
    analyze: 'Analysieren',
    analyzing: 'Seite wird analysiert...',
    passed: 'Bestanden',
    errors: 'Fehler',
    warnings: 'Warnungen',
    showAll: 'Alle anzeigen',
    filter: 'Filter',
    totalWords: 'Gesamtzahl',
    uniqueWords: 'Einzigartig',
    keywordsCloud: 'Schlüsselwort-Wolke',
    topKeywords: 'Top-Schlüsselwörter',
    twoWordPhrases: 'Zwei-Wort-Phrasen',
    threeWordPhrases: 'Drei-Wort-Phrasen',
    exportTitle: 'HTML-Bericht exportieren (White Label)',
    companyName: 'Webseite',
    companyPhone: 'Telefon',
    exportBtn: 'HTML-Bericht exportieren',
    settings: 'Einstellungen',
    save: 'Speichern',
    basicInfo: 'Grundinformationen',
    pageAnalysis: 'Seitenanalyse',
    headingsStructure: 'Überschriftenstruktur',
    technicalParams: 'Technische Parameter',
    socialStructured: 'Social Media & Strukturierte Daten',
    links: 'Links',
    title: 'Titel',
    metaDesc: 'Meta-Beschreibung',
    canonical: 'Canonical URL',
    h1heading: 'H1-Überschrift',
    images: 'Bilder',
    textHtmlRatio: 'Text/HTML-Verhältnis',
    viewport: 'Viewport',
    favicon: 'Favicon',
    openGraph: 'Open Graph',
    twitterCard: 'Twitter Card',
    schemaOrg: 'Schema.org',
    internalLinks: 'Interne Links',
    externalLinks: 'Externe Links',
    nofollowLinks: 'Nofollow-Links',
    chars: 'Zeichen',
    optimal: 'optimal',
    tooLong: 'zu lang',
    tooShort: 'zu kurz',
    missing: 'Fehlt',
    set: 'Gesetzt',
    correct: 'korrekt',
    recommended: 'empfohlen ist',
    headings: 'Überschriften',
    allImagesHaveAlt: 'Alle {0} Bilder haben ALT-Attribut',
    imagesWithoutAlt: '{0} von {1} Bildern ohne ALT-Attribut',
    noImagesOnPage: 'Keine Bilder auf der Seite',
    excellent: 'ausgezeichnet',
    acceptable: 'akzeptabel',
    tooLow: 'zu niedrig',
    metaViewportSet: 'Meta-Viewport ist gesetzt',
    missingMetaViewport: 'Meta-Viewport-Tag fehlt',
    faviconSet: 'Favicon ist gesetzt',
    missingFavicon: 'Favicon fehlt',
    tagsFound: 'Tags gefunden',
    noTags: 'Keine',
    typesFound: 'Typen gefunden',
    types: 'Typen',
    noStructuredData: 'Keine strukturierten Daten',
    linksCount: 'Links',
    clickToShow: 'Klicken zum Anzeigen',
    keyword: 'Schlüsselwort',
    count: 'Anzahl',
    density: 'Dichte',
    noData: 'Keine Daten',
    language: 'Sprache',
    encoding: 'Kodierung',
    notSet: 'Nicht gesetzt',
    noHeadingsOnPage: 'Keine Überschriften auf der Seite',
    cannotAnalyze: 'Diese Seite kann nicht analysiert werden',
    analyzeFirst: 'Analysieren Sie zuerst eine Seite',
    analysisDate: 'Analysedatum',
    analyzedUrl: 'Analysierte URL',
    notFound: 'Nicht gefunden',
    noPhrasesWithFreq: 'Keine Phrasen mit Häufigkeit ≥ 2',
    robotsTxt: 'Robots.txt',
    sitemapXml: 'Sitemap.xml',
    llmsTxt: 'LLMs.txt',
    found: 'Gefunden',
    notFoundFile: 'Nicht gefunden',
    checking: 'Überprüfen...',
    open: 'öffnen',
    tabSchema: 'Schema',
    schemaTypes: 'Typen',
    valid: 'Gültig',
    errorsFound: 'Fehler',
    googleTest: 'In Google testen',
    schemaValidation: 'Schema.org Validierung',
    required: 'erforderlich',
    recommended: 'empfohlen',
    fieldMissing: 'fehlt',
    noSchemaFound: 'Keine Schema.org Daten gefunden'
  },
  fr: {
    tabAudit: 'Audit',
    tabKeywords: 'Mots-clés',
    tabExport: 'Export',
    analyze: 'Analyser',
    analyzing: 'Analyse en cours...',
    passed: 'Réussi',
    errors: 'Erreurs',
    warnings: 'Avertissements',
    showAll: 'Tout afficher',
    filter: 'Filtre',
    totalWords: 'Total mots',
    uniqueWords: 'Uniques',
    keywordsCloud: 'Nuage de mots-clés',
    topKeywords: 'Top mots-clés',
    twoWordPhrases: 'Phrases de deux mots',
    threeWordPhrases: 'Phrases de trois mots',
    exportTitle: 'Exporter rapport HTML (White Label)',
    companyName: 'Site web',
    companyPhone: 'Téléphone',
    exportBtn: 'Exporter rapport HTML',
    settings: 'Paramètres',
    save: 'Enregistrer',
    basicInfo: 'Informations de base',
    pageAnalysis: 'Analyse de la page',
    headingsStructure: 'Structure des titres',
    technicalParams: 'Paramètres techniques',
    socialStructured: 'Réseaux sociaux & Données structurées',
    links: 'Liens',
    title: 'Titre',
    metaDesc: 'Meta description',
    canonical: 'URL canonique',
    h1heading: 'Titre H1',
    images: 'Images',
    textHtmlRatio: 'Ratio Texte/HTML',
    viewport: 'Viewport',
    favicon: 'Favicon',
    openGraph: 'Open Graph',
    twitterCard: 'Twitter Card',
    schemaOrg: 'Schema.org',
    internalLinks: 'Liens internes',
    externalLinks: 'Liens externes',
    nofollowLinks: 'Liens nofollow',
    chars: 'caractères',
    optimal: 'optimal',
    tooLong: 'trop long',
    tooShort: 'trop court',
    missing: 'Manquant',
    set: 'Défini',
    correct: 'correct',
    recommended: 'recommandé est',
    headings: 'titres',
    allImagesHaveAlt: 'Toutes les {0} images ont l\'attribut ALT',
    imagesWithoutAlt: '{0} sur {1} images sans attribut ALT',
    noImagesOnPage: 'Aucune image sur la page',
    excellent: 'excellent',
    acceptable: 'acceptable',
    tooLow: 'trop bas',
    metaViewportSet: 'Meta viewport est défini',
    missingMetaViewport: 'Balise meta viewport manquante',
    faviconSet: 'Favicon est défini',
    missingFavicon: 'Favicon manquant',
    tagsFound: 'balises trouvées',
    noTags: 'Aucune',
    typesFound: 'types trouvés',
    types: 'Types',
    noStructuredData: 'Aucune donnée structurée',
    linksCount: 'liens',
    clickToShow: 'cliquez pour afficher',
    keyword: 'Mot-clé',
    count: 'Nombre',
    density: 'Densité',
    noData: 'Aucune donnée',
    language: 'Langue',
    encoding: 'Encodage',
    notSet: 'Non défini',
    noHeadingsOnPage: 'Aucun titre sur la page',
    cannotAnalyze: 'Impossible d\'analyser cette page',
    analyzeFirst: 'Analysez d\'abord une page',
    analysisDate: 'Date d\'analyse',
    analyzedUrl: 'URL analysée',
    notFound: 'Non trouvé',
    noPhrasesWithFreq: 'Aucune phrase avec fréquence ≥ 2',
    robotsTxt: 'Robots.txt',
    sitemapXml: 'Sitemap.xml',
    llmsTxt: 'LLMs.txt',
    found: 'Trouvé',
    notFoundFile: 'Non trouvé',
    checking: 'Vérification...',
    open: 'ouvrir',
    tabSchema: 'Schema',
    schemaTypes: 'Types',
    valid: 'Valide',
    errorsFound: 'Erreurs',
    googleTest: 'Tester dans Google',
    schemaValidation: 'Validation Schema.org',
    required: 'obligatoire',
    recommended: 'recommandé',
    fieldMissing: 'manquant',
    noSchemaFound: 'Aucune donnée Schema.org trouvée'
  },
  it: {
    tabAudit: 'Audit',
    tabKeywords: 'Parole chiave',
    tabExport: 'Esporta',
    analyze: 'Analizza',
    analyzing: 'Analisi in corso...',
    passed: 'Superato',
    errors: 'Errori',
    warnings: 'Avvisi',
    showAll: 'Mostra tutto',
    filter: 'Filtro',
    totalWords: 'Totale parole',
    uniqueWords: 'Uniche',
    keywordsCloud: 'Nuvola di parole chiave',
    topKeywords: 'Top parole chiave',
    twoWordPhrases: 'Frasi di due parole',
    threeWordPhrases: 'Frasi di tre parole',
    exportTitle: 'Esporta report HTML (White Label)',
    companyName: 'Sito web',
    companyPhone: 'Telefono',
    exportBtn: 'Esporta report HTML',
    settings: 'Impostazioni',
    save: 'Salva',
    basicInfo: 'Informazioni di base',
    pageAnalysis: 'Analisi della pagina',
    headingsStructure: 'Struttura dei titoli',
    technicalParams: 'Parametri tecnici',
    socialStructured: 'Social media & Dati strutturati',
    links: 'Link',
    title: 'Titolo',
    metaDesc: 'Meta descrizione',
    canonical: 'URL canonico',
    h1heading: 'Titolo H1',
    images: 'Immagini',
    textHtmlRatio: 'Rapporto Testo/HTML',
    viewport: 'Viewport',
    favicon: 'Favicon',
    openGraph: 'Open Graph',
    twitterCard: 'Twitter Card',
    schemaOrg: 'Schema.org',
    internalLinks: 'Link interni',
    externalLinks: 'Link esterni',
    nofollowLinks: 'Link nofollow',
    chars: 'caratteri',
    optimal: 'ottimale',
    tooLong: 'troppo lungo',
    tooShort: 'troppo corto',
    missing: 'Mancante',
    set: 'Impostato',
    correct: 'corretto',
    recommended: 'consigliato è',
    headings: 'titoli',
    allImagesHaveAlt: 'Tutte le {0} immagini hanno l\'attributo ALT',
    imagesWithoutAlt: '{0} di {1} immagini senza attributo ALT',
    noImagesOnPage: 'Nessuna immagine nella pagina',
    excellent: 'eccellente',
    acceptable: 'accettabile',
    tooLow: 'troppo basso',
    metaViewportSet: 'Meta viewport è impostato',
    missingMetaViewport: 'Tag meta viewport mancante',
    faviconSet: 'Favicon è impostato',
    missingFavicon: 'Favicon mancante',
    tagsFound: 'tag trovati',
    noTags: 'Nessuno',
    typesFound: 'tipi trovati',
    types: 'Tipi',
    noStructuredData: 'Nessun dato strutturato',
    linksCount: 'link',
    clickToShow: 'clicca per mostrare',
    keyword: 'Parola chiave',
    count: 'Conteggio',
    density: 'Densità',
    noData: 'Nessun dato',
    language: 'Lingua',
    encoding: 'Codifica',
    notSet: 'Non impostato',
    noHeadingsOnPage: 'Nessun titolo nella pagina',
    cannotAnalyze: 'Impossibile analizzare questa pagina',
    analyzeFirst: 'Prima analizza una pagina',
    analysisDate: 'Data analisi',
    analyzedUrl: 'URL analizzato',
    notFound: 'Non trovato',
    noPhrasesWithFreq: 'Nessuna frase con frequenza ≥ 2',
    robotsTxt: 'Robots.txt',
    sitemapXml: 'Sitemap.xml',
    llmsTxt: 'LLMs.txt',
    found: 'Trovato',
    notFoundFile: 'Non trovato',
    checking: 'Verifica...',
    open: 'aprire',
    tabSchema: 'Schema',
    schemaTypes: 'Tipi',
    valid: 'Valido',
    errorsFound: 'Errori',
    googleTest: 'Testa in Google',
    schemaValidation: 'Validazione Schema.org',
    required: 'obbligatorio',
    recommended: 'consigliato',
    fieldMissing: 'mancante',
    noSchemaFound: 'Nessun dato Schema.org trovato'
  },
  ru: {
    tabAudit: 'Аудит',
    tabKeywords: 'Ключевые слова',
    tabExport: 'Экспорт',
    analyze: 'Анализировать',
    analyzing: 'Анализ страницы...',
    passed: 'Успешно',
    errors: 'Ошибки',
    warnings: 'Предупр.',
    showAll: 'Показать все',
    filter: 'Фильтр',
    totalWords: 'Всего слов',
    uniqueWords: 'Уникальных',
    keywordsCloud: 'Облако ключевых слов',
    topKeywords: 'Топ ключевых слов',
    twoWordPhrases: 'Двухсловные фразы',
    threeWordPhrases: 'Трёхсловные фразы',
    exportTitle: 'Экспорт HTML отчёта (White Label)',
    companyName: 'Сайт',
    companyPhone: 'Телефон',
    exportBtn: 'Экспорт HTML отчёта',
    settings: 'Настройки',
    save: 'Сохранить',
    basicInfo: 'Основная информация',
    pageAnalysis: 'Анализ страницы',
    headingsStructure: 'Структура заголовков',
    technicalParams: 'Технические параметры',
    socialStructured: 'Соцсети & Структурированные данные',
    links: 'Ссылки',
    title: 'Заголовок',
    metaDesc: 'Мета-описание',
    canonical: 'Canonical URL',
    h1heading: 'Заголовок H1',
    images: 'Изображения',
    textHtmlRatio: 'Соотношение Текст/HTML',
    viewport: 'Viewport',
    favicon: 'Favicon',
    openGraph: 'Open Graph',
    twitterCard: 'Twitter Card',
    schemaOrg: 'Schema.org',
    internalLinks: 'Внутренние ссылки',
    externalLinks: 'Внешние ссылки',
    nofollowLinks: 'Nofollow ссылки',
    chars: 'символов',
    optimal: 'оптимально',
    tooLong: 'слишком длинный',
    tooShort: 'слишком короткий',
    missing: 'Отсутствует',
    set: 'Установлен',
    correct: 'правильно',
    recommended: 'рекомендуется',
    headings: 'заголовков',
    allImagesHaveAlt: 'Все {0} изображений имеют атрибут ALT',
    imagesWithoutAlt: '{0} из {1} изображений без атрибута ALT',
    noImagesOnPage: 'Нет изображений на странице',
    excellent: 'отлично',
    acceptable: 'приемлемо',
    tooLow: 'слишком низкое',
    metaViewportSet: 'Meta viewport установлен',
    missingMetaViewport: 'Отсутствует meta viewport тег',
    faviconSet: 'Favicon установлен',
    missingFavicon: 'Отсутствует favicon',
    tagsFound: 'тегов найдено',
    noTags: 'Нет',
    typesFound: 'типов найдено',
    types: 'Типы',
    noStructuredData: 'Нет структурированных данных',
    linksCount: 'ссылок',
    clickToShow: 'нажмите для показа',
    keyword: 'Ключевое слово',
    count: 'Количество',
    density: 'Плотность',
    noData: 'Нет данных',
    language: 'Язык',
    encoding: 'Кодировка',
    notSet: 'Не установлен',
    noHeadingsOnPage: 'Нет заголовков на странице',
    cannotAnalyze: 'Невозможно проанализировать эту страницу',
    analyzeFirst: 'Сначала проанализируйте страницу',
    analysisDate: 'Дата анализа',
    analyzedUrl: 'Анализируемый URL',
    notFound: 'Не найдено',
    noPhrasesWithFreq: 'Нет фраз с частотой ≥ 2',
    robotsTxt: 'Robots.txt',
    sitemapXml: 'Sitemap.xml',
    llmsTxt: 'LLMs.txt',
    found: 'Найден',
    notFoundFile: 'Не найден',
    checking: 'Проверка...',
    open: 'открыть',
    tabSchema: 'Schema',
    schemaTypes: 'Типы',
    valid: 'Валидные',
    errorsFound: 'Ошибки',
    googleTest: 'Тест в Google',
    schemaValidation: 'Валидация Schema.org',
    required: 'обязательно',
    recommended: 'рекомендуется',
    fieldMissing: 'отсутствует',
    noSchemaFound: 'Данные Schema.org не найдены'
  }
};

function t(key) {
  return translations[currentLang][key] || translations['en'][key] || key;
}

// SVG icons
var checkIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polyline points="20 6 9 17 4 12"/></svg>';
var xIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>';
var alertIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>';
var infoIcon = '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/></svg>';

document.addEventListener('DOMContentLoaded', init);

function init() {
  loadLanguage();
  
  if (chrome && chrome.tabs) {
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
      if (tabs[0]) {
        document.getElementById('urlInput').value = tabs[0].url;
      }
    });
  }

  var tabs = document.querySelectorAll('.tab');
  for (var i = 0; i < tabs.length; i++) {
    tabs[i].onclick = function() {
      switchTab(this.getAttribute('data-tab'));
    };
  }

  var scoreCards = document.querySelectorAll('.score-card');
  for (var j = 0; j < scoreCards.length; j++) {
    scoreCards[j].onclick = function() {
      toggleFilter(this.getAttribute('data-filter'));
    };
  }

  // Language flags
  var flags = document.querySelectorAll('.lang-flag');
  for (var f = 0; f < flags.length; f++) {
    flags[f].onclick = function() {
      setLanguage(this.getAttribute('data-lang'));
    };
  }

  document.getElementById('clearFilter').onclick = clearFilter;
  document.getElementById('analyzeBtn').onclick = runAudit;
  document.getElementById('settingsBtn').onclick = function() {
    document.getElementById('settingsModal').classList.remove('hidden');
  };
  document.getElementById('closeSettings').onclick = function() {
    document.getElementById('settingsModal').classList.add('hidden');
  };
  document.getElementById('saveSettings').onclick = saveSettings;
  document.getElementById('exportBtn').onclick = exportReport;

  loadSettings();
}

function loadLanguage() {
  if (chrome && chrome.storage) {
    chrome.storage.local.get(['seoLang'], function(result) {
      if (result.seoLang) {
        currentLang = result.seoLang;
      }
      updateLanguageUI();
    });
  } else {
    updateLanguageUI();
  }
}

function setLanguage(lang) {
  currentLang = lang;
  if (chrome && chrome.storage) {
    chrome.storage.local.set({seoLang: lang});
  }
  updateLanguageUI();
  
  // Re-render results if we have data
  if (auditData) {
    showResults(auditData);
  }
}

function updateLanguageUI() {
  // Update flag active state
  var flags = document.querySelectorAll('.lang-flag');
  for (var f = 0; f < flags.length; f++) {
    flags[f].classList.remove('active');
    if (flags[f].getAttribute('data-lang') === currentLang) {
      flags[f].classList.add('active');
    }
  }
  
  // Update all translatable elements
  var elements = document.querySelectorAll('[data-i18n]');
  for (var i = 0; i < elements.length; i++) {
    var key = elements[i].getAttribute('data-i18n');
    elements[i].textContent = t(key);
  }
}

function switchTab(name) {
  var tabs = document.querySelectorAll('.tab');
  var contents = document.querySelectorAll('.tab-content');
  for (var i = 0; i < tabs.length; i++) tabs[i].classList.remove('active');
  for (var j = 0; j < contents.length; j++) contents[j].classList.remove('active');
  document.querySelector('.tab[data-tab="' + name + '"]').classList.add('active');
  document.getElementById(name + 'Tab').classList.add('active');
}

function toggleFilter(filter) {
  var cards = document.querySelectorAll('.score-card');
  var filterInfo = document.getElementById('filterInfo');
  var filterText = document.getElementById('filterText');
  
  if (currentFilter === filter) {
    clearFilter();
    return;
  }
  
  currentFilter = filter;
  
  for (var i = 0; i < cards.length; i++) {
    cards[i].classList.remove('active');
    if (cards[i].getAttribute('data-filter') === filter) {
      cards[i].classList.add('active');
    }
  }
  
  var filterNames = { passed: t('passed'), error: t('errors'), warning: t('warnings') };
  filterText.textContent = t('filter') + ': ' + filterNames[filter];
  filterInfo.classList.remove('hidden');
  
  var items = document.querySelectorAll('.audit-item');
  for (var j = 0; j < items.length; j++) {
    var itemStatus = items[j].getAttribute('data-status');
    if (itemStatus === filter) {
      items[j].classList.remove('hidden');
    } else {
      items[j].classList.add('hidden');
    }
  }
}

function clearFilter() {
  currentFilter = null;
  var cards = document.querySelectorAll('.score-card');
  for (var i = 0; i < cards.length; i++) {
    cards[i].classList.remove('active');
  }
  document.getElementById('filterInfo').classList.add('hidden');
  var items = document.querySelectorAll('.audit-item');
  for (var j = 0; j < items.length; j++) {
    items[j].classList.remove('hidden');
  }
}

function loadSettings() {
  if (chrome && chrome.storage) {
    chrome.storage.local.get(['seoSettings'], function(result) {
      if (result.seoSettings) {
        document.getElementById('companyName').value = result.seoSettings.name || 'https://webstudio.ltd';
        document.getElementById('companyPhone').value = result.seoSettings.phone || '+421 950 216 916';
        document.getElementById('companyEmail').value = result.seoSettings.email || 'info@webstudio.ltd';
        document.getElementById('defaultCompanyName').value = result.seoSettings.name || 'https://webstudio.ltd';
        document.getElementById('defaultCompanyPhone').value = result.seoSettings.phone || '+421 950 216 916';
        document.getElementById('defaultCompanyEmail').value = result.seoSettings.email || 'info@webstudio.ltd';
      }
    });
  }
}

function saveSettings() {
  var settings = {
    name: document.getElementById('defaultCompanyName').value,
    phone: document.getElementById('defaultCompanyPhone').value,
    email: document.getElementById('defaultCompanyEmail').value
  };
  if (chrome && chrome.storage) {
    chrome.storage.local.set({seoSettings: settings});
  }
  document.getElementById('companyName').value = settings.name;
  document.getElementById('companyPhone').value = settings.phone;
  document.getElementById('companyEmail').value = settings.email;
  document.getElementById('settingsModal').classList.add('hidden');
}

function runAudit() {
  document.getElementById('loading').classList.remove('hidden');
  document.querySelector('.main-content').classList.add('hidden');

  chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
    var tab = tabs[0];
    
    if (!tab || tab.url.indexOf('chrome') === 0 || tab.url.indexOf('about') === 0) {
      alert(t('cannotAnalyze'));
      document.getElementById('loading').classList.add('hidden');
      document.querySelector('.main-content').classList.remove('hidden');
      return;
    }

    chrome.scripting.executeScript({
      target: {tabId: tab.id},
      func: analyzePageContent
    }, function(results) {
      document.getElementById('loading').classList.add('hidden');
      document.querySelector('.main-content').classList.remove('hidden');

      if (chrome.runtime.lastError) {
        alert('Error: ' + chrome.runtime.lastError.message);
        return;
      }

      if (results && results[0] && results[0].result) {
        auditData = results[0].result;
        auditData.url = tab.url;
        
        // Check robots.txt, sitemap.xml, llms.txt
        checkSiteFiles(tab.url, function() {
          showResults(auditData);
        });
      }
    });
  });
}

function checkSiteFiles(pageUrl, callback) {
  try {
    var urlObj = new URL(pageUrl);
    var baseUrl = urlObj.protocol + '//' + urlObj.hostname;
    
    fileChecks = { robots: null, sitemap: null, llms: null, baseUrl: baseUrl };
    var pending = 3;
    
    function done() {
      pending--;
      if (pending === 0) callback();
    }
    
    // Check robots.txt
    fetch(baseUrl + '/robots.txt', { method: 'HEAD' })
      .then(function(r) { fileChecks.robots = r.ok; done(); })
      .catch(function() { fileChecks.robots = false; done(); });
    
    // Check sitemap.xml
    fetch(baseUrl + '/sitemap.xml', { method: 'HEAD' })
      .then(function(r) { fileChecks.sitemap = r.ok; done(); })
      .catch(function() { fileChecks.sitemap = false; done(); });
    
    // Check llms.txt
    fetch(baseUrl + '/llms.txt', { method: 'HEAD' })
      .then(function(r) { fileChecks.llms = r.ok; done(); })
      .catch(function() { fileChecks.llms = false; done(); });
      
  } catch(e) {
    fileChecks = { robots: false, sitemap: false, llms: false, baseUrl: '' };
    callback();
  }
}

function analyzePageContent() {
  var result = {
    title: document.title || '',
    titleLen: (document.title || '').length,
    metaDesc: '',
    metaDescLen: 0,
    canonical: '',
    lang: document.documentElement.lang || '',
    charset: document.characterSet || '',
    headings: { h1: [], h2: [], h3: [], h4: [], h5: [], h6: [] },
    imgTotal: 0,
    imgAlt: 0,
    imgWithoutAlt: [],
    linksInternal: [],
    linksExternal: [],
    linksNofollow: [],
    textLen: 0,
    htmlLen: 0,
    ratio: 0,
    viewport: false,
    viewportContent: '',
    favicon: false,
    og: {},
    twitter: {},
    schema: [],
    schemaRaw: [],
    words: {},
    phrases2: {},
    phrases3: {},
    totalWords: 0
  };

  var metaD = document.querySelector('meta[name="description"]');
  if (metaD) {
    result.metaDesc = metaD.getAttribute('content') || '';
    result.metaDescLen = result.metaDesc.length;
  }

  var can = document.querySelector('link[rel="canonical"]');
  if (can) result.canonical = can.getAttribute('href') || '';

  for (var h = 1; h <= 6; h++) {
    var headings = document.querySelectorAll('h' + h);
    for (var i = 0; i < headings.length; i++) {
      result.headings['h' + h].push(headings[i].textContent.trim());
    }
  }

  var imgs = document.querySelectorAll('img');
  result.imgTotal = imgs.length;
  
  // Patterns to ignore (system images)
  var ignorePatterns = [
    'avatar',
    'gravatar.com',
    'pixel.wp.com',
    'stats.wp.com',
    'fonts.gstatic.com',
    'fonts.googleapis.com',
    'google-analytics.com',
    'googletagmanager.com',
    'facebook.com/tr',
    'analytics',
    'tracking',
    'beacon',
    '/plugins/',
    'wp-includes',
    'data:image',
    '1x1',
    'spacer',
    'blank.gif',
    'pixel.gif',
    'transparent.gif',
    '.svg'
  ];
  
  function shouldIgnoreImage(src) {
    if (!src) return true;
    var srcLower = src.toLowerCase();
    for (var i = 0; i < ignorePatterns.length; i++) {
      if (srcLower.indexOf(ignorePatterns[i].toLowerCase()) >= 0) return true;
    }
    return false;
  }
  
  for (var j = 0; j < imgs.length; j++) {
    var alt = imgs[j].getAttribute('alt');
    if (alt && alt.trim()) {
      result.imgAlt++;
    } else {
      var imgSrc = imgs[j].src || imgs[j].getAttribute('data-src') || imgs[j].getAttribute('data-lazy-src') || '';
      if (imgSrc && !shouldIgnoreImage(imgSrc)) {
        result.imgWithoutAlt.push(imgSrc);
      } else {
        // Count ignored as having alt (don't penalize)
        result.imgAlt++;
      }
    }
  }

  var links = document.querySelectorAll('a[href]');
  var host = window.location.hostname;
  var seenInt = {}, seenExt = {}, seenNof = {};
  
  for (var k = 0; k < links.length; k++) {
    var href = links[k].getAttribute('href') || '';
    var rel = links[k].getAttribute('rel') || '';
    
    try {
      var u = new URL(href, location.origin);
      var fullUrl = u.href;
      
      if (u.hostname === host) {
        if (!seenInt[fullUrl]) { result.linksInternal.push(fullUrl); seenInt[fullUrl] = true; }
      } else if (href.indexOf('http') === 0) {
        if (!seenExt[fullUrl]) { result.linksExternal.push(fullUrl); seenExt[fullUrl] = true; }
      }
      
      if (rel.indexOf('nofollow') >= 0 && !seenNof[fullUrl]) {
        result.linksNofollow.push(fullUrl);
        seenNof[fullUrl] = true;
      }
    } catch(e) {}
  }

  var bodyText = document.body.innerText || '';
  var textOnly = bodyText.replace(/\s+/g, ' ').trim();
  result.textLen = textOnly.length;
  
  var htmlClone = document.documentElement.cloneNode(true);
  var scripts = htmlClone.querySelectorAll('script, style, noscript');
  for (var s = 0; s < scripts.length; s++) scripts[s].remove();
  result.htmlLen = htmlClone.innerHTML.length;
  
  if (result.htmlLen > 0) result.ratio = ((result.textLen / result.htmlLen) * 100).toFixed(2);

  var vp = document.querySelector('meta[name="viewport"]');
  if (vp) {
    result.viewport = true;
    result.viewportContent = vp.getAttribute('content') || '';
  }

  result.favicon = !!document.querySelector('link[rel="icon"], link[rel="shortcut icon"], link[rel="apple-touch-icon"]');

  var ogTags = document.querySelectorAll('meta[property^="og:"]');
  for (var m = 0; m < ogTags.length; m++) {
    var prop = ogTags[m].getAttribute('property').replace('og:', '');
    result.og[prop] = ogTags[m].getAttribute('content') || '';
  }

  var twTags = document.querySelectorAll('meta[name^="twitter:"]');
  for (var n = 0; n < twTags.length; n++) {
    var name = twTags[n].getAttribute('name').replace('twitter:', '');
    result.twitter[name] = twTags[n].getAttribute('content') || '';
  }

  var jsonLd = document.querySelectorAll('script[type="application/ld+json"]');
  for (var p = 0; p < jsonLd.length; p++) {
    try {
      var data = JSON.parse(jsonLd[p].textContent);
      
      function addSchemaType(schemaType) {
        if (Array.isArray(schemaType)) {
          for (var i = 0; i < schemaType.length; i++) {
            if (schemaType[i] && result.schema.indexOf(schemaType[i]) < 0) {
              result.schema.push(schemaType[i]);
            }
          }
        } else if (schemaType && result.schema.indexOf(schemaType) < 0) {
          result.schema.push(schemaType);
        }
      }
      
      function collectSchemaItem(item) {
        if (item && item['@type']) {
          result.schemaRaw.push(JSON.parse(JSON.stringify(item)));
          addSchemaType(item['@type']);
        }
      }
      
      if (data['@type']) collectSchemaItem(data);
      if (data['@graph']) {
        for (var g = 0; g < data['@graph'].length; g++) {
          collectSchemaItem(data['@graph'][g]);
        }
      }
    } catch(e) {}
  }

  var microdata = document.querySelectorAll('[itemtype]');
  for (var md = 0; md < microdata.length; md++) {
    var itemtype = microdata[md].getAttribute('itemtype');
    if (itemtype) {
      var type = itemtype.split('/').pop();
      if (result.schema.indexOf(type) < 0) result.schema.push(type);
    }
  }

  var text = bodyText.toLowerCase();
  var wordList = text.replace(/[^a-záäčďéíľňóôŕšťúýžěřůüàâæçéèêëïîôœùûüÿßäöüàèéìòóùäöüåæøа-яё\s]/g, ' ').split(/\s+/).filter(function(w) {
    return w.length > 2;
  });
  
  var stops = ['pre','pri','pod','nad','ako','ale','keď','kde','kto','tak','aby','ani','bez','ich','jeho','jej','len','než','nie','ste','tam','ten','však','the','and','for','are','but','not','you','all','can','was','one','our','this','that','with','have','from','they','been','has','were','said','each','she','which','their','will','way','about','many','then','them','would','these','her','him','more','také','tiež','alebo','môže','môžu','bude','budem','budeme','budú','máte','máme','vaše','vaša','vašu','môžete','preto','ktorý','ktorá','ktoré','ktorú','tohto','toho','tejto','touto','všetky','každý','každá','sme','som','bol','bola','boli','byť','und','der','die','das','ist','ein','eine','auf','mit','für','von','den','dem','des','sich','auch','als','oder','bei','nach','aus','wie','über','nur','noch','werden','kann','können','haben','wird','sind','war','zum','zur','dans','les','des','pour','par','sur','avec','une','que','qui','est','pas','son','sont','plus','tout','faire','comme','nous','vous','été','être','ont','nel','della','che','per','con','una','sono','dal','gli','anche','come','più','può','essere','quello','questa','hanno','suo','dalla','его','для','что','это','как','она','они','или','при','так','все','быть','было','этот','только','уже','если','ещё','когда','очень','нет','есть','будет','него','была','были'];
  
  var filtered = wordList.filter(function(w) { return stops.indexOf(w) < 0; });

  for (var q = 0; q < filtered.length; q++) {
    var w = filtered[q];
    result.words[w] = (result.words[w] || 0) + 1;
  }

  for (var r = 0; r < filtered.length - 1; r++) {
    var p2 = filtered[r] + ' ' + filtered[r+1];
    result.phrases2[p2] = (result.phrases2[p2] || 0) + 1;
  }

  for (var tt = 0; tt < filtered.length - 2; tt++) {
    var p3 = filtered[tt] + ' ' + filtered[tt+1] + ' ' + filtered[tt+2];
    result.phrases3[p3] = (result.phrases3[p3] || 0) + 1;
  }

  result.totalWords = wordList.length;
  return result;
}

function showResults(d) {
  var passed = 0, errors = 0, warnings = 0;
  auditIssues = { errors: [], warnings: [], passed: [] };
  var html = '';

  // Basic Info
  html += '<div class="section"><div class="section-title">';
  html += '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/></svg>';
  html += t('basicInfo') + '</div>';
  html += '<div class="info-item"><span class="info-label">URL</span><span class="info-value">' + esc(d.url) + '</span></div>';
  html += '<div class="info-item"><span class="info-label">' + t('language') + '</span><span class="info-value">' + (d.lang || t('notSet')) + '</span></div>';
  html += '<div class="info-item"><span class="info-label">' + t('encoding') + '</span><span class="info-value">' + (d.charset || 'UTF-8') + '</span></div>';
  html += '</div>';

  // Page Analysis
  html += '<div class="section"><div class="section-title">';
  html += '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/><polyline points="14 2 14 8 20 8"/></svg>';
  html += t('pageAnalysis') + '</div>';

  // Title
  if (d.titleLen > 0 && d.titleLen <= 60) {
    html += auditItem('passed', t('title'), d.titleLen + ' ' + t('chars') + ' — ' + t('optimal') + ' (max 60)', d.title);
    auditIssues.passed.push({ title: t('title'), desc: d.titleLen + ' ' + t('chars') + ' — ' + t('optimal') });
    passed++;
  } else if (d.titleLen > 60) {
    html += auditItem('warning', t('title'), d.titleLen + ' ' + t('chars') + ' — ' + t('tooLong') + ' (max 60)', d.title);
    auditIssues.warnings.push({ title: t('title'), desc: d.titleLen + ' ' + t('chars') + ' — ' + t('tooLong') + ' (max 60)' });
    warnings++;
  } else {
    html += auditItem('error', t('title'), t('missing') + ' ' + t('title').toLowerCase());
    auditIssues.errors.push({ title: t('title'), desc: t('missing') + ' ' + t('title').toLowerCase() });
    errors++;
  }

  // Meta description
  if (d.metaDescLen >= 120 && d.metaDescLen <= 160) {
    html += auditItem('passed', t('metaDesc'), d.metaDescLen + ' ' + t('chars') + ' — ' + t('optimal') + ' (120-160)', d.metaDesc);
    auditIssues.passed.push({ title: t('metaDesc'), desc: d.metaDescLen + ' ' + t('chars') + ' — ' + t('optimal') });
    passed++;
  } else if (d.metaDescLen > 0 && d.metaDescLen < 120) {
    html += auditItem('warning', t('metaDesc'), d.metaDescLen + ' ' + t('chars') + ' — ' + t('tooShort') + ' (min 120)', d.metaDesc);
    auditIssues.warnings.push({ title: t('metaDesc'), desc: d.metaDescLen + ' ' + t('chars') + ' — ' + t('tooShort') + ' (min 120)' });
    warnings++;
  } else if (d.metaDescLen > 160) {
    html += auditItem('warning', t('metaDesc'), d.metaDescLen + ' ' + t('chars') + ' — ' + t('tooLong') + ' (max 160)', d.metaDesc);
    auditIssues.warnings.push({ title: t('metaDesc'), desc: d.metaDescLen + ' ' + t('chars') + ' — ' + t('tooLong') + ' (max 160)' });
    warnings++;
  } else {
    html += auditItem('error', t('metaDesc'), t('missing') + ' ' + t('metaDesc').toLowerCase());
    auditIssues.errors.push({ title: t('metaDesc'), desc: t('missing') + ' ' + t('metaDesc').toLowerCase() });
    errors++;
  }

  // Canonical
  if (d.canonical) {
    html += auditItem('passed', t('canonical'), t('set'), d.canonical);
    auditIssues.passed.push({ title: t('canonical'), desc: t('set') });
    passed++;
  } else {
    html += auditItem('warning', t('canonical'), t('missing') + ' canonical tag');
    auditIssues.warnings.push({ title: t('canonical'), desc: t('missing') + ' canonical tag' });
    warnings++;
  }

  // H1
  if (d.headings.h1.length === 1) {
    html += auditItem('passed', t('h1heading'), '1 — ' + t('correct'));
    auditIssues.passed.push({ title: t('h1heading'), desc: '1 — ' + t('correct') });
    passed++;
  } else if (d.headings.h1.length === 0) {
    html += auditItem('error', t('h1heading'), t('missing') + ' H1');
    auditIssues.errors.push({ title: t('h1heading'), desc: t('missing') + ' H1' });
    errors++;
  } else {
    html += auditItem('warning', t('h1heading'), d.headings.h1.length + ' ' + t('headings') + ' — ' + t('recommended') + ' 1');
    auditIssues.warnings.push({ title: t('h1heading'), desc: d.headings.h1.length + ' ' + t('headings') + ' — ' + t('recommended') + ' 1' });
    warnings++;
  }

  // Images
  if (d.imgTotal > 0) {
    var imgMissing = d.imgTotal - d.imgAlt;
    if (d.imgAlt === d.imgTotal) {
      html += auditItem('passed', t('images'), t('allImagesHaveAlt').replace('{0}', d.imgTotal));
      auditIssues.passed.push({ title: t('images'), desc: t('allImagesHaveAlt').replace('{0}', d.imgTotal) });
      passed++;
    } else {
      html += auditItemClickable('warning', t('images'), t('imagesWithoutAlt').replace('{0}', imgMissing).replace('{1}', d.imgTotal), d.imgWithoutAlt, 'img-list');
      auditIssues.warnings.push({ title: t('images'), desc: t('imagesWithoutAlt').replace('{0}', imgMissing).replace('{1}', d.imgTotal) });
      warnings++;
    }
  } else {
    html += auditItem('info', t('images'), t('noImagesOnPage'));
  }

  // Text/HTML ratio
  var ratio = parseFloat(d.ratio);
  if (ratio >= 25) {
    html += auditItem('passed', t('textHtmlRatio'), d.ratio + '% — ' + t('excellent') + ' (min 25%)', 'Text: ' + d.textLen + ' ' + t('chars') + ' | HTML: ' + d.htmlLen + ' ' + t('chars'));
    auditIssues.passed.push({ title: t('textHtmlRatio'), desc: d.ratio + '% — ' + t('excellent') });
    passed++;
  } else if (ratio >= 15) {
    html += auditItem('warning', t('textHtmlRatio'), d.ratio + '% — ' + t('acceptable') + ' (min 25%)', 'Text: ' + d.textLen + ' ' + t('chars') + ' | HTML: ' + d.htmlLen + ' ' + t('chars'));
    auditIssues.warnings.push({ title: t('textHtmlRatio'), desc: d.ratio + '% — ' + t('acceptable') + ' (min 25%)' });
    warnings++;
  } else {
    html += auditItem('error', t('textHtmlRatio'), d.ratio + '% — ' + t('tooLow') + ' (min 15%)', 'Text: ' + d.textLen + ' ' + t('chars') + ' | HTML: ' + d.htmlLen + ' ' + t('chars'));
    auditIssues.errors.push({ title: t('textHtmlRatio'), desc: d.ratio + '% — ' + t('tooLow') + ' (min 15%)' });
    errors++;
  }

  html += '</div>';

  // Headings
  html += '<div class="section"><div class="section-title">';
  html += '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M4 12h8"/><path d="M4 18V6"/><path d="M12 18V6"/><path d="M17 10v8"/><path d="M17 10l3-4"/><path d="M17 10l-3-4"/></svg>';
  html += t('headingsStructure') + '</div>';

  var headingTags = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
  for (var hi = 0; hi < headingTags.length; hi++) {
    var tag = headingTags[hi];
    var headings = d.headings[tag];
    if (headings.length > 0) {
      html += '<div class="heading-list">';
      for (var hj = 0; hj < headings.length; hj++) {
        html += '<div class="heading-item"><span class="heading-tag">' + tag.toUpperCase() + '</span><span class="heading-text">' + esc(headings[hj]) + '</span></div>';
      }
      html += '</div>';
    }
  }
  
  var totalHeadings = d.headings.h1.length + d.headings.h2.length + d.headings.h3.length + d.headings.h4.length + d.headings.h5.length + d.headings.h6.length;
  if (totalHeadings === 0) {
    html += '<div class="info-item"><span class="info-label">' + t('noHeadingsOnPage') + '</span></div>';
  }
  html += '</div>';

  // Technical
  html += '<div class="section"><div class="section-title">';
  html += '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="5" y="2" width="14" height="20" rx="2" ry="2"/><line x1="12" y1="18" x2="12.01" y2="18"/></svg>';
  html += t('technicalParams') + '</div>';

  if (d.viewport) {
    html += auditItem('passed', t('viewport'), t('metaViewportSet'), d.viewportContent);
    auditIssues.passed.push({ title: t('viewport'), desc: t('metaViewportSet') });
    passed++;
  } else {
    html += auditItem('error', t('viewport'), t('missingMetaViewport'));
    auditIssues.errors.push({ title: t('viewport'), desc: t('missingMetaViewport') });
    errors++;
  }

  if (d.favicon) {
    html += auditItem('passed', t('favicon'), t('faviconSet'));
    auditIssues.passed.push({ title: t('favicon'), desc: t('faviconSet') });
    passed++;
  } else {
    html += auditItem('warning', t('favicon'), t('missingFavicon'));
    auditIssues.warnings.push({ title: t('favicon'), desc: t('missingFavicon') });
    warnings++;
  }

  // Robots.txt
  if (fileChecks.robots) {
    html += auditItemLink('passed', t('robotsTxt'), t('found'), fileChecks.baseUrl + '/robots.txt');
    auditIssues.passed.push({ title: t('robotsTxt'), desc: t('found'), url: fileChecks.baseUrl + '/robots.txt' });
    passed++;
  } else {
    html += auditItem('warning', t('robotsTxt'), t('notFoundFile'));
    auditIssues.warnings.push({ title: t('robotsTxt'), desc: t('notFoundFile') });
    warnings++;
  }

  // Sitemap.xml
  if (fileChecks.sitemap) {
    html += auditItemLink('passed', t('sitemapXml'), t('found'), fileChecks.baseUrl + '/sitemap.xml');
    auditIssues.passed.push({ title: t('sitemapXml'), desc: t('found'), url: fileChecks.baseUrl + '/sitemap.xml' });
    passed++;
  } else {
    html += auditItem('warning', t('sitemapXml'), t('notFoundFile'));
    auditIssues.warnings.push({ title: t('sitemapXml'), desc: t('notFoundFile') });
    warnings++;
  }

  // LLMs.txt
  if (fileChecks.llms) {
    html += auditItemLink('passed', t('llmsTxt'), t('found') + ' (AI ready)', fileChecks.baseUrl + '/llms.txt');
    auditIssues.passed.push({ title: t('llmsTxt'), desc: t('found'), url: fileChecks.baseUrl + '/llms.txt' });
    passed++;
  } else {
    html += auditItem('info', t('llmsTxt'), t('notFoundFile') + ' (optional)');
  }

  html += '</div>';

  // Social & Schema
  html += '<div class="section"><div class="section-title">';
  html += '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"/></svg>';
  html += t('socialStructured') + '</div>';

  var ogKeys = Object.keys(d.og);
  if (ogKeys.length > 0) {
    var ogDetails = ogKeys.map(function(k) { return k + ': ' + d.og[k]; }).join('\n');
    html += auditItem('passed', t('openGraph'), ogKeys.length + ' ' + t('tagsFound'), ogDetails);
    auditIssues.passed.push({ title: t('openGraph'), desc: ogKeys.length + ' ' + t('tagsFound') });
    passed++;
  } else {
    html += auditItem('warning', t('openGraph'), t('noTags') + ' Open Graph ' + t('tagsFound').toLowerCase());
    auditIssues.warnings.push({ title: t('openGraph'), desc: t('noTags') + ' Open Graph ' + t('tagsFound').toLowerCase() });
    warnings++;
  }

  var twKeys = Object.keys(d.twitter);
  if (twKeys.length > 0) {
    var twDetails = twKeys.map(function(k) { return k + ': ' + d.twitter[k]; }).join('\n');
    html += auditItem('passed', t('twitterCard'), twKeys.length + ' ' + t('tagsFound'), twDetails);
    auditIssues.passed.push({ title: t('twitterCard'), desc: twKeys.length + ' ' + t('tagsFound') });
    passed++;
  } else {
    html += auditItem('warning', t('twitterCard'), t('noTags') + ' Twitter Card ' + t('tagsFound').toLowerCase());
    auditIssues.warnings.push({ title: t('twitterCard'), desc: t('noTags') + ' Twitter Card ' + t('tagsFound').toLowerCase() });
    warnings++;
  }

  if (d.schema.length > 0) {
    html += auditItem('passed', t('schemaOrg'), d.schema.length + ' ' + t('typesFound'), d.schema.join(', '));
    auditIssues.passed.push({ title: t('schemaOrg'), desc: d.schema.length + ' ' + t('typesFound') + ': ' + d.schema.join(', ') });
    passed++;
  } else {
    html += auditItem('warning', t('schemaOrg'), t('noStructuredData'));
    auditIssues.warnings.push({ title: t('schemaOrg'), desc: t('noStructuredData') });
    warnings++;
  }

  html += '</div>';

  // Links
  html += '<div class="section"><div class="section-title">';
  html += '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"/><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"/></svg>';
  html += t('links') + '</div>';

  html += auditItemClickable('info', t('internalLinks'), d.linksInternal.length + ' ' + t('linksCount'), d.linksInternal, 'int-links');
  html += auditItemClickable('info', t('externalLinks'), d.linksExternal.length + ' ' + t('linksCount'), d.linksExternal, 'ext-links');
  html += auditItemClickable('info', t('nofollowLinks'), d.linksNofollow.length + ' ' + t('linksCount'), d.linksNofollow, 'nof-links');

  html += '</div>';

  document.getElementById('auditResults').innerHTML = html;

  setTimeout(function() {
    var clickables = document.querySelectorAll('.clickable-item');
    for (var c = 0; c < clickables.length; c++) {
      clickables[c].onclick = function() {
        var listId = this.getAttribute('data-list');
        var list = document.getElementById(listId);
        if (list) list.classList.toggle('hidden');
      };
    }
  }, 100);

  document.getElementById('passedCount').textContent = passed;
  document.getElementById('errorsCount').textContent = errors;
  document.getElementById('warningsCount').textContent = warnings;

  document.getElementById('totalWords').textContent = d.totalWords;
  document.getElementById('uniqueWords').textContent = Object.keys(d.words).length;
  document.getElementById('textRatio').textContent = d.ratio + '%';

  var cloudHtml = generateKeywordsCloud(d.words);
  document.getElementById('keywordsCloud').innerHTML = cloudHtml;

  var topWords = sortObj(d.words).slice(0, 10);
  document.getElementById('singleKeywords').innerHTML = kwTable(topWords, d.totalWords);

  var topPhrases2 = sortObj(d.phrases2).filter(function(x) { return x[1] >= 2; }).slice(0, 10);
  document.getElementById('twoWordPhrases').innerHTML = kwTable(topPhrases2, d.totalWords);

  var topPhrases3 = sortObj(d.phrases3).filter(function(x) { return x[1] >= 2; }).slice(0, 10);
  document.getElementById('threeWordPhrases').innerHTML = kwTable(topPhrases3, d.totalWords);

  // Schema tab
  schemaData = d.schemaRaw || [];
  showSchemaResults(d);
}

function generateKeywordsCloud(words) {
  var sorted = sortObj(words);
  var top50 = sorted.slice(0, 50);
  
  if (top50.length === 0) return '<span style="color:#8b949e">' + t('noData') + '</span>';
  
  var maxCount = top50[0][1];
  var minCount = top50[top50.length - 1][1];
  var range = maxCount - minCount || 1;
  
  var html = '';
  for (var k = 0; k < top50.length; k++) {
    var word = top50[k][0];
    var count = top50[k][1];
    var size = Math.ceil(((count - minCount) / range) * 5) + 1;
    if (size > 6) size = 6;
    html += '<span class="cloud-word size-' + size + '">' + esc(word) + '</span> ';
  }
  
  return html;
}

// Schema validation rules
var schemaRules = {
  'BreadcrumbList': {
    required: ['itemListElement'],
    recommended: ['name']
  },
  'Product': {
    required: ['name'],
    recommended: ['image', 'description', 'offers', 'brand', 'sku']
  },
  'Article': {
    required: ['headline', 'author', 'datePublished'],
    recommended: ['image', 'dateModified', 'publisher']
  },
  'NewsArticle': {
    required: ['headline', 'author', 'datePublished'],
    recommended: ['image', 'dateModified', 'publisher']
  },
  'BlogPosting': {
    required: ['headline', 'author', 'datePublished'],
    recommended: ['image', 'dateModified', 'publisher']
  },
  'LocalBusiness': {
    required: ['name', 'address'],
    recommended: ['telephone', 'openingHours', 'image', 'priceRange']
  },
  'Organization': {
    required: ['name'],
    recommended: ['logo', 'url', 'contactPoint', 'sameAs']
  },
  'WebSite': {
    required: ['name', 'url'],
    recommended: ['potentialAction', 'publisher']
  },
  'WebPage': {
    required: ['name'],
    recommended: ['description', 'url', 'breadcrumb']
  },
  'FAQPage': {
    required: ['mainEntity'],
    recommended: []
  },
  'HowTo': {
    required: ['name', 'step'],
    recommended: ['image', 'totalTime', 'estimatedCost']
  },
  'Recipe': {
    required: ['name', 'recipeIngredient', 'recipeInstructions'],
    recommended: ['image', 'author', 'prepTime', 'cookTime', 'nutrition']
  },
  'Event': {
    required: ['name', 'startDate', 'location'],
    recommended: ['image', 'description', 'endDate', 'offers', 'performer']
  },
  'Person': {
    required: ['name'],
    recommended: ['image', 'jobTitle', 'worksFor', 'sameAs']
  },
  'Review': {
    required: ['itemReviewed', 'reviewRating', 'author'],
    recommended: ['reviewBody', 'datePublished']
  },
  'VideoObject': {
    required: ['name', 'description', 'thumbnailUrl', 'uploadDate'],
    recommended: ['duration', 'contentUrl', 'embedUrl']
  },
  'ImageObject': {
    required: ['contentUrl'],
    recommended: ['name', 'description', 'author']
  }
};

function validateSchema(schemaItem) {
  var type = schemaItem['@type'];
  if (Array.isArray(type)) type = type[0];
  
  var rules = schemaRules[type] || { required: [], recommended: [] };
  var result = {
    type: type,
    data: schemaItem,
    errors: [],
    warnings: [],
    valid: []
  };
  
  // Check required fields
  for (var i = 0; i < rules.required.length; i++) {
    var field = rules.required[i];
    if (schemaItem[field] !== undefined && schemaItem[field] !== null && schemaItem[field] !== '') {
      result.valid.push({ field: field, value: schemaItem[field], type: 'required' });
    } else {
      result.errors.push({ field: field, type: 'required' });
    }
  }
  
  // Check recommended fields
  for (var j = 0; j < rules.recommended.length; j++) {
    var recField = rules.recommended[j];
    if (schemaItem[recField] !== undefined && schemaItem[recField] !== null && schemaItem[recField] !== '') {
      result.valid.push({ field: recField, value: schemaItem[recField], type: 'recommended' });
    } else {
      result.warnings.push({ field: recField, type: 'recommended' });
    }
  }
  
  return result;
}

function showSchemaResults(d) {
  var schemaItems = d.schemaRaw || [];
  var totalValid = 0;
  var totalErrors = 0;
  var html = '';
  
  // Set Google test link
  var googleLink = document.getElementById('googleTestLink');
  if (googleLink && d.url) {
    googleLink.href = 'https://search.google.com/test/rich-results?url=' + encodeURIComponent(d.url);
  }
  
  if (schemaItems.length === 0) {
    html = '<div class="audit-item"><div class="status-icon warning">' + alertIcon + '</div>';
    html += '<div class="audit-content"><div class="audit-title">' + t('noSchemaFound') + '</div></div></div>';
    document.getElementById('schemaResults').innerHTML = html;
    document.getElementById('schemaCount').textContent = '0';
    document.getElementById('schemaValid').textContent = '0';
    document.getElementById('schemaErrors').textContent = '0';
    return;
  }
  
  // Group by type and validate
  var processedTypes = {};
  var validatedItems = [];
  
  for (var i = 0; i < schemaItems.length; i++) {
    var item = schemaItems[i];
    var type = item['@type'];
    if (Array.isArray(type)) type = type[0];
    
    // Skip duplicates of same type (keep first)
    if (processedTypes[type]) continue;
    processedTypes[type] = true;
    
    var validation = validateSchema(item);
    validatedItems.push(validation);
    
    if (validation.errors.length === 0) {
      totalValid++;
    } else {
      totalErrors++;
    }
  }
  
  // Render results
  for (var v = 0; v < validatedItems.length; v++) {
    var val = validatedItems[v];
    var statusClass = val.errors.length === 0 ? 'valid' : 'invalid';
    var statusText = val.errors.length === 0 ? '✓ OK' : '✕ ' + val.errors.length + ' ' + t('errorsFound').toLowerCase();
    
    html += '<div class="schema-item">';
    html += '<div class="schema-item-header" data-schema-idx="' + v + '">';
    html += '<span class="schema-type">' + esc(val.type) + '</span>';
    html += '<span class="schema-status ' + statusClass + '">' + statusText + '</span>';
    html += '</div>';
    html += '<div class="schema-fields hidden" id="schema-fields-' + v + '">';
    
    // Show errors first
    for (var e = 0; e < val.errors.length; e++) {
      html += '<div class="schema-field">';
      html += '<span class="field-status err">✕</span>';
      html += '<span class="field-name">' + esc(val.errors[e].field) + '</span>';
      html += '<span class="field-value missing">' + t('fieldMissing') + ' (' + t('required') + ')</span>';
      html += '</div>';
    }
    
    // Show warnings
    for (var w = 0; w < val.warnings.length; w++) {
      html += '<div class="schema-field">';
      html += '<span class="field-status warn">!</span>';
      html += '<span class="field-name">' + esc(val.warnings[w].field) + '</span>';
      html += '<span class="field-value missing">' + t('fieldMissing') + ' (' + t('recommended') + ')</span>';
      html += '</div>';
    }
    
    // Show valid fields
    for (var vf = 0; vf < val.valid.length; vf++) {
      var fieldVal = val.valid[vf].value;
      var displayVal = '';
      
      if (typeof fieldVal === 'object') {
        displayVal = JSON.stringify(fieldVal).substring(0, 100);
        if (JSON.stringify(fieldVal).length > 100) displayVal += '...';
      } else {
        displayVal = String(fieldVal).substring(0, 100);
        if (String(fieldVal).length > 100) displayVal += '...';
      }
      
      html += '<div class="schema-field">';
      html += '<span class="field-status ok">✓</span>';
      html += '<span class="field-name">' + esc(val.valid[vf].field) + '</span>';
      html += '<span class="field-value">' + esc(displayVal) + '</span>';
      html += '</div>';
    }
    
    html += '</div></div>';
  }
  
  document.getElementById('schemaResults').innerHTML = html;
  document.getElementById('schemaCount').textContent = validatedItems.length;
  document.getElementById('schemaValid').textContent = totalValid;
  document.getElementById('schemaErrors').textContent = totalErrors;
  
  // Add click handlers for expandable items
  setTimeout(function() {
    var headers = document.querySelectorAll('.schema-item-header');
    for (var h = 0; h < headers.length; h++) {
      headers[h].onclick = function() {
        var idx = this.getAttribute('data-schema-idx');
        var fields = document.getElementById('schema-fields-' + idx);
        if (fields) fields.classList.toggle('hidden');
      };
    }
  }, 100);
}

function auditItem(status, title, desc, value) {
  var icon = status === 'passed' ? checkIcon : status === 'error' ? xIcon : status === 'warning' ? alertIcon : infoIcon;
  var statusClass = status === 'error' ? 'error' : status;
  
  var html = '<div class="audit-item" data-status="' + statusClass + '">';
  html += '<div class="status-icon ' + statusClass + '">' + icon + '</div>';
  html += '<div class="audit-content">';
  html += '<div class="audit-title">' + esc(title) + '</div>';
  html += '<div class="audit-desc">' + esc(desc) + '</div>';
  if (value) html += '<div class="audit-value">' + esc(value) + '</div>';
  html += '</div></div>';
  return html;
}

function auditItemLink(status, title, desc, url) {
  var icon = status === 'passed' ? checkIcon : status === 'error' ? xIcon : status === 'warning' ? alertIcon : infoIcon;
  var statusClass = status === 'error' ? 'error' : status;
  
  var html = '<div class="audit-item" data-status="' + statusClass + '">';
  html += '<div class="status-icon ' + statusClass + '">' + icon + '</div>';
  html += '<div class="audit-content">';
  html += '<div class="audit-title">' + esc(title) + '</div>';
  html += '<div class="audit-desc">' + esc(desc) + ' — <a href="' + esc(url) + '" target="_blank" style="color:#00E676;">' + t('open') + ' ↗</a></div>';
  html += '</div></div>';
  return html;
}

function auditItemClickable(status, title, desc, urls, listId) {
  var icon = status === 'passed' ? checkIcon : status === 'error' ? xIcon : status === 'warning' ? alertIcon : infoIcon;
  var statusClass = status === 'error' ? 'error' : status;
  
  var html = '<div class="audit-item clickable-item" data-status="' + statusClass + '" data-list="' + listId + '">';
  html += '<div class="status-icon ' + statusClass + '">' + icon + '</div>';
  html += '<div class="audit-content">';
  html += '<div class="audit-title">' + esc(title) + '</div>';
  html += '<div class="audit-desc">' + esc(desc) + ' — ' + t('clickToShow') + '</div>';
  
  if (urls && urls.length > 0) {
    html += '<div class="url-list hidden" id="' + listId + '">';
    for (var i = 0; i < urls.length; i++) {
      html += '<a href="' + esc(urls[i]) + '" target="_blank">' + esc(urls[i]) + '</a>';
    }
    html += '</div>';
  }
  
  html += '</div></div>';
  return html;
}

function kwTable(items, total) {
  if (items.length === 0) {
    return '<div class="kw-row"><span class="kw-word" style="color:#8b949e">' + t('noData') + '</span></div>';
  }
  
  var html = '<div class="kw-row header"><span class="kw-word">' + t('keyword') + '</span><span class="kw-count">' + t('count') + '</span><span class="kw-density">' + t('density') + '</span></div>';
  for (var i = 0; i < items.length; i++) {
    var w = items[i][0];
    var c = items[i][1];
    var p = ((c / total) * 100).toFixed(2);
    html += '<div class="kw-row"><span class="kw-word">' + esc(w) + '</span><span class="kw-count">' + c + '</span><span class="kw-density">' + p + '%</span></div>';
  }
  return html;
}

function sortObj(obj) {
  return Object.keys(obj).map(function(k) { return [k, obj[k]]; }).sort(function(a, b) { return b[1] - a[1]; });
}

function esc(s) {
  if (!s) return '';
  var d = document.createElement('div');
  d.textContent = s;
  return d.innerHTML;
}

function exportReport() {
  if (!auditData) {
    alert(t('analyzeFirst'));
    return;
  }

  var company = document.getElementById('companyName').value || 'https://webstudio.ltd';
  var phone = document.getElementById('companyPhone').value || '+421 950 216 916';
  var email = document.getElementById('companyEmail').value || 'info@webstudio.ltd';

  var passed = document.getElementById('passedCount').textContent;
  var errors = document.getElementById('errorsCount').textContent;
  var warnings = document.getElementById('warningsCount').textContent;

  var d = auditData;

  var html = '<!DOCTYPE html><html><head><meta charset="UTF-8"><title>SEO Audit Report - ' + esc(company) + '</title>';
  html += '<style>*{margin:0;padding:0;box-sizing:border-box}body{font-family:system-ui,sans-serif;background:#0d1117;color:#e6edf3;padding:30px;max-width:900px;margin:0 auto}';
  html += '.header{background:linear-gradient(135deg,#00E676,#00c853);color:#000;padding:30px;border-radius:12px;margin-bottom:30px}';
  html += 'h1{font-size:28px;margin-bottom:8px}h2{color:#00E676;font-size:18px;margin:30px 0 15px;padding-bottom:10px;border-bottom:2px solid #30363d}';
  html += '.meta{font-size:14px;opacity:0.8}';
  html += '.scores{display:flex;gap:20px;margin-bottom:30px}.score{flex:1;background:#161b22;padding:25px;border-radius:10px;text-align:center;border:1px solid #30363d}';
  html += '.score-val{font-size:42px;font-weight:700}.passed .score-val{color:#00E676}.errors .score-val{color:#f85149}.warnings .score-val{color:#d29922}';
  html += '.score-label{font-size:12px;color:#8b949e;text-transform:uppercase;margin-top:5px}';
  html += '.item{background:#161b22;padding:15px 20px;border-radius:8px;margin-bottom:10px;border:1px solid #30363d}';
  html += '.item-row{display:flex;justify-content:space-between;align-items:flex-start}';
  html += '.label{color:#8b949e;font-size:13px}.value{color:#e6edf3;font-size:13px;text-align:right;max-width:60%;word-break:break-word}';
  html += '.full-value{color:#e6edf3;font-size:12px;margin-top:8px;padding:10px;background:#0d1117;border-radius:6px;word-break:break-word}';
  html += '.heading-tag{display:inline-block;background:#00E676;color:#000;padding:3px 8px;border-radius:4px;font-size:11px;font-weight:600;margin-right:10px;vertical-align:top;flex-shrink:0}';
  html += '.heading-item{display:flex;align-items:flex-start;padding:10px 0;border-bottom:1px solid #21262d}.heading-item:last-child{border:none}.heading-text{flex:1}';
  html += 'table{width:100%;border-collapse:collapse;background:#161b22;border-radius:10px;overflow:hidden;margin-bottom:20px}';
  html += 'th,td{padding:12px 15px;text-align:left;border-bottom:1px solid #30363d}th{background:#21262d;font-size:12px;color:#8b949e;text-transform:uppercase}';
  html += 'td{font-size:13px}';
  html += '.status{display:inline-block;padding:4px 10px;border-radius:20px;font-size:11px;font-weight:600}';
  html += '.status.ok{background:rgba(0,230,118,0.15);color:#00E676}';
  html += '.status.warn{background:rgba(210,153,34,0.15);color:#d29922}';
  html += '.status.err{background:rgba(248,81,73,0.15);color:#f85149}';
  html += '.status.ok{background:rgba(0,230,118,0.15);color:#00E676}';
  html += '.status.warn{background:rgba(210,153,34,0.15);color:#d29922}';
  html += '.status.err{background:rgba(248,81,73,0.15);color:#f85149}';
  html += '.cloud{background:#161b22;border:1px solid #30363d;padding:20px;border-radius:10px;margin-bottom:20px;line-height:1.4;text-align:center}';
  html += '.cloud span{color:#00E676;margin:2px 4px;display:inline-block}';
  html += '.cloud .s1{font-size:11px;opacity:0.5}.cloud .s2{font-size:13px;opacity:0.6}.cloud .s3{font-size:15px;opacity:0.7}';
  html += '.cloud .s4{font-size:18px;opacity:0.8}.cloud .s5{font-size:22px;opacity:0.9;font-weight:500}.cloud .s6{font-size:26px;font-weight:700}';
  html += '.issue-list{margin-bottom:20px}.issue-item{display:flex;align-items:center;gap:10px;padding:10px 15px;background:#161b22;border-radius:6px;margin-bottom:6px;border:1px solid #30363d}';
  html += '.issue-icon{width:24px;height:24px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-weight:bold;font-size:14px}';
  html += '.issue-icon.err{background:rgba(248,81,73,0.15);color:#f85149}.issue-icon.warn{background:rgba(210,153,34,0.15);color:#d29922}';
  html += '.issue-text{flex:1}.issue-title{font-weight:600;font-size:13px}.issue-desc{font-size:12px;color:#8b949e;margin-top:2px}';
  html += '.link-list{max-height:300px;overflow-y:auto}.link-list a{display:block;color:#58a6ff;font-size:12px;padding:6px 0;text-decoration:none;word-break:break-all;border-bottom:1px solid #21262d}.link-list a:last-child{border:none}.link-list a:hover{color:#00E676}';
  html += '.footer{text-align:center;color:#6e7681;margin-top:40px;padding-top:20px;border-top:1px solid #30363d;font-size:13px}</style></head><body>';

  html += '<div class="header"><h1>' + esc(company) + '</h1><p class="meta">SEO Audit Report</p></div>';

  html += '<div class="item"><div class="item-row"><span class="label">' + t('analyzedUrl') + '</span><span class="value">' + esc(d.url) + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('analysisDate') + '</span><span class="value">' + new Date().toLocaleString() + '</span></div></div>';

  html += '<div class="scores">';
  html += '<div class="score passed"><div class="score-val">' + passed + '</div><div class="score-label">' + t('passed') + '</div></div>';
  html += '<div class="score errors"><div class="score-val">' + errors + '</div><div class="score-label">' + t('errors') + '</div></div>';
  html += '<div class="score warnings"><div class="score-val">' + warnings + '</div><div class="score-label">' + t('warnings') + '</div></div>';
  html += '</div>';

  // ERRORS
  if (auditIssues.errors.length > 0) {
    html += '<h2>🔴 ' + t('errors') + ' (' + auditIssues.errors.length + ')</h2>';
    html += '<div class="issue-list">';
    for (var ei = 0; ei < auditIssues.errors.length; ei++) {
      html += '<div class="issue-item"><div class="issue-icon err">✕</div><div class="issue-text"><div class="issue-title">' + esc(auditIssues.errors[ei].title) + '</div><div class="issue-desc">' + esc(auditIssues.errors[ei].desc) + '</div></div></div>';
    }
    html += '</div>';
  }

  // WARNINGS
  if (auditIssues.warnings.length > 0) {
    html += '<h2>🟡 ' + t('warnings') + ' (' + auditIssues.warnings.length + ')</h2>';
    html += '<div class="issue-list">';
    for (var wi = 0; wi < auditIssues.warnings.length; wi++) {
      html += '<div class="issue-item"><div class="issue-icon warn">!</div><div class="issue-text"><div class="issue-title">' + esc(auditIssues.warnings[wi].title) + '</div><div class="issue-desc">' + esc(auditIssues.warnings[wi].desc) + '</div></div></div>';
    }
    html += '</div>';
  }

  // Basic info
  html += '<h2>' + t('basicInfo') + '</h2>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('title') + '</span><span class="value">' + d.titleLen + ' ' + t('chars') + '</span></div><div class="full-value">' + esc(d.title) + '</div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('metaDesc') + '</span><span class="value">' + d.metaDescLen + ' ' + t('chars') + '</span></div><div class="full-value">' + esc(d.metaDesc || t('missing')) + '</div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('language') + '</span><span class="value">' + (d.lang || t('notSet')) + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('canonical') + '</span><span class="value">' + (d.canonical ? '<span class="status ok">OK</span>' : '<span class="status warn">' + t('missing') + '</span>') + '</span></div></div>';

  // Headings
  html += '<h2>' + t('headingsStructure') + '</h2>';
  var headingTags = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
  for (var hi = 0; hi < headingTags.length; hi++) {
    var tag = headingTags[hi];
    if (d.headings[tag].length > 0) {
      html += '<div class="item">';
      for (var hj = 0; hj < d.headings[tag].length; hj++) {
        html += '<div class="heading-item"><span class="heading-tag">' + tag.toUpperCase() + '</span><span class="heading-text">' + esc(d.headings[tag][hj]) + '</span></div>';
      }
      html += '</div>';
    }
  }

  // Technical
  html += '<h2>' + t('technicalParams') + '</h2>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('textHtmlRatio') + '</span><span class="value">' + d.ratio + '%</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('viewport') + '</span><span class="value">' + (d.viewport ? '<span class="status ok">OK</span>' : '<span class="status err">' + t('missing') + '</span>') + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('favicon') + '</span><span class="value">' + (d.favicon ? '<span class="status ok">OK</span>' : '<span class="status warn">' + t('missing') + '</span>') + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('openGraph') + '</span><span class="value">' + Object.keys(d.og).length + ' ' + t('tagsFound').toLowerCase() + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('schemaOrg') + '</span><span class="value">' + (d.schema.length > 0 ? d.schema.join(', ') : t('notFound')) + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('robotsTxt') + '</span><span class="value">' + (fileChecks.robots ? '<span class="status ok"><a href="' + fileChecks.baseUrl + '/robots.txt" target="_blank" style="color:#00E676;text-decoration:none;">' + t('found') + ' ↗</a></span>' : '<span class="status warn">' + t('notFoundFile') + '</span>') + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('sitemapXml') + '</span><span class="value">' + (fileChecks.sitemap ? '<span class="status ok"><a href="' + fileChecks.baseUrl + '/sitemap.xml" target="_blank" style="color:#00E676;text-decoration:none;">' + t('found') + ' ↗</a></span>' : '<span class="status warn">' + t('notFoundFile') + '</span>') + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('llmsTxt') + '</span><span class="value">' + (fileChecks.llms ? '<span class="status ok"><a href="' + fileChecks.baseUrl + '/llms.txt" target="_blank" style="color:#00E676;text-decoration:none;">' + t('found') + ' ↗</a></span>' : '<span class="status warn">' + t('notFoundFile') + '</span>') + '</span></div></div>';

  // Links
  html += '<h2>' + t('links') + '</h2>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('internalLinks') + '</span><span class="value">' + d.linksInternal.length + '</span></div></div>';
  if (d.linksInternal.length > 0) {
    html += '<div class="item"><div class="link-list">';
    for (var li = 0; li < d.linksInternal.length; li++) {
      html += '<a href="' + esc(d.linksInternal[li]) + '" target="_blank">' + esc(d.linksInternal[li]) + '</a>';
    }
    html += '</div></div>';
  }
  
  html += '<div class="item"><div class="item-row"><span class="label">' + t('externalLinks') + '</span><span class="value">' + d.linksExternal.length + '</span></div></div>';
  if (d.linksExternal.length > 0) {
    html += '<div class="item"><div class="link-list">';
    for (var le = 0; le < d.linksExternal.length; le++) {
      html += '<a href="' + esc(d.linksExternal[le]) + '" target="_blank">' + esc(d.linksExternal[le]) + '</a>';
    }
    html += '</div></div>';
  }
  
  html += '<div class="item"><div class="item-row"><span class="label">' + t('nofollowLinks') + '</span><span class="value">' + d.linksNofollow.length + '</span></div></div>';
  if (d.linksNofollow.length > 0) {
    html += '<div class="item"><div class="link-list">';
    for (var ln = 0; ln < d.linksNofollow.length; ln++) {
      html += '<a href="' + esc(d.linksNofollow[ln]) + '" target="_blank">' + esc(d.linksNofollow[ln]) + '</a>';
    }
    html += '</div></div>';
  }

  // Images without ALT
  if (d.imgWithoutAlt && d.imgWithoutAlt.length > 0) {
    html += '<h2>' + t('images') + ' — ' + t('imagesWithoutAlt').replace('{0}', d.imgWithoutAlt.length).replace('{1}', d.imgTotal) + '</h2>';
    html += '<div class="item"><div class="link-list">';
    for (var im = 0; im < d.imgWithoutAlt.length; im++) {
      html += '<a href="' + esc(d.imgWithoutAlt[im]) + '" target="_blank">' + esc(d.imgWithoutAlt[im]) + '</a>';
    }
    html += '</div></div>';
  }

  // Keywords Cloud
  html += '<h2>' + t('keywordsCloud') + '</h2>';
  var sorted = sortObj(d.words);
  var top50 = sorted.slice(0, 50);
  if (top50.length > 0) {
    var maxCount = top50[0][1];
    var minCount = top50[top50.length - 1][1];
    var range = maxCount - minCount || 1;
    
    html += '<div class="cloud">';
    for (var kk = 0; kk < top50.length; kk++) {
      var word = top50[kk][0];
      var count = top50[kk][1];
      var size = Math.ceil(((count - minCount) / range) * 5) + 1;
      if (size > 6) size = 6;
      html += '<span class="s' + size + '">' + esc(word) + '</span> ';
    }
    html += '</div>';
  }

  // Schema.org Validation
  html += '<h2>' + t('schemaValidation') + '</h2>';
  var schemaItems = d.schemaRaw || [];
  if (schemaItems.length === 0) {
    html += '<div class="item"><span class="label">' + t('noSchemaFound') + '</span></div>';
  } else {
    var processedTypesExport = {};
    for (var si = 0; si < schemaItems.length; si++) {
      var schemaItem = schemaItems[si];
      var schemaType = schemaItem['@type'];
      if (Array.isArray(schemaType)) schemaType = schemaType[0];
      
      if (processedTypesExport[schemaType]) continue;
      processedTypesExport[schemaType] = true;
      
      var validation = validateSchema(schemaItem);
      var schemaStatusClass = validation.errors.length === 0 ? 'ok' : 'err';
      var schemaStatusText = validation.errors.length === 0 ? '✓ OK' : '✕ ' + validation.errors.length + ' ' + t('errorsFound').toLowerCase();
      
      html += '<div class="item">';
      html += '<div class="item-row"><span class="label" style="font-weight:600;color:#00E676;">' + esc(schemaType) + '</span><span class="status ' + schemaStatusClass + '">' + schemaStatusText + '</span></div>';
      
      // Errors
      for (var se = 0; se < validation.errors.length; se++) {
        html += '<div class="item-row" style="padding:4px 0;"><span class="label" style="color:#f85149;">✕ ' + esc(validation.errors[se].field) + '</span><span class="value" style="color:#f85149;">' + t('fieldMissing') + ' (' + t('required') + ')</span></div>';
      }
      
      // Warnings
      for (var sw = 0; sw < validation.warnings.length; sw++) {
        html += '<div class="item-row" style="padding:4px 0;"><span class="label" style="color:#d29922;">! ' + esc(validation.warnings[sw].field) + '</span><span class="value" style="color:#d29922;">' + t('fieldMissing') + ' (' + t('recommended') + ')</span></div>';
      }
      
      // Valid fields
      for (var sv = 0; sv < validation.valid.length; sv++) {
        var fieldValue = validation.valid[sv].value;
        var displayValue = '';
        if (typeof fieldValue === 'object') {
          displayValue = JSON.stringify(fieldValue).substring(0, 80);
          if (JSON.stringify(fieldValue).length > 80) displayValue += '...';
        } else {
          displayValue = String(fieldValue).substring(0, 80);
          if (String(fieldValue).length > 80) displayValue += '...';
        }
        html += '<div class="item-row" style="padding:4px 0;"><span class="label" style="color:#00E676;">✓ ' + esc(validation.valid[sv].field) + '</span><span class="value">' + esc(displayValue) + '</span></div>';
      }
      
      html += '</div>';
    }
  }

  // Keywords table
  html += '<h2>' + t('topKeywords') + '</h2>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('totalWords') + '</span><span class="value">' + d.totalWords + '</span></div></div>';
  html += '<div class="item"><div class="item-row"><span class="label">' + t('uniqueWords') + '</span><span class="value">' + Object.keys(d.words).length + '</span></div></div>';

  var topW = sortObj(d.words).slice(0, 10);
  html += '<table><tr><th>' + t('keyword') + '</th><th>' + t('count') + '</th><th>' + t('density') + '</th></tr>';
  for (var wi2 = 0; wi2 < topW.length; wi2++) {
    var pct = ((topW[wi2][1] / d.totalWords) * 100).toFixed(2);
    html += '<tr><td>' + esc(topW[wi2][0]) + '</td><td>' + topW[wi2][1] + '</td><td>' + pct + '%</td></tr>';
  }
  html += '</table>';

  // Two-word phrases
  html += '<h2>' + t('twoWordPhrases') + '</h2>';
  var topP2 = sortObj(d.phrases2).filter(function(x) { return x[1] >= 2; }).slice(0, 10);
  if (topP2.length > 0) {
    html += '<table><tr><th>' + t('keyword') + '</th><th>' + t('count') + '</th><th>' + t('density') + '</th></tr>';
    for (var p2i = 0; p2i < topP2.length; p2i++) {
      var pct2 = ((topP2[p2i][1] / d.totalWords) * 100).toFixed(2);
      html += '<tr><td>' + esc(topP2[p2i][0]) + '</td><td>' + topP2[p2i][1] + '</td><td>' + pct2 + '%</td></tr>';
    }
    html += '</table>';
  } else {
    html += '<div class="item"><span class="label">' + t('noPhrasesWithFreq') + '</span></div>';
  }

  // Three-word phrases
  html += '<h2>' + t('threeWordPhrases') + '</h2>';
  var topP3 = sortObj(d.phrases3).filter(function(x) { return x[1] >= 2; }).slice(0, 10);
  if (topP3.length > 0) {
    html += '<table><tr><th>' + t('keyword') + '</th><th>' + t('count') + '</th><th>' + t('density') + '</th></tr>';
    for (var p3i = 0; p3i < topP3.length; p3i++) {
      var pct3 = ((topP3[p3i][1] / d.totalWords) * 100).toFixed(2);
      html += '<tr><td>' + esc(topP3[p3i][0]) + '</td><td>' + topP3[p3i][1] + '</td><td>' + pct3 + '%</td></tr>';
    }
    html += '</table>';
  } else {
    html += '<div class="item"><span class="label">' + t('noPhrasesWithFreq') + '</span></div>';
  }

  html += '<div class="footer">' + esc(company) + ' | ' + esc(phone) + ' | ' + esc(email) + '</div>';
  html += '</body></html>';

  var blob = new Blob([html], {type: 'text/html;charset=utf-8'});
  var url = URL.createObjectURL(blob);
  var a = document.createElement('a');
  a.href = url;
  
  var hostname = 'audit';
  try { hostname = new URL(d.url).hostname; } catch(e) {}
  a.download = 'seo-audit-' + hostname + '-' + new Date().toISOString().split('T')[0] + '.html';
  
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
  URL.revokeObjectURL(url);
}
