# SEO Audit by webstudio.ltd - Chrome Extension

Profesionálne rozšírenie pre SEO audit s exportom do PDF/HTML (white label).

## Funkcie

### 📊 Kompletný SEO Audit
- **Analýza URL** - dĺžka, štruktúra
- **Titulok stránky** - dĺžka, optimalizácia
- **Meta popis** - dĺžka, obsah
- **Canonical tag** - kontrola nastavenia
- **Nadpisy (H1-H6)** - štruktúra a počet
- **Obrázky** - ALT atribúty
- **Text/HTML pomer** - analýza obsahu
- **Interné/Externé odkazy** - počet a nofollow

### 📱 Mobilná kompatibilita
- Viewport meta tag
- Responzívnosť

### 🔧 Technická zhoda
- Jazyk stránky
- Doctype
- Kódovanie (UTF-8)
- Favicon

### 📣 Sociálne siete & Štruktúrované dáta
- Open Graph tagy
- Twitter Card
- Schema.org (JSON-LD)

### 🔍 Analýza kľúčových slov
- Celkový počet slov
- Hustota jednotlivých slov
- Dvojslovné frázy
- Trojslovné frázy

### 📄 Export do PDF (White Label)
- Vlastné logo spoločnosti
- Názov spoločnosti
- Webová stránka
- Email
- Profesionálny report

## Inštalácia

### Manuálna inštalácia (vývojársky režim)

1. Stiahnite a rozbaľte archív rozšírenia
2. Otvorte Chrome a prejdite na `chrome://extensions/`
3. Zapnite "Režim pre vývojárov" (Developer mode) v pravom hornom rohu
4. Kliknite na "Načítať rozbalené" (Load unpacked)
5. Vyberte priečinok `seo-audit-extension`
6. Rozšírenie je nainštalované!

## Použitie

1. Prejdite na stránku, ktorú chcete analyzovať
2. Kliknite na ikonu rozšírenia v paneli prehliadača
3. Kliknite na tlačidlo "Analyzovať"
4. Prezrite si výsledky v jednotlivých záložkách:
   - **Audit** - kompletná SEO analýza
   - **Kľúčové slová** - hustota slov a fráz
   - **Export** - export do PDF

### Nastavenie White Label

1. Kliknite na ikonu ozubeného kolieska (⚙️) v hlavičke
2. Vyplňte údaje o vašej spoločnosti:
   - Názov spoločnosti
   - URL logo (voliteľné)
   - Webová stránka
   - Email
3. Uložte nastavenia

### Export PDF

1. Prejdite na záložku "Export"
2. Upravte údaje o spoločnosti (ak je potrebné)
3. Vyberte sekcie, ktoré chcete exportovať
4. Kliknite na "Exportovať PDF"

## Technické požiadavky

- Google Chrome verzia 88+
- Microsoft Edge (Chromium) verzia 88+
- Brave Browser

## Štruktúra súborov

```
seo-audit-extension/
├── manifest.json      # Konfigurácia rozšírenia
├── popup.html         # Hlavné UI
├── popup.js           # Logika aplikácie
├── styles.css         # Štýly (dark téma)
├── content.js         # Content script
├── background.js      # Service worker
├── icons/
│   ├── icon16.png
│   ├── icon48.png
│   └── icon128.png
└── README.md
```

## Licencia

Toto rozšírenie je vytvorené pre osobné a komerčné použitie.

## Podpora

Pre otázky a návrhy na vylepšenie vytvorte issue alebo kontaktujte autora.

---

Vytvorené s ❤️ pre SEO špecialistov
